/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Response message for listing findings.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.ListFindingsResponse}
 */
public final class ListFindingsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.ListFindingsResponse)
    ListFindingsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListFindingsResponse.newBuilder() to construct.
  private ListFindingsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListFindingsResponse() {
    listFindingsResults_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListFindingsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ListFindingsResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                listFindingsResults_ =
                    new java.util.ArrayList<
                        com.google.cloud.securitycenter.v1.ListFindingsResponse
                            .ListFindingsResult>();
                mutable_bitField0_ |= 0x00000001;
              }
              listFindingsResults_.add(
                  input.readMessage(
                      com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                          .parser(),
                      extensionRegistry));
              break;
            }
          case 18:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (readTime_ != null) {
                subBuilder = readTime_.toBuilder();
              }
              readTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(readTime_);
                readTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              nextPageToken_ = s;
              break;
            }
          case 32:
            {
              totalSize_ = input.readInt32();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        listFindingsResults_ = java.util.Collections.unmodifiableList(listFindingsResults_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.ListFindingsResponse.class,
            com.google.cloud.securitycenter.v1.ListFindingsResponse.Builder.class);
  }

  public interface ListFindingsResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Finding matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     *
     * @return Whether the finding field is set.
     */
    boolean hasFinding();
    /**
     *
     *
     * <pre>
     * Finding matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     *
     * @return The finding.
     */
    com.google.cloud.securitycenter.v1.Finding getFinding();
    /**
     *
     *
     * <pre>
     * Finding matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     */
    com.google.cloud.securitycenter.v1.FindingOrBuilder getFindingOrBuilder();

    /**
     *
     *
     * <pre>
     * State change of the finding between the points in time.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange state_change = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for stateChange.
     */
    int getStateChangeValue();
    /**
     *
     *
     * <pre>
     * State change of the finding between the points in time.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange state_change = 2;
     * </code>
     *
     * @return The stateChange.
     */
    com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
        getStateChange();

    /**
     *
     *
     * <pre>
     * Output only. Resource that is associated with this finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
     * </code>
     *
     * @return Whether the resource field is set.
     */
    boolean hasResource();
    /**
     *
     *
     * <pre>
     * Output only. Resource that is associated with this finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
     * </code>
     *
     * @return The resource.
     */
    com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
        getResource();
    /**
     *
     *
     * <pre>
     * Output only. Resource that is associated with this finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
     * </code>
     */
    com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.ResourceOrBuilder
        getResourceOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Result containing the Finding and its StateChange.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult}
   */
  public static final class ListFindingsResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult)
      ListFindingsResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListFindingsResult.newBuilder() to construct.
    private ListFindingsResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListFindingsResult() {
      stateChange_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListFindingsResult();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ListFindingsResult(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.securitycenter.v1.Finding.Builder subBuilder = null;
                if (finding_ != null) {
                  subBuilder = finding_.toBuilder();
                }
                finding_ =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Finding.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(finding_);
                  finding_ = subBuilder.buildPartial();
                }

                break;
              }
            case 16:
              {
                int rawValue = input.readEnum();

                stateChange_ = rawValue;
                break;
              }
            case 26:
              {
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                        .Builder
                    subBuilder = null;
                if (resource_ != null) {
                  subBuilder = resource_.toBuilder();
                }
                resource_ =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                            .Resource.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(resource_);
                  resource_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.class,
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * The change in state of the finding.
     * When querying across two points in time this describes
     * the change in the finding between the two points: CHANGED, UNCHANGED,
     * ADDED, or REMOVED. Findings can not be deleted, so REMOVED implies that
     * the finding at timestamp does not match the filter specified, but it did
     * at timestamp - compare_duration. If there was no compare_duration
     * supplied in the request the state change will be: UNUSED
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange}
     */
    public enum StateChange implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * State change is unused, this is the canonical default for this enum.
       * </pre>
       *
       * <code>UNUSED = 0;</code>
       */
      UNUSED(0),
      /**
       *
       *
       * <pre>
       * The finding has changed state in some way between the points in time
       * and existed at both points.
       * </pre>
       *
       * <code>CHANGED = 1;</code>
       */
      CHANGED(1),
      /**
       *
       *
       * <pre>
       * The finding has not changed state between the points in time and
       * existed at both points.
       * </pre>
       *
       * <code>UNCHANGED = 2;</code>
       */
      UNCHANGED(2),
      /**
       *
       *
       * <pre>
       * The finding was created between the points in time.
       * </pre>
       *
       * <code>ADDED = 3;</code>
       */
      ADDED(3),
      /**
       *
       *
       * <pre>
       * The finding at timestamp does not match the filter specified, but it
       * did at timestamp - compare_duration.
       * </pre>
       *
       * <code>REMOVED = 4;</code>
       */
      REMOVED(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * State change is unused, this is the canonical default for this enum.
       * </pre>
       *
       * <code>UNUSED = 0;</code>
       */
      public static final int UNUSED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The finding has changed state in some way between the points in time
       * and existed at both points.
       * </pre>
       *
       * <code>CHANGED = 1;</code>
       */
      public static final int CHANGED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The finding has not changed state between the points in time and
       * existed at both points.
       * </pre>
       *
       * <code>UNCHANGED = 2;</code>
       */
      public static final int UNCHANGED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The finding was created between the points in time.
       * </pre>
       *
       * <code>ADDED = 3;</code>
       */
      public static final int ADDED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The finding at timestamp does not match the filter specified, but it
       * did at timestamp - compare_duration.
       * </pre>
       *
       * <code>REMOVED = 4;</code>
       */
      public static final int REMOVED_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static StateChange valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static StateChange forNumber(int value) {
        switch (value) {
          case 0:
            return UNUSED;
          case 1:
            return CHANGED;
          case 2:
            return UNCHANGED;
          case 3:
            return ADDED;
          case 4:
            return REMOVED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<StateChange> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<StateChange> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<StateChange>() {
            public StateChange findValueByNumber(int number) {
              return StateChange.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final StateChange[] VALUES = values();

      public static StateChange valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private StateChange(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange)
    }

    public interface ResourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The full resource name of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * The full resource name of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      /**
       *
       *
       * <pre>
       * The full resource name of project that the resource belongs to.
       * </pre>
       *
       * <code>string project_name = 2;</code>
       *
       * @return The projectName.
       */
      java.lang.String getProjectName();
      /**
       *
       *
       * <pre>
       * The full resource name of project that the resource belongs to.
       * </pre>
       *
       * <code>string project_name = 2;</code>
       *
       * @return The bytes for projectName.
       */
      com.google.protobuf.ByteString getProjectNameBytes();

      /**
       *
       *
       * <pre>
       * The human readable name of project that the resource belongs to.
       * </pre>
       *
       * <code>string project_display_name = 3;</code>
       *
       * @return The projectDisplayName.
       */
      java.lang.String getProjectDisplayName();
      /**
       *
       *
       * <pre>
       * The human readable name of project that the resource belongs to.
       * </pre>
       *
       * <code>string project_display_name = 3;</code>
       *
       * @return The bytes for projectDisplayName.
       */
      com.google.protobuf.ByteString getProjectDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * The full resource name of resource's parent.
       * </pre>
       *
       * <code>string parent_name = 4;</code>
       *
       * @return The parentName.
       */
      java.lang.String getParentName();
      /**
       *
       *
       * <pre>
       * The full resource name of resource's parent.
       * </pre>
       *
       * <code>string parent_name = 4;</code>
       *
       * @return The bytes for parentName.
       */
      com.google.protobuf.ByteString getParentNameBytes();

      /**
       *
       *
       * <pre>
       * The human readable name of resource's parent.
       * </pre>
       *
       * <code>string parent_display_name = 5;</code>
       *
       * @return The parentDisplayName.
       */
      java.lang.String getParentDisplayName();
      /**
       *
       *
       * <pre>
       * The human readable name of resource's parent.
       * </pre>
       *
       * <code>string parent_display_name = 5;</code>
       *
       * @return The bytes for parentDisplayName.
       */
      com.google.protobuf.ByteString getParentDisplayNameBytes();
    }
    /**
     *
     *
     * <pre>
     * Information related to the Google Cloud resource that is
     * associated with this finding.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource}
     */
    public static final class Resource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource)
        ResourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Resource.newBuilder() to construct.
      private Resource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Resource() {
        name_ = "";
        projectName_ = "";
        projectDisplayName_ = "";
        parentName_ = "";
        parentDisplayName_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Resource();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Resource(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  name_ = s;
                  break;
                }
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  projectName_ = s;
                  break;
                }
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  projectDisplayName_ = s;
                  break;
                }
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  parentName_ = s;
                  break;
                }
              case 42:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  parentDisplayName_ = s;
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_Resource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_Resource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                    .class,
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                    .Builder.class);
      }

      public static final int NAME_FIELD_NUMBER = 1;
      private volatile java.lang.Object name_;
      /**
       *
       *
       * <pre>
       * The full resource name of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PROJECT_NAME_FIELD_NUMBER = 2;
      private volatile java.lang.Object projectName_;
      /**
       *
       *
       * <pre>
       * The full resource name of project that the resource belongs to.
       * </pre>
       *
       * <code>string project_name = 2;</code>
       *
       * @return The projectName.
       */
      @java.lang.Override
      public java.lang.String getProjectName() {
        java.lang.Object ref = projectName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of project that the resource belongs to.
       * </pre>
       *
       * <code>string project_name = 2;</code>
       *
       * @return The bytes for projectName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getProjectNameBytes() {
        java.lang.Object ref = projectName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PROJECT_DISPLAY_NAME_FIELD_NUMBER = 3;
      private volatile java.lang.Object projectDisplayName_;
      /**
       *
       *
       * <pre>
       * The human readable name of project that the resource belongs to.
       * </pre>
       *
       * <code>string project_display_name = 3;</code>
       *
       * @return The projectDisplayName.
       */
      @java.lang.Override
      public java.lang.String getProjectDisplayName() {
        java.lang.Object ref = projectDisplayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectDisplayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The human readable name of project that the resource belongs to.
       * </pre>
       *
       * <code>string project_display_name = 3;</code>
       *
       * @return The bytes for projectDisplayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getProjectDisplayNameBytes() {
        java.lang.Object ref = projectDisplayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PARENT_NAME_FIELD_NUMBER = 4;
      private volatile java.lang.Object parentName_;
      /**
       *
       *
       * <pre>
       * The full resource name of resource's parent.
       * </pre>
       *
       * <code>string parent_name = 4;</code>
       *
       * @return The parentName.
       */
      @java.lang.Override
      public java.lang.String getParentName() {
        java.lang.Object ref = parentName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parentName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of resource's parent.
       * </pre>
       *
       * <code>string parent_name = 4;</code>
       *
       * @return The bytes for parentName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getParentNameBytes() {
        java.lang.Object ref = parentName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parentName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PARENT_DISPLAY_NAME_FIELD_NUMBER = 5;
      private volatile java.lang.Object parentDisplayName_;
      /**
       *
       *
       * <pre>
       * The human readable name of resource's parent.
       * </pre>
       *
       * <code>string parent_display_name = 5;</code>
       *
       * @return The parentDisplayName.
       */
      @java.lang.Override
      public java.lang.String getParentDisplayName() {
        java.lang.Object ref = parentDisplayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parentDisplayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The human readable name of resource's parent.
       * </pre>
       *
       * <code>string parent_display_name = 5;</code>
       *
       * @return The bytes for parentDisplayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getParentDisplayNameBytes() {
        java.lang.Object ref = parentDisplayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parentDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getNameBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (!getProjectNameBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectName_);
        }
        if (!getProjectDisplayNameBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, projectDisplayName_);
        }
        if (!getParentNameBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, parentName_);
        }
        if (!getParentDisplayNameBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, parentDisplayName_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getNameBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (!getProjectNameBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectName_);
        }
        if (!getProjectDisplayNameBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, projectDisplayName_);
        }
        if (!getParentNameBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, parentName_);
        }
        if (!getParentDisplayNameBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, parentDisplayName_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource)) {
          return super.equals(obj);
        }
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource other =
            (com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource)
                obj;

        if (!getName().equals(other.getName())) return false;
        if (!getProjectName().equals(other.getProjectName())) return false;
        if (!getProjectDisplayName().equals(other.getProjectDisplayName())) return false;
        if (!getParentName().equals(other.getParentName())) return false;
        if (!getParentDisplayName().equals(other.getParentDisplayName())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        hash = (37 * hash) + PROJECT_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getProjectName().hashCode();
        hash = (37 * hash) + PROJECT_DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getProjectDisplayName().hashCode();
        hash = (37 * hash) + PARENT_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getParentName().hashCode();
        hash = (37 * hash) + PARENT_DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getParentDisplayName().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Information related to the Google Cloud resource that is
       * associated with this finding.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource)
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .ResourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.securitycenter.v1.SecuritycenterService
              .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_Resource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.securitycenter.v1.SecuritycenterService
              .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_Resource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                      .Resource.class,
                  com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                      .Resource.Builder.class);
        }

        // Construct using
        // com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          name_ = "";

          projectName_ = "";

          projectDisplayName_ = "";

          parentName_ = "";

          parentDisplayName_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.securitycenter.v1.SecuritycenterService
              .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_Resource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
            getDefaultInstanceForType() {
          return com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
            build() {
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
            buildPartial() {
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
              result =
                  new com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                      .Resource(this);
          result.name_ = name_;
          result.projectName_ = projectName_;
          result.projectDisplayName_ = projectDisplayName_;
          result.parentName_ = parentName_;
          result.parentDisplayName_ = parentDisplayName_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource) {
            return mergeFrom(
                (com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                        .Resource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                other) {
          if (other
              == com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            onChanged();
          }
          if (!other.getProjectName().isEmpty()) {
            projectName_ = other.projectName_;
            onChanged();
          }
          if (!other.getProjectDisplayName().isEmpty()) {
            projectDisplayName_ = other.projectDisplayName_;
            onChanged();
          }
          if (!other.getParentName().isEmpty()) {
            parentName_ = other.parentName_;
            onChanged();
          }
          if (!other.getParentDisplayName().isEmpty()) {
            parentDisplayName_ = other.parentDisplayName_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                        .Resource)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * The full resource name of the resource. See:
         * https://cloud.google.com/apis/design/resource_names#full_resource_name
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The full resource name of the resource. See:
         * https://cloud.google.com/apis/design/resource_names#full_resource_name
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The full resource name of the resource. See:
         * https://cloud.google.com/apis/design/resource_names#full_resource_name
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          name_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full resource name of the resource. See:
         * https://cloud.google.com/apis/design/resource_names#full_resource_name
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {

          name_ = getDefaultInstance().getName();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full resource name of the resource. See:
         * https://cloud.google.com/apis/design/resource_names#full_resource_name
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          name_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object projectName_ = "";
        /**
         *
         *
         * <pre>
         * The full resource name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_name = 2;</code>
         *
         * @return The projectName.
         */
        public java.lang.String getProjectName() {
          java.lang.Object ref = projectName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            projectName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The full resource name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_name = 2;</code>
         *
         * @return The bytes for projectName.
         */
        public com.google.protobuf.ByteString getProjectNameBytes() {
          java.lang.Object ref = projectName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            projectName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The full resource name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_name = 2;</code>
         *
         * @param value The projectName to set.
         * @return This builder for chaining.
         */
        public Builder setProjectName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          projectName_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full resource name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_name = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearProjectName() {

          projectName_ = getDefaultInstance().getProjectName();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full resource name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_name = 2;</code>
         *
         * @param value The bytes for projectName to set.
         * @return This builder for chaining.
         */
        public Builder setProjectNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          projectName_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object projectDisplayName_ = "";
        /**
         *
         *
         * <pre>
         * The human readable name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_display_name = 3;</code>
         *
         * @return The projectDisplayName.
         */
        public java.lang.String getProjectDisplayName() {
          java.lang.Object ref = projectDisplayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            projectDisplayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The human readable name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_display_name = 3;</code>
         *
         * @return The bytes for projectDisplayName.
         */
        public com.google.protobuf.ByteString getProjectDisplayNameBytes() {
          java.lang.Object ref = projectDisplayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            projectDisplayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The human readable name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_display_name = 3;</code>
         *
         * @param value The projectDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setProjectDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          projectDisplayName_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The human readable name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_display_name = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearProjectDisplayName() {

          projectDisplayName_ = getDefaultInstance().getProjectDisplayName();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The human readable name of project that the resource belongs to.
         * </pre>
         *
         * <code>string project_display_name = 3;</code>
         *
         * @param value The bytes for projectDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setProjectDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          projectDisplayName_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object parentName_ = "";
        /**
         *
         *
         * <pre>
         * The full resource name of resource's parent.
         * </pre>
         *
         * <code>string parent_name = 4;</code>
         *
         * @return The parentName.
         */
        public java.lang.String getParentName() {
          java.lang.Object ref = parentName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            parentName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The full resource name of resource's parent.
         * </pre>
         *
         * <code>string parent_name = 4;</code>
         *
         * @return The bytes for parentName.
         */
        public com.google.protobuf.ByteString getParentNameBytes() {
          java.lang.Object ref = parentName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            parentName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The full resource name of resource's parent.
         * </pre>
         *
         * <code>string parent_name = 4;</code>
         *
         * @param value The parentName to set.
         * @return This builder for chaining.
         */
        public Builder setParentName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          parentName_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full resource name of resource's parent.
         * </pre>
         *
         * <code>string parent_name = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearParentName() {

          parentName_ = getDefaultInstance().getParentName();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full resource name of resource's parent.
         * </pre>
         *
         * <code>string parent_name = 4;</code>
         *
         * @param value The bytes for parentName to set.
         * @return This builder for chaining.
         */
        public Builder setParentNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          parentName_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object parentDisplayName_ = "";
        /**
         *
         *
         * <pre>
         * The human readable name of resource's parent.
         * </pre>
         *
         * <code>string parent_display_name = 5;</code>
         *
         * @return The parentDisplayName.
         */
        public java.lang.String getParentDisplayName() {
          java.lang.Object ref = parentDisplayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            parentDisplayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The human readable name of resource's parent.
         * </pre>
         *
         * <code>string parent_display_name = 5;</code>
         *
         * @return The bytes for parentDisplayName.
         */
        public com.google.protobuf.ByteString getParentDisplayNameBytes() {
          java.lang.Object ref = parentDisplayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            parentDisplayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The human readable name of resource's parent.
         * </pre>
         *
         * <code>string parent_display_name = 5;</code>
         *
         * @param value The parentDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setParentDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          parentDisplayName_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The human readable name of resource's parent.
         * </pre>
         *
         * <code>string parent_display_name = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearParentDisplayName() {

          parentDisplayName_ = getDefaultInstance().getParentDisplayName();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The human readable name of resource's parent.
         * </pre>
         *
         * <code>string parent_display_name = 5;</code>
         *
         * @param value The bytes for parentDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setParentDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          parentDisplayName_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource)
      private static final com.google.cloud.securitycenter.v1.ListFindingsResponse
              .ListFindingsResult.Resource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                .Resource();
      }

      public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .Resource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Resource> PARSER =
          new com.google.protobuf.AbstractParser<Resource>() {
            @java.lang.Override
            public Resource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Resource(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<Resource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Resource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int FINDING_FIELD_NUMBER = 1;
    private com.google.cloud.securitycenter.v1.Finding finding_;
    /**
     *
     *
     * <pre>
     * Finding matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     *
     * @return Whether the finding field is set.
     */
    @java.lang.Override
    public boolean hasFinding() {
      return finding_ != null;
    }
    /**
     *
     *
     * <pre>
     * Finding matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     *
     * @return The finding.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding getFinding() {
      return finding_ == null
          ? com.google.cloud.securitycenter.v1.Finding.getDefaultInstance()
          : finding_;
    }
    /**
     *
     *
     * <pre>
     * Finding matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.FindingOrBuilder getFindingOrBuilder() {
      return getFinding();
    }

    public static final int STATE_CHANGE_FIELD_NUMBER = 2;
    private int stateChange_;
    /**
     *
     *
     * <pre>
     * State change of the finding between the points in time.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange state_change = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for stateChange.
     */
    @java.lang.Override
    public int getStateChangeValue() {
      return stateChange_;
    }
    /**
     *
     *
     * <pre>
     * State change of the finding between the points in time.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange state_change = 2;
     * </code>
     *
     * @return The stateChange.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
        getStateChange() {
      @SuppressWarnings("deprecation")
      com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
          result =
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
                  .valueOf(stateChange_);
      return result == null
          ? com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
              .UNRECOGNIZED
          : result;
    }

    public static final int RESOURCE_FIELD_NUMBER = 3;
    private com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
        resource_;
    /**
     *
     *
     * <pre>
     * Output only. Resource that is associated with this finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
     * </code>
     *
     * @return Whether the resource field is set.
     */
    @java.lang.Override
    public boolean hasResource() {
      return resource_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource that is associated with this finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
     * </code>
     *
     * @return The resource.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
        getResource() {
      return resource_ == null
          ? com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
              .getDefaultInstance()
          : resource_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource that is associated with this finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
            .ResourceOrBuilder
        getResourceOrBuilder() {
      return getResource();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (finding_ != null) {
        output.writeMessage(1, getFinding());
      }
      if (stateChange_
          != com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
              .UNUSED
              .getNumber()) {
        output.writeEnum(2, stateChange_);
      }
      if (resource_ != null) {
        output.writeMessage(3, getResource());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (finding_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFinding());
      }
      if (stateChange_
          != com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
              .UNUSED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, stateChange_);
      }
      if (resource_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getResource());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult other =
          (com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult) obj;

      if (hasFinding() != other.hasFinding()) return false;
      if (hasFinding()) {
        if (!getFinding().equals(other.getFinding())) return false;
      }
      if (stateChange_ != other.stateChange_) return false;
      if (hasResource() != other.hasResource()) return false;
      if (hasResource()) {
        if (!getResource().equals(other.getResource())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasFinding()) {
        hash = (37 * hash) + FINDING_FIELD_NUMBER;
        hash = (53 * hash) + getFinding().hashCode();
      }
      hash = (37 * hash) + STATE_CHANGE_FIELD_NUMBER;
      hash = (53 * hash) + stateChange_;
      if (hasResource()) {
        hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getResource().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Result containing the Finding and its StateChange.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult)
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.class,
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (findingBuilder_ == null) {
          finding_ = null;
        } else {
          finding_ = null;
          findingBuilder_ = null;
        }
        stateChange_ = 0;

        if (resourceBuilder_ == null) {
          resource_ = null;
        } else {
          resource_ = null;
          resourceBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_ListFindingsResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult build() {
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
          buildPartial() {
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult result =
            new com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult(this);
        if (findingBuilder_ == null) {
          result.finding_ = finding_;
        } else {
          result.finding_ = findingBuilder_.build();
        }
        result.stateChange_ = stateChange_;
        if (resourceBuilder_ == null) {
          result.resource_ = resource_;
        } else {
          result.resource_ = resourceBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult other) {
        if (other
            == com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                .getDefaultInstance()) return this;
        if (other.hasFinding()) {
          mergeFinding(other.getFinding());
        }
        if (other.stateChange_ != 0) {
          setStateChangeValue(other.getStateChangeValue());
        }
        if (other.hasResource()) {
          mergeResource(other.getResource());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.cloud.securitycenter.v1.Finding finding_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Finding,
              com.google.cloud.securitycenter.v1.Finding.Builder,
              com.google.cloud.securitycenter.v1.FindingOrBuilder>
          findingBuilder_;
      /**
       *
       *
       * <pre>
       * Finding matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       *
       * @return Whether the finding field is set.
       */
      public boolean hasFinding() {
        return findingBuilder_ != null || finding_ != null;
      }
      /**
       *
       *
       * <pre>
       * Finding matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       *
       * @return The finding.
       */
      public com.google.cloud.securitycenter.v1.Finding getFinding() {
        if (findingBuilder_ == null) {
          return finding_ == null
              ? com.google.cloud.securitycenter.v1.Finding.getDefaultInstance()
              : finding_;
        } else {
          return findingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Finding matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public Builder setFinding(com.google.cloud.securitycenter.v1.Finding value) {
        if (findingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          finding_ = value;
          onChanged();
        } else {
          findingBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Finding matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public Builder setFinding(
          com.google.cloud.securitycenter.v1.Finding.Builder builderForValue) {
        if (findingBuilder_ == null) {
          finding_ = builderForValue.build();
          onChanged();
        } else {
          findingBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Finding matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public Builder mergeFinding(com.google.cloud.securitycenter.v1.Finding value) {
        if (findingBuilder_ == null) {
          if (finding_ != null) {
            finding_ =
                com.google.cloud.securitycenter.v1.Finding.newBuilder(finding_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            finding_ = value;
          }
          onChanged();
        } else {
          findingBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Finding matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public Builder clearFinding() {
        if (findingBuilder_ == null) {
          finding_ = null;
          onChanged();
        } else {
          finding_ = null;
          findingBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Finding matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public com.google.cloud.securitycenter.v1.Finding.Builder getFindingBuilder() {

        onChanged();
        return getFindingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Finding matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public com.google.cloud.securitycenter.v1.FindingOrBuilder getFindingOrBuilder() {
        if (findingBuilder_ != null) {
          return findingBuilder_.getMessageOrBuilder();
        } else {
          return finding_ == null
              ? com.google.cloud.securitycenter.v1.Finding.getDefaultInstance()
              : finding_;
        }
      }
      /**
       *
       *
       * <pre>
       * Finding matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Finding,
              com.google.cloud.securitycenter.v1.Finding.Builder,
              com.google.cloud.securitycenter.v1.FindingOrBuilder>
          getFindingFieldBuilder() {
        if (findingBuilder_ == null) {
          findingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Finding,
                  com.google.cloud.securitycenter.v1.Finding.Builder,
                  com.google.cloud.securitycenter.v1.FindingOrBuilder>(
                  getFinding(), getParentForChildren(), isClean());
          finding_ = null;
        }
        return findingBuilder_;
      }

      private int stateChange_ = 0;
      /**
       *
       *
       * <pre>
       * State change of the finding between the points in time.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange state_change = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for stateChange.
       */
      @java.lang.Override
      public int getStateChangeValue() {
        return stateChange_;
      }
      /**
       *
       *
       * <pre>
       * State change of the finding between the points in time.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange state_change = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for stateChange to set.
       * @return This builder for chaining.
       */
      public Builder setStateChangeValue(int value) {

        stateChange_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * State change of the finding between the points in time.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange state_change = 2;
       * </code>
       *
       * @return The stateChange.
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
          getStateChange() {
        @SuppressWarnings("deprecation")
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
            result =
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                    .StateChange.valueOf(stateChange_);
        return result == null
            ? com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * State change of the finding between the points in time.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange state_change = 2;
       * </code>
       *
       * @param value The stateChange to set.
       * @return This builder for chaining.
       */
      public Builder setStateChange(
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
              value) {
        if (value == null) {
          throw new NullPointerException();
        }

        stateChange_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * State change of the finding between the points in time.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange state_change = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStateChange() {

        stateChange_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
          resource_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource,
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                  .Builder,
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                  .ResourceOrBuilder>
          resourceBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Resource that is associated with this finding.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
       * </code>
       *
       * @return Whether the resource field is set.
       */
      public boolean hasResource() {
        return resourceBuilder_ != null || resource_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. Resource that is associated with this finding.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
       * </code>
       *
       * @return The resource.
       */
      public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
          getResource() {
        if (resourceBuilder_ == null) {
          return resource_ == null
              ? com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                  .getDefaultInstance()
              : resource_;
        } else {
          return resourceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Resource that is associated with this finding.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
       * </code>
       */
      public Builder setResource(
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
              value) {
        if (resourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          resource_ = value;
          onChanged();
        } else {
          resourceBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Resource that is associated with this finding.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
       * </code>
       */
      public Builder setResource(
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                  .Builder
              builderForValue) {
        if (resourceBuilder_ == null) {
          resource_ = builderForValue.build();
          onChanged();
        } else {
          resourceBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Resource that is associated with this finding.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
       * </code>
       */
      public Builder mergeResource(
          com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
              value) {
        if (resourceBuilder_ == null) {
          if (resource_ != null) {
            resource_ =
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                    .newBuilder(resource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            resource_ = value;
          }
          onChanged();
        } else {
          resourceBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Resource that is associated with this finding.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
       * </code>
       */
      public Builder clearResource() {
        if (resourceBuilder_ == null) {
          resource_ = null;
          onChanged();
        } else {
          resource_ = null;
          resourceBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Resource that is associated with this finding.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
       * </code>
       */
      public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
              .Builder
          getResourceBuilder() {

        onChanged();
        return getResourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Resource that is associated with this finding.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
       * </code>
       */
      public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
              .ResourceOrBuilder
          getResourceOrBuilder() {
        if (resourceBuilder_ != null) {
          return resourceBuilder_.getMessageOrBuilder();
        } else {
          return resource_ == null
              ? com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                  .getDefaultInstance()
              : resource_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Resource that is associated with this finding.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource resource = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource,
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
                  .Builder,
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                  .ResourceOrBuilder>
          getResourceFieldBuilder() {
        if (resourceBuilder_ == null) {
          resourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                      .Resource,
                  com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                      .Resource.Builder,
                  com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                      .ResourceOrBuilder>(getResource(), getParentForChildren(), isClean());
          resource_ = null;
        }
        return resourceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult)
    private static final com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult();
    }

    public static com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListFindingsResult> PARSER =
        new com.google.protobuf.AbstractParser<ListFindingsResult>() {
          @java.lang.Override
          public ListFindingsResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ListFindingsResult(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ListFindingsResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListFindingsResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int LIST_FINDINGS_RESULTS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult>
      listFindingsResults_;
  /**
   *
   *
   * <pre>
   * Findings matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult>
      getListFindingsResultsList() {
    return listFindingsResults_;
  }
  /**
   *
   *
   * <pre>
   * Findings matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResultOrBuilder>
      getListFindingsResultsOrBuilderList() {
    return listFindingsResults_;
  }
  /**
   *
   *
   * <pre>
   * Findings matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
   * </code>
   */
  @java.lang.Override
  public int getListFindingsResultsCount() {
    return listFindingsResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Findings matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
      getListFindingsResults(int index) {
    return listFindingsResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Findings matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResultOrBuilder
      getListFindingsResultsOrBuilder(int index) {
    return listFindingsResults_.get(index);
  }

  public static final int READ_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp readTime_;
  /**
   *
   *
   * <pre>
   * Time used for executing the list request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 2;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return readTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time used for executing the list request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 2;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }
  /**
   *
   *
   * <pre>
   * Time used for executing the list request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return getReadTime();
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * Token to retrieve the next page of results, or empty if there are no more
   * results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Token to retrieve the next page of results, or empty if there are no more
   * results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TOTAL_SIZE_FIELD_NUMBER = 4;
  private int totalSize_;
  /**
   *
   *
   * <pre>
   * The total number of findings matching the query.
   * </pre>
   *
   * <code>int32 total_size = 4;</code>
   *
   * @return The totalSize.
   */
  @java.lang.Override
  public int getTotalSize() {
    return totalSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < listFindingsResults_.size(); i++) {
      output.writeMessage(1, listFindingsResults_.get(i));
    }
    if (readTime_ != null) {
      output.writeMessage(2, getReadTime());
    }
    if (!getNextPageTokenBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
    }
    if (totalSize_ != 0) {
      output.writeInt32(4, totalSize_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < listFindingsResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, listFindingsResults_.get(i));
    }
    if (readTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getReadTime());
    }
    if (!getNextPageTokenBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
    }
    if (totalSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, totalSize_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.ListFindingsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.ListFindingsResponse other =
        (com.google.cloud.securitycenter.v1.ListFindingsResponse) obj;

    if (!getListFindingsResultsList().equals(other.getListFindingsResultsList())) return false;
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (getTotalSize() != other.getTotalSize()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getListFindingsResultsCount() > 0) {
      hash = (37 * hash) + LIST_FINDINGS_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getListFindingsResultsList().hashCode();
    }
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (37 * hash) + TOTAL_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getTotalSize();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1.ListFindingsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for listing findings.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.ListFindingsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.ListFindingsResponse)
      com.google.cloud.securitycenter.v1.ListFindingsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.ListFindingsResponse.class,
              com.google.cloud.securitycenter.v1.ListFindingsResponse.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.ListFindingsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getListFindingsResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (listFindingsResultsBuilder_ == null) {
        listFindingsResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        listFindingsResultsBuilder_.clear();
      }
      if (readTimeBuilder_ == null) {
        readTime_ = null;
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }
      nextPageToken_ = "";

      totalSize_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_ListFindingsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListFindingsResponse getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.ListFindingsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListFindingsResponse build() {
      com.google.cloud.securitycenter.v1.ListFindingsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListFindingsResponse buildPartial() {
      com.google.cloud.securitycenter.v1.ListFindingsResponse result =
          new com.google.cloud.securitycenter.v1.ListFindingsResponse(this);
      int from_bitField0_ = bitField0_;
      if (listFindingsResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          listFindingsResults_ = java.util.Collections.unmodifiableList(listFindingsResults_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.listFindingsResults_ = listFindingsResults_;
      } else {
        result.listFindingsResults_ = listFindingsResultsBuilder_.build();
      }
      if (readTimeBuilder_ == null) {
        result.readTime_ = readTime_;
      } else {
        result.readTime_ = readTimeBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      result.totalSize_ = totalSize_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.ListFindingsResponse) {
        return mergeFrom((com.google.cloud.securitycenter.v1.ListFindingsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.ListFindingsResponse other) {
      if (other == com.google.cloud.securitycenter.v1.ListFindingsResponse.getDefaultInstance())
        return this;
      if (listFindingsResultsBuilder_ == null) {
        if (!other.listFindingsResults_.isEmpty()) {
          if (listFindingsResults_.isEmpty()) {
            listFindingsResults_ = other.listFindingsResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureListFindingsResultsIsMutable();
            listFindingsResults_.addAll(other.listFindingsResults_);
          }
          onChanged();
        }
      } else {
        if (!other.listFindingsResults_.isEmpty()) {
          if (listFindingsResultsBuilder_.isEmpty()) {
            listFindingsResultsBuilder_.dispose();
            listFindingsResultsBuilder_ = null;
            listFindingsResults_ = other.listFindingsResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
            listFindingsResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getListFindingsResultsFieldBuilder()
                    : null;
          } else {
            listFindingsResultsBuilder_.addAllMessages(other.listFindingsResults_);
          }
        }
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      if (other.getTotalSize() != 0) {
        setTotalSize(other.getTotalSize());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.securitycenter.v1.ListFindingsResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.securitycenter.v1.ListFindingsResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult>
        listFindingsResults_ = java.util.Collections.emptyList();

    private void ensureListFindingsResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        listFindingsResults_ =
            new java.util.ArrayList<
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult>(
                listFindingsResults_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult,
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder,
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResultOrBuilder>
        listFindingsResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult>
        getListFindingsResultsList() {
      if (listFindingsResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(listFindingsResults_);
      } else {
        return listFindingsResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public int getListFindingsResultsCount() {
      if (listFindingsResultsBuilder_ == null) {
        return listFindingsResults_.size();
      } else {
        return listFindingsResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
        getListFindingsResults(int index) {
      if (listFindingsResultsBuilder_ == null) {
        return listFindingsResults_.get(index);
      } else {
        return listFindingsResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public Builder setListFindingsResults(
        int index,
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult value) {
      if (listFindingsResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListFindingsResultsIsMutable();
        listFindingsResults_.set(index, value);
        onChanged();
      } else {
        listFindingsResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public Builder setListFindingsResults(
        int index,
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder
            builderForValue) {
      if (listFindingsResultsBuilder_ == null) {
        ensureListFindingsResultsIsMutable();
        listFindingsResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        listFindingsResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public Builder addListFindingsResults(
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult value) {
      if (listFindingsResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListFindingsResultsIsMutable();
        listFindingsResults_.add(value);
        onChanged();
      } else {
        listFindingsResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public Builder addListFindingsResults(
        int index,
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult value) {
      if (listFindingsResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListFindingsResultsIsMutable();
        listFindingsResults_.add(index, value);
        onChanged();
      } else {
        listFindingsResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public Builder addListFindingsResults(
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder
            builderForValue) {
      if (listFindingsResultsBuilder_ == null) {
        ensureListFindingsResultsIsMutable();
        listFindingsResults_.add(builderForValue.build());
        onChanged();
      } else {
        listFindingsResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public Builder addListFindingsResults(
        int index,
        com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder
            builderForValue) {
      if (listFindingsResultsBuilder_ == null) {
        ensureListFindingsResultsIsMutable();
        listFindingsResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        listFindingsResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public Builder addAllListFindingsResults(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult>
            values) {
      if (listFindingsResultsBuilder_ == null) {
        ensureListFindingsResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, listFindingsResults_);
        onChanged();
      } else {
        listFindingsResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public Builder clearListFindingsResults() {
      if (listFindingsResultsBuilder_ == null) {
        listFindingsResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        listFindingsResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public Builder removeListFindingsResults(int index) {
      if (listFindingsResultsBuilder_ == null) {
        ensureListFindingsResultsIsMutable();
        listFindingsResults_.remove(index);
        onChanged();
      } else {
        listFindingsResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder
        getListFindingsResultsBuilder(int index) {
      return getListFindingsResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResultOrBuilder
        getListFindingsResultsOrBuilder(int index) {
      if (listFindingsResultsBuilder_ == null) {
        return listFindingsResults_.get(index);
      } else {
        return listFindingsResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResultOrBuilder>
        getListFindingsResultsOrBuilderList() {
      if (listFindingsResultsBuilder_ != null) {
        return listFindingsResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(listFindingsResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder
        addListFindingsResultsBuilder() {
      return getListFindingsResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder
        addListFindingsResultsBuilder(int index) {
      return getListFindingsResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Findings matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult list_findings_results = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder>
        getListFindingsResultsBuilderList() {
      return getListFindingsResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult,
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder,
            com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResultOrBuilder>
        getListFindingsResultsFieldBuilder() {
      if (listFindingsResultsBuilder_ == null) {
        listFindingsResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult,
                com.google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Builder,
                com.google.cloud.securitycenter.v1.ListFindingsResponse
                    .ListFindingsResultOrBuilder>(
                listFindingsResults_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        listFindingsResults_ = null;
      }
      return listFindingsResultsBuilder_;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return readTimeBuilder_ != null || readTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (readTime_ != null) {
          readTime_ =
              com.google.protobuf.Timestamp.newBuilder(readTime_).mergeFrom(value).buildPartial();
        } else {
          readTime_ = value;
        }
        onChanged();
      } else {
        readTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        readTime_ = null;
        onChanged();
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {

      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    private int totalSize_;
    /**
     *
     *
     * <pre>
     * The total number of findings matching the query.
     * </pre>
     *
     * <code>int32 total_size = 4;</code>
     *
     * @return The totalSize.
     */
    @java.lang.Override
    public int getTotalSize() {
      return totalSize_;
    }
    /**
     *
     *
     * <pre>
     * The total number of findings matching the query.
     * </pre>
     *
     * <code>int32 total_size = 4;</code>
     *
     * @param value The totalSize to set.
     * @return This builder for chaining.
     */
    public Builder setTotalSize(int value) {

      totalSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The total number of findings matching the query.
     * </pre>
     *
     * <code>int32 total_size = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalSize() {

      totalSize_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.ListFindingsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.ListFindingsResponse)
  private static final com.google.cloud.securitycenter.v1.ListFindingsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.ListFindingsResponse();
  }

  public static com.google.cloud.securitycenter.v1.ListFindingsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListFindingsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListFindingsResponse>() {
        @java.lang.Override
        public ListFindingsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ListFindingsResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ListFindingsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListFindingsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ListFindingsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
