/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Request message for bulk findings update.
 *
 * Note:
 * 1. If multiple bulk update requests match the same resource, the order in
 * which they get executed is not defined.
 * 2. Once a bulk operation is started, there is no way to stop it.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.BulkMuteFindingsRequest}
 */
public final class BulkMuteFindingsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.BulkMuteFindingsRequest)
    BulkMuteFindingsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BulkMuteFindingsRequest.newBuilder() to construct.
  private BulkMuteFindingsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BulkMuteFindingsRequest() {
    parent_ = "";
    filter_ = "";
    muteAnnotation_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BulkMuteFindingsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_BulkMuteFindingsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_BulkMuteFindingsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest.class,
            com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent, at which bulk action needs to be applied. Its format
   * is "organizations/[organization_id]", "folders/[folder_id]",
   * "projects/[project_id]".
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent, at which bulk action needs to be applied. Its format
   * is "organizations/[organization_id]", "folders/[folder_id]",
   * "projects/[project_id]".
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Expression that identifies findings that should be updated.
   * The expression is a list of zero or more restrictions combined
   * via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
   * has higher precedence than `AND`.
   *
   * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
   * `-` character in front of them to indicate negation. The fields map to
   * those defined in the corresponding resource.
   *
   * The supported operators are:
   *
   * * `=` for all value types.
   * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
   * * `:`, meaning substring matching, for strings.
   *
   * The supported value types are:
   *
   * * string literals in quotes.
   * * integer literals without quotes.
   * * boolean literals `true` and `false` without quotes.
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Expression that identifies findings that should be updated.
   * The expression is a list of zero or more restrictions combined
   * via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
   * has higher precedence than `AND`.
   *
   * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
   * `-` character in front of them to indicate negation. The fields map to
   * those defined in the corresponding resource.
   *
   * The supported operators are:
   *
   * * `=` for all value types.
   * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
   * * `:`, meaning substring matching, for strings.
   *
   * The supported value types are:
   *
   * * string literals in quotes.
   * * integer literals without quotes.
   * * boolean literals `true` and `false` without quotes.
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MUTE_ANNOTATION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object muteAnnotation_ = "";
  /**
   *
   *
   * <pre>
   * This can be a mute configuration name or any identifier for mute/unmute
   * of findings based on the filter.
   * </pre>
   *
   * <code>string mute_annotation = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.securitycenter.v1.BulkMuteFindingsRequest.mute_annotation is
   *     deprecated. See google/cloud/securitycenter/v1/securitycenter_service.proto;l=787
   * @return The muteAnnotation.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getMuteAnnotation() {
    java.lang.Object ref = muteAnnotation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      muteAnnotation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This can be a mute configuration name or any identifier for mute/unmute
   * of findings based on the filter.
   * </pre>
   *
   * <code>string mute_annotation = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.securitycenter.v1.BulkMuteFindingsRequest.mute_annotation is
   *     deprecated. See google/cloud/securitycenter/v1/securitycenter_service.proto;l=787
   * @return The bytes for muteAnnotation.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getMuteAnnotationBytes() {
    java.lang.Object ref = muteAnnotation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      muteAnnotation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(muteAnnotation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, muteAnnotation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(muteAnnotation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, muteAnnotation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest other =
        (com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getMuteAnnotation().equals(other.getMuteAnnotation())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + MUTE_ANNOTATION_FIELD_NUMBER;
    hash = (53 * hash) + getMuteAnnotation().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for bulk findings update.
   *
   * Note:
   * 1. If multiple bulk update requests match the same resource, the order in
   * which they get executed is not defined.
   * 2. Once a bulk operation is started, there is no way to stop it.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.BulkMuteFindingsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.BulkMuteFindingsRequest)
      com.google.cloud.securitycenter.v1.BulkMuteFindingsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_BulkMuteFindingsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_BulkMuteFindingsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest.class,
              com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      filter_ = "";
      muteAnnotation_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_BulkMuteFindingsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest build() {
      com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest buildPartial() {
      com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest result =
          new com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.muteAnnotation_ = muteAnnotation_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest) {
        return mergeFrom((com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest other) {
      if (other == com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getMuteAnnotation().isEmpty()) {
        muteAnnotation_ = other.muteAnnotation_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                muteAnnotation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent, at which bulk action needs to be applied. Its format
     * is "organizations/[organization_id]", "folders/[folder_id]",
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent, at which bulk action needs to be applied. Its format
     * is "organizations/[organization_id]", "folders/[folder_id]",
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent, at which bulk action needs to be applied. Its format
     * is "organizations/[organization_id]", "folders/[folder_id]",
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent, at which bulk action needs to be applied. Its format
     * is "organizations/[organization_id]", "folders/[folder_id]",
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent, at which bulk action needs to be applied. Its format
     * is "organizations/[organization_id]", "folders/[folder_id]",
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Expression that identifies findings that should be updated.
     * The expression is a list of zero or more restrictions combined
     * via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
     * has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
     * `-` character in front of them to indicate negation. The fields map to
     * those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Expression that identifies findings that should be updated.
     * The expression is a list of zero or more restrictions combined
     * via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
     * has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
     * `-` character in front of them to indicate negation. The fields map to
     * those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Expression that identifies findings that should be updated.
     * The expression is a list of zero or more restrictions combined
     * via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
     * has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
     * `-` character in front of them to indicate negation. The fields map to
     * those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that identifies findings that should be updated.
     * The expression is a list of zero or more restrictions combined
     * via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
     * has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
     * `-` character in front of them to indicate negation. The fields map to
     * those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that identifies findings that should be updated.
     * The expression is a list of zero or more restrictions combined
     * via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
     * has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
     * `-` character in front of them to indicate negation. The fields map to
     * those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object muteAnnotation_ = "";
    /**
     *
     *
     * <pre>
     * This can be a mute configuration name or any identifier for mute/unmute
     * of findings based on the filter.
     * </pre>
     *
     * <code>string mute_annotation = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.securitycenter.v1.BulkMuteFindingsRequest.mute_annotation is
     *     deprecated. See google/cloud/securitycenter/v1/securitycenter_service.proto;l=787
     * @return The muteAnnotation.
     */
    @java.lang.Deprecated
    public java.lang.String getMuteAnnotation() {
      java.lang.Object ref = muteAnnotation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        muteAnnotation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This can be a mute configuration name or any identifier for mute/unmute
     * of findings based on the filter.
     * </pre>
     *
     * <code>string mute_annotation = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.securitycenter.v1.BulkMuteFindingsRequest.mute_annotation is
     *     deprecated. See google/cloud/securitycenter/v1/securitycenter_service.proto;l=787
     * @return The bytes for muteAnnotation.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getMuteAnnotationBytes() {
      java.lang.Object ref = muteAnnotation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        muteAnnotation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This can be a mute configuration name or any identifier for mute/unmute
     * of findings based on the filter.
     * </pre>
     *
     * <code>string mute_annotation = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.securitycenter.v1.BulkMuteFindingsRequest.mute_annotation is
     *     deprecated. See google/cloud/securitycenter/v1/securitycenter_service.proto;l=787
     * @param value The muteAnnotation to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setMuteAnnotation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      muteAnnotation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This can be a mute configuration name or any identifier for mute/unmute
     * of findings based on the filter.
     * </pre>
     *
     * <code>string mute_annotation = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.securitycenter.v1.BulkMuteFindingsRequest.mute_annotation is
     *     deprecated. See google/cloud/securitycenter/v1/securitycenter_service.proto;l=787
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearMuteAnnotation() {
      muteAnnotation_ = getDefaultInstance().getMuteAnnotation();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This can be a mute configuration name or any identifier for mute/unmute
     * of findings based on the filter.
     * </pre>
     *
     * <code>string mute_annotation = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.securitycenter.v1.BulkMuteFindingsRequest.mute_annotation is
     *     deprecated. See google/cloud/securitycenter/v1/securitycenter_service.proto;l=787
     * @param value The bytes for muteAnnotation to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setMuteAnnotationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      muteAnnotation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.BulkMuteFindingsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.BulkMuteFindingsRequest)
  private static final com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest();
  }

  public static com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BulkMuteFindingsRequest> PARSER =
      new com.google.protobuf.AbstractParser<BulkMuteFindingsRequest>() {
        @java.lang.Override
        public BulkMuteFindingsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BulkMuteFindingsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BulkMuteFindingsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
