/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/security_health_analytics_custom_config.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Defines the properties in a custom module configuration for Security
 * Health Analytics. Use the custom module configuration to create custom
 * detectors that generate custom findings for resources that you specify.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.CustomConfig}
 */
public final class CustomConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.CustomConfig)
    CustomConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomConfig.newBuilder() to construct.
  private CustomConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomConfig() {
    severity_ = 0;
    description_ = "";
    recommendation_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
        .internal_static_google_cloud_securitycenter_v1_CustomConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
        .internal_static_google_cloud_securitycenter_v1_CustomConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.CustomConfig.class,
            com.google.cloud.securitycenter.v1.CustomConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Defines the valid value options for the severity of a finding.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.CustomConfig.Severity}
   */
  public enum Severity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified severity.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Critical severity.
     * </pre>
     *
     * <code>CRITICAL = 1;</code>
     */
    CRITICAL(1),
    /**
     *
     *
     * <pre>
     * High severity.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    HIGH(2),
    /**
     *
     *
     * <pre>
     * Medium severity.
     * </pre>
     *
     * <code>MEDIUM = 3;</code>
     */
    MEDIUM(3),
    /**
     *
     *
     * <pre>
     * Low severity.
     * </pre>
     *
     * <code>LOW = 4;</code>
     */
    LOW(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified severity.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Critical severity.
     * </pre>
     *
     * <code>CRITICAL = 1;</code>
     */
    public static final int CRITICAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * High severity.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    public static final int HIGH_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Medium severity.
     * </pre>
     *
     * <code>MEDIUM = 3;</code>
     */
    public static final int MEDIUM_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Low severity.
     * </pre>
     *
     * <code>LOW = 4;</code>
     */
    public static final int LOW_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Severity forNumber(int value) {
      switch (value) {
        case 0:
          return SEVERITY_UNSPECIFIED;
        case 1:
          return CRITICAL;
        case 2:
          return HIGH;
        case 3:
          return MEDIUM;
        case 4:
          return LOW;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Severity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
          public Severity findValueByNumber(int number) {
            return Severity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.CustomConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.CustomConfig.Severity)
  }

  public interface CustomOutputSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    java.util.List<com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property>
        getPropertiesList();
    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property getProperties(
        int index);
    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    int getPropertiesCount();
    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.PropertyOrBuilder>
        getPropertiesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.PropertyOrBuilder
        getPropertiesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A set of optional name-value pairs that define custom source properties to
   * return with each finding that is generated by the custom module. The custom
   * source properties that are defined here are included in the finding JSON
   * under `sourceProperties`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec}
   */
  public static final class CustomOutputSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec)
      CustomOutputSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CustomOutputSpec.newBuilder() to construct.
    private CustomOutputSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomOutputSpec() {
      properties_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomOutputSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
          .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
          .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.class,
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Builder.class);
    }

    public interface PropertyOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Name of the property for the custom output.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * Name of the property for the custom output.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      /**
       *
       *
       * <pre>
       * The CEL expression for the custom output. A resource property can be
       * specified to return the value of the property or a text string enclosed
       * in quotation marks.
       * </pre>
       *
       * <code>.google.type.Expr value_expression = 2;</code>
       *
       * @return Whether the valueExpression field is set.
       */
      boolean hasValueExpression();
      /**
       *
       *
       * <pre>
       * The CEL expression for the custom output. A resource property can be
       * specified to return the value of the property or a text string enclosed
       * in quotation marks.
       * </pre>
       *
       * <code>.google.type.Expr value_expression = 2;</code>
       *
       * @return The valueExpression.
       */
      com.google.type.Expr getValueExpression();
      /**
       *
       *
       * <pre>
       * The CEL expression for the custom output. A resource property can be
       * specified to return the value of the property or a text string enclosed
       * in quotation marks.
       * </pre>
       *
       * <code>.google.type.Expr value_expression = 2;</code>
       */
      com.google.type.ExprOrBuilder getValueExpressionOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * An individual name-value pair that defines a custom source property.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property}
     */
    public static final class Property extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property)
        PropertyOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Property.newBuilder() to construct.
      private Property(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Property() {
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Property();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
            .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_Property_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
            .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_Property_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.class,
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder
                    .class);
      }

      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Name of the property for the custom output.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the property for the custom output.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_EXPRESSION_FIELD_NUMBER = 2;
      private com.google.type.Expr valueExpression_;
      /**
       *
       *
       * <pre>
       * The CEL expression for the custom output. A resource property can be
       * specified to return the value of the property or a text string enclosed
       * in quotation marks.
       * </pre>
       *
       * <code>.google.type.Expr value_expression = 2;</code>
       *
       * @return Whether the valueExpression field is set.
       */
      @java.lang.Override
      public boolean hasValueExpression() {
        return valueExpression_ != null;
      }
      /**
       *
       *
       * <pre>
       * The CEL expression for the custom output. A resource property can be
       * specified to return the value of the property or a text string enclosed
       * in quotation marks.
       * </pre>
       *
       * <code>.google.type.Expr value_expression = 2;</code>
       *
       * @return The valueExpression.
       */
      @java.lang.Override
      public com.google.type.Expr getValueExpression() {
        return valueExpression_ == null
            ? com.google.type.Expr.getDefaultInstance()
            : valueExpression_;
      }
      /**
       *
       *
       * <pre>
       * The CEL expression for the custom output. A resource property can be
       * specified to return the value of the property or a text string enclosed
       * in quotation marks.
       * </pre>
       *
       * <code>.google.type.Expr value_expression = 2;</code>
       */
      @java.lang.Override
      public com.google.type.ExprOrBuilder getValueExpressionOrBuilder() {
        return valueExpression_ == null
            ? com.google.type.Expr.getDefaultInstance()
            : valueExpression_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (valueExpression_ != null) {
          output.writeMessage(2, getValueExpression());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (valueExpression_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getValueExpression());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property)) {
          return super.equals(obj);
        }
        com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property other =
            (com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property) obj;

        if (!getName().equals(other.getName())) return false;
        if (hasValueExpression() != other.hasValueExpression()) return false;
        if (hasValueExpression()) {
          if (!getValueExpression().equals(other.getValueExpression())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        if (hasValueExpression()) {
          hash = (37 * hash) + VALUE_EXPRESSION_FIELD_NUMBER;
          hash = (53 * hash) + getValueExpression().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * An individual name-value pair that defines a custom source property.
       * </pre>
       *
       * Protobuf type {@code google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property)
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.PropertyOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
              .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_Property_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
              .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_Property_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.class,
                  com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          name_ = "";
          valueExpression_ = null;
          if (valueExpressionBuilder_ != null) {
            valueExpressionBuilder_.dispose();
            valueExpressionBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
              .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_Property_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
            getDefaultInstanceForType() {
          return com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property build() {
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
            buildPartial() {
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property result =
              new com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.name_ = name_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.valueExpression_ =
                valueExpressionBuilder_ == null
                    ? valueExpression_
                    : valueExpressionBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property) {
            return mergeFrom(
                (com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property other) {
          if (other
              == com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasValueExpression()) {
            mergeValueExpression(other.getValueExpression());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getValueExpressionFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * Name of the property for the custom output.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the property for the custom output.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the property for the custom output.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of the property for the custom output.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of the property for the custom output.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.type.Expr valueExpression_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
            valueExpressionBuilder_;
        /**
         *
         *
         * <pre>
         * The CEL expression for the custom output. A resource property can be
         * specified to return the value of the property or a text string enclosed
         * in quotation marks.
         * </pre>
         *
         * <code>.google.type.Expr value_expression = 2;</code>
         *
         * @return Whether the valueExpression field is set.
         */
        public boolean hasValueExpression() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The CEL expression for the custom output. A resource property can be
         * specified to return the value of the property or a text string enclosed
         * in quotation marks.
         * </pre>
         *
         * <code>.google.type.Expr value_expression = 2;</code>
         *
         * @return The valueExpression.
         */
        public com.google.type.Expr getValueExpression() {
          if (valueExpressionBuilder_ == null) {
            return valueExpression_ == null
                ? com.google.type.Expr.getDefaultInstance()
                : valueExpression_;
          } else {
            return valueExpressionBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The CEL expression for the custom output. A resource property can be
         * specified to return the value of the property or a text string enclosed
         * in quotation marks.
         * </pre>
         *
         * <code>.google.type.Expr value_expression = 2;</code>
         */
        public Builder setValueExpression(com.google.type.Expr value) {
          if (valueExpressionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            valueExpression_ = value;
          } else {
            valueExpressionBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The CEL expression for the custom output. A resource property can be
         * specified to return the value of the property or a text string enclosed
         * in quotation marks.
         * </pre>
         *
         * <code>.google.type.Expr value_expression = 2;</code>
         */
        public Builder setValueExpression(com.google.type.Expr.Builder builderForValue) {
          if (valueExpressionBuilder_ == null) {
            valueExpression_ = builderForValue.build();
          } else {
            valueExpressionBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The CEL expression for the custom output. A resource property can be
         * specified to return the value of the property or a text string enclosed
         * in quotation marks.
         * </pre>
         *
         * <code>.google.type.Expr value_expression = 2;</code>
         */
        public Builder mergeValueExpression(com.google.type.Expr value) {
          if (valueExpressionBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && valueExpression_ != null
                && valueExpression_ != com.google.type.Expr.getDefaultInstance()) {
              getValueExpressionBuilder().mergeFrom(value);
            } else {
              valueExpression_ = value;
            }
          } else {
            valueExpressionBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The CEL expression for the custom output. A resource property can be
         * specified to return the value of the property or a text string enclosed
         * in quotation marks.
         * </pre>
         *
         * <code>.google.type.Expr value_expression = 2;</code>
         */
        public Builder clearValueExpression() {
          bitField0_ = (bitField0_ & ~0x00000002);
          valueExpression_ = null;
          if (valueExpressionBuilder_ != null) {
            valueExpressionBuilder_.dispose();
            valueExpressionBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The CEL expression for the custom output. A resource property can be
         * specified to return the value of the property or a text string enclosed
         * in quotation marks.
         * </pre>
         *
         * <code>.google.type.Expr value_expression = 2;</code>
         */
        public com.google.type.Expr.Builder getValueExpressionBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueExpressionFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The CEL expression for the custom output. A resource property can be
         * specified to return the value of the property or a text string enclosed
         * in quotation marks.
         * </pre>
         *
         * <code>.google.type.Expr value_expression = 2;</code>
         */
        public com.google.type.ExprOrBuilder getValueExpressionOrBuilder() {
          if (valueExpressionBuilder_ != null) {
            return valueExpressionBuilder_.getMessageOrBuilder();
          } else {
            return valueExpression_ == null
                ? com.google.type.Expr.getDefaultInstance()
                : valueExpression_;
          }
        }
        /**
         *
         *
         * <pre>
         * The CEL expression for the custom output. A resource property can be
         * specified to return the value of the property or a text string enclosed
         * in quotation marks.
         * </pre>
         *
         * <code>.google.type.Expr value_expression = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
            getValueExpressionFieldBuilder() {
          if (valueExpressionBuilder_ == null) {
            valueExpressionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.type.Expr,
                    com.google.type.Expr.Builder,
                    com.google.type.ExprOrBuilder>(
                    getValueExpression(), getParentForChildren(), isClean());
            valueExpression_ = null;
          }
          return valueExpressionBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property)
      private static final com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property();
      }

      public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Property> PARSER =
          new com.google.protobuf.AbstractParser<Property>() {
            @java.lang.Override
            public Property parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Property> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Property> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int PROPERTIES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property>
        properties_;
    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property>
        getPropertiesList() {
      return properties_;
    }
    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.PropertyOrBuilder>
        getPropertiesOrBuilderList() {
      return properties_;
    }
    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    @java.lang.Override
    public int getPropertiesCount() {
      return properties_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property getProperties(
        int index) {
      return properties_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of custom output properties to add to the finding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.PropertyOrBuilder
        getPropertiesOrBuilder(int index) {
      return properties_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < properties_.size(); i++) {
        output.writeMessage(1, properties_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < properties_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, properties_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec other =
          (com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec) obj;

      if (!getPropertiesList().equals(other.getPropertiesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPropertiesCount() > 0) {
        hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
        hash = (53 * hash) + getPropertiesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A set of optional name-value pairs that define custom source properties to
     * return with each finding that is generated by the custom module. The custom
     * source properties that are defined here are included in the finding JSON
     * under `sourceProperties`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec)
        com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
            .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
            .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.class,
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
        } else {
          properties_ = null;
          propertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
            .internal_static_google_cloud_securitycenter_v1_CustomConfig_CustomOutputSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec build() {
        com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec buildPartial() {
        com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec result =
            new com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec result) {
        if (propertiesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            properties_ = java.util.Collections.unmodifiableList(properties_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.properties_ = properties_;
        } else {
          result.properties_ = propertiesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec other) {
        if (other
            == com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
                .getDefaultInstance()) return this;
        if (propertiesBuilder_ == null) {
          if (!other.properties_.isEmpty()) {
            if (properties_.isEmpty()) {
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePropertiesIsMutable();
              properties_.addAll(other.properties_);
            }
            onChanged();
          }
        } else {
          if (!other.properties_.isEmpty()) {
            if (propertiesBuilder_.isEmpty()) {
              propertiesBuilder_.dispose();
              propertiesBuilder_ = null;
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000001);
              propertiesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPropertiesFieldBuilder()
                      : null;
            } else {
              propertiesBuilder_.addAllMessages(other.properties_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property m =
                      input.readMessage(
                          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
                              .parser(),
                          extensionRegistry);
                  if (propertiesBuilder_ == null) {
                    ensurePropertiesIsMutable();
                    properties_.add(m);
                  } else {
                    propertiesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property>
          properties_ = java.util.Collections.emptyList();

      private void ensurePropertiesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          properties_ =
              new java.util.ArrayList<
                  com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property>(
                  properties_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property,
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder,
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.PropertyOrBuilder>
          propertiesBuilder_;

      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property>
          getPropertiesList() {
        if (propertiesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(properties_);
        } else {
          return propertiesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public int getPropertiesCount() {
        if (propertiesBuilder_ == null) {
          return properties_.size();
        } else {
          return propertiesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
          getProperties(int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);
        } else {
          return propertiesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public Builder setProperties(
          int index,
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.set(index, value);
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public Builder setProperties(
          int index,
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder
              builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.set(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public Builder addProperties(
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public Builder addProperties(
          int index,
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(index, value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public Builder addProperties(
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder
              builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public Builder addProperties(
          int index,
          com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder
              builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public Builder addAllProperties(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property>
              values) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, properties_);
          onChanged();
        } else {
          propertiesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public Builder clearProperties() {
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          propertiesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public Builder removeProperties(int index) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.remove(index);
          onChanged();
        } else {
          propertiesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder
          getPropertiesBuilder(int index) {
        return getPropertiesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.PropertyOrBuilder
          getPropertiesOrBuilder(int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);
        } else {
          return propertiesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
                      .PropertyOrBuilder>
          getPropertiesOrBuilderList() {
        if (propertiesBuilder_ != null) {
          return propertiesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(properties_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder
          addPropertiesBuilder() {
        return getPropertiesFieldBuilder()
            .addBuilder(
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder
          addPropertiesBuilder(int index) {
        return getPropertiesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of custom output properties to add to the finding.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property properties = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder>
          getPropertiesBuilderList() {
        return getPropertiesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property,
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder,
              com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.PropertyOrBuilder>
          getPropertiesFieldBuilder() {
        if (propertiesBuilder_ == null) {
          propertiesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property,
                  com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Property.Builder,
                  com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
                      .PropertyOrBuilder>(
                  properties_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          properties_ = null;
        }
        return propertiesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec)
    private static final com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec();
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomOutputSpec> PARSER =
        new com.google.protobuf.AbstractParser<CustomOutputSpec>() {
          @java.lang.Override
          public CustomOutputSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CustomOutputSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomOutputSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ResourceSelectorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.CustomConfig.ResourceSelector)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The resource types to run the detector on.
     * </pre>
     *
     * <code>repeated string resource_types = 1;</code>
     *
     * @return A list containing the resourceTypes.
     */
    java.util.List<java.lang.String> getResourceTypesList();
    /**
     *
     *
     * <pre>
     * The resource types to run the detector on.
     * </pre>
     *
     * <code>repeated string resource_types = 1;</code>
     *
     * @return The count of resourceTypes.
     */
    int getResourceTypesCount();
    /**
     *
     *
     * <pre>
     * The resource types to run the detector on.
     * </pre>
     *
     * <code>repeated string resource_types = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The resourceTypes at the given index.
     */
    java.lang.String getResourceTypes(int index);
    /**
     *
     *
     * <pre>
     * The resource types to run the detector on.
     * </pre>
     *
     * <code>repeated string resource_types = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourceTypes at the given index.
     */
    com.google.protobuf.ByteString getResourceTypesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Resource for selecting resource type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.CustomConfig.ResourceSelector}
   */
  public static final class ResourceSelector extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.CustomConfig.ResourceSelector)
      ResourceSelectorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ResourceSelector.newBuilder() to construct.
    private ResourceSelector(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResourceSelector() {
      resourceTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResourceSelector();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
          .internal_static_google_cloud_securitycenter_v1_CustomConfig_ResourceSelector_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
          .internal_static_google_cloud_securitycenter_v1_CustomConfig_ResourceSelector_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.class,
              com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.Builder.class);
    }

    public static final int RESOURCE_TYPES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList resourceTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The resource types to run the detector on.
     * </pre>
     *
     * <code>repeated string resource_types = 1;</code>
     *
     * @return A list containing the resourceTypes.
     */
    public com.google.protobuf.ProtocolStringList getResourceTypesList() {
      return resourceTypes_;
    }
    /**
     *
     *
     * <pre>
     * The resource types to run the detector on.
     * </pre>
     *
     * <code>repeated string resource_types = 1;</code>
     *
     * @return The count of resourceTypes.
     */
    public int getResourceTypesCount() {
      return resourceTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The resource types to run the detector on.
     * </pre>
     *
     * <code>repeated string resource_types = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The resourceTypes at the given index.
     */
    public java.lang.String getResourceTypes(int index) {
      return resourceTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The resource types to run the detector on.
     * </pre>
     *
     * <code>repeated string resource_types = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourceTypes at the given index.
     */
    public com.google.protobuf.ByteString getResourceTypesBytes(int index) {
      return resourceTypes_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < resourceTypes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceTypes_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < resourceTypes_.size(); i++) {
          dataSize += computeStringSizeNoTag(resourceTypes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getResourceTypesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector other =
          (com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector) obj;

      if (!getResourceTypesList().equals(other.getResourceTypesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getResourceTypesCount() > 0) {
        hash = (37 * hash) + RESOURCE_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + getResourceTypesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Resource for selecting resource type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.CustomConfig.ResourceSelector}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.CustomConfig.ResourceSelector)
        com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelectorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
            .internal_static_google_cloud_securitycenter_v1_CustomConfig_ResourceSelector_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
            .internal_static_google_cloud_securitycenter_v1_CustomConfig_ResourceSelector_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.class,
                com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.Builder.class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        resourceTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
            .internal_static_google_cloud_securitycenter_v1_CustomConfig_ResourceSelector_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector build() {
        com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector buildPartial() {
        com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector result =
            new com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          resourceTypes_.makeImmutable();
          result.resourceTypes_ = resourceTypes_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector other) {
        if (other
            == com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector
                .getDefaultInstance()) return this;
        if (!other.resourceTypes_.isEmpty()) {
          if (resourceTypes_.isEmpty()) {
            resourceTypes_ = other.resourceTypes_;
            bitField0_ |= 0x00000001;
          } else {
            ensureResourceTypesIsMutable();
            resourceTypes_.addAll(other.resourceTypes_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureResourceTypesIsMutable();
                  resourceTypes_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList resourceTypes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureResourceTypesIsMutable() {
        if (!resourceTypes_.isModifiable()) {
          resourceTypes_ = new com.google.protobuf.LazyStringArrayList(resourceTypes_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * The resource types to run the detector on.
       * </pre>
       *
       * <code>repeated string resource_types = 1;</code>
       *
       * @return A list containing the resourceTypes.
       */
      public com.google.protobuf.ProtocolStringList getResourceTypesList() {
        resourceTypes_.makeImmutable();
        return resourceTypes_;
      }
      /**
       *
       *
       * <pre>
       * The resource types to run the detector on.
       * </pre>
       *
       * <code>repeated string resource_types = 1;</code>
       *
       * @return The count of resourceTypes.
       */
      public int getResourceTypesCount() {
        return resourceTypes_.size();
      }
      /**
       *
       *
       * <pre>
       * The resource types to run the detector on.
       * </pre>
       *
       * <code>repeated string resource_types = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The resourceTypes at the given index.
       */
      public java.lang.String getResourceTypes(int index) {
        return resourceTypes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The resource types to run the detector on.
       * </pre>
       *
       * <code>repeated string resource_types = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the resourceTypes at the given index.
       */
      public com.google.protobuf.ByteString getResourceTypesBytes(int index) {
        return resourceTypes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The resource types to run the detector on.
       * </pre>
       *
       * <code>repeated string resource_types = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The resourceTypes to set.
       * @return This builder for chaining.
       */
      public Builder setResourceTypes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceTypesIsMutable();
        resourceTypes_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource types to run the detector on.
       * </pre>
       *
       * <code>repeated string resource_types = 1;</code>
       *
       * @param value The resourceTypes to add.
       * @return This builder for chaining.
       */
      public Builder addResourceTypes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceTypesIsMutable();
        resourceTypes_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource types to run the detector on.
       * </pre>
       *
       * <code>repeated string resource_types = 1;</code>
       *
       * @param values The resourceTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllResourceTypes(java.lang.Iterable<java.lang.String> values) {
        ensureResourceTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceTypes_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource types to run the detector on.
       * </pre>
       *
       * <code>repeated string resource_types = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceTypes() {
        resourceTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource types to run the detector on.
       * </pre>
       *
       * <code>repeated string resource_types = 1;</code>
       *
       * @param value The bytes of the resourceTypes to add.
       * @return This builder for chaining.
       */
      public Builder addResourceTypesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureResourceTypesIsMutable();
        resourceTypes_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.CustomConfig.ResourceSelector)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.CustomConfig.ResourceSelector)
    private static final com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector();
    }

    public static com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResourceSelector> PARSER =
        new com.google.protobuf.AbstractParser<ResourceSelector>() {
          @java.lang.Override
          public ResourceSelector parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResourceSelector> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResourceSelector> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PREDICATE_FIELD_NUMBER = 1;
  private com.google.type.Expr predicate_;
  /**
   *
   *
   * <pre>
   * The CEL expression to evaluate to produce findings. When the expression
   * evaluates to true against a resource, a finding is generated.
   * </pre>
   *
   * <code>.google.type.Expr predicate = 1;</code>
   *
   * @return Whether the predicate field is set.
   */
  @java.lang.Override
  public boolean hasPredicate() {
    return predicate_ != null;
  }
  /**
   *
   *
   * <pre>
   * The CEL expression to evaluate to produce findings. When the expression
   * evaluates to true against a resource, a finding is generated.
   * </pre>
   *
   * <code>.google.type.Expr predicate = 1;</code>
   *
   * @return The predicate.
   */
  @java.lang.Override
  public com.google.type.Expr getPredicate() {
    return predicate_ == null ? com.google.type.Expr.getDefaultInstance() : predicate_;
  }
  /**
   *
   *
   * <pre>
   * The CEL expression to evaluate to produce findings. When the expression
   * evaluates to true against a resource, a finding is generated.
   * </pre>
   *
   * <code>.google.type.Expr predicate = 1;</code>
   */
  @java.lang.Override
  public com.google.type.ExprOrBuilder getPredicateOrBuilder() {
    return predicate_ == null ? com.google.type.Expr.getDefaultInstance() : predicate_;
  }

  public static final int CUSTOM_OUTPUT_FIELD_NUMBER = 2;
  private com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec customOutput_;
  /**
   *
   *
   * <pre>
   * Custom output properties.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
   *
   * @return Whether the customOutput field is set.
   */
  @java.lang.Override
  public boolean hasCustomOutput() {
    return customOutput_ != null;
  }
  /**
   *
   *
   * <pre>
   * Custom output properties.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
   *
   * @return The customOutput.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec getCustomOutput() {
    return customOutput_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.getDefaultInstance()
        : customOutput_;
  }
  /**
   *
   *
   * <pre>
   * Custom output properties.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpecOrBuilder
      getCustomOutputOrBuilder() {
    return customOutput_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.getDefaultInstance()
        : customOutput_;
  }

  public static final int RESOURCE_SELECTOR_FIELD_NUMBER = 3;
  private com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resourceSelector_;
  /**
   *
   *
   * <pre>
   * The resource types that the custom module operates on. Each custom module
   * can specify up to 5 resource types.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
   * </code>
   *
   * @return Whether the resourceSelector field is set.
   */
  @java.lang.Override
  public boolean hasResourceSelector() {
    return resourceSelector_ != null;
  }
  /**
   *
   *
   * <pre>
   * The resource types that the custom module operates on. Each custom module
   * can specify up to 5 resource types.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
   * </code>
   *
   * @return The resourceSelector.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector getResourceSelector() {
    return resourceSelector_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.getDefaultInstance()
        : resourceSelector_;
  }
  /**
   *
   *
   * <pre>
   * The resource types that the custom module operates on. Each custom module
   * can specify up to 5 resource types.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelectorOrBuilder
      getResourceSelectorOrBuilder() {
    return resourceSelector_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.getDefaultInstance()
        : resourceSelector_;
  }

  public static final int SEVERITY_FIELD_NUMBER = 4;
  private int severity_ = 0;
  /**
   *
   *
   * <pre>
   * The severity to assign to findings generated by the module.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig.Severity severity = 4;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  @java.lang.Override
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * The severity to assign to findings generated by the module.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig.Severity severity = 4;</code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfig.Severity getSeverity() {
    com.google.cloud.securitycenter.v1.CustomConfig.Severity result =
        com.google.cloud.securitycenter.v1.CustomConfig.Severity.forNumber(severity_);
    return result == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.Severity.UNRECOGNIZED
        : result;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Text that describes the vulnerability or misconfiguration that the custom
   * module detects. This explanation is returned with each finding instance to
   * help investigators understand the detected issue. The text must be enclosed
   * in quotation marks.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Text that describes the vulnerability or misconfiguration that the custom
   * module detects. This explanation is returned with each finding instance to
   * help investigators understand the detected issue. The text must be enclosed
   * in quotation marks.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECOMMENDATION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object recommendation_ = "";
  /**
   *
   *
   * <pre>
   * An explanation of the recommended steps that security teams can take to
   * resolve the detected issue. This explanation is returned with each finding
   * generated by this module in the `nextSteps` property of the finding JSON.
   * </pre>
   *
   * <code>string recommendation = 6;</code>
   *
   * @return The recommendation.
   */
  @java.lang.Override
  public java.lang.String getRecommendation() {
    java.lang.Object ref = recommendation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      recommendation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An explanation of the recommended steps that security teams can take to
   * resolve the detected issue. This explanation is returned with each finding
   * generated by this module in the `nextSteps` property of the finding JSON.
   * </pre>
   *
   * <code>string recommendation = 6;</code>
   *
   * @return The bytes for recommendation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRecommendationBytes() {
    java.lang.Object ref = recommendation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      recommendation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (predicate_ != null) {
      output.writeMessage(1, getPredicate());
    }
    if (customOutput_ != null) {
      output.writeMessage(2, getCustomOutput());
    }
    if (resourceSelector_ != null) {
      output.writeMessage(3, getResourceSelector());
    }
    if (severity_
        != com.google.cloud.securitycenter.v1.CustomConfig.Severity.SEVERITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recommendation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, recommendation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (predicate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPredicate());
    }
    if (customOutput_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCustomOutput());
    }
    if (resourceSelector_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getResourceSelector());
    }
    if (severity_
        != com.google.cloud.securitycenter.v1.CustomConfig.Severity.SEVERITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recommendation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, recommendation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.CustomConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.CustomConfig other =
        (com.google.cloud.securitycenter.v1.CustomConfig) obj;

    if (hasPredicate() != other.hasPredicate()) return false;
    if (hasPredicate()) {
      if (!getPredicate().equals(other.getPredicate())) return false;
    }
    if (hasCustomOutput() != other.hasCustomOutput()) return false;
    if (hasCustomOutput()) {
      if (!getCustomOutput().equals(other.getCustomOutput())) return false;
    }
    if (hasResourceSelector() != other.hasResourceSelector()) return false;
    if (hasResourceSelector()) {
      if (!getResourceSelector().equals(other.getResourceSelector())) return false;
    }
    if (severity_ != other.severity_) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getRecommendation().equals(other.getRecommendation())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPredicate()) {
      hash = (37 * hash) + PREDICATE_FIELD_NUMBER;
      hash = (53 * hash) + getPredicate().hashCode();
    }
    if (hasCustomOutput()) {
      hash = (37 * hash) + CUSTOM_OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + getCustomOutput().hashCode();
    }
    if (hasResourceSelector()) {
      hash = (37 * hash) + RESOURCE_SELECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getResourceSelector().hashCode();
    }
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + RECOMMENDATION_FIELD_NUMBER;
    hash = (53 * hash) + getRecommendation().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.CustomConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines the properties in a custom module configuration for Security
   * Health Analytics. Use the custom module configuration to create custom
   * detectors that generate custom findings for resources that you specify.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.CustomConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.CustomConfig)
      com.google.cloud.securitycenter.v1.CustomConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
          .internal_static_google_cloud_securitycenter_v1_CustomConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
          .internal_static_google_cloud_securitycenter_v1_CustomConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.CustomConfig.class,
              com.google.cloud.securitycenter.v1.CustomConfig.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.CustomConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      predicate_ = null;
      if (predicateBuilder_ != null) {
        predicateBuilder_.dispose();
        predicateBuilder_ = null;
      }
      customOutput_ = null;
      if (customOutputBuilder_ != null) {
        customOutputBuilder_.dispose();
        customOutputBuilder_ = null;
      }
      resourceSelector_ = null;
      if (resourceSelectorBuilder_ != null) {
        resourceSelectorBuilder_.dispose();
        resourceSelectorBuilder_ = null;
      }
      severity_ = 0;
      description_ = "";
      recommendation_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomConfigProto
          .internal_static_google_cloud_securitycenter_v1_CustomConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.CustomConfig getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.CustomConfig build() {
      com.google.cloud.securitycenter.v1.CustomConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.CustomConfig buildPartial() {
      com.google.cloud.securitycenter.v1.CustomConfig result =
          new com.google.cloud.securitycenter.v1.CustomConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.CustomConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.predicate_ = predicateBuilder_ == null ? predicate_ : predicateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.customOutput_ =
            customOutputBuilder_ == null ? customOutput_ : customOutputBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resourceSelector_ =
            resourceSelectorBuilder_ == null ? resourceSelector_ : resourceSelectorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.severity_ = severity_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.recommendation_ = recommendation_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.CustomConfig) {
        return mergeFrom((com.google.cloud.securitycenter.v1.CustomConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.CustomConfig other) {
      if (other == com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance())
        return this;
      if (other.hasPredicate()) {
        mergePredicate(other.getPredicate());
      }
      if (other.hasCustomOutput()) {
        mergeCustomOutput(other.getCustomOutput());
      }
      if (other.hasResourceSelector()) {
        mergeResourceSelector(other.getResourceSelector());
      }
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getRecommendation().isEmpty()) {
        recommendation_ = other.recommendation_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPredicateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCustomOutputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getResourceSelectorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                severity_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                recommendation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.type.Expr predicate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
        predicateBuilder_;
    /**
     *
     *
     * <pre>
     * The CEL expression to evaluate to produce findings. When the expression
     * evaluates to true against a resource, a finding is generated.
     * </pre>
     *
     * <code>.google.type.Expr predicate = 1;</code>
     *
     * @return Whether the predicate field is set.
     */
    public boolean hasPredicate() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The CEL expression to evaluate to produce findings. When the expression
     * evaluates to true against a resource, a finding is generated.
     * </pre>
     *
     * <code>.google.type.Expr predicate = 1;</code>
     *
     * @return The predicate.
     */
    public com.google.type.Expr getPredicate() {
      if (predicateBuilder_ == null) {
        return predicate_ == null ? com.google.type.Expr.getDefaultInstance() : predicate_;
      } else {
        return predicateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The CEL expression to evaluate to produce findings. When the expression
     * evaluates to true against a resource, a finding is generated.
     * </pre>
     *
     * <code>.google.type.Expr predicate = 1;</code>
     */
    public Builder setPredicate(com.google.type.Expr value) {
      if (predicateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predicate_ = value;
      } else {
        predicateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CEL expression to evaluate to produce findings. When the expression
     * evaluates to true against a resource, a finding is generated.
     * </pre>
     *
     * <code>.google.type.Expr predicate = 1;</code>
     */
    public Builder setPredicate(com.google.type.Expr.Builder builderForValue) {
      if (predicateBuilder_ == null) {
        predicate_ = builderForValue.build();
      } else {
        predicateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CEL expression to evaluate to produce findings. When the expression
     * evaluates to true against a resource, a finding is generated.
     * </pre>
     *
     * <code>.google.type.Expr predicate = 1;</code>
     */
    public Builder mergePredicate(com.google.type.Expr value) {
      if (predicateBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && predicate_ != null
            && predicate_ != com.google.type.Expr.getDefaultInstance()) {
          getPredicateBuilder().mergeFrom(value);
        } else {
          predicate_ = value;
        }
      } else {
        predicateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CEL expression to evaluate to produce findings. When the expression
     * evaluates to true against a resource, a finding is generated.
     * </pre>
     *
     * <code>.google.type.Expr predicate = 1;</code>
     */
    public Builder clearPredicate() {
      bitField0_ = (bitField0_ & ~0x00000001);
      predicate_ = null;
      if (predicateBuilder_ != null) {
        predicateBuilder_.dispose();
        predicateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CEL expression to evaluate to produce findings. When the expression
     * evaluates to true against a resource, a finding is generated.
     * </pre>
     *
     * <code>.google.type.Expr predicate = 1;</code>
     */
    public com.google.type.Expr.Builder getPredicateBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPredicateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The CEL expression to evaluate to produce findings. When the expression
     * evaluates to true against a resource, a finding is generated.
     * </pre>
     *
     * <code>.google.type.Expr predicate = 1;</code>
     */
    public com.google.type.ExprOrBuilder getPredicateOrBuilder() {
      if (predicateBuilder_ != null) {
        return predicateBuilder_.getMessageOrBuilder();
      } else {
        return predicate_ == null ? com.google.type.Expr.getDefaultInstance() : predicate_;
      }
    }
    /**
     *
     *
     * <pre>
     * The CEL expression to evaluate to produce findings. When the expression
     * evaluates to true against a resource, a finding is generated.
     * </pre>
     *
     * <code>.google.type.Expr predicate = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
        getPredicateFieldBuilder() {
      if (predicateBuilder_ == null) {
        predicateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>(
                getPredicate(), getParentForChildren(), isClean());
        predicate_ = null;
      }
      return predicateBuilder_;
    }

    private com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec customOutput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec,
            com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Builder,
            com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpecOrBuilder>
        customOutputBuilder_;
    /**
     *
     *
     * <pre>
     * Custom output properties.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
     *
     * @return Whether the customOutput field is set.
     */
    public boolean hasCustomOutput() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Custom output properties.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
     *
     * @return The customOutput.
     */
    public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec getCustomOutput() {
      if (customOutputBuilder_ == null) {
        return customOutput_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.getDefaultInstance()
            : customOutput_;
      } else {
        return customOutputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom output properties.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
     */
    public Builder setCustomOutput(
        com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec value) {
      if (customOutputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customOutput_ = value;
      } else {
        customOutputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom output properties.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
     */
    public Builder setCustomOutput(
        com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Builder builderForValue) {
      if (customOutputBuilder_ == null) {
        customOutput_ = builderForValue.build();
      } else {
        customOutputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom output properties.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
     */
    public Builder mergeCustomOutput(
        com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec value) {
      if (customOutputBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && customOutput_ != null
            && customOutput_
                != com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec
                    .getDefaultInstance()) {
          getCustomOutputBuilder().mergeFrom(value);
        } else {
          customOutput_ = value;
        }
      } else {
        customOutputBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom output properties.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
     */
    public Builder clearCustomOutput() {
      bitField0_ = (bitField0_ & ~0x00000002);
      customOutput_ = null;
      if (customOutputBuilder_ != null) {
        customOutputBuilder_.dispose();
        customOutputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom output properties.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Builder
        getCustomOutputBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCustomOutputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Custom output properties.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpecOrBuilder
        getCustomOutputOrBuilder() {
      if (customOutputBuilder_ != null) {
        return customOutputBuilder_.getMessageOrBuilder();
      } else {
        return customOutput_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.getDefaultInstance()
            : customOutput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom output properties.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec custom_output = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec,
            com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Builder,
            com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpecOrBuilder>
        getCustomOutputFieldBuilder() {
      if (customOutputBuilder_ == null) {
        customOutputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec,
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpec.Builder,
                com.google.cloud.securitycenter.v1.CustomConfig.CustomOutputSpecOrBuilder>(
                getCustomOutput(), getParentForChildren(), isClean());
        customOutput_ = null;
      }
      return customOutputBuilder_;
    }

    private com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resourceSelector_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector,
            com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.Builder,
            com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelectorOrBuilder>
        resourceSelectorBuilder_;
    /**
     *
     *
     * <pre>
     * The resource types that the custom module operates on. Each custom module
     * can specify up to 5 resource types.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
     * </code>
     *
     * @return Whether the resourceSelector field is set.
     */
    public boolean hasResourceSelector() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The resource types that the custom module operates on. Each custom module
     * can specify up to 5 resource types.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
     * </code>
     *
     * @return The resourceSelector.
     */
    public com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector getResourceSelector() {
      if (resourceSelectorBuilder_ == null) {
        return resourceSelector_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.getDefaultInstance()
            : resourceSelector_;
      } else {
        return resourceSelectorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The resource types that the custom module operates on. Each custom module
     * can specify up to 5 resource types.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
     * </code>
     */
    public Builder setResourceSelector(
        com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector value) {
      if (resourceSelectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceSelector_ = value;
      } else {
        resourceSelectorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource types that the custom module operates on. Each custom module
     * can specify up to 5 resource types.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
     * </code>
     */
    public Builder setResourceSelector(
        com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.Builder builderForValue) {
      if (resourceSelectorBuilder_ == null) {
        resourceSelector_ = builderForValue.build();
      } else {
        resourceSelectorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource types that the custom module operates on. Each custom module
     * can specify up to 5 resource types.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
     * </code>
     */
    public Builder mergeResourceSelector(
        com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector value) {
      if (resourceSelectorBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && resourceSelector_ != null
            && resourceSelector_
                != com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector
                    .getDefaultInstance()) {
          getResourceSelectorBuilder().mergeFrom(value);
        } else {
          resourceSelector_ = value;
        }
      } else {
        resourceSelectorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource types that the custom module operates on. Each custom module
     * can specify up to 5 resource types.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
     * </code>
     */
    public Builder clearResourceSelector() {
      bitField0_ = (bitField0_ & ~0x00000004);
      resourceSelector_ = null;
      if (resourceSelectorBuilder_ != null) {
        resourceSelectorBuilder_.dispose();
        resourceSelectorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource types that the custom module operates on. Each custom module
     * can specify up to 5 resource types.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.Builder
        getResourceSelectorBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getResourceSelectorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The resource types that the custom module operates on. Each custom module
     * can specify up to 5 resource types.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelectorOrBuilder
        getResourceSelectorOrBuilder() {
      if (resourceSelectorBuilder_ != null) {
        return resourceSelectorBuilder_.getMessageOrBuilder();
      } else {
        return resourceSelector_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.getDefaultInstance()
            : resourceSelector_;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource types that the custom module operates on. Each custom module
     * can specify up to 5 resource types.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector resource_selector = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector,
            com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.Builder,
            com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelectorOrBuilder>
        getResourceSelectorFieldBuilder() {
      if (resourceSelectorBuilder_ == null) {
        resourceSelectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector,
                com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelector.Builder,
                com.google.cloud.securitycenter.v1.CustomConfig.ResourceSelectorOrBuilder>(
                getResourceSelector(), getParentForChildren(), isClean());
        resourceSelector_ = null;
      }
      return resourceSelectorBuilder_;
    }

    private int severity_ = 0;
    /**
     *
     *
     * <pre>
     * The severity to assign to findings generated by the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.Severity severity = 4;</code>
     *
     * @return The enum numeric value on the wire for severity.
     */
    @java.lang.Override
    public int getSeverityValue() {
      return severity_;
    }
    /**
     *
     *
     * <pre>
     * The severity to assign to findings generated by the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.Severity severity = 4;</code>
     *
     * @param value The enum numeric value on the wire for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityValue(int value) {
      severity_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The severity to assign to findings generated by the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.Severity severity = 4;</code>
     *
     * @return The severity.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.CustomConfig.Severity getSeverity() {
      com.google.cloud.securitycenter.v1.CustomConfig.Severity result =
          com.google.cloud.securitycenter.v1.CustomConfig.Severity.forNumber(severity_);
      return result == null
          ? com.google.cloud.securitycenter.v1.CustomConfig.Severity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The severity to assign to findings generated by the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.Severity severity = 4;</code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(com.google.cloud.securitycenter.v1.CustomConfig.Severity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      severity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The severity to assign to findings generated by the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig.Severity severity = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {
      bitField0_ = (bitField0_ & ~0x00000008);
      severity_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Text that describes the vulnerability or misconfiguration that the custom
     * module detects. This explanation is returned with each finding instance to
     * help investigators understand the detected issue. The text must be enclosed
     * in quotation marks.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Text that describes the vulnerability or misconfiguration that the custom
     * module detects. This explanation is returned with each finding instance to
     * help investigators understand the detected issue. The text must be enclosed
     * in quotation marks.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Text that describes the vulnerability or misconfiguration that the custom
     * module detects. This explanation is returned with each finding instance to
     * help investigators understand the detected issue. The text must be enclosed
     * in quotation marks.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text that describes the vulnerability or misconfiguration that the custom
     * module detects. This explanation is returned with each finding instance to
     * help investigators understand the detected issue. The text must be enclosed
     * in quotation marks.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text that describes the vulnerability or misconfiguration that the custom
     * module detects. This explanation is returned with each finding instance to
     * help investigators understand the detected issue. The text must be enclosed
     * in quotation marks.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object recommendation_ = "";
    /**
     *
     *
     * <pre>
     * An explanation of the recommended steps that security teams can take to
     * resolve the detected issue. This explanation is returned with each finding
     * generated by this module in the `nextSteps` property of the finding JSON.
     * </pre>
     *
     * <code>string recommendation = 6;</code>
     *
     * @return The recommendation.
     */
    public java.lang.String getRecommendation() {
      java.lang.Object ref = recommendation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recommendation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An explanation of the recommended steps that security teams can take to
     * resolve the detected issue. This explanation is returned with each finding
     * generated by this module in the `nextSteps` property of the finding JSON.
     * </pre>
     *
     * <code>string recommendation = 6;</code>
     *
     * @return The bytes for recommendation.
     */
    public com.google.protobuf.ByteString getRecommendationBytes() {
      java.lang.Object ref = recommendation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recommendation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An explanation of the recommended steps that security teams can take to
     * resolve the detected issue. This explanation is returned with each finding
     * generated by this module in the `nextSteps` property of the finding JSON.
     * </pre>
     *
     * <code>string recommendation = 6;</code>
     *
     * @param value The recommendation to set.
     * @return This builder for chaining.
     */
    public Builder setRecommendation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      recommendation_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An explanation of the recommended steps that security teams can take to
     * resolve the detected issue. This explanation is returned with each finding
     * generated by this module in the `nextSteps` property of the finding JSON.
     * </pre>
     *
     * <code>string recommendation = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecommendation() {
      recommendation_ = getDefaultInstance().getRecommendation();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An explanation of the recommended steps that security teams can take to
     * resolve the detected issue. This explanation is returned with each finding
     * generated by this module in the `nextSteps` property of the finding JSON.
     * </pre>
     *
     * <code>string recommendation = 6;</code>
     *
     * @param value The bytes for recommendation to set.
     * @return This builder for chaining.
     */
    public Builder setRecommendationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      recommendation_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.CustomConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.CustomConfig)
  private static final com.google.cloud.securitycenter.v1.CustomConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.CustomConfig();
  }

  public static com.google.cloud.securitycenter.v1.CustomConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomConfig> PARSER =
      new com.google.protobuf.AbstractParser<CustomConfig>() {
        @java.lang.Override
        public CustomConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
