/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/vulnerability.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * CVE stands for Common Vulnerabilities and Exposures.
 * More information: https://cve.mitre.org
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Cve}
 */
public final class Cve extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Cve)
    CveOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Cve.newBuilder() to construct.
  private Cve(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Cve() {
    id_ = "";
    references_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Cve();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.VulnerabilityProto
        .internal_static_google_cloud_securitycenter_v1_Cve_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.VulnerabilityProto
        .internal_static_google_cloud_securitycenter_v1_Cve_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Cve.class,
            com.google.cloud.securitycenter.v1.Cve.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier for the vulnerability. e.g. CVE-2021-34527
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier for the vulnerability. e.g. CVE-2021-34527
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REFERENCES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Reference> references_;
  /**
   *
   *
   * <pre>
   * Additional information about the CVE.
   * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Reference> getReferencesList() {
    return references_;
  }
  /**
   *
   *
   * <pre>
   * Additional information about the CVE.
   * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.ReferenceOrBuilder>
      getReferencesOrBuilderList() {
    return references_;
  }
  /**
   *
   *
   * <pre>
   * Additional information about the CVE.
   * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
   */
  @java.lang.Override
  public int getReferencesCount() {
    return references_.size();
  }
  /**
   *
   *
   * <pre>
   * Additional information about the CVE.
   * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Reference getReferences(int index) {
    return references_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Additional information about the CVE.
   * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ReferenceOrBuilder getReferencesOrBuilder(int index) {
    return references_.get(index);
  }

  public static final int CVSSV3_FIELD_NUMBER = 3;
  private com.google.cloud.securitycenter.v1.Cvssv3 cvssv3_;
  /**
   *
   *
   * <pre>
   * Describe Common Vulnerability Scoring System specified at
   * https://www.first.org/cvss/v3.1/specification-document
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
   *
   * @return Whether the cvssv3 field is set.
   */
  @java.lang.Override
  public boolean hasCvssv3() {
    return cvssv3_ != null;
  }
  /**
   *
   *
   * <pre>
   * Describe Common Vulnerability Scoring System specified at
   * https://www.first.org/cvss/v3.1/specification-document
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
   *
   * @return The cvssv3.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3 getCvssv3() {
    return cvssv3_ == null
        ? com.google.cloud.securitycenter.v1.Cvssv3.getDefaultInstance()
        : cvssv3_;
  }
  /**
   *
   *
   * <pre>
   * Describe Common Vulnerability Scoring System specified at
   * https://www.first.org/cvss/v3.1/specification-document
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3OrBuilder getCvssv3OrBuilder() {
    return cvssv3_ == null
        ? com.google.cloud.securitycenter.v1.Cvssv3.getDefaultInstance()
        : cvssv3_;
  }

  public static final int UPSTREAM_FIX_AVAILABLE_FIELD_NUMBER = 4;
  private boolean upstreamFixAvailable_ = false;
  /**
   *
   *
   * <pre>
   * Whether upstream fix is available for the CVE.
   * </pre>
   *
   * <code>bool upstream_fix_available = 4;</code>
   *
   * @return The upstreamFixAvailable.
   */
  @java.lang.Override
  public boolean getUpstreamFixAvailable() {
    return upstreamFixAvailable_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    for (int i = 0; i < references_.size(); i++) {
      output.writeMessage(2, references_.get(i));
    }
    if (cvssv3_ != null) {
      output.writeMessage(3, getCvssv3());
    }
    if (upstreamFixAvailable_ != false) {
      output.writeBool(4, upstreamFixAvailable_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    for (int i = 0; i < references_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, references_.get(i));
    }
    if (cvssv3_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCvssv3());
    }
    if (upstreamFixAvailable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, upstreamFixAvailable_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Cve)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Cve other = (com.google.cloud.securitycenter.v1.Cve) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getReferencesList().equals(other.getReferencesList())) return false;
    if (hasCvssv3() != other.hasCvssv3()) return false;
    if (hasCvssv3()) {
      if (!getCvssv3().equals(other.getCvssv3())) return false;
    }
    if (getUpstreamFixAvailable() != other.getUpstreamFixAvailable()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (getReferencesCount() > 0) {
      hash = (37 * hash) + REFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getReferencesList().hashCode();
    }
    if (hasCvssv3()) {
      hash = (37 * hash) + CVSSV3_FIELD_NUMBER;
      hash = (53 * hash) + getCvssv3().hashCode();
    }
    hash = (37 * hash) + UPSTREAM_FIX_AVAILABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUpstreamFixAvailable());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Cve parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Cve prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CVE stands for Common Vulnerabilities and Exposures.
   * More information: https://cve.mitre.org
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Cve}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Cve)
      com.google.cloud.securitycenter.v1.CveOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.VulnerabilityProto
          .internal_static_google_cloud_securitycenter_v1_Cve_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.VulnerabilityProto
          .internal_static_google_cloud_securitycenter_v1_Cve_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Cve.class,
              com.google.cloud.securitycenter.v1.Cve.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Cve.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      if (referencesBuilder_ == null) {
        references_ = java.util.Collections.emptyList();
      } else {
        references_ = null;
        referencesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      cvssv3_ = null;
      if (cvssv3Builder_ != null) {
        cvssv3Builder_.dispose();
        cvssv3Builder_ = null;
      }
      upstreamFixAvailable_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.VulnerabilityProto
          .internal_static_google_cloud_securitycenter_v1_Cve_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cve getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Cve.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cve build() {
      com.google.cloud.securitycenter.v1.Cve result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cve buildPartial() {
      com.google.cloud.securitycenter.v1.Cve result =
          new com.google.cloud.securitycenter.v1.Cve(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.securitycenter.v1.Cve result) {
      if (referencesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          references_ = java.util.Collections.unmodifiableList(references_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.references_ = references_;
      } else {
        result.references_ = referencesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Cve result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cvssv3_ = cvssv3Builder_ == null ? cvssv3_ : cvssv3Builder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.upstreamFixAvailable_ = upstreamFixAvailable_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Cve) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Cve) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Cve other) {
      if (other == com.google.cloud.securitycenter.v1.Cve.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (referencesBuilder_ == null) {
        if (!other.references_.isEmpty()) {
          if (references_.isEmpty()) {
            references_ = other.references_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureReferencesIsMutable();
            references_.addAll(other.references_);
          }
          onChanged();
        }
      } else {
        if (!other.references_.isEmpty()) {
          if (referencesBuilder_.isEmpty()) {
            referencesBuilder_.dispose();
            referencesBuilder_ = null;
            references_ = other.references_;
            bitField0_ = (bitField0_ & ~0x00000002);
            referencesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReferencesFieldBuilder()
                    : null;
          } else {
            referencesBuilder_.addAllMessages(other.references_);
          }
        }
      }
      if (other.hasCvssv3()) {
        mergeCvssv3(other.getCvssv3());
      }
      if (other.getUpstreamFixAvailable() != false) {
        setUpstreamFixAvailable(other.getUpstreamFixAvailable());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.securitycenter.v1.Reference m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Reference.parser(), extensionRegistry);
                if (referencesBuilder_ == null) {
                  ensureReferencesIsMutable();
                  references_.add(m);
                } else {
                  referencesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCvssv3FieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                upstreamFixAvailable_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier for the vulnerability. e.g. CVE-2021-34527
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier for the vulnerability. e.g. CVE-2021-34527
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier for the vulnerability. e.g. CVE-2021-34527
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier for the vulnerability. e.g. CVE-2021-34527
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier for the vulnerability. e.g. CVE-2021-34527
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Reference> references_ =
        java.util.Collections.emptyList();

    private void ensureReferencesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        references_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Reference>(references_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Reference,
            com.google.cloud.securitycenter.v1.Reference.Builder,
            com.google.cloud.securitycenter.v1.ReferenceOrBuilder>
        referencesBuilder_;

    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Reference> getReferencesList() {
      if (referencesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(references_);
      } else {
        return referencesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public int getReferencesCount() {
      if (referencesBuilder_ == null) {
        return references_.size();
      } else {
        return referencesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Reference getReferences(int index) {
      if (referencesBuilder_ == null) {
        return references_.get(index);
      } else {
        return referencesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public Builder setReferences(int index, com.google.cloud.securitycenter.v1.Reference value) {
      if (referencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReferencesIsMutable();
        references_.set(index, value);
        onChanged();
      } else {
        referencesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public Builder setReferences(
        int index, com.google.cloud.securitycenter.v1.Reference.Builder builderForValue) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        references_.set(index, builderForValue.build());
        onChanged();
      } else {
        referencesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public Builder addReferences(com.google.cloud.securitycenter.v1.Reference value) {
      if (referencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReferencesIsMutable();
        references_.add(value);
        onChanged();
      } else {
        referencesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public Builder addReferences(int index, com.google.cloud.securitycenter.v1.Reference value) {
      if (referencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReferencesIsMutable();
        references_.add(index, value);
        onChanged();
      } else {
        referencesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public Builder addReferences(
        com.google.cloud.securitycenter.v1.Reference.Builder builderForValue) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        references_.add(builderForValue.build());
        onChanged();
      } else {
        referencesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public Builder addReferences(
        int index, com.google.cloud.securitycenter.v1.Reference.Builder builderForValue) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        references_.add(index, builderForValue.build());
        onChanged();
      } else {
        referencesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public Builder addAllReferences(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Reference> values) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, references_);
        onChanged();
      } else {
        referencesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public Builder clearReferences() {
      if (referencesBuilder_ == null) {
        references_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        referencesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public Builder removeReferences(int index) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        references_.remove(index);
        onChanged();
      } else {
        referencesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Reference.Builder getReferencesBuilder(int index) {
      return getReferencesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.ReferenceOrBuilder getReferencesOrBuilder(int index) {
      if (referencesBuilder_ == null) {
        return references_.get(index);
      } else {
        return referencesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.ReferenceOrBuilder>
        getReferencesOrBuilderList() {
      if (referencesBuilder_ != null) {
        return referencesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(references_);
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Reference.Builder addReferencesBuilder() {
      return getReferencesFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Reference.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Reference.Builder addReferencesBuilder(int index) {
      return getReferencesFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.Reference.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Additional information about the CVE.
     * e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Reference references = 2;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Reference.Builder>
        getReferencesBuilderList() {
      return getReferencesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Reference,
            com.google.cloud.securitycenter.v1.Reference.Builder,
            com.google.cloud.securitycenter.v1.ReferenceOrBuilder>
        getReferencesFieldBuilder() {
      if (referencesBuilder_ == null) {
        referencesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Reference,
                com.google.cloud.securitycenter.v1.Reference.Builder,
                com.google.cloud.securitycenter.v1.ReferenceOrBuilder>(
                references_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        references_ = null;
      }
      return referencesBuilder_;
    }

    private com.google.cloud.securitycenter.v1.Cvssv3 cvssv3_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Cvssv3,
            com.google.cloud.securitycenter.v1.Cvssv3.Builder,
            com.google.cloud.securitycenter.v1.Cvssv3OrBuilder>
        cvssv3Builder_;
    /**
     *
     *
     * <pre>
     * Describe Common Vulnerability Scoring System specified at
     * https://www.first.org/cvss/v3.1/specification-document
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
     *
     * @return Whether the cvssv3 field is set.
     */
    public boolean hasCvssv3() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Describe Common Vulnerability Scoring System specified at
     * https://www.first.org/cvss/v3.1/specification-document
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
     *
     * @return The cvssv3.
     */
    public com.google.cloud.securitycenter.v1.Cvssv3 getCvssv3() {
      if (cvssv3Builder_ == null) {
        return cvssv3_ == null
            ? com.google.cloud.securitycenter.v1.Cvssv3.getDefaultInstance()
            : cvssv3_;
      } else {
        return cvssv3Builder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Describe Common Vulnerability Scoring System specified at
     * https://www.first.org/cvss/v3.1/specification-document
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
     */
    public Builder setCvssv3(com.google.cloud.securitycenter.v1.Cvssv3 value) {
      if (cvssv3Builder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cvssv3_ = value;
      } else {
        cvssv3Builder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe Common Vulnerability Scoring System specified at
     * https://www.first.org/cvss/v3.1/specification-document
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
     */
    public Builder setCvssv3(com.google.cloud.securitycenter.v1.Cvssv3.Builder builderForValue) {
      if (cvssv3Builder_ == null) {
        cvssv3_ = builderForValue.build();
      } else {
        cvssv3Builder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe Common Vulnerability Scoring System specified at
     * https://www.first.org/cvss/v3.1/specification-document
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
     */
    public Builder mergeCvssv3(com.google.cloud.securitycenter.v1.Cvssv3 value) {
      if (cvssv3Builder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && cvssv3_ != null
            && cvssv3_ != com.google.cloud.securitycenter.v1.Cvssv3.getDefaultInstance()) {
          getCvssv3Builder().mergeFrom(value);
        } else {
          cvssv3_ = value;
        }
      } else {
        cvssv3Builder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe Common Vulnerability Scoring System specified at
     * https://www.first.org/cvss/v3.1/specification-document
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
     */
    public Builder clearCvssv3() {
      bitField0_ = (bitField0_ & ~0x00000004);
      cvssv3_ = null;
      if (cvssv3Builder_ != null) {
        cvssv3Builder_.dispose();
        cvssv3Builder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe Common Vulnerability Scoring System specified at
     * https://www.first.org/cvss/v3.1/specification-document
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.Cvssv3.Builder getCvssv3Builder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCvssv3FieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describe Common Vulnerability Scoring System specified at
     * https://www.first.org/cvss/v3.1/specification-document
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.Cvssv3OrBuilder getCvssv3OrBuilder() {
      if (cvssv3Builder_ != null) {
        return cvssv3Builder_.getMessageOrBuilder();
      } else {
        return cvssv3_ == null
            ? com.google.cloud.securitycenter.v1.Cvssv3.getDefaultInstance()
            : cvssv3_;
      }
    }
    /**
     *
     *
     * <pre>
     * Describe Common Vulnerability Scoring System specified at
     * https://www.first.org/cvss/v3.1/specification-document
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3 cvssv3 = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Cvssv3,
            com.google.cloud.securitycenter.v1.Cvssv3.Builder,
            com.google.cloud.securitycenter.v1.Cvssv3OrBuilder>
        getCvssv3FieldBuilder() {
      if (cvssv3Builder_ == null) {
        cvssv3Builder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Cvssv3,
                com.google.cloud.securitycenter.v1.Cvssv3.Builder,
                com.google.cloud.securitycenter.v1.Cvssv3OrBuilder>(
                getCvssv3(), getParentForChildren(), isClean());
        cvssv3_ = null;
      }
      return cvssv3Builder_;
    }

    private boolean upstreamFixAvailable_;
    /**
     *
     *
     * <pre>
     * Whether upstream fix is available for the CVE.
     * </pre>
     *
     * <code>bool upstream_fix_available = 4;</code>
     *
     * @return The upstreamFixAvailable.
     */
    @java.lang.Override
    public boolean getUpstreamFixAvailable() {
      return upstreamFixAvailable_;
    }
    /**
     *
     *
     * <pre>
     * Whether upstream fix is available for the CVE.
     * </pre>
     *
     * <code>bool upstream_fix_available = 4;</code>
     *
     * @param value The upstreamFixAvailable to set.
     * @return This builder for chaining.
     */
    public Builder setUpstreamFixAvailable(boolean value) {

      upstreamFixAvailable_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether upstream fix is available for the CVE.
     * </pre>
     *
     * <code>bool upstream_fix_available = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpstreamFixAvailable() {
      bitField0_ = (bitField0_ & ~0x00000008);
      upstreamFixAvailable_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Cve)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Cve)
  private static final com.google.cloud.securitycenter.v1.Cve DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Cve();
  }

  public static com.google.cloud.securitycenter.v1.Cve getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Cve> PARSER =
      new com.google.protobuf.AbstractParser<Cve>() {
        @java.lang.Override
        public Cve parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Cve> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Cve> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cve getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
