/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/vulnerability.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Common Vulnerability Scoring System version 3.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Cvssv3}
 */
public final class Cvssv3 extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Cvssv3)
    Cvssv3OrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Cvssv3.newBuilder() to construct.
  private Cvssv3(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Cvssv3() {
    attackVector_ = 0;
    attackComplexity_ = 0;
    privilegesRequired_ = 0;
    userInteraction_ = 0;
    scope_ = 0;
    confidentialityImpact_ = 0;
    integrityImpact_ = 0;
    availabilityImpact_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Cvssv3();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.VulnerabilityProto
        .internal_static_google_cloud_securitycenter_v1_Cvssv3_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.VulnerabilityProto
        .internal_static_google_cloud_securitycenter_v1_Cvssv3_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Cvssv3.class,
            com.google.cloud.securitycenter.v1.Cvssv3.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * This metric reflects the context by which vulnerability exploitation is
   * possible.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Cvssv3.AttackVector}
   */
  public enum AttackVector implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>ATTACK_VECTOR_UNSPECIFIED = 0;</code>
     */
    ATTACK_VECTOR_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The vulnerable component is bound to the network stack and the set of
     * possible attackers extends beyond the other options listed below, up to
     * and including the entire Internet.
     * </pre>
     *
     * <code>ATTACK_VECTOR_NETWORK = 1;</code>
     */
    ATTACK_VECTOR_NETWORK(1),
    /**
     *
     *
     * <pre>
     * The vulnerable component is bound to the network stack, but the attack is
     * limited at the protocol level to a logically adjacent topology.
     * </pre>
     *
     * <code>ATTACK_VECTOR_ADJACENT = 2;</code>
     */
    ATTACK_VECTOR_ADJACENT(2),
    /**
     *
     *
     * <pre>
     * The vulnerable component is not bound to the network stack and the
     * attacker's path is via read/write/execute capabilities.
     * </pre>
     *
     * <code>ATTACK_VECTOR_LOCAL = 3;</code>
     */
    ATTACK_VECTOR_LOCAL(3),
    /**
     *
     *
     * <pre>
     * The attack requires the attacker to physically touch or manipulate the
     * vulnerable component.
     * </pre>
     *
     * <code>ATTACK_VECTOR_PHYSICAL = 4;</code>
     */
    ATTACK_VECTOR_PHYSICAL(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>ATTACK_VECTOR_UNSPECIFIED = 0;</code>
     */
    public static final int ATTACK_VECTOR_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The vulnerable component is bound to the network stack and the set of
     * possible attackers extends beyond the other options listed below, up to
     * and including the entire Internet.
     * </pre>
     *
     * <code>ATTACK_VECTOR_NETWORK = 1;</code>
     */
    public static final int ATTACK_VECTOR_NETWORK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The vulnerable component is bound to the network stack, but the attack is
     * limited at the protocol level to a logically adjacent topology.
     * </pre>
     *
     * <code>ATTACK_VECTOR_ADJACENT = 2;</code>
     */
    public static final int ATTACK_VECTOR_ADJACENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The vulnerable component is not bound to the network stack and the
     * attacker's path is via read/write/execute capabilities.
     * </pre>
     *
     * <code>ATTACK_VECTOR_LOCAL = 3;</code>
     */
    public static final int ATTACK_VECTOR_LOCAL_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The attack requires the attacker to physically touch or manipulate the
     * vulnerable component.
     * </pre>
     *
     * <code>ATTACK_VECTOR_PHYSICAL = 4;</code>
     */
    public static final int ATTACK_VECTOR_PHYSICAL_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AttackVector valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AttackVector forNumber(int value) {
      switch (value) {
        case 0:
          return ATTACK_VECTOR_UNSPECIFIED;
        case 1:
          return ATTACK_VECTOR_NETWORK;
        case 2:
          return ATTACK_VECTOR_ADJACENT;
        case 3:
          return ATTACK_VECTOR_LOCAL;
        case 4:
          return ATTACK_VECTOR_PHYSICAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AttackVector> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AttackVector> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AttackVector>() {
          public AttackVector findValueByNumber(int number) {
            return AttackVector.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Cvssv3.getDescriptor().getEnumTypes().get(0);
    }

    private static final AttackVector[] VALUES = values();

    public static AttackVector valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AttackVector(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Cvssv3.AttackVector)
  }

  /**
   *
   *
   * <pre>
   * This metric describes the conditions beyond the attacker's control that
   * must exist in order to exploit the vulnerability.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Cvssv3.AttackComplexity}
   */
  public enum AttackComplexity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>ATTACK_COMPLEXITY_UNSPECIFIED = 0;</code>
     */
    ATTACK_COMPLEXITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Specialized access conditions or extenuating circumstances do not exist.
     * An attacker can expect repeatable success when attacking the vulnerable
     * component.
     * </pre>
     *
     * <code>ATTACK_COMPLEXITY_LOW = 1;</code>
     */
    ATTACK_COMPLEXITY_LOW(1),
    /**
     *
     *
     * <pre>
     * A successful attack depends on conditions beyond the attacker's control.
     * That is, a successful attack cannot be accomplished at will, but requires
     * the attacker to invest in some measurable amount of effort in preparation
     * or execution against the vulnerable component before a successful attack
     * can be expected.
     * </pre>
     *
     * <code>ATTACK_COMPLEXITY_HIGH = 2;</code>
     */
    ATTACK_COMPLEXITY_HIGH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>ATTACK_COMPLEXITY_UNSPECIFIED = 0;</code>
     */
    public static final int ATTACK_COMPLEXITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Specialized access conditions or extenuating circumstances do not exist.
     * An attacker can expect repeatable success when attacking the vulnerable
     * component.
     * </pre>
     *
     * <code>ATTACK_COMPLEXITY_LOW = 1;</code>
     */
    public static final int ATTACK_COMPLEXITY_LOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A successful attack depends on conditions beyond the attacker's control.
     * That is, a successful attack cannot be accomplished at will, but requires
     * the attacker to invest in some measurable amount of effort in preparation
     * or execution against the vulnerable component before a successful attack
     * can be expected.
     * </pre>
     *
     * <code>ATTACK_COMPLEXITY_HIGH = 2;</code>
     */
    public static final int ATTACK_COMPLEXITY_HIGH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AttackComplexity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AttackComplexity forNumber(int value) {
      switch (value) {
        case 0:
          return ATTACK_COMPLEXITY_UNSPECIFIED;
        case 1:
          return ATTACK_COMPLEXITY_LOW;
        case 2:
          return ATTACK_COMPLEXITY_HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AttackComplexity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AttackComplexity>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AttackComplexity>() {
              public AttackComplexity findValueByNumber(int number) {
                return AttackComplexity.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Cvssv3.getDescriptor().getEnumTypes().get(1);
    }

    private static final AttackComplexity[] VALUES = values();

    public static AttackComplexity valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AttackComplexity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Cvssv3.AttackComplexity)
  }

  /**
   *
   *
   * <pre>
   * This metric describes the level of privileges an attacker must possess
   * before successfully exploiting the vulnerability.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired}
   */
  public enum PrivilegesRequired implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>PRIVILEGES_REQUIRED_UNSPECIFIED = 0;</code>
     */
    PRIVILEGES_REQUIRED_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The attacker is unauthorized prior to attack, and therefore does not
     * require any access to settings or files of the vulnerable system to
     * carry out an attack.
     * </pre>
     *
     * <code>PRIVILEGES_REQUIRED_NONE = 1;</code>
     */
    PRIVILEGES_REQUIRED_NONE(1),
    /**
     *
     *
     * <pre>
     * The attacker requires privileges that provide basic user capabilities
     * that could normally affect only settings and files owned by a user.
     * Alternatively, an attacker with Low privileges has the ability to access
     * only non-sensitive resources.
     * </pre>
     *
     * <code>PRIVILEGES_REQUIRED_LOW = 2;</code>
     */
    PRIVILEGES_REQUIRED_LOW(2),
    /**
     *
     *
     * <pre>
     * The attacker requires privileges that provide significant (e.g.,
     * administrative) control over the vulnerable component allowing access to
     * component-wide settings and files.
     * </pre>
     *
     * <code>PRIVILEGES_REQUIRED_HIGH = 3;</code>
     */
    PRIVILEGES_REQUIRED_HIGH(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>PRIVILEGES_REQUIRED_UNSPECIFIED = 0;</code>
     */
    public static final int PRIVILEGES_REQUIRED_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The attacker is unauthorized prior to attack, and therefore does not
     * require any access to settings or files of the vulnerable system to
     * carry out an attack.
     * </pre>
     *
     * <code>PRIVILEGES_REQUIRED_NONE = 1;</code>
     */
    public static final int PRIVILEGES_REQUIRED_NONE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The attacker requires privileges that provide basic user capabilities
     * that could normally affect only settings and files owned by a user.
     * Alternatively, an attacker with Low privileges has the ability to access
     * only non-sensitive resources.
     * </pre>
     *
     * <code>PRIVILEGES_REQUIRED_LOW = 2;</code>
     */
    public static final int PRIVILEGES_REQUIRED_LOW_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The attacker requires privileges that provide significant (e.g.,
     * administrative) control over the vulnerable component allowing access to
     * component-wide settings and files.
     * </pre>
     *
     * <code>PRIVILEGES_REQUIRED_HIGH = 3;</code>
     */
    public static final int PRIVILEGES_REQUIRED_HIGH_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PrivilegesRequired valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PrivilegesRequired forNumber(int value) {
      switch (value) {
        case 0:
          return PRIVILEGES_REQUIRED_UNSPECIFIED;
        case 1:
          return PRIVILEGES_REQUIRED_NONE;
        case 2:
          return PRIVILEGES_REQUIRED_LOW;
        case 3:
          return PRIVILEGES_REQUIRED_HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PrivilegesRequired>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PrivilegesRequired>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PrivilegesRequired>() {
              public PrivilegesRequired findValueByNumber(int number) {
                return PrivilegesRequired.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Cvssv3.getDescriptor().getEnumTypes().get(2);
    }

    private static final PrivilegesRequired[] VALUES = values();

    public static PrivilegesRequired valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PrivilegesRequired(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired)
  }

  /**
   *
   *
   * <pre>
   * This metric captures the requirement for a human user, other than the
   * attacker, to participate in the successful compromise of the vulnerable
   * component.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Cvssv3.UserInteraction}
   */
  public enum UserInteraction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>USER_INTERACTION_UNSPECIFIED = 0;</code>
     */
    USER_INTERACTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The vulnerable system can be exploited without interaction from any user.
     * </pre>
     *
     * <code>USER_INTERACTION_NONE = 1;</code>
     */
    USER_INTERACTION_NONE(1),
    /**
     *
     *
     * <pre>
     * Successful exploitation of this vulnerability requires a user to take
     * some action before the vulnerability can be exploited.
     * </pre>
     *
     * <code>USER_INTERACTION_REQUIRED = 2;</code>
     */
    USER_INTERACTION_REQUIRED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>USER_INTERACTION_UNSPECIFIED = 0;</code>
     */
    public static final int USER_INTERACTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The vulnerable system can be exploited without interaction from any user.
     * </pre>
     *
     * <code>USER_INTERACTION_NONE = 1;</code>
     */
    public static final int USER_INTERACTION_NONE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Successful exploitation of this vulnerability requires a user to take
     * some action before the vulnerability can be exploited.
     * </pre>
     *
     * <code>USER_INTERACTION_REQUIRED = 2;</code>
     */
    public static final int USER_INTERACTION_REQUIRED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UserInteraction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static UserInteraction forNumber(int value) {
      switch (value) {
        case 0:
          return USER_INTERACTION_UNSPECIFIED;
        case 1:
          return USER_INTERACTION_NONE;
        case 2:
          return USER_INTERACTION_REQUIRED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<UserInteraction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<UserInteraction>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<UserInteraction>() {
              public UserInteraction findValueByNumber(int number) {
                return UserInteraction.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Cvssv3.getDescriptor().getEnumTypes().get(3);
    }

    private static final UserInteraction[] VALUES = values();

    public static UserInteraction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private UserInteraction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Cvssv3.UserInteraction)
  }

  /**
   *
   *
   * <pre>
   * The Scope metric captures whether a vulnerability in one vulnerable
   * component impacts resources in components beyond its security scope.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Cvssv3.Scope}
   */
  public enum Scope implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>SCOPE_UNSPECIFIED = 0;</code>
     */
    SCOPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * An exploited vulnerability can only affect resources managed by the same
     * security authority.
     * </pre>
     *
     * <code>SCOPE_UNCHANGED = 1;</code>
     */
    SCOPE_UNCHANGED(1),
    /**
     *
     *
     * <pre>
     * An exploited vulnerability can affect resources beyond the security scope
     * managed by the security authority of the vulnerable component.
     * </pre>
     *
     * <code>SCOPE_CHANGED = 2;</code>
     */
    SCOPE_CHANGED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>SCOPE_UNSPECIFIED = 0;</code>
     */
    public static final int SCOPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * An exploited vulnerability can only affect resources managed by the same
     * security authority.
     * </pre>
     *
     * <code>SCOPE_UNCHANGED = 1;</code>
     */
    public static final int SCOPE_UNCHANGED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * An exploited vulnerability can affect resources beyond the security scope
     * managed by the security authority of the vulnerable component.
     * </pre>
     *
     * <code>SCOPE_CHANGED = 2;</code>
     */
    public static final int SCOPE_CHANGED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Scope valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Scope forNumber(int value) {
      switch (value) {
        case 0:
          return SCOPE_UNSPECIFIED;
        case 1:
          return SCOPE_UNCHANGED;
        case 2:
          return SCOPE_CHANGED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Scope> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Scope> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Scope>() {
          public Scope findValueByNumber(int number) {
            return Scope.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Cvssv3.getDescriptor().getEnumTypes().get(4);
    }

    private static final Scope[] VALUES = values();

    public static Scope valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Scope(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Cvssv3.Scope)
  }

  /**
   *
   *
   * <pre>
   * The Impact metrics capture the effects of a successfully exploited
   * vulnerability on the component that suffers the worst outcome that is most
   * directly and predictably associated with the attack.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Cvssv3.Impact}
   */
  public enum Impact implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>IMPACT_UNSPECIFIED = 0;</code>
     */
    IMPACT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * High impact.
     * </pre>
     *
     * <code>IMPACT_HIGH = 1;</code>
     */
    IMPACT_HIGH(1),
    /**
     *
     *
     * <pre>
     * Low impact.
     * </pre>
     *
     * <code>IMPACT_LOW = 2;</code>
     */
    IMPACT_LOW(2),
    /**
     *
     *
     * <pre>
     * No impact.
     * </pre>
     *
     * <code>IMPACT_NONE = 3;</code>
     */
    IMPACT_NONE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value.
     * </pre>
     *
     * <code>IMPACT_UNSPECIFIED = 0;</code>
     */
    public static final int IMPACT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * High impact.
     * </pre>
     *
     * <code>IMPACT_HIGH = 1;</code>
     */
    public static final int IMPACT_HIGH_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Low impact.
     * </pre>
     *
     * <code>IMPACT_LOW = 2;</code>
     */
    public static final int IMPACT_LOW_VALUE = 2;
    /**
     *
     *
     * <pre>
     * No impact.
     * </pre>
     *
     * <code>IMPACT_NONE = 3;</code>
     */
    public static final int IMPACT_NONE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Impact valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Impact forNumber(int value) {
      switch (value) {
        case 0:
          return IMPACT_UNSPECIFIED;
        case 1:
          return IMPACT_HIGH;
        case 2:
          return IMPACT_LOW;
        case 3:
          return IMPACT_NONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Impact> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Impact> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Impact>() {
          public Impact findValueByNumber(int number) {
            return Impact.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Cvssv3.getDescriptor().getEnumTypes().get(5);
    }

    private static final Impact[] VALUES = values();

    public static Impact valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Impact(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Cvssv3.Impact)
  }

  public static final int BASE_SCORE_FIELD_NUMBER = 1;
  private double baseScore_ = 0D;
  /**
   *
   *
   * <pre>
   * The base score is a function of the base metric scores.
   * </pre>
   *
   * <code>double base_score = 1;</code>
   *
   * @return The baseScore.
   */
  @java.lang.Override
  public double getBaseScore() {
    return baseScore_;
  }

  public static final int ATTACK_VECTOR_FIELD_NUMBER = 5;
  private int attackVector_ = 0;
  /**
   *
   *
   * <pre>
   * Base Metrics
   * Represents the intrinsic characteristics of a vulnerability that are
   * constant over time and across user environments.
   * This metric reflects the context by which vulnerability exploitation is
   * possible.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackVector attack_vector = 5;</code>
   *
   * @return The enum numeric value on the wire for attackVector.
   */
  @java.lang.Override
  public int getAttackVectorValue() {
    return attackVector_;
  }
  /**
   *
   *
   * <pre>
   * Base Metrics
   * Represents the intrinsic characteristics of a vulnerability that are
   * constant over time and across user environments.
   * This metric reflects the context by which vulnerability exploitation is
   * possible.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackVector attack_vector = 5;</code>
   *
   * @return The attackVector.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3.AttackVector getAttackVector() {
    com.google.cloud.securitycenter.v1.Cvssv3.AttackVector result =
        com.google.cloud.securitycenter.v1.Cvssv3.AttackVector.forNumber(attackVector_);
    return result == null
        ? com.google.cloud.securitycenter.v1.Cvssv3.AttackVector.UNRECOGNIZED
        : result;
  }

  public static final int ATTACK_COMPLEXITY_FIELD_NUMBER = 6;
  private int attackComplexity_ = 0;
  /**
   *
   *
   * <pre>
   * This metric describes the conditions beyond the attacker's control that
   * must exist in order to exploit the vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity attack_complexity = 6;</code>
   *
   * @return The enum numeric value on the wire for attackComplexity.
   */
  @java.lang.Override
  public int getAttackComplexityValue() {
    return attackComplexity_;
  }
  /**
   *
   *
   * <pre>
   * This metric describes the conditions beyond the attacker's control that
   * must exist in order to exploit the vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity attack_complexity = 6;</code>
   *
   * @return The attackComplexity.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity getAttackComplexity() {
    com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity result =
        com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity.forNumber(attackComplexity_);
    return result == null
        ? com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity.UNRECOGNIZED
        : result;
  }

  public static final int PRIVILEGES_REQUIRED_FIELD_NUMBER = 7;
  private int privilegesRequired_ = 0;
  /**
   *
   *
   * <pre>
   * This metric describes the level of privileges an attacker must possess
   * before successfully exploiting the vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired privileges_required = 7;</code>
   *
   * @return The enum numeric value on the wire for privilegesRequired.
   */
  @java.lang.Override
  public int getPrivilegesRequiredValue() {
    return privilegesRequired_;
  }
  /**
   *
   *
   * <pre>
   * This metric describes the level of privileges an attacker must possess
   * before successfully exploiting the vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired privileges_required = 7;</code>
   *
   * @return The privilegesRequired.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired getPrivilegesRequired() {
    com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired result =
        com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired.forNumber(privilegesRequired_);
    return result == null
        ? com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired.UNRECOGNIZED
        : result;
  }

  public static final int USER_INTERACTION_FIELD_NUMBER = 8;
  private int userInteraction_ = 0;
  /**
   *
   *
   * <pre>
   * This metric captures the requirement for a human user, other than the
   * attacker, to participate in the successful compromise of the vulnerable
   * component.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.UserInteraction user_interaction = 8;</code>
   *
   * @return The enum numeric value on the wire for userInteraction.
   */
  @java.lang.Override
  public int getUserInteractionValue() {
    return userInteraction_;
  }
  /**
   *
   *
   * <pre>
   * This metric captures the requirement for a human user, other than the
   * attacker, to participate in the successful compromise of the vulnerable
   * component.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.UserInteraction user_interaction = 8;</code>
   *
   * @return The userInteraction.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction getUserInteraction() {
    com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction result =
        com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction.forNumber(userInteraction_);
    return result == null
        ? com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction.UNRECOGNIZED
        : result;
  }

  public static final int SCOPE_FIELD_NUMBER = 9;
  private int scope_ = 0;
  /**
   *
   *
   * <pre>
   * The Scope metric captures whether a vulnerability in one vulnerable
   * component impacts resources in components beyond its security scope.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.Scope scope = 9;</code>
   *
   * @return The enum numeric value on the wire for scope.
   */
  @java.lang.Override
  public int getScopeValue() {
    return scope_;
  }
  /**
   *
   *
   * <pre>
   * The Scope metric captures whether a vulnerability in one vulnerable
   * component impacts resources in components beyond its security scope.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.Scope scope = 9;</code>
   *
   * @return The scope.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3.Scope getScope() {
    com.google.cloud.securitycenter.v1.Cvssv3.Scope result =
        com.google.cloud.securitycenter.v1.Cvssv3.Scope.forNumber(scope_);
    return result == null ? com.google.cloud.securitycenter.v1.Cvssv3.Scope.UNRECOGNIZED : result;
  }

  public static final int CONFIDENTIALITY_IMPACT_FIELD_NUMBER = 10;
  private int confidentialityImpact_ = 0;
  /**
   *
   *
   * <pre>
   * This metric measures the impact to the confidentiality of the information
   * resources managed by a software component due to a successfully exploited
   * vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact confidentiality_impact = 10;</code>
   *
   * @return The enum numeric value on the wire for confidentialityImpact.
   */
  @java.lang.Override
  public int getConfidentialityImpactValue() {
    return confidentialityImpact_;
  }
  /**
   *
   *
   * <pre>
   * This metric measures the impact to the confidentiality of the information
   * resources managed by a software component due to a successfully exploited
   * vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact confidentiality_impact = 10;</code>
   *
   * @return The confidentialityImpact.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3.Impact getConfidentialityImpact() {
    com.google.cloud.securitycenter.v1.Cvssv3.Impact result =
        com.google.cloud.securitycenter.v1.Cvssv3.Impact.forNumber(confidentialityImpact_);
    return result == null ? com.google.cloud.securitycenter.v1.Cvssv3.Impact.UNRECOGNIZED : result;
  }

  public static final int INTEGRITY_IMPACT_FIELD_NUMBER = 11;
  private int integrityImpact_ = 0;
  /**
   *
   *
   * <pre>
   * This metric measures the impact to integrity of a successfully exploited
   * vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact integrity_impact = 11;</code>
   *
   * @return The enum numeric value on the wire for integrityImpact.
   */
  @java.lang.Override
  public int getIntegrityImpactValue() {
    return integrityImpact_;
  }
  /**
   *
   *
   * <pre>
   * This metric measures the impact to integrity of a successfully exploited
   * vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact integrity_impact = 11;</code>
   *
   * @return The integrityImpact.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3.Impact getIntegrityImpact() {
    com.google.cloud.securitycenter.v1.Cvssv3.Impact result =
        com.google.cloud.securitycenter.v1.Cvssv3.Impact.forNumber(integrityImpact_);
    return result == null ? com.google.cloud.securitycenter.v1.Cvssv3.Impact.UNRECOGNIZED : result;
  }

  public static final int AVAILABILITY_IMPACT_FIELD_NUMBER = 12;
  private int availabilityImpact_ = 0;
  /**
   *
   *
   * <pre>
   * This metric measures the impact to the availability of the impacted
   * component resulting from a successfully exploited vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact availability_impact = 12;</code>
   *
   * @return The enum numeric value on the wire for availabilityImpact.
   */
  @java.lang.Override
  public int getAvailabilityImpactValue() {
    return availabilityImpact_;
  }
  /**
   *
   *
   * <pre>
   * This metric measures the impact to the availability of the impacted
   * component resulting from a successfully exploited vulnerability.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact availability_impact = 12;</code>
   *
   * @return The availabilityImpact.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3.Impact getAvailabilityImpact() {
    com.google.cloud.securitycenter.v1.Cvssv3.Impact result =
        com.google.cloud.securitycenter.v1.Cvssv3.Impact.forNumber(availabilityImpact_);
    return result == null ? com.google.cloud.securitycenter.v1.Cvssv3.Impact.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (java.lang.Double.doubleToRawLongBits(baseScore_) != 0) {
      output.writeDouble(1, baseScore_);
    }
    if (attackVector_
        != com.google.cloud.securitycenter.v1.Cvssv3.AttackVector.ATTACK_VECTOR_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, attackVector_);
    }
    if (attackComplexity_
        != com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity.ATTACK_COMPLEXITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, attackComplexity_);
    }
    if (privilegesRequired_
        != com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired
            .PRIVILEGES_REQUIRED_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, privilegesRequired_);
    }
    if (userInteraction_
        != com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction.USER_INTERACTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, userInteraction_);
    }
    if (scope_ != com.google.cloud.securitycenter.v1.Cvssv3.Scope.SCOPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, scope_);
    }
    if (confidentialityImpact_
        != com.google.cloud.securitycenter.v1.Cvssv3.Impact.IMPACT_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, confidentialityImpact_);
    }
    if (integrityImpact_
        != com.google.cloud.securitycenter.v1.Cvssv3.Impact.IMPACT_UNSPECIFIED.getNumber()) {
      output.writeEnum(11, integrityImpact_);
    }
    if (availabilityImpact_
        != com.google.cloud.securitycenter.v1.Cvssv3.Impact.IMPACT_UNSPECIFIED.getNumber()) {
      output.writeEnum(12, availabilityImpact_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Double.doubleToRawLongBits(baseScore_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, baseScore_);
    }
    if (attackVector_
        != com.google.cloud.securitycenter.v1.Cvssv3.AttackVector.ATTACK_VECTOR_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, attackVector_);
    }
    if (attackComplexity_
        != com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity.ATTACK_COMPLEXITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, attackComplexity_);
    }
    if (privilegesRequired_
        != com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired
            .PRIVILEGES_REQUIRED_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, privilegesRequired_);
    }
    if (userInteraction_
        != com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction.USER_INTERACTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, userInteraction_);
    }
    if (scope_ != com.google.cloud.securitycenter.v1.Cvssv3.Scope.SCOPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, scope_);
    }
    if (confidentialityImpact_
        != com.google.cloud.securitycenter.v1.Cvssv3.Impact.IMPACT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, confidentialityImpact_);
    }
    if (integrityImpact_
        != com.google.cloud.securitycenter.v1.Cvssv3.Impact.IMPACT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, integrityImpact_);
    }
    if (availabilityImpact_
        != com.google.cloud.securitycenter.v1.Cvssv3.Impact.IMPACT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, availabilityImpact_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Cvssv3)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Cvssv3 other =
        (com.google.cloud.securitycenter.v1.Cvssv3) obj;

    if (java.lang.Double.doubleToLongBits(getBaseScore())
        != java.lang.Double.doubleToLongBits(other.getBaseScore())) return false;
    if (attackVector_ != other.attackVector_) return false;
    if (attackComplexity_ != other.attackComplexity_) return false;
    if (privilegesRequired_ != other.privilegesRequired_) return false;
    if (userInteraction_ != other.userInteraction_) return false;
    if (scope_ != other.scope_) return false;
    if (confidentialityImpact_ != other.confidentialityImpact_) return false;
    if (integrityImpact_ != other.integrityImpact_) return false;
    if (availabilityImpact_ != other.availabilityImpact_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BASE_SCORE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getBaseScore()));
    hash = (37 * hash) + ATTACK_VECTOR_FIELD_NUMBER;
    hash = (53 * hash) + attackVector_;
    hash = (37 * hash) + ATTACK_COMPLEXITY_FIELD_NUMBER;
    hash = (53 * hash) + attackComplexity_;
    hash = (37 * hash) + PRIVILEGES_REQUIRED_FIELD_NUMBER;
    hash = (53 * hash) + privilegesRequired_;
    hash = (37 * hash) + USER_INTERACTION_FIELD_NUMBER;
    hash = (53 * hash) + userInteraction_;
    hash = (37 * hash) + SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + scope_;
    hash = (37 * hash) + CONFIDENTIALITY_IMPACT_FIELD_NUMBER;
    hash = (53 * hash) + confidentialityImpact_;
    hash = (37 * hash) + INTEGRITY_IMPACT_FIELD_NUMBER;
    hash = (53 * hash) + integrityImpact_;
    hash = (37 * hash) + AVAILABILITY_IMPACT_FIELD_NUMBER;
    hash = (53 * hash) + availabilityImpact_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Cvssv3 prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Common Vulnerability Scoring System version 3.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Cvssv3}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Cvssv3)
      com.google.cloud.securitycenter.v1.Cvssv3OrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.VulnerabilityProto
          .internal_static_google_cloud_securitycenter_v1_Cvssv3_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.VulnerabilityProto
          .internal_static_google_cloud_securitycenter_v1_Cvssv3_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Cvssv3.class,
              com.google.cloud.securitycenter.v1.Cvssv3.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Cvssv3.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      baseScore_ = 0D;
      attackVector_ = 0;
      attackComplexity_ = 0;
      privilegesRequired_ = 0;
      userInteraction_ = 0;
      scope_ = 0;
      confidentialityImpact_ = 0;
      integrityImpact_ = 0;
      availabilityImpact_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.VulnerabilityProto
          .internal_static_google_cloud_securitycenter_v1_Cvssv3_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3 getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Cvssv3.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3 build() {
      com.google.cloud.securitycenter.v1.Cvssv3 result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3 buildPartial() {
      com.google.cloud.securitycenter.v1.Cvssv3 result =
          new com.google.cloud.securitycenter.v1.Cvssv3(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Cvssv3 result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.baseScore_ = baseScore_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.attackVector_ = attackVector_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.attackComplexity_ = attackComplexity_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.privilegesRequired_ = privilegesRequired_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.userInteraction_ = userInteraction_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.scope_ = scope_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.confidentialityImpact_ = confidentialityImpact_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.integrityImpact_ = integrityImpact_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.availabilityImpact_ = availabilityImpact_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Cvssv3) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Cvssv3) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Cvssv3 other) {
      if (other == com.google.cloud.securitycenter.v1.Cvssv3.getDefaultInstance()) return this;
      if (other.getBaseScore() != 0D) {
        setBaseScore(other.getBaseScore());
      }
      if (other.attackVector_ != 0) {
        setAttackVectorValue(other.getAttackVectorValue());
      }
      if (other.attackComplexity_ != 0) {
        setAttackComplexityValue(other.getAttackComplexityValue());
      }
      if (other.privilegesRequired_ != 0) {
        setPrivilegesRequiredValue(other.getPrivilegesRequiredValue());
      }
      if (other.userInteraction_ != 0) {
        setUserInteractionValue(other.getUserInteractionValue());
      }
      if (other.scope_ != 0) {
        setScopeValue(other.getScopeValue());
      }
      if (other.confidentialityImpact_ != 0) {
        setConfidentialityImpactValue(other.getConfidentialityImpactValue());
      }
      if (other.integrityImpact_ != 0) {
        setIntegrityImpactValue(other.getIntegrityImpactValue());
      }
      if (other.availabilityImpact_ != 0) {
        setAvailabilityImpactValue(other.getAvailabilityImpactValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                baseScore_ = input.readDouble();
                bitField0_ |= 0x00000001;
                break;
              } // case 9
            case 40:
              {
                attackVector_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 40
            case 48:
              {
                attackComplexity_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 48
            case 56:
              {
                privilegesRequired_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 56
            case 64:
              {
                userInteraction_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 64
            case 72:
              {
                scope_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 72
            case 80:
              {
                confidentialityImpact_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 80
            case 88:
              {
                integrityImpact_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 88
            case 96:
              {
                availabilityImpact_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private double baseScore_;
    /**
     *
     *
     * <pre>
     * The base score is a function of the base metric scores.
     * </pre>
     *
     * <code>double base_score = 1;</code>
     *
     * @return The baseScore.
     */
    @java.lang.Override
    public double getBaseScore() {
      return baseScore_;
    }
    /**
     *
     *
     * <pre>
     * The base score is a function of the base metric scores.
     * </pre>
     *
     * <code>double base_score = 1;</code>
     *
     * @param value The baseScore to set.
     * @return This builder for chaining.
     */
    public Builder setBaseScore(double value) {

      baseScore_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base score is a function of the base metric scores.
     * </pre>
     *
     * <code>double base_score = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseScore() {
      bitField0_ = (bitField0_ & ~0x00000001);
      baseScore_ = 0D;
      onChanged();
      return this;
    }

    private int attackVector_ = 0;
    /**
     *
     *
     * <pre>
     * Base Metrics
     * Represents the intrinsic characteristics of a vulnerability that are
     * constant over time and across user environments.
     * This metric reflects the context by which vulnerability exploitation is
     * possible.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackVector attack_vector = 5;</code>
     *
     * @return The enum numeric value on the wire for attackVector.
     */
    @java.lang.Override
    public int getAttackVectorValue() {
      return attackVector_;
    }
    /**
     *
     *
     * <pre>
     * Base Metrics
     * Represents the intrinsic characteristics of a vulnerability that are
     * constant over time and across user environments.
     * This metric reflects the context by which vulnerability exploitation is
     * possible.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackVector attack_vector = 5;</code>
     *
     * @param value The enum numeric value on the wire for attackVector to set.
     * @return This builder for chaining.
     */
    public Builder setAttackVectorValue(int value) {
      attackVector_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Base Metrics
     * Represents the intrinsic characteristics of a vulnerability that are
     * constant over time and across user environments.
     * This metric reflects the context by which vulnerability exploitation is
     * possible.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackVector attack_vector = 5;</code>
     *
     * @return The attackVector.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3.AttackVector getAttackVector() {
      com.google.cloud.securitycenter.v1.Cvssv3.AttackVector result =
          com.google.cloud.securitycenter.v1.Cvssv3.AttackVector.forNumber(attackVector_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Cvssv3.AttackVector.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Base Metrics
     * Represents the intrinsic characteristics of a vulnerability that are
     * constant over time and across user environments.
     * This metric reflects the context by which vulnerability exploitation is
     * possible.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackVector attack_vector = 5;</code>
     *
     * @param value The attackVector to set.
     * @return This builder for chaining.
     */
    public Builder setAttackVector(com.google.cloud.securitycenter.v1.Cvssv3.AttackVector value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      attackVector_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Base Metrics
     * Represents the intrinsic characteristics of a vulnerability that are
     * constant over time and across user environments.
     * This metric reflects the context by which vulnerability exploitation is
     * possible.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackVector attack_vector = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttackVector() {
      bitField0_ = (bitField0_ & ~0x00000002);
      attackVector_ = 0;
      onChanged();
      return this;
    }

    private int attackComplexity_ = 0;
    /**
     *
     *
     * <pre>
     * This metric describes the conditions beyond the attacker's control that
     * must exist in order to exploit the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity attack_complexity = 6;</code>
     *
     * @return The enum numeric value on the wire for attackComplexity.
     */
    @java.lang.Override
    public int getAttackComplexityValue() {
      return attackComplexity_;
    }
    /**
     *
     *
     * <pre>
     * This metric describes the conditions beyond the attacker's control that
     * must exist in order to exploit the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity attack_complexity = 6;</code>
     *
     * @param value The enum numeric value on the wire for attackComplexity to set.
     * @return This builder for chaining.
     */
    public Builder setAttackComplexityValue(int value) {
      attackComplexity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric describes the conditions beyond the attacker's control that
     * must exist in order to exploit the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity attack_complexity = 6;</code>
     *
     * @return The attackComplexity.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity getAttackComplexity() {
      com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity result =
          com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity.forNumber(attackComplexity_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * This metric describes the conditions beyond the attacker's control that
     * must exist in order to exploit the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity attack_complexity = 6;</code>
     *
     * @param value The attackComplexity to set.
     * @return This builder for chaining.
     */
    public Builder setAttackComplexity(
        com.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      attackComplexity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric describes the conditions beyond the attacker's control that
     * must exist in order to exploit the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.AttackComplexity attack_complexity = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttackComplexity() {
      bitField0_ = (bitField0_ & ~0x00000004);
      attackComplexity_ = 0;
      onChanged();
      return this;
    }

    private int privilegesRequired_ = 0;
    /**
     *
     *
     * <pre>
     * This metric describes the level of privileges an attacker must possess
     * before successfully exploiting the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired privileges_required = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for privilegesRequired.
     */
    @java.lang.Override
    public int getPrivilegesRequiredValue() {
      return privilegesRequired_;
    }
    /**
     *
     *
     * <pre>
     * This metric describes the level of privileges an attacker must possess
     * before successfully exploiting the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired privileges_required = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for privilegesRequired to set.
     * @return This builder for chaining.
     */
    public Builder setPrivilegesRequiredValue(int value) {
      privilegesRequired_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric describes the level of privileges an attacker must possess
     * before successfully exploiting the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired privileges_required = 7;
     * </code>
     *
     * @return The privilegesRequired.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired getPrivilegesRequired() {
      com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired result =
          com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired.forNumber(
              privilegesRequired_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * This metric describes the level of privileges an attacker must possess
     * before successfully exploiting the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired privileges_required = 7;
     * </code>
     *
     * @param value The privilegesRequired to set.
     * @return This builder for chaining.
     */
    public Builder setPrivilegesRequired(
        com.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      privilegesRequired_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric describes the level of privileges an attacker must possess
     * before successfully exploiting the vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.PrivilegesRequired privileges_required = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivilegesRequired() {
      bitField0_ = (bitField0_ & ~0x00000008);
      privilegesRequired_ = 0;
      onChanged();
      return this;
    }

    private int userInteraction_ = 0;
    /**
     *
     *
     * <pre>
     * This metric captures the requirement for a human user, other than the
     * attacker, to participate in the successful compromise of the vulnerable
     * component.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.UserInteraction user_interaction = 8;</code>
     *
     * @return The enum numeric value on the wire for userInteraction.
     */
    @java.lang.Override
    public int getUserInteractionValue() {
      return userInteraction_;
    }
    /**
     *
     *
     * <pre>
     * This metric captures the requirement for a human user, other than the
     * attacker, to participate in the successful compromise of the vulnerable
     * component.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.UserInteraction user_interaction = 8;</code>
     *
     * @param value The enum numeric value on the wire for userInteraction to set.
     * @return This builder for chaining.
     */
    public Builder setUserInteractionValue(int value) {
      userInteraction_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric captures the requirement for a human user, other than the
     * attacker, to participate in the successful compromise of the vulnerable
     * component.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.UserInteraction user_interaction = 8;</code>
     *
     * @return The userInteraction.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction getUserInteraction() {
      com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction result =
          com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction.forNumber(userInteraction_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * This metric captures the requirement for a human user, other than the
     * attacker, to participate in the successful compromise of the vulnerable
     * component.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.UserInteraction user_interaction = 8;</code>
     *
     * @param value The userInteraction to set.
     * @return This builder for chaining.
     */
    public Builder setUserInteraction(
        com.google.cloud.securitycenter.v1.Cvssv3.UserInteraction value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      userInteraction_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric captures the requirement for a human user, other than the
     * attacker, to participate in the successful compromise of the vulnerable
     * component.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.UserInteraction user_interaction = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserInteraction() {
      bitField0_ = (bitField0_ & ~0x00000010);
      userInteraction_ = 0;
      onChanged();
      return this;
    }

    private int scope_ = 0;
    /**
     *
     *
     * <pre>
     * The Scope metric captures whether a vulnerability in one vulnerable
     * component impacts resources in components beyond its security scope.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Scope scope = 9;</code>
     *
     * @return The enum numeric value on the wire for scope.
     */
    @java.lang.Override
    public int getScopeValue() {
      return scope_;
    }
    /**
     *
     *
     * <pre>
     * The Scope metric captures whether a vulnerability in one vulnerable
     * component impacts resources in components beyond its security scope.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Scope scope = 9;</code>
     *
     * @param value The enum numeric value on the wire for scope to set.
     * @return This builder for chaining.
     */
    public Builder setScopeValue(int value) {
      scope_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Scope metric captures whether a vulnerability in one vulnerable
     * component impacts resources in components beyond its security scope.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Scope scope = 9;</code>
     *
     * @return The scope.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3.Scope getScope() {
      com.google.cloud.securitycenter.v1.Cvssv3.Scope result =
          com.google.cloud.securitycenter.v1.Cvssv3.Scope.forNumber(scope_);
      return result == null ? com.google.cloud.securitycenter.v1.Cvssv3.Scope.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The Scope metric captures whether a vulnerability in one vulnerable
     * component impacts resources in components beyond its security scope.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Scope scope = 9;</code>
     *
     * @param value The scope to set.
     * @return This builder for chaining.
     */
    public Builder setScope(com.google.cloud.securitycenter.v1.Cvssv3.Scope value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      scope_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Scope metric captures whether a vulnerability in one vulnerable
     * component impacts resources in components beyond its security scope.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Scope scope = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScope() {
      bitField0_ = (bitField0_ & ~0x00000020);
      scope_ = 0;
      onChanged();
      return this;
    }

    private int confidentialityImpact_ = 0;
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the confidentiality of the information
     * resources managed by a software component due to a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact confidentiality_impact = 10;</code>
     *
     * @return The enum numeric value on the wire for confidentialityImpact.
     */
    @java.lang.Override
    public int getConfidentialityImpactValue() {
      return confidentialityImpact_;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the confidentiality of the information
     * resources managed by a software component due to a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact confidentiality_impact = 10;</code>
     *
     * @param value The enum numeric value on the wire for confidentialityImpact to set.
     * @return This builder for chaining.
     */
    public Builder setConfidentialityImpactValue(int value) {
      confidentialityImpact_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the confidentiality of the information
     * resources managed by a software component due to a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact confidentiality_impact = 10;</code>
     *
     * @return The confidentialityImpact.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3.Impact getConfidentialityImpact() {
      com.google.cloud.securitycenter.v1.Cvssv3.Impact result =
          com.google.cloud.securitycenter.v1.Cvssv3.Impact.forNumber(confidentialityImpact_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Cvssv3.Impact.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the confidentiality of the information
     * resources managed by a software component due to a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact confidentiality_impact = 10;</code>
     *
     * @param value The confidentialityImpact to set.
     * @return This builder for chaining.
     */
    public Builder setConfidentialityImpact(
        com.google.cloud.securitycenter.v1.Cvssv3.Impact value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      confidentialityImpact_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the confidentiality of the information
     * resources managed by a software component due to a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact confidentiality_impact = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidentialityImpact() {
      bitField0_ = (bitField0_ & ~0x00000040);
      confidentialityImpact_ = 0;
      onChanged();
      return this;
    }

    private int integrityImpact_ = 0;
    /**
     *
     *
     * <pre>
     * This metric measures the impact to integrity of a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact integrity_impact = 11;</code>
     *
     * @return The enum numeric value on the wire for integrityImpact.
     */
    @java.lang.Override
    public int getIntegrityImpactValue() {
      return integrityImpact_;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to integrity of a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact integrity_impact = 11;</code>
     *
     * @param value The enum numeric value on the wire for integrityImpact to set.
     * @return This builder for chaining.
     */
    public Builder setIntegrityImpactValue(int value) {
      integrityImpact_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to integrity of a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact integrity_impact = 11;</code>
     *
     * @return The integrityImpact.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3.Impact getIntegrityImpact() {
      com.google.cloud.securitycenter.v1.Cvssv3.Impact result =
          com.google.cloud.securitycenter.v1.Cvssv3.Impact.forNumber(integrityImpact_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Cvssv3.Impact.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to integrity of a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact integrity_impact = 11;</code>
     *
     * @param value The integrityImpact to set.
     * @return This builder for chaining.
     */
    public Builder setIntegrityImpact(com.google.cloud.securitycenter.v1.Cvssv3.Impact value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      integrityImpact_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to integrity of a successfully exploited
     * vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact integrity_impact = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntegrityImpact() {
      bitField0_ = (bitField0_ & ~0x00000080);
      integrityImpact_ = 0;
      onChanged();
      return this;
    }

    private int availabilityImpact_ = 0;
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the availability of the impacted
     * component resulting from a successfully exploited vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact availability_impact = 12;</code>
     *
     * @return The enum numeric value on the wire for availabilityImpact.
     */
    @java.lang.Override
    public int getAvailabilityImpactValue() {
      return availabilityImpact_;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the availability of the impacted
     * component resulting from a successfully exploited vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact availability_impact = 12;</code>
     *
     * @param value The enum numeric value on the wire for availabilityImpact to set.
     * @return This builder for chaining.
     */
    public Builder setAvailabilityImpactValue(int value) {
      availabilityImpact_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the availability of the impacted
     * component resulting from a successfully exploited vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact availability_impact = 12;</code>
     *
     * @return The availabilityImpact.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Cvssv3.Impact getAvailabilityImpact() {
      com.google.cloud.securitycenter.v1.Cvssv3.Impact result =
          com.google.cloud.securitycenter.v1.Cvssv3.Impact.forNumber(availabilityImpact_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Cvssv3.Impact.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the availability of the impacted
     * component resulting from a successfully exploited vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact availability_impact = 12;</code>
     *
     * @param value The availabilityImpact to set.
     * @return This builder for chaining.
     */
    public Builder setAvailabilityImpact(com.google.cloud.securitycenter.v1.Cvssv3.Impact value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      availabilityImpact_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This metric measures the impact to the availability of the impacted
     * component resulting from a successfully exploited vulnerability.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cvssv3.Impact availability_impact = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailabilityImpact() {
      bitField0_ = (bitField0_ & ~0x00000100);
      availabilityImpact_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Cvssv3)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Cvssv3)
  private static final com.google.cloud.securitycenter.v1.Cvssv3 DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Cvssv3();
  }

  public static com.google.cloud.securitycenter.v1.Cvssv3 getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Cvssv3> PARSER =
      new com.google.protobuf.AbstractParser<Cvssv3>() {
        @java.lang.Override
        public Cvssv3 parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Cvssv3> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Cvssv3> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cvssv3 getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
