/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/external_system.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Representation of third party SIEM/SOAR fields within SCC.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.ExternalSystem}
 */
public final class ExternalSystem extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.ExternalSystem)
    ExternalSystemOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExternalSystem.newBuilder() to construct.
  private ExternalSystem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExternalSystem() {
    name_ = "";
    assignees_ = com.google.protobuf.LazyStringArrayList.emptyList();
    externalUid_ = "";
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExternalSystem();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.ExternalSystemProto
        .internal_static_google_cloud_securitycenter_v1_ExternalSystem_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.ExternalSystemProto
        .internal_static_google_cloud_securitycenter_v1_ExternalSystem_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.ExternalSystem.class,
            com.google.cloud.securitycenter.v1.ExternalSystem.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Full resource name of the external system, for example:
   * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
   * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
   * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Full resource name of the external system, for example:
   * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
   * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
   * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSIGNEES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList assignees_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * References primary/secondary etc assignees in the external system.
   * </pre>
   *
   * <code>repeated string assignees = 2;</code>
   *
   * @return A list containing the assignees.
   */
  public com.google.protobuf.ProtocolStringList getAssigneesList() {
    return assignees_;
  }
  /**
   *
   *
   * <pre>
   * References primary/secondary etc assignees in the external system.
   * </pre>
   *
   * <code>repeated string assignees = 2;</code>
   *
   * @return The count of assignees.
   */
  public int getAssigneesCount() {
    return assignees_.size();
  }
  /**
   *
   *
   * <pre>
   * References primary/secondary etc assignees in the external system.
   * </pre>
   *
   * <code>repeated string assignees = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The assignees at the given index.
   */
  public java.lang.String getAssignees(int index) {
    return assignees_.get(index);
  }
  /**
   *
   *
   * <pre>
   * References primary/secondary etc assignees in the external system.
   * </pre>
   *
   * <code>repeated string assignees = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the assignees at the given index.
   */
  public com.google.protobuf.ByteString getAssigneesBytes(int index) {
    return assignees_.getByteString(index);
  }

  public static final int EXTERNAL_UID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalUid_ = "";
  /**
   *
   *
   * <pre>
   * Identifier that's used to track the given finding in the external system.
   * </pre>
   *
   * <code>string external_uid = 3;</code>
   *
   * @return The externalUid.
   */
  @java.lang.Override
  public java.lang.String getExternalUid() {
    java.lang.Object ref = externalUid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalUid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier that's used to track the given finding in the external system.
   * </pre>
   *
   * <code>string external_uid = 3;</code>
   *
   * @return The bytes for externalUid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalUidBytes() {
    java.lang.Object ref = externalUid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalUid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * Most recent status of the corresponding finding's ticket/tracker in the
   * external system.
   * </pre>
   *
   * <code>string status = 4;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Most recent status of the corresponding finding's ticket/tracker in the
   * external system.
   * </pre>
   *
   * <code>string status = 4;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_SYSTEM_UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp externalSystemUpdateTime_;
  /**
   *
   *
   * <pre>
   * The most recent time when the corresponding finding's ticket/tracker was
   * updated in the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
   *
   * @return Whether the externalSystemUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasExternalSystemUpdateTime() {
    return externalSystemUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The most recent time when the corresponding finding's ticket/tracker was
   * updated in the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
   *
   * @return The externalSystemUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExternalSystemUpdateTime() {
    return externalSystemUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : externalSystemUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * The most recent time when the corresponding finding's ticket/tracker was
   * updated in the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExternalSystemUpdateTimeOrBuilder() {
    return externalSystemUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : externalSystemUpdateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < assignees_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, assignees_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalUid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, externalUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(status_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, status_);
    }
    if (externalSystemUpdateTime_ != null) {
      output.writeMessage(5, getExternalSystemUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < assignees_.size(); i++) {
        dataSize += computeStringSizeNoTag(assignees_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAssigneesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalUid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, externalUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(status_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, status_);
    }
    if (externalSystemUpdateTime_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, getExternalSystemUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.ExternalSystem)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.ExternalSystem other =
        (com.google.cloud.securitycenter.v1.ExternalSystem) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAssigneesList().equals(other.getAssigneesList())) return false;
    if (!getExternalUid().equals(other.getExternalUid())) return false;
    if (!getStatus().equals(other.getStatus())) return false;
    if (hasExternalSystemUpdateTime() != other.hasExternalSystemUpdateTime()) return false;
    if (hasExternalSystemUpdateTime()) {
      if (!getExternalSystemUpdateTime().equals(other.getExternalSystemUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getAssigneesCount() > 0) {
      hash = (37 * hash) + ASSIGNEES_FIELD_NUMBER;
      hash = (53 * hash) + getAssigneesList().hashCode();
    }
    hash = (37 * hash) + EXTERNAL_UID_FIELD_NUMBER;
    hash = (53 * hash) + getExternalUid().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + getStatus().hashCode();
    if (hasExternalSystemUpdateTime()) {
      hash = (37 * hash) + EXTERNAL_SYSTEM_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExternalSystemUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.ExternalSystem prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Representation of third party SIEM/SOAR fields within SCC.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.ExternalSystem}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.ExternalSystem)
      com.google.cloud.securitycenter.v1.ExternalSystemOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.ExternalSystemProto
          .internal_static_google_cloud_securitycenter_v1_ExternalSystem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.ExternalSystemProto
          .internal_static_google_cloud_securitycenter_v1_ExternalSystem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.ExternalSystem.class,
              com.google.cloud.securitycenter.v1.ExternalSystem.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.ExternalSystem.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      assignees_ = com.google.protobuf.LazyStringArrayList.emptyList();
      externalUid_ = "";
      status_ = "";
      externalSystemUpdateTime_ = null;
      if (externalSystemUpdateTimeBuilder_ != null) {
        externalSystemUpdateTimeBuilder_.dispose();
        externalSystemUpdateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.ExternalSystemProto
          .internal_static_google_cloud_securitycenter_v1_ExternalSystem_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ExternalSystem getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.ExternalSystem.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ExternalSystem build() {
      com.google.cloud.securitycenter.v1.ExternalSystem result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ExternalSystem buildPartial() {
      com.google.cloud.securitycenter.v1.ExternalSystem result =
          new com.google.cloud.securitycenter.v1.ExternalSystem(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.ExternalSystem result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        assignees_.makeImmutable();
        result.assignees_ = assignees_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.externalUid_ = externalUid_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.externalSystemUpdateTime_ =
            externalSystemUpdateTimeBuilder_ == null
                ? externalSystemUpdateTime_
                : externalSystemUpdateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.ExternalSystem) {
        return mergeFrom((com.google.cloud.securitycenter.v1.ExternalSystem) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.ExternalSystem other) {
      if (other == com.google.cloud.securitycenter.v1.ExternalSystem.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.assignees_.isEmpty()) {
        if (assignees_.isEmpty()) {
          assignees_ = other.assignees_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAssigneesIsMutable();
          assignees_.addAll(other.assignees_);
        }
        onChanged();
      }
      if (!other.getExternalUid().isEmpty()) {
        externalUid_ = other.externalUid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getStatus().isEmpty()) {
        status_ = other.status_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasExternalSystemUpdateTime()) {
        mergeExternalSystemUpdateTime(other.getExternalSystemUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAssigneesIsMutable();
                assignees_.add(s);
                break;
              } // case 18
            case 26:
              {
                externalUid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getExternalSystemUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList assignees_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAssigneesIsMutable() {
      if (!assignees_.isModifiable()) {
        assignees_ = new com.google.protobuf.LazyStringArrayList(assignees_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @return A list containing the assignees.
     */
    public com.google.protobuf.ProtocolStringList getAssigneesList() {
      assignees_.makeImmutable();
      return assignees_;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @return The count of assignees.
     */
    public int getAssigneesCount() {
      return assignees_.size();
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The assignees at the given index.
     */
    public java.lang.String getAssignees(int index) {
      return assignees_.get(index);
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the assignees at the given index.
     */
    public com.google.protobuf.ByteString getAssigneesBytes(int index) {
      return assignees_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The assignees to set.
     * @return This builder for chaining.
     */
    public Builder setAssignees(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssigneesIsMutable();
      assignees_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param value The assignees to add.
     * @return This builder for chaining.
     */
    public Builder addAssignees(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssigneesIsMutable();
      assignees_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param values The assignees to add.
     * @return This builder for chaining.
     */
    public Builder addAllAssignees(java.lang.Iterable<java.lang.String> values) {
      ensureAssigneesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, assignees_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssignees() {
      assignees_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param value The bytes of the assignees to add.
     * @return This builder for chaining.
     */
    public Builder addAssigneesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAssigneesIsMutable();
      assignees_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object externalUid_ = "";
    /**
     *
     *
     * <pre>
     * Identifier that's used to track the given finding in the external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @return The externalUid.
     */
    public java.lang.String getExternalUid() {
      java.lang.Object ref = externalUid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalUid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier that's used to track the given finding in the external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @return The bytes for externalUid.
     */
    public com.google.protobuf.ByteString getExternalUidBytes() {
      java.lang.Object ref = externalUid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalUid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier that's used to track the given finding in the external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @param value The externalUid to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalUid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier that's used to track the given finding in the external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalUid() {
      externalUid_ = getDefaultInstance().getExternalUid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier that's used to track the given finding in the external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @param value The bytes for externalUid to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalUid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * Most recent status of the corresponding finding's ticket/tracker in the
     * external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Most recent status of the corresponding finding's ticket/tracker in the
     * external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Most recent status of the corresponding finding's ticket/tracker in the
     * external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Most recent status of the corresponding finding's ticket/tracker in the
     * external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Most recent status of the corresponding finding's ticket/tracker in the
     * external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp externalSystemUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        externalSystemUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The most recent time when the corresponding finding's ticket/tracker was
     * updated in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     *
     * @return Whether the externalSystemUpdateTime field is set.
     */
    public boolean hasExternalSystemUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The most recent time when the corresponding finding's ticket/tracker was
     * updated in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     *
     * @return The externalSystemUpdateTime.
     */
    public com.google.protobuf.Timestamp getExternalSystemUpdateTime() {
      if (externalSystemUpdateTimeBuilder_ == null) {
        return externalSystemUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : externalSystemUpdateTime_;
      } else {
        return externalSystemUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The most recent time when the corresponding finding's ticket/tracker was
     * updated in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public Builder setExternalSystemUpdateTime(com.google.protobuf.Timestamp value) {
      if (externalSystemUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        externalSystemUpdateTime_ = value;
      } else {
        externalSystemUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent time when the corresponding finding's ticket/tracker was
     * updated in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public Builder setExternalSystemUpdateTime(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (externalSystemUpdateTimeBuilder_ == null) {
        externalSystemUpdateTime_ = builderForValue.build();
      } else {
        externalSystemUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent time when the corresponding finding's ticket/tracker was
     * updated in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public Builder mergeExternalSystemUpdateTime(com.google.protobuf.Timestamp value) {
      if (externalSystemUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && externalSystemUpdateTime_ != null
            && externalSystemUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExternalSystemUpdateTimeBuilder().mergeFrom(value);
        } else {
          externalSystemUpdateTime_ = value;
        }
      } else {
        externalSystemUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent time when the corresponding finding's ticket/tracker was
     * updated in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public Builder clearExternalSystemUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      externalSystemUpdateTime_ = null;
      if (externalSystemUpdateTimeBuilder_ != null) {
        externalSystemUpdateTimeBuilder_.dispose();
        externalSystemUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent time when the corresponding finding's ticket/tracker was
     * updated in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExternalSystemUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getExternalSystemUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The most recent time when the corresponding finding's ticket/tracker was
     * updated in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getExternalSystemUpdateTimeOrBuilder() {
      if (externalSystemUpdateTimeBuilder_ != null) {
        return externalSystemUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return externalSystemUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : externalSystemUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The most recent time when the corresponding finding's ticket/tracker was
     * updated in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExternalSystemUpdateTimeFieldBuilder() {
      if (externalSystemUpdateTimeBuilder_ == null) {
        externalSystemUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExternalSystemUpdateTime(), getParentForChildren(), isClean());
        externalSystemUpdateTime_ = null;
      }
      return externalSystemUpdateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.ExternalSystem)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.ExternalSystem)
  private static final com.google.cloud.securitycenter.v1.ExternalSystem DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.ExternalSystem();
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExternalSystem> PARSER =
      new com.google.protobuf.AbstractParser<ExternalSystem>() {
        @java.lang.Override
        public ExternalSystem parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExternalSystem> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExternalSystem> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExternalSystem getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
