/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/finding.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Security Command Center finding.
 *
 * A finding is a record of assessment data like security, risk, health, or
 * privacy, that is ingested into Security Command Center for presentation,
 * notification, analysis, policy testing, and enforcement. For example, a
 * cross-site scripting (XSS) vulnerability in an App Engine application is a
 * finding.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Finding}
 */
public final class Finding extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Finding)
    FindingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Finding.newBuilder() to construct.
  private Finding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Finding() {
    name_ = "";
    parent_ = "";
    resourceName_ = "";
    state_ = 0;
    category_ = "";
    externalUri_ = "";
    severity_ = 0;
    canonicalName_ = "";
    mute_ = 0;
    findingClass_ = 0;
    connections_ = java.util.Collections.emptyList();
    muteInitiator_ = "";
    processes_ = java.util.Collections.emptyList();
    compliances_ = java.util.Collections.emptyList();
    parentDisplayName_ = "";
    description_ = "";
    iamBindings_ = java.util.Collections.emptyList();
    nextSteps_ = "";
    moduleName_ = "";
    containers_ = java.util.Collections.emptyList();
    files_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Finding();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.FindingOuterClass
        .internal_static_google_cloud_securitycenter_v1_Finding_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetSourceProperties();
      case 22:
        return internalGetExternalSystems();
      case 33:
        return internalGetContacts();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.FindingOuterClass
        .internal_static_google_cloud_securitycenter_v1_Finding_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Finding.class,
            com.google.cloud.securitycenter.v1.Finding.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of the finding.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Finding.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The finding requires attention and has not been addressed yet.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * The finding has been fixed, triaged as a non-issue or otherwise addressed
     * and is no longer active.
     * </pre>
     *
     * <code>INACTIVE = 2;</code>
     */
    INACTIVE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The finding requires attention and has not been addressed yet.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The finding has been fixed, triaged as a non-issue or otherwise addressed
     * and is no longer active.
     * </pre>
     *
     * <code>INACTIVE = 2;</code>
     */
    public static final int INACTIVE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return INACTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Finding.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Finding.State)
  }

  /**
   *
   *
   * <pre>
   * The severity of the finding.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Finding.Severity}
   */
  public enum Severity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This value is used for findings when a source doesn't write a severity
     * value.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Vulnerability:
     * A critical vulnerability is easily discoverable by an external actor,
     * exploitable, and results in the direct ability to execute arbitrary code,
     * exfiltrate data, and otherwise gain additional access and privileges to
     * cloud resources and workloads. Examples include publicly accessible
     * unprotected user data and public SSH access with weak or no
     * passwords.
     *
     * Threat:
     * Indicates a threat that is able to access, modify, or delete data or
     * execute unauthorized code within existing resources.
     * </pre>
     *
     * <code>CRITICAL = 1;</code>
     */
    CRITICAL(1),
    /**
     *
     *
     * <pre>
     * Vulnerability:
     * A high risk vulnerability can be easily discovered and exploited in
     * combination with other vulnerabilities in order to gain direct access and
     * the ability to execute arbitrary code, exfiltrate data, and otherwise
     * gain additional access and privileges to cloud resources and workloads.
     * An example is a database with weak or no passwords that is only
     * accessible internally. This database could easily be compromised by an
     * actor that had access to the internal network.
     *
     * Threat:
     * Indicates a threat that is able to create new computational resources in
     * an environment but not able to access data or execute code in existing
     * resources.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    HIGH(2),
    /**
     *
     *
     * <pre>
     * Vulnerability:
     * A medium risk vulnerability could be used by an actor to gain access to
     * resources or privileges that enable them to eventually (through multiple
     * steps or a complex exploit) gain access and the ability to execute
     * arbitrary code or exfiltrate data. An example is a service account with
     * access to more projects than it should have. If an actor gains access to
     * the service account, they could potentially use that access to manipulate
     * a project the service account was not intended to.
     *
     * Threat:
     * Indicates a threat that is able to cause operational impact but may not
     * access data or execute unauthorized code.
     * </pre>
     *
     * <code>MEDIUM = 3;</code>
     */
    MEDIUM(3),
    /**
     *
     *
     * <pre>
     * Vulnerability:
     * A low risk vulnerability hampers a security organization's ability to
     * detect vulnerabilities or active threats in their deployment, or prevents
     * the root cause investigation of security issues. An example is monitoring
     * and logs being disabled for resource configurations and access.
     *
     * Threat:
     * Indicates a threat that has obtained minimal access to an environment but
     * is not able to access data, execute code, or create resources.
     * </pre>
     *
     * <code>LOW = 4;</code>
     */
    LOW(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This value is used for findings when a source doesn't write a severity
     * value.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Vulnerability:
     * A critical vulnerability is easily discoverable by an external actor,
     * exploitable, and results in the direct ability to execute arbitrary code,
     * exfiltrate data, and otherwise gain additional access and privileges to
     * cloud resources and workloads. Examples include publicly accessible
     * unprotected user data and public SSH access with weak or no
     * passwords.
     *
     * Threat:
     * Indicates a threat that is able to access, modify, or delete data or
     * execute unauthorized code within existing resources.
     * </pre>
     *
     * <code>CRITICAL = 1;</code>
     */
    public static final int CRITICAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Vulnerability:
     * A high risk vulnerability can be easily discovered and exploited in
     * combination with other vulnerabilities in order to gain direct access and
     * the ability to execute arbitrary code, exfiltrate data, and otherwise
     * gain additional access and privileges to cloud resources and workloads.
     * An example is a database with weak or no passwords that is only
     * accessible internally. This database could easily be compromised by an
     * actor that had access to the internal network.
     *
     * Threat:
     * Indicates a threat that is able to create new computational resources in
     * an environment but not able to access data or execute code in existing
     * resources.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    public static final int HIGH_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Vulnerability:
     * A medium risk vulnerability could be used by an actor to gain access to
     * resources or privileges that enable them to eventually (through multiple
     * steps or a complex exploit) gain access and the ability to execute
     * arbitrary code or exfiltrate data. An example is a service account with
     * access to more projects than it should have. If an actor gains access to
     * the service account, they could potentially use that access to manipulate
     * a project the service account was not intended to.
     *
     * Threat:
     * Indicates a threat that is able to cause operational impact but may not
     * access data or execute unauthorized code.
     * </pre>
     *
     * <code>MEDIUM = 3;</code>
     */
    public static final int MEDIUM_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Vulnerability:
     * A low risk vulnerability hampers a security organization's ability to
     * detect vulnerabilities or active threats in their deployment, or prevents
     * the root cause investigation of security issues. An example is monitoring
     * and logs being disabled for resource configurations and access.
     *
     * Threat:
     * Indicates a threat that has obtained minimal access to an environment but
     * is not able to access data, execute code, or create resources.
     * </pre>
     *
     * <code>LOW = 4;</code>
     */
    public static final int LOW_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Severity forNumber(int value) {
      switch (value) {
        case 0:
          return SEVERITY_UNSPECIFIED;
        case 1:
          return CRITICAL;
        case 2:
          return HIGH;
        case 3:
          return MEDIUM;
        case 4:
          return LOW;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Severity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
          public Severity findValueByNumber(int number) {
            return Severity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Finding.getDescriptor().getEnumTypes().get(1);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Finding.Severity)
  }

  /**
   *
   *
   * <pre>
   * Mute state a finding can be in.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Finding.Mute}
   */
  public enum Mute implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>MUTE_UNSPECIFIED = 0;</code>
     */
    MUTE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Finding has been muted.
     * </pre>
     *
     * <code>MUTED = 1;</code>
     */
    MUTED(1),
    /**
     *
     *
     * <pre>
     * Finding has been unmuted.
     * </pre>
     *
     * <code>UNMUTED = 2;</code>
     */
    UNMUTED(2),
    /**
     *
     *
     * <pre>
     * Finding has never been muted/unmuted.
     * </pre>
     *
     * <code>UNDEFINED = 4;</code>
     */
    UNDEFINED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>MUTE_UNSPECIFIED = 0;</code>
     */
    public static final int MUTE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Finding has been muted.
     * </pre>
     *
     * <code>MUTED = 1;</code>
     */
    public static final int MUTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Finding has been unmuted.
     * </pre>
     *
     * <code>UNMUTED = 2;</code>
     */
    public static final int UNMUTED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Finding has never been muted/unmuted.
     * </pre>
     *
     * <code>UNDEFINED = 4;</code>
     */
    public static final int UNDEFINED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mute valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mute forNumber(int value) {
      switch (value) {
        case 0:
          return MUTE_UNSPECIFIED;
        case 1:
          return MUTED;
        case 2:
          return UNMUTED;
        case 4:
          return UNDEFINED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mute> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mute> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mute>() {
          public Mute findValueByNumber(int number) {
            return Mute.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Finding.getDescriptor().getEnumTypes().get(2);
    }

    private static final Mute[] VALUES = values();

    public static Mute valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mute(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Finding.Mute)
  }

  /**
   *
   *
   * <pre>
   * Represents what kind of Finding it is.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Finding.FindingClass}
   */
  public enum FindingClass implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified finding class.
     * </pre>
     *
     * <code>FINDING_CLASS_UNSPECIFIED = 0;</code>
     */
    FINDING_CLASS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Describes unwanted or malicious activity.
     * </pre>
     *
     * <code>THREAT = 1;</code>
     */
    THREAT(1),
    /**
     *
     *
     * <pre>
     * Describes a potential weakness in software that increases risk to
     * Confidentiality &amp; Integrity &amp; Availability.
     * </pre>
     *
     * <code>VULNERABILITY = 2;</code>
     */
    VULNERABILITY(2),
    /**
     *
     *
     * <pre>
     * Describes a potential weakness in cloud resource/asset configuration that
     * increases risk.
     * </pre>
     *
     * <code>MISCONFIGURATION = 3;</code>
     */
    MISCONFIGURATION(3),
    /**
     *
     *
     * <pre>
     * Describes a security observation that is for informational purposes.
     * </pre>
     *
     * <code>OBSERVATION = 4;</code>
     */
    OBSERVATION(4),
    /**
     *
     *
     * <pre>
     * Describes an error that prevents some SCC functionality.
     * </pre>
     *
     * <code>SCC_ERROR = 5;</code>
     */
    SCC_ERROR(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified finding class.
     * </pre>
     *
     * <code>FINDING_CLASS_UNSPECIFIED = 0;</code>
     */
    public static final int FINDING_CLASS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Describes unwanted or malicious activity.
     * </pre>
     *
     * <code>THREAT = 1;</code>
     */
    public static final int THREAT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Describes a potential weakness in software that increases risk to
     * Confidentiality &amp; Integrity &amp; Availability.
     * </pre>
     *
     * <code>VULNERABILITY = 2;</code>
     */
    public static final int VULNERABILITY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Describes a potential weakness in cloud resource/asset configuration that
     * increases risk.
     * </pre>
     *
     * <code>MISCONFIGURATION = 3;</code>
     */
    public static final int MISCONFIGURATION_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Describes a security observation that is for informational purposes.
     * </pre>
     *
     * <code>OBSERVATION = 4;</code>
     */
    public static final int OBSERVATION_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Describes an error that prevents some SCC functionality.
     * </pre>
     *
     * <code>SCC_ERROR = 5;</code>
     */
    public static final int SCC_ERROR_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FindingClass valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FindingClass forNumber(int value) {
      switch (value) {
        case 0:
          return FINDING_CLASS_UNSPECIFIED;
        case 1:
          return THREAT;
        case 2:
          return VULNERABILITY;
        case 3:
          return MISCONFIGURATION;
        case 4:
          return OBSERVATION;
        case 5:
          return SCC_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FindingClass> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FindingClass> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FindingClass>() {
          public FindingClass findValueByNumber(int number) {
            return FindingClass.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Finding.getDescriptor().getEnumTypes().get(3);
    }

    private static final FindingClass[] VALUES = values();

    public static FindingClass valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FindingClass(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Finding.FindingClass)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The [relative resource
   * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
   * of the finding. Example:
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
   * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
   * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [relative resource
   * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
   * of the finding. Example:
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
   * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
   * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * The relative resource name of the source the finding belongs to. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * This field is immutable after creation time.
   * For example:
   * "organizations/{organization_id}/sources/{source_id}"
   * </pre>
   *
   * <code>string parent = 2;</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative resource name of the source the finding belongs to. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * This field is immutable after creation time.
   * For example:
   * "organizations/{organization_id}/sources/{source_id}"
   * </pre>
   *
   * <code>string parent = 2;</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   *
   *
   * <pre>
   * For findings on Google Cloud resources, the full resource
   * name of the Google Cloud resource this finding is for. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * When the finding is for a non-Google Cloud resource, the resourceName can
   * be a customer or partner defined string. This field is immutable after
   * creation time.
   * </pre>
   *
   * <code>string resource_name = 3;</code>
   *
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * For findings on Google Cloud resources, the full resource
   * name of the Google Cloud resource this finding is for. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * When the finding is for a non-Google Cloud resource, the resourceName can
   * be a customer or partner defined string. This field is immutable after
   * creation time.
   * </pre>
   *
   * <code>string resource_name = 3;</code>
   *
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The state of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The state of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Finding.State getState() {
    com.google.cloud.securitycenter.v1.Finding.State result =
        com.google.cloud.securitycenter.v1.Finding.State.forNumber(state_);
    return result == null ? com.google.cloud.securitycenter.v1.Finding.State.UNRECOGNIZED : result;
  }

  public static final int CATEGORY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object category_ = "";
  /**
   *
   *
   * <pre>
   * The additional taxonomy group within findings from a given source.
   * This field is immutable after creation time.
   * Example: "XSS_FLASH_INJECTION"
   * </pre>
   *
   * <code>string category = 5;</code>
   *
   * @return The category.
   */
  @java.lang.Override
  public java.lang.String getCategory() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      category_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The additional taxonomy group within findings from a given source.
   * This field is immutable after creation time.
   * Example: "XSS_FLASH_INJECTION"
   * </pre>
   *
   * <code>string category = 5;</code>
   *
   * @return The bytes for category.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCategoryBytes() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      category_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_URI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI that, if available, points to a web page outside of Security
   * Command Center where additional information about the finding can be found.
   * This field is guaranteed to be either empty or a well formed URL.
   * </pre>
   *
   * <code>string external_uri = 6;</code>
   *
   * @return The externalUri.
   */
  @java.lang.Override
  public java.lang.String getExternalUri() {
    java.lang.Object ref = externalUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI that, if available, points to a web page outside of Security
   * Command Center where additional information about the finding can be found.
   * This field is guaranteed to be either empty or a well formed URL.
   * </pre>
   *
   * <code>string external_uri = 6;</code>
   *
   * @return The bytes for externalUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalUriBytes() {
    java.lang.Object ref = externalUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_PROPERTIES_FIELD_NUMBER = 7;

  private static final class SourcePropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.securitycenter.v1.FindingOuterClass
                        .internal_static_google_cloud_securitycenter_v1_Finding_SourcePropertiesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      sourceProperties_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetSourceProperties() {
    if (sourceProperties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SourcePropertiesDefaultEntryHolder.defaultEntry);
    }
    return sourceProperties_;
  }

  public int getSourcePropertiesCount() {
    return internalGetSourceProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  @java.lang.Override
  public boolean containsSourceProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSourceProperties().getMap().containsKey(key);
  }
  /** Use {@link #getSourcePropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getSourceProperties() {
    return getSourcePropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getSourcePropertiesMap() {
    return internalGetSourceProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Value getSourcePropertiesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetSourceProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getSourcePropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetSourceProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SECURITY_MARKS_FIELD_NUMBER = 8;
  private com.google.cloud.securitycenter.v1.SecurityMarks securityMarks_;
  /**
   *
   *
   * <pre>
   * Output only. User specified security marks. These marks are entirely
   * managed by the user and come from the SecurityMarks resource that belongs
   * to the finding.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the securityMarks field is set.
   */
  @java.lang.Override
  public boolean hasSecurityMarks() {
    return securityMarks_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. User specified security marks. These marks are entirely
   * managed by the user and come from the SecurityMarks resource that belongs
   * to the finding.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The securityMarks.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityMarks getSecurityMarks() {
    return securityMarks_ == null
        ? com.google.cloud.securitycenter.v1.SecurityMarks.getDefaultInstance()
        : securityMarks_;
  }
  /**
   *
   *
   * <pre>
   * Output only. User specified security marks. These marks are entirely
   * managed by the user and come from the SecurityMarks resource that belongs
   * to the finding.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder getSecurityMarksOrBuilder() {
    return securityMarks_ == null
        ? com.google.cloud.securitycenter.v1.SecurityMarks.getDefaultInstance()
        : securityMarks_;
  }

  public static final int EVENT_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp eventTime_;
  /**
   *
   *
   * <pre>
   * The time the finding was first detected. If an existing finding is updated,
   * then this is the time the update occurred.
   * For example, if the finding represents an open firewall, this property
   * captures the time the detector believes the firewall became open. The
   * accuracy is determined by the detector. If the finding is later resolved,
   * then this time reflects when the finding was resolved. This must not
   * be set to a value greater than the current timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 9;</code>
   *
   * @return Whether the eventTime field is set.
   */
  @java.lang.Override
  public boolean hasEventTime() {
    return eventTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time the finding was first detected. If an existing finding is updated,
   * then this is the time the update occurred.
   * For example, if the finding represents an open firewall, this property
   * captures the time the detector believes the firewall became open. The
   * accuracy is determined by the detector. If the finding is later resolved,
   * then this time reflects when the finding was resolved. This must not
   * be set to a value greater than the current timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 9;</code>
   *
   * @return The eventTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEventTime() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the finding was first detected. If an existing finding is updated,
   * then this is the time the update occurred.
   * For example, if the finding represents an open firewall, this property
   * captures the time the detector believes the firewall became open. The
   * accuracy is determined by the detector. If the finding is later resolved,
   * then this time reflects when the finding was resolved. This must not
   * be set to a value greater than the current timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time at which the finding was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the finding was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the finding was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int SEVERITY_FIELD_NUMBER = 12;
  private int severity_ = 0;
  /**
   *
   *
   * <pre>
   * The severity of the finding. This field is managed by the source that
   * writes the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  @java.lang.Override
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * The severity of the finding. This field is managed by the source that
   * writes the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Finding.Severity getSeverity() {
    com.google.cloud.securitycenter.v1.Finding.Severity result =
        com.google.cloud.securitycenter.v1.Finding.Severity.forNumber(severity_);
    return result == null
        ? com.google.cloud.securitycenter.v1.Finding.Severity.UNRECOGNIZED
        : result;
  }

  public static final int CANONICAL_NAME_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object canonicalName_ = "";
  /**
   *
   *
   * <pre>
   * The canonical name of the finding. It's either
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
   * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
   * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
   * depending on the closest CRM ancestor of the resource associated with the
   * finding.
   * </pre>
   *
   * <code>string canonical_name = 14;</code>
   *
   * @return The canonicalName.
   */
  @java.lang.Override
  public java.lang.String getCanonicalName() {
    java.lang.Object ref = canonicalName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      canonicalName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The canonical name of the finding. It's either
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
   * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
   * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
   * depending on the closest CRM ancestor of the resource associated with the
   * finding.
   * </pre>
   *
   * <code>string canonical_name = 14;</code>
   *
   * @return The bytes for canonicalName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCanonicalNameBytes() {
    java.lang.Object ref = canonicalName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      canonicalName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MUTE_FIELD_NUMBER = 15;
  private int mute_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates the mute state of a finding (either muted, unmuted
   * or undefined). Unlike other attributes of a finding, a finding provider
   * shouldn't set the value of mute.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
   *
   * @return The enum numeric value on the wire for mute.
   */
  @java.lang.Override
  public int getMuteValue() {
    return mute_;
  }
  /**
   *
   *
   * <pre>
   * Indicates the mute state of a finding (either muted, unmuted
   * or undefined). Unlike other attributes of a finding, a finding provider
   * shouldn't set the value of mute.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
   *
   * @return The mute.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Finding.Mute getMute() {
    com.google.cloud.securitycenter.v1.Finding.Mute result =
        com.google.cloud.securitycenter.v1.Finding.Mute.forNumber(mute_);
    return result == null ? com.google.cloud.securitycenter.v1.Finding.Mute.UNRECOGNIZED : result;
  }

  public static final int FINDING_CLASS_FIELD_NUMBER = 17;
  private int findingClass_ = 0;
  /**
   *
   *
   * <pre>
   * The class of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
   *
   * @return The enum numeric value on the wire for findingClass.
   */
  @java.lang.Override
  public int getFindingClassValue() {
    return findingClass_;
  }
  /**
   *
   *
   * <pre>
   * The class of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
   *
   * @return The findingClass.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Finding.FindingClass getFindingClass() {
    com.google.cloud.securitycenter.v1.Finding.FindingClass result =
        com.google.cloud.securitycenter.v1.Finding.FindingClass.forNumber(findingClass_);
    return result == null
        ? com.google.cloud.securitycenter.v1.Finding.FindingClass.UNRECOGNIZED
        : result;
  }

  public static final int INDICATOR_FIELD_NUMBER = 18;
  private com.google.cloud.securitycenter.v1.Indicator indicator_;
  /**
   *
   *
   * <pre>
   * Represents what's commonly known as an *indicator of compromise* (IoC) in
   * computer forensics. This is an artifact observed on a network or in an
   * operating system that, with high confidence, indicates a computer
   * intrusion. For more information, see [Indicator of
   * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
   *
   * @return Whether the indicator field is set.
   */
  @java.lang.Override
  public boolean hasIndicator() {
    return indicator_ != null;
  }
  /**
   *
   *
   * <pre>
   * Represents what's commonly known as an *indicator of compromise* (IoC) in
   * computer forensics. This is an artifact observed on a network or in an
   * operating system that, with high confidence, indicates a computer
   * intrusion. For more information, see [Indicator of
   * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
   *
   * @return The indicator.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Indicator getIndicator() {
    return indicator_ == null
        ? com.google.cloud.securitycenter.v1.Indicator.getDefaultInstance()
        : indicator_;
  }
  /**
   *
   *
   * <pre>
   * Represents what's commonly known as an *indicator of compromise* (IoC) in
   * computer forensics. This is an artifact observed on a network or in an
   * operating system that, with high confidence, indicates a computer
   * intrusion. For more information, see [Indicator of
   * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.IndicatorOrBuilder getIndicatorOrBuilder() {
    return indicator_ == null
        ? com.google.cloud.securitycenter.v1.Indicator.getDefaultInstance()
        : indicator_;
  }

  public static final int VULNERABILITY_FIELD_NUMBER = 20;
  private com.google.cloud.securitycenter.v1.Vulnerability vulnerability_;
  /**
   *
   *
   * <pre>
   * Represents vulnerability-specific fields like CVE and CVSS scores.
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
   *
   * @return Whether the vulnerability field is set.
   */
  @java.lang.Override
  public boolean hasVulnerability() {
    return vulnerability_ != null;
  }
  /**
   *
   *
   * <pre>
   * Represents vulnerability-specific fields like CVE and CVSS scores.
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
   *
   * @return The vulnerability.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Vulnerability getVulnerability() {
    return vulnerability_ == null
        ? com.google.cloud.securitycenter.v1.Vulnerability.getDefaultInstance()
        : vulnerability_;
  }
  /**
   *
   *
   * <pre>
   * Represents vulnerability-specific fields like CVE and CVSS scores.
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.VulnerabilityOrBuilder getVulnerabilityOrBuilder() {
    return vulnerability_ == null
        ? com.google.cloud.securitycenter.v1.Vulnerability.getDefaultInstance()
        : vulnerability_;
  }

  public static final int MUTE_UPDATE_TIME_FIELD_NUMBER = 21;
  private com.google.protobuf.Timestamp muteUpdateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this finding was muted or unmuted.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the muteUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasMuteUpdateTime() {
    return muteUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this finding was muted or unmuted.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The muteUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getMuteUpdateTime() {
    return muteUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : muteUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this finding was muted or unmuted.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getMuteUpdateTimeOrBuilder() {
    return muteUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : muteUpdateTime_;
  }

  public static final int EXTERNAL_SYSTEMS_FIELD_NUMBER = 22;

  private static final class ExternalSystemsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
                    newDefaultInstance(
                        com.google.cloud.securitycenter.v1.FindingOuterClass
                            .internal_static_google_cloud_securitycenter_v1_Finding_ExternalSystemsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.securitycenter.v1.ExternalSystem.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
      externalSystems_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
      internalGetExternalSystems() {
    if (externalSystems_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ExternalSystemsDefaultEntryHolder.defaultEntry);
    }
    return externalSystems_;
  }

  public int getExternalSystemsCount() {
    return internalGetExternalSystems().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Third party SIEM/SOAR fields within SCC, contains external
   * system information and external system finding fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsExternalSystems(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetExternalSystems().getMap().containsKey(key);
  }
  /** Use {@link #getExternalSystemsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
      getExternalSystems() {
    return getExternalSystemsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Third party SIEM/SOAR fields within SCC, contains external
   * system information and external system finding fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
      getExternalSystemsMap() {
    return internalGetExternalSystems().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Third party SIEM/SOAR fields within SCC, contains external
   * system information and external system finding fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.securitycenter.v1.ExternalSystem
      getExternalSystemsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.securitycenter.v1.ExternalSystem defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem> map =
        internalGetExternalSystems().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Third party SIEM/SOAR fields within SCC, contains external
   * system information and external system finding fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExternalSystem getExternalSystemsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem> map =
        internalGetExternalSystems().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MITRE_ATTACK_FIELD_NUMBER = 25;
  private com.google.cloud.securitycenter.v1.MitreAttack mitreAttack_;
  /**
   *
   *
   * <pre>
   * MITRE ATT&amp;CK tactics and techniques related to this finding.
   * See: https://attack.mitre.org
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
   *
   * @return Whether the mitreAttack field is set.
   */
  @java.lang.Override
  public boolean hasMitreAttack() {
    return mitreAttack_ != null;
  }
  /**
   *
   *
   * <pre>
   * MITRE ATT&amp;CK tactics and techniques related to this finding.
   * See: https://attack.mitre.org
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
   *
   * @return The mitreAttack.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.MitreAttack getMitreAttack() {
    return mitreAttack_ == null
        ? com.google.cloud.securitycenter.v1.MitreAttack.getDefaultInstance()
        : mitreAttack_;
  }
  /**
   *
   *
   * <pre>
   * MITRE ATT&amp;CK tactics and techniques related to this finding.
   * See: https://attack.mitre.org
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.MitreAttackOrBuilder getMitreAttackOrBuilder() {
    return mitreAttack_ == null
        ? com.google.cloud.securitycenter.v1.MitreAttack.getDefaultInstance()
        : mitreAttack_;
  }

  public static final int ACCESS_FIELD_NUMBER = 26;
  private com.google.cloud.securitycenter.v1.Access access_;
  /**
   *
   *
   * <pre>
   * Access details associated with the finding, such as more information on the
   * caller, which method was accessed, and from where.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
   *
   * @return Whether the access field is set.
   */
  @java.lang.Override
  public boolean hasAccess() {
    return access_ != null;
  }
  /**
   *
   *
   * <pre>
   * Access details associated with the finding, such as more information on the
   * caller, which method was accessed, and from where.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
   *
   * @return The access.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Access getAccess() {
    return access_ == null
        ? com.google.cloud.securitycenter.v1.Access.getDefaultInstance()
        : access_;
  }
  /**
   *
   *
   * <pre>
   * Access details associated with the finding, such as more information on the
   * caller, which method was accessed, and from where.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.AccessOrBuilder getAccessOrBuilder() {
    return access_ == null
        ? com.google.cloud.securitycenter.v1.Access.getDefaultInstance()
        : access_;
  }

  public static final int CONNECTIONS_FIELD_NUMBER = 31;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Connection> connections_;
  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Connection> getConnectionsList() {
    return connections_;
  }
  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.ConnectionOrBuilder>
      getConnectionsOrBuilderList() {
    return connections_;
  }
  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  @java.lang.Override
  public int getConnectionsCount() {
    return connections_.size();
  }
  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Connection getConnections(int index) {
    return connections_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ConnectionOrBuilder getConnectionsOrBuilder(int index) {
    return connections_.get(index);
  }

  public static final int MUTE_INITIATOR_FIELD_NUMBER = 28;

  @SuppressWarnings("serial")
  private volatile java.lang.Object muteInitiator_ = "";
  /**
   *
   *
   * <pre>
   * Records additional information about the mute operation, for example, the
   * [mute configuration](/security-command-center/docs/how-to-mute-findings)
   * that muted the finding and the user who muted the finding.
   * </pre>
   *
   * <code>string mute_initiator = 28;</code>
   *
   * @return The muteInitiator.
   */
  @java.lang.Override
  public java.lang.String getMuteInitiator() {
    java.lang.Object ref = muteInitiator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      muteInitiator_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Records additional information about the mute operation, for example, the
   * [mute configuration](/security-command-center/docs/how-to-mute-findings)
   * that muted the finding and the user who muted the finding.
   * </pre>
   *
   * <code>string mute_initiator = 28;</code>
   *
   * @return The bytes for muteInitiator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMuteInitiatorBytes() {
    java.lang.Object ref = muteInitiator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      muteInitiator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROCESSES_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Process> processes_;
  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Process> getProcessesList() {
    return processes_;
  }
  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.ProcessOrBuilder>
      getProcessesOrBuilderList() {
    return processes_;
  }
  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  @java.lang.Override
  public int getProcessesCount() {
    return processes_.size();
  }
  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Process getProcesses(int index) {
    return processes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ProcessOrBuilder getProcessesOrBuilder(int index) {
    return processes_.get(index);
  }

  public static final int CONTACTS_FIELD_NUMBER = 33;

  private static final class ContactsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
                    newDefaultInstance(
                        com.google.cloud.securitycenter.v1.FindingOuterClass
                            .internal_static_google_cloud_securitycenter_v1_Finding_ContactsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.securitycenter.v1.ContactDetails.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
      contacts_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
      internalGetContacts() {
    if (contacts_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ContactsDefaultEntryHolder.defaultEntry);
    }
    return contacts_;
  }

  public int getContactsCount() {
    return internalGetContacts().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map containing the points of contact for the given finding.
   * The key represents the type of contact, while the value contains a list of
   * all the contacts that pertain. Please refer to:
   * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
   *
   *     {
   *       "security": {
   *         "contacts": [
   *           {
   *             "email": "person1&#64;company.com"
   *           },
   *           {
   *             "email": "person2&#64;company.com"
   *           }
   *         ]
   *       }
   *     }
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsContacts(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetContacts().getMap().containsKey(key);
  }
  /** Use {@link #getContactsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
      getContacts() {
    return getContactsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map containing the points of contact for the given finding.
   * The key represents the type of contact, while the value contains a list of
   * all the contacts that pertain. Please refer to:
   * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
   *
   *     {
   *       "security": {
   *         "contacts": [
   *           {
   *             "email": "person1&#64;company.com"
   *           },
   *           {
   *             "email": "person2&#64;company.com"
   *           }
   *         ]
   *       }
   *     }
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
      getContactsMap() {
    return internalGetContacts().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map containing the points of contact for the given finding.
   * The key represents the type of contact, while the value contains a list of
   * all the contacts that pertain. Please refer to:
   * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
   *
   *     {
   *       "security": {
   *         "contacts": [
   *           {
   *             "email": "person1&#64;company.com"
   *           },
   *           {
   *             "email": "person2&#64;company.com"
   *           }
   *         ]
   *       }
   *     }
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.securitycenter.v1.ContactDetails getContactsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.securitycenter.v1.ContactDetails defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails> map =
        internalGetContacts().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Map containing the points of contact for the given finding.
   * The key represents the type of contact, while the value contains a list of
   * all the contacts that pertain. Please refer to:
   * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
   *
   *     {
   *       "security": {
   *         "contacts": [
   *           {
   *             "email": "person1&#64;company.com"
   *           },
   *           {
   *             "email": "person2&#64;company.com"
   *           }
   *         ]
   *       }
   *     }
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ContactDetails getContactsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails> map =
        internalGetContacts().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int COMPLIANCES_FIELD_NUMBER = 34;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Compliance> compliances_;
  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Compliance> getCompliancesList() {
    return compliances_;
  }
  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.ComplianceOrBuilder>
      getCompliancesOrBuilderList() {
    return compliances_;
  }
  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  @java.lang.Override
  public int getCompliancesCount() {
    return compliances_.size();
  }
  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Compliance getCompliances(int index) {
    return compliances_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ComplianceOrBuilder getCompliancesOrBuilder(int index) {
    return compliances_.get(index);
  }

  public static final int PARENT_DISPLAY_NAME_FIELD_NUMBER = 36;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentDisplayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The human readable display name of the finding source such as
   * "Event Threat Detection" or "Security Health Analytics".
   * </pre>
   *
   * <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The parentDisplayName.
   */
  @java.lang.Override
  public java.lang.String getParentDisplayName() {
    java.lang.Object ref = parentDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The human readable display name of the finding source such as
   * "Event Threat Detection" or "Security Health Analytics".
   * </pre>
   *
   * <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for parentDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentDisplayNameBytes() {
    java.lang.Object ref = parentDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 37;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Contains more details about the finding.
   * </pre>
   *
   * <code>string description = 37;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Contains more details about the finding.
   * </pre>
   *
   * <code>string description = 37;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXFILTRATION_FIELD_NUMBER = 38;
  private com.google.cloud.securitycenter.v1.Exfiltration exfiltration_;
  /**
   *
   *
   * <pre>
   * Represents exfiltrations associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
   *
   * @return Whether the exfiltration field is set.
   */
  @java.lang.Override
  public boolean hasExfiltration() {
    return exfiltration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Represents exfiltrations associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
   *
   * @return The exfiltration.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Exfiltration getExfiltration() {
    return exfiltration_ == null
        ? com.google.cloud.securitycenter.v1.Exfiltration.getDefaultInstance()
        : exfiltration_;
  }
  /**
   *
   *
   * <pre>
   * Represents exfiltrations associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExfiltrationOrBuilder getExfiltrationOrBuilder() {
    return exfiltration_ == null
        ? com.google.cloud.securitycenter.v1.Exfiltration.getDefaultInstance()
        : exfiltration_;
  }

  public static final int IAM_BINDINGS_FIELD_NUMBER = 39;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.IamBinding> iamBindings_;
  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.IamBinding> getIamBindingsList() {
    return iamBindings_;
  }
  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.IamBindingOrBuilder>
      getIamBindingsOrBuilderList() {
    return iamBindings_;
  }
  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  @java.lang.Override
  public int getIamBindingsCount() {
    return iamBindings_.size();
  }
  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.IamBinding getIamBindings(int index) {
    return iamBindings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.IamBindingOrBuilder getIamBindingsOrBuilder(int index) {
    return iamBindings_.get(index);
  }

  public static final int NEXT_STEPS_FIELD_NUMBER = 40;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextSteps_ = "";
  /**
   *
   *
   * <pre>
   * Steps to address the finding.
   * </pre>
   *
   * <code>string next_steps = 40;</code>
   *
   * @return The nextSteps.
   */
  @java.lang.Override
  public java.lang.String getNextSteps() {
    java.lang.Object ref = nextSteps_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextSteps_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Steps to address the finding.
   * </pre>
   *
   * <code>string next_steps = 40;</code>
   *
   * @return The bytes for nextSteps.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextStepsBytes() {
    java.lang.Object ref = nextSteps_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextSteps_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODULE_NAME_FIELD_NUMBER = 41;

  @SuppressWarnings("serial")
  private volatile java.lang.Object moduleName_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier of the module which generated the finding.
   * Example:
   * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
   * </pre>
   *
   * <code>string module_name = 41;</code>
   *
   * @return The moduleName.
   */
  @java.lang.Override
  public java.lang.String getModuleName() {
    java.lang.Object ref = moduleName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      moduleName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier of the module which generated the finding.
   * Example:
   * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
   * </pre>
   *
   * <code>string module_name = 41;</code>
   *
   * @return The bytes for moduleName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModuleNameBytes() {
    java.lang.Object ref = moduleName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      moduleName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINERS_FIELD_NUMBER = 42;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Container> containers_;
  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Container> getContainersList() {
    return containers_;
  }
  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.ContainerOrBuilder>
      getContainersOrBuilderList() {
    return containers_;
  }
  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  @java.lang.Override
  public int getContainersCount() {
    return containers_.size();
  }
  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Container getContainers(int index) {
    return containers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ContainerOrBuilder getContainersOrBuilder(int index) {
    return containers_.get(index);
  }

  public static final int KUBERNETES_FIELD_NUMBER = 43;
  private com.google.cloud.securitycenter.v1.Kubernetes kubernetes_;
  /**
   *
   *
   * <pre>
   * Kubernetes resources associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
   *
   * @return Whether the kubernetes field is set.
   */
  @java.lang.Override
  public boolean hasKubernetes() {
    return kubernetes_ != null;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes resources associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
   *
   * @return The kubernetes.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes getKubernetes() {
    return kubernetes_ == null
        ? com.google.cloud.securitycenter.v1.Kubernetes.getDefaultInstance()
        : kubernetes_;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes resources associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.KubernetesOrBuilder getKubernetesOrBuilder() {
    return kubernetes_ == null
        ? com.google.cloud.securitycenter.v1.Kubernetes.getDefaultInstance()
        : kubernetes_;
  }

  public static final int DATABASE_FIELD_NUMBER = 44;
  private com.google.cloud.securitycenter.v1.Database database_;
  /**
   *
   *
   * <pre>
   * Database associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
   *
   * @return Whether the database field is set.
   */
  @java.lang.Override
  public boolean hasDatabase() {
    return database_ != null;
  }
  /**
   *
   *
   * <pre>
   * Database associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Database getDatabase() {
    return database_ == null
        ? com.google.cloud.securitycenter.v1.Database.getDefaultInstance()
        : database_;
  }
  /**
   *
   *
   * <pre>
   * Database associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.DatabaseOrBuilder getDatabaseOrBuilder() {
    return database_ == null
        ? com.google.cloud.securitycenter.v1.Database.getDefaultInstance()
        : database_;
  }

  public static final int FILES_FIELD_NUMBER = 46;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.File> files_;
  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.File> getFilesList() {
    return files_;
  }
  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.FileOrBuilder>
      getFilesOrBuilderList() {
    return files_;
  }
  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  @java.lang.Override
  public int getFilesCount() {
    return files_.size();
  }
  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.File getFiles(int index) {
    return files_.get(index);
  }
  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.FileOrBuilder getFilesOrBuilder(int index) {
    return files_.get(index);
  }

  public static final int CLOUD_DLP_INSPECTION_FIELD_NUMBER = 48;
  private com.google.cloud.securitycenter.v1.CloudDlpInspection cloudDlpInspection_;
  /**
   *
   *
   * <pre>
   * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
   * associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
   *
   * @return Whether the cloudDlpInspection field is set.
   */
  @java.lang.Override
  public boolean hasCloudDlpInspection() {
    return cloudDlpInspection_ != null;
  }
  /**
   *
   *
   * <pre>
   * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
   * associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
   *
   * @return The cloudDlpInspection.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CloudDlpInspection getCloudDlpInspection() {
    return cloudDlpInspection_ == null
        ? com.google.cloud.securitycenter.v1.CloudDlpInspection.getDefaultInstance()
        : cloudDlpInspection_;
  }
  /**
   *
   *
   * <pre>
   * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
   * associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CloudDlpInspectionOrBuilder
      getCloudDlpInspectionOrBuilder() {
    return cloudDlpInspection_ == null
        ? com.google.cloud.securitycenter.v1.CloudDlpInspection.getDefaultInstance()
        : cloudDlpInspection_;
  }

  public static final int CLOUD_DLP_DATA_PROFILE_FIELD_NUMBER = 49;
  private com.google.cloud.securitycenter.v1.CloudDlpDataProfile cloudDlpDataProfile_;
  /**
   *
   *
   * <pre>
   * Cloud DLP data profile that is associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
   *
   * @return Whether the cloudDlpDataProfile field is set.
   */
  @java.lang.Override
  public boolean hasCloudDlpDataProfile() {
    return cloudDlpDataProfile_ != null;
  }
  /**
   *
   *
   * <pre>
   * Cloud DLP data profile that is associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
   *
   * @return The cloudDlpDataProfile.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CloudDlpDataProfile getCloudDlpDataProfile() {
    return cloudDlpDataProfile_ == null
        ? com.google.cloud.securitycenter.v1.CloudDlpDataProfile.getDefaultInstance()
        : cloudDlpDataProfile_;
  }
  /**
   *
   *
   * <pre>
   * Cloud DLP data profile that is associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CloudDlpDataProfileOrBuilder
      getCloudDlpDataProfileOrBuilder() {
    return cloudDlpDataProfile_ == null
        ? com.google.cloud.securitycenter.v1.CloudDlpDataProfile.getDefaultInstance()
        : cloudDlpDataProfile_;
  }

  public static final int KERNEL_ROOTKIT_FIELD_NUMBER = 50;
  private com.google.cloud.securitycenter.v1.KernelRootkit kernelRootkit_;
  /**
   *
   *
   * <pre>
   * Signature of the kernel rootkit.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
   *
   * @return Whether the kernelRootkit field is set.
   */
  @java.lang.Override
  public boolean hasKernelRootkit() {
    return kernelRootkit_ != null;
  }
  /**
   *
   *
   * <pre>
   * Signature of the kernel rootkit.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
   *
   * @return The kernelRootkit.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.KernelRootkit getKernelRootkit() {
    return kernelRootkit_ == null
        ? com.google.cloud.securitycenter.v1.KernelRootkit.getDefaultInstance()
        : kernelRootkit_;
  }
  /**
   *
   *
   * <pre>
   * Signature of the kernel rootkit.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.KernelRootkitOrBuilder getKernelRootkitOrBuilder() {
    return kernelRootkit_ == null
        ? com.google.cloud.securitycenter.v1.KernelRootkit.getDefaultInstance()
        : kernelRootkit_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resourceName_);
    }
    if (state_ != com.google.cloud.securitycenter.v1.Finding.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(category_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, category_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, externalUri_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSourceProperties(), SourcePropertiesDefaultEntryHolder.defaultEntry, 7);
    if (securityMarks_ != null) {
      output.writeMessage(8, getSecurityMarks());
    }
    if (eventTime_ != null) {
      output.writeMessage(9, getEventTime());
    }
    if (createTime_ != null) {
      output.writeMessage(10, getCreateTime());
    }
    if (severity_
        != com.google.cloud.securitycenter.v1.Finding.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(12, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, canonicalName_);
    }
    if (mute_ != com.google.cloud.securitycenter.v1.Finding.Mute.MUTE_UNSPECIFIED.getNumber()) {
      output.writeEnum(15, mute_);
    }
    if (findingClass_
        != com.google.cloud.securitycenter.v1.Finding.FindingClass.FINDING_CLASS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(17, findingClass_);
    }
    if (indicator_ != null) {
      output.writeMessage(18, getIndicator());
    }
    if (vulnerability_ != null) {
      output.writeMessage(20, getVulnerability());
    }
    if (muteUpdateTime_ != null) {
      output.writeMessage(21, getMuteUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetExternalSystems(), ExternalSystemsDefaultEntryHolder.defaultEntry, 22);
    if (mitreAttack_ != null) {
      output.writeMessage(25, getMitreAttack());
    }
    if (access_ != null) {
      output.writeMessage(26, getAccess());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(muteInitiator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 28, muteInitiator_);
    }
    for (int i = 0; i < processes_.size(); i++) {
      output.writeMessage(30, processes_.get(i));
    }
    for (int i = 0; i < connections_.size(); i++) {
      output.writeMessage(31, connections_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetContacts(), ContactsDefaultEntryHolder.defaultEntry, 33);
    for (int i = 0; i < compliances_.size(); i++) {
      output.writeMessage(34, compliances_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 36, parentDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 37, description_);
    }
    if (exfiltration_ != null) {
      output.writeMessage(38, getExfiltration());
    }
    for (int i = 0; i < iamBindings_.size(); i++) {
      output.writeMessage(39, iamBindings_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextSteps_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 40, nextSteps_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(moduleName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 41, moduleName_);
    }
    for (int i = 0; i < containers_.size(); i++) {
      output.writeMessage(42, containers_.get(i));
    }
    if (kubernetes_ != null) {
      output.writeMessage(43, getKubernetes());
    }
    if (database_ != null) {
      output.writeMessage(44, getDatabase());
    }
    for (int i = 0; i < files_.size(); i++) {
      output.writeMessage(46, files_.get(i));
    }
    if (cloudDlpInspection_ != null) {
      output.writeMessage(48, getCloudDlpInspection());
    }
    if (cloudDlpDataProfile_ != null) {
      output.writeMessage(49, getCloudDlpDataProfile());
    }
    if (kernelRootkit_ != null) {
      output.writeMessage(50, getKernelRootkit());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resourceName_);
    }
    if (state_ != com.google.cloud.securitycenter.v1.Finding.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(category_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, category_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, externalUri_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetSourceProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> sourceProperties__ =
          SourcePropertiesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, sourceProperties__);
    }
    if (securityMarks_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSecurityMarks());
    }
    if (eventTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getEventTime());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreateTime());
    }
    if (severity_
        != com.google.cloud.securitycenter.v1.Finding.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, canonicalName_);
    }
    if (mute_ != com.google.cloud.securitycenter.v1.Finding.Mute.MUTE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, mute_);
    }
    if (findingClass_
        != com.google.cloud.securitycenter.v1.Finding.FindingClass.FINDING_CLASS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(17, findingClass_);
    }
    if (indicator_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getIndicator());
    }
    if (vulnerability_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getVulnerability());
    }
    if (muteUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getMuteUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
        entry : internalGetExternalSystems().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
          externalSystems__ =
              ExternalSystemsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, externalSystems__);
    }
    if (mitreAttack_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getMitreAttack());
    }
    if (access_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getAccess());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(muteInitiator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(28, muteInitiator_);
    }
    for (int i = 0; i < processes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(30, processes_.get(i));
    }
    for (int i = 0; i < connections_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, connections_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
        entry : internalGetContacts().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
          contacts__ =
              ContactsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(33, contacts__);
    }
    for (int i = 0; i < compliances_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(34, compliances_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(36, parentDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(37, description_);
    }
    if (exfiltration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(38, getExfiltration());
    }
    for (int i = 0; i < iamBindings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(39, iamBindings_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextSteps_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(40, nextSteps_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(moduleName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(41, moduleName_);
    }
    for (int i = 0; i < containers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(42, containers_.get(i));
    }
    if (kubernetes_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(43, getKubernetes());
    }
    if (database_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(44, getDatabase());
    }
    for (int i = 0; i < files_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(46, files_.get(i));
    }
    if (cloudDlpInspection_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(48, getCloudDlpInspection());
    }
    if (cloudDlpDataProfile_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(49, getCloudDlpDataProfile());
    }
    if (kernelRootkit_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(50, getKernelRootkit());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Finding)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Finding other =
        (com.google.cloud.securitycenter.v1.Finding) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getParent().equals(other.getParent())) return false;
    if (!getResourceName().equals(other.getResourceName())) return false;
    if (state_ != other.state_) return false;
    if (!getCategory().equals(other.getCategory())) return false;
    if (!getExternalUri().equals(other.getExternalUri())) return false;
    if (!internalGetSourceProperties().equals(other.internalGetSourceProperties())) return false;
    if (hasSecurityMarks() != other.hasSecurityMarks()) return false;
    if (hasSecurityMarks()) {
      if (!getSecurityMarks().equals(other.getSecurityMarks())) return false;
    }
    if (hasEventTime() != other.hasEventTime()) return false;
    if (hasEventTime()) {
      if (!getEventTime().equals(other.getEventTime())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (severity_ != other.severity_) return false;
    if (!getCanonicalName().equals(other.getCanonicalName())) return false;
    if (mute_ != other.mute_) return false;
    if (findingClass_ != other.findingClass_) return false;
    if (hasIndicator() != other.hasIndicator()) return false;
    if (hasIndicator()) {
      if (!getIndicator().equals(other.getIndicator())) return false;
    }
    if (hasVulnerability() != other.hasVulnerability()) return false;
    if (hasVulnerability()) {
      if (!getVulnerability().equals(other.getVulnerability())) return false;
    }
    if (hasMuteUpdateTime() != other.hasMuteUpdateTime()) return false;
    if (hasMuteUpdateTime()) {
      if (!getMuteUpdateTime().equals(other.getMuteUpdateTime())) return false;
    }
    if (!internalGetExternalSystems().equals(other.internalGetExternalSystems())) return false;
    if (hasMitreAttack() != other.hasMitreAttack()) return false;
    if (hasMitreAttack()) {
      if (!getMitreAttack().equals(other.getMitreAttack())) return false;
    }
    if (hasAccess() != other.hasAccess()) return false;
    if (hasAccess()) {
      if (!getAccess().equals(other.getAccess())) return false;
    }
    if (!getConnectionsList().equals(other.getConnectionsList())) return false;
    if (!getMuteInitiator().equals(other.getMuteInitiator())) return false;
    if (!getProcessesList().equals(other.getProcessesList())) return false;
    if (!internalGetContacts().equals(other.internalGetContacts())) return false;
    if (!getCompliancesList().equals(other.getCompliancesList())) return false;
    if (!getParentDisplayName().equals(other.getParentDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasExfiltration() != other.hasExfiltration()) return false;
    if (hasExfiltration()) {
      if (!getExfiltration().equals(other.getExfiltration())) return false;
    }
    if (!getIamBindingsList().equals(other.getIamBindingsList())) return false;
    if (!getNextSteps().equals(other.getNextSteps())) return false;
    if (!getModuleName().equals(other.getModuleName())) return false;
    if (!getContainersList().equals(other.getContainersList())) return false;
    if (hasKubernetes() != other.hasKubernetes()) return false;
    if (hasKubernetes()) {
      if (!getKubernetes().equals(other.getKubernetes())) return false;
    }
    if (hasDatabase() != other.hasDatabase()) return false;
    if (hasDatabase()) {
      if (!getDatabase().equals(other.getDatabase())) return false;
    }
    if (!getFilesList().equals(other.getFilesList())) return false;
    if (hasCloudDlpInspection() != other.hasCloudDlpInspection()) return false;
    if (hasCloudDlpInspection()) {
      if (!getCloudDlpInspection().equals(other.getCloudDlpInspection())) return false;
    }
    if (hasCloudDlpDataProfile() != other.hasCloudDlpDataProfile()) return false;
    if (hasCloudDlpDataProfile()) {
      if (!getCloudDlpDataProfile().equals(other.getCloudDlpDataProfile())) return false;
    }
    if (hasKernelRootkit() != other.hasKernelRootkit()) return false;
    if (hasKernelRootkit()) {
      if (!getKernelRootkit().equals(other.getKernelRootkit())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + getCategory().hashCode();
    hash = (37 * hash) + EXTERNAL_URI_FIELD_NUMBER;
    hash = (53 * hash) + getExternalUri().hashCode();
    if (!internalGetSourceProperties().getMap().isEmpty()) {
      hash = (37 * hash) + SOURCE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSourceProperties().hashCode();
    }
    if (hasSecurityMarks()) {
      hash = (37 * hash) + SECURITY_MARKS_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityMarks().hashCode();
    }
    if (hasEventTime()) {
      hash = (37 * hash) + EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEventTime().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    hash = (37 * hash) + CANONICAL_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getCanonicalName().hashCode();
    hash = (37 * hash) + MUTE_FIELD_NUMBER;
    hash = (53 * hash) + mute_;
    hash = (37 * hash) + FINDING_CLASS_FIELD_NUMBER;
    hash = (53 * hash) + findingClass_;
    if (hasIndicator()) {
      hash = (37 * hash) + INDICATOR_FIELD_NUMBER;
      hash = (53 * hash) + getIndicator().hashCode();
    }
    if (hasVulnerability()) {
      hash = (37 * hash) + VULNERABILITY_FIELD_NUMBER;
      hash = (53 * hash) + getVulnerability().hashCode();
    }
    if (hasMuteUpdateTime()) {
      hash = (37 * hash) + MUTE_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getMuteUpdateTime().hashCode();
    }
    if (!internalGetExternalSystems().getMap().isEmpty()) {
      hash = (37 * hash) + EXTERNAL_SYSTEMS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetExternalSystems().hashCode();
    }
    if (hasMitreAttack()) {
      hash = (37 * hash) + MITRE_ATTACK_FIELD_NUMBER;
      hash = (53 * hash) + getMitreAttack().hashCode();
    }
    if (hasAccess()) {
      hash = (37 * hash) + ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + getAccess().hashCode();
    }
    if (getConnectionsCount() > 0) {
      hash = (37 * hash) + CONNECTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionsList().hashCode();
    }
    hash = (37 * hash) + MUTE_INITIATOR_FIELD_NUMBER;
    hash = (53 * hash) + getMuteInitiator().hashCode();
    if (getProcessesCount() > 0) {
      hash = (37 * hash) + PROCESSES_FIELD_NUMBER;
      hash = (53 * hash) + getProcessesList().hashCode();
    }
    if (!internalGetContacts().getMap().isEmpty()) {
      hash = (37 * hash) + CONTACTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetContacts().hashCode();
    }
    if (getCompliancesCount() > 0) {
      hash = (37 * hash) + COMPLIANCES_FIELD_NUMBER;
      hash = (53 * hash) + getCompliancesList().hashCode();
    }
    hash = (37 * hash) + PARENT_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getParentDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasExfiltration()) {
      hash = (37 * hash) + EXFILTRATION_FIELD_NUMBER;
      hash = (53 * hash) + getExfiltration().hashCode();
    }
    if (getIamBindingsCount() > 0) {
      hash = (37 * hash) + IAM_BINDINGS_FIELD_NUMBER;
      hash = (53 * hash) + getIamBindingsList().hashCode();
    }
    hash = (37 * hash) + NEXT_STEPS_FIELD_NUMBER;
    hash = (53 * hash) + getNextSteps().hashCode();
    hash = (37 * hash) + MODULE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getModuleName().hashCode();
    if (getContainersCount() > 0) {
      hash = (37 * hash) + CONTAINERS_FIELD_NUMBER;
      hash = (53 * hash) + getContainersList().hashCode();
    }
    if (hasKubernetes()) {
      hash = (37 * hash) + KUBERNETES_FIELD_NUMBER;
      hash = (53 * hash) + getKubernetes().hashCode();
    }
    if (hasDatabase()) {
      hash = (37 * hash) + DATABASE_FIELD_NUMBER;
      hash = (53 * hash) + getDatabase().hashCode();
    }
    if (getFilesCount() > 0) {
      hash = (37 * hash) + FILES_FIELD_NUMBER;
      hash = (53 * hash) + getFilesList().hashCode();
    }
    if (hasCloudDlpInspection()) {
      hash = (37 * hash) + CLOUD_DLP_INSPECTION_FIELD_NUMBER;
      hash = (53 * hash) + getCloudDlpInspection().hashCode();
    }
    if (hasCloudDlpDataProfile()) {
      hash = (37 * hash) + CLOUD_DLP_DATA_PROFILE_FIELD_NUMBER;
      hash = (53 * hash) + getCloudDlpDataProfile().hashCode();
    }
    if (hasKernelRootkit()) {
      hash = (37 * hash) + KERNEL_ROOTKIT_FIELD_NUMBER;
      hash = (53 * hash) + getKernelRootkit().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Finding prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Security Command Center finding.
   *
   * A finding is a record of assessment data like security, risk, health, or
   * privacy, that is ingested into Security Command Center for presentation,
   * notification, analysis, policy testing, and enforcement. For example, a
   * cross-site scripting (XSS) vulnerability in an App Engine application is a
   * finding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Finding}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Finding)
      com.google.cloud.securitycenter.v1.FindingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.FindingOuterClass
          .internal_static_google_cloud_securitycenter_v1_Finding_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetSourceProperties();
        case 22:
          return internalGetExternalSystems();
        case 33:
          return internalGetContacts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableSourceProperties();
        case 22:
          return internalGetMutableExternalSystems();
        case 33:
          return internalGetMutableContacts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.FindingOuterClass
          .internal_static_google_cloud_securitycenter_v1_Finding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Finding.class,
              com.google.cloud.securitycenter.v1.Finding.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Finding.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      name_ = "";
      parent_ = "";
      resourceName_ = "";
      state_ = 0;
      category_ = "";
      externalUri_ = "";
      internalGetMutableSourceProperties().clear();
      securityMarks_ = null;
      if (securityMarksBuilder_ != null) {
        securityMarksBuilder_.dispose();
        securityMarksBuilder_ = null;
      }
      eventTime_ = null;
      if (eventTimeBuilder_ != null) {
        eventTimeBuilder_.dispose();
        eventTimeBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      severity_ = 0;
      canonicalName_ = "";
      mute_ = 0;
      findingClass_ = 0;
      indicator_ = null;
      if (indicatorBuilder_ != null) {
        indicatorBuilder_.dispose();
        indicatorBuilder_ = null;
      }
      vulnerability_ = null;
      if (vulnerabilityBuilder_ != null) {
        vulnerabilityBuilder_.dispose();
        vulnerabilityBuilder_ = null;
      }
      muteUpdateTime_ = null;
      if (muteUpdateTimeBuilder_ != null) {
        muteUpdateTimeBuilder_.dispose();
        muteUpdateTimeBuilder_ = null;
      }
      internalGetMutableExternalSystems().clear();
      mitreAttack_ = null;
      if (mitreAttackBuilder_ != null) {
        mitreAttackBuilder_.dispose();
        mitreAttackBuilder_ = null;
      }
      access_ = null;
      if (accessBuilder_ != null) {
        accessBuilder_.dispose();
        accessBuilder_ = null;
      }
      if (connectionsBuilder_ == null) {
        connections_ = java.util.Collections.emptyList();
      } else {
        connections_ = null;
        connectionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00100000);
      muteInitiator_ = "";
      if (processesBuilder_ == null) {
        processes_ = java.util.Collections.emptyList();
      } else {
        processes_ = null;
        processesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00400000);
      internalGetMutableContacts().clear();
      if (compliancesBuilder_ == null) {
        compliances_ = java.util.Collections.emptyList();
      } else {
        compliances_ = null;
        compliancesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x01000000);
      parentDisplayName_ = "";
      description_ = "";
      exfiltration_ = null;
      if (exfiltrationBuilder_ != null) {
        exfiltrationBuilder_.dispose();
        exfiltrationBuilder_ = null;
      }
      if (iamBindingsBuilder_ == null) {
        iamBindings_ = java.util.Collections.emptyList();
      } else {
        iamBindings_ = null;
        iamBindingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x10000000);
      nextSteps_ = "";
      moduleName_ = "";
      if (containersBuilder_ == null) {
        containers_ = java.util.Collections.emptyList();
      } else {
        containers_ = null;
        containersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x80000000);
      kubernetes_ = null;
      if (kubernetesBuilder_ != null) {
        kubernetesBuilder_.dispose();
        kubernetesBuilder_ = null;
      }
      database_ = null;
      if (databaseBuilder_ != null) {
        databaseBuilder_.dispose();
        databaseBuilder_ = null;
      }
      if (filesBuilder_ == null) {
        files_ = java.util.Collections.emptyList();
      } else {
        files_ = null;
        filesBuilder_.clear();
      }
      bitField1_ = (bitField1_ & ~0x00000004);
      cloudDlpInspection_ = null;
      if (cloudDlpInspectionBuilder_ != null) {
        cloudDlpInspectionBuilder_.dispose();
        cloudDlpInspectionBuilder_ = null;
      }
      cloudDlpDataProfile_ = null;
      if (cloudDlpDataProfileBuilder_ != null) {
        cloudDlpDataProfileBuilder_.dispose();
        cloudDlpDataProfileBuilder_ = null;
      }
      kernelRootkit_ = null;
      if (kernelRootkitBuilder_ != null) {
        kernelRootkitBuilder_.dispose();
        kernelRootkitBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.FindingOuterClass
          .internal_static_google_cloud_securitycenter_v1_Finding_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Finding.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding build() {
      com.google.cloud.securitycenter.v1.Finding result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding buildPartial() {
      com.google.cloud.securitycenter.v1.Finding result =
          new com.google.cloud.securitycenter.v1.Finding(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.securitycenter.v1.Finding result) {
      if (connectionsBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)) {
          connections_ = java.util.Collections.unmodifiableList(connections_);
          bitField0_ = (bitField0_ & ~0x00100000);
        }
        result.connections_ = connections_;
      } else {
        result.connections_ = connectionsBuilder_.build();
      }
      if (processesBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)) {
          processes_ = java.util.Collections.unmodifiableList(processes_);
          bitField0_ = (bitField0_ & ~0x00400000);
        }
        result.processes_ = processes_;
      } else {
        result.processes_ = processesBuilder_.build();
      }
      if (compliancesBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)) {
          compliances_ = java.util.Collections.unmodifiableList(compliances_);
          bitField0_ = (bitField0_ & ~0x01000000);
        }
        result.compliances_ = compliances_;
      } else {
        result.compliances_ = compliancesBuilder_.build();
      }
      if (iamBindingsBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)) {
          iamBindings_ = java.util.Collections.unmodifiableList(iamBindings_);
          bitField0_ = (bitField0_ & ~0x10000000);
        }
        result.iamBindings_ = iamBindings_;
      } else {
        result.iamBindings_ = iamBindingsBuilder_.build();
      }
      if (containersBuilder_ == null) {
        if (((bitField0_ & 0x80000000) != 0)) {
          containers_ = java.util.Collections.unmodifiableList(containers_);
          bitField0_ = (bitField0_ & ~0x80000000);
        }
        result.containers_ = containers_;
      } else {
        result.containers_ = containersBuilder_.build();
      }
      if (filesBuilder_ == null) {
        if (((bitField1_ & 0x00000004) != 0)) {
          files_ = java.util.Collections.unmodifiableList(files_);
          bitField1_ = (bitField1_ & ~0x00000004);
        }
        result.files_ = files_;
      } else {
        result.files_ = filesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Finding result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.category_ = category_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.externalUri_ = externalUri_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sourceProperties_ = internalGetSourceProperties();
        result.sourceProperties_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.securityMarks_ =
            securityMarksBuilder_ == null ? securityMarks_ : securityMarksBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.eventTime_ = eventTimeBuilder_ == null ? eventTime_ : eventTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.severity_ = severity_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.canonicalName_ = canonicalName_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.mute_ = mute_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.findingClass_ = findingClass_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.indicator_ = indicatorBuilder_ == null ? indicator_ : indicatorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.vulnerability_ =
            vulnerabilityBuilder_ == null ? vulnerability_ : vulnerabilityBuilder_.build();
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.muteUpdateTime_ =
            muteUpdateTimeBuilder_ == null ? muteUpdateTime_ : muteUpdateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.externalSystems_ = internalGetExternalSystems();
        result.externalSystems_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.mitreAttack_ =
            mitreAttackBuilder_ == null ? mitreAttack_ : mitreAttackBuilder_.build();
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.access_ = accessBuilder_ == null ? access_ : accessBuilder_.build();
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.muteInitiator_ = muteInitiator_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.contacts_ = internalGetContacts();
        result.contacts_.makeImmutable();
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.parentDisplayName_ = parentDisplayName_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.exfiltration_ =
            exfiltrationBuilder_ == null ? exfiltration_ : exfiltrationBuilder_.build();
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.nextSteps_ = nextSteps_;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.moduleName_ = moduleName_;
      }
    }

    private void buildPartial1(com.google.cloud.securitycenter.v1.Finding result) {
      int from_bitField1_ = bitField1_;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.kubernetes_ = kubernetesBuilder_ == null ? kubernetes_ : kubernetesBuilder_.build();
      }
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.database_ = databaseBuilder_ == null ? database_ : databaseBuilder_.build();
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.cloudDlpInspection_ =
            cloudDlpInspectionBuilder_ == null
                ? cloudDlpInspection_
                : cloudDlpInspectionBuilder_.build();
      }
      if (((from_bitField1_ & 0x00000010) != 0)) {
        result.cloudDlpDataProfile_ =
            cloudDlpDataProfileBuilder_ == null
                ? cloudDlpDataProfile_
                : cloudDlpDataProfileBuilder_.build();
      }
      if (((from_bitField1_ & 0x00000020) != 0)) {
        result.kernelRootkit_ =
            kernelRootkitBuilder_ == null ? kernelRootkit_ : kernelRootkitBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Finding) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Finding) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Finding other) {
      if (other == com.google.cloud.securitycenter.v1.Finding.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getCategory().isEmpty()) {
        category_ = other.category_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getExternalUri().isEmpty()) {
        externalUri_ = other.externalUri_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableSourceProperties().mergeFrom(other.internalGetSourceProperties());
      bitField0_ |= 0x00000040;
      if (other.hasSecurityMarks()) {
        mergeSecurityMarks(other.getSecurityMarks());
      }
      if (other.hasEventTime()) {
        mergeEventTime(other.getEventTime());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      if (!other.getCanonicalName().isEmpty()) {
        canonicalName_ = other.canonicalName_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.mute_ != 0) {
        setMuteValue(other.getMuteValue());
      }
      if (other.findingClass_ != 0) {
        setFindingClassValue(other.getFindingClassValue());
      }
      if (other.hasIndicator()) {
        mergeIndicator(other.getIndicator());
      }
      if (other.hasVulnerability()) {
        mergeVulnerability(other.getVulnerability());
      }
      if (other.hasMuteUpdateTime()) {
        mergeMuteUpdateTime(other.getMuteUpdateTime());
      }
      internalGetMutableExternalSystems().mergeFrom(other.internalGetExternalSystems());
      bitField0_ |= 0x00020000;
      if (other.hasMitreAttack()) {
        mergeMitreAttack(other.getMitreAttack());
      }
      if (other.hasAccess()) {
        mergeAccess(other.getAccess());
      }
      if (connectionsBuilder_ == null) {
        if (!other.connections_.isEmpty()) {
          if (connections_.isEmpty()) {
            connections_ = other.connections_;
            bitField0_ = (bitField0_ & ~0x00100000);
          } else {
            ensureConnectionsIsMutable();
            connections_.addAll(other.connections_);
          }
          onChanged();
        }
      } else {
        if (!other.connections_.isEmpty()) {
          if (connectionsBuilder_.isEmpty()) {
            connectionsBuilder_.dispose();
            connectionsBuilder_ = null;
            connections_ = other.connections_;
            bitField0_ = (bitField0_ & ~0x00100000);
            connectionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConnectionsFieldBuilder()
                    : null;
          } else {
            connectionsBuilder_.addAllMessages(other.connections_);
          }
        }
      }
      if (!other.getMuteInitiator().isEmpty()) {
        muteInitiator_ = other.muteInitiator_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (processesBuilder_ == null) {
        if (!other.processes_.isEmpty()) {
          if (processes_.isEmpty()) {
            processes_ = other.processes_;
            bitField0_ = (bitField0_ & ~0x00400000);
          } else {
            ensureProcessesIsMutable();
            processes_.addAll(other.processes_);
          }
          onChanged();
        }
      } else {
        if (!other.processes_.isEmpty()) {
          if (processesBuilder_.isEmpty()) {
            processesBuilder_.dispose();
            processesBuilder_ = null;
            processes_ = other.processes_;
            bitField0_ = (bitField0_ & ~0x00400000);
            processesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProcessesFieldBuilder()
                    : null;
          } else {
            processesBuilder_.addAllMessages(other.processes_);
          }
        }
      }
      internalGetMutableContacts().mergeFrom(other.internalGetContacts());
      bitField0_ |= 0x00800000;
      if (compliancesBuilder_ == null) {
        if (!other.compliances_.isEmpty()) {
          if (compliances_.isEmpty()) {
            compliances_ = other.compliances_;
            bitField0_ = (bitField0_ & ~0x01000000);
          } else {
            ensureCompliancesIsMutable();
            compliances_.addAll(other.compliances_);
          }
          onChanged();
        }
      } else {
        if (!other.compliances_.isEmpty()) {
          if (compliancesBuilder_.isEmpty()) {
            compliancesBuilder_.dispose();
            compliancesBuilder_ = null;
            compliances_ = other.compliances_;
            bitField0_ = (bitField0_ & ~0x01000000);
            compliancesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCompliancesFieldBuilder()
                    : null;
          } else {
            compliancesBuilder_.addAllMessages(other.compliances_);
          }
        }
      }
      if (!other.getParentDisplayName().isEmpty()) {
        parentDisplayName_ = other.parentDisplayName_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      if (other.hasExfiltration()) {
        mergeExfiltration(other.getExfiltration());
      }
      if (iamBindingsBuilder_ == null) {
        if (!other.iamBindings_.isEmpty()) {
          if (iamBindings_.isEmpty()) {
            iamBindings_ = other.iamBindings_;
            bitField0_ = (bitField0_ & ~0x10000000);
          } else {
            ensureIamBindingsIsMutable();
            iamBindings_.addAll(other.iamBindings_);
          }
          onChanged();
        }
      } else {
        if (!other.iamBindings_.isEmpty()) {
          if (iamBindingsBuilder_.isEmpty()) {
            iamBindingsBuilder_.dispose();
            iamBindingsBuilder_ = null;
            iamBindings_ = other.iamBindings_;
            bitField0_ = (bitField0_ & ~0x10000000);
            iamBindingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIamBindingsFieldBuilder()
                    : null;
          } else {
            iamBindingsBuilder_.addAllMessages(other.iamBindings_);
          }
        }
      }
      if (!other.getNextSteps().isEmpty()) {
        nextSteps_ = other.nextSteps_;
        bitField0_ |= 0x20000000;
        onChanged();
      }
      if (!other.getModuleName().isEmpty()) {
        moduleName_ = other.moduleName_;
        bitField0_ |= 0x40000000;
        onChanged();
      }
      if (containersBuilder_ == null) {
        if (!other.containers_.isEmpty()) {
          if (containers_.isEmpty()) {
            containers_ = other.containers_;
            bitField0_ = (bitField0_ & ~0x80000000);
          } else {
            ensureContainersIsMutable();
            containers_.addAll(other.containers_);
          }
          onChanged();
        }
      } else {
        if (!other.containers_.isEmpty()) {
          if (containersBuilder_.isEmpty()) {
            containersBuilder_.dispose();
            containersBuilder_ = null;
            containers_ = other.containers_;
            bitField0_ = (bitField0_ & ~0x80000000);
            containersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContainersFieldBuilder()
                    : null;
          } else {
            containersBuilder_.addAllMessages(other.containers_);
          }
        }
      }
      if (other.hasKubernetes()) {
        mergeKubernetes(other.getKubernetes());
      }
      if (other.hasDatabase()) {
        mergeDatabase(other.getDatabase());
      }
      if (filesBuilder_ == null) {
        if (!other.files_.isEmpty()) {
          if (files_.isEmpty()) {
            files_ = other.files_;
            bitField1_ = (bitField1_ & ~0x00000004);
          } else {
            ensureFilesIsMutable();
            files_.addAll(other.files_);
          }
          onChanged();
        }
      } else {
        if (!other.files_.isEmpty()) {
          if (filesBuilder_.isEmpty()) {
            filesBuilder_.dispose();
            filesBuilder_ = null;
            files_ = other.files_;
            bitField1_ = (bitField1_ & ~0x00000004);
            filesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFilesFieldBuilder()
                    : null;
          } else {
            filesBuilder_.addAllMessages(other.files_);
          }
        }
      }
      if (other.hasCloudDlpInspection()) {
        mergeCloudDlpInspection(other.getCloudDlpInspection());
      }
      if (other.hasCloudDlpDataProfile()) {
        mergeCloudDlpDataProfile(other.getCloudDlpDataProfile());
      }
      if (other.hasKernelRootkit()) {
        mergeKernelRootkit(other.getKernelRootkit());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                resourceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                category_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                externalUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                    sourceProperties__ =
                        input.readMessage(
                            SourcePropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableSourceProperties()
                    .getMutableMap()
                    .put(sourceProperties__.getKey(), sourceProperties__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getSecurityMarksFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getEventTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 96:
              {
                severity_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 96
            case 114:
              {
                canonicalName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 114
            case 120:
              {
                mute_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 120
            case 136:
              {
                findingClass_ = input.readEnum();
                bitField0_ |= 0x00002000;
                break;
              } // case 136
            case 146:
              {
                input.readMessage(getIndicatorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 146
            case 162:
              {
                input.readMessage(getVulnerabilityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getMuteUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 170
            case 178:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
                    externalSystems__ =
                        input.readMessage(
                            ExternalSystemsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableExternalSystems()
                    .getMutableMap()
                    .put(externalSystems__.getKey(), externalSystems__.getValue());
                bitField0_ |= 0x00020000;
                break;
              } // case 178
            case 202:
              {
                input.readMessage(getMitreAttackFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(getAccessFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 210
            case 226:
              {
                muteInitiator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 226
            case 242:
              {
                com.google.cloud.securitycenter.v1.Process m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Process.parser(), extensionRegistry);
                if (processesBuilder_ == null) {
                  ensureProcessesIsMutable();
                  processes_.add(m);
                } else {
                  processesBuilder_.addMessage(m);
                }
                break;
              } // case 242
            case 250:
              {
                com.google.cloud.securitycenter.v1.Connection m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Connection.parser(), extensionRegistry);
                if (connectionsBuilder_ == null) {
                  ensureConnectionsIsMutable();
                  connections_.add(m);
                } else {
                  connectionsBuilder_.addMessage(m);
                }
                break;
              } // case 250
            case 266:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
                    contacts__ =
                        input.readMessage(
                            ContactsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableContacts()
                    .getMutableMap()
                    .put(contacts__.getKey(), contacts__.getValue());
                bitField0_ |= 0x00800000;
                break;
              } // case 266
            case 274:
              {
                com.google.cloud.securitycenter.v1.Compliance m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Compliance.parser(), extensionRegistry);
                if (compliancesBuilder_ == null) {
                  ensureCompliancesIsMutable();
                  compliances_.add(m);
                } else {
                  compliancesBuilder_.addMessage(m);
                }
                break;
              } // case 274
            case 290:
              {
                parentDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x02000000;
                break;
              } // case 290
            case 298:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x04000000;
                break;
              } // case 298
            case 306:
              {
                input.readMessage(getExfiltrationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x08000000;
                break;
              } // case 306
            case 314:
              {
                com.google.cloud.securitycenter.v1.IamBinding m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.IamBinding.parser(), extensionRegistry);
                if (iamBindingsBuilder_ == null) {
                  ensureIamBindingsIsMutable();
                  iamBindings_.add(m);
                } else {
                  iamBindingsBuilder_.addMessage(m);
                }
                break;
              } // case 314
            case 322:
              {
                nextSteps_ = input.readStringRequireUtf8();
                bitField0_ |= 0x20000000;
                break;
              } // case 322
            case 330:
              {
                moduleName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x40000000;
                break;
              } // case 330
            case 338:
              {
                com.google.cloud.securitycenter.v1.Container m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Container.parser(), extensionRegistry);
                if (containersBuilder_ == null) {
                  ensureContainersIsMutable();
                  containers_.add(m);
                } else {
                  containersBuilder_.addMessage(m);
                }
                break;
              } // case 338
            case 346:
              {
                input.readMessage(getKubernetesFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000001;
                break;
              } // case 346
            case 354:
              {
                input.readMessage(getDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000002;
                break;
              } // case 354
            case 370:
              {
                com.google.cloud.securitycenter.v1.File m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.File.parser(), extensionRegistry);
                if (filesBuilder_ == null) {
                  ensureFilesIsMutable();
                  files_.add(m);
                } else {
                  filesBuilder_.addMessage(m);
                }
                break;
              } // case 370
            case 386:
              {
                input.readMessage(
                    getCloudDlpInspectionFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000008;
                break;
              } // case 386
            case 394:
              {
                input.readMessage(
                    getCloudDlpDataProfileFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000010;
                break;
              } // case 394
            case 402:
              {
                input.readMessage(getKernelRootkitFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000020;
                break;
              } // case 402
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The [relative resource
     * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * of the finding. Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
     * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [relative resource
     * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * of the finding. Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
     * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [relative resource
     * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * of the finding. Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
     * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [relative resource
     * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * of the finding. Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
     * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [relative resource
     * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * of the finding. Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
     * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object resourceName_ = "";
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding.State getState() {
      com.google.cloud.securitycenter.v1.Finding.State result =
          com.google.cloud.securitycenter.v1.Finding.State.forNumber(state_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Finding.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.securitycenter.v1.Finding.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object category_ = "";
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @return The category.
     */
    public java.lang.String getCategory() {
      java.lang.Object ref = category_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        category_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @return The bytes for category.
     */
    public com.google.protobuf.ByteString getCategoryBytes() {
      java.lang.Object ref = category_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        category_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @param value The category to set.
     * @return This builder for chaining.
     */
    public Builder setCategory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      category_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCategory() {
      category_ = getDefaultInstance().getCategory();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @param value The bytes for category to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      category_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object externalUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @return The externalUri.
     */
    public java.lang.String getExternalUri() {
      java.lang.Object ref = externalUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @return The bytes for externalUri.
     */
    public com.google.protobuf.ByteString getExternalUriBytes() {
      java.lang.Object ref = externalUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @param value The externalUri to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalUri() {
      externalUri_ = getDefaultInstance().getExternalUri();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @param value The bytes for externalUri to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        sourceProperties_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetSourceProperties() {
      if (sourceProperties_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SourcePropertiesDefaultEntryHolder.defaultEntry);
      }
      return sourceProperties_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetMutableSourceProperties() {
      if (sourceProperties_ == null) {
        sourceProperties_ =
            com.google.protobuf.MapField.newMapField(
                SourcePropertiesDefaultEntryHolder.defaultEntry);
      }
      if (!sourceProperties_.isMutable()) {
        sourceProperties_ = sourceProperties_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return sourceProperties_;
    }

    public int getSourcePropertiesCount() {
      return internalGetSourceProperties().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    @java.lang.Override
    public boolean containsSourceProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSourceProperties().getMap().containsKey(key);
    }
    /** Use {@link #getSourcePropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getSourceProperties() {
      return getSourcePropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getSourcePropertiesMap() {
      return internalGetSourceProperties().getMap();
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getSourcePropertiesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetSourceProperties().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getSourcePropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetSourceProperties().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSourceProperties() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableSourceProperties().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    public Builder removeSourceProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSourceProperties().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMutableSourceProperties() {
      bitField0_ |= 0x00000040;
      return internalGetMutableSourceProperties().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    public Builder putSourceProperties(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableSourceProperties().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    public Builder putAllSourceProperties(
        java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      internalGetMutableSourceProperties().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.cloud.securitycenter.v1.SecurityMarks securityMarks_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SecurityMarks,
            com.google.cloud.securitycenter.v1.SecurityMarks.Builder,
            com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder>
        securityMarksBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the securityMarks field is set.
     */
    public boolean hasSecurityMarks() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The securityMarks.
     */
    public com.google.cloud.securitycenter.v1.SecurityMarks getSecurityMarks() {
      if (securityMarksBuilder_ == null) {
        return securityMarks_ == null
            ? com.google.cloud.securitycenter.v1.SecurityMarks.getDefaultInstance()
            : securityMarks_;
      } else {
        return securityMarksBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSecurityMarks(com.google.cloud.securitycenter.v1.SecurityMarks value) {
      if (securityMarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securityMarks_ = value;
      } else {
        securityMarksBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSecurityMarks(
        com.google.cloud.securitycenter.v1.SecurityMarks.Builder builderForValue) {
      if (securityMarksBuilder_ == null) {
        securityMarks_ = builderForValue.build();
      } else {
        securityMarksBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSecurityMarks(com.google.cloud.securitycenter.v1.SecurityMarks value) {
      if (securityMarksBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && securityMarks_ != null
            && securityMarks_
                != com.google.cloud.securitycenter.v1.SecurityMarks.getDefaultInstance()) {
          getSecurityMarksBuilder().mergeFrom(value);
        } else {
          securityMarks_ = value;
        }
      } else {
        securityMarksBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSecurityMarks() {
      bitField0_ = (bitField0_ & ~0x00000080);
      securityMarks_ = null;
      if (securityMarksBuilder_ != null) {
        securityMarksBuilder_.dispose();
        securityMarksBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SecurityMarks.Builder getSecurityMarksBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getSecurityMarksFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder getSecurityMarksOrBuilder() {
      if (securityMarksBuilder_ != null) {
        return securityMarksBuilder_.getMessageOrBuilder();
      } else {
        return securityMarks_ == null
            ? com.google.cloud.securitycenter.v1.SecurityMarks.getDefaultInstance()
            : securityMarks_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SecurityMarks,
            com.google.cloud.securitycenter.v1.SecurityMarks.Builder,
            com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder>
        getSecurityMarksFieldBuilder() {
      if (securityMarksBuilder_ == null) {
        securityMarksBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.SecurityMarks,
                com.google.cloud.securitycenter.v1.SecurityMarks.Builder,
                com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder>(
                getSecurityMarks(), getParentForChildren(), isClean());
        securityMarks_ = null;
      }
      return securityMarksBuilder_;
    }

    private com.google.protobuf.Timestamp eventTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        eventTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     *
     * @return Whether the eventTime field is set.
     */
    public boolean hasEventTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     *
     * @return The eventTime.
     */
    public com.google.protobuf.Timestamp getEventTime() {
      if (eventTimeBuilder_ == null) {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      } else {
        return eventTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventTime_ = value;
      } else {
        eventTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (eventTimeBuilder_ == null) {
        eventTime_ = builderForValue.build();
      } else {
        eventTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public Builder mergeEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && eventTime_ != null
            && eventTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEventTimeBuilder().mergeFrom(value);
        } else {
          eventTime_ = value;
        }
      } else {
        eventTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public Builder clearEventTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      eventTime_ = null;
      if (eventTimeBuilder_ != null) {
        eventTimeBuilder_.dispose();
        eventTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEventTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getEventTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
      if (eventTimeBuilder_ != null) {
        return eventTimeBuilder_.getMessageOrBuilder();
      } else {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEventTimeFieldBuilder() {
      if (eventTimeBuilder_ == null) {
        eventTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEventTime(), getParentForChildren(), isClean());
        eventTime_ = null;
      }
      return eventTimeBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int severity_ = 0;
    /**
     *
     *
     * <pre>
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     *
     * @return The enum numeric value on the wire for severity.
     */
    @java.lang.Override
    public int getSeverityValue() {
      return severity_;
    }
    /**
     *
     *
     * <pre>
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     *
     * @param value The enum numeric value on the wire for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityValue(int value) {
      severity_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     *
     * @return The severity.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding.Severity getSeverity() {
      com.google.cloud.securitycenter.v1.Finding.Severity result =
          com.google.cloud.securitycenter.v1.Finding.Severity.forNumber(severity_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Finding.Severity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(com.google.cloud.securitycenter.v1.Finding.Severity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      severity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {
      bitField0_ = (bitField0_ & ~0x00000400);
      severity_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object canonicalName_ = "";
    /**
     *
     *
     * <pre>
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     * </pre>
     *
     * <code>string canonical_name = 14;</code>
     *
     * @return The canonicalName.
     */
    public java.lang.String getCanonicalName() {
      java.lang.Object ref = canonicalName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        canonicalName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     * </pre>
     *
     * <code>string canonical_name = 14;</code>
     *
     * @return The bytes for canonicalName.
     */
    public com.google.protobuf.ByteString getCanonicalNameBytes() {
      java.lang.Object ref = canonicalName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        canonicalName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     * </pre>
     *
     * <code>string canonical_name = 14;</code>
     *
     * @param value The canonicalName to set.
     * @return This builder for chaining.
     */
    public Builder setCanonicalName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      canonicalName_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     * </pre>
     *
     * <code>string canonical_name = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCanonicalName() {
      canonicalName_ = getDefaultInstance().getCanonicalName();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     * </pre>
     *
     * <code>string canonical_name = 14;</code>
     *
     * @param value The bytes for canonicalName to set.
     * @return This builder for chaining.
     */
    public Builder setCanonicalNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      canonicalName_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private int mute_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     *
     * @return The enum numeric value on the wire for mute.
     */
    @java.lang.Override
    public int getMuteValue() {
      return mute_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     *
     * @param value The enum numeric value on the wire for mute to set.
     * @return This builder for chaining.
     */
    public Builder setMuteValue(int value) {
      mute_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     *
     * @return The mute.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding.Mute getMute() {
      com.google.cloud.securitycenter.v1.Finding.Mute result =
          com.google.cloud.securitycenter.v1.Finding.Mute.forNumber(mute_);
      return result == null ? com.google.cloud.securitycenter.v1.Finding.Mute.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     *
     * @param value The mute to set.
     * @return This builder for chaining.
     */
    public Builder setMute(com.google.cloud.securitycenter.v1.Finding.Mute value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      mute_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMute() {
      bitField0_ = (bitField0_ & ~0x00001000);
      mute_ = 0;
      onChanged();
      return this;
    }

    private int findingClass_ = 0;
    /**
     *
     *
     * <pre>
     * The class of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     *
     * @return The enum numeric value on the wire for findingClass.
     */
    @java.lang.Override
    public int getFindingClassValue() {
      return findingClass_;
    }
    /**
     *
     *
     * <pre>
     * The class of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     *
     * @param value The enum numeric value on the wire for findingClass to set.
     * @return This builder for chaining.
     */
    public Builder setFindingClassValue(int value) {
      findingClass_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The class of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     *
     * @return The findingClass.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding.FindingClass getFindingClass() {
      com.google.cloud.securitycenter.v1.Finding.FindingClass result =
          com.google.cloud.securitycenter.v1.Finding.FindingClass.forNumber(findingClass_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Finding.FindingClass.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The class of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     *
     * @param value The findingClass to set.
     * @return This builder for chaining.
     */
    public Builder setFindingClass(com.google.cloud.securitycenter.v1.Finding.FindingClass value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      findingClass_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The class of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFindingClass() {
      bitField0_ = (bitField0_ & ~0x00002000);
      findingClass_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1.Indicator indicator_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Indicator,
            com.google.cloud.securitycenter.v1.Indicator.Builder,
            com.google.cloud.securitycenter.v1.IndicatorOrBuilder>
        indicatorBuilder_;
    /**
     *
     *
     * <pre>
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     *
     * @return Whether the indicator field is set.
     */
    public boolean hasIndicator() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     *
     * @return The indicator.
     */
    public com.google.cloud.securitycenter.v1.Indicator getIndicator() {
      if (indicatorBuilder_ == null) {
        return indicator_ == null
            ? com.google.cloud.securitycenter.v1.Indicator.getDefaultInstance()
            : indicator_;
      } else {
        return indicatorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     */
    public Builder setIndicator(com.google.cloud.securitycenter.v1.Indicator value) {
      if (indicatorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        indicator_ = value;
      } else {
        indicatorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     */
    public Builder setIndicator(
        com.google.cloud.securitycenter.v1.Indicator.Builder builderForValue) {
      if (indicatorBuilder_ == null) {
        indicator_ = builderForValue.build();
      } else {
        indicatorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     */
    public Builder mergeIndicator(com.google.cloud.securitycenter.v1.Indicator value) {
      if (indicatorBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && indicator_ != null
            && indicator_ != com.google.cloud.securitycenter.v1.Indicator.getDefaultInstance()) {
          getIndicatorBuilder().mergeFrom(value);
        } else {
          indicator_ = value;
        }
      } else {
        indicatorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     */
    public Builder clearIndicator() {
      bitField0_ = (bitField0_ & ~0x00004000);
      indicator_ = null;
      if (indicatorBuilder_ != null) {
        indicatorBuilder_.dispose();
        indicatorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     */
    public com.google.cloud.securitycenter.v1.Indicator.Builder getIndicatorBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getIndicatorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     */
    public com.google.cloud.securitycenter.v1.IndicatorOrBuilder getIndicatorOrBuilder() {
      if (indicatorBuilder_ != null) {
        return indicatorBuilder_.getMessageOrBuilder();
      } else {
        return indicator_ == null
            ? com.google.cloud.securitycenter.v1.Indicator.getDefaultInstance()
            : indicator_;
      }
    }
    /**
     *
     *
     * <pre>
     * Represents what's commonly known as an *indicator of compromise* (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion. For more information, see [Indicator of
     * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Indicator,
            com.google.cloud.securitycenter.v1.Indicator.Builder,
            com.google.cloud.securitycenter.v1.IndicatorOrBuilder>
        getIndicatorFieldBuilder() {
      if (indicatorBuilder_ == null) {
        indicatorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Indicator,
                com.google.cloud.securitycenter.v1.Indicator.Builder,
                com.google.cloud.securitycenter.v1.IndicatorOrBuilder>(
                getIndicator(), getParentForChildren(), isClean());
        indicator_ = null;
      }
      return indicatorBuilder_;
    }

    private com.google.cloud.securitycenter.v1.Vulnerability vulnerability_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Vulnerability,
            com.google.cloud.securitycenter.v1.Vulnerability.Builder,
            com.google.cloud.securitycenter.v1.VulnerabilityOrBuilder>
        vulnerabilityBuilder_;
    /**
     *
     *
     * <pre>
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     *
     * @return Whether the vulnerability field is set.
     */
    public boolean hasVulnerability() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     *
     * @return The vulnerability.
     */
    public com.google.cloud.securitycenter.v1.Vulnerability getVulnerability() {
      if (vulnerabilityBuilder_ == null) {
        return vulnerability_ == null
            ? com.google.cloud.securitycenter.v1.Vulnerability.getDefaultInstance()
            : vulnerability_;
      } else {
        return vulnerabilityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     */
    public Builder setVulnerability(com.google.cloud.securitycenter.v1.Vulnerability value) {
      if (vulnerabilityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vulnerability_ = value;
      } else {
        vulnerabilityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     */
    public Builder setVulnerability(
        com.google.cloud.securitycenter.v1.Vulnerability.Builder builderForValue) {
      if (vulnerabilityBuilder_ == null) {
        vulnerability_ = builderForValue.build();
      } else {
        vulnerabilityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     */
    public Builder mergeVulnerability(com.google.cloud.securitycenter.v1.Vulnerability value) {
      if (vulnerabilityBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && vulnerability_ != null
            && vulnerability_
                != com.google.cloud.securitycenter.v1.Vulnerability.getDefaultInstance()) {
          getVulnerabilityBuilder().mergeFrom(value);
        } else {
          vulnerability_ = value;
        }
      } else {
        vulnerabilityBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     */
    public Builder clearVulnerability() {
      bitField0_ = (bitField0_ & ~0x00008000);
      vulnerability_ = null;
      if (vulnerabilityBuilder_ != null) {
        vulnerabilityBuilder_.dispose();
        vulnerabilityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     */
    public com.google.cloud.securitycenter.v1.Vulnerability.Builder getVulnerabilityBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getVulnerabilityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     */
    public com.google.cloud.securitycenter.v1.VulnerabilityOrBuilder getVulnerabilityOrBuilder() {
      if (vulnerabilityBuilder_ != null) {
        return vulnerabilityBuilder_.getMessageOrBuilder();
      } else {
        return vulnerability_ == null
            ? com.google.cloud.securitycenter.v1.Vulnerability.getDefaultInstance()
            : vulnerability_;
      }
    }
    /**
     *
     *
     * <pre>
     * Represents vulnerability-specific fields like CVE and CVSS scores.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Vulnerability,
            com.google.cloud.securitycenter.v1.Vulnerability.Builder,
            com.google.cloud.securitycenter.v1.VulnerabilityOrBuilder>
        getVulnerabilityFieldBuilder() {
      if (vulnerabilityBuilder_ == null) {
        vulnerabilityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Vulnerability,
                com.google.cloud.securitycenter.v1.Vulnerability.Builder,
                com.google.cloud.securitycenter.v1.VulnerabilityOrBuilder>(
                getVulnerability(), getParentForChildren(), isClean());
        vulnerability_ = null;
      }
      return vulnerabilityBuilder_;
    }

    private com.google.protobuf.Timestamp muteUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        muteUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this finding was muted or unmuted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the muteUpdateTime field is set.
     */
    public boolean hasMuteUpdateTime() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this finding was muted or unmuted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The muteUpdateTime.
     */
    public com.google.protobuf.Timestamp getMuteUpdateTime() {
      if (muteUpdateTimeBuilder_ == null) {
        return muteUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : muteUpdateTime_;
      } else {
        return muteUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this finding was muted or unmuted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMuteUpdateTime(com.google.protobuf.Timestamp value) {
      if (muteUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        muteUpdateTime_ = value;
      } else {
        muteUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this finding was muted or unmuted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMuteUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (muteUpdateTimeBuilder_ == null) {
        muteUpdateTime_ = builderForValue.build();
      } else {
        muteUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this finding was muted or unmuted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMuteUpdateTime(com.google.protobuf.Timestamp value) {
      if (muteUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && muteUpdateTime_ != null
            && muteUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getMuteUpdateTimeBuilder().mergeFrom(value);
        } else {
          muteUpdateTime_ = value;
        }
      } else {
        muteUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this finding was muted or unmuted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMuteUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00010000);
      muteUpdateTime_ = null;
      if (muteUpdateTimeBuilder_ != null) {
        muteUpdateTimeBuilder_.dispose();
        muteUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this finding was muted or unmuted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getMuteUpdateTimeBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getMuteUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this finding was muted or unmuted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getMuteUpdateTimeOrBuilder() {
      if (muteUpdateTimeBuilder_ != null) {
        return muteUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return muteUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : muteUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time this finding was muted or unmuted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getMuteUpdateTimeFieldBuilder() {
      if (muteUpdateTimeBuilder_ == null) {
        muteUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getMuteUpdateTime(), getParentForChildren(), isClean());
        muteUpdateTime_ = null;
      }
      return muteUpdateTimeBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
        externalSystems_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
        internalGetExternalSystems() {
      if (externalSystems_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ExternalSystemsDefaultEntryHolder.defaultEntry);
      }
      return externalSystems_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
        internalGetMutableExternalSystems() {
      if (externalSystems_ == null) {
        externalSystems_ =
            com.google.protobuf.MapField.newMapField(
                ExternalSystemsDefaultEntryHolder.defaultEntry);
      }
      if (!externalSystems_.isMutable()) {
        externalSystems_ = externalSystems_.copy();
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return externalSystems_;
    }

    public int getExternalSystemsCount() {
      return internalGetExternalSystems().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsExternalSystems(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetExternalSystems().getMap().containsKey(key);
    }
    /** Use {@link #getExternalSystemsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
        getExternalSystems() {
      return getExternalSystemsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
        getExternalSystemsMap() {
      return internalGetExternalSystems().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.securitycenter.v1.ExternalSystem
        getExternalSystemsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.securitycenter.v1.ExternalSystem defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem> map =
          internalGetExternalSystems().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ExternalSystem getExternalSystemsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem> map =
          internalGetExternalSystems().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearExternalSystems() {
      bitField0_ = (bitField0_ & ~0x00020000);
      internalGetMutableExternalSystems().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeExternalSystems(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableExternalSystems().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
        getMutableExternalSystems() {
      bitField0_ |= 0x00020000;
      return internalGetMutableExternalSystems().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putExternalSystems(
        java.lang.String key, com.google.cloud.securitycenter.v1.ExternalSystem value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableExternalSystems().getMutableMap().put(key, value);
      bitField0_ |= 0x00020000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Third party SIEM/SOAR fields within SCC, contains external
     * system information and external system finding fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllExternalSystems(
        java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem> values) {
      internalGetMutableExternalSystems().getMutableMap().putAll(values);
      bitField0_ |= 0x00020000;
      return this;
    }

    private com.google.cloud.securitycenter.v1.MitreAttack mitreAttack_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.MitreAttack,
            com.google.cloud.securitycenter.v1.MitreAttack.Builder,
            com.google.cloud.securitycenter.v1.MitreAttackOrBuilder>
        mitreAttackBuilder_;
    /**
     *
     *
     * <pre>
     * MITRE ATT&amp;CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     *
     * @return Whether the mitreAttack field is set.
     */
    public boolean hasMitreAttack() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * MITRE ATT&amp;CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     *
     * @return The mitreAttack.
     */
    public com.google.cloud.securitycenter.v1.MitreAttack getMitreAttack() {
      if (mitreAttackBuilder_ == null) {
        return mitreAttack_ == null
            ? com.google.cloud.securitycenter.v1.MitreAttack.getDefaultInstance()
            : mitreAttack_;
      } else {
        return mitreAttackBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * MITRE ATT&amp;CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     */
    public Builder setMitreAttack(com.google.cloud.securitycenter.v1.MitreAttack value) {
      if (mitreAttackBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mitreAttack_ = value;
      } else {
        mitreAttackBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * MITRE ATT&amp;CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     */
    public Builder setMitreAttack(
        com.google.cloud.securitycenter.v1.MitreAttack.Builder builderForValue) {
      if (mitreAttackBuilder_ == null) {
        mitreAttack_ = builderForValue.build();
      } else {
        mitreAttackBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * MITRE ATT&amp;CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     */
    public Builder mergeMitreAttack(com.google.cloud.securitycenter.v1.MitreAttack value) {
      if (mitreAttackBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && mitreAttack_ != null
            && mitreAttack_
                != com.google.cloud.securitycenter.v1.MitreAttack.getDefaultInstance()) {
          getMitreAttackBuilder().mergeFrom(value);
        } else {
          mitreAttack_ = value;
        }
      } else {
        mitreAttackBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * MITRE ATT&amp;CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     */
    public Builder clearMitreAttack() {
      bitField0_ = (bitField0_ & ~0x00040000);
      mitreAttack_ = null;
      if (mitreAttackBuilder_ != null) {
        mitreAttackBuilder_.dispose();
        mitreAttackBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * MITRE ATT&amp;CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     */
    public com.google.cloud.securitycenter.v1.MitreAttack.Builder getMitreAttackBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getMitreAttackFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * MITRE ATT&amp;CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     */
    public com.google.cloud.securitycenter.v1.MitreAttackOrBuilder getMitreAttackOrBuilder() {
      if (mitreAttackBuilder_ != null) {
        return mitreAttackBuilder_.getMessageOrBuilder();
      } else {
        return mitreAttack_ == null
            ? com.google.cloud.securitycenter.v1.MitreAttack.getDefaultInstance()
            : mitreAttack_;
      }
    }
    /**
     *
     *
     * <pre>
     * MITRE ATT&amp;CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.MitreAttack,
            com.google.cloud.securitycenter.v1.MitreAttack.Builder,
            com.google.cloud.securitycenter.v1.MitreAttackOrBuilder>
        getMitreAttackFieldBuilder() {
      if (mitreAttackBuilder_ == null) {
        mitreAttackBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.MitreAttack,
                com.google.cloud.securitycenter.v1.MitreAttack.Builder,
                com.google.cloud.securitycenter.v1.MitreAttackOrBuilder>(
                getMitreAttack(), getParentForChildren(), isClean());
        mitreAttack_ = null;
      }
      return mitreAttackBuilder_;
    }

    private com.google.cloud.securitycenter.v1.Access access_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Access,
            com.google.cloud.securitycenter.v1.Access.Builder,
            com.google.cloud.securitycenter.v1.AccessOrBuilder>
        accessBuilder_;
    /**
     *
     *
     * <pre>
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     *
     * @return Whether the access field is set.
     */
    public boolean hasAccess() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     *
     * @return The access.
     */
    public com.google.cloud.securitycenter.v1.Access getAccess() {
      if (accessBuilder_ == null) {
        return access_ == null
            ? com.google.cloud.securitycenter.v1.Access.getDefaultInstance()
            : access_;
      } else {
        return accessBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     */
    public Builder setAccess(com.google.cloud.securitycenter.v1.Access value) {
      if (accessBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        access_ = value;
      } else {
        accessBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     */
    public Builder setAccess(com.google.cloud.securitycenter.v1.Access.Builder builderForValue) {
      if (accessBuilder_ == null) {
        access_ = builderForValue.build();
      } else {
        accessBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     */
    public Builder mergeAccess(com.google.cloud.securitycenter.v1.Access value) {
      if (accessBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && access_ != null
            && access_ != com.google.cloud.securitycenter.v1.Access.getDefaultInstance()) {
          getAccessBuilder().mergeFrom(value);
        } else {
          access_ = value;
        }
      } else {
        accessBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     */
    public Builder clearAccess() {
      bitField0_ = (bitField0_ & ~0x00080000);
      access_ = null;
      if (accessBuilder_ != null) {
        accessBuilder_.dispose();
        accessBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     */
    public com.google.cloud.securitycenter.v1.Access.Builder getAccessBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getAccessFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     */
    public com.google.cloud.securitycenter.v1.AccessOrBuilder getAccessOrBuilder() {
      if (accessBuilder_ != null) {
        return accessBuilder_.getMessageOrBuilder();
      } else {
        return access_ == null
            ? com.google.cloud.securitycenter.v1.Access.getDefaultInstance()
            : access_;
      }
    }
    /**
     *
     *
     * <pre>
     * Access details associated with the finding, such as more information on the
     * caller, which method was accessed, and from where.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Access,
            com.google.cloud.securitycenter.v1.Access.Builder,
            com.google.cloud.securitycenter.v1.AccessOrBuilder>
        getAccessFieldBuilder() {
      if (accessBuilder_ == null) {
        accessBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Access,
                com.google.cloud.securitycenter.v1.Access.Builder,
                com.google.cloud.securitycenter.v1.AccessOrBuilder>(
                getAccess(), getParentForChildren(), isClean());
        access_ = null;
      }
      return accessBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Connection> connections_ =
        java.util.Collections.emptyList();

    private void ensureConnectionsIsMutable() {
      if (!((bitField0_ & 0x00100000) != 0)) {
        connections_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Connection>(connections_);
        bitField0_ |= 0x00100000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Connection,
            com.google.cloud.securitycenter.v1.Connection.Builder,
            com.google.cloud.securitycenter.v1.ConnectionOrBuilder>
        connectionsBuilder_;

    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Connection> getConnectionsList() {
      if (connectionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(connections_);
      } else {
        return connectionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public int getConnectionsCount() {
      if (connectionsBuilder_ == null) {
        return connections_.size();
      } else {
        return connectionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public com.google.cloud.securitycenter.v1.Connection getConnections(int index) {
      if (connectionsBuilder_ == null) {
        return connections_.get(index);
      } else {
        return connectionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public Builder setConnections(int index, com.google.cloud.securitycenter.v1.Connection value) {
      if (connectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectionsIsMutable();
        connections_.set(index, value);
        onChanged();
      } else {
        connectionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public Builder setConnections(
        int index, com.google.cloud.securitycenter.v1.Connection.Builder builderForValue) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        connections_.set(index, builderForValue.build());
        onChanged();
      } else {
        connectionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public Builder addConnections(com.google.cloud.securitycenter.v1.Connection value) {
      if (connectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectionsIsMutable();
        connections_.add(value);
        onChanged();
      } else {
        connectionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public Builder addConnections(int index, com.google.cloud.securitycenter.v1.Connection value) {
      if (connectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectionsIsMutable();
        connections_.add(index, value);
        onChanged();
      } else {
        connectionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public Builder addConnections(
        com.google.cloud.securitycenter.v1.Connection.Builder builderForValue) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        connections_.add(builderForValue.build());
        onChanged();
      } else {
        connectionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public Builder addConnections(
        int index, com.google.cloud.securitycenter.v1.Connection.Builder builderForValue) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        connections_.add(index, builderForValue.build());
        onChanged();
      } else {
        connectionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public Builder addAllConnections(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Connection> values) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, connections_);
        onChanged();
      } else {
        connectionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public Builder clearConnections() {
      if (connectionsBuilder_ == null) {
        connections_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00100000);
        onChanged();
      } else {
        connectionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public Builder removeConnections(int index) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        connections_.remove(index);
        onChanged();
      } else {
        connectionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public com.google.cloud.securitycenter.v1.Connection.Builder getConnectionsBuilder(int index) {
      return getConnectionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public com.google.cloud.securitycenter.v1.ConnectionOrBuilder getConnectionsOrBuilder(
        int index) {
      if (connectionsBuilder_ == null) {
        return connections_.get(index);
      } else {
        return connectionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.ConnectionOrBuilder>
        getConnectionsOrBuilderList() {
      if (connectionsBuilder_ != null) {
        return connectionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(connections_);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public com.google.cloud.securitycenter.v1.Connection.Builder addConnectionsBuilder() {
      return getConnectionsFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Connection.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public com.google.cloud.securitycenter.v1.Connection.Builder addConnectionsBuilder(int index) {
      return getConnectionsFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.Connection.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Contains information about the IP connection associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Connection.Builder>
        getConnectionsBuilderList() {
      return getConnectionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Connection,
            com.google.cloud.securitycenter.v1.Connection.Builder,
            com.google.cloud.securitycenter.v1.ConnectionOrBuilder>
        getConnectionsFieldBuilder() {
      if (connectionsBuilder_ == null) {
        connectionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Connection,
                com.google.cloud.securitycenter.v1.Connection.Builder,
                com.google.cloud.securitycenter.v1.ConnectionOrBuilder>(
                connections_, ((bitField0_ & 0x00100000) != 0), getParentForChildren(), isClean());
        connections_ = null;
      }
      return connectionsBuilder_;
    }

    private java.lang.Object muteInitiator_ = "";
    /**
     *
     *
     * <pre>
     * Records additional information about the mute operation, for example, the
     * [mute configuration](/security-command-center/docs/how-to-mute-findings)
     * that muted the finding and the user who muted the finding.
     * </pre>
     *
     * <code>string mute_initiator = 28;</code>
     *
     * @return The muteInitiator.
     */
    public java.lang.String getMuteInitiator() {
      java.lang.Object ref = muteInitiator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        muteInitiator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Records additional information about the mute operation, for example, the
     * [mute configuration](/security-command-center/docs/how-to-mute-findings)
     * that muted the finding and the user who muted the finding.
     * </pre>
     *
     * <code>string mute_initiator = 28;</code>
     *
     * @return The bytes for muteInitiator.
     */
    public com.google.protobuf.ByteString getMuteInitiatorBytes() {
      java.lang.Object ref = muteInitiator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        muteInitiator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Records additional information about the mute operation, for example, the
     * [mute configuration](/security-command-center/docs/how-to-mute-findings)
     * that muted the finding and the user who muted the finding.
     * </pre>
     *
     * <code>string mute_initiator = 28;</code>
     *
     * @param value The muteInitiator to set.
     * @return This builder for chaining.
     */
    public Builder setMuteInitiator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      muteInitiator_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records additional information about the mute operation, for example, the
     * [mute configuration](/security-command-center/docs/how-to-mute-findings)
     * that muted the finding and the user who muted the finding.
     * </pre>
     *
     * <code>string mute_initiator = 28;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMuteInitiator() {
      muteInitiator_ = getDefaultInstance().getMuteInitiator();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Records additional information about the mute operation, for example, the
     * [mute configuration](/security-command-center/docs/how-to-mute-findings)
     * that muted the finding and the user who muted the finding.
     * </pre>
     *
     * <code>string mute_initiator = 28;</code>
     *
     * @param value The bytes for muteInitiator to set.
     * @return This builder for chaining.
     */
    public Builder setMuteInitiatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      muteInitiator_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Process> processes_ =
        java.util.Collections.emptyList();

    private void ensureProcessesIsMutable() {
      if (!((bitField0_ & 0x00400000) != 0)) {
        processes_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Process>(processes_);
        bitField0_ |= 0x00400000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Process,
            com.google.cloud.securitycenter.v1.Process.Builder,
            com.google.cloud.securitycenter.v1.ProcessOrBuilder>
        processesBuilder_;

    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Process> getProcessesList() {
      if (processesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(processes_);
      } else {
        return processesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public int getProcessesCount() {
      if (processesBuilder_ == null) {
        return processes_.size();
      } else {
        return processesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public com.google.cloud.securitycenter.v1.Process getProcesses(int index) {
      if (processesBuilder_ == null) {
        return processes_.get(index);
      } else {
        return processesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public Builder setProcesses(int index, com.google.cloud.securitycenter.v1.Process value) {
      if (processesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProcessesIsMutable();
        processes_.set(index, value);
        onChanged();
      } else {
        processesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public Builder setProcesses(
        int index, com.google.cloud.securitycenter.v1.Process.Builder builderForValue) {
      if (processesBuilder_ == null) {
        ensureProcessesIsMutable();
        processes_.set(index, builderForValue.build());
        onChanged();
      } else {
        processesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public Builder addProcesses(com.google.cloud.securitycenter.v1.Process value) {
      if (processesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProcessesIsMutable();
        processes_.add(value);
        onChanged();
      } else {
        processesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public Builder addProcesses(int index, com.google.cloud.securitycenter.v1.Process value) {
      if (processesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProcessesIsMutable();
        processes_.add(index, value);
        onChanged();
      } else {
        processesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public Builder addProcesses(
        com.google.cloud.securitycenter.v1.Process.Builder builderForValue) {
      if (processesBuilder_ == null) {
        ensureProcessesIsMutable();
        processes_.add(builderForValue.build());
        onChanged();
      } else {
        processesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public Builder addProcesses(
        int index, com.google.cloud.securitycenter.v1.Process.Builder builderForValue) {
      if (processesBuilder_ == null) {
        ensureProcessesIsMutable();
        processes_.add(index, builderForValue.build());
        onChanged();
      } else {
        processesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public Builder addAllProcesses(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Process> values) {
      if (processesBuilder_ == null) {
        ensureProcessesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, processes_);
        onChanged();
      } else {
        processesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public Builder clearProcesses() {
      if (processesBuilder_ == null) {
        processes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00400000);
        onChanged();
      } else {
        processesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public Builder removeProcesses(int index) {
      if (processesBuilder_ == null) {
        ensureProcessesIsMutable();
        processes_.remove(index);
        onChanged();
      } else {
        processesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public com.google.cloud.securitycenter.v1.Process.Builder getProcessesBuilder(int index) {
      return getProcessesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public com.google.cloud.securitycenter.v1.ProcessOrBuilder getProcessesOrBuilder(int index) {
      if (processesBuilder_ == null) {
        return processes_.get(index);
      } else {
        return processesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.ProcessOrBuilder>
        getProcessesOrBuilderList() {
      if (processesBuilder_ != null) {
        return processesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(processes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public com.google.cloud.securitycenter.v1.Process.Builder addProcessesBuilder() {
      return getProcessesFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Process.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public com.google.cloud.securitycenter.v1.Process.Builder addProcessesBuilder(int index) {
      return getProcessesFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.Process.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Represents operating system processes associated with the Finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Process.Builder>
        getProcessesBuilderList() {
      return getProcessesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Process,
            com.google.cloud.securitycenter.v1.Process.Builder,
            com.google.cloud.securitycenter.v1.ProcessOrBuilder>
        getProcessesFieldBuilder() {
      if (processesBuilder_ == null) {
        processesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Process,
                com.google.cloud.securitycenter.v1.Process.Builder,
                com.google.cloud.securitycenter.v1.ProcessOrBuilder>(
                processes_, ((bitField0_ & 0x00400000) != 0), getParentForChildren(), isClean());
        processes_ = null;
      }
      return processesBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
        contacts_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
        internalGetContacts() {
      if (contacts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ContactsDefaultEntryHolder.defaultEntry);
      }
      return contacts_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
        internalGetMutableContacts() {
      if (contacts_ == null) {
        contacts_ =
            com.google.protobuf.MapField.newMapField(ContactsDefaultEntryHolder.defaultEntry);
      }
      if (!contacts_.isMutable()) {
        contacts_ = contacts_.copy();
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return contacts_;
    }

    public int getContactsCount() {
      return internalGetContacts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsContacts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetContacts().getMap().containsKey(key);
    }
    /** Use {@link #getContactsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
        getContacts() {
      return getContactsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
        getContactsMap() {
      return internalGetContacts().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.securitycenter.v1.ContactDetails getContactsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.securitycenter.v1.ContactDetails defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails> map =
          internalGetContacts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ContactDetails getContactsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails> map =
          internalGetContacts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearContacts() {
      bitField0_ = (bitField0_ & ~0x00800000);
      internalGetMutableContacts().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeContacts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableContacts().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
        getMutableContacts() {
      bitField0_ |= 0x00800000;
      return internalGetMutableContacts().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putContacts(
        java.lang.String key, com.google.cloud.securitycenter.v1.ContactDetails value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableContacts().getMutableMap().put(key, value);
      bitField0_ |= 0x00800000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map containing the points of contact for the given finding.
     * The key represents the type of contact, while the value contains a list of
     * all the contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllContacts(
        java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails> values) {
      internalGetMutableContacts().getMutableMap().putAll(values);
      bitField0_ |= 0x00800000;
      return this;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Compliance> compliances_ =
        java.util.Collections.emptyList();

    private void ensureCompliancesIsMutable() {
      if (!((bitField0_ & 0x01000000) != 0)) {
        compliances_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Compliance>(compliances_);
        bitField0_ |= 0x01000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Compliance,
            com.google.cloud.securitycenter.v1.Compliance.Builder,
            com.google.cloud.securitycenter.v1.ComplianceOrBuilder>
        compliancesBuilder_;

    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Compliance> getCompliancesList() {
      if (compliancesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(compliances_);
      } else {
        return compliancesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public int getCompliancesCount() {
      if (compliancesBuilder_ == null) {
        return compliances_.size();
      } else {
        return compliancesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public com.google.cloud.securitycenter.v1.Compliance getCompliances(int index) {
      if (compliancesBuilder_ == null) {
        return compliances_.get(index);
      } else {
        return compliancesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public Builder setCompliances(int index, com.google.cloud.securitycenter.v1.Compliance value) {
      if (compliancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompliancesIsMutable();
        compliances_.set(index, value);
        onChanged();
      } else {
        compliancesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public Builder setCompliances(
        int index, com.google.cloud.securitycenter.v1.Compliance.Builder builderForValue) {
      if (compliancesBuilder_ == null) {
        ensureCompliancesIsMutable();
        compliances_.set(index, builderForValue.build());
        onChanged();
      } else {
        compliancesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public Builder addCompliances(com.google.cloud.securitycenter.v1.Compliance value) {
      if (compliancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompliancesIsMutable();
        compliances_.add(value);
        onChanged();
      } else {
        compliancesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public Builder addCompliances(int index, com.google.cloud.securitycenter.v1.Compliance value) {
      if (compliancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompliancesIsMutable();
        compliances_.add(index, value);
        onChanged();
      } else {
        compliancesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public Builder addCompliances(
        com.google.cloud.securitycenter.v1.Compliance.Builder builderForValue) {
      if (compliancesBuilder_ == null) {
        ensureCompliancesIsMutable();
        compliances_.add(builderForValue.build());
        onChanged();
      } else {
        compliancesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public Builder addCompliances(
        int index, com.google.cloud.securitycenter.v1.Compliance.Builder builderForValue) {
      if (compliancesBuilder_ == null) {
        ensureCompliancesIsMutable();
        compliances_.add(index, builderForValue.build());
        onChanged();
      } else {
        compliancesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public Builder addAllCompliances(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Compliance> values) {
      if (compliancesBuilder_ == null) {
        ensureCompliancesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, compliances_);
        onChanged();
      } else {
        compliancesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public Builder clearCompliances() {
      if (compliancesBuilder_ == null) {
        compliances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x01000000);
        onChanged();
      } else {
        compliancesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public Builder removeCompliances(int index) {
      if (compliancesBuilder_ == null) {
        ensureCompliancesIsMutable();
        compliances_.remove(index);
        onChanged();
      } else {
        compliancesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public com.google.cloud.securitycenter.v1.Compliance.Builder getCompliancesBuilder(int index) {
      return getCompliancesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public com.google.cloud.securitycenter.v1.ComplianceOrBuilder getCompliancesOrBuilder(
        int index) {
      if (compliancesBuilder_ == null) {
        return compliances_.get(index);
      } else {
        return compliancesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.ComplianceOrBuilder>
        getCompliancesOrBuilderList() {
      if (compliancesBuilder_ != null) {
        return compliancesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(compliances_);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public com.google.cloud.securitycenter.v1.Compliance.Builder addCompliancesBuilder() {
      return getCompliancesFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Compliance.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public com.google.cloud.securitycenter.v1.Compliance.Builder addCompliancesBuilder(int index) {
      return getCompliancesFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.Compliance.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Contains compliance information for security standards associated to the
     * finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Compliance.Builder>
        getCompliancesBuilderList() {
      return getCompliancesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Compliance,
            com.google.cloud.securitycenter.v1.Compliance.Builder,
            com.google.cloud.securitycenter.v1.ComplianceOrBuilder>
        getCompliancesFieldBuilder() {
      if (compliancesBuilder_ == null) {
        compliancesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Compliance,
                com.google.cloud.securitycenter.v1.Compliance.Builder,
                com.google.cloud.securitycenter.v1.ComplianceOrBuilder>(
                compliances_, ((bitField0_ & 0x01000000) != 0), getParentForChildren(), isClean());
        compliances_ = null;
      }
      return compliancesBuilder_;
    }

    private java.lang.Object parentDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The human readable display name of the finding source such as
     * "Event Threat Detection" or "Security Health Analytics".
     * </pre>
     *
     * <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The parentDisplayName.
     */
    public java.lang.String getParentDisplayName() {
      java.lang.Object ref = parentDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The human readable display name of the finding source such as
     * "Event Threat Detection" or "Security Health Analytics".
     * </pre>
     *
     * <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for parentDisplayName.
     */
    public com.google.protobuf.ByteString getParentDisplayNameBytes() {
      java.lang.Object ref = parentDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The human readable display name of the finding source such as
     * "Event Threat Detection" or "Security Health Analytics".
     * </pre>
     *
     * <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The parentDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentDisplayName_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The human readable display name of the finding source such as
     * "Event Threat Detection" or "Security Health Analytics".
     * </pre>
     *
     * <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentDisplayName() {
      parentDisplayName_ = getDefaultInstance().getParentDisplayName();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The human readable display name of the finding source such as
     * "Event Threat Detection" or "Security Health Analytics".
     * </pre>
     *
     * <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for parentDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentDisplayName_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Contains more details about the finding.
     * </pre>
     *
     * <code>string description = 37;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains more details about the finding.
     * </pre>
     *
     * <code>string description = 37;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains more details about the finding.
     * </pre>
     *
     * <code>string description = 37;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains more details about the finding.
     * </pre>
     *
     * <code>string description = 37;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains more details about the finding.
     * </pre>
     *
     * <code>string description = 37;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1.Exfiltration exfiltration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Exfiltration,
            com.google.cloud.securitycenter.v1.Exfiltration.Builder,
            com.google.cloud.securitycenter.v1.ExfiltrationOrBuilder>
        exfiltrationBuilder_;
    /**
     *
     *
     * <pre>
     * Represents exfiltrations associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     *
     * @return Whether the exfiltration field is set.
     */
    public boolean hasExfiltration() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Represents exfiltrations associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     *
     * @return The exfiltration.
     */
    public com.google.cloud.securitycenter.v1.Exfiltration getExfiltration() {
      if (exfiltrationBuilder_ == null) {
        return exfiltration_ == null
            ? com.google.cloud.securitycenter.v1.Exfiltration.getDefaultInstance()
            : exfiltration_;
      } else {
        return exfiltrationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents exfiltrations associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     */
    public Builder setExfiltration(com.google.cloud.securitycenter.v1.Exfiltration value) {
      if (exfiltrationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        exfiltration_ = value;
      } else {
        exfiltrationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents exfiltrations associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     */
    public Builder setExfiltration(
        com.google.cloud.securitycenter.v1.Exfiltration.Builder builderForValue) {
      if (exfiltrationBuilder_ == null) {
        exfiltration_ = builderForValue.build();
      } else {
        exfiltrationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents exfiltrations associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     */
    public Builder mergeExfiltration(com.google.cloud.securitycenter.v1.Exfiltration value) {
      if (exfiltrationBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)
            && exfiltration_ != null
            && exfiltration_
                != com.google.cloud.securitycenter.v1.Exfiltration.getDefaultInstance()) {
          getExfiltrationBuilder().mergeFrom(value);
        } else {
          exfiltration_ = value;
        }
      } else {
        exfiltrationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents exfiltrations associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     */
    public Builder clearExfiltration() {
      bitField0_ = (bitField0_ & ~0x08000000);
      exfiltration_ = null;
      if (exfiltrationBuilder_ != null) {
        exfiltrationBuilder_.dispose();
        exfiltrationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents exfiltrations associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     */
    public com.google.cloud.securitycenter.v1.Exfiltration.Builder getExfiltrationBuilder() {
      bitField0_ |= 0x08000000;
      onChanged();
      return getExfiltrationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents exfiltrations associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfiltrationOrBuilder getExfiltrationOrBuilder() {
      if (exfiltrationBuilder_ != null) {
        return exfiltrationBuilder_.getMessageOrBuilder();
      } else {
        return exfiltration_ == null
            ? com.google.cloud.securitycenter.v1.Exfiltration.getDefaultInstance()
            : exfiltration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Represents exfiltrations associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Exfiltration,
            com.google.cloud.securitycenter.v1.Exfiltration.Builder,
            com.google.cloud.securitycenter.v1.ExfiltrationOrBuilder>
        getExfiltrationFieldBuilder() {
      if (exfiltrationBuilder_ == null) {
        exfiltrationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Exfiltration,
                com.google.cloud.securitycenter.v1.Exfiltration.Builder,
                com.google.cloud.securitycenter.v1.ExfiltrationOrBuilder>(
                getExfiltration(), getParentForChildren(), isClean());
        exfiltration_ = null;
      }
      return exfiltrationBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.IamBinding> iamBindings_ =
        java.util.Collections.emptyList();

    private void ensureIamBindingsIsMutable() {
      if (!((bitField0_ & 0x10000000) != 0)) {
        iamBindings_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.IamBinding>(iamBindings_);
        bitField0_ |= 0x10000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.IamBinding,
            com.google.cloud.securitycenter.v1.IamBinding.Builder,
            com.google.cloud.securitycenter.v1.IamBindingOrBuilder>
        iamBindingsBuilder_;

    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.IamBinding> getIamBindingsList() {
      if (iamBindingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(iamBindings_);
      } else {
        return iamBindingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public int getIamBindingsCount() {
      if (iamBindingsBuilder_ == null) {
        return iamBindings_.size();
      } else {
        return iamBindingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public com.google.cloud.securitycenter.v1.IamBinding getIamBindings(int index) {
      if (iamBindingsBuilder_ == null) {
        return iamBindings_.get(index);
      } else {
        return iamBindingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public Builder setIamBindings(int index, com.google.cloud.securitycenter.v1.IamBinding value) {
      if (iamBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIamBindingsIsMutable();
        iamBindings_.set(index, value);
        onChanged();
      } else {
        iamBindingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public Builder setIamBindings(
        int index, com.google.cloud.securitycenter.v1.IamBinding.Builder builderForValue) {
      if (iamBindingsBuilder_ == null) {
        ensureIamBindingsIsMutable();
        iamBindings_.set(index, builderForValue.build());
        onChanged();
      } else {
        iamBindingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public Builder addIamBindings(com.google.cloud.securitycenter.v1.IamBinding value) {
      if (iamBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIamBindingsIsMutable();
        iamBindings_.add(value);
        onChanged();
      } else {
        iamBindingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public Builder addIamBindings(int index, com.google.cloud.securitycenter.v1.IamBinding value) {
      if (iamBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIamBindingsIsMutable();
        iamBindings_.add(index, value);
        onChanged();
      } else {
        iamBindingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public Builder addIamBindings(
        com.google.cloud.securitycenter.v1.IamBinding.Builder builderForValue) {
      if (iamBindingsBuilder_ == null) {
        ensureIamBindingsIsMutable();
        iamBindings_.add(builderForValue.build());
        onChanged();
      } else {
        iamBindingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public Builder addIamBindings(
        int index, com.google.cloud.securitycenter.v1.IamBinding.Builder builderForValue) {
      if (iamBindingsBuilder_ == null) {
        ensureIamBindingsIsMutable();
        iamBindings_.add(index, builderForValue.build());
        onChanged();
      } else {
        iamBindingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public Builder addAllIamBindings(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.IamBinding> values) {
      if (iamBindingsBuilder_ == null) {
        ensureIamBindingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, iamBindings_);
        onChanged();
      } else {
        iamBindingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public Builder clearIamBindings() {
      if (iamBindingsBuilder_ == null) {
        iamBindings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x10000000);
        onChanged();
      } else {
        iamBindingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public Builder removeIamBindings(int index) {
      if (iamBindingsBuilder_ == null) {
        ensureIamBindingsIsMutable();
        iamBindings_.remove(index);
        onChanged();
      } else {
        iamBindingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public com.google.cloud.securitycenter.v1.IamBinding.Builder getIamBindingsBuilder(int index) {
      return getIamBindingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public com.google.cloud.securitycenter.v1.IamBindingOrBuilder getIamBindingsOrBuilder(
        int index) {
      if (iamBindingsBuilder_ == null) {
        return iamBindings_.get(index);
      } else {
        return iamBindingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.IamBindingOrBuilder>
        getIamBindingsOrBuilderList() {
      if (iamBindingsBuilder_ != null) {
        return iamBindingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(iamBindings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public com.google.cloud.securitycenter.v1.IamBinding.Builder addIamBindingsBuilder() {
      return getIamBindingsFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.IamBinding.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public com.google.cloud.securitycenter.v1.IamBinding.Builder addIamBindingsBuilder(int index) {
      return getIamBindingsFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.IamBinding.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Represents IAM bindings associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.IamBinding.Builder>
        getIamBindingsBuilderList() {
      return getIamBindingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.IamBinding,
            com.google.cloud.securitycenter.v1.IamBinding.Builder,
            com.google.cloud.securitycenter.v1.IamBindingOrBuilder>
        getIamBindingsFieldBuilder() {
      if (iamBindingsBuilder_ == null) {
        iamBindingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.IamBinding,
                com.google.cloud.securitycenter.v1.IamBinding.Builder,
                com.google.cloud.securitycenter.v1.IamBindingOrBuilder>(
                iamBindings_, ((bitField0_ & 0x10000000) != 0), getParentForChildren(), isClean());
        iamBindings_ = null;
      }
      return iamBindingsBuilder_;
    }

    private java.lang.Object nextSteps_ = "";
    /**
     *
     *
     * <pre>
     * Steps to address the finding.
     * </pre>
     *
     * <code>string next_steps = 40;</code>
     *
     * @return The nextSteps.
     */
    public java.lang.String getNextSteps() {
      java.lang.Object ref = nextSteps_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextSteps_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Steps to address the finding.
     * </pre>
     *
     * <code>string next_steps = 40;</code>
     *
     * @return The bytes for nextSteps.
     */
    public com.google.protobuf.ByteString getNextStepsBytes() {
      java.lang.Object ref = nextSteps_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextSteps_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Steps to address the finding.
     * </pre>
     *
     * <code>string next_steps = 40;</code>
     *
     * @param value The nextSteps to set.
     * @return This builder for chaining.
     */
    public Builder setNextSteps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextSteps_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to address the finding.
     * </pre>
     *
     * <code>string next_steps = 40;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextSteps() {
      nextSteps_ = getDefaultInstance().getNextSteps();
      bitField0_ = (bitField0_ & ~0x20000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to address the finding.
     * </pre>
     *
     * <code>string next_steps = 40;</code>
     *
     * @param value The bytes for nextSteps to set.
     * @return This builder for chaining.
     */
    public Builder setNextStepsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextSteps_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    private java.lang.Object moduleName_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier of the module which generated the finding.
     * Example:
     * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
     * </pre>
     *
     * <code>string module_name = 41;</code>
     *
     * @return The moduleName.
     */
    public java.lang.String getModuleName() {
      java.lang.Object ref = moduleName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        moduleName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the module which generated the finding.
     * Example:
     * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
     * </pre>
     *
     * <code>string module_name = 41;</code>
     *
     * @return The bytes for moduleName.
     */
    public com.google.protobuf.ByteString getModuleNameBytes() {
      java.lang.Object ref = moduleName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        moduleName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the module which generated the finding.
     * Example:
     * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
     * </pre>
     *
     * <code>string module_name = 41;</code>
     *
     * @param value The moduleName to set.
     * @return This builder for chaining.
     */
    public Builder setModuleName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      moduleName_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the module which generated the finding.
     * Example:
     * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
     * </pre>
     *
     * <code>string module_name = 41;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModuleName() {
      moduleName_ = getDefaultInstance().getModuleName();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the module which generated the finding.
     * Example:
     * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
     * </pre>
     *
     * <code>string module_name = 41;</code>
     *
     * @param value The bytes for moduleName to set.
     * @return This builder for chaining.
     */
    public Builder setModuleNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      moduleName_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Container> containers_ =
        java.util.Collections.emptyList();

    private void ensureContainersIsMutable() {
      if (!((bitField0_ & 0x80000000) != 0)) {
        containers_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Container>(containers_);
        bitField0_ |= 0x80000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Container,
            com.google.cloud.securitycenter.v1.Container.Builder,
            com.google.cloud.securitycenter.v1.ContainerOrBuilder>
        containersBuilder_;

    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Container> getContainersList() {
      if (containersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(containers_);
      } else {
        return containersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public int getContainersCount() {
      if (containersBuilder_ == null) {
        return containers_.size();
      } else {
        return containersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public com.google.cloud.securitycenter.v1.Container getContainers(int index) {
      if (containersBuilder_ == null) {
        return containers_.get(index);
      } else {
        return containersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public Builder setContainers(int index, com.google.cloud.securitycenter.v1.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.set(index, value);
        onChanged();
      } else {
        containersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public Builder setContainers(
        int index, com.google.cloud.securitycenter.v1.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.set(index, builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public Builder addContainers(com.google.cloud.securitycenter.v1.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.add(value);
        onChanged();
      } else {
        containersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public Builder addContainers(int index, com.google.cloud.securitycenter.v1.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.add(index, value);
        onChanged();
      } else {
        containersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public Builder addContainers(
        com.google.cloud.securitycenter.v1.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.add(builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public Builder addContainers(
        int index, com.google.cloud.securitycenter.v1.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.add(index, builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public Builder addAllContainers(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Container> values) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, containers_);
        onChanged();
      } else {
        containersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public Builder clearContainers() {
      if (containersBuilder_ == null) {
        containers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x80000000);
        onChanged();
      } else {
        containersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public Builder removeContainers(int index) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.remove(index);
        onChanged();
      } else {
        containersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public com.google.cloud.securitycenter.v1.Container.Builder getContainersBuilder(int index) {
      return getContainersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public com.google.cloud.securitycenter.v1.ContainerOrBuilder getContainersOrBuilder(int index) {
      if (containersBuilder_ == null) {
        return containers_.get(index);
      } else {
        return containersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.ContainerOrBuilder>
        getContainersOrBuilderList() {
      if (containersBuilder_ != null) {
        return containersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(containers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public com.google.cloud.securitycenter.v1.Container.Builder addContainersBuilder() {
      return getContainersFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Container.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public com.google.cloud.securitycenter.v1.Container.Builder addContainersBuilder(int index) {
      return getContainersFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.Container.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Containers associated with the finding. This field provides information for
     * both Kubernetes and non-Kubernetes containers.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Container.Builder>
        getContainersBuilderList() {
      return getContainersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Container,
            com.google.cloud.securitycenter.v1.Container.Builder,
            com.google.cloud.securitycenter.v1.ContainerOrBuilder>
        getContainersFieldBuilder() {
      if (containersBuilder_ == null) {
        containersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Container,
                com.google.cloud.securitycenter.v1.Container.Builder,
                com.google.cloud.securitycenter.v1.ContainerOrBuilder>(
                containers_, ((bitField0_ & 0x80000000) != 0), getParentForChildren(), isClean());
        containers_ = null;
      }
      return containersBuilder_;
    }

    private com.google.cloud.securitycenter.v1.Kubernetes kubernetes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes,
            com.google.cloud.securitycenter.v1.Kubernetes.Builder,
            com.google.cloud.securitycenter.v1.KubernetesOrBuilder>
        kubernetesBuilder_;
    /**
     *
     *
     * <pre>
     * Kubernetes resources associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     *
     * @return Whether the kubernetes field is set.
     */
    public boolean hasKubernetes() {
      return ((bitField1_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Kubernetes resources associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     *
     * @return The kubernetes.
     */
    public com.google.cloud.securitycenter.v1.Kubernetes getKubernetes() {
      if (kubernetesBuilder_ == null) {
        return kubernetes_ == null
            ? com.google.cloud.securitycenter.v1.Kubernetes.getDefaultInstance()
            : kubernetes_;
      } else {
        return kubernetesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes resources associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     */
    public Builder setKubernetes(com.google.cloud.securitycenter.v1.Kubernetes value) {
      if (kubernetesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubernetes_ = value;
      } else {
        kubernetesBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes resources associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     */
    public Builder setKubernetes(
        com.google.cloud.securitycenter.v1.Kubernetes.Builder builderForValue) {
      if (kubernetesBuilder_ == null) {
        kubernetes_ = builderForValue.build();
      } else {
        kubernetesBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes resources associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     */
    public Builder mergeKubernetes(com.google.cloud.securitycenter.v1.Kubernetes value) {
      if (kubernetesBuilder_ == null) {
        if (((bitField1_ & 0x00000001) != 0)
            && kubernetes_ != null
            && kubernetes_ != com.google.cloud.securitycenter.v1.Kubernetes.getDefaultInstance()) {
          getKubernetesBuilder().mergeFrom(value);
        } else {
          kubernetes_ = value;
        }
      } else {
        kubernetesBuilder_.mergeFrom(value);
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes resources associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     */
    public Builder clearKubernetes() {
      bitField1_ = (bitField1_ & ~0x00000001);
      kubernetes_ = null;
      if (kubernetesBuilder_ != null) {
        kubernetesBuilder_.dispose();
        kubernetesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes resources associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Builder getKubernetesBuilder() {
      bitField1_ |= 0x00000001;
      onChanged();
      return getKubernetesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Kubernetes resources associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     */
    public com.google.cloud.securitycenter.v1.KubernetesOrBuilder getKubernetesOrBuilder() {
      if (kubernetesBuilder_ != null) {
        return kubernetesBuilder_.getMessageOrBuilder();
      } else {
        return kubernetes_ == null
            ? com.google.cloud.securitycenter.v1.Kubernetes.getDefaultInstance()
            : kubernetes_;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes resources associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes,
            com.google.cloud.securitycenter.v1.Kubernetes.Builder,
            com.google.cloud.securitycenter.v1.KubernetesOrBuilder>
        getKubernetesFieldBuilder() {
      if (kubernetesBuilder_ == null) {
        kubernetesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Kubernetes,
                com.google.cloud.securitycenter.v1.Kubernetes.Builder,
                com.google.cloud.securitycenter.v1.KubernetesOrBuilder>(
                getKubernetes(), getParentForChildren(), isClean());
        kubernetes_ = null;
      }
      return kubernetesBuilder_;
    }

    private com.google.cloud.securitycenter.v1.Database database_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Database,
            com.google.cloud.securitycenter.v1.Database.Builder,
            com.google.cloud.securitycenter.v1.DatabaseOrBuilder>
        databaseBuilder_;
    /**
     *
     *
     * <pre>
     * Database associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     *
     * @return Whether the database field is set.
     */
    public boolean hasDatabase() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Database associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     *
     * @return The database.
     */
    public com.google.cloud.securitycenter.v1.Database getDatabase() {
      if (databaseBuilder_ == null) {
        return database_ == null
            ? com.google.cloud.securitycenter.v1.Database.getDefaultInstance()
            : database_;
      } else {
        return databaseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Database associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     */
    public Builder setDatabase(com.google.cloud.securitycenter.v1.Database value) {
      if (databaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        database_ = value;
      } else {
        databaseBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     */
    public Builder setDatabase(
        com.google.cloud.securitycenter.v1.Database.Builder builderForValue) {
      if (databaseBuilder_ == null) {
        database_ = builderForValue.build();
      } else {
        databaseBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     */
    public Builder mergeDatabase(com.google.cloud.securitycenter.v1.Database value) {
      if (databaseBuilder_ == null) {
        if (((bitField1_ & 0x00000002) != 0)
            && database_ != null
            && database_ != com.google.cloud.securitycenter.v1.Database.getDefaultInstance()) {
          getDatabaseBuilder().mergeFrom(value);
        } else {
          database_ = value;
        }
      } else {
        databaseBuilder_.mergeFrom(value);
      }
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     */
    public Builder clearDatabase() {
      bitField1_ = (bitField1_ & ~0x00000002);
      database_ = null;
      if (databaseBuilder_ != null) {
        databaseBuilder_.dispose();
        databaseBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     */
    public com.google.cloud.securitycenter.v1.Database.Builder getDatabaseBuilder() {
      bitField1_ |= 0x00000002;
      onChanged();
      return getDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Database associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     */
    public com.google.cloud.securitycenter.v1.DatabaseOrBuilder getDatabaseOrBuilder() {
      if (databaseBuilder_ != null) {
        return databaseBuilder_.getMessageOrBuilder();
      } else {
        return database_ == null
            ? com.google.cloud.securitycenter.v1.Database.getDefaultInstance()
            : database_;
      }
    }
    /**
     *
     *
     * <pre>
     * Database associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Database,
            com.google.cloud.securitycenter.v1.Database.Builder,
            com.google.cloud.securitycenter.v1.DatabaseOrBuilder>
        getDatabaseFieldBuilder() {
      if (databaseBuilder_ == null) {
        databaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Database,
                com.google.cloud.securitycenter.v1.Database.Builder,
                com.google.cloud.securitycenter.v1.DatabaseOrBuilder>(
                getDatabase(), getParentForChildren(), isClean());
        database_ = null;
      }
      return databaseBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.File> files_ =
        java.util.Collections.emptyList();

    private void ensureFilesIsMutable() {
      if (!((bitField1_ & 0x00000004) != 0)) {
        files_ = new java.util.ArrayList<com.google.cloud.securitycenter.v1.File>(files_);
        bitField1_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.File,
            com.google.cloud.securitycenter.v1.File.Builder,
            com.google.cloud.securitycenter.v1.FileOrBuilder>
        filesBuilder_;

    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.File> getFilesList() {
      if (filesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(files_);
      } else {
        return filesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public int getFilesCount() {
      if (filesBuilder_ == null) {
        return files_.size();
      } else {
        return filesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public com.google.cloud.securitycenter.v1.File getFiles(int index) {
      if (filesBuilder_ == null) {
        return files_.get(index);
      } else {
        return filesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public Builder setFiles(int index, com.google.cloud.securitycenter.v1.File value) {
      if (filesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.set(index, value);
        onChanged();
      } else {
        filesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public Builder setFiles(
        int index, com.google.cloud.securitycenter.v1.File.Builder builderForValue) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.set(index, builderForValue.build());
        onChanged();
      } else {
        filesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public Builder addFiles(com.google.cloud.securitycenter.v1.File value) {
      if (filesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.add(value);
        onChanged();
      } else {
        filesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public Builder addFiles(int index, com.google.cloud.securitycenter.v1.File value) {
      if (filesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilesIsMutable();
        files_.add(index, value);
        onChanged();
      } else {
        filesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public Builder addFiles(com.google.cloud.securitycenter.v1.File.Builder builderForValue) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.add(builderForValue.build());
        onChanged();
      } else {
        filesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public Builder addFiles(
        int index, com.google.cloud.securitycenter.v1.File.Builder builderForValue) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.add(index, builderForValue.build());
        onChanged();
      } else {
        filesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public Builder addAllFiles(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.File> values) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, files_);
        onChanged();
      } else {
        filesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public Builder clearFiles() {
      if (filesBuilder_ == null) {
        files_ = java.util.Collections.emptyList();
        bitField1_ = (bitField1_ & ~0x00000004);
        onChanged();
      } else {
        filesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public Builder removeFiles(int index) {
      if (filesBuilder_ == null) {
        ensureFilesIsMutable();
        files_.remove(index);
        onChanged();
      } else {
        filesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public com.google.cloud.securitycenter.v1.File.Builder getFilesBuilder(int index) {
      return getFilesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public com.google.cloud.securitycenter.v1.FileOrBuilder getFilesOrBuilder(int index) {
      if (filesBuilder_ == null) {
        return files_.get(index);
      } else {
        return filesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.FileOrBuilder>
        getFilesOrBuilderList() {
      if (filesBuilder_ != null) {
        return filesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(files_);
      }
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public com.google.cloud.securitycenter.v1.File.Builder addFilesBuilder() {
      return getFilesFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.File.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public com.google.cloud.securitycenter.v1.File.Builder addFilesBuilder(int index) {
      return getFilesFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.File.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * File associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.File.Builder> getFilesBuilderList() {
      return getFilesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.File,
            com.google.cloud.securitycenter.v1.File.Builder,
            com.google.cloud.securitycenter.v1.FileOrBuilder>
        getFilesFieldBuilder() {
      if (filesBuilder_ == null) {
        filesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.File,
                com.google.cloud.securitycenter.v1.File.Builder,
                com.google.cloud.securitycenter.v1.FileOrBuilder>(
                files_, ((bitField1_ & 0x00000004) != 0), getParentForChildren(), isClean());
        files_ = null;
      }
      return filesBuilder_;
    }

    private com.google.cloud.securitycenter.v1.CloudDlpInspection cloudDlpInspection_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CloudDlpInspection,
            com.google.cloud.securitycenter.v1.CloudDlpInspection.Builder,
            com.google.cloud.securitycenter.v1.CloudDlpInspectionOrBuilder>
        cloudDlpInspectionBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     *
     * @return Whether the cloudDlpInspection field is set.
     */
    public boolean hasCloudDlpInspection() {
      return ((bitField1_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     *
     * @return The cloudDlpInspection.
     */
    public com.google.cloud.securitycenter.v1.CloudDlpInspection getCloudDlpInspection() {
      if (cloudDlpInspectionBuilder_ == null) {
        return cloudDlpInspection_ == null
            ? com.google.cloud.securitycenter.v1.CloudDlpInspection.getDefaultInstance()
            : cloudDlpInspection_;
      } else {
        return cloudDlpInspectionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     */
    public Builder setCloudDlpInspection(
        com.google.cloud.securitycenter.v1.CloudDlpInspection value) {
      if (cloudDlpInspectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cloudDlpInspection_ = value;
      } else {
        cloudDlpInspectionBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     */
    public Builder setCloudDlpInspection(
        com.google.cloud.securitycenter.v1.CloudDlpInspection.Builder builderForValue) {
      if (cloudDlpInspectionBuilder_ == null) {
        cloudDlpInspection_ = builderForValue.build();
      } else {
        cloudDlpInspectionBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     */
    public Builder mergeCloudDlpInspection(
        com.google.cloud.securitycenter.v1.CloudDlpInspection value) {
      if (cloudDlpInspectionBuilder_ == null) {
        if (((bitField1_ & 0x00000008) != 0)
            && cloudDlpInspection_ != null
            && cloudDlpInspection_
                != com.google.cloud.securitycenter.v1.CloudDlpInspection.getDefaultInstance()) {
          getCloudDlpInspectionBuilder().mergeFrom(value);
        } else {
          cloudDlpInspection_ = value;
        }
      } else {
        cloudDlpInspectionBuilder_.mergeFrom(value);
      }
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     */
    public Builder clearCloudDlpInspection() {
      bitField1_ = (bitField1_ & ~0x00000008);
      cloudDlpInspection_ = null;
      if (cloudDlpInspectionBuilder_ != null) {
        cloudDlpInspectionBuilder_.dispose();
        cloudDlpInspectionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     */
    public com.google.cloud.securitycenter.v1.CloudDlpInspection.Builder
        getCloudDlpInspectionBuilder() {
      bitField1_ |= 0x00000008;
      onChanged();
      return getCloudDlpInspectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     */
    public com.google.cloud.securitycenter.v1.CloudDlpInspectionOrBuilder
        getCloudDlpInspectionOrBuilder() {
      if (cloudDlpInspectionBuilder_ != null) {
        return cloudDlpInspectionBuilder_.getMessageOrBuilder();
      } else {
        return cloudDlpInspection_ == null
            ? com.google.cloud.securitycenter.v1.CloudDlpInspection.getDefaultInstance()
            : cloudDlpInspection_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
     * associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CloudDlpInspection,
            com.google.cloud.securitycenter.v1.CloudDlpInspection.Builder,
            com.google.cloud.securitycenter.v1.CloudDlpInspectionOrBuilder>
        getCloudDlpInspectionFieldBuilder() {
      if (cloudDlpInspectionBuilder_ == null) {
        cloudDlpInspectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.CloudDlpInspection,
                com.google.cloud.securitycenter.v1.CloudDlpInspection.Builder,
                com.google.cloud.securitycenter.v1.CloudDlpInspectionOrBuilder>(
                getCloudDlpInspection(), getParentForChildren(), isClean());
        cloudDlpInspection_ = null;
      }
      return cloudDlpInspectionBuilder_;
    }

    private com.google.cloud.securitycenter.v1.CloudDlpDataProfile cloudDlpDataProfile_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CloudDlpDataProfile,
            com.google.cloud.securitycenter.v1.CloudDlpDataProfile.Builder,
            com.google.cloud.securitycenter.v1.CloudDlpDataProfileOrBuilder>
        cloudDlpDataProfileBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud DLP data profile that is associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     *
     * @return Whether the cloudDlpDataProfile field is set.
     */
    public boolean hasCloudDlpDataProfile() {
      return ((bitField1_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cloud DLP data profile that is associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     *
     * @return The cloudDlpDataProfile.
     */
    public com.google.cloud.securitycenter.v1.CloudDlpDataProfile getCloudDlpDataProfile() {
      if (cloudDlpDataProfileBuilder_ == null) {
        return cloudDlpDataProfile_ == null
            ? com.google.cloud.securitycenter.v1.CloudDlpDataProfile.getDefaultInstance()
            : cloudDlpDataProfile_;
      } else {
        return cloudDlpDataProfileBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud DLP data profile that is associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     */
    public Builder setCloudDlpDataProfile(
        com.google.cloud.securitycenter.v1.CloudDlpDataProfile value) {
      if (cloudDlpDataProfileBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cloudDlpDataProfile_ = value;
      } else {
        cloudDlpDataProfileBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud DLP data profile that is associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     */
    public Builder setCloudDlpDataProfile(
        com.google.cloud.securitycenter.v1.CloudDlpDataProfile.Builder builderForValue) {
      if (cloudDlpDataProfileBuilder_ == null) {
        cloudDlpDataProfile_ = builderForValue.build();
      } else {
        cloudDlpDataProfileBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud DLP data profile that is associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     */
    public Builder mergeCloudDlpDataProfile(
        com.google.cloud.securitycenter.v1.CloudDlpDataProfile value) {
      if (cloudDlpDataProfileBuilder_ == null) {
        if (((bitField1_ & 0x00000010) != 0)
            && cloudDlpDataProfile_ != null
            && cloudDlpDataProfile_
                != com.google.cloud.securitycenter.v1.CloudDlpDataProfile.getDefaultInstance()) {
          getCloudDlpDataProfileBuilder().mergeFrom(value);
        } else {
          cloudDlpDataProfile_ = value;
        }
      } else {
        cloudDlpDataProfileBuilder_.mergeFrom(value);
      }
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud DLP data profile that is associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     */
    public Builder clearCloudDlpDataProfile() {
      bitField1_ = (bitField1_ & ~0x00000010);
      cloudDlpDataProfile_ = null;
      if (cloudDlpDataProfileBuilder_ != null) {
        cloudDlpDataProfileBuilder_.dispose();
        cloudDlpDataProfileBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud DLP data profile that is associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     */
    public com.google.cloud.securitycenter.v1.CloudDlpDataProfile.Builder
        getCloudDlpDataProfileBuilder() {
      bitField1_ |= 0x00000010;
      onChanged();
      return getCloudDlpDataProfileFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud DLP data profile that is associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     */
    public com.google.cloud.securitycenter.v1.CloudDlpDataProfileOrBuilder
        getCloudDlpDataProfileOrBuilder() {
      if (cloudDlpDataProfileBuilder_ != null) {
        return cloudDlpDataProfileBuilder_.getMessageOrBuilder();
      } else {
        return cloudDlpDataProfile_ == null
            ? com.google.cloud.securitycenter.v1.CloudDlpDataProfile.getDefaultInstance()
            : cloudDlpDataProfile_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud DLP data profile that is associated with the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CloudDlpDataProfile,
            com.google.cloud.securitycenter.v1.CloudDlpDataProfile.Builder,
            com.google.cloud.securitycenter.v1.CloudDlpDataProfileOrBuilder>
        getCloudDlpDataProfileFieldBuilder() {
      if (cloudDlpDataProfileBuilder_ == null) {
        cloudDlpDataProfileBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.CloudDlpDataProfile,
                com.google.cloud.securitycenter.v1.CloudDlpDataProfile.Builder,
                com.google.cloud.securitycenter.v1.CloudDlpDataProfileOrBuilder>(
                getCloudDlpDataProfile(), getParentForChildren(), isClean());
        cloudDlpDataProfile_ = null;
      }
      return cloudDlpDataProfileBuilder_;
    }

    private com.google.cloud.securitycenter.v1.KernelRootkit kernelRootkit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.KernelRootkit,
            com.google.cloud.securitycenter.v1.KernelRootkit.Builder,
            com.google.cloud.securitycenter.v1.KernelRootkitOrBuilder>
        kernelRootkitBuilder_;
    /**
     *
     *
     * <pre>
     * Signature of the kernel rootkit.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     *
     * @return Whether the kernelRootkit field is set.
     */
    public boolean hasKernelRootkit() {
      return ((bitField1_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Signature of the kernel rootkit.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     *
     * @return The kernelRootkit.
     */
    public com.google.cloud.securitycenter.v1.KernelRootkit getKernelRootkit() {
      if (kernelRootkitBuilder_ == null) {
        return kernelRootkit_ == null
            ? com.google.cloud.securitycenter.v1.KernelRootkit.getDefaultInstance()
            : kernelRootkit_;
      } else {
        return kernelRootkitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Signature of the kernel rootkit.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     */
    public Builder setKernelRootkit(com.google.cloud.securitycenter.v1.KernelRootkit value) {
      if (kernelRootkitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kernelRootkit_ = value;
      } else {
        kernelRootkitBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signature of the kernel rootkit.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     */
    public Builder setKernelRootkit(
        com.google.cloud.securitycenter.v1.KernelRootkit.Builder builderForValue) {
      if (kernelRootkitBuilder_ == null) {
        kernelRootkit_ = builderForValue.build();
      } else {
        kernelRootkitBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signature of the kernel rootkit.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     */
    public Builder mergeKernelRootkit(com.google.cloud.securitycenter.v1.KernelRootkit value) {
      if (kernelRootkitBuilder_ == null) {
        if (((bitField1_ & 0x00000020) != 0)
            && kernelRootkit_ != null
            && kernelRootkit_
                != com.google.cloud.securitycenter.v1.KernelRootkit.getDefaultInstance()) {
          getKernelRootkitBuilder().mergeFrom(value);
        } else {
          kernelRootkit_ = value;
        }
      } else {
        kernelRootkitBuilder_.mergeFrom(value);
      }
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signature of the kernel rootkit.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     */
    public Builder clearKernelRootkit() {
      bitField1_ = (bitField1_ & ~0x00000020);
      kernelRootkit_ = null;
      if (kernelRootkitBuilder_ != null) {
        kernelRootkitBuilder_.dispose();
        kernelRootkitBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signature of the kernel rootkit.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     */
    public com.google.cloud.securitycenter.v1.KernelRootkit.Builder getKernelRootkitBuilder() {
      bitField1_ |= 0x00000020;
      onChanged();
      return getKernelRootkitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Signature of the kernel rootkit.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     */
    public com.google.cloud.securitycenter.v1.KernelRootkitOrBuilder getKernelRootkitOrBuilder() {
      if (kernelRootkitBuilder_ != null) {
        return kernelRootkitBuilder_.getMessageOrBuilder();
      } else {
        return kernelRootkit_ == null
            ? com.google.cloud.securitycenter.v1.KernelRootkit.getDefaultInstance()
            : kernelRootkit_;
      }
    }
    /**
     *
     *
     * <pre>
     * Signature of the kernel rootkit.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.KernelRootkit,
            com.google.cloud.securitycenter.v1.KernelRootkit.Builder,
            com.google.cloud.securitycenter.v1.KernelRootkitOrBuilder>
        getKernelRootkitFieldBuilder() {
      if (kernelRootkitBuilder_ == null) {
        kernelRootkitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.KernelRootkit,
                com.google.cloud.securitycenter.v1.KernelRootkit.Builder,
                com.google.cloud.securitycenter.v1.KernelRootkitOrBuilder>(
                getKernelRootkit(), getParentForChildren(), isClean());
        kernelRootkit_ = null;
      }
      return kernelRootkitBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Finding)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Finding)
  private static final com.google.cloud.securitycenter.v1.Finding DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Finding();
  }

  public static com.google.cloud.securitycenter.v1.Finding getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Finding> PARSER =
      new com.google.protobuf.AbstractParser<Finding>() {
        @java.lang.Override
        public Finding parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Finding> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Finding> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Finding getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
