/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/finding.proto

package com.google.cloud.securitycenter.v1;

public interface FindingOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Finding)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The [relative resource
   * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
   * of the finding. Example:
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
   * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
   * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The [relative resource
   * name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
   * of the finding. Example:
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
   * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
   * "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The relative resource name of the source the finding belongs to. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * This field is immutable after creation time.
   * For example:
   * "organizations/{organization_id}/sources/{source_id}"
   * </pre>
   *
   * <code>string parent = 2;</code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * The relative resource name of the source the finding belongs to. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * This field is immutable after creation time.
   * For example:
   * "organizations/{organization_id}/sources/{source_id}"
   * </pre>
   *
   * <code>string parent = 2;</code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * For findings on Google Cloud resources, the full resource
   * name of the Google Cloud resource this finding is for. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * When the finding is for a non-Google Cloud resource, the resourceName can
   * be a customer or partner defined string. This field is immutable after
   * creation time.
   * </pre>
   *
   * <code>string resource_name = 3;</code>
   *
   * @return The resourceName.
   */
  java.lang.String getResourceName();
  /**
   *
   *
   * <pre>
   * For findings on Google Cloud resources, the full resource
   * name of the Google Cloud resource this finding is for. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * When the finding is for a non-Google Cloud resource, the resourceName can
   * be a customer or partner defined string. This field is immutable after
   * creation time.
   * </pre>
   *
   * <code>string resource_name = 3;</code>
   *
   * @return The bytes for resourceName.
   */
  com.google.protobuf.ByteString getResourceNameBytes();

  /**
   *
   *
   * <pre>
   * The state of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * The state of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
   *
   * @return The state.
   */
  com.google.cloud.securitycenter.v1.Finding.State getState();

  /**
   *
   *
   * <pre>
   * The additional taxonomy group within findings from a given source.
   * This field is immutable after creation time.
   * Example: "XSS_FLASH_INJECTION"
   * </pre>
   *
   * <code>string category = 5;</code>
   *
   * @return The category.
   */
  java.lang.String getCategory();
  /**
   *
   *
   * <pre>
   * The additional taxonomy group within findings from a given source.
   * This field is immutable after creation time.
   * Example: "XSS_FLASH_INJECTION"
   * </pre>
   *
   * <code>string category = 5;</code>
   *
   * @return The bytes for category.
   */
  com.google.protobuf.ByteString getCategoryBytes();

  /**
   *
   *
   * <pre>
   * The URI that, if available, points to a web page outside of Security
   * Command Center where additional information about the finding can be found.
   * This field is guaranteed to be either empty or a well formed URL.
   * </pre>
   *
   * <code>string external_uri = 6;</code>
   *
   * @return The externalUri.
   */
  java.lang.String getExternalUri();
  /**
   *
   *
   * <pre>
   * The URI that, if available, points to a web page outside of Security
   * Command Center where additional information about the finding can be found.
   * This field is guaranteed to be either empty or a well formed URL.
   * </pre>
   *
   * <code>string external_uri = 6;</code>
   *
   * @return The bytes for externalUri.
   */
  com.google.protobuf.ByteString getExternalUriBytes();

  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  int getSourcePropertiesCount();
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  boolean containsSourceProperties(java.lang.String key);
  /** Use {@link #getSourcePropertiesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.protobuf.Value> getSourceProperties();
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  java.util.Map<java.lang.String, com.google.protobuf.Value> getSourcePropertiesMap();
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  /* nullable */
  com.google.protobuf.Value getSourcePropertiesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue);
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  com.google.protobuf.Value getSourcePropertiesOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. User specified security marks. These marks are entirely
   * managed by the user and come from the SecurityMarks resource that belongs
   * to the finding.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the securityMarks field is set.
   */
  boolean hasSecurityMarks();
  /**
   *
   *
   * <pre>
   * Output only. User specified security marks. These marks are entirely
   * managed by the user and come from the SecurityMarks resource that belongs
   * to the finding.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The securityMarks.
   */
  com.google.cloud.securitycenter.v1.SecurityMarks getSecurityMarks();
  /**
   *
   *
   * <pre>
   * Output only. User specified security marks. These marks are entirely
   * managed by the user and come from the SecurityMarks resource that belongs
   * to the finding.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder getSecurityMarksOrBuilder();

  /**
   *
   *
   * <pre>
   * The time the finding was first detected. If an existing finding is updated,
   * then this is the time the update occurred.
   * For example, if the finding represents an open firewall, this property
   * captures the time the detector believes the firewall became open. The
   * accuracy is determined by the detector. If the finding is later resolved,
   * then this time reflects when the finding was resolved. This must not
   * be set to a value greater than the current timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 9;</code>
   *
   * @return Whether the eventTime field is set.
   */
  boolean hasEventTime();
  /**
   *
   *
   * <pre>
   * The time the finding was first detected. If an existing finding is updated,
   * then this is the time the update occurred.
   * For example, if the finding represents an open firewall, this property
   * captures the time the detector believes the firewall became open. The
   * accuracy is determined by the detector. If the finding is later resolved,
   * then this time reflects when the finding was resolved. This must not
   * be set to a value greater than the current timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 9;</code>
   *
   * @return The eventTime.
   */
  com.google.protobuf.Timestamp getEventTime();
  /**
   *
   *
   * <pre>
   * The time the finding was first detected. If an existing finding is updated,
   * then this is the time the update occurred.
   * For example, if the finding represents an open firewall, this property
   * captures the time the detector believes the firewall became open. The
   * accuracy is determined by the detector. If the finding is later resolved,
   * then this time reflects when the finding was resolved. This must not
   * be set to a value greater than the current timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 9;</code>
   */
  com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The time at which the finding was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * The time at which the finding was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * The time at which the finding was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The severity of the finding. This field is managed by the source that
   * writes the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  int getSeverityValue();
  /**
   *
   *
   * <pre>
   * The severity of the finding. This field is managed by the source that
   * writes the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
   *
   * @return The severity.
   */
  com.google.cloud.securitycenter.v1.Finding.Severity getSeverity();

  /**
   *
   *
   * <pre>
   * The canonical name of the finding. It's either
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
   * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
   * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
   * depending on the closest CRM ancestor of the resource associated with the
   * finding.
   * </pre>
   *
   * <code>string canonical_name = 14;</code>
   *
   * @return The canonicalName.
   */
  java.lang.String getCanonicalName();
  /**
   *
   *
   * <pre>
   * The canonical name of the finding. It's either
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
   * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
   * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
   * depending on the closest CRM ancestor of the resource associated with the
   * finding.
   * </pre>
   *
   * <code>string canonical_name = 14;</code>
   *
   * @return The bytes for canonicalName.
   */
  com.google.protobuf.ByteString getCanonicalNameBytes();

  /**
   *
   *
   * <pre>
   * Indicates the mute state of a finding (either muted, unmuted
   * or undefined). Unlike other attributes of a finding, a finding provider
   * shouldn't set the value of mute.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
   *
   * @return The enum numeric value on the wire for mute.
   */
  int getMuteValue();
  /**
   *
   *
   * <pre>
   * Indicates the mute state of a finding (either muted, unmuted
   * or undefined). Unlike other attributes of a finding, a finding provider
   * shouldn't set the value of mute.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
   *
   * @return The mute.
   */
  com.google.cloud.securitycenter.v1.Finding.Mute getMute();

  /**
   *
   *
   * <pre>
   * The class of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
   *
   * @return The enum numeric value on the wire for findingClass.
   */
  int getFindingClassValue();
  /**
   *
   *
   * <pre>
   * The class of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
   *
   * @return The findingClass.
   */
  com.google.cloud.securitycenter.v1.Finding.FindingClass getFindingClass();

  /**
   *
   *
   * <pre>
   * Represents what's commonly known as an *indicator of compromise* (IoC) in
   * computer forensics. This is an artifact observed on a network or in an
   * operating system that, with high confidence, indicates a computer
   * intrusion. For more information, see [Indicator of
   * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
   *
   * @return Whether the indicator field is set.
   */
  boolean hasIndicator();
  /**
   *
   *
   * <pre>
   * Represents what's commonly known as an *indicator of compromise* (IoC) in
   * computer forensics. This is an artifact observed on a network or in an
   * operating system that, with high confidence, indicates a computer
   * intrusion. For more information, see [Indicator of
   * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
   *
   * @return The indicator.
   */
  com.google.cloud.securitycenter.v1.Indicator getIndicator();
  /**
   *
   *
   * <pre>
   * Represents what's commonly known as an *indicator of compromise* (IoC) in
   * computer forensics. This is an artifact observed on a network or in an
   * operating system that, with high confidence, indicates a computer
   * intrusion. For more information, see [Indicator of
   * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
   */
  com.google.cloud.securitycenter.v1.IndicatorOrBuilder getIndicatorOrBuilder();

  /**
   *
   *
   * <pre>
   * Represents vulnerability-specific fields like CVE and CVSS scores.
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
   *
   * @return Whether the vulnerability field is set.
   */
  boolean hasVulnerability();
  /**
   *
   *
   * <pre>
   * Represents vulnerability-specific fields like CVE and CVSS scores.
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
   *
   * @return The vulnerability.
   */
  com.google.cloud.securitycenter.v1.Vulnerability getVulnerability();
  /**
   *
   *
   * <pre>
   * Represents vulnerability-specific fields like CVE and CVSS scores.
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
   */
  com.google.cloud.securitycenter.v1.VulnerabilityOrBuilder getVulnerabilityOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The most recent time this finding was muted or unmuted.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the muteUpdateTime field is set.
   */
  boolean hasMuteUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this finding was muted or unmuted.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The muteUpdateTime.
   */
  com.google.protobuf.Timestamp getMuteUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The most recent time this finding was muted or unmuted.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getMuteUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Third party SIEM/SOAR fields within SCC, contains external
   * system information and external system finding fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getExternalSystemsCount();
  /**
   *
   *
   * <pre>
   * Output only. Third party SIEM/SOAR fields within SCC, contains external
   * system information and external system finding fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  boolean containsExternalSystems(java.lang.String key);
  /** Use {@link #getExternalSystemsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
      getExternalSystems();
  /**
   *
   *
   * <pre>
   * Output only. Third party SIEM/SOAR fields within SCC, contains external
   * system information and external system finding fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ExternalSystem>
      getExternalSystemsMap();
  /**
   *
   *
   * <pre>
   * Output only. Third party SIEM/SOAR fields within SCC, contains external
   * system information and external system finding fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  /* nullable */
  com.google.cloud.securitycenter.v1.ExternalSystem getExternalSystemsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.securitycenter.v1.ExternalSystem defaultValue);
  /**
   *
   *
   * <pre>
   * Output only. Third party SIEM/SOAR fields within SCC, contains external
   * system information and external system finding fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ExternalSystem&gt; external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.securitycenter.v1.ExternalSystem getExternalSystemsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * MITRE ATT&amp;CK tactics and techniques related to this finding.
   * See: https://attack.mitre.org
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
   *
   * @return Whether the mitreAttack field is set.
   */
  boolean hasMitreAttack();
  /**
   *
   *
   * <pre>
   * MITRE ATT&amp;CK tactics and techniques related to this finding.
   * See: https://attack.mitre.org
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
   *
   * @return The mitreAttack.
   */
  com.google.cloud.securitycenter.v1.MitreAttack getMitreAttack();
  /**
   *
   *
   * <pre>
   * MITRE ATT&amp;CK tactics and techniques related to this finding.
   * See: https://attack.mitre.org
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
   */
  com.google.cloud.securitycenter.v1.MitreAttackOrBuilder getMitreAttackOrBuilder();

  /**
   *
   *
   * <pre>
   * Access details associated with the finding, such as more information on the
   * caller, which method was accessed, and from where.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
   *
   * @return Whether the access field is set.
   */
  boolean hasAccess();
  /**
   *
   *
   * <pre>
   * Access details associated with the finding, such as more information on the
   * caller, which method was accessed, and from where.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
   *
   * @return The access.
   */
  com.google.cloud.securitycenter.v1.Access getAccess();
  /**
   *
   *
   * <pre>
   * Access details associated with the finding, such as more information on the
   * caller, which method was accessed, and from where.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
   */
  com.google.cloud.securitycenter.v1.AccessOrBuilder getAccessOrBuilder();

  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  java.util.List<com.google.cloud.securitycenter.v1.Connection> getConnectionsList();
  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  com.google.cloud.securitycenter.v1.Connection getConnections(int index);
  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  int getConnectionsCount();
  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  java.util.List<? extends com.google.cloud.securitycenter.v1.ConnectionOrBuilder>
      getConnectionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Contains information about the IP connection associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
   */
  com.google.cloud.securitycenter.v1.ConnectionOrBuilder getConnectionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Records additional information about the mute operation, for example, the
   * [mute configuration](/security-command-center/docs/how-to-mute-findings)
   * that muted the finding and the user who muted the finding.
   * </pre>
   *
   * <code>string mute_initiator = 28;</code>
   *
   * @return The muteInitiator.
   */
  java.lang.String getMuteInitiator();
  /**
   *
   *
   * <pre>
   * Records additional information about the mute operation, for example, the
   * [mute configuration](/security-command-center/docs/how-to-mute-findings)
   * that muted the finding and the user who muted the finding.
   * </pre>
   *
   * <code>string mute_initiator = 28;</code>
   *
   * @return The bytes for muteInitiator.
   */
  com.google.protobuf.ByteString getMuteInitiatorBytes();

  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  java.util.List<com.google.cloud.securitycenter.v1.Process> getProcessesList();
  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  com.google.cloud.securitycenter.v1.Process getProcesses(int index);
  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  int getProcessesCount();
  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  java.util.List<? extends com.google.cloud.securitycenter.v1.ProcessOrBuilder>
      getProcessesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Represents operating system processes associated with the Finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
   */
  com.google.cloud.securitycenter.v1.ProcessOrBuilder getProcessesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. Map containing the points of contact for the given finding.
   * The key represents the type of contact, while the value contains a list of
   * all the contacts that pertain. Please refer to:
   * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
   *
   *     {
   *       "security": {
   *         "contacts": [
   *           {
   *             "email": "person1&#64;company.com"
   *           },
   *           {
   *             "email": "person2&#64;company.com"
   *           }
   *         ]
   *       }
   *     }
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getContactsCount();
  /**
   *
   *
   * <pre>
   * Output only. Map containing the points of contact for the given finding.
   * The key represents the type of contact, while the value contains a list of
   * all the contacts that pertain. Please refer to:
   * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
   *
   *     {
   *       "security": {
   *         "contacts": [
   *           {
   *             "email": "person1&#64;company.com"
   *           },
   *           {
   *             "email": "person2&#64;company.com"
   *           }
   *         ]
   *       }
   *     }
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  boolean containsContacts(java.lang.String key);
  /** Use {@link #getContactsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails> getContacts();
  /**
   *
   *
   * <pre>
   * Output only. Map containing the points of contact for the given finding.
   * The key represents the type of contact, while the value contains a list of
   * all the contacts that pertain. Please refer to:
   * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
   *
   *     {
   *       "security": {
   *         "contacts": [
   *           {
   *             "email": "person1&#64;company.com"
   *           },
   *           {
   *             "email": "person2&#64;company.com"
   *           }
   *         ]
   *       }
   *     }
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.Map<java.lang.String, com.google.cloud.securitycenter.v1.ContactDetails>
      getContactsMap();
  /**
   *
   *
   * <pre>
   * Output only. Map containing the points of contact for the given finding.
   * The key represents the type of contact, while the value contains a list of
   * all the contacts that pertain. Please refer to:
   * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
   *
   *     {
   *       "security": {
   *         "contacts": [
   *           {
   *             "email": "person1&#64;company.com"
   *           },
   *           {
   *             "email": "person2&#64;company.com"
   *           }
   *         ]
   *       }
   *     }
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  /* nullable */
  com.google.cloud.securitycenter.v1.ContactDetails getContactsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.securitycenter.v1.ContactDetails defaultValue);
  /**
   *
   *
   * <pre>
   * Output only. Map containing the points of contact for the given finding.
   * The key represents the type of contact, while the value contains a list of
   * all the contacts that pertain. Please refer to:
   * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
   *
   *     {
   *       "security": {
   *         "contacts": [
   *           {
   *             "email": "person1&#64;company.com"
   *           },
   *           {
   *             "email": "person2&#64;company.com"
   *           }
   *         ]
   *       }
   *     }
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.securitycenter.v1.ContactDetails&gt; contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.securitycenter.v1.ContactDetails getContactsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  java.util.List<com.google.cloud.securitycenter.v1.Compliance> getCompliancesList();
  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  com.google.cloud.securitycenter.v1.Compliance getCompliances(int index);
  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  int getCompliancesCount();
  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  java.util.List<? extends com.google.cloud.securitycenter.v1.ComplianceOrBuilder>
      getCompliancesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Contains compliance information for security standards associated to the
   * finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
   */
  com.google.cloud.securitycenter.v1.ComplianceOrBuilder getCompliancesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. The human readable display name of the finding source such as
   * "Event Threat Detection" or "Security Health Analytics".
   * </pre>
   *
   * <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The parentDisplayName.
   */
  java.lang.String getParentDisplayName();
  /**
   *
   *
   * <pre>
   * Output only. The human readable display name of the finding source such as
   * "Event Threat Detection" or "Security Health Analytics".
   * </pre>
   *
   * <code>string parent_display_name = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for parentDisplayName.
   */
  com.google.protobuf.ByteString getParentDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Contains more details about the finding.
   * </pre>
   *
   * <code>string description = 37;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Contains more details about the finding.
   * </pre>
   *
   * <code>string description = 37;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Represents exfiltrations associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
   *
   * @return Whether the exfiltration field is set.
   */
  boolean hasExfiltration();
  /**
   *
   *
   * <pre>
   * Represents exfiltrations associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
   *
   * @return The exfiltration.
   */
  com.google.cloud.securitycenter.v1.Exfiltration getExfiltration();
  /**
   *
   *
   * <pre>
   * Represents exfiltrations associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
   */
  com.google.cloud.securitycenter.v1.ExfiltrationOrBuilder getExfiltrationOrBuilder();

  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  java.util.List<com.google.cloud.securitycenter.v1.IamBinding> getIamBindingsList();
  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  com.google.cloud.securitycenter.v1.IamBinding getIamBindings(int index);
  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  int getIamBindingsCount();
  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  java.util.List<? extends com.google.cloud.securitycenter.v1.IamBindingOrBuilder>
      getIamBindingsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Represents IAM bindings associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
   */
  com.google.cloud.securitycenter.v1.IamBindingOrBuilder getIamBindingsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Steps to address the finding.
   * </pre>
   *
   * <code>string next_steps = 40;</code>
   *
   * @return The nextSteps.
   */
  java.lang.String getNextSteps();
  /**
   *
   *
   * <pre>
   * Steps to address the finding.
   * </pre>
   *
   * <code>string next_steps = 40;</code>
   *
   * @return The bytes for nextSteps.
   */
  com.google.protobuf.ByteString getNextStepsBytes();

  /**
   *
   *
   * <pre>
   * Unique identifier of the module which generated the finding.
   * Example:
   * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
   * </pre>
   *
   * <code>string module_name = 41;</code>
   *
   * @return The moduleName.
   */
  java.lang.String getModuleName();
  /**
   *
   *
   * <pre>
   * Unique identifier of the module which generated the finding.
   * Example:
   * folders/598186756061/securityHealthAnalyticsSettings/customModules/56799441161885
   * </pre>
   *
   * <code>string module_name = 41;</code>
   *
   * @return The bytes for moduleName.
   */
  com.google.protobuf.ByteString getModuleNameBytes();

  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  java.util.List<com.google.cloud.securitycenter.v1.Container> getContainersList();
  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  com.google.cloud.securitycenter.v1.Container getContainers(int index);
  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  int getContainersCount();
  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  java.util.List<? extends com.google.cloud.securitycenter.v1.ContainerOrBuilder>
      getContainersOrBuilderList();
  /**
   *
   *
   * <pre>
   * Containers associated with the finding. This field provides information for
   * both Kubernetes and non-Kubernetes containers.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
   */
  com.google.cloud.securitycenter.v1.ContainerOrBuilder getContainersOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Kubernetes resources associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
   *
   * @return Whether the kubernetes field is set.
   */
  boolean hasKubernetes();
  /**
   *
   *
   * <pre>
   * Kubernetes resources associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
   *
   * @return The kubernetes.
   */
  com.google.cloud.securitycenter.v1.Kubernetes getKubernetes();
  /**
   *
   *
   * <pre>
   * Kubernetes resources associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
   */
  com.google.cloud.securitycenter.v1.KubernetesOrBuilder getKubernetesOrBuilder();

  /**
   *
   *
   * <pre>
   * Database associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
   *
   * @return Whether the database field is set.
   */
  boolean hasDatabase();
  /**
   *
   *
   * <pre>
   * Database associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
   *
   * @return The database.
   */
  com.google.cloud.securitycenter.v1.Database getDatabase();
  /**
   *
   *
   * <pre>
   * Database associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Database database = 44;</code>
   */
  com.google.cloud.securitycenter.v1.DatabaseOrBuilder getDatabaseOrBuilder();

  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  java.util.List<com.google.cloud.securitycenter.v1.File> getFilesList();
  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  com.google.cloud.securitycenter.v1.File getFiles(int index);
  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  int getFilesCount();
  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  java.util.List<? extends com.google.cloud.securitycenter.v1.FileOrBuilder>
      getFilesOrBuilderList();
  /**
   *
   *
   * <pre>
   * File associated with the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File files = 46;</code>
   */
  com.google.cloud.securitycenter.v1.FileOrBuilder getFilesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
   * associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
   *
   * @return Whether the cloudDlpInspection field is set.
   */
  boolean hasCloudDlpInspection();
  /**
   *
   *
   * <pre>
   * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
   * associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
   *
   * @return The cloudDlpInspection.
   */
  com.google.cloud.securitycenter.v1.CloudDlpInspection getCloudDlpInspection();
  /**
   *
   *
   * <pre>
   * Cloud Data Loss Prevention (Cloud DLP) inspection results that are
   * associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpInspection cloud_dlp_inspection = 48;</code>
   */
  com.google.cloud.securitycenter.v1.CloudDlpInspectionOrBuilder getCloudDlpInspectionOrBuilder();

  /**
   *
   *
   * <pre>
   * Cloud DLP data profile that is associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
   *
   * @return Whether the cloudDlpDataProfile field is set.
   */
  boolean hasCloudDlpDataProfile();
  /**
   *
   *
   * <pre>
   * Cloud DLP data profile that is associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
   *
   * @return The cloudDlpDataProfile.
   */
  com.google.cloud.securitycenter.v1.CloudDlpDataProfile getCloudDlpDataProfile();
  /**
   *
   *
   * <pre>
   * Cloud DLP data profile that is associated with the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CloudDlpDataProfile cloud_dlp_data_profile = 49;</code>
   */
  com.google.cloud.securitycenter.v1.CloudDlpDataProfileOrBuilder getCloudDlpDataProfileOrBuilder();

  /**
   *
   *
   * <pre>
   * Signature of the kernel rootkit.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
   *
   * @return Whether the kernelRootkit field is set.
   */
  boolean hasKernelRootkit();
  /**
   *
   *
   * <pre>
   * Signature of the kernel rootkit.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
   *
   * @return The kernelRootkit.
   */
  com.google.cloud.securitycenter.v1.KernelRootkit getKernelRootkit();
  /**
   *
   *
   * <pre>
   * Signature of the kernel rootkit.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.KernelRootkit kernel_rootkit = 50;</code>
   */
  com.google.cloud.securitycenter.v1.KernelRootkitOrBuilder getKernelRootkitOrBuilder();
}
