/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/indicator.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Represents what's commonly known as an _indicator of compromise_ (IoC) in
 * computer forensics. This is an artifact observed on a network or in an
 * operating system that, with high confidence, indicates a computer intrusion.
 * For more information, see [Indicator of
 * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Indicator}
 */
public final class Indicator extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Indicator)
    IndicatorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Indicator.newBuilder() to construct.
  private Indicator(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Indicator() {
    ipAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    domains_ = com.google.protobuf.LazyStringArrayList.emptyList();
    signatures_ = java.util.Collections.emptyList();
    uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Indicator();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.IndicatorProto
        .internal_static_google_cloud_securitycenter_v1_Indicator_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.IndicatorProto
        .internal_static_google_cloud_securitycenter_v1_Indicator_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Indicator.class,
            com.google.cloud.securitycenter.v1.Indicator.Builder.class);
  }

  public interface ProcessSignatureOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Indicator.ProcessSignature)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Signature indicating that a binary family was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
     * </code>
     *
     * @return Whether the memoryHashSignature field is set.
     */
    boolean hasMemoryHashSignature();
    /**
     *
     *
     * <pre>
     * Signature indicating that a binary family was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
     * </code>
     *
     * @return The memoryHashSignature.
     */
    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
        getMemoryHashSignature();
    /**
     *
     *
     * <pre>
     * Signature indicating that a binary family was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
     * </code>
     */
    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignatureOrBuilder
        getMemoryHashSignatureOrBuilder();

    /**
     *
     *
     * <pre>
     * Signature indicating that a YARA rule was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
     * </code>
     *
     * @return Whether the yaraRuleSignature field is set.
     */
    boolean hasYaraRuleSignature();
    /**
     *
     *
     * <pre>
     * Signature indicating that a YARA rule was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
     * </code>
     *
     * @return The yaraRuleSignature.
     */
    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
        getYaraRuleSignature();
    /**
     *
     *
     * <pre>
     * Signature indicating that a YARA rule was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
     * </code>
     */
    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignatureOrBuilder
        getYaraRuleSignatureOrBuilder();

    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.SignatureCase getSignatureCase();
  }
  /**
   *
   *
   * <pre>
   * Indicates what signature matched this process.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Indicator.ProcessSignature}
   */
  public static final class ProcessSignature extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Indicator.ProcessSignature)
      ProcessSignatureOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ProcessSignature.newBuilder() to construct.
    private ProcessSignature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ProcessSignature() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ProcessSignature();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.IndicatorProto
          .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.IndicatorProto
          .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.class,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder.class);
    }

    public interface MemoryHashSignatureOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The binary family.
       * </pre>
       *
       * <code>string binary_family = 1;</code>
       *
       * @return The binaryFamily.
       */
      java.lang.String getBinaryFamily();
      /**
       *
       *
       * <pre>
       * The binary family.
       * </pre>
       *
       * <code>string binary_family = 1;</code>
       *
       * @return The bytes for binaryFamily.
       */
      com.google.protobuf.ByteString getBinaryFamilyBytes();

      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      java.util.List<
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Detection>
          getDetectionsList();
      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection
          getDetections(int index);
      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      int getDetectionsCount();
      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .DetectionOrBuilder>
          getDetectionsOrBuilderList();
      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
              .DetectionOrBuilder
          getDetectionsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * A signature corresponding to memory page hashes.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature}
     */
    public static final class MemoryHashSignature extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
        MemoryHashSignatureOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MemoryHashSignature.newBuilder() to construct.
      private MemoryHashSignature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MemoryHashSignature() {
        binaryFamily_ = "";
        detections_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MemoryHashSignature();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.IndicatorProto
            .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.IndicatorProto
            .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .class,
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Builder.class);
      }

      public interface DetectionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The name of the binary associated with the memory hash
         * signature detection.
         * </pre>
         *
         * <code>string binary = 2;</code>
         *
         * @return The binary.
         */
        java.lang.String getBinary();
        /**
         *
         *
         * <pre>
         * The name of the binary associated with the memory hash
         * signature detection.
         * </pre>
         *
         * <code>string binary = 2;</code>
         *
         * @return The bytes for binary.
         */
        com.google.protobuf.ByteString getBinaryBytes();

        /**
         *
         *
         * <pre>
         * The percentage of memory page hashes in the signature
         * that were matched.
         * </pre>
         *
         * <code>double percent_pages_matched = 3;</code>
         *
         * @return The percentPagesMatched.
         */
        double getPercentPagesMatched();
      }
      /**
       *
       *
       * <pre>
       * Memory hash detection contributing to the binary family match.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection}
       */
      public static final class Detection extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection)
          DetectionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Detection.newBuilder() to construct.
        private Detection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Detection() {
          binary_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Detection();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.securitycenter.v1.IndicatorProto
              .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_Detection_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.securitycenter.v1.IndicatorProto
              .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_Detection_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .Detection.class,
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .Detection.Builder.class);
        }

        public static final int BINARY_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object binary_ = "";
        /**
         *
         *
         * <pre>
         * The name of the binary associated with the memory hash
         * signature detection.
         * </pre>
         *
         * <code>string binary = 2;</code>
         *
         * @return The binary.
         */
        @java.lang.Override
        public java.lang.String getBinary() {
          java.lang.Object ref = binary_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            binary_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the binary associated with the memory hash
         * signature detection.
         * </pre>
         *
         * <code>string binary = 2;</code>
         *
         * @return The bytes for binary.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getBinaryBytes() {
          java.lang.Object ref = binary_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            binary_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int PERCENT_PAGES_MATCHED_FIELD_NUMBER = 3;
        private double percentPagesMatched_ = 0D;
        /**
         *
         *
         * <pre>
         * The percentage of memory page hashes in the signature
         * that were matched.
         * </pre>
         *
         * <code>double percent_pages_matched = 3;</code>
         *
         * @return The percentPagesMatched.
         */
        @java.lang.Override
        public double getPercentPagesMatched() {
          return percentPagesMatched_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(binary_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, binary_);
          }
          if (java.lang.Double.doubleToRawLongBits(percentPagesMatched_) != 0) {
            output.writeDouble(3, percentPagesMatched_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(binary_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, binary_);
          }
          if (java.lang.Double.doubleToRawLongBits(percentPagesMatched_) != 0) {
            size +=
                com.google.protobuf.CodedOutputStream.computeDoubleSize(3, percentPagesMatched_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Detection)) {
            return super.equals(obj);
          }
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Detection
              other =
                  (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                          .Detection)
                      obj;

          if (!getBinary().equals(other.getBinary())) return false;
          if (java.lang.Double.doubleToLongBits(getPercentPagesMatched())
              != java.lang.Double.doubleToLongBits(other.getPercentPagesMatched())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + BINARY_FIELD_NUMBER;
          hash = (53 * hash) + getBinary().hashCode();
          hash = (37 * hash) + PERCENT_PAGES_MATCHED_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getPercentPagesMatched()));
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Memory hash detection contributing to the binary family match.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection)
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                .DetectionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.securitycenter.v1.IndicatorProto
                .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_Detection_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.securitycenter.v1.IndicatorProto
                .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_Detection_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                        .MemoryHashSignature.Detection.class,
                    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                        .MemoryHashSignature.Detection.Builder.class);
          }

          // Construct using
          // com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            binary_ = "";
            percentPagesMatched_ = 0D;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.securitycenter.v1.IndicatorProto
                .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_Detection_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Detection
              getDefaultInstanceForType() {
            return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                .Detection.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Detection
              build() {
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Detection
              buildPartial() {
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection
                result =
                    new com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                        .MemoryHashSignature.Detection(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .Detection
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.binary_ = binary_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.percentPagesMatched_ = percentPagesMatched_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection) {
              return mergeFrom(
                  (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                          .Detection)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .Detection
                  other) {
            if (other
                == com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection.getDefaultInstance()) return this;
            if (!other.getBinary().isEmpty()) {
              binary_ = other.binary_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (other.getPercentPagesMatched() != 0D) {
              setPercentPagesMatched(other.getPercentPagesMatched());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 18:
                    {
                      binary_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 18
                  case 25:
                    {
                      percentPagesMatched_ = input.readDouble();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 25
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object binary_ = "";
          /**
           *
           *
           * <pre>
           * The name of the binary associated with the memory hash
           * signature detection.
           * </pre>
           *
           * <code>string binary = 2;</code>
           *
           * @return The binary.
           */
          public java.lang.String getBinary() {
            java.lang.Object ref = binary_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              binary_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the binary associated with the memory hash
           * signature detection.
           * </pre>
           *
           * <code>string binary = 2;</code>
           *
           * @return The bytes for binary.
           */
          public com.google.protobuf.ByteString getBinaryBytes() {
            java.lang.Object ref = binary_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              binary_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the binary associated with the memory hash
           * signature detection.
           * </pre>
           *
           * <code>string binary = 2;</code>
           *
           * @param value The binary to set.
           * @return This builder for chaining.
           */
          public Builder setBinary(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            binary_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the binary associated with the memory hash
           * signature detection.
           * </pre>
           *
           * <code>string binary = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearBinary() {
            binary_ = getDefaultInstance().getBinary();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the binary associated with the memory hash
           * signature detection.
           * </pre>
           *
           * <code>string binary = 2;</code>
           *
           * @param value The bytes for binary to set.
           * @return This builder for chaining.
           */
          public Builder setBinaryBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            binary_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private double percentPagesMatched_;
          /**
           *
           *
           * <pre>
           * The percentage of memory page hashes in the signature
           * that were matched.
           * </pre>
           *
           * <code>double percent_pages_matched = 3;</code>
           *
           * @return The percentPagesMatched.
           */
          @java.lang.Override
          public double getPercentPagesMatched() {
            return percentPagesMatched_;
          }
          /**
           *
           *
           * <pre>
           * The percentage of memory page hashes in the signature
           * that were matched.
           * </pre>
           *
           * <code>double percent_pages_matched = 3;</code>
           *
           * @param value The percentPagesMatched to set.
           * @return This builder for chaining.
           */
          public Builder setPercentPagesMatched(double value) {

            percentPagesMatched_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The percentage of memory page hashes in the signature
           * that were matched.
           * </pre>
           *
           * <code>double percent_pages_matched = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPercentPagesMatched() {
            bitField0_ = (bitField0_ & ~0x00000002);
            percentPagesMatched_ = 0D;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection)
        private static final com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Detection();
        }

        public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                .MemoryHashSignature.Detection
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Detection> PARSER =
            new com.google.protobuf.AbstractParser<Detection>() {
              @java.lang.Override
              public Detection parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Detection> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Detection> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                .Detection
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int BINARY_FAMILY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object binaryFamily_ = "";
      /**
       *
       *
       * <pre>
       * The binary family.
       * </pre>
       *
       * <code>string binary_family = 1;</code>
       *
       * @return The binaryFamily.
       */
      @java.lang.Override
      public java.lang.String getBinaryFamily() {
        java.lang.Object ref = binaryFamily_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          binaryFamily_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The binary family.
       * </pre>
       *
       * <code>string binary_family = 1;</code>
       *
       * @return The bytes for binaryFamily.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBinaryFamilyBytes() {
        java.lang.Object ref = binaryFamily_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          binaryFamily_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DETECTIONS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Detection>
          detections_;
      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Detection>
          getDetectionsList() {
        return detections_;
      }
      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .DetectionOrBuilder>
          getDetectionsOrBuilderList() {
        return detections_;
      }
      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      @java.lang.Override
      public int getDetectionsCount() {
        return detections_.size();
      }
      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
              .Detection
          getDetections(int index) {
        return detections_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The list of memory hash detections contributing to the binary family
       * match.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
              .DetectionOrBuilder
          getDetectionsOrBuilder(int index) {
        return detections_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(binaryFamily_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, binaryFamily_);
        }
        for (int i = 0; i < detections_.size(); i++) {
          output.writeMessage(4, detections_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(binaryFamily_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, binaryFamily_);
        }
        for (int i = 0; i < detections_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, detections_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)) {
          return super.equals(obj);
        }
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature other =
            (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature) obj;

        if (!getBinaryFamily().equals(other.getBinaryFamily())) return false;
        if (!getDetectionsList().equals(other.getDetectionsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + BINARY_FAMILY_FIELD_NUMBER;
        hash = (53 * hash) + getBinaryFamily().hashCode();
        if (getDetectionsCount() > 0) {
          hash = (37 * hash) + DETECTIONS_FIELD_NUMBER;
          hash = (53 * hash) + getDetectionsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A signature corresponding to memory page hashes.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignatureOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.securitycenter.v1.IndicatorProto
              .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.securitycenter.v1.IndicatorProto
              .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .class,
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          binaryFamily_ = "";
          if (detectionsBuilder_ == null) {
            detections_ = java.util.Collections.emptyList();
          } else {
            detections_ = null;
            detectionsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.securitycenter.v1.IndicatorProto
              .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_MemoryHashSignature_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
            getDefaultInstanceForType() {
          return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
            build() {
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
            buildPartial() {
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature result =
              new com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                result) {
          if (detectionsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              detections_ = java.util.Collections.unmodifiableList(detections_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.detections_ = detections_;
          } else {
            result.detections_ = detectionsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.binaryFamily_ = binaryFamily_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature) {
            return mergeFrom(
                (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                other) {
          if (other
              == com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .getDefaultInstance()) return this;
          if (!other.getBinaryFamily().isEmpty()) {
            binaryFamily_ = other.binaryFamily_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (detectionsBuilder_ == null) {
            if (!other.detections_.isEmpty()) {
              if (detections_.isEmpty()) {
                detections_ = other.detections_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureDetectionsIsMutable();
                detections_.addAll(other.detections_);
              }
              onChanged();
            }
          } else {
            if (!other.detections_.isEmpty()) {
              if (detectionsBuilder_.isEmpty()) {
                detectionsBuilder_.dispose();
                detectionsBuilder_ = null;
                detections_ = other.detections_;
                bitField0_ = (bitField0_ & ~0x00000002);
                detectionsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectionsFieldBuilder()
                        : null;
              } else {
                detectionsBuilder_.addAllMessages(other.detections_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    binaryFamily_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 34:
                  {
                    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                            .MemoryHashSignature.Detection
                        m =
                            input.readMessage(
                                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                                    .MemoryHashSignature.Detection.parser(),
                                extensionRegistry);
                    if (detectionsBuilder_ == null) {
                      ensureDetectionsIsMutable();
                      detections_.add(m);
                    } else {
                      detectionsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object binaryFamily_ = "";
        /**
         *
         *
         * <pre>
         * The binary family.
         * </pre>
         *
         * <code>string binary_family = 1;</code>
         *
         * @return The binaryFamily.
         */
        public java.lang.String getBinaryFamily() {
          java.lang.Object ref = binaryFamily_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            binaryFamily_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The binary family.
         * </pre>
         *
         * <code>string binary_family = 1;</code>
         *
         * @return The bytes for binaryFamily.
         */
        public com.google.protobuf.ByteString getBinaryFamilyBytes() {
          java.lang.Object ref = binaryFamily_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            binaryFamily_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The binary family.
         * </pre>
         *
         * <code>string binary_family = 1;</code>
         *
         * @param value The binaryFamily to set.
         * @return This builder for chaining.
         */
        public Builder setBinaryFamily(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          binaryFamily_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The binary family.
         * </pre>
         *
         * <code>string binary_family = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBinaryFamily() {
          binaryFamily_ = getDefaultInstance().getBinaryFamily();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The binary family.
         * </pre>
         *
         * <code>string binary_family = 1;</code>
         *
         * @param value The bytes for binaryFamily to set.
         * @return This builder for chaining.
         */
        public Builder setBinaryFamilyBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          binaryFamily_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection>
            detections_ = java.util.Collections.emptyList();

        private void ensureDetectionsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            detections_ =
                new java.util.ArrayList<
                    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                        .MemoryHashSignature.Detection>(detections_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection,
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection.Builder,
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .DetectionOrBuilder>
            detectionsBuilder_;

        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection>
            getDetectionsList() {
          if (detectionsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detections_);
          } else {
            return detectionsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public int getDetectionsCount() {
          if (detectionsBuilder_ == null) {
            return detections_.size();
          } else {
            return detectionsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                .Detection
            getDetections(int index) {
          if (detectionsBuilder_ == null) {
            return detections_.get(index);
          } else {
            return detectionsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public Builder setDetections(
            int index,
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection
                value) {
          if (detectionsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectionsIsMutable();
            detections_.set(index, value);
            onChanged();
          } else {
            detectionsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public Builder setDetections(
            int index,
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection.Builder
                builderForValue) {
          if (detectionsBuilder_ == null) {
            ensureDetectionsIsMutable();
            detections_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectionsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public Builder addDetections(
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection
                value) {
          if (detectionsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectionsIsMutable();
            detections_.add(value);
            onChanged();
          } else {
            detectionsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public Builder addDetections(
            int index,
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection
                value) {
          if (detectionsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectionsIsMutable();
            detections_.add(index, value);
            onChanged();
          } else {
            detectionsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public Builder addDetections(
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection.Builder
                builderForValue) {
          if (detectionsBuilder_ == null) {
            ensureDetectionsIsMutable();
            detections_.add(builderForValue.build());
            onChanged();
          } else {
            detectionsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public Builder addDetections(
            int index,
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection.Builder
                builderForValue) {
          if (detectionsBuilder_ == null) {
            ensureDetectionsIsMutable();
            detections_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectionsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public Builder addAllDetections(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                            .MemoryHashSignature.Detection>
                values) {
          if (detectionsBuilder_ == null) {
            ensureDetectionsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detections_);
            onChanged();
          } else {
            detectionsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public Builder clearDetections() {
          if (detectionsBuilder_ == null) {
            detections_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            detectionsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public Builder removeDetections(int index) {
          if (detectionsBuilder_ == null) {
            ensureDetectionsIsMutable();
            detections_.remove(index);
            onChanged();
          } else {
            detectionsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                .Detection.Builder
            getDetectionsBuilder(int index) {
          return getDetectionsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                .DetectionOrBuilder
            getDetectionsOrBuilder(int index) {
          if (detectionsBuilder_ == null) {
            return detections_.get(index);
          } else {
            return detectionsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                        .MemoryHashSignature.DetectionOrBuilder>
            getDetectionsOrBuilderList() {
          if (detectionsBuilder_ != null) {
            return detectionsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detections_);
          }
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                .Detection.Builder
            addDetectionsBuilder() {
          return getDetectionsFieldBuilder()
              .addBuilder(
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .Detection.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                .Detection.Builder
            addDetectionsBuilder(int index) {
          return getDetectionsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .Detection.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * The list of memory hash detections contributing to the binary family
         * match.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Detection detections = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection.Builder>
            getDetectionsBuilderList() {
          return getDetectionsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection,
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .Detection.Builder,
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .DetectionOrBuilder>
            getDetectionsFieldBuilder() {
          if (detectionsBuilder_ == null) {
            detectionsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                        .MemoryHashSignature.Detection,
                    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                        .MemoryHashSignature.Detection.Builder,
                    com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                        .MemoryHashSignature.DetectionOrBuilder>(
                    detections_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            detections_ = null;
          }
          return detectionsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
      private static final com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature();
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignature
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MemoryHashSignature> PARSER =
          new com.google.protobuf.AbstractParser<MemoryHashSignature>() {
            @java.lang.Override
            public MemoryHashSignature parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MemoryHashSignature> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MemoryHashSignature> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface YaraRuleSignatureOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The name of the YARA rule.
       * </pre>
       *
       * <code>string yara_rule = 5;</code>
       *
       * @return The yaraRule.
       */
      java.lang.String getYaraRule();
      /**
       *
       *
       * <pre>
       * The name of the YARA rule.
       * </pre>
       *
       * <code>string yara_rule = 5;</code>
       *
       * @return The bytes for yaraRule.
       */
      com.google.protobuf.ByteString getYaraRuleBytes();
    }
    /**
     *
     *
     * <pre>
     * A signature corresponding to a YARA rule.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature}
     */
    public static final class YaraRuleSignature extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
        YaraRuleSignatureOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use YaraRuleSignature.newBuilder() to construct.
      private YaraRuleSignature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private YaraRuleSignature() {
        yaraRule_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new YaraRuleSignature();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.IndicatorProto
            .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_YaraRuleSignature_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.IndicatorProto
            .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_YaraRuleSignature_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                    .class,
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                    .Builder.class);
      }

      public static final int YARA_RULE_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object yaraRule_ = "";
      /**
       *
       *
       * <pre>
       * The name of the YARA rule.
       * </pre>
       *
       * <code>string yara_rule = 5;</code>
       *
       * @return The yaraRule.
       */
      @java.lang.Override
      public java.lang.String getYaraRule() {
        java.lang.Object ref = yaraRule_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          yaraRule_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the YARA rule.
       * </pre>
       *
       * <code>string yara_rule = 5;</code>
       *
       * @return The bytes for yaraRule.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getYaraRuleBytes() {
        java.lang.Object ref = yaraRule_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          yaraRule_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(yaraRule_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, yaraRule_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(yaraRule_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, yaraRule_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)) {
          return super.equals(obj);
        }
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature other =
            (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature) obj;

        if (!getYaraRule().equals(other.getYaraRule())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + YARA_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getYaraRule().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A signature corresponding to a YARA rule.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignatureOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.securitycenter.v1.IndicatorProto
              .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_YaraRuleSignature_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.securitycenter.v1.IndicatorProto
              .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_YaraRuleSignature_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                      .class,
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          yaraRule_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.securitycenter.v1.IndicatorProto
              .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_YaraRuleSignature_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
            getDefaultInstanceForType() {
          return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
            build() {
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
            buildPartial() {
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature result =
              new com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.yaraRule_ = yaraRule_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature) {
            return mergeFrom(
                (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature other) {
          if (other
              == com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                  .getDefaultInstance()) return this;
          if (!other.getYaraRule().isEmpty()) {
            yaraRule_ = other.yaraRule_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 42:
                  {
                    yaraRule_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object yaraRule_ = "";
        /**
         *
         *
         * <pre>
         * The name of the YARA rule.
         * </pre>
         *
         * <code>string yara_rule = 5;</code>
         *
         * @return The yaraRule.
         */
        public java.lang.String getYaraRule() {
          java.lang.Object ref = yaraRule_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            yaraRule_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the YARA rule.
         * </pre>
         *
         * <code>string yara_rule = 5;</code>
         *
         * @return The bytes for yaraRule.
         */
        public com.google.protobuf.ByteString getYaraRuleBytes() {
          java.lang.Object ref = yaraRule_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            yaraRule_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the YARA rule.
         * </pre>
         *
         * <code>string yara_rule = 5;</code>
         *
         * @param value The yaraRule to set.
         * @return This builder for chaining.
         */
        public Builder setYaraRule(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          yaraRule_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the YARA rule.
         * </pre>
         *
         * <code>string yara_rule = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearYaraRule() {
          yaraRule_ = getDefaultInstance().getYaraRule();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the YARA rule.
         * </pre>
         *
         * <code>string yara_rule = 5;</code>
         *
         * @param value The bytes for yaraRule to set.
         * @return This builder for chaining.
         */
        public Builder setYaraRuleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          yaraRule_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
      private static final com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .YaraRuleSignature
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature();
      }

      public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<YaraRuleSignature> PARSER =
          new com.google.protobuf.AbstractParser<YaraRuleSignature>() {
            @java.lang.Override
            public YaraRuleSignature parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<YaraRuleSignature> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<YaraRuleSignature> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int signatureCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object signature_;

    public enum SignatureCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      MEMORY_HASH_SIGNATURE(6),
      YARA_RULE_SIGNATURE(7),
      SIGNATURE_NOT_SET(0);
      private final int value;

      private SignatureCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SignatureCase valueOf(int value) {
        return forNumber(value);
      }

      public static SignatureCase forNumber(int value) {
        switch (value) {
          case 6:
            return MEMORY_HASH_SIGNATURE;
          case 7:
            return YARA_RULE_SIGNATURE;
          case 0:
            return SIGNATURE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SignatureCase getSignatureCase() {
      return SignatureCase.forNumber(signatureCase_);
    }

    public static final int MEMORY_HASH_SIGNATURE_FIELD_NUMBER = 6;
    /**
     *
     *
     * <pre>
     * Signature indicating that a binary family was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
     * </code>
     *
     * @return Whether the memoryHashSignature field is set.
     */
    @java.lang.Override
    public boolean hasMemoryHashSignature() {
      return signatureCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Signature indicating that a binary family was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
     * </code>
     *
     * @return The memoryHashSignature.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
        getMemoryHashSignature() {
      if (signatureCase_ == 6) {
        return (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
            signature_;
      }
      return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Signature indicating that a binary family was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
            .MemoryHashSignatureOrBuilder
        getMemoryHashSignatureOrBuilder() {
      if (signatureCase_ == 6) {
        return (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
            signature_;
      }
      return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
          .getDefaultInstance();
    }

    public static final int YARA_RULE_SIGNATURE_FIELD_NUMBER = 7;
    /**
     *
     *
     * <pre>
     * Signature indicating that a YARA rule was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
     * </code>
     *
     * @return Whether the yaraRuleSignature field is set.
     */
    @java.lang.Override
    public boolean hasYaraRuleSignature() {
      return signatureCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Signature indicating that a YARA rule was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
     * </code>
     *
     * @return The yaraRuleSignature.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
        getYaraRuleSignature() {
      if (signatureCase_ == 7) {
        return (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
            signature_;
      }
      return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Signature indicating that a YARA rule was matched.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignatureOrBuilder
        getYaraRuleSignatureOrBuilder() {
      if (signatureCase_ == 7) {
        return (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
            signature_;
      }
      return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (signatureCase_ == 6) {
        output.writeMessage(
            6,
            (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
                signature_);
      }
      if (signatureCase_ == 7) {
        output.writeMessage(
            7,
            (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
                signature_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (signatureCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6,
                (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature)
                    signature_);
      }
      if (signatureCase_ == 7) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7,
                (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
                    signature_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.Indicator.ProcessSignature)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.Indicator.ProcessSignature other =
          (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature) obj;

      if (!getSignatureCase().equals(other.getSignatureCase())) return false;
      switch (signatureCase_) {
        case 6:
          if (!getMemoryHashSignature().equals(other.getMemoryHashSignature())) return false;
          break;
        case 7:
          if (!getYaraRuleSignature().equals(other.getYaraRuleSignature())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (signatureCase_) {
        case 6:
          hash = (37 * hash) + MEMORY_HASH_SIGNATURE_FIELD_NUMBER;
          hash = (53 * hash) + getMemoryHashSignature().hashCode();
          break;
        case 7:
          hash = (37 * hash) + YARA_RULE_SIGNATURE_FIELD_NUMBER;
          hash = (53 * hash) + getYaraRuleSignature().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Indicates what signature matched this process.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.Indicator.ProcessSignature}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Indicator.ProcessSignature)
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignatureOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.IndicatorProto
            .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.IndicatorProto
            .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.class,
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (memoryHashSignatureBuilder_ != null) {
          memoryHashSignatureBuilder_.clear();
        }
        if (yaraRuleSignatureBuilder_ != null) {
          yaraRuleSignatureBuilder_.clear();
        }
        signatureCase_ = 0;
        signature_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.IndicatorProto
            .internal_static_google_cloud_securitycenter_v1_Indicator_ProcessSignature_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature build() {
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature buildPartial() {
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature result =
            new com.google.cloud.securitycenter.v1.Indicator.ProcessSignature(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature result) {
        result.signatureCase_ = signatureCase_;
        result.signature_ = this.signature_;
        if (signatureCase_ == 6 && memoryHashSignatureBuilder_ != null) {
          result.signature_ = memoryHashSignatureBuilder_.build();
        }
        if (signatureCase_ == 7 && yaraRuleSignatureBuilder_ != null) {
          result.signature_ = yaraRuleSignatureBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.Indicator.ProcessSignature) {
          return mergeFrom((com.google.cloud.securitycenter.v1.Indicator.ProcessSignature) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature other) {
        if (other
            == com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.getDefaultInstance())
          return this;
        switch (other.getSignatureCase()) {
          case MEMORY_HASH_SIGNATURE:
            {
              mergeMemoryHashSignature(other.getMemoryHashSignature());
              break;
            }
          case YARA_RULE_SIGNATURE:
            {
              mergeYaraRuleSignature(other.getYaraRuleSignature());
              break;
            }
          case SIGNATURE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 50:
                {
                  input.readMessage(
                      getMemoryHashSignatureFieldBuilder().getBuilder(), extensionRegistry);
                  signatureCase_ = 6;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getYaraRuleSignatureFieldBuilder().getBuilder(), extensionRegistry);
                  signatureCase_ = 7;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int signatureCase_ = 0;
      private java.lang.Object signature_;

      public SignatureCase getSignatureCase() {
        return SignatureCase.forNumber(signatureCase_);
      }

      public Builder clearSignature() {
        signatureCase_ = 0;
        signature_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Builder,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                  .MemoryHashSignatureOrBuilder>
          memoryHashSignatureBuilder_;
      /**
       *
       *
       * <pre>
       * Signature indicating that a binary family was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
       * </code>
       *
       * @return Whether the memoryHashSignature field is set.
       */
      @java.lang.Override
      public boolean hasMemoryHashSignature() {
        return signatureCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a binary family was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
       * </code>
       *
       * @return The memoryHashSignature.
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
          getMemoryHashSignature() {
        if (memoryHashSignatureBuilder_ == null) {
          if (signatureCase_ == 6) {
            return (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                    .MemoryHashSignature)
                signature_;
          }
          return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
              .getDefaultInstance();
        } else {
          if (signatureCase_ == 6) {
            return memoryHashSignatureBuilder_.getMessage();
          }
          return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a binary family was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
       * </code>
       */
      public Builder setMemoryHashSignature(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature value) {
        if (memoryHashSignatureBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          signature_ = value;
          onChanged();
        } else {
          memoryHashSignatureBuilder_.setMessage(value);
        }
        signatureCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a binary family was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
       * </code>
       */
      public Builder setMemoryHashSignature(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature.Builder
              builderForValue) {
        if (memoryHashSignatureBuilder_ == null) {
          signature_ = builderForValue.build();
          onChanged();
        } else {
          memoryHashSignatureBuilder_.setMessage(builderForValue.build());
        }
        signatureCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a binary family was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
       * </code>
       */
      public Builder mergeMemoryHashSignature(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature value) {
        if (memoryHashSignatureBuilder_ == null) {
          if (signatureCase_ == 6
              && signature_
                  != com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                      .MemoryHashSignature.getDefaultInstance()) {
            signature_ =
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .newBuilder(
                        (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                                .MemoryHashSignature)
                            signature_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            signature_ = value;
          }
          onChanged();
        } else {
          if (signatureCase_ == 6) {
            memoryHashSignatureBuilder_.mergeFrom(value);
          } else {
            memoryHashSignatureBuilder_.setMessage(value);
          }
        }
        signatureCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a binary family was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
       * </code>
       */
      public Builder clearMemoryHashSignature() {
        if (memoryHashSignatureBuilder_ == null) {
          if (signatureCase_ == 6) {
            signatureCase_ = 0;
            signature_ = null;
            onChanged();
          }
        } else {
          if (signatureCase_ == 6) {
            signatureCase_ = 0;
            signature_ = null;
          }
          memoryHashSignatureBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a binary family was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
       * </code>
       */
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
              .Builder
          getMemoryHashSignatureBuilder() {
        return getMemoryHashSignatureFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a binary family was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .MemoryHashSignatureOrBuilder
          getMemoryHashSignatureOrBuilder() {
        if ((signatureCase_ == 6) && (memoryHashSignatureBuilder_ != null)) {
          return memoryHashSignatureBuilder_.getMessageOrBuilder();
        } else {
          if (signatureCase_ == 6) {
            return (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                    .MemoryHashSignature)
                signature_;
          }
          return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a binary family was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature memory_hash_signature = 6;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                  .Builder,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                  .MemoryHashSignatureOrBuilder>
          getMemoryHashSignatureFieldBuilder() {
        if (memoryHashSignatureBuilder_ == null) {
          if (!(signatureCase_ == 6)) {
            signature_ =
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                    .getDefaultInstance();
          }
          memoryHashSignatureBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature,
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.MemoryHashSignature
                      .Builder,
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                      .MemoryHashSignatureOrBuilder>(
                  (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                          .MemoryHashSignature)
                      signature_,
                  getParentForChildren(),
                  isClean());
          signature_ = null;
        }
        signatureCase_ = 6;
        onChanged();
        return memoryHashSignatureBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                  .Builder,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                  .YaraRuleSignatureOrBuilder>
          yaraRuleSignatureBuilder_;
      /**
       *
       *
       * <pre>
       * Signature indicating that a YARA rule was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
       * </code>
       *
       * @return Whether the yaraRuleSignature field is set.
       */
      @java.lang.Override
      public boolean hasYaraRuleSignature() {
        return signatureCase_ == 7;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a YARA rule was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
       * </code>
       *
       * @return The yaraRuleSignature.
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
          getYaraRuleSignature() {
        if (yaraRuleSignatureBuilder_ == null) {
          if (signatureCase_ == 7) {
            return (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
                signature_;
          }
          return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
              .getDefaultInstance();
        } else {
          if (signatureCase_ == 7) {
            return yaraRuleSignatureBuilder_.getMessage();
          }
          return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a YARA rule was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
       * </code>
       */
      public Builder setYaraRuleSignature(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature value) {
        if (yaraRuleSignatureBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          signature_ = value;
          onChanged();
        } else {
          yaraRuleSignatureBuilder_.setMessage(value);
        }
        signatureCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a YARA rule was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
       * </code>
       */
      public Builder setYaraRuleSignature(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature.Builder
              builderForValue) {
        if (yaraRuleSignatureBuilder_ == null) {
          signature_ = builderForValue.build();
          onChanged();
        } else {
          yaraRuleSignatureBuilder_.setMessage(builderForValue.build());
        }
        signatureCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a YARA rule was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
       * </code>
       */
      public Builder mergeYaraRuleSignature(
          com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature value) {
        if (yaraRuleSignatureBuilder_ == null) {
          if (signatureCase_ == 7
              && signature_
                  != com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                      .getDefaultInstance()) {
            signature_ =
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                    .newBuilder(
                        (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                                .YaraRuleSignature)
                            signature_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            signature_ = value;
          }
          onChanged();
        } else {
          if (signatureCase_ == 7) {
            yaraRuleSignatureBuilder_.mergeFrom(value);
          } else {
            yaraRuleSignatureBuilder_.setMessage(value);
          }
        }
        signatureCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a YARA rule was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
       * </code>
       */
      public Builder clearYaraRuleSignature() {
        if (yaraRuleSignatureBuilder_ == null) {
          if (signatureCase_ == 7) {
            signatureCase_ = 0;
            signature_ = null;
            onChanged();
          }
        } else {
          if (signatureCase_ == 7) {
            signatureCase_ = 0;
            signature_ = null;
          }
          yaraRuleSignatureBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a YARA rule was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
       * </code>
       */
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature.Builder
          getYaraRuleSignatureBuilder() {
        return getYaraRuleSignatureFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a YARA rule was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
              .YaraRuleSignatureOrBuilder
          getYaraRuleSignatureOrBuilder() {
        if ((signatureCase_ == 7) && (yaraRuleSignatureBuilder_ != null)) {
          return yaraRuleSignatureBuilder_.getMessageOrBuilder();
        } else {
          if (signatureCase_ == 7) {
            return (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
                signature_;
          }
          return com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Signature indicating that a YARA rule was matched.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature yara_rule_signature = 7;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                  .Builder,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                  .YaraRuleSignatureOrBuilder>
          getYaraRuleSignatureFieldBuilder() {
        if (yaraRuleSignatureBuilder_ == null) {
          if (!(signatureCase_ == 7)) {
            signature_ =
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                    .getDefaultInstance();
          }
          yaraRuleSignatureBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature,
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature
                      .Builder,
                  com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
                      .YaraRuleSignatureOrBuilder>(
                  (com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.YaraRuleSignature)
                      signature_,
                  getParentForChildren(),
                  isClean());
          signature_ = null;
        }
        signatureCase_ = 7;
        onChanged();
        return yaraRuleSignatureBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Indicator.ProcessSignature)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Indicator.ProcessSignature)
    private static final com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Indicator.ProcessSignature();
    }

    public static com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ProcessSignature> PARSER =
        new com.google.protobuf.AbstractParser<ProcessSignature>() {
          @java.lang.Override
          public ProcessSignature parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ProcessSignature> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ProcessSignature> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int IP_ADDRESSES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ipAddresses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of IP addresses that are associated with the finding.
   * </pre>
   *
   * <code>repeated string ip_addresses = 1;</code>
   *
   * @return A list containing the ipAddresses.
   */
  public com.google.protobuf.ProtocolStringList getIpAddressesList() {
    return ipAddresses_;
  }
  /**
   *
   *
   * <pre>
   * The list of IP addresses that are associated with the finding.
   * </pre>
   *
   * <code>repeated string ip_addresses = 1;</code>
   *
   * @return The count of ipAddresses.
   */
  public int getIpAddressesCount() {
    return ipAddresses_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of IP addresses that are associated with the finding.
   * </pre>
   *
   * <code>repeated string ip_addresses = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The ipAddresses at the given index.
   */
  public java.lang.String getIpAddresses(int index) {
    return ipAddresses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of IP addresses that are associated with the finding.
   * </pre>
   *
   * <code>repeated string ip_addresses = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ipAddresses at the given index.
   */
  public com.google.protobuf.ByteString getIpAddressesBytes(int index) {
    return ipAddresses_.getByteString(index);
  }

  public static final int DOMAINS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList domains_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of domains associated to the Finding.
   * </pre>
   *
   * <code>repeated string domains = 2;</code>
   *
   * @return A list containing the domains.
   */
  public com.google.protobuf.ProtocolStringList getDomainsList() {
    return domains_;
  }
  /**
   *
   *
   * <pre>
   * List of domains associated to the Finding.
   * </pre>
   *
   * <code>repeated string domains = 2;</code>
   *
   * @return The count of domains.
   */
  public int getDomainsCount() {
    return domains_.size();
  }
  /**
   *
   *
   * <pre>
   * List of domains associated to the Finding.
   * </pre>
   *
   * <code>repeated string domains = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The domains at the given index.
   */
  public java.lang.String getDomains(int index) {
    return domains_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of domains associated to the Finding.
   * </pre>
   *
   * <code>repeated string domains = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the domains at the given index.
   */
  public com.google.protobuf.ByteString getDomainsBytes(int index) {
    return domains_.getByteString(index);
  }

  public static final int SIGNATURES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Indicator.ProcessSignature> signatures_;
  /**
   *
   *
   * <pre>
   * The list of matched signatures indicating that the given
   * process is present in the environment.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Indicator.ProcessSignature>
      getSignaturesList() {
    return signatures_;
  }
  /**
   *
   *
   * <pre>
   * The list of matched signatures indicating that the given
   * process is present in the environment.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.securitycenter.v1.Indicator.ProcessSignatureOrBuilder>
      getSignaturesOrBuilderList() {
    return signatures_;
  }
  /**
   *
   *
   * <pre>
   * The list of matched signatures indicating that the given
   * process is present in the environment.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
   * </code>
   */
  @java.lang.Override
  public int getSignaturesCount() {
    return signatures_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of matched signatures indicating that the given
   * process is present in the environment.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature getSignatures(int index) {
    return signatures_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of matched signatures indicating that the given
   * process is present in the environment.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Indicator.ProcessSignatureOrBuilder
      getSignaturesOrBuilder(int index) {
    return signatures_.get(index);
  }

  public static final int URIS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList uris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of URIs associated to the Findings.
   * </pre>
   *
   * <code>repeated string uris = 4;</code>
   *
   * @return A list containing the uris.
   */
  public com.google.protobuf.ProtocolStringList getUrisList() {
    return uris_;
  }
  /**
   *
   *
   * <pre>
   * The list of URIs associated to the Findings.
   * </pre>
   *
   * <code>repeated string uris = 4;</code>
   *
   * @return The count of uris.
   */
  public int getUrisCount() {
    return uris_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of URIs associated to the Findings.
   * </pre>
   *
   * <code>repeated string uris = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The uris at the given index.
   */
  public java.lang.String getUris(int index) {
    return uris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of URIs associated to the Findings.
   * </pre>
   *
   * <code>repeated string uris = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the uris at the given index.
   */
  public com.google.protobuf.ByteString getUrisBytes(int index) {
    return uris_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < ipAddresses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ipAddresses_.getRaw(i));
    }
    for (int i = 0; i < domains_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, domains_.getRaw(i));
    }
    for (int i = 0; i < signatures_.size(); i++) {
      output.writeMessage(3, signatures_.get(i));
    }
    for (int i = 0; i < uris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, uris_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < ipAddresses_.size(); i++) {
        dataSize += computeStringSizeNoTag(ipAddresses_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIpAddressesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < domains_.size(); i++) {
        dataSize += computeStringSizeNoTag(domains_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDomainsList().size();
    }
    for (int i = 0; i < signatures_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, signatures_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < uris_.size(); i++) {
        dataSize += computeStringSizeNoTag(uris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUrisList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Indicator)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Indicator other =
        (com.google.cloud.securitycenter.v1.Indicator) obj;

    if (!getIpAddressesList().equals(other.getIpAddressesList())) return false;
    if (!getDomainsList().equals(other.getDomainsList())) return false;
    if (!getSignaturesList().equals(other.getSignaturesList())) return false;
    if (!getUrisList().equals(other.getUrisList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getIpAddressesCount() > 0) {
      hash = (37 * hash) + IP_ADDRESSES_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddressesList().hashCode();
    }
    if (getDomainsCount() > 0) {
      hash = (37 * hash) + DOMAINS_FIELD_NUMBER;
      hash = (53 * hash) + getDomainsList().hashCode();
    }
    if (getSignaturesCount() > 0) {
      hash = (37 * hash) + SIGNATURES_FIELD_NUMBER;
      hash = (53 * hash) + getSignaturesList().hashCode();
    }
    if (getUrisCount() > 0) {
      hash = (37 * hash) + URIS_FIELD_NUMBER;
      hash = (53 * hash) + getUrisList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Indicator parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Indicator prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents what's commonly known as an _indicator of compromise_ (IoC) in
   * computer forensics. This is an artifact observed on a network or in an
   * operating system that, with high confidence, indicates a computer intrusion.
   * For more information, see [Indicator of
   * compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Indicator}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Indicator)
      com.google.cloud.securitycenter.v1.IndicatorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.IndicatorProto
          .internal_static_google_cloud_securitycenter_v1_Indicator_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.IndicatorProto
          .internal_static_google_cloud_securitycenter_v1_Indicator_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Indicator.class,
              com.google.cloud.securitycenter.v1.Indicator.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Indicator.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      ipAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      domains_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (signaturesBuilder_ == null) {
        signatures_ = java.util.Collections.emptyList();
      } else {
        signatures_ = null;
        signaturesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.IndicatorProto
          .internal_static_google_cloud_securitycenter_v1_Indicator_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Indicator getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Indicator.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Indicator build() {
      com.google.cloud.securitycenter.v1.Indicator result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Indicator buildPartial() {
      com.google.cloud.securitycenter.v1.Indicator result =
          new com.google.cloud.securitycenter.v1.Indicator(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.securitycenter.v1.Indicator result) {
      if (signaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          signatures_ = java.util.Collections.unmodifiableList(signatures_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.signatures_ = signatures_;
      } else {
        result.signatures_ = signaturesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Indicator result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        ipAddresses_.makeImmutable();
        result.ipAddresses_ = ipAddresses_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        domains_.makeImmutable();
        result.domains_ = domains_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        uris_.makeImmutable();
        result.uris_ = uris_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Indicator) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Indicator) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Indicator other) {
      if (other == com.google.cloud.securitycenter.v1.Indicator.getDefaultInstance()) return this;
      if (!other.ipAddresses_.isEmpty()) {
        if (ipAddresses_.isEmpty()) {
          ipAddresses_ = other.ipAddresses_;
          bitField0_ |= 0x00000001;
        } else {
          ensureIpAddressesIsMutable();
          ipAddresses_.addAll(other.ipAddresses_);
        }
        onChanged();
      }
      if (!other.domains_.isEmpty()) {
        if (domains_.isEmpty()) {
          domains_ = other.domains_;
          bitField0_ |= 0x00000002;
        } else {
          ensureDomainsIsMutable();
          domains_.addAll(other.domains_);
        }
        onChanged();
      }
      if (signaturesBuilder_ == null) {
        if (!other.signatures_.isEmpty()) {
          if (signatures_.isEmpty()) {
            signatures_ = other.signatures_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSignaturesIsMutable();
            signatures_.addAll(other.signatures_);
          }
          onChanged();
        }
      } else {
        if (!other.signatures_.isEmpty()) {
          if (signaturesBuilder_.isEmpty()) {
            signaturesBuilder_.dispose();
            signaturesBuilder_ = null;
            signatures_ = other.signatures_;
            bitField0_ = (bitField0_ & ~0x00000004);
            signaturesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSignaturesFieldBuilder()
                    : null;
          } else {
            signaturesBuilder_.addAllMessages(other.signatures_);
          }
        }
      }
      if (!other.uris_.isEmpty()) {
        if (uris_.isEmpty()) {
          uris_ = other.uris_;
          bitField0_ |= 0x00000008;
        } else {
          ensureUrisIsMutable();
          uris_.addAll(other.uris_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIpAddressesIsMutable();
                ipAddresses_.add(s);
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDomainsIsMutable();
                domains_.add(s);
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.parser(),
                        extensionRegistry);
                if (signaturesBuilder_ == null) {
                  ensureSignaturesIsMutable();
                  signatures_.add(m);
                } else {
                  signaturesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUrisIsMutable();
                uris_.add(s);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList ipAddresses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIpAddressesIsMutable() {
      if (!ipAddresses_.isModifiable()) {
        ipAddresses_ = new com.google.protobuf.LazyStringArrayList(ipAddresses_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * The list of IP addresses that are associated with the finding.
     * </pre>
     *
     * <code>repeated string ip_addresses = 1;</code>
     *
     * @return A list containing the ipAddresses.
     */
    public com.google.protobuf.ProtocolStringList getIpAddressesList() {
      ipAddresses_.makeImmutable();
      return ipAddresses_;
    }
    /**
     *
     *
     * <pre>
     * The list of IP addresses that are associated with the finding.
     * </pre>
     *
     * <code>repeated string ip_addresses = 1;</code>
     *
     * @return The count of ipAddresses.
     */
    public int getIpAddressesCount() {
      return ipAddresses_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of IP addresses that are associated with the finding.
     * </pre>
     *
     * <code>repeated string ip_addresses = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The ipAddresses at the given index.
     */
    public java.lang.String getIpAddresses(int index) {
      return ipAddresses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of IP addresses that are associated with the finding.
     * </pre>
     *
     * <code>repeated string ip_addresses = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ipAddresses at the given index.
     */
    public com.google.protobuf.ByteString getIpAddressesBytes(int index) {
      return ipAddresses_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of IP addresses that are associated with the finding.
     * </pre>
     *
     * <code>repeated string ip_addresses = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The ipAddresses to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddresses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpAddressesIsMutable();
      ipAddresses_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of IP addresses that are associated with the finding.
     * </pre>
     *
     * <code>repeated string ip_addresses = 1;</code>
     *
     * @param value The ipAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addIpAddresses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpAddressesIsMutable();
      ipAddresses_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of IP addresses that are associated with the finding.
     * </pre>
     *
     * <code>repeated string ip_addresses = 1;</code>
     *
     * @param values The ipAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addAllIpAddresses(java.lang.Iterable<java.lang.String> values) {
      ensureIpAddressesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipAddresses_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of IP addresses that are associated with the finding.
     * </pre>
     *
     * <code>repeated string ip_addresses = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddresses() {
      ipAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of IP addresses that are associated with the finding.
     * </pre>
     *
     * <code>repeated string ip_addresses = 1;</code>
     *
     * @param value The bytes of the ipAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addIpAddressesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIpAddressesIsMutable();
      ipAddresses_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList domains_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDomainsIsMutable() {
      if (!domains_.isModifiable()) {
        domains_ = new com.google.protobuf.LazyStringArrayList(domains_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * List of domains associated to the Finding.
     * </pre>
     *
     * <code>repeated string domains = 2;</code>
     *
     * @return A list containing the domains.
     */
    public com.google.protobuf.ProtocolStringList getDomainsList() {
      domains_.makeImmutable();
      return domains_;
    }
    /**
     *
     *
     * <pre>
     * List of domains associated to the Finding.
     * </pre>
     *
     * <code>repeated string domains = 2;</code>
     *
     * @return The count of domains.
     */
    public int getDomainsCount() {
      return domains_.size();
    }
    /**
     *
     *
     * <pre>
     * List of domains associated to the Finding.
     * </pre>
     *
     * <code>repeated string domains = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The domains at the given index.
     */
    public java.lang.String getDomains(int index) {
      return domains_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of domains associated to the Finding.
     * </pre>
     *
     * <code>repeated string domains = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the domains at the given index.
     */
    public com.google.protobuf.ByteString getDomainsBytes(int index) {
      return domains_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of domains associated to the Finding.
     * </pre>
     *
     * <code>repeated string domains = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The domains to set.
     * @return This builder for chaining.
     */
    public Builder setDomains(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainsIsMutable();
      domains_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of domains associated to the Finding.
     * </pre>
     *
     * <code>repeated string domains = 2;</code>
     *
     * @param value The domains to add.
     * @return This builder for chaining.
     */
    public Builder addDomains(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainsIsMutable();
      domains_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of domains associated to the Finding.
     * </pre>
     *
     * <code>repeated string domains = 2;</code>
     *
     * @param values The domains to add.
     * @return This builder for chaining.
     */
    public Builder addAllDomains(java.lang.Iterable<java.lang.String> values) {
      ensureDomainsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, domains_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of domains associated to the Finding.
     * </pre>
     *
     * <code>repeated string domains = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomains() {
      domains_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of domains associated to the Finding.
     * </pre>
     *
     * <code>repeated string domains = 2;</code>
     *
     * @param value The bytes of the domains to add.
     * @return This builder for chaining.
     */
    public Builder addDomainsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDomainsIsMutable();
      domains_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Indicator.ProcessSignature>
        signatures_ = java.util.Collections.emptyList();

    private void ensureSignaturesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        signatures_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Indicator.ProcessSignature>(
                signatures_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature,
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder,
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignatureOrBuilder>
        signaturesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Indicator.ProcessSignature>
        getSignaturesList() {
      if (signaturesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(signatures_);
      } else {
        return signaturesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public int getSignaturesCount() {
      if (signaturesBuilder_ == null) {
        return signatures_.size();
      } else {
        return signaturesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature getSignatures(int index) {
      if (signaturesBuilder_ == null) {
        return signatures_.get(index);
      } else {
        return signaturesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public Builder setSignatures(
        int index, com.google.cloud.securitycenter.v1.Indicator.ProcessSignature value) {
      if (signaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSignaturesIsMutable();
        signatures_.set(index, value);
        onChanged();
      } else {
        signaturesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public Builder setSignatures(
        int index,
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder builderForValue) {
      if (signaturesBuilder_ == null) {
        ensureSignaturesIsMutable();
        signatures_.set(index, builderForValue.build());
        onChanged();
      } else {
        signaturesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public Builder addSignatures(
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature value) {
      if (signaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSignaturesIsMutable();
        signatures_.add(value);
        onChanged();
      } else {
        signaturesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public Builder addSignatures(
        int index, com.google.cloud.securitycenter.v1.Indicator.ProcessSignature value) {
      if (signaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSignaturesIsMutable();
        signatures_.add(index, value);
        onChanged();
      } else {
        signaturesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public Builder addSignatures(
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder builderForValue) {
      if (signaturesBuilder_ == null) {
        ensureSignaturesIsMutable();
        signatures_.add(builderForValue.build());
        onChanged();
      } else {
        signaturesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public Builder addSignatures(
        int index,
        com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder builderForValue) {
      if (signaturesBuilder_ == null) {
        ensureSignaturesIsMutable();
        signatures_.add(index, builderForValue.build());
        onChanged();
      } else {
        signaturesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public Builder addAllSignatures(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Indicator.ProcessSignature>
            values) {
      if (signaturesBuilder_ == null) {
        ensureSignaturesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, signatures_);
        onChanged();
      } else {
        signaturesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public Builder clearSignatures() {
      if (signaturesBuilder_ == null) {
        signatures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        signaturesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public Builder removeSignatures(int index) {
      if (signaturesBuilder_ == null) {
        ensureSignaturesIsMutable();
        signatures_.remove(index);
        onChanged();
      } else {
        signaturesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder
        getSignaturesBuilder(int index) {
      return getSignaturesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignatureOrBuilder
        getSignaturesOrBuilder(int index) {
      if (signaturesBuilder_ == null) {
        return signatures_.get(index);
      } else {
        return signaturesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.securitycenter.v1.Indicator.ProcessSignatureOrBuilder>
        getSignaturesOrBuilderList() {
      if (signaturesBuilder_ != null) {
        return signaturesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(signatures_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder
        addSignaturesBuilder() {
      return getSignaturesFieldBuilder()
          .addBuilder(
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder
        addSignaturesBuilder(int index) {
      return getSignaturesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of matched signatures indicating that the given
     * process is present in the environment.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Indicator.ProcessSignature signatures = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder>
        getSignaturesBuilderList() {
      return getSignaturesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature,
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder,
            com.google.cloud.securitycenter.v1.Indicator.ProcessSignatureOrBuilder>
        getSignaturesFieldBuilder() {
      if (signaturesBuilder_ == null) {
        signaturesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature,
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignature.Builder,
                com.google.cloud.securitycenter.v1.Indicator.ProcessSignatureOrBuilder>(
                signatures_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        signatures_ = null;
      }
      return signaturesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList uris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUrisIsMutable() {
      if (!uris_.isModifiable()) {
        uris_ = new com.google.protobuf.LazyStringArrayList(uris_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The list of URIs associated to the Findings.
     * </pre>
     *
     * <code>repeated string uris = 4;</code>
     *
     * @return A list containing the uris.
     */
    public com.google.protobuf.ProtocolStringList getUrisList() {
      uris_.makeImmutable();
      return uris_;
    }
    /**
     *
     *
     * <pre>
     * The list of URIs associated to the Findings.
     * </pre>
     *
     * <code>repeated string uris = 4;</code>
     *
     * @return The count of uris.
     */
    public int getUrisCount() {
      return uris_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of URIs associated to the Findings.
     * </pre>
     *
     * <code>repeated string uris = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The uris at the given index.
     */
    public java.lang.String getUris(int index) {
      return uris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of URIs associated to the Findings.
     * </pre>
     *
     * <code>repeated string uris = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the uris at the given index.
     */
    public com.google.protobuf.ByteString getUrisBytes(int index) {
      return uris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of URIs associated to the Findings.
     * </pre>
     *
     * <code>repeated string uris = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The uris to set.
     * @return This builder for chaining.
     */
    public Builder setUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUrisIsMutable();
      uris_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URIs associated to the Findings.
     * </pre>
     *
     * <code>repeated string uris = 4;</code>
     *
     * @param value The uris to add.
     * @return This builder for chaining.
     */
    public Builder addUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUrisIsMutable();
      uris_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URIs associated to the Findings.
     * </pre>
     *
     * <code>repeated string uris = 4;</code>
     *
     * @param values The uris to add.
     * @return This builder for chaining.
     */
    public Builder addAllUris(java.lang.Iterable<java.lang.String> values) {
      ensureUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, uris_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URIs associated to the Findings.
     * </pre>
     *
     * <code>repeated string uris = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUris() {
      uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URIs associated to the Findings.
     * </pre>
     *
     * <code>repeated string uris = 4;</code>
     *
     * @param value The bytes of the uris to add.
     * @return This builder for chaining.
     */
    public Builder addUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUrisIsMutable();
      uris_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Indicator)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Indicator)
  private static final com.google.cloud.securitycenter.v1.Indicator DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Indicator();
  }

  public static com.google.cloud.securitycenter.v1.Indicator getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Indicator> PARSER =
      new com.google.protobuf.AbstractParser<Indicator>() {
        @java.lang.Override
        public Indicator parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Indicator> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Indicator> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Indicator getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
