/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/kernel_rootkit.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Kernel mode rootkit signatures.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.KernelRootkit}
 */
public final class KernelRootkit extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.KernelRootkit)
    KernelRootkitOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KernelRootkit.newBuilder() to construct.
  private KernelRootkit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KernelRootkit() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KernelRootkit();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.KernelRootkitProto
        .internal_static_google_cloud_securitycenter_v1_KernelRootkit_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.KernelRootkitProto
        .internal_static_google_cloud_securitycenter_v1_KernelRootkit_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.KernelRootkit.class,
            com.google.cloud.securitycenter.v1.KernelRootkit.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Rootkit name, when available.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Rootkit name, when available.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNEXPECTED_CODE_MODIFICATION_FIELD_NUMBER = 2;
  private boolean unexpectedCodeModification_ = false;
  /**
   *
   *
   * <pre>
   * True if unexpected modifications of kernel code memory are present.
   * </pre>
   *
   * <code>bool unexpected_code_modification = 2;</code>
   *
   * @return The unexpectedCodeModification.
   */
  @java.lang.Override
  public boolean getUnexpectedCodeModification() {
    return unexpectedCodeModification_;
  }

  public static final int UNEXPECTED_READ_ONLY_DATA_MODIFICATION_FIELD_NUMBER = 3;
  private boolean unexpectedReadOnlyDataModification_ = false;
  /**
   *
   *
   * <pre>
   * True if unexpected modifications of kernel read-only data memory are
   * present.
   * </pre>
   *
   * <code>bool unexpected_read_only_data_modification = 3;</code>
   *
   * @return The unexpectedReadOnlyDataModification.
   */
  @java.lang.Override
  public boolean getUnexpectedReadOnlyDataModification() {
    return unexpectedReadOnlyDataModification_;
  }

  public static final int UNEXPECTED_FTRACE_HANDLER_FIELD_NUMBER = 4;
  private boolean unexpectedFtraceHandler_ = false;
  /**
   *
   *
   * <pre>
   * True if `ftrace` points are present with callbacks pointing to regions
   * that are not in the expected kernel or module code range.
   * </pre>
   *
   * <code>bool unexpected_ftrace_handler = 4;</code>
   *
   * @return The unexpectedFtraceHandler.
   */
  @java.lang.Override
  public boolean getUnexpectedFtraceHandler() {
    return unexpectedFtraceHandler_;
  }

  public static final int UNEXPECTED_KPROBE_HANDLER_FIELD_NUMBER = 5;
  private boolean unexpectedKprobeHandler_ = false;
  /**
   *
   *
   * <pre>
   * True if `kprobe` points are present with callbacks pointing to regions
   * that are not in the expected kernel or module code range.
   * </pre>
   *
   * <code>bool unexpected_kprobe_handler = 5;</code>
   *
   * @return The unexpectedKprobeHandler.
   */
  @java.lang.Override
  public boolean getUnexpectedKprobeHandler() {
    return unexpectedKprobeHandler_;
  }

  public static final int UNEXPECTED_KERNEL_CODE_PAGES_FIELD_NUMBER = 6;
  private boolean unexpectedKernelCodePages_ = false;
  /**
   *
   *
   * <pre>
   * True if kernel code pages that are not in the expected kernel or module
   * code regions are present.
   * </pre>
   *
   * <code>bool unexpected_kernel_code_pages = 6;</code>
   *
   * @return The unexpectedKernelCodePages.
   */
  @java.lang.Override
  public boolean getUnexpectedKernelCodePages() {
    return unexpectedKernelCodePages_;
  }

  public static final int UNEXPECTED_SYSTEM_CALL_HANDLER_FIELD_NUMBER = 7;
  private boolean unexpectedSystemCallHandler_ = false;
  /**
   *
   *
   * <pre>
   * True if system call handlers that are are not in the expected kernel or
   * module code regions are present.
   * </pre>
   *
   * <code>bool unexpected_system_call_handler = 7;</code>
   *
   * @return The unexpectedSystemCallHandler.
   */
  @java.lang.Override
  public boolean getUnexpectedSystemCallHandler() {
    return unexpectedSystemCallHandler_;
  }

  public static final int UNEXPECTED_INTERRUPT_HANDLER_FIELD_NUMBER = 8;
  private boolean unexpectedInterruptHandler_ = false;
  /**
   *
   *
   * <pre>
   * True if interrupt handlers that are are not in the expected kernel or
   * module code regions are present.
   * </pre>
   *
   * <code>bool unexpected_interrupt_handler = 8;</code>
   *
   * @return The unexpectedInterruptHandler.
   */
  @java.lang.Override
  public boolean getUnexpectedInterruptHandler() {
    return unexpectedInterruptHandler_;
  }

  public static final int UNEXPECTED_PROCESSES_IN_RUNQUEUE_FIELD_NUMBER = 9;
  private boolean unexpectedProcessesInRunqueue_ = false;
  /**
   *
   *
   * <pre>
   * True if unexpected processes in the scheduler run queue are present. Such
   * processes are in the run queue, but not in the process task list.
   * </pre>
   *
   * <code>bool unexpected_processes_in_runqueue = 9;</code>
   *
   * @return The unexpectedProcessesInRunqueue.
   */
  @java.lang.Override
  public boolean getUnexpectedProcessesInRunqueue() {
    return unexpectedProcessesInRunqueue_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (unexpectedCodeModification_ != false) {
      output.writeBool(2, unexpectedCodeModification_);
    }
    if (unexpectedReadOnlyDataModification_ != false) {
      output.writeBool(3, unexpectedReadOnlyDataModification_);
    }
    if (unexpectedFtraceHandler_ != false) {
      output.writeBool(4, unexpectedFtraceHandler_);
    }
    if (unexpectedKprobeHandler_ != false) {
      output.writeBool(5, unexpectedKprobeHandler_);
    }
    if (unexpectedKernelCodePages_ != false) {
      output.writeBool(6, unexpectedKernelCodePages_);
    }
    if (unexpectedSystemCallHandler_ != false) {
      output.writeBool(7, unexpectedSystemCallHandler_);
    }
    if (unexpectedInterruptHandler_ != false) {
      output.writeBool(8, unexpectedInterruptHandler_);
    }
    if (unexpectedProcessesInRunqueue_ != false) {
      output.writeBool(9, unexpectedProcessesInRunqueue_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (unexpectedCodeModification_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, unexpectedCodeModification_);
    }
    if (unexpectedReadOnlyDataModification_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              3, unexpectedReadOnlyDataModification_);
    }
    if (unexpectedFtraceHandler_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, unexpectedFtraceHandler_);
    }
    if (unexpectedKprobeHandler_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, unexpectedKprobeHandler_);
    }
    if (unexpectedKernelCodePages_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, unexpectedKernelCodePages_);
    }
    if (unexpectedSystemCallHandler_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(7, unexpectedSystemCallHandler_);
    }
    if (unexpectedInterruptHandler_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, unexpectedInterruptHandler_);
    }
    if (unexpectedProcessesInRunqueue_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(9, unexpectedProcessesInRunqueue_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.KernelRootkit)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.KernelRootkit other =
        (com.google.cloud.securitycenter.v1.KernelRootkit) obj;

    if (!getName().equals(other.getName())) return false;
    if (getUnexpectedCodeModification() != other.getUnexpectedCodeModification()) return false;
    if (getUnexpectedReadOnlyDataModification() != other.getUnexpectedReadOnlyDataModification())
      return false;
    if (getUnexpectedFtraceHandler() != other.getUnexpectedFtraceHandler()) return false;
    if (getUnexpectedKprobeHandler() != other.getUnexpectedKprobeHandler()) return false;
    if (getUnexpectedKernelCodePages() != other.getUnexpectedKernelCodePages()) return false;
    if (getUnexpectedSystemCallHandler() != other.getUnexpectedSystemCallHandler()) return false;
    if (getUnexpectedInterruptHandler() != other.getUnexpectedInterruptHandler()) return false;
    if (getUnexpectedProcessesInRunqueue() != other.getUnexpectedProcessesInRunqueue())
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UNEXPECTED_CODE_MODIFICATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnexpectedCodeModification());
    hash = (37 * hash) + UNEXPECTED_READ_ONLY_DATA_MODIFICATION_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(getUnexpectedReadOnlyDataModification());
    hash = (37 * hash) + UNEXPECTED_FTRACE_HANDLER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnexpectedFtraceHandler());
    hash = (37 * hash) + UNEXPECTED_KPROBE_HANDLER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnexpectedKprobeHandler());
    hash = (37 * hash) + UNEXPECTED_KERNEL_CODE_PAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnexpectedKernelCodePages());
    hash = (37 * hash) + UNEXPECTED_SYSTEM_CALL_HANDLER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnexpectedSystemCallHandler());
    hash = (37 * hash) + UNEXPECTED_INTERRUPT_HANDLER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnexpectedInterruptHandler());
    hash = (37 * hash) + UNEXPECTED_PROCESSES_IN_RUNQUEUE_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnexpectedProcessesInRunqueue());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.KernelRootkit prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Kernel mode rootkit signatures.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.KernelRootkit}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.KernelRootkit)
      com.google.cloud.securitycenter.v1.KernelRootkitOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KernelRootkitProto
          .internal_static_google_cloud_securitycenter_v1_KernelRootkit_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KernelRootkitProto
          .internal_static_google_cloud_securitycenter_v1_KernelRootkit_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.KernelRootkit.class,
              com.google.cloud.securitycenter.v1.KernelRootkit.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.KernelRootkit.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      unexpectedCodeModification_ = false;
      unexpectedReadOnlyDataModification_ = false;
      unexpectedFtraceHandler_ = false;
      unexpectedKprobeHandler_ = false;
      unexpectedKernelCodePages_ = false;
      unexpectedSystemCallHandler_ = false;
      unexpectedInterruptHandler_ = false;
      unexpectedProcessesInRunqueue_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.KernelRootkitProto
          .internal_static_google_cloud_securitycenter_v1_KernelRootkit_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.KernelRootkit getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.KernelRootkit.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.KernelRootkit build() {
      com.google.cloud.securitycenter.v1.KernelRootkit result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.KernelRootkit buildPartial() {
      com.google.cloud.securitycenter.v1.KernelRootkit result =
          new com.google.cloud.securitycenter.v1.KernelRootkit(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.KernelRootkit result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.unexpectedCodeModification_ = unexpectedCodeModification_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.unexpectedReadOnlyDataModification_ = unexpectedReadOnlyDataModification_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.unexpectedFtraceHandler_ = unexpectedFtraceHandler_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.unexpectedKprobeHandler_ = unexpectedKprobeHandler_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.unexpectedKernelCodePages_ = unexpectedKernelCodePages_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.unexpectedSystemCallHandler_ = unexpectedSystemCallHandler_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.unexpectedInterruptHandler_ = unexpectedInterruptHandler_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.unexpectedProcessesInRunqueue_ = unexpectedProcessesInRunqueue_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.KernelRootkit) {
        return mergeFrom((com.google.cloud.securitycenter.v1.KernelRootkit) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.KernelRootkit other) {
      if (other == com.google.cloud.securitycenter.v1.KernelRootkit.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getUnexpectedCodeModification() != false) {
        setUnexpectedCodeModification(other.getUnexpectedCodeModification());
      }
      if (other.getUnexpectedReadOnlyDataModification() != false) {
        setUnexpectedReadOnlyDataModification(other.getUnexpectedReadOnlyDataModification());
      }
      if (other.getUnexpectedFtraceHandler() != false) {
        setUnexpectedFtraceHandler(other.getUnexpectedFtraceHandler());
      }
      if (other.getUnexpectedKprobeHandler() != false) {
        setUnexpectedKprobeHandler(other.getUnexpectedKprobeHandler());
      }
      if (other.getUnexpectedKernelCodePages() != false) {
        setUnexpectedKernelCodePages(other.getUnexpectedKernelCodePages());
      }
      if (other.getUnexpectedSystemCallHandler() != false) {
        setUnexpectedSystemCallHandler(other.getUnexpectedSystemCallHandler());
      }
      if (other.getUnexpectedInterruptHandler() != false) {
        setUnexpectedInterruptHandler(other.getUnexpectedInterruptHandler());
      }
      if (other.getUnexpectedProcessesInRunqueue() != false) {
        setUnexpectedProcessesInRunqueue(other.getUnexpectedProcessesInRunqueue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                unexpectedCodeModification_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                unexpectedReadOnlyDataModification_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                unexpectedFtraceHandler_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                unexpectedKprobeHandler_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                unexpectedKernelCodePages_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                unexpectedSystemCallHandler_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                unexpectedInterruptHandler_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                unexpectedProcessesInRunqueue_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Rootkit name, when available.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rootkit name, when available.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rootkit name, when available.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rootkit name, when available.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rootkit name, when available.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean unexpectedCodeModification_;
    /**
     *
     *
     * <pre>
     * True if unexpected modifications of kernel code memory are present.
     * </pre>
     *
     * <code>bool unexpected_code_modification = 2;</code>
     *
     * @return The unexpectedCodeModification.
     */
    @java.lang.Override
    public boolean getUnexpectedCodeModification() {
      return unexpectedCodeModification_;
    }
    /**
     *
     *
     * <pre>
     * True if unexpected modifications of kernel code memory are present.
     * </pre>
     *
     * <code>bool unexpected_code_modification = 2;</code>
     *
     * @param value The unexpectedCodeModification to set.
     * @return This builder for chaining.
     */
    public Builder setUnexpectedCodeModification(boolean value) {

      unexpectedCodeModification_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if unexpected modifications of kernel code memory are present.
     * </pre>
     *
     * <code>bool unexpected_code_modification = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnexpectedCodeModification() {
      bitField0_ = (bitField0_ & ~0x00000002);
      unexpectedCodeModification_ = false;
      onChanged();
      return this;
    }

    private boolean unexpectedReadOnlyDataModification_;
    /**
     *
     *
     * <pre>
     * True if unexpected modifications of kernel read-only data memory are
     * present.
     * </pre>
     *
     * <code>bool unexpected_read_only_data_modification = 3;</code>
     *
     * @return The unexpectedReadOnlyDataModification.
     */
    @java.lang.Override
    public boolean getUnexpectedReadOnlyDataModification() {
      return unexpectedReadOnlyDataModification_;
    }
    /**
     *
     *
     * <pre>
     * True if unexpected modifications of kernel read-only data memory are
     * present.
     * </pre>
     *
     * <code>bool unexpected_read_only_data_modification = 3;</code>
     *
     * @param value The unexpectedReadOnlyDataModification to set.
     * @return This builder for chaining.
     */
    public Builder setUnexpectedReadOnlyDataModification(boolean value) {

      unexpectedReadOnlyDataModification_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if unexpected modifications of kernel read-only data memory are
     * present.
     * </pre>
     *
     * <code>bool unexpected_read_only_data_modification = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnexpectedReadOnlyDataModification() {
      bitField0_ = (bitField0_ & ~0x00000004);
      unexpectedReadOnlyDataModification_ = false;
      onChanged();
      return this;
    }

    private boolean unexpectedFtraceHandler_;
    /**
     *
     *
     * <pre>
     * True if `ftrace` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     * </pre>
     *
     * <code>bool unexpected_ftrace_handler = 4;</code>
     *
     * @return The unexpectedFtraceHandler.
     */
    @java.lang.Override
    public boolean getUnexpectedFtraceHandler() {
      return unexpectedFtraceHandler_;
    }
    /**
     *
     *
     * <pre>
     * True if `ftrace` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     * </pre>
     *
     * <code>bool unexpected_ftrace_handler = 4;</code>
     *
     * @param value The unexpectedFtraceHandler to set.
     * @return This builder for chaining.
     */
    public Builder setUnexpectedFtraceHandler(boolean value) {

      unexpectedFtraceHandler_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if `ftrace` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     * </pre>
     *
     * <code>bool unexpected_ftrace_handler = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnexpectedFtraceHandler() {
      bitField0_ = (bitField0_ & ~0x00000008);
      unexpectedFtraceHandler_ = false;
      onChanged();
      return this;
    }

    private boolean unexpectedKprobeHandler_;
    /**
     *
     *
     * <pre>
     * True if `kprobe` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     * </pre>
     *
     * <code>bool unexpected_kprobe_handler = 5;</code>
     *
     * @return The unexpectedKprobeHandler.
     */
    @java.lang.Override
    public boolean getUnexpectedKprobeHandler() {
      return unexpectedKprobeHandler_;
    }
    /**
     *
     *
     * <pre>
     * True if `kprobe` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     * </pre>
     *
     * <code>bool unexpected_kprobe_handler = 5;</code>
     *
     * @param value The unexpectedKprobeHandler to set.
     * @return This builder for chaining.
     */
    public Builder setUnexpectedKprobeHandler(boolean value) {

      unexpectedKprobeHandler_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if `kprobe` points are present with callbacks pointing to regions
     * that are not in the expected kernel or module code range.
     * </pre>
     *
     * <code>bool unexpected_kprobe_handler = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnexpectedKprobeHandler() {
      bitField0_ = (bitField0_ & ~0x00000010);
      unexpectedKprobeHandler_ = false;
      onChanged();
      return this;
    }

    private boolean unexpectedKernelCodePages_;
    /**
     *
     *
     * <pre>
     * True if kernel code pages that are not in the expected kernel or module
     * code regions are present.
     * </pre>
     *
     * <code>bool unexpected_kernel_code_pages = 6;</code>
     *
     * @return The unexpectedKernelCodePages.
     */
    @java.lang.Override
    public boolean getUnexpectedKernelCodePages() {
      return unexpectedKernelCodePages_;
    }
    /**
     *
     *
     * <pre>
     * True if kernel code pages that are not in the expected kernel or module
     * code regions are present.
     * </pre>
     *
     * <code>bool unexpected_kernel_code_pages = 6;</code>
     *
     * @param value The unexpectedKernelCodePages to set.
     * @return This builder for chaining.
     */
    public Builder setUnexpectedKernelCodePages(boolean value) {

      unexpectedKernelCodePages_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if kernel code pages that are not in the expected kernel or module
     * code regions are present.
     * </pre>
     *
     * <code>bool unexpected_kernel_code_pages = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnexpectedKernelCodePages() {
      bitField0_ = (bitField0_ & ~0x00000020);
      unexpectedKernelCodePages_ = false;
      onChanged();
      return this;
    }

    private boolean unexpectedSystemCallHandler_;
    /**
     *
     *
     * <pre>
     * True if system call handlers that are are not in the expected kernel or
     * module code regions are present.
     * </pre>
     *
     * <code>bool unexpected_system_call_handler = 7;</code>
     *
     * @return The unexpectedSystemCallHandler.
     */
    @java.lang.Override
    public boolean getUnexpectedSystemCallHandler() {
      return unexpectedSystemCallHandler_;
    }
    /**
     *
     *
     * <pre>
     * True if system call handlers that are are not in the expected kernel or
     * module code regions are present.
     * </pre>
     *
     * <code>bool unexpected_system_call_handler = 7;</code>
     *
     * @param value The unexpectedSystemCallHandler to set.
     * @return This builder for chaining.
     */
    public Builder setUnexpectedSystemCallHandler(boolean value) {

      unexpectedSystemCallHandler_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if system call handlers that are are not in the expected kernel or
     * module code regions are present.
     * </pre>
     *
     * <code>bool unexpected_system_call_handler = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnexpectedSystemCallHandler() {
      bitField0_ = (bitField0_ & ~0x00000040);
      unexpectedSystemCallHandler_ = false;
      onChanged();
      return this;
    }

    private boolean unexpectedInterruptHandler_;
    /**
     *
     *
     * <pre>
     * True if interrupt handlers that are are not in the expected kernel or
     * module code regions are present.
     * </pre>
     *
     * <code>bool unexpected_interrupt_handler = 8;</code>
     *
     * @return The unexpectedInterruptHandler.
     */
    @java.lang.Override
    public boolean getUnexpectedInterruptHandler() {
      return unexpectedInterruptHandler_;
    }
    /**
     *
     *
     * <pre>
     * True if interrupt handlers that are are not in the expected kernel or
     * module code regions are present.
     * </pre>
     *
     * <code>bool unexpected_interrupt_handler = 8;</code>
     *
     * @param value The unexpectedInterruptHandler to set.
     * @return This builder for chaining.
     */
    public Builder setUnexpectedInterruptHandler(boolean value) {

      unexpectedInterruptHandler_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if interrupt handlers that are are not in the expected kernel or
     * module code regions are present.
     * </pre>
     *
     * <code>bool unexpected_interrupt_handler = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnexpectedInterruptHandler() {
      bitField0_ = (bitField0_ & ~0x00000080);
      unexpectedInterruptHandler_ = false;
      onChanged();
      return this;
    }

    private boolean unexpectedProcessesInRunqueue_;
    /**
     *
     *
     * <pre>
     * True if unexpected processes in the scheduler run queue are present. Such
     * processes are in the run queue, but not in the process task list.
     * </pre>
     *
     * <code>bool unexpected_processes_in_runqueue = 9;</code>
     *
     * @return The unexpectedProcessesInRunqueue.
     */
    @java.lang.Override
    public boolean getUnexpectedProcessesInRunqueue() {
      return unexpectedProcessesInRunqueue_;
    }
    /**
     *
     *
     * <pre>
     * True if unexpected processes in the scheduler run queue are present. Such
     * processes are in the run queue, but not in the process task list.
     * </pre>
     *
     * <code>bool unexpected_processes_in_runqueue = 9;</code>
     *
     * @param value The unexpectedProcessesInRunqueue to set.
     * @return This builder for chaining.
     */
    public Builder setUnexpectedProcessesInRunqueue(boolean value) {

      unexpectedProcessesInRunqueue_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if unexpected processes in the scheduler run queue are present. Such
     * processes are in the run queue, but not in the process task list.
     * </pre>
     *
     * <code>bool unexpected_processes_in_runqueue = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnexpectedProcessesInRunqueue() {
      bitField0_ = (bitField0_ & ~0x00000100);
      unexpectedProcessesInRunqueue_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.KernelRootkit)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.KernelRootkit)
  private static final com.google.cloud.securitycenter.v1.KernelRootkit DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.KernelRootkit();
  }

  public static com.google.cloud.securitycenter.v1.KernelRootkit getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KernelRootkit> PARSER =
      new com.google.protobuf.AbstractParser<KernelRootkit>() {
        @java.lang.Override
        public KernelRootkit parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KernelRootkit> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KernelRootkit> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.KernelRootkit getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
