/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/mitre_attack.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * MITRE ATT&amp;CK tactics and techniques related to this finding.
 * See: https://attack.mitre.org
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.MitreAttack}
 */
public final class MitreAttack extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.MitreAttack)
    MitreAttackOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MitreAttack.newBuilder() to construct.
  private MitreAttack(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MitreAttack() {
    primaryTactic_ = 0;
    primaryTechniques_ = java.util.Collections.emptyList();
    additionalTactics_ = java.util.Collections.emptyList();
    additionalTechniques_ = java.util.Collections.emptyList();
    version_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MitreAttack();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.MitreAttackProto
        .internal_static_google_cloud_securitycenter_v1_MitreAttack_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.MitreAttackProto
        .internal_static_google_cloud_securitycenter_v1_MitreAttack_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.MitreAttack.class,
            com.google.cloud.securitycenter.v1.MitreAttack.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * MITRE ATT&amp;CK tactics that can be referenced by SCC findings.
   * See: https://attack.mitre.org/tactics/enterprise/
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.MitreAttack.Tactic}
   */
  public enum Tactic implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified value.
     * </pre>
     *
     * <code>TACTIC_UNSPECIFIED = 0;</code>
     */
    TACTIC_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * TA0043
     * </pre>
     *
     * <code>RECONNAISSANCE = 1;</code>
     */
    RECONNAISSANCE(1),
    /**
     *
     *
     * <pre>
     * TA0042
     * </pre>
     *
     * <code>RESOURCE_DEVELOPMENT = 2;</code>
     */
    RESOURCE_DEVELOPMENT(2),
    /**
     *
     *
     * <pre>
     * TA0001
     * </pre>
     *
     * <code>INITIAL_ACCESS = 5;</code>
     */
    INITIAL_ACCESS(5),
    /**
     *
     *
     * <pre>
     * TA0002
     * </pre>
     *
     * <code>EXECUTION = 3;</code>
     */
    EXECUTION(3),
    /**
     *
     *
     * <pre>
     * TA0003
     * </pre>
     *
     * <code>PERSISTENCE = 6;</code>
     */
    PERSISTENCE(6),
    /**
     *
     *
     * <pre>
     * TA0004
     * </pre>
     *
     * <code>PRIVILEGE_ESCALATION = 8;</code>
     */
    PRIVILEGE_ESCALATION(8),
    /**
     *
     *
     * <pre>
     * TA0005
     * </pre>
     *
     * <code>DEFENSE_EVASION = 7;</code>
     */
    DEFENSE_EVASION(7),
    /**
     *
     *
     * <pre>
     * TA0006
     * </pre>
     *
     * <code>CREDENTIAL_ACCESS = 9;</code>
     */
    CREDENTIAL_ACCESS(9),
    /**
     *
     *
     * <pre>
     * TA0007
     * </pre>
     *
     * <code>DISCOVERY = 10;</code>
     */
    DISCOVERY(10),
    /**
     *
     *
     * <pre>
     * TA0008
     * </pre>
     *
     * <code>LATERAL_MOVEMENT = 11;</code>
     */
    LATERAL_MOVEMENT(11),
    /**
     *
     *
     * <pre>
     * TA0009
     * </pre>
     *
     * <code>COLLECTION = 12;</code>
     */
    COLLECTION(12),
    /**
     *
     *
     * <pre>
     * TA0011
     * </pre>
     *
     * <code>COMMAND_AND_CONTROL = 4;</code>
     */
    COMMAND_AND_CONTROL(4),
    /**
     *
     *
     * <pre>
     * TA0010
     * </pre>
     *
     * <code>EXFILTRATION = 13;</code>
     */
    EXFILTRATION(13),
    /**
     *
     *
     * <pre>
     * TA0040
     * </pre>
     *
     * <code>IMPACT = 14;</code>
     */
    IMPACT(14),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified value.
     * </pre>
     *
     * <code>TACTIC_UNSPECIFIED = 0;</code>
     */
    public static final int TACTIC_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * TA0043
     * </pre>
     *
     * <code>RECONNAISSANCE = 1;</code>
     */
    public static final int RECONNAISSANCE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * TA0042
     * </pre>
     *
     * <code>RESOURCE_DEVELOPMENT = 2;</code>
     */
    public static final int RESOURCE_DEVELOPMENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * TA0001
     * </pre>
     *
     * <code>INITIAL_ACCESS = 5;</code>
     */
    public static final int INITIAL_ACCESS_VALUE = 5;
    /**
     *
     *
     * <pre>
     * TA0002
     * </pre>
     *
     * <code>EXECUTION = 3;</code>
     */
    public static final int EXECUTION_VALUE = 3;
    /**
     *
     *
     * <pre>
     * TA0003
     * </pre>
     *
     * <code>PERSISTENCE = 6;</code>
     */
    public static final int PERSISTENCE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * TA0004
     * </pre>
     *
     * <code>PRIVILEGE_ESCALATION = 8;</code>
     */
    public static final int PRIVILEGE_ESCALATION_VALUE = 8;
    /**
     *
     *
     * <pre>
     * TA0005
     * </pre>
     *
     * <code>DEFENSE_EVASION = 7;</code>
     */
    public static final int DEFENSE_EVASION_VALUE = 7;
    /**
     *
     *
     * <pre>
     * TA0006
     * </pre>
     *
     * <code>CREDENTIAL_ACCESS = 9;</code>
     */
    public static final int CREDENTIAL_ACCESS_VALUE = 9;
    /**
     *
     *
     * <pre>
     * TA0007
     * </pre>
     *
     * <code>DISCOVERY = 10;</code>
     */
    public static final int DISCOVERY_VALUE = 10;
    /**
     *
     *
     * <pre>
     * TA0008
     * </pre>
     *
     * <code>LATERAL_MOVEMENT = 11;</code>
     */
    public static final int LATERAL_MOVEMENT_VALUE = 11;
    /**
     *
     *
     * <pre>
     * TA0009
     * </pre>
     *
     * <code>COLLECTION = 12;</code>
     */
    public static final int COLLECTION_VALUE = 12;
    /**
     *
     *
     * <pre>
     * TA0011
     * </pre>
     *
     * <code>COMMAND_AND_CONTROL = 4;</code>
     */
    public static final int COMMAND_AND_CONTROL_VALUE = 4;
    /**
     *
     *
     * <pre>
     * TA0010
     * </pre>
     *
     * <code>EXFILTRATION = 13;</code>
     */
    public static final int EXFILTRATION_VALUE = 13;
    /**
     *
     *
     * <pre>
     * TA0040
     * </pre>
     *
     * <code>IMPACT = 14;</code>
     */
    public static final int IMPACT_VALUE = 14;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Tactic valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Tactic forNumber(int value) {
      switch (value) {
        case 0:
          return TACTIC_UNSPECIFIED;
        case 1:
          return RECONNAISSANCE;
        case 2:
          return RESOURCE_DEVELOPMENT;
        case 5:
          return INITIAL_ACCESS;
        case 3:
          return EXECUTION;
        case 6:
          return PERSISTENCE;
        case 8:
          return PRIVILEGE_ESCALATION;
        case 7:
          return DEFENSE_EVASION;
        case 9:
          return CREDENTIAL_ACCESS;
        case 10:
          return DISCOVERY;
        case 11:
          return LATERAL_MOVEMENT;
        case 12:
          return COLLECTION;
        case 4:
          return COMMAND_AND_CONTROL;
        case 13:
          return EXFILTRATION;
        case 14:
          return IMPACT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Tactic> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Tactic> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Tactic>() {
          public Tactic findValueByNumber(int number) {
            return Tactic.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.MitreAttack.getDescriptor().getEnumTypes().get(0);
    }

    private static final Tactic[] VALUES = values();

    public static Tactic valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Tactic(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.MitreAttack.Tactic)
  }

  /**
   *
   *
   * <pre>
   * MITRE ATT&amp;CK techniques that can be referenced by SCC findings.
   * See: https://attack.mitre.org/techniques/enterprise/
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.MitreAttack.Technique}
   */
  public enum Technique implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified value.
     * </pre>
     *
     * <code>TECHNIQUE_UNSPECIFIED = 0;</code>
     */
    TECHNIQUE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * T1595
     * </pre>
     *
     * <code>ACTIVE_SCANNING = 1;</code>
     */
    ACTIVE_SCANNING(1),
    /**
     *
     *
     * <pre>
     * T1595.001
     * </pre>
     *
     * <code>SCANNING_IP_BLOCKS = 2;</code>
     */
    SCANNING_IP_BLOCKS(2),
    /**
     *
     *
     * <pre>
     * T1105
     * </pre>
     *
     * <code>INGRESS_TOOL_TRANSFER = 3;</code>
     */
    INGRESS_TOOL_TRANSFER(3),
    /**
     *
     *
     * <pre>
     * T1106
     * </pre>
     *
     * <code>NATIVE_API = 4;</code>
     */
    NATIVE_API(4),
    /**
     *
     *
     * <pre>
     * T1129
     * </pre>
     *
     * <code>SHARED_MODULES = 5;</code>
     */
    SHARED_MODULES(5),
    /**
     *
     *
     * <pre>
     * T1059
     * </pre>
     *
     * <code>COMMAND_AND_SCRIPTING_INTERPRETER = 6;</code>
     */
    COMMAND_AND_SCRIPTING_INTERPRETER(6),
    /**
     *
     *
     * <pre>
     * T1059.004
     * </pre>
     *
     * <code>UNIX_SHELL = 7;</code>
     */
    UNIX_SHELL(7),
    /**
     *
     *
     * <pre>
     * T1496
     * </pre>
     *
     * <code>RESOURCE_HIJACKING = 8;</code>
     */
    RESOURCE_HIJACKING(8),
    /**
     *
     *
     * <pre>
     * T1090
     * </pre>
     *
     * <code>PROXY = 9;</code>
     */
    PROXY(9),
    /**
     *
     *
     * <pre>
     * T1090.002
     * </pre>
     *
     * <code>EXTERNAL_PROXY = 10;</code>
     */
    EXTERNAL_PROXY(10),
    /**
     *
     *
     * <pre>
     * T1090.003
     * </pre>
     *
     * <code>MULTI_HOP_PROXY = 11;</code>
     */
    MULTI_HOP_PROXY(11),
    /**
     *
     *
     * <pre>
     * T1568
     * </pre>
     *
     * <code>DYNAMIC_RESOLUTION = 12;</code>
     */
    DYNAMIC_RESOLUTION(12),
    /**
     *
     *
     * <pre>
     * T1552
     * </pre>
     *
     * <code>UNSECURED_CREDENTIALS = 13;</code>
     */
    UNSECURED_CREDENTIALS(13),
    /**
     *
     *
     * <pre>
     * T1078
     * </pre>
     *
     * <code>VALID_ACCOUNTS = 14;</code>
     */
    VALID_ACCOUNTS(14),
    /**
     *
     *
     * <pre>
     * T1078.003
     * </pre>
     *
     * <code>LOCAL_ACCOUNTS = 15;</code>
     */
    LOCAL_ACCOUNTS(15),
    /**
     *
     *
     * <pre>
     * T1078.004
     * </pre>
     *
     * <code>CLOUD_ACCOUNTS = 16;</code>
     */
    CLOUD_ACCOUNTS(16),
    /**
     *
     *
     * <pre>
     * T1498
     * </pre>
     *
     * <code>NETWORK_DENIAL_OF_SERVICE = 17;</code>
     */
    NETWORK_DENIAL_OF_SERVICE(17),
    /**
     *
     *
     * <pre>
     * T1069
     * </pre>
     *
     * <code>PERMISSION_GROUPS_DISCOVERY = 18;</code>
     */
    PERMISSION_GROUPS_DISCOVERY(18),
    /**
     *
     *
     * <pre>
     * T1069.003
     * </pre>
     *
     * <code>CLOUD_GROUPS = 19;</code>
     */
    CLOUD_GROUPS(19),
    /**
     *
     *
     * <pre>
     * T1567
     * </pre>
     *
     * <code>EXFILTRATION_OVER_WEB_SERVICE = 20;</code>
     */
    EXFILTRATION_OVER_WEB_SERVICE(20),
    /**
     *
     *
     * <pre>
     * T1567.002
     * </pre>
     *
     * <code>EXFILTRATION_TO_CLOUD_STORAGE = 21;</code>
     */
    EXFILTRATION_TO_CLOUD_STORAGE(21),
    /**
     *
     *
     * <pre>
     * T1098
     * </pre>
     *
     * <code>ACCOUNT_MANIPULATION = 22;</code>
     */
    ACCOUNT_MANIPULATION(22),
    /**
     *
     *
     * <pre>
     * T1098.004
     * </pre>
     *
     * <code>SSH_AUTHORIZED_KEYS = 23;</code>
     */
    SSH_AUTHORIZED_KEYS(23),
    /**
     *
     *
     * <pre>
     * T1543
     * </pre>
     *
     * <code>CREATE_OR_MODIFY_SYSTEM_PROCESS = 24;</code>
     */
    CREATE_OR_MODIFY_SYSTEM_PROCESS(24),
    /**
     *
     *
     * <pre>
     * T1539
     * </pre>
     *
     * <code>STEAL_WEB_SESSION_COOKIE = 25;</code>
     */
    STEAL_WEB_SESSION_COOKIE(25),
    /**
     *
     *
     * <pre>
     * T1578
     * </pre>
     *
     * <code>MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE = 26;</code>
     */
    MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE(26),
    /**
     *
     *
     * <pre>
     * T1190
     * </pre>
     *
     * <code>EXPLOIT_PUBLIC_FACING_APPLICATION = 27;</code>
     */
    EXPLOIT_PUBLIC_FACING_APPLICATION(27),
    /**
     *
     *
     * <pre>
     * T1556
     * </pre>
     *
     * <code>MODIFY_AUTHENTICATION_PROCESS = 28;</code>
     */
    MODIFY_AUTHENTICATION_PROCESS(28),
    /**
     *
     *
     * <pre>
     * T1485
     * </pre>
     *
     * <code>DATA_DESTRUCTION = 29;</code>
     */
    DATA_DESTRUCTION(29),
    /**
     *
     *
     * <pre>
     * T1484
     * </pre>
     *
     * <code>DOMAIN_POLICY_MODIFICATION = 30;</code>
     */
    DOMAIN_POLICY_MODIFICATION(30),
    /**
     *
     *
     * <pre>
     * T1562
     * </pre>
     *
     * <code>IMPAIR_DEFENSES = 31;</code>
     */
    IMPAIR_DEFENSES(31),
    /**
     *
     *
     * <pre>
     * T1046
     * </pre>
     *
     * <code>NETWORK_SERVICE_DISCOVERY = 32;</code>
     */
    NETWORK_SERVICE_DISCOVERY(32),
    /**
     *
     *
     * <pre>
     * T1134
     * </pre>
     *
     * <code>ACCESS_TOKEN_MANIPULATION = 33;</code>
     */
    ACCESS_TOKEN_MANIPULATION(33),
    /**
     *
     *
     * <pre>
     * T1548
     * </pre>
     *
     * <code>ABUSE_ELEVATION_CONTROL_MECHANISM = 34;</code>
     */
    ABUSE_ELEVATION_CONTROL_MECHANISM(34),
    /**
     *
     *
     * <pre>
     * T1078.001
     * </pre>
     *
     * <code>DEFAULT_ACCOUNTS = 35;</code>
     */
    DEFAULT_ACCOUNTS(35),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified value.
     * </pre>
     *
     * <code>TECHNIQUE_UNSPECIFIED = 0;</code>
     */
    public static final int TECHNIQUE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * T1595
     * </pre>
     *
     * <code>ACTIVE_SCANNING = 1;</code>
     */
    public static final int ACTIVE_SCANNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * T1595.001
     * </pre>
     *
     * <code>SCANNING_IP_BLOCKS = 2;</code>
     */
    public static final int SCANNING_IP_BLOCKS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * T1105
     * </pre>
     *
     * <code>INGRESS_TOOL_TRANSFER = 3;</code>
     */
    public static final int INGRESS_TOOL_TRANSFER_VALUE = 3;
    /**
     *
     *
     * <pre>
     * T1106
     * </pre>
     *
     * <code>NATIVE_API = 4;</code>
     */
    public static final int NATIVE_API_VALUE = 4;
    /**
     *
     *
     * <pre>
     * T1129
     * </pre>
     *
     * <code>SHARED_MODULES = 5;</code>
     */
    public static final int SHARED_MODULES_VALUE = 5;
    /**
     *
     *
     * <pre>
     * T1059
     * </pre>
     *
     * <code>COMMAND_AND_SCRIPTING_INTERPRETER = 6;</code>
     */
    public static final int COMMAND_AND_SCRIPTING_INTERPRETER_VALUE = 6;
    /**
     *
     *
     * <pre>
     * T1059.004
     * </pre>
     *
     * <code>UNIX_SHELL = 7;</code>
     */
    public static final int UNIX_SHELL_VALUE = 7;
    /**
     *
     *
     * <pre>
     * T1496
     * </pre>
     *
     * <code>RESOURCE_HIJACKING = 8;</code>
     */
    public static final int RESOURCE_HIJACKING_VALUE = 8;
    /**
     *
     *
     * <pre>
     * T1090
     * </pre>
     *
     * <code>PROXY = 9;</code>
     */
    public static final int PROXY_VALUE = 9;
    /**
     *
     *
     * <pre>
     * T1090.002
     * </pre>
     *
     * <code>EXTERNAL_PROXY = 10;</code>
     */
    public static final int EXTERNAL_PROXY_VALUE = 10;
    /**
     *
     *
     * <pre>
     * T1090.003
     * </pre>
     *
     * <code>MULTI_HOP_PROXY = 11;</code>
     */
    public static final int MULTI_HOP_PROXY_VALUE = 11;
    /**
     *
     *
     * <pre>
     * T1568
     * </pre>
     *
     * <code>DYNAMIC_RESOLUTION = 12;</code>
     */
    public static final int DYNAMIC_RESOLUTION_VALUE = 12;
    /**
     *
     *
     * <pre>
     * T1552
     * </pre>
     *
     * <code>UNSECURED_CREDENTIALS = 13;</code>
     */
    public static final int UNSECURED_CREDENTIALS_VALUE = 13;
    /**
     *
     *
     * <pre>
     * T1078
     * </pre>
     *
     * <code>VALID_ACCOUNTS = 14;</code>
     */
    public static final int VALID_ACCOUNTS_VALUE = 14;
    /**
     *
     *
     * <pre>
     * T1078.003
     * </pre>
     *
     * <code>LOCAL_ACCOUNTS = 15;</code>
     */
    public static final int LOCAL_ACCOUNTS_VALUE = 15;
    /**
     *
     *
     * <pre>
     * T1078.004
     * </pre>
     *
     * <code>CLOUD_ACCOUNTS = 16;</code>
     */
    public static final int CLOUD_ACCOUNTS_VALUE = 16;
    /**
     *
     *
     * <pre>
     * T1498
     * </pre>
     *
     * <code>NETWORK_DENIAL_OF_SERVICE = 17;</code>
     */
    public static final int NETWORK_DENIAL_OF_SERVICE_VALUE = 17;
    /**
     *
     *
     * <pre>
     * T1069
     * </pre>
     *
     * <code>PERMISSION_GROUPS_DISCOVERY = 18;</code>
     */
    public static final int PERMISSION_GROUPS_DISCOVERY_VALUE = 18;
    /**
     *
     *
     * <pre>
     * T1069.003
     * </pre>
     *
     * <code>CLOUD_GROUPS = 19;</code>
     */
    public static final int CLOUD_GROUPS_VALUE = 19;
    /**
     *
     *
     * <pre>
     * T1567
     * </pre>
     *
     * <code>EXFILTRATION_OVER_WEB_SERVICE = 20;</code>
     */
    public static final int EXFILTRATION_OVER_WEB_SERVICE_VALUE = 20;
    /**
     *
     *
     * <pre>
     * T1567.002
     * </pre>
     *
     * <code>EXFILTRATION_TO_CLOUD_STORAGE = 21;</code>
     */
    public static final int EXFILTRATION_TO_CLOUD_STORAGE_VALUE = 21;
    /**
     *
     *
     * <pre>
     * T1098
     * </pre>
     *
     * <code>ACCOUNT_MANIPULATION = 22;</code>
     */
    public static final int ACCOUNT_MANIPULATION_VALUE = 22;
    /**
     *
     *
     * <pre>
     * T1098.004
     * </pre>
     *
     * <code>SSH_AUTHORIZED_KEYS = 23;</code>
     */
    public static final int SSH_AUTHORIZED_KEYS_VALUE = 23;
    /**
     *
     *
     * <pre>
     * T1543
     * </pre>
     *
     * <code>CREATE_OR_MODIFY_SYSTEM_PROCESS = 24;</code>
     */
    public static final int CREATE_OR_MODIFY_SYSTEM_PROCESS_VALUE = 24;
    /**
     *
     *
     * <pre>
     * T1539
     * </pre>
     *
     * <code>STEAL_WEB_SESSION_COOKIE = 25;</code>
     */
    public static final int STEAL_WEB_SESSION_COOKIE_VALUE = 25;
    /**
     *
     *
     * <pre>
     * T1578
     * </pre>
     *
     * <code>MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE = 26;</code>
     */
    public static final int MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE_VALUE = 26;
    /**
     *
     *
     * <pre>
     * T1190
     * </pre>
     *
     * <code>EXPLOIT_PUBLIC_FACING_APPLICATION = 27;</code>
     */
    public static final int EXPLOIT_PUBLIC_FACING_APPLICATION_VALUE = 27;
    /**
     *
     *
     * <pre>
     * T1556
     * </pre>
     *
     * <code>MODIFY_AUTHENTICATION_PROCESS = 28;</code>
     */
    public static final int MODIFY_AUTHENTICATION_PROCESS_VALUE = 28;
    /**
     *
     *
     * <pre>
     * T1485
     * </pre>
     *
     * <code>DATA_DESTRUCTION = 29;</code>
     */
    public static final int DATA_DESTRUCTION_VALUE = 29;
    /**
     *
     *
     * <pre>
     * T1484
     * </pre>
     *
     * <code>DOMAIN_POLICY_MODIFICATION = 30;</code>
     */
    public static final int DOMAIN_POLICY_MODIFICATION_VALUE = 30;
    /**
     *
     *
     * <pre>
     * T1562
     * </pre>
     *
     * <code>IMPAIR_DEFENSES = 31;</code>
     */
    public static final int IMPAIR_DEFENSES_VALUE = 31;
    /**
     *
     *
     * <pre>
     * T1046
     * </pre>
     *
     * <code>NETWORK_SERVICE_DISCOVERY = 32;</code>
     */
    public static final int NETWORK_SERVICE_DISCOVERY_VALUE = 32;
    /**
     *
     *
     * <pre>
     * T1134
     * </pre>
     *
     * <code>ACCESS_TOKEN_MANIPULATION = 33;</code>
     */
    public static final int ACCESS_TOKEN_MANIPULATION_VALUE = 33;
    /**
     *
     *
     * <pre>
     * T1548
     * </pre>
     *
     * <code>ABUSE_ELEVATION_CONTROL_MECHANISM = 34;</code>
     */
    public static final int ABUSE_ELEVATION_CONTROL_MECHANISM_VALUE = 34;
    /**
     *
     *
     * <pre>
     * T1078.001
     * </pre>
     *
     * <code>DEFAULT_ACCOUNTS = 35;</code>
     */
    public static final int DEFAULT_ACCOUNTS_VALUE = 35;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Technique valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Technique forNumber(int value) {
      switch (value) {
        case 0:
          return TECHNIQUE_UNSPECIFIED;
        case 1:
          return ACTIVE_SCANNING;
        case 2:
          return SCANNING_IP_BLOCKS;
        case 3:
          return INGRESS_TOOL_TRANSFER;
        case 4:
          return NATIVE_API;
        case 5:
          return SHARED_MODULES;
        case 6:
          return COMMAND_AND_SCRIPTING_INTERPRETER;
        case 7:
          return UNIX_SHELL;
        case 8:
          return RESOURCE_HIJACKING;
        case 9:
          return PROXY;
        case 10:
          return EXTERNAL_PROXY;
        case 11:
          return MULTI_HOP_PROXY;
        case 12:
          return DYNAMIC_RESOLUTION;
        case 13:
          return UNSECURED_CREDENTIALS;
        case 14:
          return VALID_ACCOUNTS;
        case 15:
          return LOCAL_ACCOUNTS;
        case 16:
          return CLOUD_ACCOUNTS;
        case 17:
          return NETWORK_DENIAL_OF_SERVICE;
        case 18:
          return PERMISSION_GROUPS_DISCOVERY;
        case 19:
          return CLOUD_GROUPS;
        case 20:
          return EXFILTRATION_OVER_WEB_SERVICE;
        case 21:
          return EXFILTRATION_TO_CLOUD_STORAGE;
        case 22:
          return ACCOUNT_MANIPULATION;
        case 23:
          return SSH_AUTHORIZED_KEYS;
        case 24:
          return CREATE_OR_MODIFY_SYSTEM_PROCESS;
        case 25:
          return STEAL_WEB_SESSION_COOKIE;
        case 26:
          return MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE;
        case 27:
          return EXPLOIT_PUBLIC_FACING_APPLICATION;
        case 28:
          return MODIFY_AUTHENTICATION_PROCESS;
        case 29:
          return DATA_DESTRUCTION;
        case 30:
          return DOMAIN_POLICY_MODIFICATION;
        case 31:
          return IMPAIR_DEFENSES;
        case 32:
          return NETWORK_SERVICE_DISCOVERY;
        case 33:
          return ACCESS_TOKEN_MANIPULATION;
        case 34:
          return ABUSE_ELEVATION_CONTROL_MECHANISM;
        case 35:
          return DEFAULT_ACCOUNTS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Technique> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Technique> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Technique>() {
          public Technique findValueByNumber(int number) {
            return Technique.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.MitreAttack.getDescriptor().getEnumTypes().get(1);
    }

    private static final Technique[] VALUES = values();

    public static Technique valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Technique(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.MitreAttack.Technique)
  }

  public static final int PRIMARY_TACTIC_FIELD_NUMBER = 1;
  private int primaryTactic_ = 0;
  /**
   *
   *
   * <pre>
   * The MITRE ATT&amp;CK tactic most closely represented by this finding, if any.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.MitreAttack.Tactic primary_tactic = 1;</code>
   *
   * @return The enum numeric value on the wire for primaryTactic.
   */
  @java.lang.Override
  public int getPrimaryTacticValue() {
    return primaryTactic_;
  }
  /**
   *
   *
   * <pre>
   * The MITRE ATT&amp;CK tactic most closely represented by this finding, if any.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.MitreAttack.Tactic primary_tactic = 1;</code>
   *
   * @return The primaryTactic.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.MitreAttack.Tactic getPrimaryTactic() {
    com.google.cloud.securitycenter.v1.MitreAttack.Tactic result =
        com.google.cloud.securitycenter.v1.MitreAttack.Tactic.forNumber(primaryTactic_);
    return result == null
        ? com.google.cloud.securitycenter.v1.MitreAttack.Tactic.UNRECOGNIZED
        : result;
  }

  public static final int PRIMARY_TECHNIQUES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> primaryTechniques_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Technique>
      primaryTechniques_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Technique>() {
            public com.google.cloud.securitycenter.v1.MitreAttack.Technique convert(
                java.lang.Integer from) {
              com.google.cloud.securitycenter.v1.MitreAttack.Technique result =
                  com.google.cloud.securitycenter.v1.MitreAttack.Technique.forNumber(from);
              return result == null
                  ? com.google.cloud.securitycenter.v1.MitreAttack.Technique.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The MITRE ATT&amp;CK technique most closely represented by this finding, if
   * any. primary_techniques is a repeated field because there are multiple
   * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
   * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
   * both the sub-technique and its parent technique(s) will be listed (e.g.
   * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
   * </code>
   *
   * @return A list containing the primaryTechniques.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.MitreAttack.Technique>
      getPrimaryTechniquesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Technique>(
        primaryTechniques_, primaryTechniques_converter_);
  }
  /**
   *
   *
   * <pre>
   * The MITRE ATT&amp;CK technique most closely represented by this finding, if
   * any. primary_techniques is a repeated field because there are multiple
   * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
   * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
   * both the sub-technique and its parent technique(s) will be listed (e.g.
   * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
   * </code>
   *
   * @return The count of primaryTechniques.
   */
  @java.lang.Override
  public int getPrimaryTechniquesCount() {
    return primaryTechniques_.size();
  }
  /**
   *
   *
   * <pre>
   * The MITRE ATT&amp;CK technique most closely represented by this finding, if
   * any. primary_techniques is a repeated field because there are multiple
   * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
   * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
   * both the sub-technique and its parent technique(s) will be listed (e.g.
   * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The primaryTechniques at the given index.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.MitreAttack.Technique getPrimaryTechniques(int index) {
    return primaryTechniques_converter_.convert(primaryTechniques_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The MITRE ATT&amp;CK technique most closely represented by this finding, if
   * any. primary_techniques is a repeated field because there are multiple
   * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
   * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
   * both the sub-technique and its parent technique(s) will be listed (e.g.
   * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for primaryTechniques.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getPrimaryTechniquesValueList() {
    return primaryTechniques_;
  }
  /**
   *
   *
   * <pre>
   * The MITRE ATT&amp;CK technique most closely represented by this finding, if
   * any. primary_techniques is a repeated field because there are multiple
   * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
   * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
   * both the sub-technique and its parent technique(s) will be listed (e.g.
   * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of primaryTechniques at the given index.
   */
  @java.lang.Override
  public int getPrimaryTechniquesValue(int index) {
    return primaryTechniques_.get(index);
  }

  private int primaryTechniquesMemoizedSerializedSize;

  public static final int ADDITIONAL_TACTICS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> additionalTactics_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Tactic>
      additionalTactics_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Tactic>() {
            public com.google.cloud.securitycenter.v1.MitreAttack.Tactic convert(
                java.lang.Integer from) {
              com.google.cloud.securitycenter.v1.MitreAttack.Tactic result =
                  com.google.cloud.securitycenter.v1.MitreAttack.Tactic.forNumber(from);
              return result == null
                  ? com.google.cloud.securitycenter.v1.MitreAttack.Tactic.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
   * </code>
   *
   * @return A list containing the additionalTactics.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.MitreAttack.Tactic>
      getAdditionalTacticsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Tactic>(
        additionalTactics_, additionalTactics_converter_);
  }
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
   * </code>
   *
   * @return The count of additionalTactics.
   */
  @java.lang.Override
  public int getAdditionalTacticsCount() {
    return additionalTactics_.size();
  }
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The additionalTactics at the given index.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.MitreAttack.Tactic getAdditionalTactics(int index) {
    return additionalTactics_converter_.convert(additionalTactics_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for additionalTactics.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAdditionalTacticsValueList() {
    return additionalTactics_;
  }
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of additionalTactics at the given index.
   */
  @java.lang.Override
  public int getAdditionalTacticsValue(int index) {
    return additionalTactics_.get(index);
  }

  private int additionalTacticsMemoizedSerializedSize;

  public static final int ADDITIONAL_TECHNIQUES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> additionalTechniques_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Technique>
      additionalTechniques_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Technique>() {
            public com.google.cloud.securitycenter.v1.MitreAttack.Technique convert(
                java.lang.Integer from) {
              com.google.cloud.securitycenter.v1.MitreAttack.Technique result =
                  com.google.cloud.securitycenter.v1.MitreAttack.Technique.forNumber(from);
              return result == null
                  ? com.google.cloud.securitycenter.v1.MitreAttack.Technique.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
   * with any of their respective parent techniques.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
   * </code>
   *
   * @return A list containing the additionalTechniques.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.MitreAttack.Technique>
      getAdditionalTechniquesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Technique>(
        additionalTechniques_, additionalTechniques_converter_);
  }
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
   * with any of their respective parent techniques.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
   * </code>
   *
   * @return The count of additionalTechniques.
   */
  @java.lang.Override
  public int getAdditionalTechniquesCount() {
    return additionalTechniques_.size();
  }
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
   * with any of their respective parent techniques.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The additionalTechniques at the given index.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.MitreAttack.Technique getAdditionalTechniques(
      int index) {
    return additionalTechniques_converter_.convert(additionalTechniques_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
   * with any of their respective parent techniques.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for additionalTechniques.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAdditionalTechniquesValueList() {
    return additionalTechniques_;
  }
  /**
   *
   *
   * <pre>
   * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
   * with any of their respective parent techniques.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of additionalTechniques at the given index.
   */
  @java.lang.Override
  public int getAdditionalTechniquesValue(int index) {
    return additionalTechniques_.get(index);
  }

  private int additionalTechniquesMemoizedSerializedSize;

  public static final int VERSION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * The MITRE ATT&amp;CK version referenced by the above fields. E.g. "8".
   * </pre>
   *
   * <code>string version = 5;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The MITRE ATT&amp;CK version referenced by the above fields. E.g. "8".
   * </pre>
   *
   * <code>string version = 5;</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (primaryTactic_
        != com.google.cloud.securitycenter.v1.MitreAttack.Tactic.TACTIC_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, primaryTactic_);
    }
    if (getPrimaryTechniquesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(primaryTechniquesMemoizedSerializedSize);
    }
    for (int i = 0; i < primaryTechniques_.size(); i++) {
      output.writeEnumNoTag(primaryTechniques_.get(i));
    }
    if (getAdditionalTacticsList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(additionalTacticsMemoizedSerializedSize);
    }
    for (int i = 0; i < additionalTactics_.size(); i++) {
      output.writeEnumNoTag(additionalTactics_.get(i));
    }
    if (getAdditionalTechniquesList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(additionalTechniquesMemoizedSerializedSize);
    }
    for (int i = 0; i < additionalTechniques_.size(); i++) {
      output.writeEnumNoTag(additionalTechniques_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, version_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (primaryTactic_
        != com.google.cloud.securitycenter.v1.MitreAttack.Tactic.TACTIC_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, primaryTactic_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < primaryTechniques_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(primaryTechniques_.get(i));
      }
      size += dataSize;
      if (!getPrimaryTechniquesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      primaryTechniquesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < additionalTactics_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(additionalTactics_.get(i));
      }
      size += dataSize;
      if (!getAdditionalTacticsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      additionalTacticsMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < additionalTechniques_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                additionalTechniques_.get(i));
      }
      size += dataSize;
      if (!getAdditionalTechniquesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      additionalTechniquesMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, version_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.MitreAttack)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.MitreAttack other =
        (com.google.cloud.securitycenter.v1.MitreAttack) obj;

    if (primaryTactic_ != other.primaryTactic_) return false;
    if (!primaryTechniques_.equals(other.primaryTechniques_)) return false;
    if (!additionalTactics_.equals(other.additionalTactics_)) return false;
    if (!additionalTechniques_.equals(other.additionalTechniques_)) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRIMARY_TACTIC_FIELD_NUMBER;
    hash = (53 * hash) + primaryTactic_;
    if (getPrimaryTechniquesCount() > 0) {
      hash = (37 * hash) + PRIMARY_TECHNIQUES_FIELD_NUMBER;
      hash = (53 * hash) + primaryTechniques_.hashCode();
    }
    if (getAdditionalTacticsCount() > 0) {
      hash = (37 * hash) + ADDITIONAL_TACTICS_FIELD_NUMBER;
      hash = (53 * hash) + additionalTactics_.hashCode();
    }
    if (getAdditionalTechniquesCount() > 0) {
      hash = (37 * hash) + ADDITIONAL_TECHNIQUES_FIELD_NUMBER;
      hash = (53 * hash) + additionalTechniques_.hashCode();
    }
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.MitreAttack prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * MITRE ATT&amp;CK tactics and techniques related to this finding.
   * See: https://attack.mitre.org
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.MitreAttack}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.MitreAttack)
      com.google.cloud.securitycenter.v1.MitreAttackOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.MitreAttackProto
          .internal_static_google_cloud_securitycenter_v1_MitreAttack_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.MitreAttackProto
          .internal_static_google_cloud_securitycenter_v1_MitreAttack_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.MitreAttack.class,
              com.google.cloud.securitycenter.v1.MitreAttack.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.MitreAttack.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      primaryTactic_ = 0;
      primaryTechniques_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      additionalTactics_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      additionalTechniques_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      version_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.MitreAttackProto
          .internal_static_google_cloud_securitycenter_v1_MitreAttack_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.MitreAttack getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.MitreAttack.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.MitreAttack build() {
      com.google.cloud.securitycenter.v1.MitreAttack result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.MitreAttack buildPartial() {
      com.google.cloud.securitycenter.v1.MitreAttack result =
          new com.google.cloud.securitycenter.v1.MitreAttack(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.securitycenter.v1.MitreAttack result) {
      if (((bitField0_ & 0x00000002) != 0)) {
        primaryTechniques_ = java.util.Collections.unmodifiableList(primaryTechniques_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.primaryTechniques_ = primaryTechniques_;
      if (((bitField0_ & 0x00000004) != 0)) {
        additionalTactics_ = java.util.Collections.unmodifiableList(additionalTactics_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.additionalTactics_ = additionalTactics_;
      if (((bitField0_ & 0x00000008) != 0)) {
        additionalTechniques_ = java.util.Collections.unmodifiableList(additionalTechniques_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.additionalTechniques_ = additionalTechniques_;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.MitreAttack result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.primaryTactic_ = primaryTactic_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.version_ = version_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.MitreAttack) {
        return mergeFrom((com.google.cloud.securitycenter.v1.MitreAttack) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.MitreAttack other) {
      if (other == com.google.cloud.securitycenter.v1.MitreAttack.getDefaultInstance()) return this;
      if (other.primaryTactic_ != 0) {
        setPrimaryTacticValue(other.getPrimaryTacticValue());
      }
      if (!other.primaryTechniques_.isEmpty()) {
        if (primaryTechniques_.isEmpty()) {
          primaryTechniques_ = other.primaryTechniques_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensurePrimaryTechniquesIsMutable();
          primaryTechniques_.addAll(other.primaryTechniques_);
        }
        onChanged();
      }
      if (!other.additionalTactics_.isEmpty()) {
        if (additionalTactics_.isEmpty()) {
          additionalTactics_ = other.additionalTactics_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureAdditionalTacticsIsMutable();
          additionalTactics_.addAll(other.additionalTactics_);
        }
        onChanged();
      }
      if (!other.additionalTechniques_.isEmpty()) {
        if (additionalTechniques_.isEmpty()) {
          additionalTechniques_ = other.additionalTechniques_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureAdditionalTechniquesIsMutable();
          additionalTechniques_.addAll(other.additionalTechniques_);
        }
        onChanged();
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                primaryTactic_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                int tmpRaw = input.readEnum();
                ensurePrimaryTechniquesIsMutable();
                primaryTechniques_.add(tmpRaw);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensurePrimaryTechniquesIsMutable();
                  primaryTechniques_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 18
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureAdditionalTacticsIsMutable();
                additionalTactics_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureAdditionalTacticsIsMutable();
                  additionalTactics_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureAdditionalTechniquesIsMutable();
                additionalTechniques_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureAdditionalTechniquesIsMutable();
                  additionalTechniques_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            case 42:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int primaryTactic_ = 0;
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK tactic most closely represented by this finding, if any.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack.Tactic primary_tactic = 1;</code>
     *
     * @return The enum numeric value on the wire for primaryTactic.
     */
    @java.lang.Override
    public int getPrimaryTacticValue() {
      return primaryTactic_;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK tactic most closely represented by this finding, if any.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack.Tactic primary_tactic = 1;</code>
     *
     * @param value The enum numeric value on the wire for primaryTactic to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryTacticValue(int value) {
      primaryTactic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK tactic most closely represented by this finding, if any.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack.Tactic primary_tactic = 1;</code>
     *
     * @return The primaryTactic.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.MitreAttack.Tactic getPrimaryTactic() {
      com.google.cloud.securitycenter.v1.MitreAttack.Tactic result =
          com.google.cloud.securitycenter.v1.MitreAttack.Tactic.forNumber(primaryTactic_);
      return result == null
          ? com.google.cloud.securitycenter.v1.MitreAttack.Tactic.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK tactic most closely represented by this finding, if any.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack.Tactic primary_tactic = 1;</code>
     *
     * @param value The primaryTactic to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryTactic(com.google.cloud.securitycenter.v1.MitreAttack.Tactic value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      primaryTactic_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK tactic most closely represented by this finding, if any.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.MitreAttack.Tactic primary_tactic = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrimaryTactic() {
      bitField0_ = (bitField0_ & ~0x00000001);
      primaryTactic_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> primaryTechniques_ =
        java.util.Collections.emptyList();

    private void ensurePrimaryTechniquesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        primaryTechniques_ = new java.util.ArrayList<java.lang.Integer>(primaryTechniques_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @return A list containing the primaryTechniques.
     */
    public java.util.List<com.google.cloud.securitycenter.v1.MitreAttack.Technique>
        getPrimaryTechniquesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Technique>(
          primaryTechniques_, primaryTechniques_converter_);
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @return The count of primaryTechniques.
     */
    public int getPrimaryTechniquesCount() {
      return primaryTechniques_.size();
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The primaryTechniques at the given index.
     */
    public com.google.cloud.securitycenter.v1.MitreAttack.Technique getPrimaryTechniques(
        int index) {
      return primaryTechniques_converter_.convert(primaryTechniques_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The primaryTechniques to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryTechniques(
        int index, com.google.cloud.securitycenter.v1.MitreAttack.Technique value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrimaryTechniquesIsMutable();
      primaryTechniques_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @param value The primaryTechniques to add.
     * @return This builder for chaining.
     */
    public Builder addPrimaryTechniques(
        com.google.cloud.securitycenter.v1.MitreAttack.Technique value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrimaryTechniquesIsMutable();
      primaryTechniques_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @param values The primaryTechniques to add.
     * @return This builder for chaining.
     */
    public Builder addAllPrimaryTechniques(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.MitreAttack.Technique>
            values) {
      ensurePrimaryTechniquesIsMutable();
      for (com.google.cloud.securitycenter.v1.MitreAttack.Technique value : values) {
        primaryTechniques_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrimaryTechniques() {
      primaryTechniques_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for primaryTechniques.
     */
    public java.util.List<java.lang.Integer> getPrimaryTechniquesValueList() {
      return java.util.Collections.unmodifiableList(primaryTechniques_);
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of primaryTechniques at the given index.
     */
    public int getPrimaryTechniquesValue(int index) {
      return primaryTechniques_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for primaryTechniques to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryTechniquesValue(int index, int value) {
      ensurePrimaryTechniquesIsMutable();
      primaryTechniques_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for primaryTechniques to add.
     * @return This builder for chaining.
     */
    public Builder addPrimaryTechniquesValue(int value) {
      ensurePrimaryTechniquesIsMutable();
      primaryTechniques_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK technique most closely represented by this finding, if
     * any. primary_techniques is a repeated field because there are multiple
     * levels of MITRE ATT&amp;CK techniques.  If the technique most closely
     * represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
     * both the sub-technique and its parent technique(s) will be listed (e.g.
     * `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Technique primary_techniques = 2;
     * </code>
     *
     * @param values The enum numeric values on the wire for primaryTechniques to add.
     * @return This builder for chaining.
     */
    public Builder addAllPrimaryTechniquesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensurePrimaryTechniquesIsMutable();
      for (int value : values) {
        primaryTechniques_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> additionalTactics_ =
        java.util.Collections.emptyList();

    private void ensureAdditionalTacticsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        additionalTactics_ = new java.util.ArrayList<java.lang.Integer>(additionalTactics_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @return A list containing the additionalTactics.
     */
    public java.util.List<com.google.cloud.securitycenter.v1.MitreAttack.Tactic>
        getAdditionalTacticsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Tactic>(
          additionalTactics_, additionalTactics_converter_);
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @return The count of additionalTactics.
     */
    public int getAdditionalTacticsCount() {
      return additionalTactics_.size();
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The additionalTactics at the given index.
     */
    public com.google.cloud.securitycenter.v1.MitreAttack.Tactic getAdditionalTactics(int index) {
      return additionalTactics_converter_.convert(additionalTactics_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The additionalTactics to set.
     * @return This builder for chaining.
     */
    public Builder setAdditionalTactics(
        int index, com.google.cloud.securitycenter.v1.MitreAttack.Tactic value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdditionalTacticsIsMutable();
      additionalTactics_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @param value The additionalTactics to add.
     * @return This builder for chaining.
     */
    public Builder addAdditionalTactics(
        com.google.cloud.securitycenter.v1.MitreAttack.Tactic value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdditionalTacticsIsMutable();
      additionalTactics_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @param values The additionalTactics to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdditionalTactics(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.MitreAttack.Tactic>
            values) {
      ensureAdditionalTacticsIsMutable();
      for (com.google.cloud.securitycenter.v1.MitreAttack.Tactic value : values) {
        additionalTactics_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdditionalTactics() {
      additionalTactics_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for additionalTactics.
     */
    public java.util.List<java.lang.Integer> getAdditionalTacticsValueList() {
      return java.util.Collections.unmodifiableList(additionalTactics_);
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of additionalTactics at the given index.
     */
    public int getAdditionalTacticsValue(int index) {
      return additionalTactics_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for additionalTactics to set.
     * @return This builder for chaining.
     */
    public Builder setAdditionalTacticsValue(int index, int value) {
      ensureAdditionalTacticsIsMutable();
      additionalTactics_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for additionalTactics to add.
     * @return This builder for chaining.
     */
    public Builder addAdditionalTacticsValue(int value) {
      ensureAdditionalTacticsIsMutable();
      additionalTactics_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK tactics related to this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.MitreAttack.Tactic additional_tactics = 3;
     * </code>
     *
     * @param values The enum numeric values on the wire for additionalTactics to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdditionalTacticsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureAdditionalTacticsIsMutable();
      for (int value : values) {
        additionalTactics_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> additionalTechniques_ =
        java.util.Collections.emptyList();

    private void ensureAdditionalTechniquesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        additionalTechniques_ = new java.util.ArrayList<java.lang.Integer>(additionalTechniques_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @return A list containing the additionalTechniques.
     */
    public java.util.List<com.google.cloud.securitycenter.v1.MitreAttack.Technique>
        getAdditionalTechniquesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.securitycenter.v1.MitreAttack.Technique>(
          additionalTechniques_, additionalTechniques_converter_);
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @return The count of additionalTechniques.
     */
    public int getAdditionalTechniquesCount() {
      return additionalTechniques_.size();
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The additionalTechniques at the given index.
     */
    public com.google.cloud.securitycenter.v1.MitreAttack.Technique getAdditionalTechniques(
        int index) {
      return additionalTechniques_converter_.convert(additionalTechniques_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The additionalTechniques to set.
     * @return This builder for chaining.
     */
    public Builder setAdditionalTechniques(
        int index, com.google.cloud.securitycenter.v1.MitreAttack.Technique value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdditionalTechniquesIsMutable();
      additionalTechniques_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @param value The additionalTechniques to add.
     * @return This builder for chaining.
     */
    public Builder addAdditionalTechniques(
        com.google.cloud.securitycenter.v1.MitreAttack.Technique value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdditionalTechniquesIsMutable();
      additionalTechniques_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @param values The additionalTechniques to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdditionalTechniques(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.MitreAttack.Technique>
            values) {
      ensureAdditionalTechniquesIsMutable();
      for (com.google.cloud.securitycenter.v1.MitreAttack.Technique value : values) {
        additionalTechniques_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdditionalTechniques() {
      additionalTechniques_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for additionalTechniques.
     */
    public java.util.List<java.lang.Integer> getAdditionalTechniquesValueList() {
      return java.util.Collections.unmodifiableList(additionalTechniques_);
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of additionalTechniques at the given index.
     */
    public int getAdditionalTechniquesValue(int index) {
      return additionalTechniques_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for additionalTechniques to set.
     * @return This builder for chaining.
     */
    public Builder setAdditionalTechniquesValue(int index, int value) {
      ensureAdditionalTechniquesIsMutable();
      additionalTechniques_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for additionalTechniques to add.
     * @return This builder for chaining.
     */
    public Builder addAdditionalTechniquesValue(int value) {
      ensureAdditionalTechniquesIsMutable();
      additionalTechniques_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional MITRE ATT&amp;CK techniques related to this finding, if any, along
     * with any of their respective parent techniques.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.MitreAttack.Technique additional_techniques = 4;
     * </code>
     *
     * @param values The enum numeric values on the wire for additionalTechniques to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdditionalTechniquesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureAdditionalTechniquesIsMutable();
      for (int value : values) {
        additionalTechniques_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK version referenced by the above fields. E.g. "8".
     * </pre>
     *
     * <code>string version = 5;</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK version referenced by the above fields. E.g. "8".
     * </pre>
     *
     * <code>string version = 5;</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK version referenced by the above fields. E.g. "8".
     * </pre>
     *
     * <code>string version = 5;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK version referenced by the above fields. E.g. "8".
     * </pre>
     *
     * <code>string version = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MITRE ATT&amp;CK version referenced by the above fields. E.g. "8".
     * </pre>
     *
     * <code>string version = 5;</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.MitreAttack)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.MitreAttack)
  private static final com.google.cloud.securitycenter.v1.MitreAttack DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.MitreAttack();
  }

  public static com.google.cloud.securitycenter.v1.MitreAttack getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MitreAttack> PARSER =
      new com.google.protobuf.AbstractParser<MitreAttack>() {
        @java.lang.Override
        public MitreAttack parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MitreAttack> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MitreAttack> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.MitreAttack getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
