/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/resource.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Information related to the Google Cloud resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Resource}
 */
public final class Resource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Resource)
    ResourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Resource.newBuilder() to construct.
  private Resource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Resource() {
    name_ = "";
    displayName_ = "";
    type_ = "";
    project_ = "";
    projectDisplayName_ = "";
    parent_ = "";
    parentDisplayName_ = "";
    folders_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Resource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.ResourceProto
        .internal_static_google_cloud_securitycenter_v1_Resource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.ResourceProto
        .internal_static_google_cloud_securitycenter_v1_Resource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Resource.class,
            com.google.cloud.securitycenter.v1.Resource.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The full resource name of the resource. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full resource name of the resource. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The human readable name of the resource.
   * </pre>
   *
   * <code>string display_name = 8;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human readable name of the resource.
   * </pre>
   *
   * <code>string display_name = 8;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The full resource type of the resource.
   * </pre>
   *
   * <code>string type = 6;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full resource type of the resource.
   * </pre>
   *
   * <code>string type = 6;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object project_ = "";
  /**
   *
   *
   * <pre>
   * The full resource name of project that the resource belongs to.
   * </pre>
   *
   * <code>string project = 2;</code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full resource name of project that the resource belongs to.
   * </pre>
   *
   * <code>string project = 2;</code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectDisplayName_ = "";
  /**
   *
   *
   * <pre>
   * The project ID that the resource belongs to.
   * </pre>
   *
   * <code>string project_display_name = 3;</code>
   *
   * @return The projectDisplayName.
   */
  @java.lang.Override
  public java.lang.String getProjectDisplayName() {
    java.lang.Object ref = projectDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project ID that the resource belongs to.
   * </pre>
   *
   * <code>string project_display_name = 3;</code>
   *
   * @return The bytes for projectDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectDisplayNameBytes() {
    java.lang.Object ref = projectDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * The full resource name of resource's parent.
   * </pre>
   *
   * <code>string parent = 4;</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full resource name of resource's parent.
   * </pre>
   *
   * <code>string parent = 4;</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentDisplayName_ = "";
  /**
   *
   *
   * <pre>
   * The human readable name of resource's parent.
   * </pre>
   *
   * <code>string parent_display_name = 5;</code>
   *
   * @return The parentDisplayName.
   */
  @java.lang.Override
  public java.lang.String getParentDisplayName() {
    java.lang.Object ref = parentDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human readable name of resource's parent.
   * </pre>
   *
   * <code>string parent_display_name = 5;</code>
   *
   * @return The bytes for parentDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentDisplayNameBytes() {
    java.lang.Object ref = parentDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FOLDERS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Folder> folders_;
  /**
   *
   *
   * <pre>
   * Output only. Contains a Folder message for each folder in the assets
   * ancestry. The first folder is the deepest nested folder, and the last
   * folder is the folder directly under the Organization.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Folder> getFoldersList() {
    return folders_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains a Folder message for each folder in the assets
   * ancestry. The first folder is the deepest nested folder, and the last
   * folder is the folder directly under the Organization.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.FolderOrBuilder>
      getFoldersOrBuilderList() {
    return folders_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains a Folder message for each folder in the assets
   * ancestry. The first folder is the deepest nested folder, and the last
   * folder is the folder directly under the Organization.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getFoldersCount() {
    return folders_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains a Folder message for each folder in the assets
   * ancestry. The first folder is the deepest nested folder, and the last
   * folder is the folder directly under the Organization.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Folder getFolders(int index) {
    return folders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains a Folder message for each folder in the assets
   * ancestry. The first folder is the deepest nested folder, and the last
   * folder is the folder directly under the Organization.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.FolderOrBuilder getFoldersOrBuilder(int index) {
    return folders_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, projectDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, parentDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, type_);
    }
    for (int i = 0; i < folders_.size(); i++) {
      output.writeMessage(7, folders_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, projectDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, parentDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, type_);
    }
    for (int i = 0; i < folders_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, folders_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Resource)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Resource other =
        (com.google.cloud.securitycenter.v1.Resource) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getProject().equals(other.getProject())) return false;
    if (!getProjectDisplayName().equals(other.getProjectDisplayName())) return false;
    if (!getParent().equals(other.getParent())) return false;
    if (!getParentDisplayName().equals(other.getParentDisplayName())) return false;
    if (!getFoldersList().equals(other.getFoldersList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    hash = (37 * hash) + PROJECT_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getProjectDisplayName().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PARENT_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getParentDisplayName().hashCode();
    if (getFoldersCount() > 0) {
      hash = (37 * hash) + FOLDERS_FIELD_NUMBER;
      hash = (53 * hash) + getFoldersList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Resource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Resource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information related to the Google Cloud resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Resource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Resource)
      com.google.cloud.securitycenter.v1.ResourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.ResourceProto
          .internal_static_google_cloud_securitycenter_v1_Resource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.ResourceProto
          .internal_static_google_cloud_securitycenter_v1_Resource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Resource.class,
              com.google.cloud.securitycenter.v1.Resource.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Resource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      type_ = "";
      project_ = "";
      projectDisplayName_ = "";
      parent_ = "";
      parentDisplayName_ = "";
      if (foldersBuilder_ == null) {
        folders_ = java.util.Collections.emptyList();
      } else {
        folders_ = null;
        foldersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.ResourceProto
          .internal_static_google_cloud_securitycenter_v1_Resource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Resource getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Resource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Resource build() {
      com.google.cloud.securitycenter.v1.Resource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Resource buildPartial() {
      com.google.cloud.securitycenter.v1.Resource result =
          new com.google.cloud.securitycenter.v1.Resource(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.securitycenter.v1.Resource result) {
      if (foldersBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          folders_ = java.util.Collections.unmodifiableList(folders_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.folders_ = folders_;
      } else {
        result.folders_ = foldersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Resource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.project_ = project_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.projectDisplayName_ = projectDisplayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.parentDisplayName_ = parentDisplayName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Resource) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Resource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Resource other) {
      if (other == com.google.cloud.securitycenter.v1.Resource.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getProjectDisplayName().isEmpty()) {
        projectDisplayName_ = other.projectDisplayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getParentDisplayName().isEmpty()) {
        parentDisplayName_ = other.parentDisplayName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (foldersBuilder_ == null) {
        if (!other.folders_.isEmpty()) {
          if (folders_.isEmpty()) {
            folders_ = other.folders_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureFoldersIsMutable();
            folders_.addAll(other.folders_);
          }
          onChanged();
        }
      } else {
        if (!other.folders_.isEmpty()) {
          if (foldersBuilder_.isEmpty()) {
            foldersBuilder_.dispose();
            foldersBuilder_ = null;
            folders_ = other.folders_;
            bitField0_ = (bitField0_ & ~0x00000080);
            foldersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFoldersFieldBuilder()
                    : null;
          } else {
            foldersBuilder_.addAllMessages(other.folders_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                project_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                projectDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                parentDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.securitycenter.v1.Folder m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Folder.parser(), extensionRegistry);
                if (foldersBuilder_ == null) {
                  ensureFoldersIsMutable();
                  folders_.add(m);
                } else {
                  foldersBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The human readable name of the resource.
     * </pre>
     *
     * <code>string display_name = 8;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human readable name of the resource.
     * </pre>
     *
     * <code>string display_name = 8;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human readable name of the resource.
     * </pre>
     *
     * <code>string display_name = 8;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human readable name of the resource.
     * </pre>
     *
     * <code>string display_name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human readable name of the resource.
     * </pre>
     *
     * <code>string display_name = 8;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The full resource type of the resource.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource type of the resource.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource type of the resource.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource type of the resource.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource type of the resource.
     * </pre>
     *
     * <code>string type = 6;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name of project that the resource belongs to.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of project that the resource belongs to.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of project that the resource belongs to.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      project_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of project that the resource belongs to.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {
      project_ = getDefaultInstance().getProject();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of project that the resource belongs to.
     * </pre>
     *
     * <code>string project = 2;</code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      project_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object projectDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * The project ID that the resource belongs to.
     * </pre>
     *
     * <code>string project_display_name = 3;</code>
     *
     * @return The projectDisplayName.
     */
    public java.lang.String getProjectDisplayName() {
      java.lang.Object ref = projectDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project ID that the resource belongs to.
     * </pre>
     *
     * <code>string project_display_name = 3;</code>
     *
     * @return The bytes for projectDisplayName.
     */
    public com.google.protobuf.ByteString getProjectDisplayNameBytes() {
      java.lang.Object ref = projectDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project ID that the resource belongs to.
     * </pre>
     *
     * <code>string project_display_name = 3;</code>
     *
     * @param value The projectDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setProjectDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectDisplayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project ID that the resource belongs to.
     * </pre>
     *
     * <code>string project_display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectDisplayName() {
      projectDisplayName_ = getDefaultInstance().getProjectDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project ID that the resource belongs to.
     * </pre>
     *
     * <code>string project_display_name = 3;</code>
     *
     * @param value The bytes for projectDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setProjectDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectDisplayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name of resource's parent.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of resource's parent.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of resource's parent.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of resource's parent.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of resource's parent.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object parentDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * The human readable name of resource's parent.
     * </pre>
     *
     * <code>string parent_display_name = 5;</code>
     *
     * @return The parentDisplayName.
     */
    public java.lang.String getParentDisplayName() {
      java.lang.Object ref = parentDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human readable name of resource's parent.
     * </pre>
     *
     * <code>string parent_display_name = 5;</code>
     *
     * @return The bytes for parentDisplayName.
     */
    public com.google.protobuf.ByteString getParentDisplayNameBytes() {
      java.lang.Object ref = parentDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human readable name of resource's parent.
     * </pre>
     *
     * <code>string parent_display_name = 5;</code>
     *
     * @param value The parentDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentDisplayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human readable name of resource's parent.
     * </pre>
     *
     * <code>string parent_display_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentDisplayName() {
      parentDisplayName_ = getDefaultInstance().getParentDisplayName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human readable name of resource's parent.
     * </pre>
     *
     * <code>string parent_display_name = 5;</code>
     *
     * @param value The bytes for parentDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentDisplayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Folder> folders_ =
        java.util.Collections.emptyList();

    private void ensureFoldersIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        folders_ = new java.util.ArrayList<com.google.cloud.securitycenter.v1.Folder>(folders_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Folder,
            com.google.cloud.securitycenter.v1.Folder.Builder,
            com.google.cloud.securitycenter.v1.FolderOrBuilder>
        foldersBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Folder> getFoldersList() {
      if (foldersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(folders_);
      } else {
        return foldersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getFoldersCount() {
      if (foldersBuilder_ == null) {
        return folders_.size();
      } else {
        return foldersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Folder getFolders(int index) {
      if (foldersBuilder_ == null) {
        return folders_.get(index);
      } else {
        return foldersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFolders(int index, com.google.cloud.securitycenter.v1.Folder value) {
      if (foldersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFoldersIsMutable();
        folders_.set(index, value);
        onChanged();
      } else {
        foldersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFolders(
        int index, com.google.cloud.securitycenter.v1.Folder.Builder builderForValue) {
      if (foldersBuilder_ == null) {
        ensureFoldersIsMutable();
        folders_.set(index, builderForValue.build());
        onChanged();
      } else {
        foldersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addFolders(com.google.cloud.securitycenter.v1.Folder value) {
      if (foldersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFoldersIsMutable();
        folders_.add(value);
        onChanged();
      } else {
        foldersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addFolders(int index, com.google.cloud.securitycenter.v1.Folder value) {
      if (foldersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFoldersIsMutable();
        folders_.add(index, value);
        onChanged();
      } else {
        foldersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addFolders(com.google.cloud.securitycenter.v1.Folder.Builder builderForValue) {
      if (foldersBuilder_ == null) {
        ensureFoldersIsMutable();
        folders_.add(builderForValue.build());
        onChanged();
      } else {
        foldersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addFolders(
        int index, com.google.cloud.securitycenter.v1.Folder.Builder builderForValue) {
      if (foldersBuilder_ == null) {
        ensureFoldersIsMutable();
        folders_.add(index, builderForValue.build());
        onChanged();
      } else {
        foldersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllFolders(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Folder> values) {
      if (foldersBuilder_ == null) {
        ensureFoldersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, folders_);
        onChanged();
      } else {
        foldersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFolders() {
      if (foldersBuilder_ == null) {
        folders_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        foldersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeFolders(int index) {
      if (foldersBuilder_ == null) {
        ensureFoldersIsMutable();
        folders_.remove(index);
        onChanged();
      } else {
        foldersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Folder.Builder getFoldersBuilder(int index) {
      return getFoldersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.FolderOrBuilder getFoldersOrBuilder(int index) {
      if (foldersBuilder_ == null) {
        return folders_.get(index);
      } else {
        return foldersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.FolderOrBuilder>
        getFoldersOrBuilderList() {
      if (foldersBuilder_ != null) {
        return foldersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(folders_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Folder.Builder addFoldersBuilder() {
      return getFoldersFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Folder.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Folder.Builder addFoldersBuilder(int index) {
      return getFoldersFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.Folder.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.Folder folders = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Folder.Builder>
        getFoldersBuilderList() {
      return getFoldersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Folder,
            com.google.cloud.securitycenter.v1.Folder.Builder,
            com.google.cloud.securitycenter.v1.FolderOrBuilder>
        getFoldersFieldBuilder() {
      if (foldersBuilder_ == null) {
        foldersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Folder,
                com.google.cloud.securitycenter.v1.Folder.Builder,
                com.google.cloud.securitycenter.v1.FolderOrBuilder>(
                folders_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        folders_ = null;
      }
      return foldersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Resource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Resource)
  private static final com.google.cloud.securitycenter.v1.Resource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Resource();
  }

  public static com.google.cloud.securitycenter.v1.Resource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Resource> PARSER =
      new com.google.protobuf.AbstractParser<Resource>() {
        @java.lang.Override
        public Resource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Resource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Resource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Resource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
