/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/security_health_analytics_custom_module.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Represents an instance of a Security Health Analytics custom module,
 * including its full module name, display name, enablement state, and last
 * updated time. You can create a custom module at the organization, folder, or
 * project level. Custom modules that you create at the organization or folder
 * level are inherited by the child folders and projects.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule}
 */
public final class SecurityHealthAnalyticsCustomModule
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule)
    SecurityHealthAnalyticsCustomModuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecurityHealthAnalyticsCustomModule.newBuilder() to construct.
  private SecurityHealthAnalyticsCustomModule(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityHealthAnalyticsCustomModule() {
    name_ = "";
    displayName_ = "";
    enablementState_ = 0;
    lastEditor_ = "";
    ancestorModule_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityHealthAnalyticsCustomModule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModuleProto
        .internal_static_google_cloud_securitycenter_v1_SecurityHealthAnalyticsCustomModule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModuleProto
        .internal_static_google_cloud_securitycenter_v1_SecurityHealthAnalyticsCustomModule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.class,
            com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible enablement states of a custom module.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState}
   */
  public enum EnablementState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified enablement state.
     * </pre>
     *
     * <code>ENABLEMENT_STATE_UNSPECIFIED = 0;</code>
     */
    ENABLEMENT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The module is enabled at the given CRM resource.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * The module is disabled at the given CRM resource.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     *
     *
     * <pre>
     * State is inherited from an ancestor module. The module will either
     * be effectively ENABLED or DISABLED based on its closest non-inherited
     * ancestor module in the CRM hierarchy.
     * </pre>
     *
     * <code>INHERITED = 3;</code>
     */
    INHERITED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified enablement state.
     * </pre>
     *
     * <code>ENABLEMENT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int ENABLEMENT_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The module is enabled at the given CRM resource.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The module is disabled at the given CRM resource.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * State is inherited from an ancestor module. The module will either
     * be effectively ENABLED or DISABLED based on its closest non-inherited
     * ancestor module in the CRM hierarchy.
     * </pre>
     *
     * <code>INHERITED = 3;</code>
     */
    public static final int INHERITED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EnablementState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EnablementState forNumber(int value) {
      switch (value) {
        case 0:
          return ENABLEMENT_STATE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        case 3:
          return INHERITED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EnablementState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EnablementState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EnablementState>() {
              public EnablementState findValueByNumber(int number) {
                return EnablementState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EnablementState[] VALUES = values();

    public static EnablementState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EnablementState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the custom module.
   * Its format is
   * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
   * or
   * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
   * or
   * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
   *
   * The id {customModule} is server-generated and is not user settable.
   * It will be a numeric id containing 1-20 digits.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the custom module.
   * Its format is
   * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
   * or
   * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
   * or
   * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
   *
   * The id {customModule} is server-generated and is not user settable.
   * It will be a numeric id containing 1-20 digits.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the Security Health Analytics custom module. This
   * display name becomes the finding category for all findings that are
   * returned by this custom module. The display name must be between 1 and
   * 128 characters, start with a lowercase letter, and contain alphanumeric
   * characters or underscores only.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the Security Health Analytics custom module. This
   * display name becomes the finding category for all findings that are
   * returned by this custom module. The display name must be between 1 and
   * 128 characters, start with a lowercase letter, and contain alphanumeric
   * characters or underscores only.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLEMENT_STATE_FIELD_NUMBER = 4;
  private int enablementState_ = 0;
  /**
   *
   *
   * <pre>
   * The enablement state of the custom module.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for enablementState.
   */
  @java.lang.Override
  public int getEnablementStateValue() {
    return enablementState_;
  }
  /**
   *
   *
   * <pre>
   * The enablement state of the custom module.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;
   * </code>
   *
   * @return The enablementState.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
      getEnablementState() {
    com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState result =
        com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
            .forNumber(enablementState_);
    return result == null
        ? com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
            .UNRECOGNIZED
        : result;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the custom module was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the custom module was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the custom module was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LAST_EDITOR_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastEditor_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The editor that last updated the custom module.
   * </pre>
   *
   * <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The lastEditor.
   */
  @java.lang.Override
  public java.lang.String getLastEditor() {
    java.lang.Object ref = lastEditor_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastEditor_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The editor that last updated the custom module.
   * </pre>
   *
   * <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for lastEditor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastEditorBytes() {
    java.lang.Object ref = lastEditor_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastEditor_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANCESTOR_MODULE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ancestorModule_ = "";
  /**
   *
   *
   * <pre>
   * Output only. If empty, indicates that the custom module was created in the
   * organization, folder, or project in which you are viewing the custom
   * module. Otherwise, `ancestor_module` specifies the organization or folder
   * from which the custom module is inherited.
   * </pre>
   *
   * <code>
   * string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The ancestorModule.
   */
  @java.lang.Override
  public java.lang.String getAncestorModule() {
    java.lang.Object ref = ancestorModule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ancestorModule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. If empty, indicates that the custom module was created in the
   * organization, folder, or project in which you are viewing the custom
   * module. Otherwise, `ancestor_module` specifies the organization or folder
   * from which the custom module is inherited.
   * </pre>
   *
   * <code>
   * string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for ancestorModule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAncestorModuleBytes() {
    java.lang.Object ref = ancestorModule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ancestorModule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.securitycenter.v1.CustomConfig customConfig_;
  /**
   *
   *
   * <pre>
   * The user specified custom configuration for the module.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
   *
   * @return Whether the customConfig field is set.
   */
  @java.lang.Override
  public boolean hasCustomConfig() {
    return customConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The user specified custom configuration for the module.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
   *
   * @return The customConfig.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfig getCustomConfig() {
    return customConfig_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
        : customConfig_;
  }
  /**
   *
   *
   * <pre>
   * The user specified custom configuration for the module.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfigOrBuilder getCustomConfigOrBuilder() {
    return customConfig_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
        : customConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (enablementState_
        != com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
            .ENABLEMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, enablementState_);
    }
    if (updateTime_ != null) {
      output.writeMessage(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastEditor_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, lastEditor_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ancestorModule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, ancestorModule_);
    }
    if (customConfig_ != null) {
      output.writeMessage(8, getCustomConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (enablementState_
        != com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
            .ENABLEMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, enablementState_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastEditor_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, lastEditor_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ancestorModule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, ancestorModule_);
    }
    if (customConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCustomConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule other =
        (com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (enablementState_ != other.enablementState_) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getLastEditor().equals(other.getLastEditor())) return false;
    if (!getAncestorModule().equals(other.getAncestorModule())) return false;
    if (hasCustomConfig() != other.hasCustomConfig()) return false;
    if (hasCustomConfig()) {
      if (!getCustomConfig().equals(other.getCustomConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + ENABLEMENT_STATE_FIELD_NUMBER;
    hash = (53 * hash) + enablementState_;
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + LAST_EDITOR_FIELD_NUMBER;
    hash = (53 * hash) + getLastEditor().hashCode();
    hash = (37 * hash) + ANCESTOR_MODULE_FIELD_NUMBER;
    hash = (53 * hash) + getAncestorModule().hashCode();
    if (hasCustomConfig()) {
      hash = (37 * hash) + CUSTOM_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCustomConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an instance of a Security Health Analytics custom module,
   * including its full module name, display name, enablement state, and last
   * updated time. You can create a custom module at the organization, folder, or
   * project level. Custom modules that you create at the organization or folder
   * level are inherited by the child folders and projects.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule)
      com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModuleProto
          .internal_static_google_cloud_securitycenter_v1_SecurityHealthAnalyticsCustomModule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModuleProto
          .internal_static_google_cloud_securitycenter_v1_SecurityHealthAnalyticsCustomModule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.class,
              com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.Builder.class);
    }

    // Construct using
    // com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      enablementState_ = 0;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      lastEditor_ = "";
      ancestorModule_ = "";
      customConfig_ = null;
      if (customConfigBuilder_ != null) {
        customConfigBuilder_.dispose();
        customConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModuleProto
          .internal_static_google_cloud_securitycenter_v1_SecurityHealthAnalyticsCustomModule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
        getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule build() {
      com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule buildPartial() {
      com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule result =
          new com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enablementState_ = enablementState_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.lastEditor_ = lastEditor_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ancestorModule_ = ancestorModule_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.customConfig_ =
            customConfigBuilder_ == null ? customConfig_ : customConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule) {
        return mergeFrom(
            (com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule other) {
      if (other
          == com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
              .getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.enablementState_ != 0) {
        setEnablementStateValue(other.getEnablementStateValue());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getLastEditor().isEmpty()) {
        lastEditor_ = other.lastEditor_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getAncestorModule().isEmpty()) {
        ancestorModule_ = other.ancestorModule_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasCustomConfig()) {
        mergeCustomConfig(other.getCustomConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 32:
              {
                enablementState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                lastEditor_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                ancestorModule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getCustomConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
     *
     * The id {customModule} is server-generated and is not user settable.
     * It will be a numeric id containing 1-20 digits.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
     *
     * The id {customModule} is server-generated and is not user settable.
     * It will be a numeric id containing 1-20 digits.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
     *
     * The id {customModule} is server-generated and is not user settable.
     * It will be a numeric id containing 1-20 digits.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
     *
     * The id {customModule} is server-generated and is not user settable.
     * It will be a numeric id containing 1-20 digits.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
     *
     * The id {customModule} is server-generated and is not user settable.
     * It will be a numeric id containing 1-20 digits.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the Security Health Analytics custom module. This
     * display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and
     * 128 characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the Security Health Analytics custom module. This
     * display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and
     * 128 characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the Security Health Analytics custom module. This
     * display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and
     * 128 characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the Security Health Analytics custom module. This
     * display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and
     * 128 characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the Security Health Analytics custom module. This
     * display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and
     * 128 characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int enablementState_ = 0;
    /**
     *
     *
     * <pre>
     * The enablement state of the custom module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for enablementState.
     */
    @java.lang.Override
    public int getEnablementStateValue() {
      return enablementState_;
    }
    /**
     *
     *
     * <pre>
     * The enablement state of the custom module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for enablementState to set.
     * @return This builder for chaining.
     */
    public Builder setEnablementStateValue(int value) {
      enablementState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The enablement state of the custom module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;
     * </code>
     *
     * @return The enablementState.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
        getEnablementState() {
      com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
          result =
              com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
                  .forNumber(enablementState_);
      return result == null
          ? com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The enablement state of the custom module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;
     * </code>
     *
     * @param value The enablementState to set.
     * @return This builder for chaining.
     */
    public Builder setEnablementState(
        com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      enablementState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The enablement state of the custom module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnablementState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enablementState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the custom module was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the custom module was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the custom module was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the custom module was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the custom module was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the custom module was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the custom module was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the custom module was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the custom module was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object lastEditor_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The editor that last updated the custom module.
     * </pre>
     *
     * <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The lastEditor.
     */
    public java.lang.String getLastEditor() {
      java.lang.Object ref = lastEditor_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastEditor_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The editor that last updated the custom module.
     * </pre>
     *
     * <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for lastEditor.
     */
    public com.google.protobuf.ByteString getLastEditorBytes() {
      java.lang.Object ref = lastEditor_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastEditor_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The editor that last updated the custom module.
     * </pre>
     *
     * <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The lastEditor to set.
     * @return This builder for chaining.
     */
    public Builder setLastEditor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastEditor_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The editor that last updated the custom module.
     * </pre>
     *
     * <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastEditor() {
      lastEditor_ = getDefaultInstance().getLastEditor();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The editor that last updated the custom module.
     * </pre>
     *
     * <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for lastEditor to set.
     * @return This builder for chaining.
     */
    public Builder setLastEditorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastEditor_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object ancestorModule_ = "";
    /**
     *
     *
     * <pre>
     * Output only. If empty, indicates that the custom module was created in the
     * organization, folder, or project in which you are viewing the custom
     * module. Otherwise, `ancestor_module` specifies the organization or folder
     * from which the custom module is inherited.
     * </pre>
     *
     * <code>
     * string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The ancestorModule.
     */
    public java.lang.String getAncestorModule() {
      java.lang.Object ref = ancestorModule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ancestorModule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If empty, indicates that the custom module was created in the
     * organization, folder, or project in which you are viewing the custom
     * module. Otherwise, `ancestor_module` specifies the organization or folder
     * from which the custom module is inherited.
     * </pre>
     *
     * <code>
     * string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for ancestorModule.
     */
    public com.google.protobuf.ByteString getAncestorModuleBytes() {
      java.lang.Object ref = ancestorModule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ancestorModule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If empty, indicates that the custom module was created in the
     * organization, folder, or project in which you are viewing the custom
     * module. Otherwise, `ancestor_module` specifies the organization or folder
     * from which the custom module is inherited.
     * </pre>
     *
     * <code>
     * string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The ancestorModule to set.
     * @return This builder for chaining.
     */
    public Builder setAncestorModule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ancestorModule_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If empty, indicates that the custom module was created in the
     * organization, folder, or project in which you are viewing the custom
     * module. Otherwise, `ancestor_module` specifies the organization or folder
     * from which the custom module is inherited.
     * </pre>
     *
     * <code>
     * string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAncestorModule() {
      ancestorModule_ = getDefaultInstance().getAncestorModule();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If empty, indicates that the custom module was created in the
     * organization, folder, or project in which you are viewing the custom
     * module. Otherwise, `ancestor_module` specifies the organization or folder
     * from which the custom module is inherited.
     * </pre>
     *
     * <code>
     * string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for ancestorModule to set.
     * @return This builder for chaining.
     */
    public Builder setAncestorModuleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ancestorModule_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1.CustomConfig customConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig,
            com.google.cloud.securitycenter.v1.CustomConfig.Builder,
            com.google.cloud.securitycenter.v1.CustomConfigOrBuilder>
        customConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The user specified custom configuration for the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     *
     * @return Whether the customConfig field is set.
     */
    public boolean hasCustomConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The user specified custom configuration for the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     *
     * @return The customConfig.
     */
    public com.google.cloud.securitycenter.v1.CustomConfig getCustomConfig() {
      if (customConfigBuilder_ == null) {
        return customConfig_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
            : customConfig_;
      } else {
        return customConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The user specified custom configuration for the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     */
    public Builder setCustomConfig(com.google.cloud.securitycenter.v1.CustomConfig value) {
      if (customConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customConfig_ = value;
      } else {
        customConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user specified custom configuration for the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     */
    public Builder setCustomConfig(
        com.google.cloud.securitycenter.v1.CustomConfig.Builder builderForValue) {
      if (customConfigBuilder_ == null) {
        customConfig_ = builderForValue.build();
      } else {
        customConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user specified custom configuration for the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     */
    public Builder mergeCustomConfig(com.google.cloud.securitycenter.v1.CustomConfig value) {
      if (customConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && customConfig_ != null
            && customConfig_
                != com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()) {
          getCustomConfigBuilder().mergeFrom(value);
        } else {
          customConfig_ = value;
        }
      } else {
        customConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user specified custom configuration for the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     */
    public Builder clearCustomConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      customConfig_ = null;
      if (customConfigBuilder_ != null) {
        customConfigBuilder_.dispose();
        customConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user specified custom configuration for the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfig.Builder getCustomConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCustomConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The user specified custom configuration for the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfigOrBuilder getCustomConfigOrBuilder() {
      if (customConfigBuilder_ != null) {
        return customConfigBuilder_.getMessageOrBuilder();
      } else {
        return customConfig_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
            : customConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The user specified custom configuration for the module.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig,
            com.google.cloud.securitycenter.v1.CustomConfig.Builder,
            com.google.cloud.securitycenter.v1.CustomConfigOrBuilder>
        getCustomConfigFieldBuilder() {
      if (customConfigBuilder_ == null) {
        customConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.CustomConfig,
                com.google.cloud.securitycenter.v1.CustomConfig.Builder,
                com.google.cloud.securitycenter.v1.CustomConfigOrBuilder>(
                getCustomConfig(), getParentForChildren(), isClean());
        customConfig_ = null;
      }
      return customConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule)
  private static final com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule();
  }

  public static com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecurityHealthAnalyticsCustomModule> PARSER =
      new com.google.protobuf.AbstractParser<SecurityHealthAnalyticsCustomModule>() {
        @java.lang.Override
        public SecurityHealthAnalyticsCustomModule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecurityHealthAnalyticsCustomModule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityHealthAnalyticsCustomModule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
