/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/access.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Represents an access event.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Access}
 */
public final class Access extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Access)
    AccessOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Access.newBuilder() to construct.
  private Access(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Access() {
    principalEmail_ = "";
    callerIp_ = "";
    userAgentFamily_ = "";
    userAgent_ = "";
    serviceName_ = "";
    methodName_ = "";
    principalSubject_ = "";
    serviceAccountKeyName_ = "";
    serviceAccountDelegationInfo_ = java.util.Collections.emptyList();
    userName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Access();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.AccessProto
        .internal_static_google_cloud_securitycenter_v1_Access_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.AccessProto
        .internal_static_google_cloud_securitycenter_v1_Access_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Access.class,
            com.google.cloud.securitycenter.v1.Access.Builder.class);
  }

  private int bitField0_;
  public static final int PRINCIPAL_EMAIL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object principalEmail_ = "";
  /**
   *
   *
   * <pre>
   * Associated email, such as "foo&#64;google.com".
   *
   * The email address of the authenticated user or a service account acting on
   * behalf of a third party principal making the request. For third party
   * identity callers, the `principal_subject` field is populated instead of
   * this field. For privacy reasons, the principal email address is sometimes
   * redacted. For more information, see [Caller identities in audit
   * logs](https://cloud.google.com/logging/docs/audit#user-id).
   * </pre>
   *
   * <code>string principal_email = 1;</code>
   *
   * @return The principalEmail.
   */
  @java.lang.Override
  public java.lang.String getPrincipalEmail() {
    java.lang.Object ref = principalEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      principalEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Associated email, such as "foo&#64;google.com".
   *
   * The email address of the authenticated user or a service account acting on
   * behalf of a third party principal making the request. For third party
   * identity callers, the `principal_subject` field is populated instead of
   * this field. For privacy reasons, the principal email address is sometimes
   * redacted. For more information, see [Caller identities in audit
   * logs](https://cloud.google.com/logging/docs/audit#user-id).
   * </pre>
   *
   * <code>string principal_email = 1;</code>
   *
   * @return The bytes for principalEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrincipalEmailBytes() {
    java.lang.Object ref = principalEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      principalEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CALLER_IP_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object callerIp_ = "";
  /**
   *
   *
   * <pre>
   * Caller's IP address, such as "1.1.1.1".
   * </pre>
   *
   * <code>string caller_ip = 2;</code>
   *
   * @return The callerIp.
   */
  @java.lang.Override
  public java.lang.String getCallerIp() {
    java.lang.Object ref = callerIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      callerIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Caller's IP address, such as "1.1.1.1".
   * </pre>
   *
   * <code>string caller_ip = 2;</code>
   *
   * @return The bytes for callerIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCallerIpBytes() {
    java.lang.Object ref = callerIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      callerIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CALLER_IP_GEO_FIELD_NUMBER = 3;
  private com.google.cloud.securitycenter.v1.Geolocation callerIpGeo_;
  /**
   *
   *
   * <pre>
   * The caller IP's geolocation, which identifies where the call came from.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
   *
   * @return Whether the callerIpGeo field is set.
   */
  @java.lang.Override
  public boolean hasCallerIpGeo() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The caller IP's geolocation, which identifies where the call came from.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
   *
   * @return The callerIpGeo.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Geolocation getCallerIpGeo() {
    return callerIpGeo_ == null
        ? com.google.cloud.securitycenter.v1.Geolocation.getDefaultInstance()
        : callerIpGeo_;
  }
  /**
   *
   *
   * <pre>
   * The caller IP's geolocation, which identifies where the call came from.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.GeolocationOrBuilder getCallerIpGeoOrBuilder() {
    return callerIpGeo_ == null
        ? com.google.cloud.securitycenter.v1.Geolocation.getDefaultInstance()
        : callerIpGeo_;
  }

  public static final int USER_AGENT_FAMILY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userAgentFamily_ = "";
  /**
   *
   *
   * <pre>
   * Type of user agent associated with the finding. For example, an operating
   * system shell or an embedded or standalone application.
   * </pre>
   *
   * <code>string user_agent_family = 4;</code>
   *
   * @return The userAgentFamily.
   */
  @java.lang.Override
  public java.lang.String getUserAgentFamily() {
    java.lang.Object ref = userAgentFamily_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userAgentFamily_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of user agent associated with the finding. For example, an operating
   * system shell or an embedded or standalone application.
   * </pre>
   *
   * <code>string user_agent_family = 4;</code>
   *
   * @return The bytes for userAgentFamily.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserAgentFamilyBytes() {
    java.lang.Object ref = userAgentFamily_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userAgentFamily_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_AGENT_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userAgent_ = "";
  /**
   *
   *
   * <pre>
   * The caller's user agent string associated with the finding.
   * </pre>
   *
   * <code>string user_agent = 12;</code>
   *
   * @return The userAgent.
   */
  @java.lang.Override
  public java.lang.String getUserAgent() {
    java.lang.Object ref = userAgent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userAgent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The caller's user agent string associated with the finding.
   * </pre>
   *
   * <code>string user_agent = 12;</code>
   *
   * @return The bytes for userAgent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserAgentBytes() {
    java.lang.Object ref = userAgent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userAgent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceName_ = "";
  /**
   *
   *
   * <pre>
   * This is the API service that the service account made a call to, e.g.
   * "iam.googleapis.com"
   * </pre>
   *
   * <code>string service_name = 5;</code>
   *
   * @return The serviceName.
   */
  @java.lang.Override
  public java.lang.String getServiceName() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This is the API service that the service account made a call to, e.g.
   * "iam.googleapis.com"
   * </pre>
   *
   * <code>string service_name = 5;</code>
   *
   * @return The bytes for serviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceNameBytes() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METHOD_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object methodName_ = "";
  /**
   *
   *
   * <pre>
   * The method that the service account called, e.g. "SetIamPolicy".
   * </pre>
   *
   * <code>string method_name = 6;</code>
   *
   * @return The methodName.
   */
  @java.lang.Override
  public java.lang.String getMethodName() {
    java.lang.Object ref = methodName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      methodName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The method that the service account called, e.g. "SetIamPolicy".
   * </pre>
   *
   * <code>string method_name = 6;</code>
   *
   * @return The bytes for methodName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMethodNameBytes() {
    java.lang.Object ref = methodName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      methodName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRINCIPAL_SUBJECT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object principalSubject_ = "";
  /**
   *
   *
   * <pre>
   * A string that represents the principal_subject that is associated with the
   * identity. Unlike `principal_email`, `principal_subject` supports principals
   * that aren't associated with email addresses, such as third party
   * principals. For most identities, the format is
   * `principal://iam.googleapis.com/{identity pool name}/subject/{subject}`.
   * Some GKE identities, such as GKE_WORKLOAD, FREEFORM, and GKE_HUB_WORKLOAD,
   * still use the legacy format `serviceAccount:{identity pool
   * name}[{subject}]`.
   * </pre>
   *
   * <code>string principal_subject = 7;</code>
   *
   * @return The principalSubject.
   */
  @java.lang.Override
  public java.lang.String getPrincipalSubject() {
    java.lang.Object ref = principalSubject_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      principalSubject_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A string that represents the principal_subject that is associated with the
   * identity. Unlike `principal_email`, `principal_subject` supports principals
   * that aren't associated with email addresses, such as third party
   * principals. For most identities, the format is
   * `principal://iam.googleapis.com/{identity pool name}/subject/{subject}`.
   * Some GKE identities, such as GKE_WORKLOAD, FREEFORM, and GKE_HUB_WORKLOAD,
   * still use the legacy format `serviceAccount:{identity pool
   * name}[{subject}]`.
   * </pre>
   *
   * <code>string principal_subject = 7;</code>
   *
   * @return The bytes for principalSubject.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrincipalSubjectBytes() {
    java.lang.Object ref = principalSubject_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      principalSubject_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_KEY_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccountKeyName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the service account key that was used to create or exchange
   * credentials when authenticating the service account that made the request.
   * This is a scheme-less URI full resource name. For example:
   *
   * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}".
   * </pre>
   *
   * <code>string service_account_key_name = 8;</code>
   *
   * @return The serviceAccountKeyName.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountKeyName() {
    java.lang.Object ref = serviceAccountKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the service account key that was used to create or exchange
   * credentials when authenticating the service account that made the request.
   * This is a scheme-less URI full resource name. For example:
   *
   * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}".
   * </pre>
   *
   * <code>string service_account_key_name = 8;</code>
   *
   * @return The bytes for serviceAccountKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountKeyNameBytes() {
    java.lang.Object ref = serviceAccountKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_DELEGATION_INFO_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo>
      serviceAccountDelegationInfo_;
  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo>
      getServiceAccountDelegationInfoList() {
    return serviceAccountDelegationInfo_;
  }
  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfoOrBuilder>
      getServiceAccountDelegationInfoOrBuilderList() {
    return serviceAccountDelegationInfo_;
  }
  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  @java.lang.Override
  public int getServiceAccountDelegationInfoCount() {
    return serviceAccountDelegationInfo_.size();
  }
  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo
      getServiceAccountDelegationInfo(int index) {
    return serviceAccountDelegationInfo_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfoOrBuilder
      getServiceAccountDelegationInfoOrBuilder(int index) {
    return serviceAccountDelegationInfo_.get(index);
  }

  public static final int USER_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userName_ = "";
  /**
   *
   *
   * <pre>
   * A string that represents a username. The username provided depends on the
   * type of the finding and is likely not an IAM principal. For example, this
   * can be a system username if the finding is related to a virtual machine, or
   * it can be an application login username.
   * </pre>
   *
   * <code>string user_name = 11;</code>
   *
   * @return The userName.
   */
  @java.lang.Override
  public java.lang.String getUserName() {
    java.lang.Object ref = userName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A string that represents a username. The username provided depends on the
   * type of the finding and is likely not an IAM principal. For example, this
   * can be a system username if the finding is related to a virtual machine, or
   * it can be an application login username.
   * </pre>
   *
   * <code>string user_name = 11;</code>
   *
   * @return The bytes for userName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserNameBytes() {
    java.lang.Object ref = userName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principalEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, principalEmail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(callerIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, callerIp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCallerIpGeo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userAgentFamily_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, userAgentFamily_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(methodName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, methodName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principalSubject_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, principalSubject_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, serviceAccountKeyName_);
    }
    for (int i = 0; i < serviceAccountDelegationInfo_.size(); i++) {
      output.writeMessage(9, serviceAccountDelegationInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, userName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userAgent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, userAgent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principalEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, principalEmail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(callerIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, callerIp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCallerIpGeo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userAgentFamily_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, userAgentFamily_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(methodName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, methodName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principalSubject_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, principalSubject_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, serviceAccountKeyName_);
    }
    for (int i = 0; i < serviceAccountDelegationInfo_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, serviceAccountDelegationInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, userName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userAgent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, userAgent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Access)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Access other =
        (com.google.cloud.securitycenter.v1.Access) obj;

    if (!getPrincipalEmail().equals(other.getPrincipalEmail())) return false;
    if (!getCallerIp().equals(other.getCallerIp())) return false;
    if (hasCallerIpGeo() != other.hasCallerIpGeo()) return false;
    if (hasCallerIpGeo()) {
      if (!getCallerIpGeo().equals(other.getCallerIpGeo())) return false;
    }
    if (!getUserAgentFamily().equals(other.getUserAgentFamily())) return false;
    if (!getUserAgent().equals(other.getUserAgent())) return false;
    if (!getServiceName().equals(other.getServiceName())) return false;
    if (!getMethodName().equals(other.getMethodName())) return false;
    if (!getPrincipalSubject().equals(other.getPrincipalSubject())) return false;
    if (!getServiceAccountKeyName().equals(other.getServiceAccountKeyName())) return false;
    if (!getServiceAccountDelegationInfoList().equals(other.getServiceAccountDelegationInfoList()))
      return false;
    if (!getUserName().equals(other.getUserName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRINCIPAL_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getPrincipalEmail().hashCode();
    hash = (37 * hash) + CALLER_IP_FIELD_NUMBER;
    hash = (53 * hash) + getCallerIp().hashCode();
    if (hasCallerIpGeo()) {
      hash = (37 * hash) + CALLER_IP_GEO_FIELD_NUMBER;
      hash = (53 * hash) + getCallerIpGeo().hashCode();
    }
    hash = (37 * hash) + USER_AGENT_FAMILY_FIELD_NUMBER;
    hash = (53 * hash) + getUserAgentFamily().hashCode();
    hash = (37 * hash) + USER_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + getUserAgent().hashCode();
    hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceName().hashCode();
    hash = (37 * hash) + METHOD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getMethodName().hashCode();
    hash = (37 * hash) + PRINCIPAL_SUBJECT_FIELD_NUMBER;
    hash = (53 * hash) + getPrincipalSubject().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountKeyName().hashCode();
    if (getServiceAccountDelegationInfoCount() > 0) {
      hash = (37 * hash) + SERVICE_ACCOUNT_DELEGATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountDelegationInfoList().hashCode();
    }
    hash = (37 * hash) + USER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getUserName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Access parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Access parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Access parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Access prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an access event.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Access}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Access)
      com.google.cloud.securitycenter.v1.AccessOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.AccessProto
          .internal_static_google_cloud_securitycenter_v1_Access_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.AccessProto
          .internal_static_google_cloud_securitycenter_v1_Access_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Access.class,
              com.google.cloud.securitycenter.v1.Access.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Access.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCallerIpGeoFieldBuilder();
        getServiceAccountDelegationInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      principalEmail_ = "";
      callerIp_ = "";
      callerIpGeo_ = null;
      if (callerIpGeoBuilder_ != null) {
        callerIpGeoBuilder_.dispose();
        callerIpGeoBuilder_ = null;
      }
      userAgentFamily_ = "";
      userAgent_ = "";
      serviceName_ = "";
      methodName_ = "";
      principalSubject_ = "";
      serviceAccountKeyName_ = "";
      if (serviceAccountDelegationInfoBuilder_ == null) {
        serviceAccountDelegationInfo_ = java.util.Collections.emptyList();
      } else {
        serviceAccountDelegationInfo_ = null;
        serviceAccountDelegationInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      userName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.AccessProto
          .internal_static_google_cloud_securitycenter_v1_Access_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Access getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Access.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Access build() {
      com.google.cloud.securitycenter.v1.Access result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Access buildPartial() {
      com.google.cloud.securitycenter.v1.Access result =
          new com.google.cloud.securitycenter.v1.Access(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.securitycenter.v1.Access result) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          serviceAccountDelegationInfo_ =
              java.util.Collections.unmodifiableList(serviceAccountDelegationInfo_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.serviceAccountDelegationInfo_ = serviceAccountDelegationInfo_;
      } else {
        result.serviceAccountDelegationInfo_ = serviceAccountDelegationInfoBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Access result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.principalEmail_ = principalEmail_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.callerIp_ = callerIp_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.callerIpGeo_ =
            callerIpGeoBuilder_ == null ? callerIpGeo_ : callerIpGeoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.userAgentFamily_ = userAgentFamily_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.userAgent_ = userAgent_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.serviceName_ = serviceName_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.methodName_ = methodName_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.principalSubject_ = principalSubject_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.serviceAccountKeyName_ = serviceAccountKeyName_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.userName_ = userName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Access) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Access) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Access other) {
      if (other == com.google.cloud.securitycenter.v1.Access.getDefaultInstance()) return this;
      if (!other.getPrincipalEmail().isEmpty()) {
        principalEmail_ = other.principalEmail_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCallerIp().isEmpty()) {
        callerIp_ = other.callerIp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCallerIpGeo()) {
        mergeCallerIpGeo(other.getCallerIpGeo());
      }
      if (!other.getUserAgentFamily().isEmpty()) {
        userAgentFamily_ = other.userAgentFamily_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getUserAgent().isEmpty()) {
        userAgent_ = other.userAgent_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getServiceName().isEmpty()) {
        serviceName_ = other.serviceName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getMethodName().isEmpty()) {
        methodName_ = other.methodName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getPrincipalSubject().isEmpty()) {
        principalSubject_ = other.principalSubject_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getServiceAccountKeyName().isEmpty()) {
        serviceAccountKeyName_ = other.serviceAccountKeyName_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (!other.serviceAccountDelegationInfo_.isEmpty()) {
          if (serviceAccountDelegationInfo_.isEmpty()) {
            serviceAccountDelegationInfo_ = other.serviceAccountDelegationInfo_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureServiceAccountDelegationInfoIsMutable();
            serviceAccountDelegationInfo_.addAll(other.serviceAccountDelegationInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.serviceAccountDelegationInfo_.isEmpty()) {
          if (serviceAccountDelegationInfoBuilder_.isEmpty()) {
            serviceAccountDelegationInfoBuilder_.dispose();
            serviceAccountDelegationInfoBuilder_ = null;
            serviceAccountDelegationInfo_ = other.serviceAccountDelegationInfo_;
            bitField0_ = (bitField0_ & ~0x00000200);
            serviceAccountDelegationInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServiceAccountDelegationInfoFieldBuilder()
                    : null;
          } else {
            serviceAccountDelegationInfoBuilder_.addAllMessages(
                other.serviceAccountDelegationInfo_);
          }
        }
      }
      if (!other.getUserName().isEmpty()) {
        userName_ = other.userName_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                principalEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                callerIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCallerIpGeoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                userAgentFamily_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                serviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                methodName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                principalSubject_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                serviceAccountKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.parser(),
                        extensionRegistry);
                if (serviceAccountDelegationInfoBuilder_ == null) {
                  ensureServiceAccountDelegationInfoIsMutable();
                  serviceAccountDelegationInfo_.add(m);
                } else {
                  serviceAccountDelegationInfoBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 90:
              {
                userName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                userAgent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object principalEmail_ = "";
    /**
     *
     *
     * <pre>
     * Associated email, such as "foo&#64;google.com".
     *
     * The email address of the authenticated user or a service account acting on
     * behalf of a third party principal making the request. For third party
     * identity callers, the `principal_subject` field is populated instead of
     * this field. For privacy reasons, the principal email address is sometimes
     * redacted. For more information, see [Caller identities in audit
     * logs](https://cloud.google.com/logging/docs/audit#user-id).
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return The principalEmail.
     */
    public java.lang.String getPrincipalEmail() {
      java.lang.Object ref = principalEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principalEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Associated email, such as "foo&#64;google.com".
     *
     * The email address of the authenticated user or a service account acting on
     * behalf of a third party principal making the request. For third party
     * identity callers, the `principal_subject` field is populated instead of
     * this field. For privacy reasons, the principal email address is sometimes
     * redacted. For more information, see [Caller identities in audit
     * logs](https://cloud.google.com/logging/docs/audit#user-id).
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return The bytes for principalEmail.
     */
    public com.google.protobuf.ByteString getPrincipalEmailBytes() {
      java.lang.Object ref = principalEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principalEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Associated email, such as "foo&#64;google.com".
     *
     * The email address of the authenticated user or a service account acting on
     * behalf of a third party principal making the request. For third party
     * identity callers, the `principal_subject` field is populated instead of
     * this field. For privacy reasons, the principal email address is sometimes
     * redacted. For more information, see [Caller identities in audit
     * logs](https://cloud.google.com/logging/docs/audit#user-id).
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @param value The principalEmail to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      principalEmail_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associated email, such as "foo&#64;google.com".
     *
     * The email address of the authenticated user or a service account acting on
     * behalf of a third party principal making the request. For third party
     * identity callers, the `principal_subject` field is populated instead of
     * this field. For privacy reasons, the principal email address is sometimes
     * redacted. For more information, see [Caller identities in audit
     * logs](https://cloud.google.com/logging/docs/audit#user-id).
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrincipalEmail() {
      principalEmail_ = getDefaultInstance().getPrincipalEmail();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associated email, such as "foo&#64;google.com".
     *
     * The email address of the authenticated user or a service account acting on
     * behalf of a third party principal making the request. For third party
     * identity callers, the `principal_subject` field is populated instead of
     * this field. For privacy reasons, the principal email address is sometimes
     * redacted. For more information, see [Caller identities in audit
     * logs](https://cloud.google.com/logging/docs/audit#user-id).
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @param value The bytes for principalEmail to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      principalEmail_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object callerIp_ = "";
    /**
     *
     *
     * <pre>
     * Caller's IP address, such as "1.1.1.1".
     * </pre>
     *
     * <code>string caller_ip = 2;</code>
     *
     * @return The callerIp.
     */
    public java.lang.String getCallerIp() {
      java.lang.Object ref = callerIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        callerIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Caller's IP address, such as "1.1.1.1".
     * </pre>
     *
     * <code>string caller_ip = 2;</code>
     *
     * @return The bytes for callerIp.
     */
    public com.google.protobuf.ByteString getCallerIpBytes() {
      java.lang.Object ref = callerIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        callerIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Caller's IP address, such as "1.1.1.1".
     * </pre>
     *
     * <code>string caller_ip = 2;</code>
     *
     * @param value The callerIp to set.
     * @return This builder for chaining.
     */
    public Builder setCallerIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      callerIp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Caller's IP address, such as "1.1.1.1".
     * </pre>
     *
     * <code>string caller_ip = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCallerIp() {
      callerIp_ = getDefaultInstance().getCallerIp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Caller's IP address, such as "1.1.1.1".
     * </pre>
     *
     * <code>string caller_ip = 2;</code>
     *
     * @param value The bytes for callerIp to set.
     * @return This builder for chaining.
     */
    public Builder setCallerIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      callerIp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1.Geolocation callerIpGeo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Geolocation,
            com.google.cloud.securitycenter.v1.Geolocation.Builder,
            com.google.cloud.securitycenter.v1.GeolocationOrBuilder>
        callerIpGeoBuilder_;
    /**
     *
     *
     * <pre>
     * The caller IP's geolocation, which identifies where the call came from.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
     *
     * @return Whether the callerIpGeo field is set.
     */
    public boolean hasCallerIpGeo() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The caller IP's geolocation, which identifies where the call came from.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
     *
     * @return The callerIpGeo.
     */
    public com.google.cloud.securitycenter.v1.Geolocation getCallerIpGeo() {
      if (callerIpGeoBuilder_ == null) {
        return callerIpGeo_ == null
            ? com.google.cloud.securitycenter.v1.Geolocation.getDefaultInstance()
            : callerIpGeo_;
      } else {
        return callerIpGeoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The caller IP's geolocation, which identifies where the call came from.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
     */
    public Builder setCallerIpGeo(com.google.cloud.securitycenter.v1.Geolocation value) {
      if (callerIpGeoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        callerIpGeo_ = value;
      } else {
        callerIpGeoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The caller IP's geolocation, which identifies where the call came from.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
     */
    public Builder setCallerIpGeo(
        com.google.cloud.securitycenter.v1.Geolocation.Builder builderForValue) {
      if (callerIpGeoBuilder_ == null) {
        callerIpGeo_ = builderForValue.build();
      } else {
        callerIpGeoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The caller IP's geolocation, which identifies where the call came from.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
     */
    public Builder mergeCallerIpGeo(com.google.cloud.securitycenter.v1.Geolocation value) {
      if (callerIpGeoBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && callerIpGeo_ != null
            && callerIpGeo_
                != com.google.cloud.securitycenter.v1.Geolocation.getDefaultInstance()) {
          getCallerIpGeoBuilder().mergeFrom(value);
        } else {
          callerIpGeo_ = value;
        }
      } else {
        callerIpGeoBuilder_.mergeFrom(value);
      }
      if (callerIpGeo_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The caller IP's geolocation, which identifies where the call came from.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
     */
    public Builder clearCallerIpGeo() {
      bitField0_ = (bitField0_ & ~0x00000004);
      callerIpGeo_ = null;
      if (callerIpGeoBuilder_ != null) {
        callerIpGeoBuilder_.dispose();
        callerIpGeoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The caller IP's geolocation, which identifies where the call came from.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.Geolocation.Builder getCallerIpGeoBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCallerIpGeoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The caller IP's geolocation, which identifies where the call came from.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.GeolocationOrBuilder getCallerIpGeoOrBuilder() {
      if (callerIpGeoBuilder_ != null) {
        return callerIpGeoBuilder_.getMessageOrBuilder();
      } else {
        return callerIpGeo_ == null
            ? com.google.cloud.securitycenter.v1.Geolocation.getDefaultInstance()
            : callerIpGeo_;
      }
    }
    /**
     *
     *
     * <pre>
     * The caller IP's geolocation, which identifies where the call came from.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Geolocation,
            com.google.cloud.securitycenter.v1.Geolocation.Builder,
            com.google.cloud.securitycenter.v1.GeolocationOrBuilder>
        getCallerIpGeoFieldBuilder() {
      if (callerIpGeoBuilder_ == null) {
        callerIpGeoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Geolocation,
                com.google.cloud.securitycenter.v1.Geolocation.Builder,
                com.google.cloud.securitycenter.v1.GeolocationOrBuilder>(
                getCallerIpGeo(), getParentForChildren(), isClean());
        callerIpGeo_ = null;
      }
      return callerIpGeoBuilder_;
    }

    private java.lang.Object userAgentFamily_ = "";
    /**
     *
     *
     * <pre>
     * Type of user agent associated with the finding. For example, an operating
     * system shell or an embedded or standalone application.
     * </pre>
     *
     * <code>string user_agent_family = 4;</code>
     *
     * @return The userAgentFamily.
     */
    public java.lang.String getUserAgentFamily() {
      java.lang.Object ref = userAgentFamily_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userAgentFamily_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of user agent associated with the finding. For example, an operating
     * system shell or an embedded or standalone application.
     * </pre>
     *
     * <code>string user_agent_family = 4;</code>
     *
     * @return The bytes for userAgentFamily.
     */
    public com.google.protobuf.ByteString getUserAgentFamilyBytes() {
      java.lang.Object ref = userAgentFamily_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userAgentFamily_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of user agent associated with the finding. For example, an operating
     * system shell or an embedded or standalone application.
     * </pre>
     *
     * <code>string user_agent_family = 4;</code>
     *
     * @param value The userAgentFamily to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgentFamily(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userAgentFamily_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of user agent associated with the finding. For example, an operating
     * system shell or an embedded or standalone application.
     * </pre>
     *
     * <code>string user_agent_family = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserAgentFamily() {
      userAgentFamily_ = getDefaultInstance().getUserAgentFamily();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of user agent associated with the finding. For example, an operating
     * system shell or an embedded or standalone application.
     * </pre>
     *
     * <code>string user_agent_family = 4;</code>
     *
     * @param value The bytes for userAgentFamily to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgentFamilyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userAgentFamily_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object userAgent_ = "";
    /**
     *
     *
     * <pre>
     * The caller's user agent string associated with the finding.
     * </pre>
     *
     * <code>string user_agent = 12;</code>
     *
     * @return The userAgent.
     */
    public java.lang.String getUserAgent() {
      java.lang.Object ref = userAgent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userAgent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The caller's user agent string associated with the finding.
     * </pre>
     *
     * <code>string user_agent = 12;</code>
     *
     * @return The bytes for userAgent.
     */
    public com.google.protobuf.ByteString getUserAgentBytes() {
      java.lang.Object ref = userAgent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userAgent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The caller's user agent string associated with the finding.
     * </pre>
     *
     * <code>string user_agent = 12;</code>
     *
     * @param value The userAgent to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userAgent_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The caller's user agent string associated with the finding.
     * </pre>
     *
     * <code>string user_agent = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserAgent() {
      userAgent_ = getDefaultInstance().getUserAgent();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The caller's user agent string associated with the finding.
     * </pre>
     *
     * <code>string user_agent = 12;</code>
     *
     * @param value The bytes for userAgent to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userAgent_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * This is the API service that the service account made a call to, e.g.
     * "iam.googleapis.com"
     * </pre>
     *
     * <code>string service_name = 5;</code>
     *
     * @return The serviceName.
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This is the API service that the service account made a call to, e.g.
     * "iam.googleapis.com"
     * </pre>
     *
     * <code>string service_name = 5;</code>
     *
     * @return The bytes for serviceName.
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This is the API service that the service account made a call to, e.g.
     * "iam.googleapis.com"
     * </pre>
     *
     * <code>string service_name = 5;</code>
     *
     * @param value The serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is the API service that the service account made a call to, e.g.
     * "iam.googleapis.com"
     * </pre>
     *
     * <code>string service_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceName() {
      serviceName_ = getDefaultInstance().getServiceName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is the API service that the service account made a call to, e.g.
     * "iam.googleapis.com"
     * </pre>
     *
     * <code>string service_name = 5;</code>
     *
     * @param value The bytes for serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object methodName_ = "";
    /**
     *
     *
     * <pre>
     * The method that the service account called, e.g. "SetIamPolicy".
     * </pre>
     *
     * <code>string method_name = 6;</code>
     *
     * @return The methodName.
     */
    public java.lang.String getMethodName() {
      java.lang.Object ref = methodName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        methodName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The method that the service account called, e.g. "SetIamPolicy".
     * </pre>
     *
     * <code>string method_name = 6;</code>
     *
     * @return The bytes for methodName.
     */
    public com.google.protobuf.ByteString getMethodNameBytes() {
      java.lang.Object ref = methodName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        methodName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The method that the service account called, e.g. "SetIamPolicy".
     * </pre>
     *
     * <code>string method_name = 6;</code>
     *
     * @param value The methodName to set.
     * @return This builder for chaining.
     */
    public Builder setMethodName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      methodName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The method that the service account called, e.g. "SetIamPolicy".
     * </pre>
     *
     * <code>string method_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMethodName() {
      methodName_ = getDefaultInstance().getMethodName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The method that the service account called, e.g. "SetIamPolicy".
     * </pre>
     *
     * <code>string method_name = 6;</code>
     *
     * @param value The bytes for methodName to set.
     * @return This builder for chaining.
     */
    public Builder setMethodNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      methodName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object principalSubject_ = "";
    /**
     *
     *
     * <pre>
     * A string that represents the principal_subject that is associated with the
     * identity. Unlike `principal_email`, `principal_subject` supports principals
     * that aren't associated with email addresses, such as third party
     * principals. For most identities, the format is
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject}`.
     * Some GKE identities, such as GKE_WORKLOAD, FREEFORM, and GKE_HUB_WORKLOAD,
     * still use the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`.
     * </pre>
     *
     * <code>string principal_subject = 7;</code>
     *
     * @return The principalSubject.
     */
    public java.lang.String getPrincipalSubject() {
      java.lang.Object ref = principalSubject_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principalSubject_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string that represents the principal_subject that is associated with the
     * identity. Unlike `principal_email`, `principal_subject` supports principals
     * that aren't associated with email addresses, such as third party
     * principals. For most identities, the format is
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject}`.
     * Some GKE identities, such as GKE_WORKLOAD, FREEFORM, and GKE_HUB_WORKLOAD,
     * still use the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`.
     * </pre>
     *
     * <code>string principal_subject = 7;</code>
     *
     * @return The bytes for principalSubject.
     */
    public com.google.protobuf.ByteString getPrincipalSubjectBytes() {
      java.lang.Object ref = principalSubject_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principalSubject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string that represents the principal_subject that is associated with the
     * identity. Unlike `principal_email`, `principal_subject` supports principals
     * that aren't associated with email addresses, such as third party
     * principals. For most identities, the format is
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject}`.
     * Some GKE identities, such as GKE_WORKLOAD, FREEFORM, and GKE_HUB_WORKLOAD,
     * still use the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`.
     * </pre>
     *
     * <code>string principal_subject = 7;</code>
     *
     * @param value The principalSubject to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalSubject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      principalSubject_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string that represents the principal_subject that is associated with the
     * identity. Unlike `principal_email`, `principal_subject` supports principals
     * that aren't associated with email addresses, such as third party
     * principals. For most identities, the format is
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject}`.
     * Some GKE identities, such as GKE_WORKLOAD, FREEFORM, and GKE_HUB_WORKLOAD,
     * still use the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`.
     * </pre>
     *
     * <code>string principal_subject = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrincipalSubject() {
      principalSubject_ = getDefaultInstance().getPrincipalSubject();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string that represents the principal_subject that is associated with the
     * identity. Unlike `principal_email`, `principal_subject` supports principals
     * that aren't associated with email addresses, such as third party
     * principals. For most identities, the format is
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject}`.
     * Some GKE identities, such as GKE_WORKLOAD, FREEFORM, and GKE_HUB_WORKLOAD,
     * still use the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`.
     * </pre>
     *
     * <code>string principal_subject = 7;</code>
     *
     * @param value The bytes for principalSubject to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalSubjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      principalSubject_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the service account key that was used to create or exchange
     * credentials when authenticating the service account that made the request.
     * This is a scheme-less URI full resource name. For example:
     *
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}".
     * </pre>
     *
     * <code>string service_account_key_name = 8;</code>
     *
     * @return The serviceAccountKeyName.
     */
    public java.lang.String getServiceAccountKeyName() {
      java.lang.Object ref = serviceAccountKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the service account key that was used to create or exchange
     * credentials when authenticating the service account that made the request.
     * This is a scheme-less URI full resource name. For example:
     *
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}".
     * </pre>
     *
     * <code>string service_account_key_name = 8;</code>
     *
     * @return The bytes for serviceAccountKeyName.
     */
    public com.google.protobuf.ByteString getServiceAccountKeyNameBytes() {
      java.lang.Object ref = serviceAccountKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the service account key that was used to create or exchange
     * credentials when authenticating the service account that made the request.
     * This is a scheme-less URI full resource name. For example:
     *
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}".
     * </pre>
     *
     * <code>string service_account_key_name = 8;</code>
     *
     * @param value The serviceAccountKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccountKeyName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the service account key that was used to create or exchange
     * credentials when authenticating the service account that made the request.
     * This is a scheme-less URI full resource name. For example:
     *
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}".
     * </pre>
     *
     * <code>string service_account_key_name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountKeyName() {
      serviceAccountKeyName_ = getDefaultInstance().getServiceAccountKeyName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the service account key that was used to create or exchange
     * credentials when authenticating the service account that made the request.
     * This is a scheme-less URI full resource name. For example:
     *
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}".
     * </pre>
     *
     * <code>string service_account_key_name = 8;</code>
     *
     * @param value The bytes for serviceAccountKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccountKeyName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo>
        serviceAccountDelegationInfo_ = java.util.Collections.emptyList();

    private void ensureServiceAccountDelegationInfoIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        serviceAccountDelegationInfo_ =
            new java.util.ArrayList<
                com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo>(
                serviceAccountDelegationInfo_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo,
            com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder,
            com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfoOrBuilder>
        serviceAccountDelegationInfoBuilder_;

    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo>
        getServiceAccountDelegationInfoList() {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serviceAccountDelegationInfo_);
      } else {
        return serviceAccountDelegationInfoBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public int getServiceAccountDelegationInfoCount() {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        return serviceAccountDelegationInfo_.size();
      } else {
        return serviceAccountDelegationInfoBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo
        getServiceAccountDelegationInfo(int index) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        return serviceAccountDelegationInfo_.get(index);
      } else {
        return serviceAccountDelegationInfoBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public Builder setServiceAccountDelegationInfo(
        int index, com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo value) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.set(index, value);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public Builder setServiceAccountDelegationInfo(
        int index,
        com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder builderForValue) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public Builder addServiceAccountDelegationInfo(
        com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo value) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.add(value);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public Builder addServiceAccountDelegationInfo(
        int index, com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo value) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.add(index, value);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public Builder addServiceAccountDelegationInfo(
        com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder builderForValue) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.add(builderForValue.build());
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public Builder addServiceAccountDelegationInfo(
        int index,
        com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder builderForValue) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public Builder addAllServiceAccountDelegationInfo(
        java.lang.Iterable<
                ? extends com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo>
            values) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, serviceAccountDelegationInfo_);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public Builder clearServiceAccountDelegationInfo() {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        serviceAccountDelegationInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public Builder removeServiceAccountDelegationInfo(int index) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.remove(index);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder
        getServiceAccountDelegationInfoBuilder(int index) {
      return getServiceAccountDelegationInfoFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfoOrBuilder
        getServiceAccountDelegationInfoOrBuilder(int index) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        return serviceAccountDelegationInfo_.get(index);
      } else {
        return serviceAccountDelegationInfoBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfoOrBuilder>
        getServiceAccountDelegationInfoOrBuilderList() {
      if (serviceAccountDelegationInfoBuilder_ != null) {
        return serviceAccountDelegationInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serviceAccountDelegationInfo_);
      }
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder
        addServiceAccountDelegationInfoBuilder() {
      return getServiceAccountDelegationInfoFieldBuilder()
          .addBuilder(
              com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder
        addServiceAccountDelegationInfoBuilder(int index) {
      return getServiceAccountDelegationInfoFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The identity delegation history of an authenticated service account that
     * made the request. The `serviceAccountDelegationInfo[]` object contains
     * information about the real authorities that try to access Google Cloud
     * resources by delegating on a service account. When multiple authorities are
     * present, they are guaranteed to be sorted based on the original ordering of
     * the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
     * </code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder>
        getServiceAccountDelegationInfoBuilderList() {
      return getServiceAccountDelegationInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo,
            com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder,
            com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfoOrBuilder>
        getServiceAccountDelegationInfoFieldBuilder() {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        serviceAccountDelegationInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo,
                com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo.Builder,
                com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfoOrBuilder>(
                serviceAccountDelegationInfo_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        serviceAccountDelegationInfo_ = null;
      }
      return serviceAccountDelegationInfoBuilder_;
    }

    private java.lang.Object userName_ = "";
    /**
     *
     *
     * <pre>
     * A string that represents a username. The username provided depends on the
     * type of the finding and is likely not an IAM principal. For example, this
     * can be a system username if the finding is related to a virtual machine, or
     * it can be an application login username.
     * </pre>
     *
     * <code>string user_name = 11;</code>
     *
     * @return The userName.
     */
    public java.lang.String getUserName() {
      java.lang.Object ref = userName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string that represents a username. The username provided depends on the
     * type of the finding and is likely not an IAM principal. For example, this
     * can be a system username if the finding is related to a virtual machine, or
     * it can be an application login username.
     * </pre>
     *
     * <code>string user_name = 11;</code>
     *
     * @return The bytes for userName.
     */
    public com.google.protobuf.ByteString getUserNameBytes() {
      java.lang.Object ref = userName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string that represents a username. The username provided depends on the
     * type of the finding and is likely not an IAM principal. For example, this
     * can be a system username if the finding is related to a virtual machine, or
     * it can be an application login username.
     * </pre>
     *
     * <code>string user_name = 11;</code>
     *
     * @param value The userName to set.
     * @return This builder for chaining.
     */
    public Builder setUserName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userName_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string that represents a username. The username provided depends on the
     * type of the finding and is likely not an IAM principal. For example, this
     * can be a system username if the finding is related to a virtual machine, or
     * it can be an application login username.
     * </pre>
     *
     * <code>string user_name = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserName() {
      userName_ = getDefaultInstance().getUserName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string that represents a username. The username provided depends on the
     * type of the finding and is likely not an IAM principal. For example, this
     * can be a system username if the finding is related to a virtual machine, or
     * it can be an application login username.
     * </pre>
     *
     * <code>string user_name = 11;</code>
     *
     * @param value The bytes for userName to set.
     * @return This builder for chaining.
     */
    public Builder setUserNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userName_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Access)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Access)
  private static final com.google.cloud.securitycenter.v1.Access DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Access();
  }

  public static com.google.cloud.securitycenter.v1.Access getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Access> PARSER =
      new com.google.protobuf.AbstractParser<Access>() {
        @java.lang.Override
        public Access parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Access> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Access> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Access getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
