/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/access.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

public interface AccessOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Access)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Associated email, such as "foo&#64;google.com".
   *
   * The email address of the authenticated user or a service account acting on
   * behalf of a third party principal making the request. For third party
   * identity callers, the `principal_subject` field is populated instead of
   * this field. For privacy reasons, the principal email address is sometimes
   * redacted. For more information, see [Caller identities in audit
   * logs](https://cloud.google.com/logging/docs/audit#user-id).
   * </pre>
   *
   * <code>string principal_email = 1;</code>
   *
   * @return The principalEmail.
   */
  java.lang.String getPrincipalEmail();
  /**
   *
   *
   * <pre>
   * Associated email, such as "foo&#64;google.com".
   *
   * The email address of the authenticated user or a service account acting on
   * behalf of a third party principal making the request. For third party
   * identity callers, the `principal_subject` field is populated instead of
   * this field. For privacy reasons, the principal email address is sometimes
   * redacted. For more information, see [Caller identities in audit
   * logs](https://cloud.google.com/logging/docs/audit#user-id).
   * </pre>
   *
   * <code>string principal_email = 1;</code>
   *
   * @return The bytes for principalEmail.
   */
  com.google.protobuf.ByteString getPrincipalEmailBytes();

  /**
   *
   *
   * <pre>
   * Caller's IP address, such as "1.1.1.1".
   * </pre>
   *
   * <code>string caller_ip = 2;</code>
   *
   * @return The callerIp.
   */
  java.lang.String getCallerIp();
  /**
   *
   *
   * <pre>
   * Caller's IP address, such as "1.1.1.1".
   * </pre>
   *
   * <code>string caller_ip = 2;</code>
   *
   * @return The bytes for callerIp.
   */
  com.google.protobuf.ByteString getCallerIpBytes();

  /**
   *
   *
   * <pre>
   * The caller IP's geolocation, which identifies where the call came from.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
   *
   * @return Whether the callerIpGeo field is set.
   */
  boolean hasCallerIpGeo();
  /**
   *
   *
   * <pre>
   * The caller IP's geolocation, which identifies where the call came from.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
   *
   * @return The callerIpGeo.
   */
  com.google.cloud.securitycenter.v1.Geolocation getCallerIpGeo();
  /**
   *
   *
   * <pre>
   * The caller IP's geolocation, which identifies where the call came from.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Geolocation caller_ip_geo = 3;</code>
   */
  com.google.cloud.securitycenter.v1.GeolocationOrBuilder getCallerIpGeoOrBuilder();

  /**
   *
   *
   * <pre>
   * Type of user agent associated with the finding. For example, an operating
   * system shell or an embedded or standalone application.
   * </pre>
   *
   * <code>string user_agent_family = 4;</code>
   *
   * @return The userAgentFamily.
   */
  java.lang.String getUserAgentFamily();
  /**
   *
   *
   * <pre>
   * Type of user agent associated with the finding. For example, an operating
   * system shell or an embedded or standalone application.
   * </pre>
   *
   * <code>string user_agent_family = 4;</code>
   *
   * @return The bytes for userAgentFamily.
   */
  com.google.protobuf.ByteString getUserAgentFamilyBytes();

  /**
   *
   *
   * <pre>
   * The caller's user agent string associated with the finding.
   * </pre>
   *
   * <code>string user_agent = 12;</code>
   *
   * @return The userAgent.
   */
  java.lang.String getUserAgent();
  /**
   *
   *
   * <pre>
   * The caller's user agent string associated with the finding.
   * </pre>
   *
   * <code>string user_agent = 12;</code>
   *
   * @return The bytes for userAgent.
   */
  com.google.protobuf.ByteString getUserAgentBytes();

  /**
   *
   *
   * <pre>
   * This is the API service that the service account made a call to, e.g.
   * "iam.googleapis.com"
   * </pre>
   *
   * <code>string service_name = 5;</code>
   *
   * @return The serviceName.
   */
  java.lang.String getServiceName();
  /**
   *
   *
   * <pre>
   * This is the API service that the service account made a call to, e.g.
   * "iam.googleapis.com"
   * </pre>
   *
   * <code>string service_name = 5;</code>
   *
   * @return The bytes for serviceName.
   */
  com.google.protobuf.ByteString getServiceNameBytes();

  /**
   *
   *
   * <pre>
   * The method that the service account called, e.g. "SetIamPolicy".
   * </pre>
   *
   * <code>string method_name = 6;</code>
   *
   * @return The methodName.
   */
  java.lang.String getMethodName();
  /**
   *
   *
   * <pre>
   * The method that the service account called, e.g. "SetIamPolicy".
   * </pre>
   *
   * <code>string method_name = 6;</code>
   *
   * @return The bytes for methodName.
   */
  com.google.protobuf.ByteString getMethodNameBytes();

  /**
   *
   *
   * <pre>
   * A string that represents the principal_subject that is associated with the
   * identity. Unlike `principal_email`, `principal_subject` supports principals
   * that aren't associated with email addresses, such as third party
   * principals. For most identities, the format is
   * `principal://iam.googleapis.com/{identity pool name}/subject/{subject}`.
   * Some GKE identities, such as GKE_WORKLOAD, FREEFORM, and GKE_HUB_WORKLOAD,
   * still use the legacy format `serviceAccount:{identity pool
   * name}[{subject}]`.
   * </pre>
   *
   * <code>string principal_subject = 7;</code>
   *
   * @return The principalSubject.
   */
  java.lang.String getPrincipalSubject();
  /**
   *
   *
   * <pre>
   * A string that represents the principal_subject that is associated with the
   * identity. Unlike `principal_email`, `principal_subject` supports principals
   * that aren't associated with email addresses, such as third party
   * principals. For most identities, the format is
   * `principal://iam.googleapis.com/{identity pool name}/subject/{subject}`.
   * Some GKE identities, such as GKE_WORKLOAD, FREEFORM, and GKE_HUB_WORKLOAD,
   * still use the legacy format `serviceAccount:{identity pool
   * name}[{subject}]`.
   * </pre>
   *
   * <code>string principal_subject = 7;</code>
   *
   * @return The bytes for principalSubject.
   */
  com.google.protobuf.ByteString getPrincipalSubjectBytes();

  /**
   *
   *
   * <pre>
   * The name of the service account key that was used to create or exchange
   * credentials when authenticating the service account that made the request.
   * This is a scheme-less URI full resource name. For example:
   *
   * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}".
   * </pre>
   *
   * <code>string service_account_key_name = 8;</code>
   *
   * @return The serviceAccountKeyName.
   */
  java.lang.String getServiceAccountKeyName();
  /**
   *
   *
   * <pre>
   * The name of the service account key that was used to create or exchange
   * credentials when authenticating the service account that made the request.
   * This is a scheme-less URI full resource name. For example:
   *
   * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}".
   * </pre>
   *
   * <code>string service_account_key_name = 8;</code>
   *
   * @return The bytes for serviceAccountKeyName.
   */
  com.google.protobuf.ByteString getServiceAccountKeyNameBytes();

  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  java.util.List<com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo>
      getServiceAccountDelegationInfoList();
  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfo getServiceAccountDelegationInfo(
      int index);
  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  int getServiceAccountDelegationInfoCount();
  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  java.util.List<? extends com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfoOrBuilder>
      getServiceAccountDelegationInfoOrBuilderList();
  /**
   *
   *
   * <pre>
   * The identity delegation history of an authenticated service account that
   * made the request. The `serviceAccountDelegationInfo[]` object contains
   * information about the real authorities that try to access Google Cloud
   * resources by delegating on a service account. When multiple authorities are
   * present, they are guaranteed to be sorted based on the original ordering of
   * the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.ServiceAccountDelegationInfo service_account_delegation_info = 9;
   * </code>
   */
  com.google.cloud.securitycenter.v1.ServiceAccountDelegationInfoOrBuilder
      getServiceAccountDelegationInfoOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * A string that represents a username. The username provided depends on the
   * type of the finding and is likely not an IAM principal. For example, this
   * can be a system username if the finding is related to a virtual machine, or
   * it can be an application login username.
   * </pre>
   *
   * <code>string user_name = 11;</code>
   *
   * @return The userName.
   */
  java.lang.String getUserName();
  /**
   *
   *
   * <pre>
   * A string that represents a username. The username provided depends on the
   * type of the finding and is likely not an IAM principal. For example, this
   * can be a system username if the finding is related to a virtual machine, or
   * it can be an application login username.
   * </pre>
   *
   * <code>string user_name = 11;</code>
   *
   * @return The bytes for userName.
   */
  com.google.protobuf.ByteString getUserNameBytes();
}
