/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/backup_disaster_recovery.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Information related to Google Cloud Backup and DR Service findings.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.BackupDisasterRecovery}
 */
public final class BackupDisasterRecovery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.BackupDisasterRecovery)
    BackupDisasterRecoveryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackupDisasterRecovery.newBuilder() to construct.
  private BackupDisasterRecovery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackupDisasterRecovery() {
    backupTemplate_ = "";
    policies_ = com.google.protobuf.LazyStringArrayList.emptyList();
    host_ = "";
    applications_ = com.google.protobuf.LazyStringArrayList.emptyList();
    storagePool_ = "";
    policyOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    profile_ = "";
    appliance_ = "";
    backupType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackupDisasterRecovery();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.BackupDisasterRecoveryProto
        .internal_static_google_cloud_securitycenter_v1_BackupDisasterRecovery_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.BackupDisasterRecoveryProto
        .internal_static_google_cloud_securitycenter_v1_BackupDisasterRecovery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.BackupDisasterRecovery.class,
            com.google.cloud.securitycenter.v1.BackupDisasterRecovery.Builder.class);
  }

  private int bitField0_;
  public static final int BACKUP_TEMPLATE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backupTemplate_ = "";
  /**
   *
   *
   * <pre>
   * The name of a Backup and DR template which comprises one or more backup
   * policies. See the [Backup and DR
   * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
   * for more information. For example, `snap-ov`.
   * </pre>
   *
   * <code>string backup_template = 1;</code>
   *
   * @return The backupTemplate.
   */
  @java.lang.Override
  public java.lang.String getBackupTemplate() {
    java.lang.Object ref = backupTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backupTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of a Backup and DR template which comprises one or more backup
   * policies. See the [Backup and DR
   * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
   * for more information. For example, `snap-ov`.
   * </pre>
   *
   * <code>string backup_template = 1;</code>
   *
   * @return The bytes for backupTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackupTemplateBytes() {
    java.lang.Object ref = backupTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backupTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICIES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList policies_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The names of Backup and DR policies that are associated with a template
   * and that define when to run a backup, how frequently to run a backup, and
   * how long to retain the backup image. For example, `onvaults`.
   * </pre>
   *
   * <code>repeated string policies = 2;</code>
   *
   * @return A list containing the policies.
   */
  public com.google.protobuf.ProtocolStringList getPoliciesList() {
    return policies_;
  }
  /**
   *
   *
   * <pre>
   * The names of Backup and DR policies that are associated with a template
   * and that define when to run a backup, how frequently to run a backup, and
   * how long to retain the backup image. For example, `onvaults`.
   * </pre>
   *
   * <code>repeated string policies = 2;</code>
   *
   * @return The count of policies.
   */
  public int getPoliciesCount() {
    return policies_.size();
  }
  /**
   *
   *
   * <pre>
   * The names of Backup and DR policies that are associated with a template
   * and that define when to run a backup, how frequently to run a backup, and
   * how long to retain the backup image. For example, `onvaults`.
   * </pre>
   *
   * <code>repeated string policies = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The policies at the given index.
   */
  public java.lang.String getPolicies(int index) {
    return policies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The names of Backup and DR policies that are associated with a template
   * and that define when to run a backup, how frequently to run a backup, and
   * how long to retain the backup image. For example, `onvaults`.
   * </pre>
   *
   * <code>repeated string policies = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the policies at the given index.
   */
  public com.google.protobuf.ByteString getPoliciesBytes(int index) {
    return policies_.getByteString(index);
  }

  public static final int HOST_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object host_ = "";
  /**
   *
   *
   * <pre>
   * The name of a Backup and DR host, which is managed by the backup and
   * recovery appliance and known to the management console. The host can be of
   * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
   * system, etc.), vCenter, or an ESX server. See the [Backup and DR
   * documentation on
   * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
   * for more information. For example, `centos7-01`.
   * </pre>
   *
   * <code>string host = 3;</code>
   *
   * @return The host.
   */
  @java.lang.Override
  public java.lang.String getHost() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      host_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of a Backup and DR host, which is managed by the backup and
   * recovery appliance and known to the management console. The host can be of
   * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
   * system, etc.), vCenter, or an ESX server. See the [Backup and DR
   * documentation on
   * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
   * for more information. For example, `centos7-01`.
   * </pre>
   *
   * <code>string host = 3;</code>
   *
   * @return The bytes for host.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostBytes() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      host_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPLICATIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList applications_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The names of Backup and DR applications. An application is a VM, database,
   * or file system on a managed host monitored by a backup and recovery
   * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
   * `centos7-01-vol02`.
   * </pre>
   *
   * <code>repeated string applications = 4;</code>
   *
   * @return A list containing the applications.
   */
  public com.google.protobuf.ProtocolStringList getApplicationsList() {
    return applications_;
  }
  /**
   *
   *
   * <pre>
   * The names of Backup and DR applications. An application is a VM, database,
   * or file system on a managed host monitored by a backup and recovery
   * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
   * `centos7-01-vol02`.
   * </pre>
   *
   * <code>repeated string applications = 4;</code>
   *
   * @return The count of applications.
   */
  public int getApplicationsCount() {
    return applications_.size();
  }
  /**
   *
   *
   * <pre>
   * The names of Backup and DR applications. An application is a VM, database,
   * or file system on a managed host monitored by a backup and recovery
   * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
   * `centos7-01-vol02`.
   * </pre>
   *
   * <code>repeated string applications = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The applications at the given index.
   */
  public java.lang.String getApplications(int index) {
    return applications_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The names of Backup and DR applications. An application is a VM, database,
   * or file system on a managed host monitored by a backup and recovery
   * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
   * `centos7-01-vol02`.
   * </pre>
   *
   * <code>repeated string applications = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the applications at the given index.
   */
  public com.google.protobuf.ByteString getApplicationsBytes(int index) {
    return applications_.getByteString(index);
  }

  public static final int STORAGE_POOL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object storagePool_ = "";
  /**
   *
   *
   * <pre>
   * The name of the Backup and DR storage pool that the backup and recovery
   * appliance is storing data in. The storage pool could be of type Cloud,
   * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
   * storage
   * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
   * For example, `DiskPoolOne`.
   * </pre>
   *
   * <code>string storage_pool = 5;</code>
   *
   * @return The storagePool.
   */
  @java.lang.Override
  public java.lang.String getStoragePool() {
    java.lang.Object ref = storagePool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      storagePool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the Backup and DR storage pool that the backup and recovery
   * appliance is storing data in. The storage pool could be of type Cloud,
   * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
   * storage
   * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
   * For example, `DiskPoolOne`.
   * </pre>
   *
   * <code>string storage_pool = 5;</code>
   *
   * @return The bytes for storagePool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStoragePoolBytes() {
    java.lang.Object ref = storagePool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      storagePool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICY_OPTIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList policyOptions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The names of Backup and DR advanced policy options of a policy applying to
   * an application. See the [Backup and DR documentation on policy
   * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
   * For example, `skipofflineappsincongrp, nounmap`.
   * </pre>
   *
   * <code>repeated string policy_options = 6;</code>
   *
   * @return A list containing the policyOptions.
   */
  public com.google.protobuf.ProtocolStringList getPolicyOptionsList() {
    return policyOptions_;
  }
  /**
   *
   *
   * <pre>
   * The names of Backup and DR advanced policy options of a policy applying to
   * an application. See the [Backup and DR documentation on policy
   * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
   * For example, `skipofflineappsincongrp, nounmap`.
   * </pre>
   *
   * <code>repeated string policy_options = 6;</code>
   *
   * @return The count of policyOptions.
   */
  public int getPolicyOptionsCount() {
    return policyOptions_.size();
  }
  /**
   *
   *
   * <pre>
   * The names of Backup and DR advanced policy options of a policy applying to
   * an application. See the [Backup and DR documentation on policy
   * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
   * For example, `skipofflineappsincongrp, nounmap`.
   * </pre>
   *
   * <code>repeated string policy_options = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The policyOptions at the given index.
   */
  public java.lang.String getPolicyOptions(int index) {
    return policyOptions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The names of Backup and DR advanced policy options of a policy applying to
   * an application. See the [Backup and DR documentation on policy
   * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
   * For example, `skipofflineappsincongrp, nounmap`.
   * </pre>
   *
   * <code>repeated string policy_options = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the policyOptions at the given index.
   */
  public com.google.protobuf.ByteString getPolicyOptionsBytes(int index) {
    return policyOptions_.getByteString(index);
  }

  public static final int PROFILE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object profile_ = "";
  /**
   *
   *
   * <pre>
   * The name of the Backup and DR resource profile that specifies the storage
   * media for backups of application and VM data. See the [Backup and DR
   * documentation on
   * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
   * For example, `GCP`.
   * </pre>
   *
   * <code>string profile = 7;</code>
   *
   * @return The profile.
   */
  @java.lang.Override
  public java.lang.String getProfile() {
    java.lang.Object ref = profile_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      profile_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the Backup and DR resource profile that specifies the storage
   * media for backups of application and VM data. See the [Backup and DR
   * documentation on
   * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
   * For example, `GCP`.
   * </pre>
   *
   * <code>string profile = 7;</code>
   *
   * @return The bytes for profile.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProfileBytes() {
    java.lang.Object ref = profile_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      profile_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPLIANCE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object appliance_ = "";
  /**
   *
   *
   * <pre>
   * The name of the Backup and DR appliance that captures, moves, and manages
   * the lifecycle of backup data. For example, `backup-server-57137`.
   * </pre>
   *
   * <code>string appliance = 8;</code>
   *
   * @return The appliance.
   */
  @java.lang.Override
  public java.lang.String getAppliance() {
    java.lang.Object ref = appliance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appliance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the Backup and DR appliance that captures, moves, and manages
   * the lifecycle of backup data. For example, `backup-server-57137`.
   * </pre>
   *
   * <code>string appliance = 8;</code>
   *
   * @return The bytes for appliance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getApplianceBytes() {
    java.lang.Object ref = appliance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appliance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_TYPE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backupType_ = "";
  /**
   *
   *
   * <pre>
   * The backup type of the Backup and DR image.
   * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
   * </pre>
   *
   * <code>string backup_type = 9;</code>
   *
   * @return The backupType.
   */
  @java.lang.Override
  public java.lang.String getBackupType() {
    java.lang.Object ref = backupType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backupType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The backup type of the Backup and DR image.
   * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
   * </pre>
   *
   * <code>string backup_type = 9;</code>
   *
   * @return The bytes for backupType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackupTypeBytes() {
    java.lang.Object ref = backupType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backupType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp backupCreateTime_;
  /**
   *
   *
   * <pre>
   * The timestamp at which the Backup and DR backup was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
   *
   * @return Whether the backupCreateTime field is set.
   */
  @java.lang.Override
  public boolean hasBackupCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The timestamp at which the Backup and DR backup was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
   *
   * @return The backupCreateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getBackupCreateTime() {
    return backupCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : backupCreateTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp at which the Backup and DR backup was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getBackupCreateTimeOrBuilder() {
    return backupCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : backupCreateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupTemplate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, backupTemplate_);
    }
    for (int i = 0; i < policies_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, policies_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, host_);
    }
    for (int i = 0; i < applications_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, applications_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storagePool_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, storagePool_);
    }
    for (int i = 0; i < policyOptions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, policyOptions_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(profile_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, profile_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appliance_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, appliance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, backupType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(10, getBackupCreateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupTemplate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, backupTemplate_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < policies_.size(); i++) {
        dataSize += computeStringSizeNoTag(policies_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPoliciesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, host_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < applications_.size(); i++) {
        dataSize += computeStringSizeNoTag(applications_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getApplicationsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storagePool_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, storagePool_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < policyOptions_.size(); i++) {
        dataSize += computeStringSizeNoTag(policyOptions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPolicyOptionsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(profile_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, profile_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appliance_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, appliance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, backupType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getBackupCreateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.BackupDisasterRecovery)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.BackupDisasterRecovery other =
        (com.google.cloud.securitycenter.v1.BackupDisasterRecovery) obj;

    if (!getBackupTemplate().equals(other.getBackupTemplate())) return false;
    if (!getPoliciesList().equals(other.getPoliciesList())) return false;
    if (!getHost().equals(other.getHost())) return false;
    if (!getApplicationsList().equals(other.getApplicationsList())) return false;
    if (!getStoragePool().equals(other.getStoragePool())) return false;
    if (!getPolicyOptionsList().equals(other.getPolicyOptionsList())) return false;
    if (!getProfile().equals(other.getProfile())) return false;
    if (!getAppliance().equals(other.getAppliance())) return false;
    if (!getBackupType().equals(other.getBackupType())) return false;
    if (hasBackupCreateTime() != other.hasBackupCreateTime()) return false;
    if (hasBackupCreateTime()) {
      if (!getBackupCreateTime().equals(other.getBackupCreateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BACKUP_TEMPLATE_FIELD_NUMBER;
    hash = (53 * hash) + getBackupTemplate().hashCode();
    if (getPoliciesCount() > 0) {
      hash = (37 * hash) + POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getPoliciesList().hashCode();
    }
    hash = (37 * hash) + HOST_FIELD_NUMBER;
    hash = (53 * hash) + getHost().hashCode();
    if (getApplicationsCount() > 0) {
      hash = (37 * hash) + APPLICATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getApplicationsList().hashCode();
    }
    hash = (37 * hash) + STORAGE_POOL_FIELD_NUMBER;
    hash = (53 * hash) + getStoragePool().hashCode();
    if (getPolicyOptionsCount() > 0) {
      hash = (37 * hash) + POLICY_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPolicyOptionsList().hashCode();
    }
    hash = (37 * hash) + PROFILE_FIELD_NUMBER;
    hash = (53 * hash) + getProfile().hashCode();
    hash = (37 * hash) + APPLIANCE_FIELD_NUMBER;
    hash = (53 * hash) + getAppliance().hashCode();
    hash = (37 * hash) + BACKUP_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getBackupType().hashCode();
    if (hasBackupCreateTime()) {
      hash = (37 * hash) + BACKUP_CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getBackupCreateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1.BackupDisasterRecovery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information related to Google Cloud Backup and DR Service findings.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.BackupDisasterRecovery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.BackupDisasterRecovery)
      com.google.cloud.securitycenter.v1.BackupDisasterRecoveryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.BackupDisasterRecoveryProto
          .internal_static_google_cloud_securitycenter_v1_BackupDisasterRecovery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.BackupDisasterRecoveryProto
          .internal_static_google_cloud_securitycenter_v1_BackupDisasterRecovery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.BackupDisasterRecovery.class,
              com.google.cloud.securitycenter.v1.BackupDisasterRecovery.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.BackupDisasterRecovery.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBackupCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      backupTemplate_ = "";
      policies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      host_ = "";
      applications_ = com.google.protobuf.LazyStringArrayList.emptyList();
      storagePool_ = "";
      policyOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      profile_ = "";
      appliance_ = "";
      backupType_ = "";
      backupCreateTime_ = null;
      if (backupCreateTimeBuilder_ != null) {
        backupCreateTimeBuilder_.dispose();
        backupCreateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.BackupDisasterRecoveryProto
          .internal_static_google_cloud_securitycenter_v1_BackupDisasterRecovery_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.BackupDisasterRecovery getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.BackupDisasterRecovery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.BackupDisasterRecovery build() {
      com.google.cloud.securitycenter.v1.BackupDisasterRecovery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.BackupDisasterRecovery buildPartial() {
      com.google.cloud.securitycenter.v1.BackupDisasterRecovery result =
          new com.google.cloud.securitycenter.v1.BackupDisasterRecovery(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.BackupDisasterRecovery result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.backupTemplate_ = backupTemplate_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        policies_.makeImmutable();
        result.policies_ = policies_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.host_ = host_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        applications_.makeImmutable();
        result.applications_ = applications_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.storagePool_ = storagePool_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        policyOptions_.makeImmutable();
        result.policyOptions_ = policyOptions_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.profile_ = profile_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.appliance_ = appliance_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.backupType_ = backupType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.backupCreateTime_ =
            backupCreateTimeBuilder_ == null ? backupCreateTime_ : backupCreateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.BackupDisasterRecovery) {
        return mergeFrom((com.google.cloud.securitycenter.v1.BackupDisasterRecovery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.BackupDisasterRecovery other) {
      if (other == com.google.cloud.securitycenter.v1.BackupDisasterRecovery.getDefaultInstance())
        return this;
      if (!other.getBackupTemplate().isEmpty()) {
        backupTemplate_ = other.backupTemplate_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.policies_.isEmpty()) {
        if (policies_.isEmpty()) {
          policies_ = other.policies_;
          bitField0_ |= 0x00000002;
        } else {
          ensurePoliciesIsMutable();
          policies_.addAll(other.policies_);
        }
        onChanged();
      }
      if (!other.getHost().isEmpty()) {
        host_ = other.host_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.applications_.isEmpty()) {
        if (applications_.isEmpty()) {
          applications_ = other.applications_;
          bitField0_ |= 0x00000008;
        } else {
          ensureApplicationsIsMutable();
          applications_.addAll(other.applications_);
        }
        onChanged();
      }
      if (!other.getStoragePool().isEmpty()) {
        storagePool_ = other.storagePool_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.policyOptions_.isEmpty()) {
        if (policyOptions_.isEmpty()) {
          policyOptions_ = other.policyOptions_;
          bitField0_ |= 0x00000020;
        } else {
          ensurePolicyOptionsIsMutable();
          policyOptions_.addAll(other.policyOptions_);
        }
        onChanged();
      }
      if (!other.getProfile().isEmpty()) {
        profile_ = other.profile_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getAppliance().isEmpty()) {
        appliance_ = other.appliance_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getBackupType().isEmpty()) {
        backupType_ = other.backupType_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasBackupCreateTime()) {
        mergeBackupCreateTime(other.getBackupCreateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                backupTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePoliciesIsMutable();
                policies_.add(s);
                break;
              } // case 18
            case 26:
              {
                host_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureApplicationsIsMutable();
                applications_.add(s);
                break;
              } // case 34
            case 42:
              {
                storagePool_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePolicyOptionsIsMutable();
                policyOptions_.add(s);
                break;
              } // case 50
            case 58:
              {
                profile_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                appliance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                backupType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getBackupCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object backupTemplate_ = "";
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR template which comprises one or more backup
     * policies. See the [Backup and DR
     * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
     * for more information. For example, `snap-ov`.
     * </pre>
     *
     * <code>string backup_template = 1;</code>
     *
     * @return The backupTemplate.
     */
    public java.lang.String getBackupTemplate() {
      java.lang.Object ref = backupTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backupTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR template which comprises one or more backup
     * policies. See the [Backup and DR
     * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
     * for more information. For example, `snap-ov`.
     * </pre>
     *
     * <code>string backup_template = 1;</code>
     *
     * @return The bytes for backupTemplate.
     */
    public com.google.protobuf.ByteString getBackupTemplateBytes() {
      java.lang.Object ref = backupTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backupTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR template which comprises one or more backup
     * policies. See the [Backup and DR
     * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
     * for more information. For example, `snap-ov`.
     * </pre>
     *
     * <code>string backup_template = 1;</code>
     *
     * @param value The backupTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setBackupTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backupTemplate_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR template which comprises one or more backup
     * policies. See the [Backup and DR
     * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
     * for more information. For example, `snap-ov`.
     * </pre>
     *
     * <code>string backup_template = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackupTemplate() {
      backupTemplate_ = getDefaultInstance().getBackupTemplate();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR template which comprises one or more backup
     * policies. See the [Backup and DR
     * documentation](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#temp)
     * for more information. For example, `snap-ov`.
     * </pre>
     *
     * <code>string backup_template = 1;</code>
     *
     * @param value The bytes for backupTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setBackupTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backupTemplate_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList policies_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePoliciesIsMutable() {
      if (!policies_.isModifiable()) {
        policies_ = new com.google.protobuf.LazyStringArrayList(policies_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     * </pre>
     *
     * <code>repeated string policies = 2;</code>
     *
     * @return A list containing the policies.
     */
    public com.google.protobuf.ProtocolStringList getPoliciesList() {
      policies_.makeImmutable();
      return policies_;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     * </pre>
     *
     * <code>repeated string policies = 2;</code>
     *
     * @return The count of policies.
     */
    public int getPoliciesCount() {
      return policies_.size();
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     * </pre>
     *
     * <code>repeated string policies = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The policies at the given index.
     */
    public java.lang.String getPolicies(int index) {
      return policies_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     * </pre>
     *
     * <code>repeated string policies = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the policies at the given index.
     */
    public com.google.protobuf.ByteString getPoliciesBytes(int index) {
      return policies_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     * </pre>
     *
     * <code>repeated string policies = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The policies to set.
     * @return This builder for chaining.
     */
    public Builder setPolicies(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePoliciesIsMutable();
      policies_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     * </pre>
     *
     * <code>repeated string policies = 2;</code>
     *
     * @param value The policies to add.
     * @return This builder for chaining.
     */
    public Builder addPolicies(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePoliciesIsMutable();
      policies_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     * </pre>
     *
     * <code>repeated string policies = 2;</code>
     *
     * @param values The policies to add.
     * @return This builder for chaining.
     */
    public Builder addAllPolicies(java.lang.Iterable<java.lang.String> values) {
      ensurePoliciesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, policies_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     * </pre>
     *
     * <code>repeated string policies = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicies() {
      policies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR policies that are associated with a template
     * and that define when to run a backup, how frequently to run a backup, and
     * how long to retain the backup image. For example, `onvaults`.
     * </pre>
     *
     * <code>repeated string policies = 2;</code>
     *
     * @param value The bytes of the policies to add.
     * @return This builder for chaining.
     */
    public Builder addPoliciesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePoliciesIsMutable();
      policies_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object host_ = "";
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR host, which is managed by the backup and
     * recovery appliance and known to the management console. The host can be of
     * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
     * system, etc.), vCenter, or an ESX server. See the [Backup and DR
     * documentation on
     * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
     * for more information. For example, `centos7-01`.
     * </pre>
     *
     * <code>string host = 3;</code>
     *
     * @return The host.
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR host, which is managed by the backup and
     * recovery appliance and known to the management console. The host can be of
     * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
     * system, etc.), vCenter, or an ESX server. See the [Backup and DR
     * documentation on
     * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
     * for more information. For example, `centos7-01`.
     * </pre>
     *
     * <code>string host = 3;</code>
     *
     * @return The bytes for host.
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR host, which is managed by the backup and
     * recovery appliance and known to the management console. The host can be of
     * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
     * system, etc.), vCenter, or an ESX server. See the [Backup and DR
     * documentation on
     * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
     * for more information. For example, `centos7-01`.
     * </pre>
     *
     * <code>string host = 3;</code>
     *
     * @param value The host to set.
     * @return This builder for chaining.
     */
    public Builder setHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      host_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR host, which is managed by the backup and
     * recovery appliance and known to the management console. The host can be of
     * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
     * system, etc.), vCenter, or an ESX server. See the [Backup and DR
     * documentation on
     * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
     * for more information. For example, `centos7-01`.
     * </pre>
     *
     * <code>string host = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHost() {
      host_ = getDefaultInstance().getHost();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a Backup and DR host, which is managed by the backup and
     * recovery appliance and known to the management console. The host can be of
     * type Generic (for example, Compute Engine, SQL Server, Oracle DB, SMB file
     * system, etc.), vCenter, or an ESX server. See the [Backup and DR
     * documentation on
     * hosts](https://cloud.google.com/backup-disaster-recovery/docs/configuration/manage-hosts-and-their-applications)
     * for more information. For example, `centos7-01`.
     * </pre>
     *
     * <code>string host = 3;</code>
     *
     * @param value The bytes for host to set.
     * @return This builder for chaining.
     */
    public Builder setHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      host_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList applications_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureApplicationsIsMutable() {
      if (!applications_.isModifiable()) {
        applications_ = new com.google.protobuf.LazyStringArrayList(applications_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     * </pre>
     *
     * <code>repeated string applications = 4;</code>
     *
     * @return A list containing the applications.
     */
    public com.google.protobuf.ProtocolStringList getApplicationsList() {
      applications_.makeImmutable();
      return applications_;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     * </pre>
     *
     * <code>repeated string applications = 4;</code>
     *
     * @return The count of applications.
     */
    public int getApplicationsCount() {
      return applications_.size();
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     * </pre>
     *
     * <code>repeated string applications = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The applications at the given index.
     */
    public java.lang.String getApplications(int index) {
      return applications_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     * </pre>
     *
     * <code>repeated string applications = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the applications at the given index.
     */
    public com.google.protobuf.ByteString getApplicationsBytes(int index) {
      return applications_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     * </pre>
     *
     * <code>repeated string applications = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The applications to set.
     * @return This builder for chaining.
     */
    public Builder setApplications(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureApplicationsIsMutable();
      applications_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     * </pre>
     *
     * <code>repeated string applications = 4;</code>
     *
     * @param value The applications to add.
     * @return This builder for chaining.
     */
    public Builder addApplications(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureApplicationsIsMutable();
      applications_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     * </pre>
     *
     * <code>repeated string applications = 4;</code>
     *
     * @param values The applications to add.
     * @return This builder for chaining.
     */
    public Builder addAllApplications(java.lang.Iterable<java.lang.String> values) {
      ensureApplicationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, applications_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     * </pre>
     *
     * <code>repeated string applications = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApplications() {
      applications_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR applications. An application is a VM, database,
     * or file system on a managed host monitored by a backup and recovery
     * appliance. For example, `centos7-01-vol00`, `centos7-01-vol01`,
     * `centos7-01-vol02`.
     * </pre>
     *
     * <code>repeated string applications = 4;</code>
     *
     * @param value The bytes of the applications to add.
     * @return This builder for chaining.
     */
    public Builder addApplicationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureApplicationsIsMutable();
      applications_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object storagePool_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR storage pool that the backup and recovery
     * appliance is storing data in. The storage pool could be of type Cloud,
     * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
     * storage
     * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
     * For example, `DiskPoolOne`.
     * </pre>
     *
     * <code>string storage_pool = 5;</code>
     *
     * @return The storagePool.
     */
    public java.lang.String getStoragePool() {
      java.lang.Object ref = storagePool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        storagePool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR storage pool that the backup and recovery
     * appliance is storing data in. The storage pool could be of type Cloud,
     * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
     * storage
     * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
     * For example, `DiskPoolOne`.
     * </pre>
     *
     * <code>string storage_pool = 5;</code>
     *
     * @return The bytes for storagePool.
     */
    public com.google.protobuf.ByteString getStoragePoolBytes() {
      java.lang.Object ref = storagePool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        storagePool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR storage pool that the backup and recovery
     * appliance is storing data in. The storage pool could be of type Cloud,
     * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
     * storage
     * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
     * For example, `DiskPoolOne`.
     * </pre>
     *
     * <code>string storage_pool = 5;</code>
     *
     * @param value The storagePool to set.
     * @return This builder for chaining.
     */
    public Builder setStoragePool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      storagePool_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR storage pool that the backup and recovery
     * appliance is storing data in. The storage pool could be of type Cloud,
     * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
     * storage
     * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
     * For example, `DiskPoolOne`.
     * </pre>
     *
     * <code>string storage_pool = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStoragePool() {
      storagePool_ = getDefaultInstance().getStoragePool();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR storage pool that the backup and recovery
     * appliance is storing data in. The storage pool could be of type Cloud,
     * Primary, Snapshot, or OnVault. See the [Backup and DR documentation on
     * storage
     * pools](https://cloud.google.com/backup-disaster-recovery/docs/concepts/storage-pools).
     * For example, `DiskPoolOne`.
     * </pre>
     *
     * <code>string storage_pool = 5;</code>
     *
     * @param value The bytes for storagePool to set.
     * @return This builder for chaining.
     */
    public Builder setStoragePoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      storagePool_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList policyOptions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePolicyOptionsIsMutable() {
      if (!policyOptions_.isModifiable()) {
        policyOptions_ = new com.google.protobuf.LazyStringArrayList(policyOptions_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     * </pre>
     *
     * <code>repeated string policy_options = 6;</code>
     *
     * @return A list containing the policyOptions.
     */
    public com.google.protobuf.ProtocolStringList getPolicyOptionsList() {
      policyOptions_.makeImmutable();
      return policyOptions_;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     * </pre>
     *
     * <code>repeated string policy_options = 6;</code>
     *
     * @return The count of policyOptions.
     */
    public int getPolicyOptionsCount() {
      return policyOptions_.size();
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     * </pre>
     *
     * <code>repeated string policy_options = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The policyOptions at the given index.
     */
    public java.lang.String getPolicyOptions(int index) {
      return policyOptions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     * </pre>
     *
     * <code>repeated string policy_options = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the policyOptions at the given index.
     */
    public com.google.protobuf.ByteString getPolicyOptionsBytes(int index) {
      return policyOptions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     * </pre>
     *
     * <code>repeated string policy_options = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The policyOptions to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyOptions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePolicyOptionsIsMutable();
      policyOptions_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     * </pre>
     *
     * <code>repeated string policy_options = 6;</code>
     *
     * @param value The policyOptions to add.
     * @return This builder for chaining.
     */
    public Builder addPolicyOptions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePolicyOptionsIsMutable();
      policyOptions_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     * </pre>
     *
     * <code>repeated string policy_options = 6;</code>
     *
     * @param values The policyOptions to add.
     * @return This builder for chaining.
     */
    public Builder addAllPolicyOptions(java.lang.Iterable<java.lang.String> values) {
      ensurePolicyOptionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, policyOptions_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     * </pre>
     *
     * <code>repeated string policy_options = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicyOptions() {
      policyOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of Backup and DR advanced policy options of a policy applying to
     * an application. See the [Backup and DR documentation on policy
     * options](https://cloud.google.com/backup-disaster-recovery/docs/create-plan/policy-settings).
     * For example, `skipofflineappsincongrp, nounmap`.
     * </pre>
     *
     * <code>repeated string policy_options = 6;</code>
     *
     * @param value The bytes of the policyOptions to add.
     * @return This builder for chaining.
     */
    public Builder addPolicyOptionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePolicyOptionsIsMutable();
      policyOptions_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object profile_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR resource profile that specifies the storage
     * media for backups of application and VM data. See the [Backup and DR
     * documentation on
     * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
     * For example, `GCP`.
     * </pre>
     *
     * <code>string profile = 7;</code>
     *
     * @return The profile.
     */
    public java.lang.String getProfile() {
      java.lang.Object ref = profile_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        profile_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR resource profile that specifies the storage
     * media for backups of application and VM data. See the [Backup and DR
     * documentation on
     * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
     * For example, `GCP`.
     * </pre>
     *
     * <code>string profile = 7;</code>
     *
     * @return The bytes for profile.
     */
    public com.google.protobuf.ByteString getProfileBytes() {
      java.lang.Object ref = profile_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        profile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR resource profile that specifies the storage
     * media for backups of application and VM data. See the [Backup and DR
     * documentation on
     * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
     * For example, `GCP`.
     * </pre>
     *
     * <code>string profile = 7;</code>
     *
     * @param value The profile to set.
     * @return This builder for chaining.
     */
    public Builder setProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      profile_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR resource profile that specifies the storage
     * media for backups of application and VM data. See the [Backup and DR
     * documentation on
     * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
     * For example, `GCP`.
     * </pre>
     *
     * <code>string profile = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProfile() {
      profile_ = getDefaultInstance().getProfile();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR resource profile that specifies the storage
     * media for backups of application and VM data. See the [Backup and DR
     * documentation on
     * profiles](https://cloud.google.com/backup-disaster-recovery/docs/concepts/backup-plan#profile).
     * For example, `GCP`.
     * </pre>
     *
     * <code>string profile = 7;</code>
     *
     * @param value The bytes for profile to set.
     * @return This builder for chaining.
     */
    public Builder setProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      profile_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object appliance_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR appliance that captures, moves, and manages
     * the lifecycle of backup data. For example, `backup-server-57137`.
     * </pre>
     *
     * <code>string appliance = 8;</code>
     *
     * @return The appliance.
     */
    public java.lang.String getAppliance() {
      java.lang.Object ref = appliance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appliance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR appliance that captures, moves, and manages
     * the lifecycle of backup data. For example, `backup-server-57137`.
     * </pre>
     *
     * <code>string appliance = 8;</code>
     *
     * @return The bytes for appliance.
     */
    public com.google.protobuf.ByteString getApplianceBytes() {
      java.lang.Object ref = appliance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appliance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR appliance that captures, moves, and manages
     * the lifecycle of backup data. For example, `backup-server-57137`.
     * </pre>
     *
     * <code>string appliance = 8;</code>
     *
     * @param value The appliance to set.
     * @return This builder for chaining.
     */
    public Builder setAppliance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      appliance_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR appliance that captures, moves, and manages
     * the lifecycle of backup data. For example, `backup-server-57137`.
     * </pre>
     *
     * <code>string appliance = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppliance() {
      appliance_ = getDefaultInstance().getAppliance();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Backup and DR appliance that captures, moves, and manages
     * the lifecycle of backup data. For example, `backup-server-57137`.
     * </pre>
     *
     * <code>string appliance = 8;</code>
     *
     * @param value The bytes for appliance to set.
     * @return This builder for chaining.
     */
    public Builder setApplianceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      appliance_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object backupType_ = "";
    /**
     *
     *
     * <pre>
     * The backup type of the Backup and DR image.
     * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
     * </pre>
     *
     * <code>string backup_type = 9;</code>
     *
     * @return The backupType.
     */
    public java.lang.String getBackupType() {
      java.lang.Object ref = backupType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backupType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The backup type of the Backup and DR image.
     * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
     * </pre>
     *
     * <code>string backup_type = 9;</code>
     *
     * @return The bytes for backupType.
     */
    public com.google.protobuf.ByteString getBackupTypeBytes() {
      java.lang.Object ref = backupType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backupType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The backup type of the Backup and DR image.
     * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
     * </pre>
     *
     * <code>string backup_type = 9;</code>
     *
     * @param value The backupType to set.
     * @return This builder for chaining.
     */
    public Builder setBackupType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backupType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup type of the Backup and DR image.
     * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
     * </pre>
     *
     * <code>string backup_type = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackupType() {
      backupType_ = getDefaultInstance().getBackupType();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup type of the Backup and DR image.
     * For example, `Snapshot`, `Remote Snapshot`, `OnVault`.
     * </pre>
     *
     * <code>string backup_type = 9;</code>
     *
     * @param value The bytes for backupType to set.
     * @return This builder for chaining.
     */
    public Builder setBackupTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backupType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp backupCreateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        backupCreateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp at which the Backup and DR backup was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     *
     * @return Whether the backupCreateTime field is set.
     */
    public boolean hasBackupCreateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp at which the Backup and DR backup was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     *
     * @return The backupCreateTime.
     */
    public com.google.protobuf.Timestamp getBackupCreateTime() {
      if (backupCreateTimeBuilder_ == null) {
        return backupCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : backupCreateTime_;
      } else {
        return backupCreateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp at which the Backup and DR backup was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     */
    public Builder setBackupCreateTime(com.google.protobuf.Timestamp value) {
      if (backupCreateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backupCreateTime_ = value;
      } else {
        backupCreateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp at which the Backup and DR backup was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     */
    public Builder setBackupCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (backupCreateTimeBuilder_ == null) {
        backupCreateTime_ = builderForValue.build();
      } else {
        backupCreateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp at which the Backup and DR backup was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     */
    public Builder mergeBackupCreateTime(com.google.protobuf.Timestamp value) {
      if (backupCreateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && backupCreateTime_ != null
            && backupCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getBackupCreateTimeBuilder().mergeFrom(value);
        } else {
          backupCreateTime_ = value;
        }
      } else {
        backupCreateTimeBuilder_.mergeFrom(value);
      }
      if (backupCreateTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp at which the Backup and DR backup was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     */
    public Builder clearBackupCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      backupCreateTime_ = null;
      if (backupCreateTimeBuilder_ != null) {
        backupCreateTimeBuilder_.dispose();
        backupCreateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp at which the Backup and DR backup was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getBackupCreateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getBackupCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp at which the Backup and DR backup was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getBackupCreateTimeOrBuilder() {
      if (backupCreateTimeBuilder_ != null) {
        return backupCreateTimeBuilder_.getMessageOrBuilder();
      } else {
        return backupCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : backupCreateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp at which the Backup and DR backup was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp backup_create_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getBackupCreateTimeFieldBuilder() {
      if (backupCreateTimeBuilder_ == null) {
        backupCreateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getBackupCreateTime(), getParentForChildren(), isClean());
        backupCreateTime_ = null;
      }
      return backupCreateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.BackupDisasterRecovery)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.BackupDisasterRecovery)
  private static final com.google.cloud.securitycenter.v1.BackupDisasterRecovery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.BackupDisasterRecovery();
  }

  public static com.google.cloud.securitycenter.v1.BackupDisasterRecovery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackupDisasterRecovery> PARSER =
      new com.google.protobuf.AbstractParser<BackupDisasterRecovery>() {
        @java.lang.Override
        public BackupDisasterRecovery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackupDisasterRecovery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackupDisasterRecovery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.BackupDisasterRecovery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
