/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/effective_security_health_analytics_custom_module.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * An EffectiveSecurityHealthAnalyticsCustomModule is the representation of
 * a Security Health Analytics custom module at a specified level of the
 * resource hierarchy: organization, folder, or project. If a custom module is
 * inherited from a parent organization or folder, the value of the
 * `enablementState` property in EffectiveSecurityHealthAnalyticsCustomModule is
 * set to the value that is effective in the parent, instead of  `INHERITED`.
 * For example, if the module is enabled in a parent organization or folder, the
 * effective enablement_state for the module in all child folders or projects is
 * also `enabled`. EffectiveSecurityHealthAnalyticsCustomModule is read-only.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule}
 */
public final class EffectiveSecurityHealthAnalyticsCustomModule
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule)
    EffectiveSecurityHealthAnalyticsCustomModuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EffectiveSecurityHealthAnalyticsCustomModule.newBuilder() to construct.
  private EffectiveSecurityHealthAnalyticsCustomModule(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EffectiveSecurityHealthAnalyticsCustomModule() {
    name_ = "";
    enablementState_ = 0;
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EffectiveSecurityHealthAnalyticsCustomModule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModuleProto
        .internal_static_google_cloud_securitycenter_v1_EffectiveSecurityHealthAnalyticsCustomModule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModuleProto
        .internal_static_google_cloud_securitycenter_v1_EffectiveSecurityHealthAnalyticsCustomModule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.class,
            com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * The enablement state of the module.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState}
   */
  public enum EnablementState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified enablement state.
     * </pre>
     *
     * <code>ENABLEMENT_STATE_UNSPECIFIED = 0;</code>
     */
    ENABLEMENT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The module is enabled at the given level.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * The module is disabled at the given level.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified enablement state.
     * </pre>
     *
     * <code>ENABLEMENT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int ENABLEMENT_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The module is enabled at the given level.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The module is disabled at the given level.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EnablementState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EnablementState forNumber(int value) {
      switch (value) {
        case 0:
          return ENABLEMENT_STATE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EnablementState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EnablementState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EnablementState>() {
              public EnablementState findValueByNumber(int number) {
                return EnablementState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EnablementState[] VALUES = values();

    public static EnablementState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EnablementState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the custom module.
   * Its format is
   * "organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
   * or
   * "folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
   * or
   * "projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}"
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the custom module.
   * Its format is
   * "organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
   * or
   * "folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
   * or
   * "projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}"
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.securitycenter.v1.CustomConfig customConfig_;
  /**
   *
   *
   * <pre>
   * Output only. The user-specified configuration for the module.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the customConfig field is set.
   */
  @java.lang.Override
  public boolean hasCustomConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The user-specified configuration for the module.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The customConfig.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfig getCustomConfig() {
    return customConfig_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
        : customConfig_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The user-specified configuration for the module.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfigOrBuilder getCustomConfigOrBuilder() {
    return customConfig_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
        : customConfig_;
  }

  public static final int ENABLEMENT_STATE_FIELD_NUMBER = 3;
  private int enablementState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The effective state of enablement for the module at the given
   * level of the hierarchy.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for enablementState.
   */
  @java.lang.Override
  public int getEnablementStateValue() {
    return enablementState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The effective state of enablement for the module at the given
   * level of the hierarchy.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enablementState.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
          .EnablementState
      getEnablementState() {
    com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState
        result =
            com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
                .EnablementState.forNumber(enablementState_);
    return result == null
        ? com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
            .EnablementState.UNRECOGNIZED
        : result;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The display name for the custom module. The name must be
   * between 1 and 128 characters, start with a lowercase letter, and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The display name for the custom module. The name must be
   * between 1 and 128 characters, start with a lowercase letter, and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCustomConfig());
    }
    if (enablementState_
        != com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
            .EnablementState.ENABLEMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, enablementState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCustomConfig());
    }
    if (enablementState_
        != com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
            .EnablementState.ENABLEMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, enablementState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule other =
        (com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCustomConfig() != other.hasCustomConfig()) return false;
    if (hasCustomConfig()) {
      if (!getCustomConfig().equals(other.getCustomConfig())) return false;
    }
    if (enablementState_ != other.enablementState_) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCustomConfig()) {
      hash = (37 * hash) + CUSTOM_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCustomConfig().hashCode();
    }
    hash = (37 * hash) + ENABLEMENT_STATE_FIELD_NUMBER;
    hash = (53 * hash) + enablementState_;
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An EffectiveSecurityHealthAnalyticsCustomModule is the representation of
   * a Security Health Analytics custom module at a specified level of the
   * resource hierarchy: organization, folder, or project. If a custom module is
   * inherited from a parent organization or folder, the value of the
   * `enablementState` property in EffectiveSecurityHealthAnalyticsCustomModule is
   * set to the value that is effective in the parent, instead of  `INHERITED`.
   * For example, if the module is enabled in a parent organization or folder, the
   * effective enablement_state for the module in all child folders or projects is
   * also `enabled`. EffectiveSecurityHealthAnalyticsCustomModule is read-only.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule)
      com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModuleProto
          .internal_static_google_cloud_securitycenter_v1_EffectiveSecurityHealthAnalyticsCustomModule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModuleProto
          .internal_static_google_cloud_securitycenter_v1_EffectiveSecurityHealthAnalyticsCustomModule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.class,
              com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCustomConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      customConfig_ = null;
      if (customConfigBuilder_ != null) {
        customConfigBuilder_.dispose();
        customConfigBuilder_ = null;
      }
      enablementState_ = 0;
      displayName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModuleProto
          .internal_static_google_cloud_securitycenter_v1_EffectiveSecurityHealthAnalyticsCustomModule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
        getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule build() {
      com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
        buildPartial() {
      com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule result =
          new com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.customConfig_ =
            customConfigBuilder_ == null ? customConfig_ : customConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enablementState_ = enablementState_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule) {
        return mergeFrom(
            (com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule other) {
      if (other
          == com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
              .getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCustomConfig()) {
        mergeCustomConfig(other.getCustomConfig());
      }
      if (other.enablementState_ != 0) {
        setEnablementStateValue(other.getEnablementStateValue());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCustomConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                enablementState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1.CustomConfig customConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig,
            com.google.cloud.securitycenter.v1.CustomConfig.Builder,
            com.google.cloud.securitycenter.v1.CustomConfigOrBuilder>
        customConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The user-specified configuration for the module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the customConfig field is set.
     */
    public boolean hasCustomConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified configuration for the module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The customConfig.
     */
    public com.google.cloud.securitycenter.v1.CustomConfig getCustomConfig() {
      if (customConfigBuilder_ == null) {
        return customConfig_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
            : customConfig_;
      } else {
        return customConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified configuration for the module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCustomConfig(com.google.cloud.securitycenter.v1.CustomConfig value) {
      if (customConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customConfig_ = value;
      } else {
        customConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified configuration for the module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCustomConfig(
        com.google.cloud.securitycenter.v1.CustomConfig.Builder builderForValue) {
      if (customConfigBuilder_ == null) {
        customConfig_ = builderForValue.build();
      } else {
        customConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified configuration for the module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCustomConfig(com.google.cloud.securitycenter.v1.CustomConfig value) {
      if (customConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && customConfig_ != null
            && customConfig_
                != com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()) {
          getCustomConfigBuilder().mergeFrom(value);
        } else {
          customConfig_ = value;
        }
      } else {
        customConfigBuilder_.mergeFrom(value);
      }
      if (customConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified configuration for the module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCustomConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      customConfig_ = null;
      if (customConfigBuilder_ != null) {
        customConfigBuilder_.dispose();
        customConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified configuration for the module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfig.Builder getCustomConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCustomConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified configuration for the module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfigOrBuilder getCustomConfigOrBuilder() {
      if (customConfigBuilder_ != null) {
        return customConfigBuilder_.getMessageOrBuilder();
      } else {
        return customConfig_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
            : customConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified configuration for the module.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig,
            com.google.cloud.securitycenter.v1.CustomConfig.Builder,
            com.google.cloud.securitycenter.v1.CustomConfigOrBuilder>
        getCustomConfigFieldBuilder() {
      if (customConfigBuilder_ == null) {
        customConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.CustomConfig,
                com.google.cloud.securitycenter.v1.CustomConfig.Builder,
                com.google.cloud.securitycenter.v1.CustomConfigOrBuilder>(
                getCustomConfig(), getParentForChildren(), isClean());
        customConfig_ = null;
      }
      return customConfigBuilder_;
    }

    private int enablementState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The effective state of enablement for the module at the given
     * level of the hierarchy.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for enablementState.
     */
    @java.lang.Override
    public int getEnablementStateValue() {
      return enablementState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The effective state of enablement for the module at the given
     * level of the hierarchy.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for enablementState to set.
     * @return This builder for chaining.
     */
    public Builder setEnablementStateValue(int value) {
      enablementState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The effective state of enablement for the module at the given
     * level of the hierarchy.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enablementState.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
            .EnablementState
        getEnablementState() {
      com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
              .EnablementState
          result =
              com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
                  .EnablementState.forNumber(enablementState_);
      return result == null
          ? com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
              .EnablementState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The effective state of enablement for the module at the given
     * level of the hierarchy.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enablementState to set.
     * @return This builder for chaining.
     */
    public Builder setEnablementState(
        com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
                .EnablementState
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      enablementState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The effective state of enablement for the module at the given
     * level of the hierarchy.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnablementState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enablementState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The display name for the custom module. The name must be
     * between 1 and 128 characters, start with a lowercase letter, and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name for the custom module. The name must be
     * between 1 and 128 characters, start with a lowercase letter, and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name for the custom module. The name must be
     * between 1 and 128 characters, start with a lowercase letter, and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name for the custom module. The name must be
     * between 1 and 128 characters, start with a lowercase letter, and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name for the custom module. The name must be
     * between 1 and 128 characters, start with a lowercase letter, and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule)
  private static final com.google.cloud.securitycenter.v1
          .EffectiveSecurityHealthAnalyticsCustomModule
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule();
  }

  public static com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EffectiveSecurityHealthAnalyticsCustomModule>
      PARSER =
          new com.google.protobuf.AbstractParser<EffectiveSecurityHealthAnalyticsCustomModule>() {
            @java.lang.Override
            public EffectiveSecurityHealthAnalyticsCustomModule parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<EffectiveSecurityHealthAnalyticsCustomModule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EffectiveSecurityHealthAnalyticsCustomModule>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
