/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/exfiltration.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Exfiltration represents a data exfiltration attempt from one or more sources
 * to one or more targets. The `sources` attribute lists the sources of the
 * exfiltrated data. The `targets` attribute lists the destinations the data was
 * copied to.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Exfiltration}
 */
public final class Exfiltration extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Exfiltration)
    ExfiltrationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Exfiltration.newBuilder() to construct.
  private Exfiltration(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Exfiltration() {
    sources_ = java.util.Collections.emptyList();
    targets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Exfiltration();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.ExfiltrationProto
        .internal_static_google_cloud_securitycenter_v1_Exfiltration_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.ExfiltrationProto
        .internal_static_google_cloud_securitycenter_v1_Exfiltration_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Exfiltration.class,
            com.google.cloud.securitycenter.v1.Exfiltration.Builder.class);
  }

  public static final int SOURCES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.ExfilResource> sources_;
  /**
   *
   *
   * <pre>
   * If there are multiple sources, then the data is considered "joined" between
   * them. For instance, BigQuery can join multiple tables, and each
   * table would be considered a source.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.ExfilResource> getSourcesList() {
    return sources_;
  }
  /**
   *
   *
   * <pre>
   * If there are multiple sources, then the data is considered "joined" between
   * them. For instance, BigQuery can join multiple tables, and each
   * table would be considered a source.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>
      getSourcesOrBuilderList() {
    return sources_;
  }
  /**
   *
   *
   * <pre>
   * If there are multiple sources, then the data is considered "joined" between
   * them. For instance, BigQuery can join multiple tables, and each
   * table would be considered a source.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
   */
  @java.lang.Override
  public int getSourcesCount() {
    return sources_.size();
  }
  /**
   *
   *
   * <pre>
   * If there are multiple sources, then the data is considered "joined" between
   * them. For instance, BigQuery can join multiple tables, and each
   * table would be considered a source.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExfilResource getSources(int index) {
    return sources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If there are multiple sources, then the data is considered "joined" between
   * them. For instance, BigQuery can join multiple tables, and each
   * table would be considered a source.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder getSourcesOrBuilder(int index) {
    return sources_.get(index);
  }

  public static final int TARGETS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.ExfilResource> targets_;
  /**
   *
   *
   * <pre>
   * If there are multiple targets, each target would get a complete copy of the
   * "joined" source data.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.ExfilResource> getTargetsList() {
    return targets_;
  }
  /**
   *
   *
   * <pre>
   * If there are multiple targets, each target would get a complete copy of the
   * "joined" source data.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>
      getTargetsOrBuilderList() {
    return targets_;
  }
  /**
   *
   *
   * <pre>
   * If there are multiple targets, each target would get a complete copy of the
   * "joined" source data.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
   */
  @java.lang.Override
  public int getTargetsCount() {
    return targets_.size();
  }
  /**
   *
   *
   * <pre>
   * If there are multiple targets, each target would get a complete copy of the
   * "joined" source data.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExfilResource getTargets(int index) {
    return targets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If there are multiple targets, each target would get a complete copy of the
   * "joined" source data.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder getTargetsOrBuilder(int index) {
    return targets_.get(index);
  }

  public static final int TOTAL_EXFILTRATED_BYTES_FIELD_NUMBER = 3;
  private long totalExfiltratedBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Total exfiltrated bytes processed for the entire job.
   * </pre>
   *
   * <code>int64 total_exfiltrated_bytes = 3;</code>
   *
   * @return The totalExfiltratedBytes.
   */
  @java.lang.Override
  public long getTotalExfiltratedBytes() {
    return totalExfiltratedBytes_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < sources_.size(); i++) {
      output.writeMessage(1, sources_.get(i));
    }
    for (int i = 0; i < targets_.size(); i++) {
      output.writeMessage(2, targets_.get(i));
    }
    if (totalExfiltratedBytes_ != 0L) {
      output.writeInt64(3, totalExfiltratedBytes_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < sources_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, sources_.get(i));
    }
    for (int i = 0; i < targets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, targets_.get(i));
    }
    if (totalExfiltratedBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, totalExfiltratedBytes_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Exfiltration)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Exfiltration other =
        (com.google.cloud.securitycenter.v1.Exfiltration) obj;

    if (!getSourcesList().equals(other.getSourcesList())) return false;
    if (!getTargetsList().equals(other.getTargetsList())) return false;
    if (getTotalExfiltratedBytes() != other.getTotalExfiltratedBytes()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSourcesCount() > 0) {
      hash = (37 * hash) + SOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getSourcesList().hashCode();
    }
    if (getTargetsCount() > 0) {
      hash = (37 * hash) + TARGETS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetsList().hashCode();
    }
    hash = (37 * hash) + TOTAL_EXFILTRATED_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalExfiltratedBytes());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Exfiltration prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Exfiltration represents a data exfiltration attempt from one or more sources
   * to one or more targets. The `sources` attribute lists the sources of the
   * exfiltrated data. The `targets` attribute lists the destinations the data was
   * copied to.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Exfiltration}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Exfiltration)
      com.google.cloud.securitycenter.v1.ExfiltrationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.ExfiltrationProto
          .internal_static_google_cloud_securitycenter_v1_Exfiltration_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.ExfiltrationProto
          .internal_static_google_cloud_securitycenter_v1_Exfiltration_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Exfiltration.class,
              com.google.cloud.securitycenter.v1.Exfiltration.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Exfiltration.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (sourcesBuilder_ == null) {
        sources_ = java.util.Collections.emptyList();
      } else {
        sources_ = null;
        sourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (targetsBuilder_ == null) {
        targets_ = java.util.Collections.emptyList();
      } else {
        targets_ = null;
        targetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      totalExfiltratedBytes_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.ExfiltrationProto
          .internal_static_google_cloud_securitycenter_v1_Exfiltration_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Exfiltration getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Exfiltration.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Exfiltration build() {
      com.google.cloud.securitycenter.v1.Exfiltration result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Exfiltration buildPartial() {
      com.google.cloud.securitycenter.v1.Exfiltration result =
          new com.google.cloud.securitycenter.v1.Exfiltration(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.securitycenter.v1.Exfiltration result) {
      if (sourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          sources_ = java.util.Collections.unmodifiableList(sources_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.sources_ = sources_;
      } else {
        result.sources_ = sourcesBuilder_.build();
      }
      if (targetsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          targets_ = java.util.Collections.unmodifiableList(targets_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.targets_ = targets_;
      } else {
        result.targets_ = targetsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Exfiltration result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.totalExfiltratedBytes_ = totalExfiltratedBytes_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Exfiltration) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Exfiltration) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Exfiltration other) {
      if (other == com.google.cloud.securitycenter.v1.Exfiltration.getDefaultInstance())
        return this;
      if (sourcesBuilder_ == null) {
        if (!other.sources_.isEmpty()) {
          if (sources_.isEmpty()) {
            sources_ = other.sources_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSourcesIsMutable();
            sources_.addAll(other.sources_);
          }
          onChanged();
        }
      } else {
        if (!other.sources_.isEmpty()) {
          if (sourcesBuilder_.isEmpty()) {
            sourcesBuilder_.dispose();
            sourcesBuilder_ = null;
            sources_ = other.sources_;
            bitField0_ = (bitField0_ & ~0x00000001);
            sourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSourcesFieldBuilder()
                    : null;
          } else {
            sourcesBuilder_.addAllMessages(other.sources_);
          }
        }
      }
      if (targetsBuilder_ == null) {
        if (!other.targets_.isEmpty()) {
          if (targets_.isEmpty()) {
            targets_ = other.targets_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTargetsIsMutable();
            targets_.addAll(other.targets_);
          }
          onChanged();
        }
      } else {
        if (!other.targets_.isEmpty()) {
          if (targetsBuilder_.isEmpty()) {
            targetsBuilder_.dispose();
            targetsBuilder_ = null;
            targets_ = other.targets_;
            bitField0_ = (bitField0_ & ~0x00000002);
            targetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTargetsFieldBuilder()
                    : null;
          } else {
            targetsBuilder_.addAllMessages(other.targets_);
          }
        }
      }
      if (other.getTotalExfiltratedBytes() != 0L) {
        setTotalExfiltratedBytes(other.getTotalExfiltratedBytes());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.securitycenter.v1.ExfilResource m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.ExfilResource.parser(),
                        extensionRegistry);
                if (sourcesBuilder_ == null) {
                  ensureSourcesIsMutable();
                  sources_.add(m);
                } else {
                  sourcesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.securitycenter.v1.ExfilResource m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.ExfilResource.parser(),
                        extensionRegistry);
                if (targetsBuilder_ == null) {
                  ensureTargetsIsMutable();
                  targets_.add(m);
                } else {
                  targetsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                totalExfiltratedBytes_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.securitycenter.v1.ExfilResource> sources_ =
        java.util.Collections.emptyList();

    private void ensureSourcesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        sources_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.ExfilResource>(sources_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ExfilResource,
            com.google.cloud.securitycenter.v1.ExfilResource.Builder,
            com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>
        sourcesBuilder_;

    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.ExfilResource> getSourcesList() {
      if (sourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sources_);
      } else {
        return sourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public int getSourcesCount() {
      if (sourcesBuilder_ == null) {
        return sources_.size();
      } else {
        return sourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResource getSources(int index) {
      if (sourcesBuilder_ == null) {
        return sources_.get(index);
      } else {
        return sourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public Builder setSources(int index, com.google.cloud.securitycenter.v1.ExfilResource value) {
      if (sourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourcesIsMutable();
        sources_.set(index, value);
        onChanged();
      } else {
        sourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public Builder setSources(
        int index, com.google.cloud.securitycenter.v1.ExfilResource.Builder builderForValue) {
      if (sourcesBuilder_ == null) {
        ensureSourcesIsMutable();
        sources_.set(index, builderForValue.build());
        onChanged();
      } else {
        sourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public Builder addSources(com.google.cloud.securitycenter.v1.ExfilResource value) {
      if (sourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourcesIsMutable();
        sources_.add(value);
        onChanged();
      } else {
        sourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public Builder addSources(int index, com.google.cloud.securitycenter.v1.ExfilResource value) {
      if (sourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourcesIsMutable();
        sources_.add(index, value);
        onChanged();
      } else {
        sourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public Builder addSources(
        com.google.cloud.securitycenter.v1.ExfilResource.Builder builderForValue) {
      if (sourcesBuilder_ == null) {
        ensureSourcesIsMutable();
        sources_.add(builderForValue.build());
        onChanged();
      } else {
        sourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public Builder addSources(
        int index, com.google.cloud.securitycenter.v1.ExfilResource.Builder builderForValue) {
      if (sourcesBuilder_ == null) {
        ensureSourcesIsMutable();
        sources_.add(index, builderForValue.build());
        onChanged();
      } else {
        sourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public Builder addAllSources(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.ExfilResource> values) {
      if (sourcesBuilder_ == null) {
        ensureSourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sources_);
        onChanged();
      } else {
        sourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public Builder clearSources() {
      if (sourcesBuilder_ == null) {
        sources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        sourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public Builder removeSources(int index) {
      if (sourcesBuilder_ == null) {
        ensureSourcesIsMutable();
        sources_.remove(index);
        onChanged();
      } else {
        sourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResource.Builder getSourcesBuilder(int index) {
      return getSourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder getSourcesOrBuilder(
        int index) {
      if (sourcesBuilder_ == null) {
        return sources_.get(index);
      } else {
        return sourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>
        getSourcesOrBuilderList() {
      if (sourcesBuilder_ != null) {
        return sourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sources_);
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResource.Builder addSourcesBuilder() {
      return getSourcesFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.ExfilResource.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResource.Builder addSourcesBuilder(int index) {
      return getSourcesFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.ExfilResource.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If there are multiple sources, then the data is considered "joined" between
     * them. For instance, BigQuery can join multiple tables, and each
     * table would be considered a source.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource sources = 1;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.ExfilResource.Builder>
        getSourcesBuilderList() {
      return getSourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ExfilResource,
            com.google.cloud.securitycenter.v1.ExfilResource.Builder,
            com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>
        getSourcesFieldBuilder() {
      if (sourcesBuilder_ == null) {
        sourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.ExfilResource,
                com.google.cloud.securitycenter.v1.ExfilResource.Builder,
                com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>(
                sources_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        sources_ = null;
      }
      return sourcesBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.ExfilResource> targets_ =
        java.util.Collections.emptyList();

    private void ensureTargetsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        targets_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.ExfilResource>(targets_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ExfilResource,
            com.google.cloud.securitycenter.v1.ExfilResource.Builder,
            com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>
        targetsBuilder_;

    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.ExfilResource> getTargetsList() {
      if (targetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(targets_);
      } else {
        return targetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public int getTargetsCount() {
      if (targetsBuilder_ == null) {
        return targets_.size();
      } else {
        return targetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResource getTargets(int index) {
      if (targetsBuilder_ == null) {
        return targets_.get(index);
      } else {
        return targetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public Builder setTargets(int index, com.google.cloud.securitycenter.v1.ExfilResource value) {
      if (targetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetsIsMutable();
        targets_.set(index, value);
        onChanged();
      } else {
        targetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public Builder setTargets(
        int index, com.google.cloud.securitycenter.v1.ExfilResource.Builder builderForValue) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        targets_.set(index, builderForValue.build());
        onChanged();
      } else {
        targetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public Builder addTargets(com.google.cloud.securitycenter.v1.ExfilResource value) {
      if (targetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetsIsMutable();
        targets_.add(value);
        onChanged();
      } else {
        targetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public Builder addTargets(int index, com.google.cloud.securitycenter.v1.ExfilResource value) {
      if (targetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetsIsMutable();
        targets_.add(index, value);
        onChanged();
      } else {
        targetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public Builder addTargets(
        com.google.cloud.securitycenter.v1.ExfilResource.Builder builderForValue) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        targets_.add(builderForValue.build());
        onChanged();
      } else {
        targetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public Builder addTargets(
        int index, com.google.cloud.securitycenter.v1.ExfilResource.Builder builderForValue) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        targets_.add(index, builderForValue.build());
        onChanged();
      } else {
        targetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public Builder addAllTargets(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.ExfilResource> values) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targets_);
        onChanged();
      } else {
        targetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public Builder clearTargets() {
      if (targetsBuilder_ == null) {
        targets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        targetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public Builder removeTargets(int index) {
      if (targetsBuilder_ == null) {
        ensureTargetsIsMutable();
        targets_.remove(index);
        onChanged();
      } else {
        targetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResource.Builder getTargetsBuilder(int index) {
      return getTargetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder getTargetsOrBuilder(
        int index) {
      if (targetsBuilder_ == null) {
        return targets_.get(index);
      } else {
        return targetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>
        getTargetsOrBuilderList() {
      if (targetsBuilder_ != null) {
        return targetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(targets_);
      }
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResource.Builder addTargetsBuilder() {
      return getTargetsFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.ExfilResource.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.ExfilResource.Builder addTargetsBuilder(int index) {
      return getTargetsFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.ExfilResource.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If there are multiple targets, each target would get a complete copy of the
     * "joined" source data.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.ExfilResource targets = 2;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.ExfilResource.Builder>
        getTargetsBuilderList() {
      return getTargetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ExfilResource,
            com.google.cloud.securitycenter.v1.ExfilResource.Builder,
            com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>
        getTargetsFieldBuilder() {
      if (targetsBuilder_ == null) {
        targetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.ExfilResource,
                com.google.cloud.securitycenter.v1.ExfilResource.Builder,
                com.google.cloud.securitycenter.v1.ExfilResourceOrBuilder>(
                targets_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        targets_ = null;
      }
      return targetsBuilder_;
    }

    private long totalExfiltratedBytes_;
    /**
     *
     *
     * <pre>
     * Total exfiltrated bytes processed for the entire job.
     * </pre>
     *
     * <code>int64 total_exfiltrated_bytes = 3;</code>
     *
     * @return The totalExfiltratedBytes.
     */
    @java.lang.Override
    public long getTotalExfiltratedBytes() {
      return totalExfiltratedBytes_;
    }
    /**
     *
     *
     * <pre>
     * Total exfiltrated bytes processed for the entire job.
     * </pre>
     *
     * <code>int64 total_exfiltrated_bytes = 3;</code>
     *
     * @param value The totalExfiltratedBytes to set.
     * @return This builder for chaining.
     */
    public Builder setTotalExfiltratedBytes(long value) {

      totalExfiltratedBytes_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total exfiltrated bytes processed for the entire job.
     * </pre>
     *
     * <code>int64 total_exfiltrated_bytes = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalExfiltratedBytes() {
      bitField0_ = (bitField0_ & ~0x00000004);
      totalExfiltratedBytes_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Exfiltration)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Exfiltration)
  private static final com.google.cloud.securitycenter.v1.Exfiltration DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Exfiltration();
  }

  public static com.google.cloud.securitycenter.v1.Exfiltration getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Exfiltration> PARSER =
      new com.google.protobuf.AbstractParser<Exfiltration>() {
        @java.lang.Override
        public Exfiltration parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Exfiltration> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Exfiltration> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Exfiltration getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
