/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/external_system.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Representation of third party SIEM/SOAR fields within SCC.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.ExternalSystem}
 */
public final class ExternalSystem extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.ExternalSystem)
    ExternalSystemOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExternalSystem.newBuilder() to construct.
  private ExternalSystem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExternalSystem() {
    name_ = "";
    assignees_ = com.google.protobuf.LazyStringArrayList.emptyList();
    externalUid_ = "";
    status_ = "";
    caseUri_ = "";
    casePriority_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExternalSystem();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.ExternalSystemProto
        .internal_static_google_cloud_securitycenter_v1_ExternalSystem_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.ExternalSystemProto
        .internal_static_google_cloud_securitycenter_v1_ExternalSystem_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.ExternalSystem.class,
            com.google.cloud.securitycenter.v1.ExternalSystem.Builder.class);
  }

  public interface TicketInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.ExternalSystem.TicketInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The identifier of the ticket in the ticket system.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * The identifier of the ticket in the ticket system.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * The assignee of the ticket in the ticket system.
     * </pre>
     *
     * <code>string assignee = 2;</code>
     *
     * @return The assignee.
     */
    java.lang.String getAssignee();
    /**
     *
     *
     * <pre>
     * The assignee of the ticket in the ticket system.
     * </pre>
     *
     * <code>string assignee = 2;</code>
     *
     * @return The bytes for assignee.
     */
    com.google.protobuf.ByteString getAssigneeBytes();

    /**
     *
     *
     * <pre>
     * The description of the ticket in the ticket system.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * The description of the ticket in the ticket system.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * The link to the ticket in the ticket system.
     * </pre>
     *
     * <code>string uri = 4;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * The link to the ticket in the ticket system.
     * </pre>
     *
     * <code>string uri = 4;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * The latest status of the ticket, as reported by the ticket system.
     * </pre>
     *
     * <code>string status = 5;</code>
     *
     * @return The status.
     */
    java.lang.String getStatus();
    /**
     *
     *
     * <pre>
     * The latest status of the ticket, as reported by the ticket system.
     * </pre>
     *
     * <code>string status = 5;</code>
     *
     * @return The bytes for status.
     */
    com.google.protobuf.ByteString getStatusBytes();

    /**
     *
     *
     * <pre>
     * The time when the ticket was last updated, as reported by the ticket
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     *
     * @return Whether the updateTime field is set.
     */
    boolean hasUpdateTime();
    /**
     *
     *
     * <pre>
     * The time when the ticket was last updated, as reported by the ticket
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     *
     * @return The updateTime.
     */
    com.google.protobuf.Timestamp getUpdateTime();
    /**
     *
     *
     * <pre>
     * The time when the ticket was last updated, as reported by the ticket
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     */
    com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Information about the ticket, if any, that is being used to track the
   * resolution of the issue that is identified by this finding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.ExternalSystem.TicketInfo}
   */
  public static final class TicketInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.ExternalSystem.TicketInfo)
      TicketInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TicketInfo.newBuilder() to construct.
    private TicketInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TicketInfo() {
      id_ = "";
      assignee_ = "";
      description_ = "";
      uri_ = "";
      status_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TicketInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.ExternalSystemProto
          .internal_static_google_cloud_securitycenter_v1_ExternalSystem_TicketInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.ExternalSystemProto
          .internal_static_google_cloud_securitycenter_v1_ExternalSystem_TicketInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.class,
              com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The identifier of the ticket in the ticket system.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of the ticket in the ticket system.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ASSIGNEE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object assignee_ = "";
    /**
     *
     *
     * <pre>
     * The assignee of the ticket in the ticket system.
     * </pre>
     *
     * <code>string assignee = 2;</code>
     *
     * @return The assignee.
     */
    @java.lang.Override
    public java.lang.String getAssignee() {
      java.lang.Object ref = assignee_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assignee_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The assignee of the ticket in the ticket system.
     * </pre>
     *
     * <code>string assignee = 2;</code>
     *
     * @return The bytes for assignee.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAssigneeBytes() {
      java.lang.Object ref = assignee_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        assignee_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the ticket in the ticket system.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the ticket in the ticket system.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int URI_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * The link to the ticket in the ticket system.
     * </pre>
     *
     * <code>string uri = 4;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The link to the ticket in the ticket system.
     * </pre>
     *
     * <code>string uri = 4;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * The latest status of the ticket, as reported by the ticket system.
     * </pre>
     *
     * <code>string status = 5;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The latest status of the ticket, as reported by the ticket system.
     * </pre>
     *
     * <code>string status = 5;</code>
     *
     * @return The bytes for status.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int UPDATE_TIME_FIELD_NUMBER = 6;
    private com.google.protobuf.Timestamp updateTime_;
    /**
     *
     *
     * <pre>
     * The time when the ticket was last updated, as reported by the ticket
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the ticket was last updated, as reported by the ticket
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }
    /**
     *
     *
     * <pre>
     * The time when the ticket was last updated, as reported by the ticket
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assignee_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, assignee_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(status_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, status_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(6, getUpdateTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assignee_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, assignee_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(status_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, status_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo other =
          (com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getAssignee().equals(other.getAssignee())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (!getUri().equals(other.getUri())) return false;
      if (!getStatus().equals(other.getStatus())) return false;
      if (hasUpdateTime() != other.hasUpdateTime()) return false;
      if (hasUpdateTime()) {
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + ASSIGNEE_FIELD_NUMBER;
      hash = (53 * hash) + getAssignee().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
      if (hasUpdateTime()) {
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.ExternalSystem.TicketInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.ExternalSystem.TicketInfo)
        com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.ExternalSystemProto
            .internal_static_google_cloud_securitycenter_v1_ExternalSystem_TicketInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.ExternalSystemProto
            .internal_static_google_cloud_securitycenter_v1_ExternalSystem_TicketInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.class,
                com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getUpdateTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        assignee_ = "";
        description_ = "";
        uri_ = "";
        status_ = "";
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.ExternalSystemProto
            .internal_static_google_cloud_securitycenter_v1_ExternalSystem_TicketInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo build() {
        com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo buildPartial() {
        com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo result =
            new com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.assignee_ = assignee_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.uri_ = uri_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.status_ = status_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.updateTime_ =
              updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo) {
          return mergeFrom((com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo other) {
        if (other
            == com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getAssignee().isEmpty()) {
          assignee_ = other.assignee_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getStatus().isEmpty()) {
          status_ = other.status_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasUpdateTime()) {
          mergeUpdateTime(other.getUpdateTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  assignee_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  uri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  status_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * The identifier of the ticket in the ticket system.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The identifier of the ticket in the ticket system.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The identifier of the ticket in the ticket system.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The identifier of the ticket in the ticket system.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The identifier of the ticket in the ticket system.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object assignee_ = "";
      /**
       *
       *
       * <pre>
       * The assignee of the ticket in the ticket system.
       * </pre>
       *
       * <code>string assignee = 2;</code>
       *
       * @return The assignee.
       */
      public java.lang.String getAssignee() {
        java.lang.Object ref = assignee_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          assignee_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The assignee of the ticket in the ticket system.
       * </pre>
       *
       * <code>string assignee = 2;</code>
       *
       * @return The bytes for assignee.
       */
      public com.google.protobuf.ByteString getAssigneeBytes() {
        java.lang.Object ref = assignee_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          assignee_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The assignee of the ticket in the ticket system.
       * </pre>
       *
       * <code>string assignee = 2;</code>
       *
       * @param value The assignee to set.
       * @return This builder for chaining.
       */
      public Builder setAssignee(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        assignee_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The assignee of the ticket in the ticket system.
       * </pre>
       *
       * <code>string assignee = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAssignee() {
        assignee_ = getDefaultInstance().getAssignee();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The assignee of the ticket in the ticket system.
       * </pre>
       *
       * <code>string assignee = 2;</code>
       *
       * @param value The bytes for assignee to set.
       * @return This builder for chaining.
       */
      public Builder setAssigneeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        assignee_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * The description of the ticket in the ticket system.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The description of the ticket in the ticket system.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The description of the ticket in the ticket system.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The description of the ticket in the ticket system.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The description of the ticket in the ticket system.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * The link to the ticket in the ticket system.
       * </pre>
       *
       * <code>string uri = 4;</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The link to the ticket in the ticket system.
       * </pre>
       *
       * <code>string uri = 4;</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The link to the ticket in the ticket system.
       * </pre>
       *
       * <code>string uri = 4;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        uri_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The link to the ticket in the ticket system.
       * </pre>
       *
       * <code>string uri = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        uri_ = getDefaultInstance().getUri();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The link to the ticket in the ticket system.
       * </pre>
       *
       * <code>string uri = 4;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        uri_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object status_ = "";
      /**
       *
       *
       * <pre>
       * The latest status of the ticket, as reported by the ticket system.
       * </pre>
       *
       * <code>string status = 5;</code>
       *
       * @return The status.
       */
      public java.lang.String getStatus() {
        java.lang.Object ref = status_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          status_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The latest status of the ticket, as reported by the ticket system.
       * </pre>
       *
       * <code>string status = 5;</code>
       *
       * @return The bytes for status.
       */
      public com.google.protobuf.ByteString getStatusBytes() {
        java.lang.Object ref = status_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          status_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The latest status of the ticket, as reported by the ticket system.
       * </pre>
       *
       * <code>string status = 5;</code>
       *
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The latest status of the ticket, as reported by the ticket system.
       * </pre>
       *
       * <code>string status = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        status_ = getDefaultInstance().getStatus();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The latest status of the ticket, as reported by the ticket system.
       * </pre>
       *
       * <code>string status = 5;</code>
       *
       * @param value The bytes for status to set.
       * @return This builder for chaining.
       */
      public Builder setStatusBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        status_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp updateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          updateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The time when the ticket was last updated, as reported by the ticket
       * system.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 6;</code>
       *
       * @return Whether the updateTime field is set.
       */
      public boolean hasUpdateTime() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * The time when the ticket was last updated, as reported by the ticket
       * system.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 6;</code>
       *
       * @return The updateTime.
       */
      public com.google.protobuf.Timestamp getUpdateTime() {
        if (updateTimeBuilder_ == null) {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        } else {
          return updateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time when the ticket was last updated, as reported by the ticket
       * system.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 6;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTime_ = value;
        } else {
          updateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time when the ticket was last updated, as reported by the ticket
       * system.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 6;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (updateTimeBuilder_ == null) {
          updateTime_ = builderForValue.build();
        } else {
          updateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time when the ticket was last updated, as reported by the ticket
       * system.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 6;</code>
       */
      public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && updateTime_ != null
              && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getUpdateTimeBuilder().mergeFrom(value);
          } else {
            updateTime_ = value;
          }
        } else {
          updateTimeBuilder_.mergeFrom(value);
        }
        if (updateTime_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time when the ticket was last updated, as reported by the ticket
       * system.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 6;</code>
       */
      public Builder clearUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000020);
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time when the ticket was last updated, as reported by the ticket
       * system.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 6;</code>
       */
      public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time when the ticket was last updated, as reported by the ticket
       * system.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 6;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
        if (updateTimeBuilder_ != null) {
          return updateTimeBuilder_.getMessageOrBuilder();
        } else {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time when the ticket was last updated, as reported by the ticket
       * system.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getUpdateTimeFieldBuilder() {
        if (updateTimeBuilder_ == null) {
          updateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getUpdateTime(), getParentForChildren(), isClean());
          updateTime_ = null;
        }
        return updateTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.ExternalSystem.TicketInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.ExternalSystem.TicketInfo)
    private static final com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo();
    }

    public static com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TicketInfo> PARSER =
        new com.google.protobuf.AbstractParser<TicketInfo>() {
          @java.lang.Override
          public TicketInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TicketInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TicketInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Full resource name of the external system, for example:
   * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
   * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
   * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Full resource name of the external system, for example:
   * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
   * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
   * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSIGNEES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList assignees_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * References primary/secondary etc assignees in the external system.
   * </pre>
   *
   * <code>repeated string assignees = 2;</code>
   *
   * @return A list containing the assignees.
   */
  public com.google.protobuf.ProtocolStringList getAssigneesList() {
    return assignees_;
  }
  /**
   *
   *
   * <pre>
   * References primary/secondary etc assignees in the external system.
   * </pre>
   *
   * <code>repeated string assignees = 2;</code>
   *
   * @return The count of assignees.
   */
  public int getAssigneesCount() {
    return assignees_.size();
  }
  /**
   *
   *
   * <pre>
   * References primary/secondary etc assignees in the external system.
   * </pre>
   *
   * <code>repeated string assignees = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The assignees at the given index.
   */
  public java.lang.String getAssignees(int index) {
    return assignees_.get(index);
  }
  /**
   *
   *
   * <pre>
   * References primary/secondary etc assignees in the external system.
   * </pre>
   *
   * <code>repeated string assignees = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the assignees at the given index.
   */
  public com.google.protobuf.ByteString getAssigneesBytes(int index) {
    return assignees_.getByteString(index);
  }

  public static final int EXTERNAL_UID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalUid_ = "";
  /**
   *
   *
   * <pre>
   * The identifier that's used to track the finding's corresponding case in the
   * external system.
   * </pre>
   *
   * <code>string external_uid = 3;</code>
   *
   * @return The externalUid.
   */
  @java.lang.Override
  public java.lang.String getExternalUid() {
    java.lang.Object ref = externalUid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalUid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The identifier that's used to track the finding's corresponding case in the
   * external system.
   * </pre>
   *
   * <code>string external_uid = 3;</code>
   *
   * @return The bytes for externalUid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalUidBytes() {
    java.lang.Object ref = externalUid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalUid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * The most recent status of the finding's corresponding case, as reported by
   * the external system.
   * </pre>
   *
   * <code>string status = 4;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The most recent status of the finding's corresponding case, as reported by
   * the external system.
   * </pre>
   *
   * <code>string status = 4;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_SYSTEM_UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp externalSystemUpdateTime_;
  /**
   *
   *
   * <pre>
   * The time when the case was last updated, as reported by the external
   * system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
   *
   * @return Whether the externalSystemUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasExternalSystemUpdateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the case was last updated, as reported by the external
   * system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
   *
   * @return The externalSystemUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExternalSystemUpdateTime() {
    return externalSystemUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : externalSystemUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the case was last updated, as reported by the external
   * system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExternalSystemUpdateTimeOrBuilder() {
    return externalSystemUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : externalSystemUpdateTime_;
  }

  public static final int CASE_URI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object caseUri_ = "";
  /**
   *
   *
   * <pre>
   * The link to the finding's corresponding case in the external system.
   * </pre>
   *
   * <code>string case_uri = 6;</code>
   *
   * @return The caseUri.
   */
  @java.lang.Override
  public java.lang.String getCaseUri() {
    java.lang.Object ref = caseUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      caseUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The link to the finding's corresponding case in the external system.
   * </pre>
   *
   * <code>string case_uri = 6;</code>
   *
   * @return The bytes for caseUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCaseUriBytes() {
    java.lang.Object ref = caseUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      caseUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CASE_PRIORITY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object casePriority_ = "";
  /**
   *
   *
   * <pre>
   * The priority of the finding's corresponding case in the external system.
   * </pre>
   *
   * <code>string case_priority = 7;</code>
   *
   * @return The casePriority.
   */
  @java.lang.Override
  public java.lang.String getCasePriority() {
    java.lang.Object ref = casePriority_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      casePriority_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The priority of the finding's corresponding case in the external system.
   * </pre>
   *
   * <code>string case_priority = 7;</code>
   *
   * @return The bytes for casePriority.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCasePriorityBytes() {
    java.lang.Object ref = casePriority_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      casePriority_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CASE_SLA_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp caseSla_;
  /**
   *
   *
   * <pre>
   * The SLA of the finding's corresponding case in the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp case_sla = 9;</code>
   *
   * @return Whether the caseSla field is set.
   */
  @java.lang.Override
  public boolean hasCaseSla() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The SLA of the finding's corresponding case in the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp case_sla = 9;</code>
   *
   * @return The caseSla.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCaseSla() {
    return caseSla_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : caseSla_;
  }
  /**
   *
   *
   * <pre>
   * The SLA of the finding's corresponding case in the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp case_sla = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCaseSlaOrBuilder() {
    return caseSla_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : caseSla_;
  }

  public static final int CASE_CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp caseCreateTime_;
  /**
   *
   *
   * <pre>
   * The time when the case was created, as reported by the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
   *
   * @return Whether the caseCreateTime field is set.
   */
  @java.lang.Override
  public boolean hasCaseCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the case was created, as reported by the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
   *
   * @return The caseCreateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCaseCreateTime() {
    return caseCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : caseCreateTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the case was created, as reported by the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCaseCreateTimeOrBuilder() {
    return caseCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : caseCreateTime_;
  }

  public static final int CASE_CLOSE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp caseCloseTime_;
  /**
   *
   *
   * <pre>
   * The time when the case was closed, as reported by the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
   *
   * @return Whether the caseCloseTime field is set.
   */
  @java.lang.Override
  public boolean hasCaseCloseTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the case was closed, as reported by the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
   *
   * @return The caseCloseTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCaseCloseTime() {
    return caseCloseTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : caseCloseTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the case was closed, as reported by the external system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCaseCloseTimeOrBuilder() {
    return caseCloseTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : caseCloseTime_;
  }

  public static final int TICKET_INFO_FIELD_NUMBER = 8;
  private com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticketInfo_;
  /**
   *
   *
   * <pre>
   * Information about the ticket, if any, that is being used to track the
   * resolution of the issue that is identified by this finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
   *
   * @return Whether the ticketInfo field is set.
   */
  @java.lang.Override
  public boolean hasTicketInfo() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Information about the ticket, if any, that is being used to track the
   * resolution of the issue that is identified by this finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
   *
   * @return The ticketInfo.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo getTicketInfo() {
    return ticketInfo_ == null
        ? com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.getDefaultInstance()
        : ticketInfo_;
  }
  /**
   *
   *
   * <pre>
   * Information about the ticket, if any, that is being used to track the
   * resolution of the issue that is identified by this finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfoOrBuilder
      getTicketInfoOrBuilder() {
    return ticketInfo_ == null
        ? com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.getDefaultInstance()
        : ticketInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < assignees_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, assignees_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalUid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, externalUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(status_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, status_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getExternalSystemUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caseUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, caseUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(casePriority_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, casePriority_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(8, getTicketInfo());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getCaseSla());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getCaseCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getCaseCloseTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < assignees_.size(); i++) {
        dataSize += computeStringSizeNoTag(assignees_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAssigneesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalUid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, externalUid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(status_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, status_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, getExternalSystemUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caseUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, caseUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(casePriority_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, casePriority_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTicketInfo());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCaseSla());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCaseCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCaseCloseTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.ExternalSystem)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.ExternalSystem other =
        (com.google.cloud.securitycenter.v1.ExternalSystem) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAssigneesList().equals(other.getAssigneesList())) return false;
    if (!getExternalUid().equals(other.getExternalUid())) return false;
    if (!getStatus().equals(other.getStatus())) return false;
    if (hasExternalSystemUpdateTime() != other.hasExternalSystemUpdateTime()) return false;
    if (hasExternalSystemUpdateTime()) {
      if (!getExternalSystemUpdateTime().equals(other.getExternalSystemUpdateTime())) return false;
    }
    if (!getCaseUri().equals(other.getCaseUri())) return false;
    if (!getCasePriority().equals(other.getCasePriority())) return false;
    if (hasCaseSla() != other.hasCaseSla()) return false;
    if (hasCaseSla()) {
      if (!getCaseSla().equals(other.getCaseSla())) return false;
    }
    if (hasCaseCreateTime() != other.hasCaseCreateTime()) return false;
    if (hasCaseCreateTime()) {
      if (!getCaseCreateTime().equals(other.getCaseCreateTime())) return false;
    }
    if (hasCaseCloseTime() != other.hasCaseCloseTime()) return false;
    if (hasCaseCloseTime()) {
      if (!getCaseCloseTime().equals(other.getCaseCloseTime())) return false;
    }
    if (hasTicketInfo() != other.hasTicketInfo()) return false;
    if (hasTicketInfo()) {
      if (!getTicketInfo().equals(other.getTicketInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getAssigneesCount() > 0) {
      hash = (37 * hash) + ASSIGNEES_FIELD_NUMBER;
      hash = (53 * hash) + getAssigneesList().hashCode();
    }
    hash = (37 * hash) + EXTERNAL_UID_FIELD_NUMBER;
    hash = (53 * hash) + getExternalUid().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + getStatus().hashCode();
    if (hasExternalSystemUpdateTime()) {
      hash = (37 * hash) + EXTERNAL_SYSTEM_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExternalSystemUpdateTime().hashCode();
    }
    hash = (37 * hash) + CASE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getCaseUri().hashCode();
    hash = (37 * hash) + CASE_PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + getCasePriority().hashCode();
    if (hasCaseSla()) {
      hash = (37 * hash) + CASE_SLA_FIELD_NUMBER;
      hash = (53 * hash) + getCaseSla().hashCode();
    }
    if (hasCaseCreateTime()) {
      hash = (37 * hash) + CASE_CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCaseCreateTime().hashCode();
    }
    if (hasCaseCloseTime()) {
      hash = (37 * hash) + CASE_CLOSE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCaseCloseTime().hashCode();
    }
    if (hasTicketInfo()) {
      hash = (37 * hash) + TICKET_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getTicketInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.ExternalSystem prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Representation of third party SIEM/SOAR fields within SCC.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.ExternalSystem}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.ExternalSystem)
      com.google.cloud.securitycenter.v1.ExternalSystemOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.ExternalSystemProto
          .internal_static_google_cloud_securitycenter_v1_ExternalSystem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.ExternalSystemProto
          .internal_static_google_cloud_securitycenter_v1_ExternalSystem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.ExternalSystem.class,
              com.google.cloud.securitycenter.v1.ExternalSystem.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.ExternalSystem.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExternalSystemUpdateTimeFieldBuilder();
        getCaseSlaFieldBuilder();
        getCaseCreateTimeFieldBuilder();
        getCaseCloseTimeFieldBuilder();
        getTicketInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      assignees_ = com.google.protobuf.LazyStringArrayList.emptyList();
      externalUid_ = "";
      status_ = "";
      externalSystemUpdateTime_ = null;
      if (externalSystemUpdateTimeBuilder_ != null) {
        externalSystemUpdateTimeBuilder_.dispose();
        externalSystemUpdateTimeBuilder_ = null;
      }
      caseUri_ = "";
      casePriority_ = "";
      caseSla_ = null;
      if (caseSlaBuilder_ != null) {
        caseSlaBuilder_.dispose();
        caseSlaBuilder_ = null;
      }
      caseCreateTime_ = null;
      if (caseCreateTimeBuilder_ != null) {
        caseCreateTimeBuilder_.dispose();
        caseCreateTimeBuilder_ = null;
      }
      caseCloseTime_ = null;
      if (caseCloseTimeBuilder_ != null) {
        caseCloseTimeBuilder_.dispose();
        caseCloseTimeBuilder_ = null;
      }
      ticketInfo_ = null;
      if (ticketInfoBuilder_ != null) {
        ticketInfoBuilder_.dispose();
        ticketInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.ExternalSystemProto
          .internal_static_google_cloud_securitycenter_v1_ExternalSystem_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ExternalSystem getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.ExternalSystem.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ExternalSystem build() {
      com.google.cloud.securitycenter.v1.ExternalSystem result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ExternalSystem buildPartial() {
      com.google.cloud.securitycenter.v1.ExternalSystem result =
          new com.google.cloud.securitycenter.v1.ExternalSystem(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.ExternalSystem result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        assignees_.makeImmutable();
        result.assignees_ = assignees_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.externalUid_ = externalUid_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.externalSystemUpdateTime_ =
            externalSystemUpdateTimeBuilder_ == null
                ? externalSystemUpdateTime_
                : externalSystemUpdateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.caseUri_ = caseUri_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.casePriority_ = casePriority_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.caseSla_ = caseSlaBuilder_ == null ? caseSla_ : caseSlaBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.caseCreateTime_ =
            caseCreateTimeBuilder_ == null ? caseCreateTime_ : caseCreateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.caseCloseTime_ =
            caseCloseTimeBuilder_ == null ? caseCloseTime_ : caseCloseTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.ticketInfo_ = ticketInfoBuilder_ == null ? ticketInfo_ : ticketInfoBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.ExternalSystem) {
        return mergeFrom((com.google.cloud.securitycenter.v1.ExternalSystem) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.ExternalSystem other) {
      if (other == com.google.cloud.securitycenter.v1.ExternalSystem.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.assignees_.isEmpty()) {
        if (assignees_.isEmpty()) {
          assignees_ = other.assignees_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAssigneesIsMutable();
          assignees_.addAll(other.assignees_);
        }
        onChanged();
      }
      if (!other.getExternalUid().isEmpty()) {
        externalUid_ = other.externalUid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getStatus().isEmpty()) {
        status_ = other.status_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasExternalSystemUpdateTime()) {
        mergeExternalSystemUpdateTime(other.getExternalSystemUpdateTime());
      }
      if (!other.getCaseUri().isEmpty()) {
        caseUri_ = other.caseUri_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getCasePriority().isEmpty()) {
        casePriority_ = other.casePriority_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasCaseSla()) {
        mergeCaseSla(other.getCaseSla());
      }
      if (other.hasCaseCreateTime()) {
        mergeCaseCreateTime(other.getCaseCreateTime());
      }
      if (other.hasCaseCloseTime()) {
        mergeCaseCloseTime(other.getCaseCloseTime());
      }
      if (other.hasTicketInfo()) {
        mergeTicketInfo(other.getTicketInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAssigneesIsMutable();
                assignees_.add(s);
                break;
              } // case 18
            case 26:
              {
                externalUid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getExternalSystemUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                caseUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                casePriority_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getTicketInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getCaseSlaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getCaseCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getCaseCloseTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full resource name of the external system, for example:
     * "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
     * "folders/1234/sources/5678/findings/123456/externalSystems/jira",
     * "projects/1234/sources/5678/findings/123456/externalSystems/jira"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList assignees_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAssigneesIsMutable() {
      if (!assignees_.isModifiable()) {
        assignees_ = new com.google.protobuf.LazyStringArrayList(assignees_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @return A list containing the assignees.
     */
    public com.google.protobuf.ProtocolStringList getAssigneesList() {
      assignees_.makeImmutable();
      return assignees_;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @return The count of assignees.
     */
    public int getAssigneesCount() {
      return assignees_.size();
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The assignees at the given index.
     */
    public java.lang.String getAssignees(int index) {
      return assignees_.get(index);
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the assignees at the given index.
     */
    public com.google.protobuf.ByteString getAssigneesBytes(int index) {
      return assignees_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The assignees to set.
     * @return This builder for chaining.
     */
    public Builder setAssignees(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssigneesIsMutable();
      assignees_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param value The assignees to add.
     * @return This builder for chaining.
     */
    public Builder addAssignees(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssigneesIsMutable();
      assignees_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param values The assignees to add.
     * @return This builder for chaining.
     */
    public Builder addAllAssignees(java.lang.Iterable<java.lang.String> values) {
      ensureAssigneesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, assignees_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssignees() {
      assignees_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * References primary/secondary etc assignees in the external system.
     * </pre>
     *
     * <code>repeated string assignees = 2;</code>
     *
     * @param value The bytes of the assignees to add.
     * @return This builder for chaining.
     */
    public Builder addAssigneesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAssigneesIsMutable();
      assignees_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object externalUid_ = "";
    /**
     *
     *
     * <pre>
     * The identifier that's used to track the finding's corresponding case in the
     * external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @return The externalUid.
     */
    public java.lang.String getExternalUid() {
      java.lang.Object ref = externalUid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalUid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier that's used to track the finding's corresponding case in the
     * external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @return The bytes for externalUid.
     */
    public com.google.protobuf.ByteString getExternalUidBytes() {
      java.lang.Object ref = externalUid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalUid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier that's used to track the finding's corresponding case in the
     * external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @param value The externalUid to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalUid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier that's used to track the finding's corresponding case in the
     * external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalUid() {
      externalUid_ = getDefaultInstance().getExternalUid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier that's used to track the finding's corresponding case in the
     * external system.
     * </pre>
     *
     * <code>string external_uid = 3;</code>
     *
     * @param value The bytes for externalUid to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalUid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * The most recent status of the finding's corresponding case, as reported by
     * the external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The most recent status of the finding's corresponding case, as reported by
     * the external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The most recent status of the finding's corresponding case, as reported by
     * the external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent status of the finding's corresponding case, as reported by
     * the external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most recent status of the finding's corresponding case, as reported by
     * the external system.
     * </pre>
     *
     * <code>string status = 4;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp externalSystemUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        externalSystemUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the case was last updated, as reported by the external
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     *
     * @return Whether the externalSystemUpdateTime field is set.
     */
    public boolean hasExternalSystemUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the case was last updated, as reported by the external
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     *
     * @return The externalSystemUpdateTime.
     */
    public com.google.protobuf.Timestamp getExternalSystemUpdateTime() {
      if (externalSystemUpdateTimeBuilder_ == null) {
        return externalSystemUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : externalSystemUpdateTime_;
      } else {
        return externalSystemUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the case was last updated, as reported by the external
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public Builder setExternalSystemUpdateTime(com.google.protobuf.Timestamp value) {
      if (externalSystemUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        externalSystemUpdateTime_ = value;
      } else {
        externalSystemUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was last updated, as reported by the external
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public Builder setExternalSystemUpdateTime(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (externalSystemUpdateTimeBuilder_ == null) {
        externalSystemUpdateTime_ = builderForValue.build();
      } else {
        externalSystemUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was last updated, as reported by the external
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public Builder mergeExternalSystemUpdateTime(com.google.protobuf.Timestamp value) {
      if (externalSystemUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && externalSystemUpdateTime_ != null
            && externalSystemUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExternalSystemUpdateTimeBuilder().mergeFrom(value);
        } else {
          externalSystemUpdateTime_ = value;
        }
      } else {
        externalSystemUpdateTimeBuilder_.mergeFrom(value);
      }
      if (externalSystemUpdateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was last updated, as reported by the external
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public Builder clearExternalSystemUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      externalSystemUpdateTime_ = null;
      if (externalSystemUpdateTimeBuilder_ != null) {
        externalSystemUpdateTimeBuilder_.dispose();
        externalSystemUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was last updated, as reported by the external
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExternalSystemUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getExternalSystemUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the case was last updated, as reported by the external
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getExternalSystemUpdateTimeOrBuilder() {
      if (externalSystemUpdateTimeBuilder_ != null) {
        return externalSystemUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return externalSystemUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : externalSystemUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the case was last updated, as reported by the external
     * system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp external_system_update_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExternalSystemUpdateTimeFieldBuilder() {
      if (externalSystemUpdateTimeBuilder_ == null) {
        externalSystemUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExternalSystemUpdateTime(), getParentForChildren(), isClean());
        externalSystemUpdateTime_ = null;
      }
      return externalSystemUpdateTimeBuilder_;
    }

    private java.lang.Object caseUri_ = "";
    /**
     *
     *
     * <pre>
     * The link to the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_uri = 6;</code>
     *
     * @return The caseUri.
     */
    public java.lang.String getCaseUri() {
      java.lang.Object ref = caseUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        caseUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The link to the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_uri = 6;</code>
     *
     * @return The bytes for caseUri.
     */
    public com.google.protobuf.ByteString getCaseUriBytes() {
      java.lang.Object ref = caseUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        caseUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The link to the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_uri = 6;</code>
     *
     * @param value The caseUri to set.
     * @return This builder for chaining.
     */
    public Builder setCaseUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      caseUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The link to the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_uri = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCaseUri() {
      caseUri_ = getDefaultInstance().getCaseUri();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The link to the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_uri = 6;</code>
     *
     * @param value The bytes for caseUri to set.
     * @return This builder for chaining.
     */
    public Builder setCaseUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      caseUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object casePriority_ = "";
    /**
     *
     *
     * <pre>
     * The priority of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_priority = 7;</code>
     *
     * @return The casePriority.
     */
    public java.lang.String getCasePriority() {
      java.lang.Object ref = casePriority_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        casePriority_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The priority of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_priority = 7;</code>
     *
     * @return The bytes for casePriority.
     */
    public com.google.protobuf.ByteString getCasePriorityBytes() {
      java.lang.Object ref = casePriority_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        casePriority_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The priority of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_priority = 7;</code>
     *
     * @param value The casePriority to set.
     * @return This builder for chaining.
     */
    public Builder setCasePriority(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      casePriority_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The priority of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_priority = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCasePriority() {
      casePriority_ = getDefaultInstance().getCasePriority();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The priority of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>string case_priority = 7;</code>
     *
     * @param value The bytes for casePriority to set.
     * @return This builder for chaining.
     */
    public Builder setCasePriorityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      casePriority_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp caseSla_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        caseSlaBuilder_;
    /**
     *
     *
     * <pre>
     * The SLA of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_sla = 9;</code>
     *
     * @return Whether the caseSla field is set.
     */
    public boolean hasCaseSla() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The SLA of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_sla = 9;</code>
     *
     * @return The caseSla.
     */
    public com.google.protobuf.Timestamp getCaseSla() {
      if (caseSlaBuilder_ == null) {
        return caseSla_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : caseSla_;
      } else {
        return caseSlaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The SLA of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_sla = 9;</code>
     */
    public Builder setCaseSla(com.google.protobuf.Timestamp value) {
      if (caseSlaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        caseSla_ = value;
      } else {
        caseSlaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SLA of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_sla = 9;</code>
     */
    public Builder setCaseSla(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (caseSlaBuilder_ == null) {
        caseSla_ = builderForValue.build();
      } else {
        caseSlaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SLA of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_sla = 9;</code>
     */
    public Builder mergeCaseSla(com.google.protobuf.Timestamp value) {
      if (caseSlaBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && caseSla_ != null
            && caseSla_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCaseSlaBuilder().mergeFrom(value);
        } else {
          caseSla_ = value;
        }
      } else {
        caseSlaBuilder_.mergeFrom(value);
      }
      if (caseSla_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SLA of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_sla = 9;</code>
     */
    public Builder clearCaseSla() {
      bitField0_ = (bitField0_ & ~0x00000080);
      caseSla_ = null;
      if (caseSlaBuilder_ != null) {
        caseSlaBuilder_.dispose();
        caseSlaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SLA of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_sla = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCaseSlaBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCaseSlaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The SLA of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_sla = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCaseSlaOrBuilder() {
      if (caseSlaBuilder_ != null) {
        return caseSlaBuilder_.getMessageOrBuilder();
      } else {
        return caseSla_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : caseSla_;
      }
    }
    /**
     *
     *
     * <pre>
     * The SLA of the finding's corresponding case in the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_sla = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCaseSlaFieldBuilder() {
      if (caseSlaBuilder_ == null) {
        caseSlaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCaseSla(), getParentForChildren(), isClean());
        caseSla_ = null;
      }
      return caseSlaBuilder_;
    }

    private com.google.protobuf.Timestamp caseCreateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        caseCreateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the case was created, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
     *
     * @return Whether the caseCreateTime field is set.
     */
    public boolean hasCaseCreateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the case was created, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
     *
     * @return The caseCreateTime.
     */
    public com.google.protobuf.Timestamp getCaseCreateTime() {
      if (caseCreateTimeBuilder_ == null) {
        return caseCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : caseCreateTime_;
      } else {
        return caseCreateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the case was created, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
     */
    public Builder setCaseCreateTime(com.google.protobuf.Timestamp value) {
      if (caseCreateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        caseCreateTime_ = value;
      } else {
        caseCreateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was created, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
     */
    public Builder setCaseCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (caseCreateTimeBuilder_ == null) {
        caseCreateTime_ = builderForValue.build();
      } else {
        caseCreateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was created, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
     */
    public Builder mergeCaseCreateTime(com.google.protobuf.Timestamp value) {
      if (caseCreateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && caseCreateTime_ != null
            && caseCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCaseCreateTimeBuilder().mergeFrom(value);
        } else {
          caseCreateTime_ = value;
        }
      } else {
        caseCreateTimeBuilder_.mergeFrom(value);
      }
      if (caseCreateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was created, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
     */
    public Builder clearCaseCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      caseCreateTime_ = null;
      if (caseCreateTimeBuilder_ != null) {
        caseCreateTimeBuilder_.dispose();
        caseCreateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was created, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCaseCreateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCaseCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the case was created, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCaseCreateTimeOrBuilder() {
      if (caseCreateTimeBuilder_ != null) {
        return caseCreateTimeBuilder_.getMessageOrBuilder();
      } else {
        return caseCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : caseCreateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the case was created, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_create_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCaseCreateTimeFieldBuilder() {
      if (caseCreateTimeBuilder_ == null) {
        caseCreateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCaseCreateTime(), getParentForChildren(), isClean());
        caseCreateTime_ = null;
      }
      return caseCreateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp caseCloseTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        caseCloseTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the case was closed, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
     *
     * @return Whether the caseCloseTime field is set.
     */
    public boolean hasCaseCloseTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the case was closed, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
     *
     * @return The caseCloseTime.
     */
    public com.google.protobuf.Timestamp getCaseCloseTime() {
      if (caseCloseTimeBuilder_ == null) {
        return caseCloseTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : caseCloseTime_;
      } else {
        return caseCloseTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the case was closed, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
     */
    public Builder setCaseCloseTime(com.google.protobuf.Timestamp value) {
      if (caseCloseTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        caseCloseTime_ = value;
      } else {
        caseCloseTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was closed, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
     */
    public Builder setCaseCloseTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (caseCloseTimeBuilder_ == null) {
        caseCloseTime_ = builderForValue.build();
      } else {
        caseCloseTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was closed, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
     */
    public Builder mergeCaseCloseTime(com.google.protobuf.Timestamp value) {
      if (caseCloseTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && caseCloseTime_ != null
            && caseCloseTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCaseCloseTimeBuilder().mergeFrom(value);
        } else {
          caseCloseTime_ = value;
        }
      } else {
        caseCloseTimeBuilder_.mergeFrom(value);
      }
      if (caseCloseTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was closed, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
     */
    public Builder clearCaseCloseTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      caseCloseTime_ = null;
      if (caseCloseTimeBuilder_ != null) {
        caseCloseTimeBuilder_.dispose();
        caseCloseTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the case was closed, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCaseCloseTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCaseCloseTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the case was closed, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCaseCloseTimeOrBuilder() {
      if (caseCloseTimeBuilder_ != null) {
        return caseCloseTimeBuilder_.getMessageOrBuilder();
      } else {
        return caseCloseTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : caseCloseTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the case was closed, as reported by the external system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp case_close_time = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCaseCloseTimeFieldBuilder() {
      if (caseCloseTimeBuilder_ == null) {
        caseCloseTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCaseCloseTime(), getParentForChildren(), isClean());
        caseCloseTime_ = null;
      }
      return caseCloseTimeBuilder_;
    }

    private com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticketInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo,
            com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.Builder,
            com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfoOrBuilder>
        ticketInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
     *
     * @return Whether the ticketInfo field is set.
     */
    public boolean hasTicketInfo() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
     *
     * @return The ticketInfo.
     */
    public com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo getTicketInfo() {
      if (ticketInfoBuilder_ == null) {
        return ticketInfo_ == null
            ? com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.getDefaultInstance()
            : ticketInfo_;
      } else {
        return ticketInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
     */
    public Builder setTicketInfo(
        com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo value) {
      if (ticketInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ticketInfo_ = value;
      } else {
        ticketInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
     */
    public Builder setTicketInfo(
        com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.Builder builderForValue) {
      if (ticketInfoBuilder_ == null) {
        ticketInfo_ = builderForValue.build();
      } else {
        ticketInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
     */
    public Builder mergeTicketInfo(
        com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo value) {
      if (ticketInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && ticketInfo_ != null
            && ticketInfo_
                != com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo
                    .getDefaultInstance()) {
          getTicketInfoBuilder().mergeFrom(value);
        } else {
          ticketInfo_ = value;
        }
      } else {
        ticketInfoBuilder_.mergeFrom(value);
      }
      if (ticketInfo_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
     */
    public Builder clearTicketInfo() {
      bitField0_ = (bitField0_ & ~0x00000400);
      ticketInfo_ = null;
      if (ticketInfoBuilder_ != null) {
        ticketInfoBuilder_.dispose();
        ticketInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
     */
    public com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.Builder
        getTicketInfoBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getTicketInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
     */
    public com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfoOrBuilder
        getTicketInfoOrBuilder() {
      if (ticketInfoBuilder_ != null) {
        return ticketInfoBuilder_.getMessageOrBuilder();
      } else {
        return ticketInfo_ == null
            ? com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.getDefaultInstance()
            : ticketInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the ticket, if any, that is being used to track the
     * resolution of the issue that is identified by this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo ticket_info = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo,
            com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.Builder,
            com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfoOrBuilder>
        getTicketInfoFieldBuilder() {
      if (ticketInfoBuilder_ == null) {
        ticketInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo,
                com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfo.Builder,
                com.google.cloud.securitycenter.v1.ExternalSystem.TicketInfoOrBuilder>(
                getTicketInfo(), getParentForChildren(), isClean());
        ticketInfo_ = null;
      }
      return ticketInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.ExternalSystem)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.ExternalSystem)
  private static final com.google.cloud.securitycenter.v1.ExternalSystem DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.ExternalSystem();
  }

  public static com.google.cloud.securitycenter.v1.ExternalSystem getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExternalSystem> PARSER =
      new com.google.protobuf.AbstractParser<ExternalSystem>() {
        @java.lang.Override
        public ExternalSystem parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExternalSystem> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExternalSystem> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ExternalSystem getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
