/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/kubernetes.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Kubernetes-related attributes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes}
 */
public final class Kubernetes extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Kubernetes)
    KubernetesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Kubernetes.newBuilder() to construct.
  private Kubernetes(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Kubernetes() {
    pods_ = java.util.Collections.emptyList();
    nodes_ = java.util.Collections.emptyList();
    nodePools_ = java.util.Collections.emptyList();
    roles_ = java.util.Collections.emptyList();
    bindings_ = java.util.Collections.emptyList();
    accessReviews_ = java.util.Collections.emptyList();
    objects_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Kubernetes();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.KubernetesProto
        .internal_static_google_cloud_securitycenter_v1_Kubernetes_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.KubernetesProto
        .internal_static_google_cloud_securitycenter_v1_Kubernetes_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Kubernetes.class,
            com.google.cloud.securitycenter.v1.Kubernetes.Builder.class);
  }

  public interface PodOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Kubernetes.Pod)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Kubernetes Pod namespace.
     * </pre>
     *
     * <code>string ns = 1;</code>
     *
     * @return The ns.
     */
    java.lang.String getNs();
    /**
     *
     *
     * <pre>
     * Kubernetes Pod namespace.
     * </pre>
     *
     * <code>string ns = 1;</code>
     *
     * @return The bytes for ns.
     */
    com.google.protobuf.ByteString getNsBytes();

    /**
     *
     *
     * <pre>
     * Kubernetes Pod name.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Kubernetes Pod name.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    java.util.List<com.google.cloud.securitycenter.v1.Label> getLabelsList();
    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    com.google.cloud.securitycenter.v1.Label getLabels(int index);
    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    int getLabelsCount();
    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    java.util.List<? extends com.google.cloud.securitycenter.v1.LabelOrBuilder>
        getLabelsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    com.google.cloud.securitycenter.v1.LabelOrBuilder getLabelsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    java.util.List<com.google.cloud.securitycenter.v1.Container> getContainersList();
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    com.google.cloud.securitycenter.v1.Container getContainers(int index);
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    int getContainersCount();
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    java.util.List<? extends com.google.cloud.securitycenter.v1.ContainerOrBuilder>
        getContainersOrBuilderList();
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    com.google.cloud.securitycenter.v1.ContainerOrBuilder getContainersOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A Kubernetes Pod.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Pod}
   */
  public static final class Pod extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Kubernetes.Pod)
      PodOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Pod.newBuilder() to construct.
    private Pod(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Pod() {
      ns_ = "";
      name_ = "";
      labels_ = java.util.Collections.emptyList();
      containers_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Pod();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Pod_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Pod_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Kubernetes.Pod.class,
              com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder.class);
    }

    public static final int NS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object ns_ = "";
    /**
     *
     *
     * <pre>
     * Kubernetes Pod namespace.
     * </pre>
     *
     * <code>string ns = 1;</code>
     *
     * @return The ns.
     */
    @java.lang.Override
    public java.lang.String getNs() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ns_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Pod namespace.
     * </pre>
     *
     * <code>string ns = 1;</code>
     *
     * @return The bytes for ns.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNsBytes() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ns_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Kubernetes Pod name.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Pod name.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LABELS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.securitycenter.v1.Label> labels_;
    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.securitycenter.v1.Label> getLabelsList() {
      return labels_;
    }
    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.securitycenter.v1.LabelOrBuilder>
        getLabelsOrBuilderList() {
      return labels_;
    }
    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    @java.lang.Override
    public int getLabelsCount() {
      return labels_.size();
    }
    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Label getLabels(int index) {
      return labels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Pod labels.  For Kubernetes containers, these are applied to the
     * container.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.LabelOrBuilder getLabelsOrBuilder(int index) {
      return labels_.get(index);
    }

    public static final int CONTAINERS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.securitycenter.v1.Container> containers_;
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.securitycenter.v1.Container> getContainersList() {
      return containers_;
    }
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.securitycenter.v1.ContainerOrBuilder>
        getContainersOrBuilderList() {
      return containers_;
    }
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    @java.lang.Override
    public int getContainersCount() {
      return containers_.size();
    }
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Container getContainers(int index) {
      return containers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ContainerOrBuilder getContainersOrBuilder(int index) {
      return containers_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
      }
      for (int i = 0; i < labels_.size(); i++) {
        output.writeMessage(3, labels_.get(i));
      }
      for (int i = 0; i < containers_.size(); i++) {
        output.writeMessage(4, containers_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
      }
      for (int i = 0; i < labels_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels_.get(i));
      }
      for (int i = 0; i < containers_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, containers_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.Kubernetes.Pod)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.Kubernetes.Pod other =
          (com.google.cloud.securitycenter.v1.Kubernetes.Pod) obj;

      if (!getNs().equals(other.getNs())) return false;
      if (!getName().equals(other.getName())) return false;
      if (!getLabelsList().equals(other.getLabelsList())) return false;
      if (!getContainersList().equals(other.getContainersList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NS_FIELD_NUMBER;
      hash = (53 * hash) + getNs().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (getLabelsCount() > 0) {
        hash = (37 * hash) + LABELS_FIELD_NUMBER;
        hash = (53 * hash) + getLabelsList().hashCode();
      }
      if (getContainersCount() > 0) {
        hash = (37 * hash) + CONTAINERS_FIELD_NUMBER;
        hash = (53 * hash) + getContainersList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Pod prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A Kubernetes Pod.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Pod}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Kubernetes.Pod)
        com.google.cloud.securitycenter.v1.Kubernetes.PodOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Pod_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Pod_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Kubernetes.Pod.class,
                com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.Kubernetes.Pod.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        ns_ = "";
        name_ = "";
        if (labelsBuilder_ == null) {
          labels_ = java.util.Collections.emptyList();
        } else {
          labels_ = null;
          labelsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (containersBuilder_ == null) {
          containers_ = java.util.Collections.emptyList();
        } else {
          containers_ = null;
          containersBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Pod_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Pod getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.Kubernetes.Pod.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Pod build() {
        com.google.cloud.securitycenter.v1.Kubernetes.Pod result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Pod buildPartial() {
        com.google.cloud.securitycenter.v1.Kubernetes.Pod result =
            new com.google.cloud.securitycenter.v1.Kubernetes.Pod(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.securitycenter.v1.Kubernetes.Pod result) {
        if (labelsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            labels_ = java.util.Collections.unmodifiableList(labels_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.labels_ = labels_;
        } else {
          result.labels_ = labelsBuilder_.build();
        }
        if (containersBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            containers_ = java.util.Collections.unmodifiableList(containers_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.containers_ = containers_;
        } else {
          result.containers_ = containersBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.securitycenter.v1.Kubernetes.Pod result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.ns_ = ns_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.Kubernetes.Pod) {
          return mergeFrom((com.google.cloud.securitycenter.v1.Kubernetes.Pod) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securitycenter.v1.Kubernetes.Pod other) {
        if (other == com.google.cloud.securitycenter.v1.Kubernetes.Pod.getDefaultInstance())
          return this;
        if (!other.getNs().isEmpty()) {
          ns_ = other.ns_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (labelsBuilder_ == null) {
          if (!other.labels_.isEmpty()) {
            if (labels_.isEmpty()) {
              labels_ = other.labels_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureLabelsIsMutable();
              labels_.addAll(other.labels_);
            }
            onChanged();
          }
        } else {
          if (!other.labels_.isEmpty()) {
            if (labelsBuilder_.isEmpty()) {
              labelsBuilder_.dispose();
              labelsBuilder_ = null;
              labels_ = other.labels_;
              bitField0_ = (bitField0_ & ~0x00000004);
              labelsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getLabelsFieldBuilder()
                      : null;
            } else {
              labelsBuilder_.addAllMessages(other.labels_);
            }
          }
        }
        if (containersBuilder_ == null) {
          if (!other.containers_.isEmpty()) {
            if (containers_.isEmpty()) {
              containers_ = other.containers_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureContainersIsMutable();
              containers_.addAll(other.containers_);
            }
            onChanged();
          }
        } else {
          if (!other.containers_.isEmpty()) {
            if (containersBuilder_.isEmpty()) {
              containersBuilder_.dispose();
              containersBuilder_ = null;
              containers_ = other.containers_;
              bitField0_ = (bitField0_ & ~0x00000008);
              containersBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getContainersFieldBuilder()
                      : null;
            } else {
              containersBuilder_.addAllMessages(other.containers_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  ns_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.cloud.securitycenter.v1.Label m =
                      input.readMessage(
                          com.google.cloud.securitycenter.v1.Label.parser(), extensionRegistry);
                  if (labelsBuilder_ == null) {
                    ensureLabelsIsMutable();
                    labels_.add(m);
                  } else {
                    labelsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 34:
                {
                  com.google.cloud.securitycenter.v1.Container m =
                      input.readMessage(
                          com.google.cloud.securitycenter.v1.Container.parser(), extensionRegistry);
                  if (containersBuilder_ == null) {
                    ensureContainersIsMutable();
                    containers_.add(m);
                  } else {
                    containersBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object ns_ = "";
      /**
       *
       *
       * <pre>
       * Kubernetes Pod namespace.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @return The ns.
       */
      public java.lang.String getNs() {
        java.lang.Object ref = ns_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ns_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes Pod namespace.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @return The bytes for ns.
       */
      public com.google.protobuf.ByteString getNsBytes() {
        java.lang.Object ref = ns_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ns_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes Pod namespace.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @param value The ns to set.
       * @return This builder for chaining.
       */
      public Builder setNs(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ns_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes Pod namespace.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNs() {
        ns_ = getDefaultInstance().getNs();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes Pod namespace.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @param value The bytes for ns to set.
       * @return This builder for chaining.
       */
      public Builder setNsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ns_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Kubernetes Pod name.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes Pod name.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes Pod name.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes Pod name.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes Pod name.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.securitycenter.v1.Label> labels_ =
          java.util.Collections.emptyList();

      private void ensureLabelsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          labels_ = new java.util.ArrayList<com.google.cloud.securitycenter.v1.Label>(labels_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Label,
              com.google.cloud.securitycenter.v1.Label.Builder,
              com.google.cloud.securitycenter.v1.LabelOrBuilder>
          labelsBuilder_;

      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Label> getLabelsList() {
        if (labelsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(labels_);
        } else {
          return labelsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public int getLabelsCount() {
        if (labelsBuilder_ == null) {
          return labels_.size();
        } else {
          return labelsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public com.google.cloud.securitycenter.v1.Label getLabels(int index) {
        if (labelsBuilder_ == null) {
          return labels_.get(index);
        } else {
          return labelsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public Builder setLabels(int index, com.google.cloud.securitycenter.v1.Label value) {
        if (labelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLabelsIsMutable();
          labels_.set(index, value);
          onChanged();
        } else {
          labelsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public Builder setLabels(
          int index, com.google.cloud.securitycenter.v1.Label.Builder builderForValue) {
        if (labelsBuilder_ == null) {
          ensureLabelsIsMutable();
          labels_.set(index, builderForValue.build());
          onChanged();
        } else {
          labelsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public Builder addLabels(com.google.cloud.securitycenter.v1.Label value) {
        if (labelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLabelsIsMutable();
          labels_.add(value);
          onChanged();
        } else {
          labelsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public Builder addLabels(int index, com.google.cloud.securitycenter.v1.Label value) {
        if (labelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLabelsIsMutable();
          labels_.add(index, value);
          onChanged();
        } else {
          labelsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public Builder addLabels(com.google.cloud.securitycenter.v1.Label.Builder builderForValue) {
        if (labelsBuilder_ == null) {
          ensureLabelsIsMutable();
          labels_.add(builderForValue.build());
          onChanged();
        } else {
          labelsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public Builder addLabels(
          int index, com.google.cloud.securitycenter.v1.Label.Builder builderForValue) {
        if (labelsBuilder_ == null) {
          ensureLabelsIsMutable();
          labels_.add(index, builderForValue.build());
          onChanged();
        } else {
          labelsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public Builder addAllLabels(
          java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Label> values) {
        if (labelsBuilder_ == null) {
          ensureLabelsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labels_);
          onChanged();
        } else {
          labelsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public Builder clearLabels() {
        if (labelsBuilder_ == null) {
          labels_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          labelsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public Builder removeLabels(int index) {
        if (labelsBuilder_ == null) {
          ensureLabelsIsMutable();
          labels_.remove(index);
          onChanged();
        } else {
          labelsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public com.google.cloud.securitycenter.v1.Label.Builder getLabelsBuilder(int index) {
        return getLabelsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public com.google.cloud.securitycenter.v1.LabelOrBuilder getLabelsOrBuilder(int index) {
        if (labelsBuilder_ == null) {
          return labels_.get(index);
        } else {
          return labelsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public java.util.List<? extends com.google.cloud.securitycenter.v1.LabelOrBuilder>
          getLabelsOrBuilderList() {
        if (labelsBuilder_ != null) {
          return labelsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(labels_);
        }
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public com.google.cloud.securitycenter.v1.Label.Builder addLabelsBuilder() {
        return getLabelsFieldBuilder()
            .addBuilder(com.google.cloud.securitycenter.v1.Label.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public com.google.cloud.securitycenter.v1.Label.Builder addLabelsBuilder(int index) {
        return getLabelsFieldBuilder()
            .addBuilder(index, com.google.cloud.securitycenter.v1.Label.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Pod labels.  For Kubernetes containers, these are applied to the
       * container.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Label labels = 3;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Label.Builder>
          getLabelsBuilderList() {
        return getLabelsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Label,
              com.google.cloud.securitycenter.v1.Label.Builder,
              com.google.cloud.securitycenter.v1.LabelOrBuilder>
          getLabelsFieldBuilder() {
        if (labelsBuilder_ == null) {
          labelsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Label,
                  com.google.cloud.securitycenter.v1.Label.Builder,
                  com.google.cloud.securitycenter.v1.LabelOrBuilder>(
                  labels_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          labels_ = null;
        }
        return labelsBuilder_;
      }

      private java.util.List<com.google.cloud.securitycenter.v1.Container> containers_ =
          java.util.Collections.emptyList();

      private void ensureContainersIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          containers_ =
              new java.util.ArrayList<com.google.cloud.securitycenter.v1.Container>(containers_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Container,
              com.google.cloud.securitycenter.v1.Container.Builder,
              com.google.cloud.securitycenter.v1.ContainerOrBuilder>
          containersBuilder_;

      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Container> getContainersList() {
        if (containersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(containers_);
        } else {
          return containersBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public int getContainersCount() {
        if (containersBuilder_ == null) {
          return containers_.size();
        } else {
          return containersBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.Container getContainers(int index) {
        if (containersBuilder_ == null) {
          return containers_.get(index);
        } else {
          return containersBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public Builder setContainers(int index, com.google.cloud.securitycenter.v1.Container value) {
        if (containersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainersIsMutable();
          containers_.set(index, value);
          onChanged();
        } else {
          containersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public Builder setContainers(
          int index, com.google.cloud.securitycenter.v1.Container.Builder builderForValue) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          containers_.set(index, builderForValue.build());
          onChanged();
        } else {
          containersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public Builder addContainers(com.google.cloud.securitycenter.v1.Container value) {
        if (containersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainersIsMutable();
          containers_.add(value);
          onChanged();
        } else {
          containersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public Builder addContainers(int index, com.google.cloud.securitycenter.v1.Container value) {
        if (containersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainersIsMutable();
          containers_.add(index, value);
          onChanged();
        } else {
          containersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public Builder addContainers(
          com.google.cloud.securitycenter.v1.Container.Builder builderForValue) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          containers_.add(builderForValue.build());
          onChanged();
        } else {
          containersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public Builder addContainers(
          int index, com.google.cloud.securitycenter.v1.Container.Builder builderForValue) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          containers_.add(index, builderForValue.build());
          onChanged();
        } else {
          containersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public Builder addAllContainers(
          java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Container> values) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, containers_);
          onChanged();
        } else {
          containersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public Builder clearContainers() {
        if (containersBuilder_ == null) {
          containers_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          containersBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public Builder removeContainers(int index) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          containers_.remove(index);
          onChanged();
        } else {
          containersBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.Container.Builder getContainersBuilder(int index) {
        return getContainersFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.ContainerOrBuilder getContainersOrBuilder(
          int index) {
        if (containersBuilder_ == null) {
          return containers_.get(index);
        } else {
          return containersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public java.util.List<? extends com.google.cloud.securitycenter.v1.ContainerOrBuilder>
          getContainersOrBuilderList() {
        if (containersBuilder_ != null) {
          return containersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(containers_);
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.Container.Builder addContainersBuilder() {
        return getContainersFieldBuilder()
            .addBuilder(com.google.cloud.securitycenter.v1.Container.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.Container.Builder addContainersBuilder(int index) {
        return getContainersFieldBuilder()
            .addBuilder(index, com.google.cloud.securitycenter.v1.Container.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 4;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Container.Builder>
          getContainersBuilderList() {
        return getContainersFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Container,
              com.google.cloud.securitycenter.v1.Container.Builder,
              com.google.cloud.securitycenter.v1.ContainerOrBuilder>
          getContainersFieldBuilder() {
        if (containersBuilder_ == null) {
          containersBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Container,
                  com.google.cloud.securitycenter.v1.Container.Builder,
                  com.google.cloud.securitycenter.v1.ContainerOrBuilder>(
                  containers_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
          containers_ = null;
        }
        return containersBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Kubernetes.Pod)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Kubernetes.Pod)
    private static final com.google.cloud.securitycenter.v1.Kubernetes.Pod DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Kubernetes.Pod();
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Pod getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Pod> PARSER =
        new com.google.protobuf.AbstractParser<Pod>() {
          @java.lang.Override
          public Pod parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Pod> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Pod> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Pod getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NodeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Kubernetes.Node)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * [Full resource name](https://google.aip.dev/122#full-resource-names) of
     * the Compute Engine VM running the cluster node.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * [Full resource name](https://google.aip.dev/122#full-resource-names) of
     * the Compute Engine VM running the cluster node.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Kubernetes nodes associated with the finding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Node}
   */
  public static final class Node extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Kubernetes.Node)
      NodeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Node.newBuilder() to construct.
    private Node(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Node() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Node();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Node_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Node_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Kubernetes.Node.class,
              com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * [Full resource name](https://google.aip.dev/122#full-resource-names) of
     * the Compute Engine VM running the cluster node.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * [Full resource name](https://google.aip.dev/122#full-resource-names) of
     * the Compute Engine VM running the cluster node.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.Kubernetes.Node)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.Kubernetes.Node other =
          (com.google.cloud.securitycenter.v1.Kubernetes.Node) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Node prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes nodes associated with the finding.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Node}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Kubernetes.Node)
        com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Node_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Node_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Kubernetes.Node.class,
                com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.Kubernetes.Node.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Node_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Node getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.Kubernetes.Node.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Node build() {
        com.google.cloud.securitycenter.v1.Kubernetes.Node result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Node buildPartial() {
        com.google.cloud.securitycenter.v1.Kubernetes.Node result =
            new com.google.cloud.securitycenter.v1.Kubernetes.Node(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.securitycenter.v1.Kubernetes.Node result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.Kubernetes.Node) {
          return mergeFrom((com.google.cloud.securitycenter.v1.Kubernetes.Node) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securitycenter.v1.Kubernetes.Node other) {
        if (other == com.google.cloud.securitycenter.v1.Kubernetes.Node.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * [Full resource name](https://google.aip.dev/122#full-resource-names) of
       * the Compute Engine VM running the cluster node.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Full resource name](https://google.aip.dev/122#full-resource-names) of
       * the Compute Engine VM running the cluster node.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Full resource name](https://google.aip.dev/122#full-resource-names) of
       * the Compute Engine VM running the cluster node.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Full resource name](https://google.aip.dev/122#full-resource-names) of
       * the Compute Engine VM running the cluster node.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Full resource name](https://google.aip.dev/122#full-resource-names) of
       * the Compute Engine VM running the cluster node.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Kubernetes.Node)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Kubernetes.Node)
    private static final com.google.cloud.securitycenter.v1.Kubernetes.Node DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Kubernetes.Node();
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Node getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Node> PARSER =
        new com.google.protobuf.AbstractParser<Node>() {
          @java.lang.Override
          public Node parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Node> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Node> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Node getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NodePoolOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Kubernetes.NodePool)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Kubernetes node pool name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Kubernetes node pool name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node> getNodesList();
    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    com.google.cloud.securitycenter.v1.Kubernetes.Node getNodes(int index);
    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    int getNodesCount();
    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>
        getNodesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder getNodesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Provides GKE node pool information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.NodePool}
   */
  public static final class NodePool extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Kubernetes.NodePool)
      NodePoolOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NodePool.newBuilder() to construct.
    private NodePool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NodePool() {
      name_ = "";
      nodes_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NodePool();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_NodePool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_NodePool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Kubernetes.NodePool.class,
              com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Kubernetes node pool name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes node pool name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NODES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node> nodes_;
    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node> getNodesList() {
      return nodes_;
    }
    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>
        getNodesOrBuilderList() {
      return nodes_;
    }
    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    @java.lang.Override
    public int getNodesCount() {
      return nodes_.size();
    }
    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Node getNodes(int index) {
      return nodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Nodes associated with the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder getNodesOrBuilder(
        int index) {
      return nodes_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      for (int i = 0; i < nodes_.size(); i++) {
        output.writeMessage(2, nodes_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      for (int i = 0; i < nodes_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, nodes_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.Kubernetes.NodePool)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.Kubernetes.NodePool other =
          (com.google.cloud.securitycenter.v1.Kubernetes.NodePool) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getNodesList().equals(other.getNodesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (getNodesCount() > 0) {
        hash = (37 * hash) + NODES_FIELD_NUMBER;
        hash = (53 * hash) + getNodesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.Kubernetes.NodePool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Provides GKE node pool information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.NodePool}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Kubernetes.NodePool)
        com.google.cloud.securitycenter.v1.Kubernetes.NodePoolOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_NodePool_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_NodePool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Kubernetes.NodePool.class,
                com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.Kubernetes.NodePool.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        if (nodesBuilder_ == null) {
          nodes_ = java.util.Collections.emptyList();
        } else {
          nodes_ = null;
          nodesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_NodePool_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.NodePool getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.Kubernetes.NodePool.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.NodePool build() {
        com.google.cloud.securitycenter.v1.Kubernetes.NodePool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.NodePool buildPartial() {
        com.google.cloud.securitycenter.v1.Kubernetes.NodePool result =
            new com.google.cloud.securitycenter.v1.Kubernetes.NodePool(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.securitycenter.v1.Kubernetes.NodePool result) {
        if (nodesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            nodes_ = java.util.Collections.unmodifiableList(nodes_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.nodes_ = nodes_;
        } else {
          result.nodes_ = nodesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.securitycenter.v1.Kubernetes.NodePool result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.Kubernetes.NodePool) {
          return mergeFrom((com.google.cloud.securitycenter.v1.Kubernetes.NodePool) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securitycenter.v1.Kubernetes.NodePool other) {
        if (other == com.google.cloud.securitycenter.v1.Kubernetes.NodePool.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (nodesBuilder_ == null) {
          if (!other.nodes_.isEmpty()) {
            if (nodes_.isEmpty()) {
              nodes_ = other.nodes_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureNodesIsMutable();
              nodes_.addAll(other.nodes_);
            }
            onChanged();
          }
        } else {
          if (!other.nodes_.isEmpty()) {
            if (nodesBuilder_.isEmpty()) {
              nodesBuilder_.dispose();
              nodesBuilder_ = null;
              nodes_ = other.nodes_;
              bitField0_ = (bitField0_ & ~0x00000002);
              nodesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getNodesFieldBuilder()
                      : null;
            } else {
              nodesBuilder_.addAllMessages(other.nodes_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.securitycenter.v1.Kubernetes.Node m =
                      input.readMessage(
                          com.google.cloud.securitycenter.v1.Kubernetes.Node.parser(),
                          extensionRegistry);
                  if (nodesBuilder_ == null) {
                    ensureNodesIsMutable();
                    nodes_.add(m);
                  } else {
                    nodesBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Kubernetes node pool name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes node pool name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes node pool name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes node pool name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes node pool name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node> nodes_ =
          java.util.Collections.emptyList();

      private void ensureNodesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          nodes_ =
              new java.util.ArrayList<com.google.cloud.securitycenter.v1.Kubernetes.Node>(nodes_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Kubernetes.Node,
              com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder,
              com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>
          nodesBuilder_;

      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node> getNodesList() {
        if (nodesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(nodes_);
        } else {
          return nodesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public int getNodesCount() {
        if (nodesBuilder_ == null) {
          return nodes_.size();
        } else {
          return nodesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Node getNodes(int index) {
        if (nodesBuilder_ == null) {
          return nodes_.get(index);
        } else {
          return nodesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public Builder setNodes(int index, com.google.cloud.securitycenter.v1.Kubernetes.Node value) {
        if (nodesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodesIsMutable();
          nodes_.set(index, value);
          onChanged();
        } else {
          nodesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public Builder setNodes(
          int index, com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder builderForValue) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          nodes_.set(index, builderForValue.build());
          onChanged();
        } else {
          nodesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public Builder addNodes(com.google.cloud.securitycenter.v1.Kubernetes.Node value) {
        if (nodesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodesIsMutable();
          nodes_.add(value);
          onChanged();
        } else {
          nodesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public Builder addNodes(int index, com.google.cloud.securitycenter.v1.Kubernetes.Node value) {
        if (nodesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNodesIsMutable();
          nodes_.add(index, value);
          onChanged();
        } else {
          nodesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public Builder addNodes(
          com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder builderForValue) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          nodes_.add(builderForValue.build());
          onChanged();
        } else {
          nodesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public Builder addNodes(
          int index, com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder builderForValue) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          nodes_.add(index, builderForValue.build());
          onChanged();
        } else {
          nodesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public Builder addAllNodes(
          java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Kubernetes.Node> values) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodes_);
          onChanged();
        } else {
          nodesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public Builder clearNodes() {
        if (nodesBuilder_ == null) {
          nodes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          nodesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public Builder removeNodes(int index) {
        if (nodesBuilder_ == null) {
          ensureNodesIsMutable();
          nodes_.remove(index);
          onChanged();
        } else {
          nodesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder getNodesBuilder(int index) {
        return getNodesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder getNodesOrBuilder(
          int index) {
        if (nodesBuilder_ == null) {
          return nodes_.get(index);
        } else {
          return nodesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>
          getNodesOrBuilderList() {
        if (nodesBuilder_ != null) {
          return nodesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(nodes_);
        }
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder addNodesBuilder() {
        return getNodesFieldBuilder()
            .addBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Node.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder addNodesBuilder(int index) {
        return getNodesFieldBuilder()
            .addBuilder(
                index, com.google.cloud.securitycenter.v1.Kubernetes.Node.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Nodes associated with the finding.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder>
          getNodesBuilderList() {
        return getNodesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Kubernetes.Node,
              com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder,
              com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>
          getNodesFieldBuilder() {
        if (nodesBuilder_ == null) {
          nodesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Kubernetes.Node,
                  com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder,
                  com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>(
                  nodes_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          nodes_ = null;
        }
        return nodesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Kubernetes.NodePool)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Kubernetes.NodePool)
    private static final com.google.cloud.securitycenter.v1.Kubernetes.NodePool DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Kubernetes.NodePool();
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.NodePool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NodePool> PARSER =
        new com.google.protobuf.AbstractParser<NodePool>() {
          @java.lang.Override
          public NodePool parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NodePool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NodePool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.NodePool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RoleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Kubernetes.Role)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Role type.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role.Kind kind = 1;</code>
     *
     * @return The enum numeric value on the wire for kind.
     */
    int getKindValue();
    /**
     *
     *
     * <pre>
     * Role type.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role.Kind kind = 1;</code>
     *
     * @return The kind.
     */
    com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind getKind();

    /**
     *
     *
     * <pre>
     * Role namespace.
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The ns.
     */
    java.lang.String getNs();
    /**
     *
     *
     * <pre>
     * Role namespace.
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The bytes for ns.
     */
    com.google.protobuf.ByteString getNsBytes();

    /**
     *
     *
     * <pre>
     * Role name.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Role name.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Kubernetes Role or ClusterRole.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Role}
   */
  public static final class Role extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Kubernetes.Role)
      RoleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Role.newBuilder() to construct.
    private Role(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Role() {
      kind_ = 0;
      ns_ = "";
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Role();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Role_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Role_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Kubernetes.Role.class,
              com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Types of Kubernetes roles.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.securitycenter.v1.Kubernetes.Role.Kind}
     */
    public enum Kind implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Role type is not specified.
       * </pre>
       *
       * <code>KIND_UNSPECIFIED = 0;</code>
       */
      KIND_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Kubernetes Role.
       * </pre>
       *
       * <code>ROLE = 1;</code>
       */
      ROLE(1),
      /**
       *
       *
       * <pre>
       * Kubernetes ClusterRole.
       * </pre>
       *
       * <code>CLUSTER_ROLE = 2;</code>
       */
      CLUSTER_ROLE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Role type is not specified.
       * </pre>
       *
       * <code>KIND_UNSPECIFIED = 0;</code>
       */
      public static final int KIND_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Kubernetes Role.
       * </pre>
       *
       * <code>ROLE = 1;</code>
       */
      public static final int ROLE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Kubernetes ClusterRole.
       * </pre>
       *
       * <code>CLUSTER_ROLE = 2;</code>
       */
      public static final int CLUSTER_ROLE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Kind valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Kind forNumber(int value) {
        switch (value) {
          case 0:
            return KIND_UNSPECIFIED;
          case 1:
            return ROLE;
          case 2:
            return CLUSTER_ROLE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Kind> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Kind> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Kind>() {
            public Kind findValueByNumber(int number) {
              return Kind.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.Kubernetes.Role.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Kind[] VALUES = values();

      public static Kind valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Kind(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Kubernetes.Role.Kind)
    }

    public static final int KIND_FIELD_NUMBER = 1;
    private int kind_ = 0;
    /**
     *
     *
     * <pre>
     * Role type.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role.Kind kind = 1;</code>
     *
     * @return The enum numeric value on the wire for kind.
     */
    @java.lang.Override
    public int getKindValue() {
      return kind_;
    }
    /**
     *
     *
     * <pre>
     * Role type.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role.Kind kind = 1;</code>
     *
     * @return The kind.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind getKind() {
      com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind result =
          com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind.forNumber(kind_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind.UNRECOGNIZED
          : result;
    }

    public static final int NS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object ns_ = "";
    /**
     *
     *
     * <pre>
     * Role namespace.
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The ns.
     */
    @java.lang.Override
    public java.lang.String getNs() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ns_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Role namespace.
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The bytes for ns.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNsBytes() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ns_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Role name.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Role name.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (kind_
          != com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind.KIND_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, kind_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (kind_
          != com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind.KIND_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, kind_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.Kubernetes.Role)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.Kubernetes.Role other =
          (com.google.cloud.securitycenter.v1.Kubernetes.Role) obj;

      if (kind_ != other.kind_) return false;
      if (!getNs().equals(other.getNs())) return false;
      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + kind_;
      hash = (37 * hash) + NS_FIELD_NUMBER;
      hash = (53 * hash) + getNs().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Role prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Role or ClusterRole.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Role}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Kubernetes.Role)
        com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Role_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Role_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Kubernetes.Role.class,
                com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.Kubernetes.Role.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        kind_ = 0;
        ns_ = "";
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Role_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Role getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.Kubernetes.Role.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Role build() {
        com.google.cloud.securitycenter.v1.Kubernetes.Role result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Role buildPartial() {
        com.google.cloud.securitycenter.v1.Kubernetes.Role result =
            new com.google.cloud.securitycenter.v1.Kubernetes.Role(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.securitycenter.v1.Kubernetes.Role result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.kind_ = kind_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.ns_ = ns_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.Kubernetes.Role) {
          return mergeFrom((com.google.cloud.securitycenter.v1.Kubernetes.Role) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securitycenter.v1.Kubernetes.Role other) {
        if (other == com.google.cloud.securitycenter.v1.Kubernetes.Role.getDefaultInstance())
          return this;
        if (other.kind_ != 0) {
          setKindValue(other.getKindValue());
        }
        if (!other.getNs().isEmpty()) {
          ns_ = other.ns_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  kind_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  ns_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int kind_ = 0;
      /**
       *
       *
       * <pre>
       * Role type.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role.Kind kind = 1;</code>
       *
       * @return The enum numeric value on the wire for kind.
       */
      @java.lang.Override
      public int getKindValue() {
        return kind_;
      }
      /**
       *
       *
       * <pre>
       * Role type.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role.Kind kind = 1;</code>
       *
       * @param value The enum numeric value on the wire for kind to set.
       * @return This builder for chaining.
       */
      public Builder setKindValue(int value) {
        kind_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Role type.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role.Kind kind = 1;</code>
       *
       * @return The kind.
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind getKind() {
        com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind result =
            com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind.forNumber(kind_);
        return result == null
            ? com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Role type.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role.Kind kind = 1;</code>
       *
       * @param value The kind to set.
       * @return This builder for chaining.
       */
      public Builder setKind(com.google.cloud.securitycenter.v1.Kubernetes.Role.Kind value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        kind_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Role type.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role.Kind kind = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKind() {
        bitField0_ = (bitField0_ & ~0x00000001);
        kind_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object ns_ = "";
      /**
       *
       *
       * <pre>
       * Role namespace.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @return The ns.
       */
      public java.lang.String getNs() {
        java.lang.Object ref = ns_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ns_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Role namespace.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @return The bytes for ns.
       */
      public com.google.protobuf.ByteString getNsBytes() {
        java.lang.Object ref = ns_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ns_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Role namespace.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @param value The ns to set.
       * @return This builder for chaining.
       */
      public Builder setNs(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ns_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Role namespace.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNs() {
        ns_ = getDefaultInstance().getNs();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Role namespace.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @param value The bytes for ns to set.
       * @return This builder for chaining.
       */
      public Builder setNsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ns_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Role name.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Role name.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Role name.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Role name.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Role name.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Kubernetes.Role)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Kubernetes.Role)
    private static final com.google.cloud.securitycenter.v1.Kubernetes.Role DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Kubernetes.Role();
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Role getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Role> PARSER =
        new com.google.protobuf.AbstractParser<Role>() {
          @java.lang.Override
          public Role parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Role> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Role> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Role getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BindingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Kubernetes.Binding)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Namespace for the binding.
     * </pre>
     *
     * <code>string ns = 1;</code>
     *
     * @return The ns.
     */
    java.lang.String getNs();
    /**
     *
     *
     * <pre>
     * Namespace for the binding.
     * </pre>
     *
     * <code>string ns = 1;</code>
     *
     * @return The bytes for ns.
     */
    com.google.protobuf.ByteString getNsBytes();

    /**
     *
     *
     * <pre>
     * Name for the binding.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Name for the binding.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The Role or ClusterRole referenced by the binding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
     *
     * @return Whether the role field is set.
     */
    boolean hasRole();
    /**
     *
     *
     * <pre>
     * The Role or ClusterRole referenced by the binding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
     *
     * @return The role.
     */
    com.google.cloud.securitycenter.v1.Kubernetes.Role getRole();
    /**
     *
     *
     * <pre>
     * The Role or ClusterRole referenced by the binding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
     */
    com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder getRoleOrBuilder();

    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Subject> getSubjectsList();
    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    com.google.cloud.securitycenter.v1.Kubernetes.Subject getSubjects(int index);
    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    int getSubjectsCount();
    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder>
        getSubjectsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder getSubjectsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents a Kubernetes RoleBinding or ClusterRoleBinding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Binding}
   */
  public static final class Binding extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Kubernetes.Binding)
      BindingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Binding.newBuilder() to construct.
    private Binding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Binding() {
      ns_ = "";
      name_ = "";
      subjects_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Binding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Binding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Binding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Kubernetes.Binding.class,
              com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder.class);
    }

    private int bitField0_;
    public static final int NS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object ns_ = "";
    /**
     *
     *
     * <pre>
     * Namespace for the binding.
     * </pre>
     *
     * <code>string ns = 1;</code>
     *
     * @return The ns.
     */
    @java.lang.Override
    public java.lang.String getNs() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ns_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Namespace for the binding.
     * </pre>
     *
     * <code>string ns = 1;</code>
     *
     * @return The bytes for ns.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNsBytes() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ns_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name for the binding.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name for the binding.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROLE_FIELD_NUMBER = 3;
    private com.google.cloud.securitycenter.v1.Kubernetes.Role role_;
    /**
     *
     *
     * <pre>
     * The Role or ClusterRole referenced by the binding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
     *
     * @return Whether the role field is set.
     */
    @java.lang.Override
    public boolean hasRole() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Role or ClusterRole referenced by the binding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
     *
     * @return The role.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Role getRole() {
      return role_ == null
          ? com.google.cloud.securitycenter.v1.Kubernetes.Role.getDefaultInstance()
          : role_;
    }
    /**
     *
     *
     * <pre>
     * The Role or ClusterRole referenced by the binding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder getRoleOrBuilder() {
      return role_ == null
          ? com.google.cloud.securitycenter.v1.Kubernetes.Role.getDefaultInstance()
          : role_;
    }

    public static final int SUBJECTS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Subject> subjects_;
    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Subject> getSubjectsList() {
      return subjects_;
    }
    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder>
        getSubjectsOrBuilderList() {
      return subjects_;
    }
    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    @java.lang.Override
    public int getSubjectsCount() {
      return subjects_.size();
    }
    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Subject getSubjects(int index) {
      return subjects_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Represents one or more subjects that are bound to the role. Not always
     * available for PATCH requests.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder getSubjectsOrBuilder(
        int index) {
      return subjects_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getRole());
      }
      for (int i = 0; i < subjects_.size(); i++) {
        output.writeMessage(4, subjects_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRole());
      }
      for (int i = 0; i < subjects_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, subjects_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.Kubernetes.Binding)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.Kubernetes.Binding other =
          (com.google.cloud.securitycenter.v1.Kubernetes.Binding) obj;

      if (!getNs().equals(other.getNs())) return false;
      if (!getName().equals(other.getName())) return false;
      if (hasRole() != other.hasRole()) return false;
      if (hasRole()) {
        if (!getRole().equals(other.getRole())) return false;
      }
      if (!getSubjectsList().equals(other.getSubjectsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NS_FIELD_NUMBER;
      hash = (53 * hash) + getNs().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasRole()) {
        hash = (37 * hash) + ROLE_FIELD_NUMBER;
        hash = (53 * hash) + getRole().hashCode();
      }
      if (getSubjectsCount() > 0) {
        hash = (37 * hash) + SUBJECTS_FIELD_NUMBER;
        hash = (53 * hash) + getSubjectsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.Kubernetes.Binding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a Kubernetes RoleBinding or ClusterRoleBinding.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Binding}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Kubernetes.Binding)
        com.google.cloud.securitycenter.v1.Kubernetes.BindingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Binding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Binding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Kubernetes.Binding.class,
                com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.Kubernetes.Binding.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRoleFieldBuilder();
          getSubjectsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        ns_ = "";
        name_ = "";
        role_ = null;
        if (roleBuilder_ != null) {
          roleBuilder_.dispose();
          roleBuilder_ = null;
        }
        if (subjectsBuilder_ == null) {
          subjects_ = java.util.Collections.emptyList();
        } else {
          subjects_ = null;
          subjectsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Binding_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Binding getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.Kubernetes.Binding.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Binding build() {
        com.google.cloud.securitycenter.v1.Kubernetes.Binding result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Binding buildPartial() {
        com.google.cloud.securitycenter.v1.Kubernetes.Binding result =
            new com.google.cloud.securitycenter.v1.Kubernetes.Binding(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.securitycenter.v1.Kubernetes.Binding result) {
        if (subjectsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            subjects_ = java.util.Collections.unmodifiableList(subjects_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.subjects_ = subjects_;
        } else {
          result.subjects_ = subjectsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.securitycenter.v1.Kubernetes.Binding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.ns_ = ns_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.name_ = name_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.role_ = roleBuilder_ == null ? role_ : roleBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.Kubernetes.Binding) {
          return mergeFrom((com.google.cloud.securitycenter.v1.Kubernetes.Binding) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securitycenter.v1.Kubernetes.Binding other) {
        if (other == com.google.cloud.securitycenter.v1.Kubernetes.Binding.getDefaultInstance())
          return this;
        if (!other.getNs().isEmpty()) {
          ns_ = other.ns_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasRole()) {
          mergeRole(other.getRole());
        }
        if (subjectsBuilder_ == null) {
          if (!other.subjects_.isEmpty()) {
            if (subjects_.isEmpty()) {
              subjects_ = other.subjects_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureSubjectsIsMutable();
              subjects_.addAll(other.subjects_);
            }
            onChanged();
          }
        } else {
          if (!other.subjects_.isEmpty()) {
            if (subjectsBuilder_.isEmpty()) {
              subjectsBuilder_.dispose();
              subjectsBuilder_ = null;
              subjects_ = other.subjects_;
              bitField0_ = (bitField0_ & ~0x00000008);
              subjectsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSubjectsFieldBuilder()
                      : null;
            } else {
              subjectsBuilder_.addAllMessages(other.subjects_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  ns_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getRoleFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  com.google.cloud.securitycenter.v1.Kubernetes.Subject m =
                      input.readMessage(
                          com.google.cloud.securitycenter.v1.Kubernetes.Subject.parser(),
                          extensionRegistry);
                  if (subjectsBuilder_ == null) {
                    ensureSubjectsIsMutable();
                    subjects_.add(m);
                  } else {
                    subjectsBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object ns_ = "";
      /**
       *
       *
       * <pre>
       * Namespace for the binding.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @return The ns.
       */
      public java.lang.String getNs() {
        java.lang.Object ref = ns_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ns_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Namespace for the binding.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @return The bytes for ns.
       */
      public com.google.protobuf.ByteString getNsBytes() {
        java.lang.Object ref = ns_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ns_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Namespace for the binding.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @param value The ns to set.
       * @return This builder for chaining.
       */
      public Builder setNs(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ns_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Namespace for the binding.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNs() {
        ns_ = getDefaultInstance().getNs();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Namespace for the binding.
       * </pre>
       *
       * <code>string ns = 1;</code>
       *
       * @param value The bytes for ns to set.
       * @return This builder for chaining.
       */
      public Builder setNsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ns_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Name for the binding.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name for the binding.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name for the binding.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name for the binding.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name for the binding.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.securitycenter.v1.Kubernetes.Role role_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Kubernetes.Role,
              com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder,
              com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder>
          roleBuilder_;
      /**
       *
       *
       * <pre>
       * The Role or ClusterRole referenced by the binding.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
       *
       * @return Whether the role field is set.
       */
      public boolean hasRole() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The Role or ClusterRole referenced by the binding.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
       *
       * @return The role.
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Role getRole() {
        if (roleBuilder_ == null) {
          return role_ == null
              ? com.google.cloud.securitycenter.v1.Kubernetes.Role.getDefaultInstance()
              : role_;
        } else {
          return roleBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The Role or ClusterRole referenced by the binding.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
       */
      public Builder setRole(com.google.cloud.securitycenter.v1.Kubernetes.Role value) {
        if (roleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          role_ = value;
        } else {
          roleBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Role or ClusterRole referenced by the binding.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
       */
      public Builder setRole(
          com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder builderForValue) {
        if (roleBuilder_ == null) {
          role_ = builderForValue.build();
        } else {
          roleBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Role or ClusterRole referenced by the binding.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
       */
      public Builder mergeRole(com.google.cloud.securitycenter.v1.Kubernetes.Role value) {
        if (roleBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && role_ != null
              && role_ != com.google.cloud.securitycenter.v1.Kubernetes.Role.getDefaultInstance()) {
            getRoleBuilder().mergeFrom(value);
          } else {
            role_ = value;
          }
        } else {
          roleBuilder_.mergeFrom(value);
        }
        if (role_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Role or ClusterRole referenced by the binding.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
       */
      public Builder clearRole() {
        bitField0_ = (bitField0_ & ~0x00000004);
        role_ = null;
        if (roleBuilder_ != null) {
          roleBuilder_.dispose();
          roleBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Role or ClusterRole referenced by the binding.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder getRoleBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getRoleFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Role or ClusterRole referenced by the binding.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder getRoleOrBuilder() {
        if (roleBuilder_ != null) {
          return roleBuilder_.getMessageOrBuilder();
        } else {
          return role_ == null
              ? com.google.cloud.securitycenter.v1.Kubernetes.Role.getDefaultInstance()
              : role_;
        }
      }
      /**
       *
       *
       * <pre>
       * The Role or ClusterRole referenced by the binding.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Role role = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Kubernetes.Role,
              com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder,
              com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder>
          getRoleFieldBuilder() {
        if (roleBuilder_ == null) {
          roleBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Kubernetes.Role,
                  com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder,
                  com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder>(
                  getRole(), getParentForChildren(), isClean());
          role_ = null;
        }
        return roleBuilder_;
      }

      private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Subject> subjects_ =
          java.util.Collections.emptyList();

      private void ensureSubjectsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          subjects_ =
              new java.util.ArrayList<com.google.cloud.securitycenter.v1.Kubernetes.Subject>(
                  subjects_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Kubernetes.Subject,
              com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder,
              com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder>
          subjectsBuilder_;

      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Subject>
          getSubjectsList() {
        if (subjectsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(subjects_);
        } else {
          return subjectsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public int getSubjectsCount() {
        if (subjectsBuilder_ == null) {
          return subjects_.size();
        } else {
          return subjectsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Subject getSubjects(int index) {
        if (subjectsBuilder_ == null) {
          return subjects_.get(index);
        } else {
          return subjectsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public Builder setSubjects(
          int index, com.google.cloud.securitycenter.v1.Kubernetes.Subject value) {
        if (subjectsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSubjectsIsMutable();
          subjects_.set(index, value);
          onChanged();
        } else {
          subjectsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public Builder setSubjects(
          int index,
          com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder builderForValue) {
        if (subjectsBuilder_ == null) {
          ensureSubjectsIsMutable();
          subjects_.set(index, builderForValue.build());
          onChanged();
        } else {
          subjectsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public Builder addSubjects(com.google.cloud.securitycenter.v1.Kubernetes.Subject value) {
        if (subjectsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSubjectsIsMutable();
          subjects_.add(value);
          onChanged();
        } else {
          subjectsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public Builder addSubjects(
          int index, com.google.cloud.securitycenter.v1.Kubernetes.Subject value) {
        if (subjectsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSubjectsIsMutable();
          subjects_.add(index, value);
          onChanged();
        } else {
          subjectsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public Builder addSubjects(
          com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder builderForValue) {
        if (subjectsBuilder_ == null) {
          ensureSubjectsIsMutable();
          subjects_.add(builderForValue.build());
          onChanged();
        } else {
          subjectsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public Builder addSubjects(
          int index,
          com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder builderForValue) {
        if (subjectsBuilder_ == null) {
          ensureSubjectsIsMutable();
          subjects_.add(index, builderForValue.build());
          onChanged();
        } else {
          subjectsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public Builder addAllSubjects(
          java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Kubernetes.Subject>
              values) {
        if (subjectsBuilder_ == null) {
          ensureSubjectsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subjects_);
          onChanged();
        } else {
          subjectsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public Builder clearSubjects() {
        if (subjectsBuilder_ == null) {
          subjects_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          subjectsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public Builder removeSubjects(int index) {
        if (subjectsBuilder_ == null) {
          ensureSubjectsIsMutable();
          subjects_.remove(index);
          onChanged();
        } else {
          subjectsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder getSubjectsBuilder(
          int index) {
        return getSubjectsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder getSubjectsOrBuilder(
          int index) {
        if (subjectsBuilder_ == null) {
          return subjects_.get(index);
        } else {
          return subjectsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder>
          getSubjectsOrBuilderList() {
        if (subjectsBuilder_ != null) {
          return subjectsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(subjects_);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder addSubjectsBuilder() {
        return getSubjectsFieldBuilder()
            .addBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Subject.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder addSubjectsBuilder(
          int index) {
        return getSubjectsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.securitycenter.v1.Kubernetes.Subject.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Represents one or more subjects that are bound to the role. Not always
       * available for PATCH requests.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Subject subjects = 4;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder>
          getSubjectsBuilderList() {
        return getSubjectsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Kubernetes.Subject,
              com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder,
              com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder>
          getSubjectsFieldBuilder() {
        if (subjectsBuilder_ == null) {
          subjectsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Kubernetes.Subject,
                  com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder,
                  com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder>(
                  subjects_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
          subjects_ = null;
        }
        return subjectsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Kubernetes.Binding)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Kubernetes.Binding)
    private static final com.google.cloud.securitycenter.v1.Kubernetes.Binding DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Kubernetes.Binding();
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Binding getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Binding> PARSER =
        new com.google.protobuf.AbstractParser<Binding>() {
          @java.lang.Override
          public Binding parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Binding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Binding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Binding getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SubjectOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Kubernetes.Subject)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Authentication type for the subject.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType kind = 1;</code>
     *
     * @return The enum numeric value on the wire for kind.
     */
    int getKindValue();
    /**
     *
     *
     * <pre>
     * Authentication type for the subject.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType kind = 1;</code>
     *
     * @return The kind.
     */
    com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType getKind();

    /**
     *
     *
     * <pre>
     * Namespace for the subject.
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The ns.
     */
    java.lang.String getNs();
    /**
     *
     *
     * <pre>
     * Namespace for the subject.
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The bytes for ns.
     */
    com.google.protobuf.ByteString getNsBytes();

    /**
     *
     *
     * <pre>
     * Name for the subject.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Name for the subject.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents a Kubernetes subject.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Subject}
   */
  public static final class Subject extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Kubernetes.Subject)
      SubjectOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Subject.newBuilder() to construct.
    private Subject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Subject() {
      kind_ = 0;
      ns_ = "";
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Subject();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Subject_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Subject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Kubernetes.Subject.class,
              com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Auth types that can be used for the subject's kind field.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType}
     */
    public enum AuthType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Authentication is not specified.
       * </pre>
       *
       * <code>AUTH_TYPE_UNSPECIFIED = 0;</code>
       */
      AUTH_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * User with valid certificate.
       * </pre>
       *
       * <code>USER = 1;</code>
       */
      USER(1),
      /**
       *
       *
       * <pre>
       * Users managed by Kubernetes API with credentials stored as secrets.
       * </pre>
       *
       * <code>SERVICEACCOUNT = 2;</code>
       */
      SERVICEACCOUNT(2),
      /**
       *
       *
       * <pre>
       * Collection of users.
       * </pre>
       *
       * <code>GROUP = 3;</code>
       */
      GROUP(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Authentication is not specified.
       * </pre>
       *
       * <code>AUTH_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int AUTH_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * User with valid certificate.
       * </pre>
       *
       * <code>USER = 1;</code>
       */
      public static final int USER_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Users managed by Kubernetes API with credentials stored as secrets.
       * </pre>
       *
       * <code>SERVICEACCOUNT = 2;</code>
       */
      public static final int SERVICEACCOUNT_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Collection of users.
       * </pre>
       *
       * <code>GROUP = 3;</code>
       */
      public static final int GROUP_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AuthType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static AuthType forNumber(int value) {
        switch (value) {
          case 0:
            return AUTH_TYPE_UNSPECIFIED;
          case 1:
            return USER;
          case 2:
            return SERVICEACCOUNT;
          case 3:
            return GROUP;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<AuthType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<AuthType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<AuthType>() {
            public AuthType findValueByNumber(int number) {
              return AuthType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.Kubernetes.Subject.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final AuthType[] VALUES = values();

      public static AuthType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private AuthType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType)
    }

    public static final int KIND_FIELD_NUMBER = 1;
    private int kind_ = 0;
    /**
     *
     *
     * <pre>
     * Authentication type for the subject.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType kind = 1;</code>
     *
     * @return The enum numeric value on the wire for kind.
     */
    @java.lang.Override
    public int getKindValue() {
      return kind_;
    }
    /**
     *
     *
     * <pre>
     * Authentication type for the subject.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType kind = 1;</code>
     *
     * @return The kind.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType getKind() {
      com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType result =
          com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType.forNumber(kind_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType.UNRECOGNIZED
          : result;
    }

    public static final int NS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object ns_ = "";
    /**
     *
     *
     * <pre>
     * Namespace for the subject.
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The ns.
     */
    @java.lang.Override
    public java.lang.String getNs() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ns_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Namespace for the subject.
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The bytes for ns.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNsBytes() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ns_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name for the subject.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name for the subject.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (kind_
          != com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType.AUTH_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, kind_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (kind_
          != com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType.AUTH_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, kind_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.Kubernetes.Subject)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.Kubernetes.Subject other =
          (com.google.cloud.securitycenter.v1.Kubernetes.Subject) obj;

      if (kind_ != other.kind_) return false;
      if (!getNs().equals(other.getNs())) return false;
      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + kind_;
      hash = (37 * hash) + NS_FIELD_NUMBER;
      hash = (53 * hash) + getNs().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.Kubernetes.Subject prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a Kubernetes subject.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Subject}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Kubernetes.Subject)
        com.google.cloud.securitycenter.v1.Kubernetes.SubjectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Subject_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Subject_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Kubernetes.Subject.class,
                com.google.cloud.securitycenter.v1.Kubernetes.Subject.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.Kubernetes.Subject.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        kind_ = 0;
        ns_ = "";
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Subject_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Subject getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.Kubernetes.Subject.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Subject build() {
        com.google.cloud.securitycenter.v1.Kubernetes.Subject result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Subject buildPartial() {
        com.google.cloud.securitycenter.v1.Kubernetes.Subject result =
            new com.google.cloud.securitycenter.v1.Kubernetes.Subject(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.securitycenter.v1.Kubernetes.Subject result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.kind_ = kind_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.ns_ = ns_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.Kubernetes.Subject) {
          return mergeFrom((com.google.cloud.securitycenter.v1.Kubernetes.Subject) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securitycenter.v1.Kubernetes.Subject other) {
        if (other == com.google.cloud.securitycenter.v1.Kubernetes.Subject.getDefaultInstance())
          return this;
        if (other.kind_ != 0) {
          setKindValue(other.getKindValue());
        }
        if (!other.getNs().isEmpty()) {
          ns_ = other.ns_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  kind_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  ns_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int kind_ = 0;
      /**
       *
       *
       * <pre>
       * Authentication type for the subject.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType kind = 1;</code>
       *
       * @return The enum numeric value on the wire for kind.
       */
      @java.lang.Override
      public int getKindValue() {
        return kind_;
      }
      /**
       *
       *
       * <pre>
       * Authentication type for the subject.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType kind = 1;</code>
       *
       * @param value The enum numeric value on the wire for kind to set.
       * @return This builder for chaining.
       */
      public Builder setKindValue(int value) {
        kind_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication type for the subject.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType kind = 1;</code>
       *
       * @return The kind.
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType getKind() {
        com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType result =
            com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType.forNumber(kind_);
        return result == null
            ? com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Authentication type for the subject.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType kind = 1;</code>
       *
       * @param value The kind to set.
       * @return This builder for chaining.
       */
      public Builder setKind(com.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        kind_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication type for the subject.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Kubernetes.Subject.AuthType kind = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKind() {
        bitField0_ = (bitField0_ & ~0x00000001);
        kind_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object ns_ = "";
      /**
       *
       *
       * <pre>
       * Namespace for the subject.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @return The ns.
       */
      public java.lang.String getNs() {
        java.lang.Object ref = ns_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ns_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Namespace for the subject.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @return The bytes for ns.
       */
      public com.google.protobuf.ByteString getNsBytes() {
        java.lang.Object ref = ns_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ns_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Namespace for the subject.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @param value The ns to set.
       * @return This builder for chaining.
       */
      public Builder setNs(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ns_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Namespace for the subject.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNs() {
        ns_ = getDefaultInstance().getNs();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Namespace for the subject.
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @param value The bytes for ns to set.
       * @return This builder for chaining.
       */
      public Builder setNsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ns_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Name for the subject.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name for the subject.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name for the subject.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name for the subject.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name for the subject.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Kubernetes.Subject)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Kubernetes.Subject)
    private static final com.google.cloud.securitycenter.v1.Kubernetes.Subject DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Kubernetes.Subject();
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Subject getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Subject> PARSER =
        new com.google.protobuf.AbstractParser<Subject>() {
          @java.lang.Override
          public Subject parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Subject> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Subject> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Subject getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AccessReviewOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Kubernetes.AccessReview)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The API group of the resource. "*" means all.
     * </pre>
     *
     * <code>string group = 1;</code>
     *
     * @return The group.
     */
    java.lang.String getGroup();
    /**
     *
     *
     * <pre>
     * The API group of the resource. "*" means all.
     * </pre>
     *
     * <code>string group = 1;</code>
     *
     * @return The bytes for group.
     */
    com.google.protobuf.ByteString getGroupBytes();

    /**
     *
     *
     * <pre>
     * Namespace of the action being requested. Currently, there is no
     * distinction between no namespace and all namespaces.  Both
     * are represented by "" (empty).
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The ns.
     */
    java.lang.String getNs();
    /**
     *
     *
     * <pre>
     * Namespace of the action being requested. Currently, there is no
     * distinction between no namespace and all namespaces.  Both
     * are represented by "" (empty).
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The bytes for ns.
     */
    com.google.protobuf.ByteString getNsBytes();

    /**
     *
     *
     * <pre>
     * The name of the resource being requested. Empty means all.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The name of the resource being requested. Empty means all.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The optional resource type requested. "*" means all.
     * </pre>
     *
     * <code>string resource = 4;</code>
     *
     * @return The resource.
     */
    java.lang.String getResource();
    /**
     *
     *
     * <pre>
     * The optional resource type requested. "*" means all.
     * </pre>
     *
     * <code>string resource = 4;</code>
     *
     * @return The bytes for resource.
     */
    com.google.protobuf.ByteString getResourceBytes();

    /**
     *
     *
     * <pre>
     * The optional subresource type.
     * </pre>
     *
     * <code>string subresource = 5;</code>
     *
     * @return The subresource.
     */
    java.lang.String getSubresource();
    /**
     *
     *
     * <pre>
     * The optional subresource type.
     * </pre>
     *
     * <code>string subresource = 5;</code>
     *
     * @return The bytes for subresource.
     */
    com.google.protobuf.ByteString getSubresourceBytes();

    /**
     *
     *
     * <pre>
     * A Kubernetes resource API verb, like get, list, watch, create, update,
     * delete, proxy. "*" means all.
     * </pre>
     *
     * <code>string verb = 6;</code>
     *
     * @return The verb.
     */
    java.lang.String getVerb();
    /**
     *
     *
     * <pre>
     * A Kubernetes resource API verb, like get, list, watch, create, update,
     * delete, proxy. "*" means all.
     * </pre>
     *
     * <code>string verb = 6;</code>
     *
     * @return The bytes for verb.
     */
    com.google.protobuf.ByteString getVerbBytes();

    /**
     *
     *
     * <pre>
     * The API version of the resource. "*" means all.
     * </pre>
     *
     * <code>string version = 7;</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * The API version of the resource. "*" means all.
     * </pre>
     *
     * <code>string version = 7;</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Conveys information about a Kubernetes access review (such as one returned
   * by a [`kubectl auth
   * can-i`](https://kubernetes.io/docs/reference/access-authn-authz/authorization/#checking-api-access)
   * command) that was involved in a finding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.AccessReview}
   */
  public static final class AccessReview extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Kubernetes.AccessReview)
      AccessReviewOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AccessReview.newBuilder() to construct.
    private AccessReview(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AccessReview() {
      group_ = "";
      ns_ = "";
      name_ = "";
      resource_ = "";
      subresource_ = "";
      verb_ = "";
      version_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AccessReview();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_AccessReview_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_AccessReview_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.class,
              com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder.class);
    }

    public static final int GROUP_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object group_ = "";
    /**
     *
     *
     * <pre>
     * The API group of the resource. "*" means all.
     * </pre>
     *
     * <code>string group = 1;</code>
     *
     * @return The group.
     */
    @java.lang.Override
    public java.lang.String getGroup() {
      java.lang.Object ref = group_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        group_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The API group of the resource. "*" means all.
     * </pre>
     *
     * <code>string group = 1;</code>
     *
     * @return The bytes for group.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGroupBytes() {
      java.lang.Object ref = group_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        group_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object ns_ = "";
    /**
     *
     *
     * <pre>
     * Namespace of the action being requested. Currently, there is no
     * distinction between no namespace and all namespaces.  Both
     * are represented by "" (empty).
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The ns.
     */
    @java.lang.Override
    public java.lang.String getNs() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ns_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Namespace of the action being requested. Currently, there is no
     * distinction between no namespace and all namespaces.  Both
     * are represented by "" (empty).
     * </pre>
     *
     * <code>string ns = 2;</code>
     *
     * @return The bytes for ns.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNsBytes() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ns_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the resource being requested. Empty means all.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the resource being requested. Empty means all.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resource_ = "";
    /**
     *
     *
     * <pre>
     * The optional resource type requested. "*" means all.
     * </pre>
     *
     * <code>string resource = 4;</code>
     *
     * @return The resource.
     */
    @java.lang.Override
    public java.lang.String getResource() {
      java.lang.Object ref = resource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The optional resource type requested. "*" means all.
     * </pre>
     *
     * <code>string resource = 4;</code>
     *
     * @return The bytes for resource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceBytes() {
      java.lang.Object ref = resource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBRESOURCE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object subresource_ = "";
    /**
     *
     *
     * <pre>
     * The optional subresource type.
     * </pre>
     *
     * <code>string subresource = 5;</code>
     *
     * @return The subresource.
     */
    @java.lang.Override
    public java.lang.String getSubresource() {
      java.lang.Object ref = subresource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subresource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The optional subresource type.
     * </pre>
     *
     * <code>string subresource = 5;</code>
     *
     * @return The bytes for subresource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSubresourceBytes() {
      java.lang.Object ref = subresource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subresource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERB_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object verb_ = "";
    /**
     *
     *
     * <pre>
     * A Kubernetes resource API verb, like get, list, watch, create, update,
     * delete, proxy. "*" means all.
     * </pre>
     *
     * <code>string verb = 6;</code>
     *
     * @return The verb.
     */
    @java.lang.Override
    public java.lang.String getVerb() {
      java.lang.Object ref = verb_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        verb_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A Kubernetes resource API verb, like get, list, watch, create, update,
     * delete, proxy. "*" means all.
     * </pre>
     *
     * <code>string verb = 6;</code>
     *
     * @return The bytes for verb.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVerbBytes() {
      java.lang.Object ref = verb_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        verb_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The API version of the resource. "*" means all.
     * </pre>
     *
     * <code>string version = 7;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The API version of the resource. "*" means all.
     * </pre>
     *
     * <code>string version = 7;</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(group_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, group_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subresource_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, subresource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(verb_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, verb_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, version_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(group_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, group_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, resource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subresource_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, subresource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(verb_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, verb_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, version_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.Kubernetes.AccessReview)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.Kubernetes.AccessReview other =
          (com.google.cloud.securitycenter.v1.Kubernetes.AccessReview) obj;

      if (!getGroup().equals(other.getGroup())) return false;
      if (!getNs().equals(other.getNs())) return false;
      if (!getName().equals(other.getName())) return false;
      if (!getResource().equals(other.getResource())) return false;
      if (!getSubresource().equals(other.getSubresource())) return false;
      if (!getVerb().equals(other.getVerb())) return false;
      if (!getVersion().equals(other.getVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getGroup().hashCode();
      hash = (37 * hash) + NS_FIELD_NUMBER;
      hash = (53 * hash) + getNs().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
      hash = (37 * hash) + SUBRESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSubresource().hashCode();
      hash = (37 * hash) + VERB_FIELD_NUMBER;
      hash = (53 * hash) + getVerb().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.Kubernetes.AccessReview prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Conveys information about a Kubernetes access review (such as one returned
     * by a [`kubectl auth
     * can-i`](https://kubernetes.io/docs/reference/access-authn-authz/authorization/#checking-api-access)
     * command) that was involved in a finding.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.AccessReview}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Kubernetes.AccessReview)
        com.google.cloud.securitycenter.v1.Kubernetes.AccessReviewOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_AccessReview_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_AccessReview_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.class,
                com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        group_ = "";
        ns_ = "";
        name_ = "";
        resource_ = "";
        subresource_ = "";
        verb_ = "";
        version_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_AccessReview_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.AccessReview
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.AccessReview build() {
        com.google.cloud.securitycenter.v1.Kubernetes.AccessReview result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.AccessReview buildPartial() {
        com.google.cloud.securitycenter.v1.Kubernetes.AccessReview result =
            new com.google.cloud.securitycenter.v1.Kubernetes.AccessReview(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1.Kubernetes.AccessReview result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.group_ = group_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.ns_ = ns_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.resource_ = resource_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.subresource_ = subresource_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.verb_ = verb_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.version_ = version_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.Kubernetes.AccessReview) {
          return mergeFrom((com.google.cloud.securitycenter.v1.Kubernetes.AccessReview) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securitycenter.v1.Kubernetes.AccessReview other) {
        if (other
            == com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.getDefaultInstance())
          return this;
        if (!other.getGroup().isEmpty()) {
          group_ = other.group_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getNs().isEmpty()) {
          ns_ = other.ns_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getResource().isEmpty()) {
          resource_ = other.resource_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getSubresource().isEmpty()) {
          subresource_ = other.subresource_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getVerb().isEmpty()) {
          verb_ = other.verb_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  group_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  ns_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  resource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  subresource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  verb_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object group_ = "";
      /**
       *
       *
       * <pre>
       * The API group of the resource. "*" means all.
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @return The group.
       */
      public java.lang.String getGroup() {
        java.lang.Object ref = group_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          group_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API group of the resource. "*" means all.
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @return The bytes for group.
       */
      public com.google.protobuf.ByteString getGroupBytes() {
        java.lang.Object ref = group_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          group_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API group of the resource. "*" means all.
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @param value The group to set.
       * @return This builder for chaining.
       */
      public Builder setGroup(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        group_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API group of the resource. "*" means all.
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroup() {
        group_ = getDefaultInstance().getGroup();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API group of the resource. "*" means all.
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @param value The bytes for group to set.
       * @return This builder for chaining.
       */
      public Builder setGroupBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        group_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object ns_ = "";
      /**
       *
       *
       * <pre>
       * Namespace of the action being requested. Currently, there is no
       * distinction between no namespace and all namespaces.  Both
       * are represented by "" (empty).
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @return The ns.
       */
      public java.lang.String getNs() {
        java.lang.Object ref = ns_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ns_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Namespace of the action being requested. Currently, there is no
       * distinction between no namespace and all namespaces.  Both
       * are represented by "" (empty).
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @return The bytes for ns.
       */
      public com.google.protobuf.ByteString getNsBytes() {
        java.lang.Object ref = ns_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ns_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Namespace of the action being requested. Currently, there is no
       * distinction between no namespace and all namespaces.  Both
       * are represented by "" (empty).
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @param value The ns to set.
       * @return This builder for chaining.
       */
      public Builder setNs(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ns_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Namespace of the action being requested. Currently, there is no
       * distinction between no namespace and all namespaces.  Both
       * are represented by "" (empty).
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNs() {
        ns_ = getDefaultInstance().getNs();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Namespace of the action being requested. Currently, there is no
       * distinction between no namespace and all namespaces.  Both
       * are represented by "" (empty).
       * </pre>
       *
       * <code>string ns = 2;</code>
       *
       * @param value The bytes for ns to set.
       * @return This builder for chaining.
       */
      public Builder setNsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ns_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the resource being requested. Empty means all.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the resource being requested. Empty means all.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the resource being requested. Empty means all.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the resource being requested. Empty means all.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the resource being requested. Empty means all.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object resource_ = "";
      /**
       *
       *
       * <pre>
       * The optional resource type requested. "*" means all.
       * </pre>
       *
       * <code>string resource = 4;</code>
       *
       * @return The resource.
       */
      public java.lang.String getResource() {
        java.lang.Object ref = resource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The optional resource type requested. "*" means all.
       * </pre>
       *
       * <code>string resource = 4;</code>
       *
       * @return The bytes for resource.
       */
      public com.google.protobuf.ByteString getResourceBytes() {
        java.lang.Object ref = resource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The optional resource type requested. "*" means all.
       * </pre>
       *
       * <code>string resource = 4;</code>
       *
       * @param value The resource to set.
       * @return This builder for chaining.
       */
      public Builder setResource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The optional resource type requested. "*" means all.
       * </pre>
       *
       * <code>string resource = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResource() {
        resource_ = getDefaultInstance().getResource();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The optional resource type requested. "*" means all.
       * </pre>
       *
       * <code>string resource = 4;</code>
       *
       * @param value The bytes for resource to set.
       * @return This builder for chaining.
       */
      public Builder setResourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resource_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object subresource_ = "";
      /**
       *
       *
       * <pre>
       * The optional subresource type.
       * </pre>
       *
       * <code>string subresource = 5;</code>
       *
       * @return The subresource.
       */
      public java.lang.String getSubresource() {
        java.lang.Object ref = subresource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subresource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The optional subresource type.
       * </pre>
       *
       * <code>string subresource = 5;</code>
       *
       * @return The bytes for subresource.
       */
      public com.google.protobuf.ByteString getSubresourceBytes() {
        java.lang.Object ref = subresource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subresource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The optional subresource type.
       * </pre>
       *
       * <code>string subresource = 5;</code>
       *
       * @param value The subresource to set.
       * @return This builder for chaining.
       */
      public Builder setSubresource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        subresource_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The optional subresource type.
       * </pre>
       *
       * <code>string subresource = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSubresource() {
        subresource_ = getDefaultInstance().getSubresource();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The optional subresource type.
       * </pre>
       *
       * <code>string subresource = 5;</code>
       *
       * @param value The bytes for subresource to set.
       * @return This builder for chaining.
       */
      public Builder setSubresourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        subresource_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object verb_ = "";
      /**
       *
       *
       * <pre>
       * A Kubernetes resource API verb, like get, list, watch, create, update,
       * delete, proxy. "*" means all.
       * </pre>
       *
       * <code>string verb = 6;</code>
       *
       * @return The verb.
       */
      public java.lang.String getVerb() {
        java.lang.Object ref = verb_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          verb_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A Kubernetes resource API verb, like get, list, watch, create, update,
       * delete, proxy. "*" means all.
       * </pre>
       *
       * <code>string verb = 6;</code>
       *
       * @return The bytes for verb.
       */
      public com.google.protobuf.ByteString getVerbBytes() {
        java.lang.Object ref = verb_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          verb_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A Kubernetes resource API verb, like get, list, watch, create, update,
       * delete, proxy. "*" means all.
       * </pre>
       *
       * <code>string verb = 6;</code>
       *
       * @param value The verb to set.
       * @return This builder for chaining.
       */
      public Builder setVerb(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        verb_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Kubernetes resource API verb, like get, list, watch, create, update,
       * delete, proxy. "*" means all.
       * </pre>
       *
       * <code>string verb = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVerb() {
        verb_ = getDefaultInstance().getVerb();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Kubernetes resource API verb, like get, list, watch, create, update,
       * delete, proxy. "*" means all.
       * </pre>
       *
       * <code>string verb = 6;</code>
       *
       * @param value The bytes for verb to set.
       * @return This builder for chaining.
       */
      public Builder setVerbBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        verb_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * The API version of the resource. "*" means all.
       * </pre>
       *
       * <code>string version = 7;</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API version of the resource. "*" means all.
       * </pre>
       *
       * <code>string version = 7;</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The API version of the resource. "*" means all.
       * </pre>
       *
       * <code>string version = 7;</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API version of the resource. "*" means all.
       * </pre>
       *
       * <code>string version = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The API version of the resource. "*" means all.
       * </pre>
       *
       * <code>string version = 7;</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Kubernetes.AccessReview)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Kubernetes.AccessReview)
    private static final com.google.cloud.securitycenter.v1.Kubernetes.AccessReview
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Kubernetes.AccessReview();
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.AccessReview getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AccessReview> PARSER =
        new com.google.protobuf.AbstractParser<AccessReview>() {
          @java.lang.Override
          public AccessReview parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AccessReview> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AccessReview> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.AccessReview getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ObjectOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.Kubernetes.Object)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Kubernetes object group, such as "policy.k8s.io/v1".
     * </pre>
     *
     * <code>string group = 1;</code>
     *
     * @return The group.
     */
    java.lang.String getGroup();
    /**
     *
     *
     * <pre>
     * Kubernetes object group, such as "policy.k8s.io/v1".
     * </pre>
     *
     * <code>string group = 1;</code>
     *
     * @return The bytes for group.
     */
    com.google.protobuf.ByteString getGroupBytes();

    /**
     *
     *
     * <pre>
     * Kubernetes object kind, such as "Namespace".
     * </pre>
     *
     * <code>string kind = 2;</code>
     *
     * @return The kind.
     */
    java.lang.String getKind();
    /**
     *
     *
     * <pre>
     * Kubernetes object kind, such as "Namespace".
     * </pre>
     *
     * <code>string kind = 2;</code>
     *
     * @return The bytes for kind.
     */
    com.google.protobuf.ByteString getKindBytes();

    /**
     *
     *
     * <pre>
     * Kubernetes object namespace. Must be a valid DNS label. Named
     * "ns" to avoid collision with C++ namespace keyword. For details see
     * https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
     * </pre>
     *
     * <code>string ns = 3;</code>
     *
     * @return The ns.
     */
    java.lang.String getNs();
    /**
     *
     *
     * <pre>
     * Kubernetes object namespace. Must be a valid DNS label. Named
     * "ns" to avoid collision with C++ namespace keyword. For details see
     * https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
     * </pre>
     *
     * <code>string ns = 3;</code>
     *
     * @return The bytes for ns.
     */
    com.google.protobuf.ByteString getNsBytes();

    /**
     *
     *
     * <pre>
     * Kubernetes object name. For details see
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Kubernetes object name. For details see
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    java.util.List<com.google.cloud.securitycenter.v1.Container> getContainersList();
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    com.google.cloud.securitycenter.v1.Container getContainers(int index);
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    int getContainersCount();
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    java.util.List<? extends com.google.cloud.securitycenter.v1.ContainerOrBuilder>
        getContainersOrBuilderList();
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    com.google.cloud.securitycenter.v1.ContainerOrBuilder getContainersOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Kubernetes object related to the finding, uniquely identified by GKNN.
   * Used if the object Kind is not one of Pod, Node, NodePool, Binding, or
   * AccessReview.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Object}
   */
  public static final class Object extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Kubernetes.Object)
      ObjectOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Object.newBuilder() to construct.
    private Object(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Object() {
      group_ = "";
      kind_ = "";
      ns_ = "";
      name_ = "";
      containers_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Object();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Object_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_Object_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Kubernetes.Object.class,
              com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder.class);
    }

    public static final int GROUP_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object group_ = "";
    /**
     *
     *
     * <pre>
     * Kubernetes object group, such as "policy.k8s.io/v1".
     * </pre>
     *
     * <code>string group = 1;</code>
     *
     * @return The group.
     */
    @java.lang.Override
    public java.lang.String getGroup() {
      java.lang.Object ref = group_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        group_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes object group, such as "policy.k8s.io/v1".
     * </pre>
     *
     * <code>string group = 1;</code>
     *
     * @return The bytes for group.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGroupBytes() {
      java.lang.Object ref = group_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        group_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KIND_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * Kubernetes object kind, such as "Namespace".
     * </pre>
     *
     * <code>string kind = 2;</code>
     *
     * @return The kind.
     */
    @java.lang.Override
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes object kind, such as "Namespace".
     * </pre>
     *
     * <code>string kind = 2;</code>
     *
     * @return The bytes for kind.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object ns_ = "";
    /**
     *
     *
     * <pre>
     * Kubernetes object namespace. Must be a valid DNS label. Named
     * "ns" to avoid collision with C++ namespace keyword. For details see
     * https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
     * </pre>
     *
     * <code>string ns = 3;</code>
     *
     * @return The ns.
     */
    @java.lang.Override
    public java.lang.String getNs() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ns_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes object namespace. Must be a valid DNS label. Named
     * "ns" to avoid collision with C++ namespace keyword. For details see
     * https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
     * </pre>
     *
     * <code>string ns = 3;</code>
     *
     * @return The bytes for ns.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNsBytes() {
      java.lang.Object ref = ns_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ns_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Kubernetes object name. For details see
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes object name. For details see
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTAINERS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.securitycenter.v1.Container> containers_;
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.securitycenter.v1.Container> getContainersList() {
      return containers_;
    }
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.securitycenter.v1.ContainerOrBuilder>
        getContainersOrBuilderList() {
      return containers_;
    }
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    @java.lang.Override
    public int getContainersCount() {
      return containers_.size();
    }
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Container getContainers(int index) {
      return containers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Pod containers associated with this finding, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ContainerOrBuilder getContainersOrBuilder(int index) {
      return containers_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(group_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, group_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kind_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, name_);
      }
      for (int i = 0; i < containers_.size(); i++) {
        output.writeMessage(5, containers_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(group_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, group_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kind_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ns_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, ns_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, name_);
      }
      for (int i = 0; i < containers_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, containers_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.Kubernetes.Object)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.Kubernetes.Object other =
          (com.google.cloud.securitycenter.v1.Kubernetes.Object) obj;

      if (!getGroup().equals(other.getGroup())) return false;
      if (!getKind().equals(other.getKind())) return false;
      if (!getNs().equals(other.getNs())) return false;
      if (!getName().equals(other.getName())) return false;
      if (!getContainersList().equals(other.getContainersList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getGroup().hashCode();
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
      hash = (37 * hash) + NS_FIELD_NUMBER;
      hash = (53 * hash) + getNs().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (getContainersCount() > 0) {
        hash = (37 * hash) + CONTAINERS_FIELD_NUMBER;
        hash = (53 * hash) + getContainersList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.Kubernetes.Object prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes object related to the finding, uniquely identified by GKNN.
     * Used if the object Kind is not one of Pod, Node, NodePool, Binding, or
     * AccessReview.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes.Object}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Kubernetes.Object)
        com.google.cloud.securitycenter.v1.Kubernetes.ObjectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Object_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Object_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.Kubernetes.Object.class,
                com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder.class);
      }

      // Construct using com.google.cloud.securitycenter.v1.Kubernetes.Object.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        group_ = "";
        kind_ = "";
        ns_ = "";
        name_ = "";
        if (containersBuilder_ == null) {
          containers_ = java.util.Collections.emptyList();
        } else {
          containers_ = null;
          containersBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.KubernetesProto
            .internal_static_google_cloud_securitycenter_v1_Kubernetes_Object_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Object getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.Kubernetes.Object.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Object build() {
        com.google.cloud.securitycenter.v1.Kubernetes.Object result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Kubernetes.Object buildPartial() {
        com.google.cloud.securitycenter.v1.Kubernetes.Object result =
            new com.google.cloud.securitycenter.v1.Kubernetes.Object(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.securitycenter.v1.Kubernetes.Object result) {
        if (containersBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            containers_ = java.util.Collections.unmodifiableList(containers_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.containers_ = containers_;
        } else {
          result.containers_ = containersBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.securitycenter.v1.Kubernetes.Object result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.group_ = group_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.kind_ = kind_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.ns_ = ns_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securitycenter.v1.Kubernetes.Object) {
          return mergeFrom((com.google.cloud.securitycenter.v1.Kubernetes.Object) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securitycenter.v1.Kubernetes.Object other) {
        if (other == com.google.cloud.securitycenter.v1.Kubernetes.Object.getDefaultInstance())
          return this;
        if (!other.getGroup().isEmpty()) {
          group_ = other.group_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getKind().isEmpty()) {
          kind_ = other.kind_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getNs().isEmpty()) {
          ns_ = other.ns_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (containersBuilder_ == null) {
          if (!other.containers_.isEmpty()) {
            if (containers_.isEmpty()) {
              containers_ = other.containers_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureContainersIsMutable();
              containers_.addAll(other.containers_);
            }
            onChanged();
          }
        } else {
          if (!other.containers_.isEmpty()) {
            if (containersBuilder_.isEmpty()) {
              containersBuilder_.dispose();
              containersBuilder_ = null;
              containers_ = other.containers_;
              bitField0_ = (bitField0_ & ~0x00000010);
              containersBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getContainersFieldBuilder()
                      : null;
            } else {
              containersBuilder_.addAllMessages(other.containers_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  group_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  kind_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  ns_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  com.google.cloud.securitycenter.v1.Container m =
                      input.readMessage(
                          com.google.cloud.securitycenter.v1.Container.parser(), extensionRegistry);
                  if (containersBuilder_ == null) {
                    ensureContainersIsMutable();
                    containers_.add(m);
                  } else {
                    containersBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object group_ = "";
      /**
       *
       *
       * <pre>
       * Kubernetes object group, such as "policy.k8s.io/v1".
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @return The group.
       */
      public java.lang.String getGroup() {
        java.lang.Object ref = group_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          group_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object group, such as "policy.k8s.io/v1".
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @return The bytes for group.
       */
      public com.google.protobuf.ByteString getGroupBytes() {
        java.lang.Object ref = group_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          group_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object group, such as "policy.k8s.io/v1".
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @param value The group to set.
       * @return This builder for chaining.
       */
      public Builder setGroup(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        group_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object group, such as "policy.k8s.io/v1".
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroup() {
        group_ = getDefaultInstance().getGroup();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object group, such as "policy.k8s.io/v1".
       * </pre>
       *
       * <code>string group = 1;</code>
       *
       * @param value The bytes for group to set.
       * @return This builder for chaining.
       */
      public Builder setGroupBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        group_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object kind_ = "";
      /**
       *
       *
       * <pre>
       * Kubernetes object kind, such as "Namespace".
       * </pre>
       *
       * <code>string kind = 2;</code>
       *
       * @return The kind.
       */
      public java.lang.String getKind() {
        java.lang.Object ref = kind_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kind_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object kind, such as "Namespace".
       * </pre>
       *
       * <code>string kind = 2;</code>
       *
       * @return The bytes for kind.
       */
      public com.google.protobuf.ByteString getKindBytes() {
        java.lang.Object ref = kind_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kind_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object kind, such as "Namespace".
       * </pre>
       *
       * <code>string kind = 2;</code>
       *
       * @param value The kind to set.
       * @return This builder for chaining.
       */
      public Builder setKind(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object kind, such as "Namespace".
       * </pre>
       *
       * <code>string kind = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKind() {
        kind_ = getDefaultInstance().getKind();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object kind, such as "Namespace".
       * </pre>
       *
       * <code>string kind = 2;</code>
       *
       * @param value The bytes for kind to set.
       * @return This builder for chaining.
       */
      public Builder setKindBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kind_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object ns_ = "";
      /**
       *
       *
       * <pre>
       * Kubernetes object namespace. Must be a valid DNS label. Named
       * "ns" to avoid collision with C++ namespace keyword. For details see
       * https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
       * </pre>
       *
       * <code>string ns = 3;</code>
       *
       * @return The ns.
       */
      public java.lang.String getNs() {
        java.lang.Object ref = ns_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ns_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object namespace. Must be a valid DNS label. Named
       * "ns" to avoid collision with C++ namespace keyword. For details see
       * https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
       * </pre>
       *
       * <code>string ns = 3;</code>
       *
       * @return The bytes for ns.
       */
      public com.google.protobuf.ByteString getNsBytes() {
        java.lang.Object ref = ns_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ns_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object namespace. Must be a valid DNS label. Named
       * "ns" to avoid collision with C++ namespace keyword. For details see
       * https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
       * </pre>
       *
       * <code>string ns = 3;</code>
       *
       * @param value The ns to set.
       * @return This builder for chaining.
       */
      public Builder setNs(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ns_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object namespace. Must be a valid DNS label. Named
       * "ns" to avoid collision with C++ namespace keyword. For details see
       * https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
       * </pre>
       *
       * <code>string ns = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNs() {
        ns_ = getDefaultInstance().getNs();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object namespace. Must be a valid DNS label. Named
       * "ns" to avoid collision with C++ namespace keyword. For details see
       * https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
       * </pre>
       *
       * <code>string ns = 3;</code>
       *
       * @param value The bytes for ns to set.
       * @return This builder for chaining.
       */
      public Builder setNsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ns_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Kubernetes object name. For details see
       * https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object name. For details see
       * https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object name. For details see
       * https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object name. For details see
       * https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kubernetes object name. For details see
       * https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
       * </pre>
       *
       * <code>string name = 4;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.securitycenter.v1.Container> containers_ =
          java.util.Collections.emptyList();

      private void ensureContainersIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          containers_ =
              new java.util.ArrayList<com.google.cloud.securitycenter.v1.Container>(containers_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Container,
              com.google.cloud.securitycenter.v1.Container.Builder,
              com.google.cloud.securitycenter.v1.ContainerOrBuilder>
          containersBuilder_;

      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Container> getContainersList() {
        if (containersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(containers_);
        } else {
          return containersBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public int getContainersCount() {
        if (containersBuilder_ == null) {
          return containers_.size();
        } else {
          return containersBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public com.google.cloud.securitycenter.v1.Container getContainers(int index) {
        if (containersBuilder_ == null) {
          return containers_.get(index);
        } else {
          return containersBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public Builder setContainers(int index, com.google.cloud.securitycenter.v1.Container value) {
        if (containersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainersIsMutable();
          containers_.set(index, value);
          onChanged();
        } else {
          containersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public Builder setContainers(
          int index, com.google.cloud.securitycenter.v1.Container.Builder builderForValue) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          containers_.set(index, builderForValue.build());
          onChanged();
        } else {
          containersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public Builder addContainers(com.google.cloud.securitycenter.v1.Container value) {
        if (containersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainersIsMutable();
          containers_.add(value);
          onChanged();
        } else {
          containersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public Builder addContainers(int index, com.google.cloud.securitycenter.v1.Container value) {
        if (containersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainersIsMutable();
          containers_.add(index, value);
          onChanged();
        } else {
          containersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public Builder addContainers(
          com.google.cloud.securitycenter.v1.Container.Builder builderForValue) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          containers_.add(builderForValue.build());
          onChanged();
        } else {
          containersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public Builder addContainers(
          int index, com.google.cloud.securitycenter.v1.Container.Builder builderForValue) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          containers_.add(index, builderForValue.build());
          onChanged();
        } else {
          containersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public Builder addAllContainers(
          java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Container> values) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, containers_);
          onChanged();
        } else {
          containersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public Builder clearContainers() {
        if (containersBuilder_ == null) {
          containers_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          containersBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public Builder removeContainers(int index) {
        if (containersBuilder_ == null) {
          ensureContainersIsMutable();
          containers_.remove(index);
          onChanged();
        } else {
          containersBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public com.google.cloud.securitycenter.v1.Container.Builder getContainersBuilder(int index) {
        return getContainersFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public com.google.cloud.securitycenter.v1.ContainerOrBuilder getContainersOrBuilder(
          int index) {
        if (containersBuilder_ == null) {
          return containers_.get(index);
        } else {
          return containersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public java.util.List<? extends com.google.cloud.securitycenter.v1.ContainerOrBuilder>
          getContainersOrBuilderList() {
        if (containersBuilder_ != null) {
          return containersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(containers_);
        }
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public com.google.cloud.securitycenter.v1.Container.Builder addContainersBuilder() {
        return getContainersFieldBuilder()
            .addBuilder(com.google.cloud.securitycenter.v1.Container.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public com.google.cloud.securitycenter.v1.Container.Builder addContainersBuilder(int index) {
        return getContainersFieldBuilder()
            .addBuilder(index, com.google.cloud.securitycenter.v1.Container.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Pod containers associated with this finding, if any.
       * </pre>
       *
       * <code>repeated .google.cloud.securitycenter.v1.Container containers = 5;</code>
       */
      public java.util.List<com.google.cloud.securitycenter.v1.Container.Builder>
          getContainersBuilderList() {
        return getContainersFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Container,
              com.google.cloud.securitycenter.v1.Container.Builder,
              com.google.cloud.securitycenter.v1.ContainerOrBuilder>
          getContainersFieldBuilder() {
        if (containersBuilder_ == null) {
          containersBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Container,
                  com.google.cloud.securitycenter.v1.Container.Builder,
                  com.google.cloud.securitycenter.v1.ContainerOrBuilder>(
                  containers_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
          containers_ = null;
        }
        return containersBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Kubernetes.Object)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Kubernetes.Object)
    private static final com.google.cloud.securitycenter.v1.Kubernetes.Object DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Kubernetes.Object();
    }

    public static com.google.cloud.securitycenter.v1.Kubernetes.Object getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Object> PARSER =
        new com.google.protobuf.AbstractParser<Object>() {
          @java.lang.Override
          public Object parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Object> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Object> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes.Object getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PODS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Pod> pods_;
  /**
   *
   *
   * <pre>
   * Kubernetes
   * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
   * associated with the finding. This field contains Pod records for each
   * container that is owned by a Pod.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Pod> getPodsList() {
    return pods_;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes
   * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
   * associated with the finding. This field contains Pod records for each
   * container that is owned by a Pod.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.PodOrBuilder>
      getPodsOrBuilderList() {
    return pods_;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes
   * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
   * associated with the finding. This field contains Pod records for each
   * container that is owned by a Pod.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
   */
  @java.lang.Override
  public int getPodsCount() {
    return pods_.size();
  }
  /**
   *
   *
   * <pre>
   * Kubernetes
   * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
   * associated with the finding. This field contains Pod records for each
   * container that is owned by a Pod.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.Pod getPods(int index) {
    return pods_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Kubernetes
   * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
   * associated with the finding. This field contains Pod records for each
   * container that is owned by a Pod.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.PodOrBuilder getPodsOrBuilder(int index) {
    return pods_.get(index);
  }

  public static final int NODES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node> nodes_;
  /**
   *
   *
   * <pre>
   * Provides Kubernetes
   * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
   * information.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node> getNodesList() {
    return nodes_;
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes
   * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
   * information.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>
      getNodesOrBuilderList() {
    return nodes_;
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes
   * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
   * information.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
   */
  @java.lang.Override
  public int getNodesCount() {
    return nodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes
   * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
   * information.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.Node getNodes(int index) {
    return nodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes
   * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
   * information.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder getNodesOrBuilder(int index) {
    return nodes_.get(index);
  }

  public static final int NODE_POOLS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.NodePool> nodePools_;
  /**
   *
   *
   * <pre>
   * GKE [node
   * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
   * associated with the finding. This field contains node pool information for
   * each node, when it is available.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.NodePool> getNodePoolsList() {
    return nodePools_;
  }
  /**
   *
   *
   * <pre>
   * GKE [node
   * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
   * associated with the finding. This field contains node pool information for
   * each node, when it is available.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.NodePoolOrBuilder>
      getNodePoolsOrBuilderList() {
    return nodePools_;
  }
  /**
   *
   *
   * <pre>
   * GKE [node
   * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
   * associated with the finding. This field contains node pool information for
   * each node, when it is available.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
   */
  @java.lang.Override
  public int getNodePoolsCount() {
    return nodePools_.size();
  }
  /**
   *
   *
   * <pre>
   * GKE [node
   * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
   * associated with the finding. This field contains node pool information for
   * each node, when it is available.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.NodePool getNodePools(int index) {
    return nodePools_.get(index);
  }
  /**
   *
   *
   * <pre>
   * GKE [node
   * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
   * associated with the finding. This field contains node pool information for
   * each node, when it is available.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.NodePoolOrBuilder getNodePoolsOrBuilder(
      int index) {
    return nodePools_.get(index);
  }

  public static final int ROLES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Role> roles_;
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role information for findings that involve [Roles or
   * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Role> getRolesList() {
    return roles_;
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role information for findings that involve [Roles or
   * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder>
      getRolesOrBuilderList() {
    return roles_;
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role information for findings that involve [Roles or
   * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
   */
  @java.lang.Override
  public int getRolesCount() {
    return roles_.size();
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role information for findings that involve [Roles or
   * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.Role getRoles(int index) {
    return roles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role information for findings that involve [Roles or
   * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder getRolesOrBuilder(int index) {
    return roles_.get(index);
  }

  public static final int BINDINGS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Binding> bindings_;
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role binding information for findings that involve
   * [RoleBindings or
   * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Binding> getBindingsList() {
    return bindings_;
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role binding information for findings that involve
   * [RoleBindings or
   * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.BindingOrBuilder>
      getBindingsOrBuilderList() {
    return bindings_;
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role binding information for findings that involve
   * [RoleBindings or
   * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
   */
  @java.lang.Override
  public int getBindingsCount() {
    return bindings_.size();
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role binding information for findings that involve
   * [RoleBindings or
   * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.Binding getBindings(int index) {
    return bindings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Provides Kubernetes role binding information for findings that involve
   * [RoleBindings or
   * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.BindingOrBuilder getBindingsOrBuilder(
      int index) {
    return bindings_.get(index);
  }

  public static final int ACCESS_REVIEWS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.AccessReview> accessReviews_;
  /**
   *
   *
   * <pre>
   * Provides information on any Kubernetes access reviews (privilege checks)
   * relevant to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.AccessReview>
      getAccessReviewsList() {
    return accessReviews_;
  }
  /**
   *
   *
   * <pre>
   * Provides information on any Kubernetes access reviews (privilege checks)
   * relevant to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.securitycenter.v1.Kubernetes.AccessReviewOrBuilder>
      getAccessReviewsOrBuilderList() {
    return accessReviews_;
  }
  /**
   *
   *
   * <pre>
   * Provides information on any Kubernetes access reviews (privilege checks)
   * relevant to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
   * </code>
   */
  @java.lang.Override
  public int getAccessReviewsCount() {
    return accessReviews_.size();
  }
  /**
   *
   *
   * <pre>
   * Provides information on any Kubernetes access reviews (privilege checks)
   * relevant to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.AccessReview getAccessReviews(int index) {
    return accessReviews_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Provides information on any Kubernetes access reviews (privilege checks)
   * relevant to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.AccessReviewOrBuilder
      getAccessReviewsOrBuilder(int index) {
    return accessReviews_.get(index);
  }

  public static final int OBJECTS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Object> objects_;
  /**
   *
   *
   * <pre>
   * Kubernetes objects related to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Object> getObjectsList() {
    return objects_;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes objects related to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.ObjectOrBuilder>
      getObjectsOrBuilderList() {
    return objects_;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes objects related to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
   */
  @java.lang.Override
  public int getObjectsCount() {
    return objects_.size();
  }
  /**
   *
   *
   * <pre>
   * Kubernetes objects related to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.Object getObjects(int index) {
    return objects_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Kubernetes objects related to the finding.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes.ObjectOrBuilder getObjectsOrBuilder(
      int index) {
    return objects_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < pods_.size(); i++) {
      output.writeMessage(1, pods_.get(i));
    }
    for (int i = 0; i < nodes_.size(); i++) {
      output.writeMessage(2, nodes_.get(i));
    }
    for (int i = 0; i < nodePools_.size(); i++) {
      output.writeMessage(3, nodePools_.get(i));
    }
    for (int i = 0; i < roles_.size(); i++) {
      output.writeMessage(4, roles_.get(i));
    }
    for (int i = 0; i < bindings_.size(); i++) {
      output.writeMessage(5, bindings_.get(i));
    }
    for (int i = 0; i < accessReviews_.size(); i++) {
      output.writeMessage(6, accessReviews_.get(i));
    }
    for (int i = 0; i < objects_.size(); i++) {
      output.writeMessage(7, objects_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < pods_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, pods_.get(i));
    }
    for (int i = 0; i < nodes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, nodes_.get(i));
    }
    for (int i = 0; i < nodePools_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, nodePools_.get(i));
    }
    for (int i = 0; i < roles_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, roles_.get(i));
    }
    for (int i = 0; i < bindings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, bindings_.get(i));
    }
    for (int i = 0; i < accessReviews_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, accessReviews_.get(i));
    }
    for (int i = 0; i < objects_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, objects_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Kubernetes)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Kubernetes other =
        (com.google.cloud.securitycenter.v1.Kubernetes) obj;

    if (!getPodsList().equals(other.getPodsList())) return false;
    if (!getNodesList().equals(other.getNodesList())) return false;
    if (!getNodePoolsList().equals(other.getNodePoolsList())) return false;
    if (!getRolesList().equals(other.getRolesList())) return false;
    if (!getBindingsList().equals(other.getBindingsList())) return false;
    if (!getAccessReviewsList().equals(other.getAccessReviewsList())) return false;
    if (!getObjectsList().equals(other.getObjectsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPodsCount() > 0) {
      hash = (37 * hash) + PODS_FIELD_NUMBER;
      hash = (53 * hash) + getPodsList().hashCode();
    }
    if (getNodesCount() > 0) {
      hash = (37 * hash) + NODES_FIELD_NUMBER;
      hash = (53 * hash) + getNodesList().hashCode();
    }
    if (getNodePoolsCount() > 0) {
      hash = (37 * hash) + NODE_POOLS_FIELD_NUMBER;
      hash = (53 * hash) + getNodePoolsList().hashCode();
    }
    if (getRolesCount() > 0) {
      hash = (37 * hash) + ROLES_FIELD_NUMBER;
      hash = (53 * hash) + getRolesList().hashCode();
    }
    if (getBindingsCount() > 0) {
      hash = (37 * hash) + BINDINGS_FIELD_NUMBER;
      hash = (53 * hash) + getBindingsList().hashCode();
    }
    if (getAccessReviewsCount() > 0) {
      hash = (37 * hash) + ACCESS_REVIEWS_FIELD_NUMBER;
      hash = (53 * hash) + getAccessReviewsList().hashCode();
    }
    if (getObjectsCount() > 0) {
      hash = (37 * hash) + OBJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Kubernetes prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes-related attributes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Kubernetes}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Kubernetes)
      com.google.cloud.securitycenter.v1.KubernetesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Kubernetes.class,
              com.google.cloud.securitycenter.v1.Kubernetes.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Kubernetes.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (podsBuilder_ == null) {
        pods_ = java.util.Collections.emptyList();
      } else {
        pods_ = null;
        podsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (nodesBuilder_ == null) {
        nodes_ = java.util.Collections.emptyList();
      } else {
        nodes_ = null;
        nodesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (nodePoolsBuilder_ == null) {
        nodePools_ = java.util.Collections.emptyList();
      } else {
        nodePools_ = null;
        nodePoolsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (rolesBuilder_ == null) {
        roles_ = java.util.Collections.emptyList();
      } else {
        roles_ = null;
        rolesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (bindingsBuilder_ == null) {
        bindings_ = java.util.Collections.emptyList();
      } else {
        bindings_ = null;
        bindingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (accessReviewsBuilder_ == null) {
        accessReviews_ = java.util.Collections.emptyList();
      } else {
        accessReviews_ = null;
        accessReviewsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (objectsBuilder_ == null) {
        objects_ = java.util.Collections.emptyList();
      } else {
        objects_ = null;
        objectsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.KubernetesProto
          .internal_static_google_cloud_securitycenter_v1_Kubernetes_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Kubernetes.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes build() {
      com.google.cloud.securitycenter.v1.Kubernetes result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Kubernetes buildPartial() {
      com.google.cloud.securitycenter.v1.Kubernetes result =
          new com.google.cloud.securitycenter.v1.Kubernetes(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.securitycenter.v1.Kubernetes result) {
      if (podsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          pods_ = java.util.Collections.unmodifiableList(pods_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.pods_ = pods_;
      } else {
        result.pods_ = podsBuilder_.build();
      }
      if (nodesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          nodes_ = java.util.Collections.unmodifiableList(nodes_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.nodes_ = nodes_;
      } else {
        result.nodes_ = nodesBuilder_.build();
      }
      if (nodePoolsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          nodePools_ = java.util.Collections.unmodifiableList(nodePools_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.nodePools_ = nodePools_;
      } else {
        result.nodePools_ = nodePoolsBuilder_.build();
      }
      if (rolesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          roles_ = java.util.Collections.unmodifiableList(roles_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.roles_ = roles_;
      } else {
        result.roles_ = rolesBuilder_.build();
      }
      if (bindingsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          bindings_ = java.util.Collections.unmodifiableList(bindings_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.bindings_ = bindings_;
      } else {
        result.bindings_ = bindingsBuilder_.build();
      }
      if (accessReviewsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          accessReviews_ = java.util.Collections.unmodifiableList(accessReviews_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.accessReviews_ = accessReviews_;
      } else {
        result.accessReviews_ = accessReviewsBuilder_.build();
      }
      if (objectsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          objects_ = java.util.Collections.unmodifiableList(objects_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.objects_ = objects_;
      } else {
        result.objects_ = objectsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Kubernetes result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Kubernetes) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Kubernetes) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Kubernetes other) {
      if (other == com.google.cloud.securitycenter.v1.Kubernetes.getDefaultInstance()) return this;
      if (podsBuilder_ == null) {
        if (!other.pods_.isEmpty()) {
          if (pods_.isEmpty()) {
            pods_ = other.pods_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePodsIsMutable();
            pods_.addAll(other.pods_);
          }
          onChanged();
        }
      } else {
        if (!other.pods_.isEmpty()) {
          if (podsBuilder_.isEmpty()) {
            podsBuilder_.dispose();
            podsBuilder_ = null;
            pods_ = other.pods_;
            bitField0_ = (bitField0_ & ~0x00000001);
            podsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPodsFieldBuilder()
                    : null;
          } else {
            podsBuilder_.addAllMessages(other.pods_);
          }
        }
      }
      if (nodesBuilder_ == null) {
        if (!other.nodes_.isEmpty()) {
          if (nodes_.isEmpty()) {
            nodes_ = other.nodes_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureNodesIsMutable();
            nodes_.addAll(other.nodes_);
          }
          onChanged();
        }
      } else {
        if (!other.nodes_.isEmpty()) {
          if (nodesBuilder_.isEmpty()) {
            nodesBuilder_.dispose();
            nodesBuilder_ = null;
            nodes_ = other.nodes_;
            bitField0_ = (bitField0_ & ~0x00000002);
            nodesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNodesFieldBuilder()
                    : null;
          } else {
            nodesBuilder_.addAllMessages(other.nodes_);
          }
        }
      }
      if (nodePoolsBuilder_ == null) {
        if (!other.nodePools_.isEmpty()) {
          if (nodePools_.isEmpty()) {
            nodePools_ = other.nodePools_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureNodePoolsIsMutable();
            nodePools_.addAll(other.nodePools_);
          }
          onChanged();
        }
      } else {
        if (!other.nodePools_.isEmpty()) {
          if (nodePoolsBuilder_.isEmpty()) {
            nodePoolsBuilder_.dispose();
            nodePoolsBuilder_ = null;
            nodePools_ = other.nodePools_;
            bitField0_ = (bitField0_ & ~0x00000004);
            nodePoolsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNodePoolsFieldBuilder()
                    : null;
          } else {
            nodePoolsBuilder_.addAllMessages(other.nodePools_);
          }
        }
      }
      if (rolesBuilder_ == null) {
        if (!other.roles_.isEmpty()) {
          if (roles_.isEmpty()) {
            roles_ = other.roles_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureRolesIsMutable();
            roles_.addAll(other.roles_);
          }
          onChanged();
        }
      } else {
        if (!other.roles_.isEmpty()) {
          if (rolesBuilder_.isEmpty()) {
            rolesBuilder_.dispose();
            rolesBuilder_ = null;
            roles_ = other.roles_;
            bitField0_ = (bitField0_ & ~0x00000008);
            rolesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRolesFieldBuilder()
                    : null;
          } else {
            rolesBuilder_.addAllMessages(other.roles_);
          }
        }
      }
      if (bindingsBuilder_ == null) {
        if (!other.bindings_.isEmpty()) {
          if (bindings_.isEmpty()) {
            bindings_ = other.bindings_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureBindingsIsMutable();
            bindings_.addAll(other.bindings_);
          }
          onChanged();
        }
      } else {
        if (!other.bindings_.isEmpty()) {
          if (bindingsBuilder_.isEmpty()) {
            bindingsBuilder_.dispose();
            bindingsBuilder_ = null;
            bindings_ = other.bindings_;
            bitField0_ = (bitField0_ & ~0x00000010);
            bindingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBindingsFieldBuilder()
                    : null;
          } else {
            bindingsBuilder_.addAllMessages(other.bindings_);
          }
        }
      }
      if (accessReviewsBuilder_ == null) {
        if (!other.accessReviews_.isEmpty()) {
          if (accessReviews_.isEmpty()) {
            accessReviews_ = other.accessReviews_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureAccessReviewsIsMutable();
            accessReviews_.addAll(other.accessReviews_);
          }
          onChanged();
        }
      } else {
        if (!other.accessReviews_.isEmpty()) {
          if (accessReviewsBuilder_.isEmpty()) {
            accessReviewsBuilder_.dispose();
            accessReviewsBuilder_ = null;
            accessReviews_ = other.accessReviews_;
            bitField0_ = (bitField0_ & ~0x00000020);
            accessReviewsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAccessReviewsFieldBuilder()
                    : null;
          } else {
            accessReviewsBuilder_.addAllMessages(other.accessReviews_);
          }
        }
      }
      if (objectsBuilder_ == null) {
        if (!other.objects_.isEmpty()) {
          if (objects_.isEmpty()) {
            objects_ = other.objects_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureObjectsIsMutable();
            objects_.addAll(other.objects_);
          }
          onChanged();
        }
      } else {
        if (!other.objects_.isEmpty()) {
          if (objectsBuilder_.isEmpty()) {
            objectsBuilder_.dispose();
            objectsBuilder_ = null;
            objects_ = other.objects_;
            bitField0_ = (bitField0_ & ~0x00000040);
            objectsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectsFieldBuilder()
                    : null;
          } else {
            objectsBuilder_.addAllMessages(other.objects_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.securitycenter.v1.Kubernetes.Pod m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Kubernetes.Pod.parser(),
                        extensionRegistry);
                if (podsBuilder_ == null) {
                  ensurePodsIsMutable();
                  pods_.add(m);
                } else {
                  podsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.securitycenter.v1.Kubernetes.Node m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Kubernetes.Node.parser(),
                        extensionRegistry);
                if (nodesBuilder_ == null) {
                  ensureNodesIsMutable();
                  nodes_.add(m);
                } else {
                  nodesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.securitycenter.v1.Kubernetes.NodePool m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Kubernetes.NodePool.parser(),
                        extensionRegistry);
                if (nodePoolsBuilder_ == null) {
                  ensureNodePoolsIsMutable();
                  nodePools_.add(m);
                } else {
                  nodePoolsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.securitycenter.v1.Kubernetes.Role m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Kubernetes.Role.parser(),
                        extensionRegistry);
                if (rolesBuilder_ == null) {
                  ensureRolesIsMutable();
                  roles_.add(m);
                } else {
                  rolesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.securitycenter.v1.Kubernetes.Binding m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Kubernetes.Binding.parser(),
                        extensionRegistry);
                if (bindingsBuilder_ == null) {
                  ensureBindingsIsMutable();
                  bindings_.add(m);
                } else {
                  bindingsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.securitycenter.v1.Kubernetes.AccessReview m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.parser(),
                        extensionRegistry);
                if (accessReviewsBuilder_ == null) {
                  ensureAccessReviewsIsMutable();
                  accessReviews_.add(m);
                } else {
                  accessReviewsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.securitycenter.v1.Kubernetes.Object m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.Kubernetes.Object.parser(),
                        extensionRegistry);
                if (objectsBuilder_ == null) {
                  ensureObjectsIsMutable();
                  objects_.add(m);
                } else {
                  objectsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Pod> pods_ =
        java.util.Collections.emptyList();

    private void ensurePodsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        pods_ = new java.util.ArrayList<com.google.cloud.securitycenter.v1.Kubernetes.Pod>(pods_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Pod,
            com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.PodOrBuilder>
        podsBuilder_;

    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Pod> getPodsList() {
      if (podsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pods_);
      } else {
        return podsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public int getPodsCount() {
      if (podsBuilder_ == null) {
        return pods_.size();
      } else {
        return podsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Pod getPods(int index) {
      if (podsBuilder_ == null) {
        return pods_.get(index);
      } else {
        return podsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public Builder setPods(int index, com.google.cloud.securitycenter.v1.Kubernetes.Pod value) {
      if (podsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePodsIsMutable();
        pods_.set(index, value);
        onChanged();
      } else {
        podsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public Builder setPods(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder builderForValue) {
      if (podsBuilder_ == null) {
        ensurePodsIsMutable();
        pods_.set(index, builderForValue.build());
        onChanged();
      } else {
        podsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public Builder addPods(com.google.cloud.securitycenter.v1.Kubernetes.Pod value) {
      if (podsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePodsIsMutable();
        pods_.add(value);
        onChanged();
      } else {
        podsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public Builder addPods(int index, com.google.cloud.securitycenter.v1.Kubernetes.Pod value) {
      if (podsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePodsIsMutable();
        pods_.add(index, value);
        onChanged();
      } else {
        podsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public Builder addPods(
        com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder builderForValue) {
      if (podsBuilder_ == null) {
        ensurePodsIsMutable();
        pods_.add(builderForValue.build());
        onChanged();
      } else {
        podsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public Builder addPods(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder builderForValue) {
      if (podsBuilder_ == null) {
        ensurePodsIsMutable();
        pods_.add(index, builderForValue.build());
        onChanged();
      } else {
        podsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public Builder addAllPods(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Kubernetes.Pod> values) {
      if (podsBuilder_ == null) {
        ensurePodsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pods_);
        onChanged();
      } else {
        podsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public Builder clearPods() {
      if (podsBuilder_ == null) {
        pods_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        podsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public Builder removePods(int index) {
      if (podsBuilder_ == null) {
        ensurePodsIsMutable();
        pods_.remove(index);
        onChanged();
      } else {
        podsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder getPodsBuilder(int index) {
      return getPodsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.PodOrBuilder getPodsOrBuilder(int index) {
      if (podsBuilder_ == null) {
        return pods_.get(index);
      } else {
        return podsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.PodOrBuilder>
        getPodsOrBuilderList() {
      if (podsBuilder_ != null) {
        return podsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pods_);
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder addPodsBuilder() {
      return getPodsFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Pod.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder addPodsBuilder(int index) {
      return getPodsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.securitycenter.v1.Kubernetes.Pod.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Kubernetes
     * [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
     * associated with the finding. This field contains Pod records for each
     * container that is owned by a Pod.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Pod pods = 1;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder>
        getPodsBuilderList() {
      return getPodsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Pod,
            com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.PodOrBuilder>
        getPodsFieldBuilder() {
      if (podsBuilder_ == null) {
        podsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Kubernetes.Pod,
                com.google.cloud.securitycenter.v1.Kubernetes.Pod.Builder,
                com.google.cloud.securitycenter.v1.Kubernetes.PodOrBuilder>(
                pods_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        pods_ = null;
      }
      return podsBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node> nodes_ =
        java.util.Collections.emptyList();

    private void ensureNodesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        nodes_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Kubernetes.Node>(nodes_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Node,
            com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>
        nodesBuilder_;

    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node> getNodesList() {
      if (nodesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nodes_);
      } else {
        return nodesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public int getNodesCount() {
      if (nodesBuilder_ == null) {
        return nodes_.size();
      } else {
        return nodesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Node getNodes(int index) {
      if (nodesBuilder_ == null) {
        return nodes_.get(index);
      } else {
        return nodesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public Builder setNodes(int index, com.google.cloud.securitycenter.v1.Kubernetes.Node value) {
      if (nodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodesIsMutable();
        nodes_.set(index, value);
        onChanged();
      } else {
        nodesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public Builder setNodes(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder builderForValue) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        nodes_.set(index, builderForValue.build());
        onChanged();
      } else {
        nodesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public Builder addNodes(com.google.cloud.securitycenter.v1.Kubernetes.Node value) {
      if (nodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodesIsMutable();
        nodes_.add(value);
        onChanged();
      } else {
        nodesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public Builder addNodes(int index, com.google.cloud.securitycenter.v1.Kubernetes.Node value) {
      if (nodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodesIsMutable();
        nodes_.add(index, value);
        onChanged();
      } else {
        nodesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public Builder addNodes(
        com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder builderForValue) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        nodes_.add(builderForValue.build());
        onChanged();
      } else {
        nodesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public Builder addNodes(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder builderForValue) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        nodes_.add(index, builderForValue.build());
        onChanged();
      } else {
        nodesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public Builder addAllNodes(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Kubernetes.Node> values) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodes_);
        onChanged();
      } else {
        nodesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public Builder clearNodes() {
      if (nodesBuilder_ == null) {
        nodes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        nodesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public Builder removeNodes(int index) {
      if (nodesBuilder_ == null) {
        ensureNodesIsMutable();
        nodes_.remove(index);
        onChanged();
      } else {
        nodesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder getNodesBuilder(int index) {
      return getNodesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder getNodesOrBuilder(
        int index) {
      if (nodesBuilder_ == null) {
        return nodes_.get(index);
      } else {
        return nodesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>
        getNodesOrBuilderList() {
      if (nodesBuilder_ != null) {
        return nodesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nodes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder addNodesBuilder() {
      return getNodesFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Node.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder addNodesBuilder(int index) {
      return getNodesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.securitycenter.v1.Kubernetes.Node.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes
     * [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
     * information.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Node nodes = 2;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder>
        getNodesBuilderList() {
      return getNodesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Node,
            com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>
        getNodesFieldBuilder() {
      if (nodesBuilder_ == null) {
        nodesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Kubernetes.Node,
                com.google.cloud.securitycenter.v1.Kubernetes.Node.Builder,
                com.google.cloud.securitycenter.v1.Kubernetes.NodeOrBuilder>(
                nodes_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        nodes_ = null;
      }
      return nodesBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.NodePool> nodePools_ =
        java.util.Collections.emptyList();

    private void ensureNodePoolsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        nodePools_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Kubernetes.NodePool>(
                nodePools_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.NodePool,
            com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.NodePoolOrBuilder>
        nodePoolsBuilder_;

    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.NodePool>
        getNodePoolsList() {
      if (nodePoolsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nodePools_);
      } else {
        return nodePoolsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public int getNodePoolsCount() {
      if (nodePoolsBuilder_ == null) {
        return nodePools_.size();
      } else {
        return nodePoolsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.NodePool getNodePools(int index) {
      if (nodePoolsBuilder_ == null) {
        return nodePools_.get(index);
      } else {
        return nodePoolsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public Builder setNodePools(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.NodePool value) {
      if (nodePoolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodePoolsIsMutable();
        nodePools_.set(index, value);
        onChanged();
      } else {
        nodePoolsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public Builder setNodePools(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder builderForValue) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        nodePools_.set(index, builderForValue.build());
        onChanged();
      } else {
        nodePoolsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public Builder addNodePools(com.google.cloud.securitycenter.v1.Kubernetes.NodePool value) {
      if (nodePoolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodePoolsIsMutable();
        nodePools_.add(value);
        onChanged();
      } else {
        nodePoolsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public Builder addNodePools(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.NodePool value) {
      if (nodePoolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodePoolsIsMutable();
        nodePools_.add(index, value);
        onChanged();
      } else {
        nodePoolsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public Builder addNodePools(
        com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder builderForValue) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        nodePools_.add(builderForValue.build());
        onChanged();
      } else {
        nodePoolsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public Builder addNodePools(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder builderForValue) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        nodePools_.add(index, builderForValue.build());
        onChanged();
      } else {
        nodePoolsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public Builder addAllNodePools(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Kubernetes.NodePool>
            values) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodePools_);
        onChanged();
      } else {
        nodePoolsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public Builder clearNodePools() {
      if (nodePoolsBuilder_ == null) {
        nodePools_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        nodePoolsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public Builder removeNodePools(int index) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        nodePools_.remove(index);
        onChanged();
      } else {
        nodePoolsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder getNodePoolsBuilder(
        int index) {
      return getNodePoolsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.NodePoolOrBuilder getNodePoolsOrBuilder(
        int index) {
      if (nodePoolsBuilder_ == null) {
        return nodePools_.get(index);
      } else {
        return nodePoolsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.NodePoolOrBuilder>
        getNodePoolsOrBuilderList() {
      if (nodePoolsBuilder_ != null) {
        return nodePoolsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nodePools_);
      }
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder addNodePoolsBuilder() {
      return getNodePoolsFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Kubernetes.NodePool.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder addNodePoolsBuilder(
        int index) {
      return getNodePoolsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.securitycenter.v1.Kubernetes.NodePool.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * GKE [node
     * pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
     * associated with the finding. This field contains node pool information for
     * each node, when it is available.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.NodePool node_pools = 3;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder>
        getNodePoolsBuilderList() {
      return getNodePoolsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.NodePool,
            com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.NodePoolOrBuilder>
        getNodePoolsFieldBuilder() {
      if (nodePoolsBuilder_ == null) {
        nodePoolsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Kubernetes.NodePool,
                com.google.cloud.securitycenter.v1.Kubernetes.NodePool.Builder,
                com.google.cloud.securitycenter.v1.Kubernetes.NodePoolOrBuilder>(
                nodePools_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        nodePools_ = null;
      }
      return nodePoolsBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Role> roles_ =
        java.util.Collections.emptyList();

    private void ensureRolesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        roles_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Kubernetes.Role>(roles_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Role,
            com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder>
        rolesBuilder_;

    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Role> getRolesList() {
      if (rolesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(roles_);
      } else {
        return rolesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public int getRolesCount() {
      if (rolesBuilder_ == null) {
        return roles_.size();
      } else {
        return rolesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Role getRoles(int index) {
      if (rolesBuilder_ == null) {
        return roles_.get(index);
      } else {
        return rolesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public Builder setRoles(int index, com.google.cloud.securitycenter.v1.Kubernetes.Role value) {
      if (rolesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRolesIsMutable();
        roles_.set(index, value);
        onChanged();
      } else {
        rolesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public Builder setRoles(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder builderForValue) {
      if (rolesBuilder_ == null) {
        ensureRolesIsMutable();
        roles_.set(index, builderForValue.build());
        onChanged();
      } else {
        rolesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public Builder addRoles(com.google.cloud.securitycenter.v1.Kubernetes.Role value) {
      if (rolesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRolesIsMutable();
        roles_.add(value);
        onChanged();
      } else {
        rolesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public Builder addRoles(int index, com.google.cloud.securitycenter.v1.Kubernetes.Role value) {
      if (rolesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRolesIsMutable();
        roles_.add(index, value);
        onChanged();
      } else {
        rolesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public Builder addRoles(
        com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder builderForValue) {
      if (rolesBuilder_ == null) {
        ensureRolesIsMutable();
        roles_.add(builderForValue.build());
        onChanged();
      } else {
        rolesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public Builder addRoles(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder builderForValue) {
      if (rolesBuilder_ == null) {
        ensureRolesIsMutable();
        roles_.add(index, builderForValue.build());
        onChanged();
      } else {
        rolesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public Builder addAllRoles(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Kubernetes.Role> values) {
      if (rolesBuilder_ == null) {
        ensureRolesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, roles_);
        onChanged();
      } else {
        rolesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public Builder clearRoles() {
      if (rolesBuilder_ == null) {
        roles_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        rolesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public Builder removeRoles(int index) {
      if (rolesBuilder_ == null) {
        ensureRolesIsMutable();
        roles_.remove(index);
        onChanged();
      } else {
        rolesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder getRolesBuilder(int index) {
      return getRolesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder getRolesOrBuilder(
        int index) {
      if (rolesBuilder_ == null) {
        return roles_.get(index);
      } else {
        return rolesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder>
        getRolesOrBuilderList() {
      if (rolesBuilder_ != null) {
        return rolesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(roles_);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder addRolesBuilder() {
      return getRolesFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Role.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder addRolesBuilder(int index) {
      return getRolesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.securitycenter.v1.Kubernetes.Role.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role information for findings that involve [Roles or
     * ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Role roles = 4;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder>
        getRolesBuilderList() {
      return getRolesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Role,
            com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder>
        getRolesFieldBuilder() {
      if (rolesBuilder_ == null) {
        rolesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Kubernetes.Role,
                com.google.cloud.securitycenter.v1.Kubernetes.Role.Builder,
                com.google.cloud.securitycenter.v1.Kubernetes.RoleOrBuilder>(
                roles_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        roles_ = null;
      }
      return rolesBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Binding> bindings_ =
        java.util.Collections.emptyList();

    private void ensureBindingsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        bindings_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Kubernetes.Binding>(
                bindings_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Binding,
            com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.BindingOrBuilder>
        bindingsBuilder_;

    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Binding> getBindingsList() {
      if (bindingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bindings_);
      } else {
        return bindingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public int getBindingsCount() {
      if (bindingsBuilder_ == null) {
        return bindings_.size();
      } else {
        return bindingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Binding getBindings(int index) {
      if (bindingsBuilder_ == null) {
        return bindings_.get(index);
      } else {
        return bindingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public Builder setBindings(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Binding value) {
      if (bindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBindingsIsMutable();
        bindings_.set(index, value);
        onChanged();
      } else {
        bindingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public Builder setBindings(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder builderForValue) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        bindings_.set(index, builderForValue.build());
        onChanged();
      } else {
        bindingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public Builder addBindings(com.google.cloud.securitycenter.v1.Kubernetes.Binding value) {
      if (bindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBindingsIsMutable();
        bindings_.add(value);
        onChanged();
      } else {
        bindingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public Builder addBindings(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Binding value) {
      if (bindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBindingsIsMutable();
        bindings_.add(index, value);
        onChanged();
      } else {
        bindingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public Builder addBindings(
        com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder builderForValue) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        bindings_.add(builderForValue.build());
        onChanged();
      } else {
        bindingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public Builder addBindings(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder builderForValue) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        bindings_.add(index, builderForValue.build());
        onChanged();
      } else {
        bindingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public Builder addAllBindings(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Kubernetes.Binding>
            values) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bindings_);
        onChanged();
      } else {
        bindingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public Builder clearBindings() {
      if (bindingsBuilder_ == null) {
        bindings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        bindingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public Builder removeBindings(int index) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        bindings_.remove(index);
        onChanged();
      } else {
        bindingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder getBindingsBuilder(
        int index) {
      return getBindingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.BindingOrBuilder getBindingsOrBuilder(
        int index) {
      if (bindingsBuilder_ == null) {
        return bindings_.get(index);
      } else {
        return bindingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.BindingOrBuilder>
        getBindingsOrBuilderList() {
      if (bindingsBuilder_ != null) {
        return bindingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bindings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder addBindingsBuilder() {
      return getBindingsFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Binding.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder addBindingsBuilder(
        int index) {
      return getBindingsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.securitycenter.v1.Kubernetes.Binding.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Provides Kubernetes role binding information for findings that involve
     * [RoleBindings or
     * ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Binding bindings = 5;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder>
        getBindingsBuilderList() {
      return getBindingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Binding,
            com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.BindingOrBuilder>
        getBindingsFieldBuilder() {
      if (bindingsBuilder_ == null) {
        bindingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Kubernetes.Binding,
                com.google.cloud.securitycenter.v1.Kubernetes.Binding.Builder,
                com.google.cloud.securitycenter.v1.Kubernetes.BindingOrBuilder>(
                bindings_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        bindings_ = null;
      }
      return bindingsBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.AccessReview>
        accessReviews_ = java.util.Collections.emptyList();

    private void ensureAccessReviewsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        accessReviews_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Kubernetes.AccessReview>(
                accessReviews_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.AccessReview,
            com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.AccessReviewOrBuilder>
        accessReviewsBuilder_;

    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.AccessReview>
        getAccessReviewsList() {
      if (accessReviewsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accessReviews_);
      } else {
        return accessReviewsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public int getAccessReviewsCount() {
      if (accessReviewsBuilder_ == null) {
        return accessReviews_.size();
      } else {
        return accessReviewsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.AccessReview getAccessReviews(int index) {
      if (accessReviewsBuilder_ == null) {
        return accessReviews_.get(index);
      } else {
        return accessReviewsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public Builder setAccessReviews(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.AccessReview value) {
      if (accessReviewsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessReviewsIsMutable();
        accessReviews_.set(index, value);
        onChanged();
      } else {
        accessReviewsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public Builder setAccessReviews(
        int index,
        com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder builderForValue) {
      if (accessReviewsBuilder_ == null) {
        ensureAccessReviewsIsMutable();
        accessReviews_.set(index, builderForValue.build());
        onChanged();
      } else {
        accessReviewsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public Builder addAccessReviews(
        com.google.cloud.securitycenter.v1.Kubernetes.AccessReview value) {
      if (accessReviewsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessReviewsIsMutable();
        accessReviews_.add(value);
        onChanged();
      } else {
        accessReviewsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public Builder addAccessReviews(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.AccessReview value) {
      if (accessReviewsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAccessReviewsIsMutable();
        accessReviews_.add(index, value);
        onChanged();
      } else {
        accessReviewsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public Builder addAccessReviews(
        com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder builderForValue) {
      if (accessReviewsBuilder_ == null) {
        ensureAccessReviewsIsMutable();
        accessReviews_.add(builderForValue.build());
        onChanged();
      } else {
        accessReviewsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public Builder addAccessReviews(
        int index,
        com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder builderForValue) {
      if (accessReviewsBuilder_ == null) {
        ensureAccessReviewsIsMutable();
        accessReviews_.add(index, builderForValue.build());
        onChanged();
      } else {
        accessReviewsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public Builder addAllAccessReviews(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Kubernetes.AccessReview>
            values) {
      if (accessReviewsBuilder_ == null) {
        ensureAccessReviewsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accessReviews_);
        onChanged();
      } else {
        accessReviewsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public Builder clearAccessReviews() {
      if (accessReviewsBuilder_ == null) {
        accessReviews_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        accessReviewsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public Builder removeAccessReviews(int index) {
      if (accessReviewsBuilder_ == null) {
        ensureAccessReviewsIsMutable();
        accessReviews_.remove(index);
        onChanged();
      } else {
        accessReviewsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder
        getAccessReviewsBuilder(int index) {
      return getAccessReviewsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.AccessReviewOrBuilder
        getAccessReviewsOrBuilder(int index) {
      if (accessReviewsBuilder_ == null) {
        return accessReviews_.get(index);
      } else {
        return accessReviewsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.securitycenter.v1.Kubernetes.AccessReviewOrBuilder>
        getAccessReviewsOrBuilderList() {
      if (accessReviewsBuilder_ != null) {
        return accessReviewsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accessReviews_);
      }
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder
        addAccessReviewsBuilder() {
      return getAccessReviewsFieldBuilder()
          .addBuilder(
              com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder
        addAccessReviewsBuilder(int index) {
      return getAccessReviewsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Provides information on any Kubernetes access reviews (privilege checks)
     * relevant to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.AccessReview access_reviews = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder>
        getAccessReviewsBuilderList() {
      return getAccessReviewsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.AccessReview,
            com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.AccessReviewOrBuilder>
        getAccessReviewsFieldBuilder() {
      if (accessReviewsBuilder_ == null) {
        accessReviewsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Kubernetes.AccessReview,
                com.google.cloud.securitycenter.v1.Kubernetes.AccessReview.Builder,
                com.google.cloud.securitycenter.v1.Kubernetes.AccessReviewOrBuilder>(
                accessReviews_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        accessReviews_ = null;
      }
      return accessReviewsBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Object> objects_ =
        java.util.Collections.emptyList();

    private void ensureObjectsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        objects_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.Kubernetes.Object>(objects_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Object,
            com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.ObjectOrBuilder>
        objectsBuilder_;

    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Object> getObjectsList() {
      if (objectsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objects_);
      } else {
        return objectsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public int getObjectsCount() {
      if (objectsBuilder_ == null) {
        return objects_.size();
      } else {
        return objectsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Object getObjects(int index) {
      if (objectsBuilder_ == null) {
        return objects_.get(index);
      } else {
        return objectsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public Builder setObjects(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Object value) {
      if (objectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectsIsMutable();
        objects_.set(index, value);
        onChanged();
      } else {
        objectsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public Builder setObjects(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder builderForValue) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        objects_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public Builder addObjects(com.google.cloud.securitycenter.v1.Kubernetes.Object value) {
      if (objectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectsIsMutable();
        objects_.add(value);
        onChanged();
      } else {
        objectsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public Builder addObjects(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Object value) {
      if (objectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectsIsMutable();
        objects_.add(index, value);
        onChanged();
      } else {
        objectsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public Builder addObjects(
        com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder builderForValue) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        objects_.add(builderForValue.build());
        onChanged();
      } else {
        objectsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public Builder addObjects(
        int index, com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder builderForValue) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        objects_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public Builder addAllObjects(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.Kubernetes.Object> values) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objects_);
        onChanged();
      } else {
        objectsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public Builder clearObjects() {
      if (objectsBuilder_ == null) {
        objects_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        objectsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public Builder removeObjects(int index) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        objects_.remove(index);
        onChanged();
      } else {
        objectsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder getObjectsBuilder(
        int index) {
      return getObjectsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.ObjectOrBuilder getObjectsOrBuilder(
        int index) {
      if (objectsBuilder_ == null) {
        return objects_.get(index);
      } else {
        return objectsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.Kubernetes.ObjectOrBuilder>
        getObjectsOrBuilderList() {
      if (objectsBuilder_ != null) {
        return objectsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objects_);
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder addObjectsBuilder() {
      return getObjectsFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.Kubernetes.Object.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder addObjectsBuilder(
        int index) {
      return getObjectsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.securitycenter.v1.Kubernetes.Object.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Kubernetes objects related to the finding.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.Kubernetes.Object objects = 7;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder>
        getObjectsBuilderList() {
      return getObjectsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Kubernetes.Object,
            com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder,
            com.google.cloud.securitycenter.v1.Kubernetes.ObjectOrBuilder>
        getObjectsFieldBuilder() {
      if (objectsBuilder_ == null) {
        objectsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Kubernetes.Object,
                com.google.cloud.securitycenter.v1.Kubernetes.Object.Builder,
                com.google.cloud.securitycenter.v1.Kubernetes.ObjectOrBuilder>(
                objects_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        objects_ = null;
      }
      return objectsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Kubernetes)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Kubernetes)
  private static final com.google.cloud.securitycenter.v1.Kubernetes DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Kubernetes();
  }

  public static com.google.cloud.securitycenter.v1.Kubernetes getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Kubernetes> PARSER =
      new com.google.protobuf.AbstractParser<Kubernetes>() {
        @java.lang.Override
        public Kubernetes parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Kubernetes> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Kubernetes> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Kubernetes getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
