/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Request message for listing assets.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.ListAssetsRequest}
 */
public final class ListAssetsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.ListAssetsRequest)
    ListAssetsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListAssetsRequest.newBuilder() to construct.
  private ListAssetsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListAssetsRequest() {
    parent_ = "";
    filter_ = "";
    orderBy_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListAssetsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_ListAssetsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_ListAssetsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.ListAssetsRequest.class,
            com.google.cloud.securitycenter.v1.ListAssetsRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the parent resource that contains the assets. The
   * value that you can specify on parent depends on the method in which you
   * specify parent. You can specify one of the following values:
   * "organizations/[organization_id]", "folders/[folder_id]", or
   * "projects/[project_id]".
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the parent resource that contains the assets. The
   * value that you can specify on parent depends on the method in which you
   * specify parent. You can specify one of the following values:
   * "organizations/[organization_id]", "folders/[folder_id]", or
   * "projects/[project_id]".
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Expression that defines the filter to apply across assets.
   * The expression is a list of zero or more restrictions combined via logical
   * operators `AND` and `OR`.
   * Parentheses are supported, and `OR` has higher precedence than `AND`.
   *
   * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a `-`
   * character in front of them to indicate negation. The fields map to those
   * defined in the Asset resource. Examples include:
   *
   * * name
   * * security_center_properties.resource_name
   * * resource_properties.a_property
   * * security_marks.marks.marka
   *
   * The supported operators are:
   *
   * * `=` for all value types.
   * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
   * * `:`, meaning substring matching, for strings.
   *
   * The supported value types are:
   *
   * * string literals in quotes.
   * * integer literals without quotes.
   * * boolean literals `true` and `false` without quotes.
   *
   * The following are the allowed field and operator combinations:
   *
   * * name: `=`
   * * update_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
   *
   *   Usage: This should be milliseconds since epoch or an RFC3339 string.
   *   Examples:
   *     `update_time = "2019-06-10T16:07:18-07:00"`
   *     `update_time = 1560208038000`
   *
   * * create_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
   *
   *   Usage: This should be milliseconds since epoch or an RFC3339 string.
   *   Examples:
   *     `create_time = "2019-06-10T16:07:18-07:00"`
   *     `create_time = 1560208038000`
   *
   * * iam_policy.policy_blob: `=`, `:`
   * * resource_properties: `=`, `:`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
   * * security_marks.marks: `=`, `:`
   * * security_center_properties.resource_name: `=`, `:`
   * * security_center_properties.resource_display_name: `=`, `:`
   * * security_center_properties.resource_type: `=`, `:`
   * * security_center_properties.resource_parent: `=`, `:`
   * * security_center_properties.resource_parent_display_name: `=`, `:`
   * * security_center_properties.resource_project: `=`, `:`
   * * security_center_properties.resource_project_display_name: `=`, `:`
   * * security_center_properties.resource_owners: `=`, `:`
   *
   * For example, `resource_properties.size = 100` is a valid filter string.
   *
   * Use a partial match on the empty string to filter based on a property
   * existing: `resource_properties.my_property : ""`
   *
   * Use a negated partial match on the empty string to filter based on a
   * property not existing: `-resource_properties.my_property : ""`
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Expression that defines the filter to apply across assets.
   * The expression is a list of zero or more restrictions combined via logical
   * operators `AND` and `OR`.
   * Parentheses are supported, and `OR` has higher precedence than `AND`.
   *
   * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a `-`
   * character in front of them to indicate negation. The fields map to those
   * defined in the Asset resource. Examples include:
   *
   * * name
   * * security_center_properties.resource_name
   * * resource_properties.a_property
   * * security_marks.marks.marka
   *
   * The supported operators are:
   *
   * * `=` for all value types.
   * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
   * * `:`, meaning substring matching, for strings.
   *
   * The supported value types are:
   *
   * * string literals in quotes.
   * * integer literals without quotes.
   * * boolean literals `true` and `false` without quotes.
   *
   * The following are the allowed field and operator combinations:
   *
   * * name: `=`
   * * update_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
   *
   *   Usage: This should be milliseconds since epoch or an RFC3339 string.
   *   Examples:
   *     `update_time = "2019-06-10T16:07:18-07:00"`
   *     `update_time = 1560208038000`
   *
   * * create_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
   *
   *   Usage: This should be milliseconds since epoch or an RFC3339 string.
   *   Examples:
   *     `create_time = "2019-06-10T16:07:18-07:00"`
   *     `create_time = 1560208038000`
   *
   * * iam_policy.policy_blob: `=`, `:`
   * * resource_properties: `=`, `:`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
   * * security_marks.marks: `=`, `:`
   * * security_center_properties.resource_name: `=`, `:`
   * * security_center_properties.resource_display_name: `=`, `:`
   * * security_center_properties.resource_type: `=`, `:`
   * * security_center_properties.resource_parent: `=`, `:`
   * * security_center_properties.resource_parent_display_name: `=`, `:`
   * * security_center_properties.resource_project: `=`, `:`
   * * security_center_properties.resource_project_display_name: `=`, `:`
   * * security_center_properties.resource_owners: `=`, `:`
   *
   * For example, `resource_properties.size = 100` is a valid filter string.
   *
   * Use a partial match on the empty string to filter based on a property
   * existing: `resource_properties.my_property : ""`
   *
   * Use a negated partial match on the empty string to filter based on a
   * property not existing: `-resource_properties.my_property : ""`
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object orderBy_ = "";
  /**
   *
   *
   * <pre>
   * Expression that defines what fields and order to use for sorting. The
   * string value should follow SQL syntax: comma separated list of fields. For
   * example: "name,resource_properties.a_property". The default sorting order
   * is ascending. To specify descending order for a field, a suffix " desc"
   * should be appended to the field name. For example: "name
   * desc,resource_properties.a_property". Redundant space characters in the
   * syntax are insignificant. "name desc,resource_properties.a_property" and "
   * name     desc  ,   resource_properties.a_property  " are equivalent.
   *
   * The following fields are supported:
   * name
   * update_time
   * resource_properties
   * security_marks.marks
   * security_center_properties.resource_name
   * security_center_properties.resource_display_name
   * security_center_properties.resource_parent
   * security_center_properties.resource_parent_display_name
   * security_center_properties.resource_project
   * security_center_properties.resource_project_display_name
   * security_center_properties.resource_type
   * </pre>
   *
   * <code>string order_by = 3;</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Expression that defines what fields and order to use for sorting. The
   * string value should follow SQL syntax: comma separated list of fields. For
   * example: "name,resource_properties.a_property". The default sorting order
   * is ascending. To specify descending order for a field, a suffix " desc"
   * should be appended to the field name. For example: "name
   * desc,resource_properties.a_property". Redundant space characters in the
   * syntax are insignificant. "name desc,resource_properties.a_property" and "
   * name     desc  ,   resource_properties.a_property  " are equivalent.
   *
   * The following fields are supported:
   * name
   * update_time
   * resource_properties
   * security_marks.marks
   * security_center_properties.resource_name
   * security_center_properties.resource_display_name
   * security_center_properties.resource_parent
   * security_center_properties.resource_parent_display_name
   * security_center_properties.resource_project
   * security_center_properties.resource_project_display_name
   * security_center_properties.resource_type
   * </pre>
   *
   * <code>string order_by = 3;</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp readTime_;
  /**
   *
   *
   * <pre>
   * Time used as a reference point when filtering assets. The filter is limited
   * to assets existing at the supplied time and their values are those at that
   * specific time. Absence of this field will default to the API's version of
   * NOW.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 4;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time used as a reference point when filtering assets. The filter is limited
   * to assets existing at the supplied time and their values are those at that
   * specific time. Absence of this field will default to the API's version of
   * NOW.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 4;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }
  /**
   *
   *
   * <pre>
   * Time used as a reference point when filtering assets. The filter is limited
   * to assets existing at the supplied time and their values are those at that
   * specific time. Absence of this field will default to the API's version of
   * NOW.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }

  public static final int COMPARE_DURATION_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration compareDuration_;
  /**
   *
   *
   * <pre>
   * When compare_duration is set, the ListAssetsResult's "state_change"
   * attribute is updated to indicate whether the asset was added, removed, or
   * remained present during the compare_duration period of time that precedes
   * the read_time. This is the time between (read_time - compare_duration) and
   * read_time.
   *
   * The state_change value is derived based on the presence of the asset at the
   * two points in time. Intermediate state changes between the two times don't
   * affect the result. For example, the results aren't affected if the asset is
   * removed and re-created again.
   *
   * Possible "state_change" values when compare_duration is specified:
   *
   * * "ADDED":   indicates that the asset was not present at the start of
   *                compare_duration, but present at read_time.
   * * "REMOVED": indicates that the asset was present at the start of
   *                compare_duration, but not present at read_time.
   * * "ACTIVE":  indicates that the asset was present at both the
   *                start and the end of the time period defined by
   *                compare_duration and read_time.
   *
   * If compare_duration is not specified, then the only possible state_change
   * is "UNUSED",  which will be the state_change set for all assets present at
   * read_time.
   * </pre>
   *
   * <code>.google.protobuf.Duration compare_duration = 5;</code>
   *
   * @return Whether the compareDuration field is set.
   */
  @java.lang.Override
  public boolean hasCompareDuration() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * When compare_duration is set, the ListAssetsResult's "state_change"
   * attribute is updated to indicate whether the asset was added, removed, or
   * remained present during the compare_duration period of time that precedes
   * the read_time. This is the time between (read_time - compare_duration) and
   * read_time.
   *
   * The state_change value is derived based on the presence of the asset at the
   * two points in time. Intermediate state changes between the two times don't
   * affect the result. For example, the results aren't affected if the asset is
   * removed and re-created again.
   *
   * Possible "state_change" values when compare_duration is specified:
   *
   * * "ADDED":   indicates that the asset was not present at the start of
   *                compare_duration, but present at read_time.
   * * "REMOVED": indicates that the asset was present at the start of
   *                compare_duration, but not present at read_time.
   * * "ACTIVE":  indicates that the asset was present at both the
   *                start and the end of the time period defined by
   *                compare_duration and read_time.
   *
   * If compare_duration is not specified, then the only possible state_change
   * is "UNUSED",  which will be the state_change set for all assets present at
   * read_time.
   * </pre>
   *
   * <code>.google.protobuf.Duration compare_duration = 5;</code>
   *
   * @return The compareDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getCompareDuration() {
    return compareDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : compareDuration_;
  }
  /**
   *
   *
   * <pre>
   * When compare_duration is set, the ListAssetsResult's "state_change"
   * attribute is updated to indicate whether the asset was added, removed, or
   * remained present during the compare_duration period of time that precedes
   * the read_time. This is the time between (read_time - compare_duration) and
   * read_time.
   *
   * The state_change value is derived based on the presence of the asset at the
   * two points in time. Intermediate state changes between the two times don't
   * affect the result. For example, the results aren't affected if the asset is
   * removed and re-created again.
   *
   * Possible "state_change" values when compare_duration is specified:
   *
   * * "ADDED":   indicates that the asset was not present at the start of
   *                compare_duration, but present at read_time.
   * * "REMOVED": indicates that the asset was present at the start of
   *                compare_duration, but not present at read_time.
   * * "ACTIVE":  indicates that the asset was present at both the
   *                start and the end of the time period defined by
   *                compare_duration and read_time.
   *
   * If compare_duration is not specified, then the only possible state_change
   * is "UNUSED",  which will be the state_change set for all assets present at
   * read_time.
   * </pre>
   *
   * <code>.google.protobuf.Duration compare_duration = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getCompareDurationOrBuilder() {
    return compareDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : compareDuration_;
  }

  public static final int FIELD_MASK_FIELD_NUMBER = 7;
  private com.google.protobuf.FieldMask fieldMask_;
  /**
   *
   *
   * <pre>
   * A field mask to specify the ListAssetsResult fields to be listed in the
   * response.
   * An empty field mask will list all fields.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 7;</code>
   *
   * @return Whether the fieldMask field is set.
   */
  @java.lang.Override
  public boolean hasFieldMask() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * A field mask to specify the ListAssetsResult fields to be listed in the
   * response.
   * An empty field mask will list all fields.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 7;</code>
   *
   * @return The fieldMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getFieldMask() {
    return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
  }
  /**
   *
   *
   * <pre>
   * A field mask to specify the ListAssetsResult fields to be listed in the
   * response.
   * An empty field mask will list all fields.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
    return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * The value returned by the last `ListAssetsResponse`; indicates
   * that this is a continuation of a prior `ListAssets` call, and
   * that the system should return the next page of data.
   * </pre>
   *
   * <code>string page_token = 8;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The value returned by the last `ListAssetsResponse`; indicates
   * that this is a continuation of a prior `ListAssets` call, and
   * that the system should return the next page of data.
   * </pre>
   *
   * <code>string page_token = 8;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 9;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * The maximum number of results to return in a single response. Default is
   * 10, minimum is 1, maximum is 1000.
   * </pre>
   *
   * <code>int32 page_size = 9;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, orderBy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getReadTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getCompareDuration());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getFieldMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, pageToken_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(9, pageSize_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, orderBy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getReadTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCompareDuration());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getFieldMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, pageToken_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, pageSize_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.ListAssetsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.ListAssetsRequest other =
        (com.google.cloud.securitycenter.v1.ListAssetsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (hasCompareDuration() != other.hasCompareDuration()) return false;
    if (hasCompareDuration()) {
      if (!getCompareDuration().equals(other.getCompareDuration())) return false;
    }
    if (hasFieldMask() != other.hasFieldMask()) return false;
    if (hasFieldMask()) {
      if (!getFieldMask().equals(other.getFieldMask())) return false;
    }
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    if (hasCompareDuration()) {
      hash = (37 * hash) + COMPARE_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getCompareDuration().hashCode();
    }
    if (hasFieldMask()) {
      hash = (37 * hash) + FIELD_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getFieldMask().hashCode();
    }
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.ListAssetsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for listing assets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.ListAssetsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.ListAssetsRequest)
      com.google.cloud.securitycenter.v1.ListAssetsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_ListAssetsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_ListAssetsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.ListAssetsRequest.class,
              com.google.cloud.securitycenter.v1.ListAssetsRequest.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.ListAssetsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReadTimeFieldBuilder();
        getCompareDurationFieldBuilder();
        getFieldMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      filter_ = "";
      orderBy_ = "";
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      compareDuration_ = null;
      if (compareDurationBuilder_ != null) {
        compareDurationBuilder_.dispose();
        compareDurationBuilder_ = null;
      }
      fieldMask_ = null;
      if (fieldMaskBuilder_ != null) {
        fieldMaskBuilder_.dispose();
        fieldMaskBuilder_ = null;
      }
      pageToken_ = "";
      pageSize_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_ListAssetsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListAssetsRequest getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.ListAssetsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListAssetsRequest build() {
      com.google.cloud.securitycenter.v1.ListAssetsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.ListAssetsRequest buildPartial() {
      com.google.cloud.securitycenter.v1.ListAssetsRequest result =
          new com.google.cloud.securitycenter.v1.ListAssetsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.ListAssetsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.orderBy_ = orderBy_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.readTime_ = readTimeBuilder_ == null ? readTime_ : readTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.compareDuration_ =
            compareDurationBuilder_ == null ? compareDuration_ : compareDurationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.fieldMask_ = fieldMaskBuilder_ == null ? fieldMask_ : fieldMaskBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.pageSize_ = pageSize_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.ListAssetsRequest) {
        return mergeFrom((com.google.cloud.securitycenter.v1.ListAssetsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.ListAssetsRequest other) {
      if (other == com.google.cloud.securitycenter.v1.ListAssetsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      if (other.hasCompareDuration()) {
        mergeCompareDuration(other.getCompareDuration());
      }
      if (other.hasFieldMask()) {
        mergeFieldMask(other.getFieldMask());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                orderBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCompareDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getFieldMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 72:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the parent resource that contains the assets. The
     * value that you can specify on parent depends on the method in which you
     * specify parent. You can specify one of the following values:
     * "organizations/[organization_id]", "folders/[folder_id]", or
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the parent resource that contains the assets. The
     * value that you can specify on parent depends on the method in which you
     * specify parent. You can specify one of the following values:
     * "organizations/[organization_id]", "folders/[folder_id]", or
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the parent resource that contains the assets. The
     * value that you can specify on parent depends on the method in which you
     * specify parent. You can specify one of the following values:
     * "organizations/[organization_id]", "folders/[folder_id]", or
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the parent resource that contains the assets. The
     * value that you can specify on parent depends on the method in which you
     * specify parent. You can specify one of the following values:
     * "organizations/[organization_id]", "folders/[folder_id]", or
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the parent resource that contains the assets. The
     * value that you can specify on parent depends on the method in which you
     * specify parent. You can specify one of the following values:
     * "organizations/[organization_id]", "folders/[folder_id]", or
     * "projects/[project_id]".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Expression that defines the filter to apply across assets.
     * The expression is a list of zero or more restrictions combined via logical
     * operators `AND` and `OR`.
     * Parentheses are supported, and `OR` has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a `-`
     * character in front of them to indicate negation. The fields map to those
     * defined in the Asset resource. Examples include:
     *
     * * name
     * * security_center_properties.resource_name
     * * resource_properties.a_property
     * * security_marks.marks.marka
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     *
     * The following are the allowed field and operator combinations:
     *
     * * name: `=`
     * * update_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `update_time = "2019-06-10T16:07:18-07:00"`
     *     `update_time = 1560208038000`
     *
     * * create_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `create_time = "2019-06-10T16:07:18-07:00"`
     *     `create_time = 1560208038000`
     *
     * * iam_policy.policy_blob: `=`, `:`
     * * resource_properties: `=`, `:`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     * * security_marks.marks: `=`, `:`
     * * security_center_properties.resource_name: `=`, `:`
     * * security_center_properties.resource_display_name: `=`, `:`
     * * security_center_properties.resource_type: `=`, `:`
     * * security_center_properties.resource_parent: `=`, `:`
     * * security_center_properties.resource_parent_display_name: `=`, `:`
     * * security_center_properties.resource_project: `=`, `:`
     * * security_center_properties.resource_project_display_name: `=`, `:`
     * * security_center_properties.resource_owners: `=`, `:`
     *
     * For example, `resource_properties.size = 100` is a valid filter string.
     *
     * Use a partial match on the empty string to filter based on a property
     * existing: `resource_properties.my_property : ""`
     *
     * Use a negated partial match on the empty string to filter based on a
     * property not existing: `-resource_properties.my_property : ""`
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Expression that defines the filter to apply across assets.
     * The expression is a list of zero or more restrictions combined via logical
     * operators `AND` and `OR`.
     * Parentheses are supported, and `OR` has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a `-`
     * character in front of them to indicate negation. The fields map to those
     * defined in the Asset resource. Examples include:
     *
     * * name
     * * security_center_properties.resource_name
     * * resource_properties.a_property
     * * security_marks.marks.marka
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     *
     * The following are the allowed field and operator combinations:
     *
     * * name: `=`
     * * update_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `update_time = "2019-06-10T16:07:18-07:00"`
     *     `update_time = 1560208038000`
     *
     * * create_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `create_time = "2019-06-10T16:07:18-07:00"`
     *     `create_time = 1560208038000`
     *
     * * iam_policy.policy_blob: `=`, `:`
     * * resource_properties: `=`, `:`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     * * security_marks.marks: `=`, `:`
     * * security_center_properties.resource_name: `=`, `:`
     * * security_center_properties.resource_display_name: `=`, `:`
     * * security_center_properties.resource_type: `=`, `:`
     * * security_center_properties.resource_parent: `=`, `:`
     * * security_center_properties.resource_parent_display_name: `=`, `:`
     * * security_center_properties.resource_project: `=`, `:`
     * * security_center_properties.resource_project_display_name: `=`, `:`
     * * security_center_properties.resource_owners: `=`, `:`
     *
     * For example, `resource_properties.size = 100` is a valid filter string.
     *
     * Use a partial match on the empty string to filter based on a property
     * existing: `resource_properties.my_property : ""`
     *
     * Use a negated partial match on the empty string to filter based on a
     * property not existing: `-resource_properties.my_property : ""`
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Expression that defines the filter to apply across assets.
     * The expression is a list of zero or more restrictions combined via logical
     * operators `AND` and `OR`.
     * Parentheses are supported, and `OR` has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a `-`
     * character in front of them to indicate negation. The fields map to those
     * defined in the Asset resource. Examples include:
     *
     * * name
     * * security_center_properties.resource_name
     * * resource_properties.a_property
     * * security_marks.marks.marka
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     *
     * The following are the allowed field and operator combinations:
     *
     * * name: `=`
     * * update_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `update_time = "2019-06-10T16:07:18-07:00"`
     *     `update_time = 1560208038000`
     *
     * * create_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `create_time = "2019-06-10T16:07:18-07:00"`
     *     `create_time = 1560208038000`
     *
     * * iam_policy.policy_blob: `=`, `:`
     * * resource_properties: `=`, `:`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     * * security_marks.marks: `=`, `:`
     * * security_center_properties.resource_name: `=`, `:`
     * * security_center_properties.resource_display_name: `=`, `:`
     * * security_center_properties.resource_type: `=`, `:`
     * * security_center_properties.resource_parent: `=`, `:`
     * * security_center_properties.resource_parent_display_name: `=`, `:`
     * * security_center_properties.resource_project: `=`, `:`
     * * security_center_properties.resource_project_display_name: `=`, `:`
     * * security_center_properties.resource_owners: `=`, `:`
     *
     * For example, `resource_properties.size = 100` is a valid filter string.
     *
     * Use a partial match on the empty string to filter based on a property
     * existing: `resource_properties.my_property : ""`
     *
     * Use a negated partial match on the empty string to filter based on a
     * property not existing: `-resource_properties.my_property : ""`
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that defines the filter to apply across assets.
     * The expression is a list of zero or more restrictions combined via logical
     * operators `AND` and `OR`.
     * Parentheses are supported, and `OR` has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a `-`
     * character in front of them to indicate negation. The fields map to those
     * defined in the Asset resource. Examples include:
     *
     * * name
     * * security_center_properties.resource_name
     * * resource_properties.a_property
     * * security_marks.marks.marka
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     *
     * The following are the allowed field and operator combinations:
     *
     * * name: `=`
     * * update_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `update_time = "2019-06-10T16:07:18-07:00"`
     *     `update_time = 1560208038000`
     *
     * * create_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `create_time = "2019-06-10T16:07:18-07:00"`
     *     `create_time = 1560208038000`
     *
     * * iam_policy.policy_blob: `=`, `:`
     * * resource_properties: `=`, `:`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     * * security_marks.marks: `=`, `:`
     * * security_center_properties.resource_name: `=`, `:`
     * * security_center_properties.resource_display_name: `=`, `:`
     * * security_center_properties.resource_type: `=`, `:`
     * * security_center_properties.resource_parent: `=`, `:`
     * * security_center_properties.resource_parent_display_name: `=`, `:`
     * * security_center_properties.resource_project: `=`, `:`
     * * security_center_properties.resource_project_display_name: `=`, `:`
     * * security_center_properties.resource_owners: `=`, `:`
     *
     * For example, `resource_properties.size = 100` is a valid filter string.
     *
     * Use a partial match on the empty string to filter based on a property
     * existing: `resource_properties.my_property : ""`
     *
     * Use a negated partial match on the empty string to filter based on a
     * property not existing: `-resource_properties.my_property : ""`
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that defines the filter to apply across assets.
     * The expression is a list of zero or more restrictions combined via logical
     * operators `AND` and `OR`.
     * Parentheses are supported, and `OR` has higher precedence than `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a `-`
     * character in front of them to indicate negation. The fields map to those
     * defined in the Asset resource. Examples include:
     *
     * * name
     * * security_center_properties.resource_name
     * * resource_properties.a_property
     * * security_marks.marks.marka
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     *
     * The following are the allowed field and operator combinations:
     *
     * * name: `=`
     * * update_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `update_time = "2019-06-10T16:07:18-07:00"`
     *     `update_time = 1560208038000`
     *
     * * create_time: `=`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     *
     *   Usage: This should be milliseconds since epoch or an RFC3339 string.
     *   Examples:
     *     `create_time = "2019-06-10T16:07:18-07:00"`
     *     `create_time = 1560208038000`
     *
     * * iam_policy.policy_blob: `=`, `:`
     * * resource_properties: `=`, `:`, `&gt;`, `&lt;`, `&gt;=`, `&lt;=`
     * * security_marks.marks: `=`, `:`
     * * security_center_properties.resource_name: `=`, `:`
     * * security_center_properties.resource_display_name: `=`, `:`
     * * security_center_properties.resource_type: `=`, `:`
     * * security_center_properties.resource_parent: `=`, `:`
     * * security_center_properties.resource_parent_display_name: `=`, `:`
     * * security_center_properties.resource_project: `=`, `:`
     * * security_center_properties.resource_project_display_name: `=`, `:`
     * * security_center_properties.resource_owners: `=`, `:`
     *
     * For example, `resource_properties.size = 100` is a valid filter string.
     *
     * Use a partial match on the empty string to filter based on a property
     * existing: `resource_properties.my_property : ""`
     *
     * Use a negated partial match on the empty string to filter based on a
     * property not existing: `-resource_properties.my_property : ""`
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object orderBy_ = "";
    /**
     *
     *
     * <pre>
     * Expression that defines what fields and order to use for sorting. The
     * string value should follow SQL syntax: comma separated list of fields. For
     * example: "name,resource_properties.a_property". The default sorting order
     * is ascending. To specify descending order for a field, a suffix " desc"
     * should be appended to the field name. For example: "name
     * desc,resource_properties.a_property". Redundant space characters in the
     * syntax are insignificant. "name desc,resource_properties.a_property" and "
     * name     desc  ,   resource_properties.a_property  " are equivalent.
     *
     * The following fields are supported:
     * name
     * update_time
     * resource_properties
     * security_marks.marks
     * security_center_properties.resource_name
     * security_center_properties.resource_display_name
     * security_center_properties.resource_parent
     * security_center_properties.resource_parent_display_name
     * security_center_properties.resource_project
     * security_center_properties.resource_project_display_name
     * security_center_properties.resource_type
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @return The orderBy.
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Expression that defines what fields and order to use for sorting. The
     * string value should follow SQL syntax: comma separated list of fields. For
     * example: "name,resource_properties.a_property". The default sorting order
     * is ascending. To specify descending order for a field, a suffix " desc"
     * should be appended to the field name. For example: "name
     * desc,resource_properties.a_property". Redundant space characters in the
     * syntax are insignificant. "name desc,resource_properties.a_property" and "
     * name     desc  ,   resource_properties.a_property  " are equivalent.
     *
     * The following fields are supported:
     * name
     * update_time
     * resource_properties
     * security_marks.marks
     * security_center_properties.resource_name
     * security_center_properties.resource_display_name
     * security_center_properties.resource_parent
     * security_center_properties.resource_parent_display_name
     * security_center_properties.resource_project
     * security_center_properties.resource_project_display_name
     * security_center_properties.resource_type
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @return The bytes for orderBy.
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Expression that defines what fields and order to use for sorting. The
     * string value should follow SQL syntax: comma separated list of fields. For
     * example: "name,resource_properties.a_property". The default sorting order
     * is ascending. To specify descending order for a field, a suffix " desc"
     * should be appended to the field name. For example: "name
     * desc,resource_properties.a_property". Redundant space characters in the
     * syntax are insignificant. "name desc,resource_properties.a_property" and "
     * name     desc  ,   resource_properties.a_property  " are equivalent.
     *
     * The following fields are supported:
     * name
     * update_time
     * resource_properties
     * security_marks.marks
     * security_center_properties.resource_name
     * security_center_properties.resource_display_name
     * security_center_properties.resource_parent
     * security_center_properties.resource_parent_display_name
     * security_center_properties.resource_project
     * security_center_properties.resource_project_display_name
     * security_center_properties.resource_type
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      orderBy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that defines what fields and order to use for sorting. The
     * string value should follow SQL syntax: comma separated list of fields. For
     * example: "name,resource_properties.a_property". The default sorting order
     * is ascending. To specify descending order for a field, a suffix " desc"
     * should be appended to the field name. For example: "name
     * desc,resource_properties.a_property". Redundant space characters in the
     * syntax are insignificant. "name desc,resource_properties.a_property" and "
     * name     desc  ,   resource_properties.a_property  " are equivalent.
     *
     * The following fields are supported:
     * name
     * update_time
     * resource_properties
     * security_marks.marks
     * security_center_properties.resource_name
     * security_center_properties.resource_display_name
     * security_center_properties.resource_parent
     * security_center_properties.resource_parent_display_name
     * security_center_properties.resource_project
     * security_center_properties.resource_project_display_name
     * security_center_properties.resource_type
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderBy() {
      orderBy_ = getDefaultInstance().getOrderBy();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that defines what fields and order to use for sorting. The
     * string value should follow SQL syntax: comma separated list of fields. For
     * example: "name,resource_properties.a_property". The default sorting order
     * is ascending. To specify descending order for a field, a suffix " desc"
     * should be appended to the field name. For example: "name
     * desc,resource_properties.a_property". Redundant space characters in the
     * syntax are insignificant. "name desc,resource_properties.a_property" and "
     * name     desc  ,   resource_properties.a_property  " are equivalent.
     *
     * The following fields are supported:
     * name
     * update_time
     * resource_properties
     * security_marks.marks
     * security_center_properties.resource_name
     * security_center_properties.resource_display_name
     * security_center_properties.resource_parent
     * security_center_properties.resource_parent_display_name
     * security_center_properties.resource_project
     * security_center_properties.resource_project_display_name
     * security_center_properties.resource_type
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      orderBy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time used as a reference point when filtering assets. The filter is limited
     * to assets existing at the supplied time and their values are those at that
     * specific time. Absence of this field will default to the API's version of
     * NOW.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time used as a reference point when filtering assets. The filter is limited
     * to assets existing at the supplied time and their values are those at that
     * specific time. Absence of this field will default to the API's version of
     * NOW.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time used as a reference point when filtering assets. The filter is limited
     * to assets existing at the supplied time and their values are those at that
     * specific time. Absence of this field will default to the API's version of
     * NOW.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
      } else {
        readTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used as a reference point when filtering assets. The filter is limited
     * to assets existing at the supplied time and their values are those at that
     * specific time. Absence of this field will default to the API's version of
     * NOW.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used as a reference point when filtering assets. The filter is limited
     * to assets existing at the supplied time and their values are those at that
     * specific time. Absence of this field will default to the API's version of
     * NOW.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && readTime_ != null
            && readTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getReadTimeBuilder().mergeFrom(value);
        } else {
          readTime_ = value;
        }
      } else {
        readTimeBuilder_.mergeFrom(value);
      }
      if (readTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used as a reference point when filtering assets. The filter is limited
     * to assets existing at the supplied time and their values are those at that
     * specific time. Absence of this field will default to the API's version of
     * NOW.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder clearReadTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used as a reference point when filtering assets. The filter is limited
     * to assets existing at the supplied time and their values are those at that
     * specific time. Absence of this field will default to the API's version of
     * NOW.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time used as a reference point when filtering assets. The filter is limited
     * to assets existing at the supplied time and their values are those at that
     * specific time. Absence of this field will default to the API's version of
     * NOW.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time used as a reference point when filtering assets. The filter is limited
     * to assets existing at the supplied time and their values are those at that
     * specific time. Absence of this field will default to the API's version of
     * NOW.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    private com.google.protobuf.Duration compareDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        compareDurationBuilder_;
    /**
     *
     *
     * <pre>
     * When compare_duration is set, the ListAssetsResult's "state_change"
     * attribute is updated to indicate whether the asset was added, removed, or
     * remained present during the compare_duration period of time that precedes
     * the read_time. This is the time between (read_time - compare_duration) and
     * read_time.
     *
     * The state_change value is derived based on the presence of the asset at the
     * two points in time. Intermediate state changes between the two times don't
     * affect the result. For example, the results aren't affected if the asset is
     * removed and re-created again.
     *
     * Possible "state_change" values when compare_duration is specified:
     *
     * * "ADDED":   indicates that the asset was not present at the start of
     *                compare_duration, but present at read_time.
     * * "REMOVED": indicates that the asset was present at the start of
     *                compare_duration, but not present at read_time.
     * * "ACTIVE":  indicates that the asset was present at both the
     *                start and the end of the time period defined by
     *                compare_duration and read_time.
     *
     * If compare_duration is not specified, then the only possible state_change
     * is "UNUSED",  which will be the state_change set for all assets present at
     * read_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration compare_duration = 5;</code>
     *
     * @return Whether the compareDuration field is set.
     */
    public boolean hasCompareDuration() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * When compare_duration is set, the ListAssetsResult's "state_change"
     * attribute is updated to indicate whether the asset was added, removed, or
     * remained present during the compare_duration period of time that precedes
     * the read_time. This is the time between (read_time - compare_duration) and
     * read_time.
     *
     * The state_change value is derived based on the presence of the asset at the
     * two points in time. Intermediate state changes between the two times don't
     * affect the result. For example, the results aren't affected if the asset is
     * removed and re-created again.
     *
     * Possible "state_change" values when compare_duration is specified:
     *
     * * "ADDED":   indicates that the asset was not present at the start of
     *                compare_duration, but present at read_time.
     * * "REMOVED": indicates that the asset was present at the start of
     *                compare_duration, but not present at read_time.
     * * "ACTIVE":  indicates that the asset was present at both the
     *                start and the end of the time period defined by
     *                compare_duration and read_time.
     *
     * If compare_duration is not specified, then the only possible state_change
     * is "UNUSED",  which will be the state_change set for all assets present at
     * read_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration compare_duration = 5;</code>
     *
     * @return The compareDuration.
     */
    public com.google.protobuf.Duration getCompareDuration() {
      if (compareDurationBuilder_ == null) {
        return compareDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : compareDuration_;
      } else {
        return compareDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * When compare_duration is set, the ListAssetsResult's "state_change"
     * attribute is updated to indicate whether the asset was added, removed, or
     * remained present during the compare_duration period of time that precedes
     * the read_time. This is the time between (read_time - compare_duration) and
     * read_time.
     *
     * The state_change value is derived based on the presence of the asset at the
     * two points in time. Intermediate state changes between the two times don't
     * affect the result. For example, the results aren't affected if the asset is
     * removed and re-created again.
     *
     * Possible "state_change" values when compare_duration is specified:
     *
     * * "ADDED":   indicates that the asset was not present at the start of
     *                compare_duration, but present at read_time.
     * * "REMOVED": indicates that the asset was present at the start of
     *                compare_duration, but not present at read_time.
     * * "ACTIVE":  indicates that the asset was present at both the
     *                start and the end of the time period defined by
     *                compare_duration and read_time.
     *
     * If compare_duration is not specified, then the only possible state_change
     * is "UNUSED",  which will be the state_change set for all assets present at
     * read_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration compare_duration = 5;</code>
     */
    public Builder setCompareDuration(com.google.protobuf.Duration value) {
      if (compareDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compareDuration_ = value;
      } else {
        compareDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When compare_duration is set, the ListAssetsResult's "state_change"
     * attribute is updated to indicate whether the asset was added, removed, or
     * remained present during the compare_duration period of time that precedes
     * the read_time. This is the time between (read_time - compare_duration) and
     * read_time.
     *
     * The state_change value is derived based on the presence of the asset at the
     * two points in time. Intermediate state changes between the two times don't
     * affect the result. For example, the results aren't affected if the asset is
     * removed and re-created again.
     *
     * Possible "state_change" values when compare_duration is specified:
     *
     * * "ADDED":   indicates that the asset was not present at the start of
     *                compare_duration, but present at read_time.
     * * "REMOVED": indicates that the asset was present at the start of
     *                compare_duration, but not present at read_time.
     * * "ACTIVE":  indicates that the asset was present at both the
     *                start and the end of the time period defined by
     *                compare_duration and read_time.
     *
     * If compare_duration is not specified, then the only possible state_change
     * is "UNUSED",  which will be the state_change set for all assets present at
     * read_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration compare_duration = 5;</code>
     */
    public Builder setCompareDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (compareDurationBuilder_ == null) {
        compareDuration_ = builderForValue.build();
      } else {
        compareDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When compare_duration is set, the ListAssetsResult's "state_change"
     * attribute is updated to indicate whether the asset was added, removed, or
     * remained present during the compare_duration period of time that precedes
     * the read_time. This is the time between (read_time - compare_duration) and
     * read_time.
     *
     * The state_change value is derived based on the presence of the asset at the
     * two points in time. Intermediate state changes between the two times don't
     * affect the result. For example, the results aren't affected if the asset is
     * removed and re-created again.
     *
     * Possible "state_change" values when compare_duration is specified:
     *
     * * "ADDED":   indicates that the asset was not present at the start of
     *                compare_duration, but present at read_time.
     * * "REMOVED": indicates that the asset was present at the start of
     *                compare_duration, but not present at read_time.
     * * "ACTIVE":  indicates that the asset was present at both the
     *                start and the end of the time period defined by
     *                compare_duration and read_time.
     *
     * If compare_duration is not specified, then the only possible state_change
     * is "UNUSED",  which will be the state_change set for all assets present at
     * read_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration compare_duration = 5;</code>
     */
    public Builder mergeCompareDuration(com.google.protobuf.Duration value) {
      if (compareDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && compareDuration_ != null
            && compareDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getCompareDurationBuilder().mergeFrom(value);
        } else {
          compareDuration_ = value;
        }
      } else {
        compareDurationBuilder_.mergeFrom(value);
      }
      if (compareDuration_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When compare_duration is set, the ListAssetsResult's "state_change"
     * attribute is updated to indicate whether the asset was added, removed, or
     * remained present during the compare_duration period of time that precedes
     * the read_time. This is the time between (read_time - compare_duration) and
     * read_time.
     *
     * The state_change value is derived based on the presence of the asset at the
     * two points in time. Intermediate state changes between the two times don't
     * affect the result. For example, the results aren't affected if the asset is
     * removed and re-created again.
     *
     * Possible "state_change" values when compare_duration is specified:
     *
     * * "ADDED":   indicates that the asset was not present at the start of
     *                compare_duration, but present at read_time.
     * * "REMOVED": indicates that the asset was present at the start of
     *                compare_duration, but not present at read_time.
     * * "ACTIVE":  indicates that the asset was present at both the
     *                start and the end of the time period defined by
     *                compare_duration and read_time.
     *
     * If compare_duration is not specified, then the only possible state_change
     * is "UNUSED",  which will be the state_change set for all assets present at
     * read_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration compare_duration = 5;</code>
     */
    public Builder clearCompareDuration() {
      bitField0_ = (bitField0_ & ~0x00000010);
      compareDuration_ = null;
      if (compareDurationBuilder_ != null) {
        compareDurationBuilder_.dispose();
        compareDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When compare_duration is set, the ListAssetsResult's "state_change"
     * attribute is updated to indicate whether the asset was added, removed, or
     * remained present during the compare_duration period of time that precedes
     * the read_time. This is the time between (read_time - compare_duration) and
     * read_time.
     *
     * The state_change value is derived based on the presence of the asset at the
     * two points in time. Intermediate state changes between the two times don't
     * affect the result. For example, the results aren't affected if the asset is
     * removed and re-created again.
     *
     * Possible "state_change" values when compare_duration is specified:
     *
     * * "ADDED":   indicates that the asset was not present at the start of
     *                compare_duration, but present at read_time.
     * * "REMOVED": indicates that the asset was present at the start of
     *                compare_duration, but not present at read_time.
     * * "ACTIVE":  indicates that the asset was present at both the
     *                start and the end of the time period defined by
     *                compare_duration and read_time.
     *
     * If compare_duration is not specified, then the only possible state_change
     * is "UNUSED",  which will be the state_change set for all assets present at
     * read_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration compare_duration = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getCompareDurationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCompareDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * When compare_duration is set, the ListAssetsResult's "state_change"
     * attribute is updated to indicate whether the asset was added, removed, or
     * remained present during the compare_duration period of time that precedes
     * the read_time. This is the time between (read_time - compare_duration) and
     * read_time.
     *
     * The state_change value is derived based on the presence of the asset at the
     * two points in time. Intermediate state changes between the two times don't
     * affect the result. For example, the results aren't affected if the asset is
     * removed and re-created again.
     *
     * Possible "state_change" values when compare_duration is specified:
     *
     * * "ADDED":   indicates that the asset was not present at the start of
     *                compare_duration, but present at read_time.
     * * "REMOVED": indicates that the asset was present at the start of
     *                compare_duration, but not present at read_time.
     * * "ACTIVE":  indicates that the asset was present at both the
     *                start and the end of the time period defined by
     *                compare_duration and read_time.
     *
     * If compare_duration is not specified, then the only possible state_change
     * is "UNUSED",  which will be the state_change set for all assets present at
     * read_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration compare_duration = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getCompareDurationOrBuilder() {
      if (compareDurationBuilder_ != null) {
        return compareDurationBuilder_.getMessageOrBuilder();
      } else {
        return compareDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : compareDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * When compare_duration is set, the ListAssetsResult's "state_change"
     * attribute is updated to indicate whether the asset was added, removed, or
     * remained present during the compare_duration period of time that precedes
     * the read_time. This is the time between (read_time - compare_duration) and
     * read_time.
     *
     * The state_change value is derived based on the presence of the asset at the
     * two points in time. Intermediate state changes between the two times don't
     * affect the result. For example, the results aren't affected if the asset is
     * removed and re-created again.
     *
     * Possible "state_change" values when compare_duration is specified:
     *
     * * "ADDED":   indicates that the asset was not present at the start of
     *                compare_duration, but present at read_time.
     * * "REMOVED": indicates that the asset was present at the start of
     *                compare_duration, but not present at read_time.
     * * "ACTIVE":  indicates that the asset was present at both the
     *                start and the end of the time period defined by
     *                compare_duration and read_time.
     *
     * If compare_duration is not specified, then the only possible state_change
     * is "UNUSED",  which will be the state_change set for all assets present at
     * read_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration compare_duration = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getCompareDurationFieldBuilder() {
      if (compareDurationBuilder_ == null) {
        compareDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getCompareDuration(), getParentForChildren(), isClean());
        compareDuration_ = null;
      }
      return compareDurationBuilder_;
    }

    private com.google.protobuf.FieldMask fieldMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        fieldMaskBuilder_;
    /**
     *
     *
     * <pre>
     * A field mask to specify the ListAssetsResult fields to be listed in the
     * response.
     * An empty field mask will list all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 7;</code>
     *
     * @return Whether the fieldMask field is set.
     */
    public boolean hasFieldMask() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * A field mask to specify the ListAssetsResult fields to be listed in the
     * response.
     * An empty field mask will list all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 7;</code>
     *
     * @return The fieldMask.
     */
    public com.google.protobuf.FieldMask getFieldMask() {
      if (fieldMaskBuilder_ == null) {
        return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
      } else {
        return fieldMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A field mask to specify the ListAssetsResult fields to be listed in the
     * response.
     * An empty field mask will list all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 7;</code>
     */
    public Builder setFieldMask(com.google.protobuf.FieldMask value) {
      if (fieldMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fieldMask_ = value;
      } else {
        fieldMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A field mask to specify the ListAssetsResult fields to be listed in the
     * response.
     * An empty field mask will list all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 7;</code>
     */
    public Builder setFieldMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (fieldMaskBuilder_ == null) {
        fieldMask_ = builderForValue.build();
      } else {
        fieldMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A field mask to specify the ListAssetsResult fields to be listed in the
     * response.
     * An empty field mask will list all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 7;</code>
     */
    public Builder mergeFieldMask(com.google.protobuf.FieldMask value) {
      if (fieldMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && fieldMask_ != null
            && fieldMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getFieldMaskBuilder().mergeFrom(value);
        } else {
          fieldMask_ = value;
        }
      } else {
        fieldMaskBuilder_.mergeFrom(value);
      }
      if (fieldMask_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A field mask to specify the ListAssetsResult fields to be listed in the
     * response.
     * An empty field mask will list all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 7;</code>
     */
    public Builder clearFieldMask() {
      bitField0_ = (bitField0_ & ~0x00000020);
      fieldMask_ = null;
      if (fieldMaskBuilder_ != null) {
        fieldMaskBuilder_.dispose();
        fieldMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A field mask to specify the ListAssetsResult fields to be listed in the
     * response.
     * An empty field mask will list all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 7;</code>
     */
    public com.google.protobuf.FieldMask.Builder getFieldMaskBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getFieldMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A field mask to specify the ListAssetsResult fields to be listed in the
     * response.
     * An empty field mask will list all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 7;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
      if (fieldMaskBuilder_ != null) {
        return fieldMaskBuilder_.getMessageOrBuilder();
      } else {
        return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * A field mask to specify the ListAssetsResult fields to be listed in the
     * response.
     * An empty field mask will list all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getFieldMaskFieldBuilder() {
      if (fieldMaskBuilder_ == null) {
        fieldMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getFieldMask(), getParentForChildren(), isClean());
        fieldMask_ = null;
      }
      return fieldMaskBuilder_;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * The value returned by the last `ListAssetsResponse`; indicates
     * that this is a continuation of a prior `ListAssets` call, and
     * that the system should return the next page of data.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value returned by the last `ListAssetsResponse`; indicates
     * that this is a continuation of a prior `ListAssets` call, and
     * that the system should return the next page of data.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value returned by the last `ListAssetsResponse`; indicates
     * that this is a continuation of a prior `ListAssets` call, and
     * that the system should return the next page of data.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value returned by the last `ListAssetsResponse`; indicates
     * that this is a continuation of a prior `ListAssets` call, and
     * that the system should return the next page of data.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value returned by the last `ListAssetsResponse`; indicates
     * that this is a continuation of a prior `ListAssets` call, and
     * that the system should return the next page of data.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * The maximum number of results to return in a single response. Default is
     * 10, minimum is 1, maximum is 1000.
     * </pre>
     *
     * <code>int32 page_size = 9;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return in a single response. Default is
     * 10, minimum is 1, maximum is 1000.
     * </pre>
     *
     * <code>int32 page_size = 9;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of results to return in a single response. Default is
     * 10, minimum is 1, maximum is 1000.
     * </pre>
     *
     * <code>int32 page_size = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000080);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.ListAssetsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.ListAssetsRequest)
  private static final com.google.cloud.securitycenter.v1.ListAssetsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.ListAssetsRequest();
  }

  public static com.google.cloud.securitycenter.v1.ListAssetsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListAssetsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListAssetsRequest>() {
        @java.lang.Override
        public ListAssetsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListAssetsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListAssetsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.ListAssetsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
