/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/notification_config.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Cloud Security Command Center (Cloud SCC) notification configs.
 *
 * A notification config is a Cloud SCC resource that contains the configuration
 * to send notifications for create/update events of findings, assets and etc.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.NotificationConfig}
 */
public final class NotificationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.NotificationConfig)
    NotificationConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NotificationConfig.newBuilder() to construct.
  private NotificationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotificationConfig() {
    name_ = "";
    description_ = "";
    pubsubTopic_ = "";
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NotificationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.NotificationConfigProto
        .internal_static_google_cloud_securitycenter_v1_NotificationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.NotificationConfigProto
        .internal_static_google_cloud_securitycenter_v1_NotificationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.NotificationConfig.class,
            com.google.cloud.securitycenter.v1.NotificationConfig.Builder.class);
  }

  public interface StreamingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Expression that defines the filter to apply across create/update events
     * of assets or findings as specified by the event type. The expression is a
     * list of zero or more restrictions combined via logical operators `AND`
     * and `OR`. Parentheses are supported, and `OR` has higher precedence than
     * `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
     * `-` character in front of them to indicate negation. The fields map to
     * those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     * </pre>
     *
     * <code>string filter = 1;</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * Expression that defines the filter to apply across create/update events
     * of assets or findings as specified by the event type. The expression is a
     * list of zero or more restrictions combined via logical operators `AND`
     * and `OR`. Parentheses are supported, and `OR` has higher precedence than
     * `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
     * `-` character in front of them to indicate negation. The fields map to
     * those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     * </pre>
     *
     * <code>string filter = 1;</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();
  }
  /**
   *
   *
   * <pre>
   * The config for streaming-based notifications, which send each event as soon
   * as it is detected.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig}
   */
  public static final class StreamingConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
      StreamingConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StreamingConfig.newBuilder() to construct.
    private StreamingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StreamingConfig() {
      filter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StreamingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.NotificationConfigProto
          .internal_static_google_cloud_securitycenter_v1_NotificationConfig_StreamingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.NotificationConfigProto
          .internal_static_google_cloud_securitycenter_v1_NotificationConfig_StreamingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.class,
              com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.Builder.class);
    }

    public static final int FILTER_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Expression that defines the filter to apply across create/update events
     * of assets or findings as specified by the event type. The expression is a
     * list of zero or more restrictions combined via logical operators `AND`
     * and `OR`. Parentheses are supported, and `OR` has higher precedence than
     * `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
     * `-` character in front of them to indicate negation. The fields map to
     * those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     * </pre>
     *
     * <code>string filter = 1;</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Expression that defines the filter to apply across create/update events
     * of assets or findings as specified by the event type. The expression is a
     * list of zero or more restrictions combined via logical operators `AND`
     * and `OR`. Parentheses are supported, and `OR` has higher precedence than
     * `AND`.
     *
     * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
     * `-` character in front of them to indicate negation. The fields map to
     * those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * * `=` for all value types.
     * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
     * * `:`, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * * string literals in quotes.
     * * integer literals without quotes.
     * * boolean literals `true` and `false` without quotes.
     * </pre>
     *
     * <code>string filter = 1;</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filter_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, filter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig other =
          (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig) obj;

      if (!getFilter().equals(other.getFilter())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The config for streaming-based notifications, which send each event as soon
     * as it is detected.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
        com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.NotificationConfigProto
            .internal_static_google_cloud_securitycenter_v1_NotificationConfig_StreamingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.NotificationConfigProto
            .internal_static_google_cloud_securitycenter_v1_NotificationConfig_StreamingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.class,
                com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        filter_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.NotificationConfigProto
            .internal_static_google_cloud_securitycenter_v1_NotificationConfig_StreamingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig build() {
        com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig buildPartial() {
        com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig result =
            new com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.filter_ = filter_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig other) {
        if (other
            == com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
                .getDefaultInstance()) return this;
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Expression that defines the filter to apply across create/update events
       * of assets or findings as specified by the event type. The expression is a
       * list of zero or more restrictions combined via logical operators `AND`
       * and `OR`. Parentheses are supported, and `OR` has higher precedence than
       * `AND`.
       *
       * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
       * `-` character in front of them to indicate negation. The fields map to
       * those defined in the corresponding resource.
       *
       * The supported operators are:
       *
       * * `=` for all value types.
       * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
       * * `:`, meaning substring matching, for strings.
       *
       * The supported value types are:
       *
       * * string literals in quotes.
       * * integer literals without quotes.
       * * boolean literals `true` and `false` without quotes.
       * </pre>
       *
       * <code>string filter = 1;</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Expression that defines the filter to apply across create/update events
       * of assets or findings as specified by the event type. The expression is a
       * list of zero or more restrictions combined via logical operators `AND`
       * and `OR`. Parentheses are supported, and `OR` has higher precedence than
       * `AND`.
       *
       * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
       * `-` character in front of them to indicate negation. The fields map to
       * those defined in the corresponding resource.
       *
       * The supported operators are:
       *
       * * `=` for all value types.
       * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
       * * `:`, meaning substring matching, for strings.
       *
       * The supported value types are:
       *
       * * string literals in quotes.
       * * integer literals without quotes.
       * * boolean literals `true` and `false` without quotes.
       * </pre>
       *
       * <code>string filter = 1;</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Expression that defines the filter to apply across create/update events
       * of assets or findings as specified by the event type. The expression is a
       * list of zero or more restrictions combined via logical operators `AND`
       * and `OR`. Parentheses are supported, and `OR` has higher precedence than
       * `AND`.
       *
       * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
       * `-` character in front of them to indicate negation. The fields map to
       * those defined in the corresponding resource.
       *
       * The supported operators are:
       *
       * * `=` for all value types.
       * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
       * * `:`, meaning substring matching, for strings.
       *
       * The supported value types are:
       *
       * * string literals in quotes.
       * * integer literals without quotes.
       * * boolean literals `true` and `false` without quotes.
       * </pre>
       *
       * <code>string filter = 1;</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Expression that defines the filter to apply across create/update events
       * of assets or findings as specified by the event type. The expression is a
       * list of zero or more restrictions combined via logical operators `AND`
       * and `OR`. Parentheses are supported, and `OR` has higher precedence than
       * `AND`.
       *
       * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
       * `-` character in front of them to indicate negation. The fields map to
       * those defined in the corresponding resource.
       *
       * The supported operators are:
       *
       * * `=` for all value types.
       * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
       * * `:`, meaning substring matching, for strings.
       *
       * The supported value types are:
       *
       * * string literals in quotes.
       * * integer literals without quotes.
       * * boolean literals `true` and `false` without quotes.
       * </pre>
       *
       * <code>string filter = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Expression that defines the filter to apply across create/update events
       * of assets or findings as specified by the event type. The expression is a
       * list of zero or more restrictions combined via logical operators `AND`
       * and `OR`. Parentheses are supported, and `OR` has higher precedence than
       * `AND`.
       *
       * Restrictions have the form `&lt;field&gt; &lt;operator&gt; &lt;value&gt;` and may have a
       * `-` character in front of them to indicate negation. The fields map to
       * those defined in the corresponding resource.
       *
       * The supported operators are:
       *
       * * `=` for all value types.
       * * `&gt;`, `&lt;`, `&gt;=`, `&lt;=` for integer values.
       * * `:`, meaning substring matching, for strings.
       *
       * The supported value types are:
       *
       * * string literals in quotes.
       * * integer literals without quotes.
       * * boolean literals `true` and `false` without quotes.
       * </pre>
       *
       * <code>string filter = 1;</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
    private static final com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig();
    }

    public static com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StreamingConfig> PARSER =
        new com.google.protobuf.AbstractParser<StreamingConfig>() {
          @java.lang.Override
          public StreamingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StreamingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StreamingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int notifyConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object notifyConfig_;

  public enum NotifyConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STREAMING_CONFIG(5),
    NOTIFYCONFIG_NOT_SET(0);
    private final int value;

    private NotifyConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NotifyConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static NotifyConfigCase forNumber(int value) {
      switch (value) {
        case 5:
          return STREAMING_CONFIG;
        case 0:
          return NOTIFYCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public NotifyConfigCase getNotifyConfigCase() {
    return NotifyConfigCase.forNumber(notifyConfigCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The relative resource name of this notification config. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/{organization_id}/notificationConfigs/notify_public_bucket",
   * "folders/{folder_id}/notificationConfigs/notify_public_bucket",
   * or "projects/{project_id}/notificationConfigs/notify_public_bucket".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative resource name of this notification config. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/{organization_id}/notificationConfigs/notify_public_bucket",
   * "folders/{folder_id}/notificationConfigs/notify_public_bucket",
   * or "projects/{project_id}/notificationConfigs/notify_public_bucket".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the notification config (max of 1024 characters).
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the notification config (max of 1024 characters).
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBSUB_TOPIC_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pubsubTopic_ = "";
  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to send notifications to. Its format is
   * "projects/[project_id]/topics/[topic]".
   * </pre>
   *
   * <code>string pubsub_topic = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The pubsubTopic.
   */
  @java.lang.Override
  public java.lang.String getPubsubTopic() {
    java.lang.Object ref = pubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pubsubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Pub/Sub topic to send notifications to. Its format is
   * "projects/[project_id]/topics/[topic]".
   * </pre>
   *
   * <code>string pubsub_topic = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for pubsubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPubsubTopicBytes() {
    java.lang.Object ref = pubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The service account that needs "pubsub.topics.publish"
   * permission to publish to the Pub/Sub topic.
   * </pre>
   *
   * <code>string service_account = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The service account that needs "pubsub.topics.publish"
   * permission to publish to the Pub/Sub topic.
   * </pre>
   *
   * <code>string service_account = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STREAMING_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The config for triggering streaming-based notifications.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
   * </code>
   *
   * @return Whether the streamingConfig field is set.
   */
  @java.lang.Override
  public boolean hasStreamingConfig() {
    return notifyConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The config for triggering streaming-based notifications.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
   * </code>
   *
   * @return The streamingConfig.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
      getStreamingConfig() {
    if (notifyConfigCase_ == 5) {
      return (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig) notifyConfig_;
    }
    return com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The config for triggering streaming-based notifications.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfigOrBuilder
      getStreamingConfigOrBuilder() {
    if (notifyConfigCase_ == 5) {
      return (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig) notifyConfig_;
    }
    return com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubsubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pubsubTopic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, serviceAccount_);
    }
    if (notifyConfigCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig) notifyConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubsubTopic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pubsubTopic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, serviceAccount_);
    }
    if (notifyConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
                  notifyConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.NotificationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.NotificationConfig other =
        (com.google.cloud.securitycenter.v1.NotificationConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getPubsubTopic().equals(other.getPubsubTopic())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getNotifyConfigCase().equals(other.getNotifyConfigCase())) return false;
    switch (notifyConfigCase_) {
      case 5:
        if (!getStreamingConfig().equals(other.getStreamingConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getPubsubTopic().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    switch (notifyConfigCase_) {
      case 5:
        hash = (37 * hash) + STREAMING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getStreamingConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1.NotificationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Cloud Security Command Center (Cloud SCC) notification configs.
   *
   * A notification config is a Cloud SCC resource that contains the configuration
   * to send notifications for create/update events of findings, assets and etc.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.NotificationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.NotificationConfig)
      com.google.cloud.securitycenter.v1.NotificationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.NotificationConfigProto
          .internal_static_google_cloud_securitycenter_v1_NotificationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.NotificationConfigProto
          .internal_static_google_cloud_securitycenter_v1_NotificationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.NotificationConfig.class,
              com.google.cloud.securitycenter.v1.NotificationConfig.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.NotificationConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      pubsubTopic_ = "";
      serviceAccount_ = "";
      if (streamingConfigBuilder_ != null) {
        streamingConfigBuilder_.clear();
      }
      notifyConfigCase_ = 0;
      notifyConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.NotificationConfigProto
          .internal_static_google_cloud_securitycenter_v1_NotificationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.NotificationConfig getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.NotificationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.NotificationConfig build() {
      com.google.cloud.securitycenter.v1.NotificationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.NotificationConfig buildPartial() {
      com.google.cloud.securitycenter.v1.NotificationConfig result =
          new com.google.cloud.securitycenter.v1.NotificationConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.NotificationConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pubsubTopic_ = pubsubTopic_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.securitycenter.v1.NotificationConfig result) {
      result.notifyConfigCase_ = notifyConfigCase_;
      result.notifyConfig_ = this.notifyConfig_;
      if (notifyConfigCase_ == 5 && streamingConfigBuilder_ != null) {
        result.notifyConfig_ = streamingConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.NotificationConfig) {
        return mergeFrom((com.google.cloud.securitycenter.v1.NotificationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.NotificationConfig other) {
      if (other == com.google.cloud.securitycenter.v1.NotificationConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getPubsubTopic().isEmpty()) {
        pubsubTopic_ = other.pubsubTopic_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      switch (other.getNotifyConfigCase()) {
        case STREAMING_CONFIG:
          {
            mergeStreamingConfig(other.getStreamingConfig());
            break;
          }
        case NOTIFYCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                pubsubTopic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getStreamingConfigFieldBuilder().getBuilder(), extensionRegistry);
                notifyConfigCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int notifyConfigCase_ = 0;
    private java.lang.Object notifyConfig_;

    public NotifyConfigCase getNotifyConfigCase() {
      return NotifyConfigCase.forNumber(notifyConfigCase_);
    }

    public Builder clearNotifyConfig() {
      notifyConfigCase_ = 0;
      notifyConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The relative resource name of this notification config. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/notificationConfigs/notify_public_bucket",
     * "folders/{folder_id}/notificationConfigs/notify_public_bucket",
     * or "projects/{project_id}/notificationConfigs/notify_public_bucket".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this notification config. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/notificationConfigs/notify_public_bucket",
     * "folders/{folder_id}/notificationConfigs/notify_public_bucket",
     * or "projects/{project_id}/notificationConfigs/notify_public_bucket".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this notification config. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/notificationConfigs/notify_public_bucket",
     * "folders/{folder_id}/notificationConfigs/notify_public_bucket",
     * or "projects/{project_id}/notificationConfigs/notify_public_bucket".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this notification config. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/notificationConfigs/notify_public_bucket",
     * "folders/{folder_id}/notificationConfigs/notify_public_bucket",
     * or "projects/{project_id}/notificationConfigs/notify_public_bucket".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this notification config. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/notificationConfigs/notify_public_bucket",
     * "folders/{folder_id}/notificationConfigs/notify_public_bucket",
     * or "projects/{project_id}/notificationConfigs/notify_public_bucket".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the notification config (max of 1024 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the notification config (max of 1024 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the notification config (max of 1024 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the notification config (max of 1024 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the notification config (max of 1024 characters).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object pubsubTopic_ = "";
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to send notifications to. Its format is
     * "projects/[project_id]/topics/[topic]".
     * </pre>
     *
     * <code>string pubsub_topic = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The pubsubTopic.
     */
    public java.lang.String getPubsubTopic() {
      java.lang.Object ref = pubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to send notifications to. Its format is
     * "projects/[project_id]/topics/[topic]".
     * </pre>
     *
     * <code>string pubsub_topic = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for pubsubTopic.
     */
    public com.google.protobuf.ByteString getPubsubTopicBytes() {
      java.lang.Object ref = pubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to send notifications to. Its format is
     * "projects/[project_id]/topics/[topic]".
     * </pre>
     *
     * <code>string pubsub_topic = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The pubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pubsubTopic_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to send notifications to. Its format is
     * "projects/[project_id]/topics/[topic]".
     * </pre>
     *
     * <code>string pubsub_topic = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPubsubTopic() {
      pubsubTopic_ = getDefaultInstance().getPubsubTopic();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Pub/Sub topic to send notifications to. Its format is
     * "projects/[project_id]/topics/[topic]".
     * </pre>
     *
     * <code>string pubsub_topic = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for pubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pubsubTopic_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The service account that needs "pubsub.topics.publish"
     * permission to publish to the Pub/Sub topic.
     * </pre>
     *
     * <code>string service_account = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account that needs "pubsub.topics.publish"
     * permission to publish to the Pub/Sub topic.
     * </pre>
     *
     * <code>string service_account = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account that needs "pubsub.topics.publish"
     * permission to publish to the Pub/Sub topic.
     * </pre>
     *
     * <code>string service_account = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account that needs "pubsub.topics.publish"
     * permission to publish to the Pub/Sub topic.
     * </pre>
     *
     * <code>string service_account = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account that needs "pubsub.topics.publish"
     * permission to publish to the Pub/Sub topic.
     * </pre>
     *
     * <code>string service_account = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig,
            com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.Builder,
            com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfigOrBuilder>
        streamingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The config for triggering streaming-based notifications.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
     * </code>
     *
     * @return Whether the streamingConfig field is set.
     */
    @java.lang.Override
    public boolean hasStreamingConfig() {
      return notifyConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The config for triggering streaming-based notifications.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
     * </code>
     *
     * @return The streamingConfig.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
        getStreamingConfig() {
      if (streamingConfigBuilder_ == null) {
        if (notifyConfigCase_ == 5) {
          return (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
              notifyConfig_;
        }
        return com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
            .getDefaultInstance();
      } else {
        if (notifyConfigCase_ == 5) {
          return streamingConfigBuilder_.getMessage();
        }
        return com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The config for triggering streaming-based notifications.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
     * </code>
     */
    public Builder setStreamingConfig(
        com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig value) {
      if (streamingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notifyConfig_ = value;
        onChanged();
      } else {
        streamingConfigBuilder_.setMessage(value);
      }
      notifyConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for triggering streaming-based notifications.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
     * </code>
     */
    public Builder setStreamingConfig(
        com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.Builder
            builderForValue) {
      if (streamingConfigBuilder_ == null) {
        notifyConfig_ = builderForValue.build();
        onChanged();
      } else {
        streamingConfigBuilder_.setMessage(builderForValue.build());
      }
      notifyConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for triggering streaming-based notifications.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
     * </code>
     */
    public Builder mergeStreamingConfig(
        com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig value) {
      if (streamingConfigBuilder_ == null) {
        if (notifyConfigCase_ == 5
            && notifyConfig_
                != com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
                    .getDefaultInstance()) {
          notifyConfig_ =
              com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.newBuilder(
                      (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
                          notifyConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          notifyConfig_ = value;
        }
        onChanged();
      } else {
        if (notifyConfigCase_ == 5) {
          streamingConfigBuilder_.mergeFrom(value);
        } else {
          streamingConfigBuilder_.setMessage(value);
        }
      }
      notifyConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for triggering streaming-based notifications.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
     * </code>
     */
    public Builder clearStreamingConfig() {
      if (streamingConfigBuilder_ == null) {
        if (notifyConfigCase_ == 5) {
          notifyConfigCase_ = 0;
          notifyConfig_ = null;
          onChanged();
        }
      } else {
        if (notifyConfigCase_ == 5) {
          notifyConfigCase_ = 0;
          notifyConfig_ = null;
        }
        streamingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for triggering streaming-based notifications.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.Builder
        getStreamingConfigBuilder() {
      return getStreamingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config for triggering streaming-based notifications.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfigOrBuilder
        getStreamingConfigOrBuilder() {
      if ((notifyConfigCase_ == 5) && (streamingConfigBuilder_ != null)) {
        return streamingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (notifyConfigCase_ == 5) {
          return (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
              notifyConfig_;
        }
        return com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The config for triggering streaming-based notifications.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig streaming_config = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig,
            com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.Builder,
            com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfigOrBuilder>
        getStreamingConfigFieldBuilder() {
      if (streamingConfigBuilder_ == null) {
        if (!(notifyConfigCase_ == 5)) {
          notifyConfig_ =
              com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig
                  .getDefaultInstance();
        }
        streamingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig,
                com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig.Builder,
                com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfigOrBuilder>(
                (com.google.cloud.securitycenter.v1.NotificationConfig.StreamingConfig)
                    notifyConfig_,
                getParentForChildren(),
                isClean());
        notifyConfig_ = null;
      }
      notifyConfigCase_ = 5;
      onChanged();
      return streamingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.NotificationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.NotificationConfig)
  private static final com.google.cloud.securitycenter.v1.NotificationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.NotificationConfig();
  }

  public static com.google.cloud.securitycenter.v1.NotificationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotificationConfig> PARSER =
      new com.google.protobuf.AbstractParser<NotificationConfig>() {
        @java.lang.Override
        public NotificationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NotificationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotificationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.NotificationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
