/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/process.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Represents an operating system process.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Process}
 */
public final class Process extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Process)
    ProcessOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Process.newBuilder() to construct.
  private Process(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Process() {
    name_ = "";
    libraries_ = java.util.Collections.emptyList();
    args_ = com.google.protobuf.LazyStringArrayList.emptyList();
    envVariables_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Process();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.ProcessProto
        .internal_static_google_cloud_securitycenter_v1_Process_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.ProcessProto
        .internal_static_google_cloud_securitycenter_v1_Process_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Process.class,
            com.google.cloud.securitycenter.v1.Process.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The process name, as displayed in utilities like `top` and `ps`. This name
   * can be accessed through `/proc/[pid]/comm` and changed with
   * `prctl(PR_SET_NAME)`.
   * </pre>
   *
   * <code>string name = 12;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The process name, as displayed in utilities like `top` and `ps`. This name
   * can be accessed through `/proc/[pid]/comm` and changed with
   * `prctl(PR_SET_NAME)`.
   * </pre>
   *
   * <code>string name = 12;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BINARY_FIELD_NUMBER = 3;
  private com.google.cloud.securitycenter.v1.File binary_;
  /**
   *
   *
   * <pre>
   * File information for the process executable.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
   *
   * @return Whether the binary field is set.
   */
  @java.lang.Override
  public boolean hasBinary() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * File information for the process executable.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
   *
   * @return The binary.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.File getBinary() {
    return binary_ == null ? com.google.cloud.securitycenter.v1.File.getDefaultInstance() : binary_;
  }
  /**
   *
   *
   * <pre>
   * File information for the process executable.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.FileOrBuilder getBinaryOrBuilder() {
    return binary_ == null ? com.google.cloud.securitycenter.v1.File.getDefaultInstance() : binary_;
  }

  public static final int LIBRARIES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.File> libraries_;
  /**
   *
   *
   * <pre>
   * File information for libraries loaded by the process.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.File> getLibrariesList() {
    return libraries_;
  }
  /**
   *
   *
   * <pre>
   * File information for libraries loaded by the process.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.FileOrBuilder>
      getLibrariesOrBuilderList() {
    return libraries_;
  }
  /**
   *
   *
   * <pre>
   * File information for libraries loaded by the process.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
   */
  @java.lang.Override
  public int getLibrariesCount() {
    return libraries_.size();
  }
  /**
   *
   *
   * <pre>
   * File information for libraries loaded by the process.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.File getLibraries(int index) {
    return libraries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * File information for libraries loaded by the process.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.FileOrBuilder getLibrariesOrBuilder(int index) {
    return libraries_.get(index);
  }

  public static final int SCRIPT_FIELD_NUMBER = 5;
  private com.google.cloud.securitycenter.v1.File script_;
  /**
   *
   *
   * <pre>
   * When the process represents the invocation of a script, `binary` provides
   * information about the interpreter, while `script` provides information
   * about the script file provided to the interpreter.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
   *
   * @return Whether the script field is set.
   */
  @java.lang.Override
  public boolean hasScript() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * When the process represents the invocation of a script, `binary` provides
   * information about the interpreter, while `script` provides information
   * about the script file provided to the interpreter.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
   *
   * @return The script.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.File getScript() {
    return script_ == null ? com.google.cloud.securitycenter.v1.File.getDefaultInstance() : script_;
  }
  /**
   *
   *
   * <pre>
   * When the process represents the invocation of a script, `binary` provides
   * information about the interpreter, while `script` provides information
   * about the script file provided to the interpreter.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.FileOrBuilder getScriptOrBuilder() {
    return script_ == null ? com.google.cloud.securitycenter.v1.File.getDefaultInstance() : script_;
  }

  public static final int ARGS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList args_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Process arguments as JSON encoded strings.
   * </pre>
   *
   * <code>repeated string args = 6;</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }
  /**
   *
   *
   * <pre>
   * Process arguments as JSON encoded strings.
   * </pre>
   *
   * <code>repeated string args = 6;</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }
  /**
   *
   *
   * <pre>
   * Process arguments as JSON encoded strings.
   * </pre>
   *
   * <code>repeated string args = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Process arguments as JSON encoded strings.
   * </pre>
   *
   * <code>repeated string args = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int ARGUMENTS_TRUNCATED_FIELD_NUMBER = 7;
  private boolean argumentsTruncated_ = false;
  /**
   *
   *
   * <pre>
   * True if `args` is incomplete.
   * </pre>
   *
   * <code>bool arguments_truncated = 7;</code>
   *
   * @return The argumentsTruncated.
   */
  @java.lang.Override
  public boolean getArgumentsTruncated() {
    return argumentsTruncated_;
  }

  public static final int ENV_VARIABLES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.EnvironmentVariable> envVariables_;
  /**
   *
   *
   * <pre>
   * Process environment variables.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.EnvironmentVariable>
      getEnvVariablesList() {
    return envVariables_;
  }
  /**
   *
   *
   * <pre>
   * Process environment variables.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securitycenter.v1.EnvironmentVariableOrBuilder>
      getEnvVariablesOrBuilderList() {
    return envVariables_;
  }
  /**
   *
   *
   * <pre>
   * Process environment variables.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
   */
  @java.lang.Override
  public int getEnvVariablesCount() {
    return envVariables_.size();
  }
  /**
   *
   *
   * <pre>
   * Process environment variables.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.EnvironmentVariable getEnvVariables(int index) {
    return envVariables_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Process environment variables.
   * </pre>
   *
   * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.EnvironmentVariableOrBuilder getEnvVariablesOrBuilder(
      int index) {
    return envVariables_.get(index);
  }

  public static final int ENV_VARIABLES_TRUNCATED_FIELD_NUMBER = 9;
  private boolean envVariablesTruncated_ = false;
  /**
   *
   *
   * <pre>
   * True if `env_variables` is incomplete.
   * </pre>
   *
   * <code>bool env_variables_truncated = 9;</code>
   *
   * @return The envVariablesTruncated.
   */
  @java.lang.Override
  public boolean getEnvVariablesTruncated() {
    return envVariablesTruncated_;
  }

  public static final int PID_FIELD_NUMBER = 10;
  private long pid_ = 0L;
  /**
   *
   *
   * <pre>
   * The process ID.
   * </pre>
   *
   * <code>int64 pid = 10;</code>
   *
   * @return The pid.
   */
  @java.lang.Override
  public long getPid() {
    return pid_;
  }

  public static final int PARENT_PID_FIELD_NUMBER = 11;
  private long parentPid_ = 0L;
  /**
   *
   *
   * <pre>
   * The parent process ID.
   * </pre>
   *
   * <code>int64 parent_pid = 11;</code>
   *
   * @return The parentPid.
   */
  @java.lang.Override
  public long getParentPid() {
    return parentPid_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getBinary());
    }
    for (int i = 0; i < libraries_.size(); i++) {
      output.writeMessage(4, libraries_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getScript());
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, args_.getRaw(i));
    }
    if (argumentsTruncated_ != false) {
      output.writeBool(7, argumentsTruncated_);
    }
    for (int i = 0; i < envVariables_.size(); i++) {
      output.writeMessage(8, envVariables_.get(i));
    }
    if (envVariablesTruncated_ != false) {
      output.writeBool(9, envVariablesTruncated_);
    }
    if (pid_ != 0L) {
      output.writeInt64(10, pid_);
    }
    if (parentPid_ != 0L) {
      output.writeInt64(11, parentPid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBinary());
    }
    for (int i = 0; i < libraries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, libraries_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getScript());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    if (argumentsTruncated_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, argumentsTruncated_);
    }
    for (int i = 0; i < envVariables_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, envVariables_.get(i));
    }
    if (envVariablesTruncated_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, envVariablesTruncated_);
    }
    if (pid_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(10, pid_);
    }
    if (parentPid_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, parentPid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Process)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Process other =
        (com.google.cloud.securitycenter.v1.Process) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasBinary() != other.hasBinary()) return false;
    if (hasBinary()) {
      if (!getBinary().equals(other.getBinary())) return false;
    }
    if (!getLibrariesList().equals(other.getLibrariesList())) return false;
    if (hasScript() != other.hasScript()) return false;
    if (hasScript()) {
      if (!getScript().equals(other.getScript())) return false;
    }
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (getArgumentsTruncated() != other.getArgumentsTruncated()) return false;
    if (!getEnvVariablesList().equals(other.getEnvVariablesList())) return false;
    if (getEnvVariablesTruncated() != other.getEnvVariablesTruncated()) return false;
    if (getPid() != other.getPid()) return false;
    if (getParentPid() != other.getParentPid()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasBinary()) {
      hash = (37 * hash) + BINARY_FIELD_NUMBER;
      hash = (53 * hash) + getBinary().hashCode();
    }
    if (getLibrariesCount() > 0) {
      hash = (37 * hash) + LIBRARIES_FIELD_NUMBER;
      hash = (53 * hash) + getLibrariesList().hashCode();
    }
    if (hasScript()) {
      hash = (37 * hash) + SCRIPT_FIELD_NUMBER;
      hash = (53 * hash) + getScript().hashCode();
    }
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    hash = (37 * hash) + ARGUMENTS_TRUNCATED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getArgumentsTruncated());
    if (getEnvVariablesCount() > 0) {
      hash = (37 * hash) + ENV_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + getEnvVariablesList().hashCode();
    }
    hash = (37 * hash) + ENV_VARIABLES_TRUNCATED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnvVariablesTruncated());
    hash = (37 * hash) + PID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPid());
    hash = (37 * hash) + PARENT_PID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getParentPid());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Process parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Process parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Process parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Process prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an operating system process.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Process}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Process)
      com.google.cloud.securitycenter.v1.ProcessOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.ProcessProto
          .internal_static_google_cloud_securitycenter_v1_Process_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.ProcessProto
          .internal_static_google_cloud_securitycenter_v1_Process_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Process.class,
              com.google.cloud.securitycenter.v1.Process.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Process.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBinaryFieldBuilder();
        getLibrariesFieldBuilder();
        getScriptFieldBuilder();
        getEnvVariablesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      binary_ = null;
      if (binaryBuilder_ != null) {
        binaryBuilder_.dispose();
        binaryBuilder_ = null;
      }
      if (librariesBuilder_ == null) {
        libraries_ = java.util.Collections.emptyList();
      } else {
        libraries_ = null;
        librariesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      script_ = null;
      if (scriptBuilder_ != null) {
        scriptBuilder_.dispose();
        scriptBuilder_ = null;
      }
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      argumentsTruncated_ = false;
      if (envVariablesBuilder_ == null) {
        envVariables_ = java.util.Collections.emptyList();
      } else {
        envVariables_ = null;
        envVariablesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      envVariablesTruncated_ = false;
      pid_ = 0L;
      parentPid_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.ProcessProto
          .internal_static_google_cloud_securitycenter_v1_Process_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Process getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Process.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Process build() {
      com.google.cloud.securitycenter.v1.Process result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Process buildPartial() {
      com.google.cloud.securitycenter.v1.Process result =
          new com.google.cloud.securitycenter.v1.Process(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.securitycenter.v1.Process result) {
      if (librariesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          libraries_ = java.util.Collections.unmodifiableList(libraries_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.libraries_ = libraries_;
      } else {
        result.libraries_ = librariesBuilder_.build();
      }
      if (envVariablesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          envVariables_ = java.util.Collections.unmodifiableList(envVariables_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.envVariables_ = envVariables_;
      } else {
        result.envVariables_ = envVariablesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Process result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.binary_ = binaryBuilder_ == null ? binary_ : binaryBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.script_ = scriptBuilder_ == null ? script_ : scriptBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        args_.makeImmutable();
        result.args_ = args_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.argumentsTruncated_ = argumentsTruncated_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.envVariablesTruncated_ = envVariablesTruncated_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.pid_ = pid_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.parentPid_ = parentPid_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Process) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Process) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Process other) {
      if (other == com.google.cloud.securitycenter.v1.Process.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasBinary()) {
        mergeBinary(other.getBinary());
      }
      if (librariesBuilder_ == null) {
        if (!other.libraries_.isEmpty()) {
          if (libraries_.isEmpty()) {
            libraries_ = other.libraries_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureLibrariesIsMutable();
            libraries_.addAll(other.libraries_);
          }
          onChanged();
        }
      } else {
        if (!other.libraries_.isEmpty()) {
          if (librariesBuilder_.isEmpty()) {
            librariesBuilder_.dispose();
            librariesBuilder_ = null;
            libraries_ = other.libraries_;
            bitField0_ = (bitField0_ & ~0x00000004);
            librariesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLibrariesFieldBuilder()
                    : null;
          } else {
            librariesBuilder_.addAllMessages(other.libraries_);
          }
        }
      }
      if (other.hasScript()) {
        mergeScript(other.getScript());
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ |= 0x00000010;
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (other.getArgumentsTruncated() != false) {
        setArgumentsTruncated(other.getArgumentsTruncated());
      }
      if (envVariablesBuilder_ == null) {
        if (!other.envVariables_.isEmpty()) {
          if (envVariables_.isEmpty()) {
            envVariables_ = other.envVariables_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureEnvVariablesIsMutable();
            envVariables_.addAll(other.envVariables_);
          }
          onChanged();
        }
      } else {
        if (!other.envVariables_.isEmpty()) {
          if (envVariablesBuilder_.isEmpty()) {
            envVariablesBuilder_.dispose();
            envVariablesBuilder_ = null;
            envVariables_ = other.envVariables_;
            bitField0_ = (bitField0_ & ~0x00000040);
            envVariablesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEnvVariablesFieldBuilder()
                    : null;
          } else {
            envVariablesBuilder_.addAllMessages(other.envVariables_);
          }
        }
      }
      if (other.getEnvVariablesTruncated() != false) {
        setEnvVariablesTruncated(other.getEnvVariablesTruncated());
      }
      if (other.getPid() != 0L) {
        setPid(other.getPid());
      }
      if (other.getParentPid() != 0L) {
        setParentPid(other.getParentPid());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                input.readMessage(getBinaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.securitycenter.v1.File m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.File.parser(), extensionRegistry);
                if (librariesBuilder_ == null) {
                  ensureLibrariesIsMutable();
                  libraries_.add(m);
                } else {
                  librariesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getScriptFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArgsIsMutable();
                args_.add(s);
                break;
              } // case 50
            case 56:
              {
                argumentsTruncated_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 66:
              {
                com.google.cloud.securitycenter.v1.EnvironmentVariable m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.EnvironmentVariable.parser(),
                        extensionRegistry);
                if (envVariablesBuilder_ == null) {
                  ensureEnvVariablesIsMutable();
                  envVariables_.add(m);
                } else {
                  envVariablesBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 72:
              {
                envVariablesTruncated_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 80:
              {
                pid_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
            case 88:
              {
                parentPid_ = input.readInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 88
            case 98:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The process name, as displayed in utilities like `top` and `ps`. This name
     * can be accessed through `/proc/[pid]/comm` and changed with
     * `prctl(PR_SET_NAME)`.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The process name, as displayed in utilities like `top` and `ps`. This name
     * can be accessed through `/proc/[pid]/comm` and changed with
     * `prctl(PR_SET_NAME)`.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The process name, as displayed in utilities like `top` and `ps`. This name
     * can be accessed through `/proc/[pid]/comm` and changed with
     * `prctl(PR_SET_NAME)`.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The process name, as displayed in utilities like `top` and `ps`. This name
     * can be accessed through `/proc/[pid]/comm` and changed with
     * `prctl(PR_SET_NAME)`.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The process name, as displayed in utilities like `top` and `ps`. This name
     * can be accessed through `/proc/[pid]/comm` and changed with
     * `prctl(PR_SET_NAME)`.
     * </pre>
     *
     * <code>string name = 12;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1.File binary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.File,
            com.google.cloud.securitycenter.v1.File.Builder,
            com.google.cloud.securitycenter.v1.FileOrBuilder>
        binaryBuilder_;
    /**
     *
     *
     * <pre>
     * File information for the process executable.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
     *
     * @return Whether the binary field is set.
     */
    public boolean hasBinary() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * File information for the process executable.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
     *
     * @return The binary.
     */
    public com.google.cloud.securitycenter.v1.File getBinary() {
      if (binaryBuilder_ == null) {
        return binary_ == null
            ? com.google.cloud.securitycenter.v1.File.getDefaultInstance()
            : binary_;
      } else {
        return binaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * File information for the process executable.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
     */
    public Builder setBinary(com.google.cloud.securitycenter.v1.File value) {
      if (binaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        binary_ = value;
      } else {
        binaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for the process executable.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
     */
    public Builder setBinary(com.google.cloud.securitycenter.v1.File.Builder builderForValue) {
      if (binaryBuilder_ == null) {
        binary_ = builderForValue.build();
      } else {
        binaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for the process executable.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
     */
    public Builder mergeBinary(com.google.cloud.securitycenter.v1.File value) {
      if (binaryBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && binary_ != null
            && binary_ != com.google.cloud.securitycenter.v1.File.getDefaultInstance()) {
          getBinaryBuilder().mergeFrom(value);
        } else {
          binary_ = value;
        }
      } else {
        binaryBuilder_.mergeFrom(value);
      }
      if (binary_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for the process executable.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
     */
    public Builder clearBinary() {
      bitField0_ = (bitField0_ & ~0x00000002);
      binary_ = null;
      if (binaryBuilder_ != null) {
        binaryBuilder_.dispose();
        binaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for the process executable.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.File.Builder getBinaryBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getBinaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * File information for the process executable.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.FileOrBuilder getBinaryOrBuilder() {
      if (binaryBuilder_ != null) {
        return binaryBuilder_.getMessageOrBuilder();
      } else {
        return binary_ == null
            ? com.google.cloud.securitycenter.v1.File.getDefaultInstance()
            : binary_;
      }
    }
    /**
     *
     *
     * <pre>
     * File information for the process executable.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File binary = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.File,
            com.google.cloud.securitycenter.v1.File.Builder,
            com.google.cloud.securitycenter.v1.FileOrBuilder>
        getBinaryFieldBuilder() {
      if (binaryBuilder_ == null) {
        binaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.File,
                com.google.cloud.securitycenter.v1.File.Builder,
                com.google.cloud.securitycenter.v1.FileOrBuilder>(
                getBinary(), getParentForChildren(), isClean());
        binary_ = null;
      }
      return binaryBuilder_;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.File> libraries_ =
        java.util.Collections.emptyList();

    private void ensureLibrariesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        libraries_ = new java.util.ArrayList<com.google.cloud.securitycenter.v1.File>(libraries_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.File,
            com.google.cloud.securitycenter.v1.File.Builder,
            com.google.cloud.securitycenter.v1.FileOrBuilder>
        librariesBuilder_;

    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.File> getLibrariesList() {
      if (librariesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(libraries_);
      } else {
        return librariesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public int getLibrariesCount() {
      if (librariesBuilder_ == null) {
        return libraries_.size();
      } else {
        return librariesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.File getLibraries(int index) {
      if (librariesBuilder_ == null) {
        return libraries_.get(index);
      } else {
        return librariesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public Builder setLibraries(int index, com.google.cloud.securitycenter.v1.File value) {
      if (librariesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLibrariesIsMutable();
        libraries_.set(index, value);
        onChanged();
      } else {
        librariesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public Builder setLibraries(
        int index, com.google.cloud.securitycenter.v1.File.Builder builderForValue) {
      if (librariesBuilder_ == null) {
        ensureLibrariesIsMutable();
        libraries_.set(index, builderForValue.build());
        onChanged();
      } else {
        librariesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public Builder addLibraries(com.google.cloud.securitycenter.v1.File value) {
      if (librariesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLibrariesIsMutable();
        libraries_.add(value);
        onChanged();
      } else {
        librariesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public Builder addLibraries(int index, com.google.cloud.securitycenter.v1.File value) {
      if (librariesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLibrariesIsMutable();
        libraries_.add(index, value);
        onChanged();
      } else {
        librariesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public Builder addLibraries(com.google.cloud.securitycenter.v1.File.Builder builderForValue) {
      if (librariesBuilder_ == null) {
        ensureLibrariesIsMutable();
        libraries_.add(builderForValue.build());
        onChanged();
      } else {
        librariesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public Builder addLibraries(
        int index, com.google.cloud.securitycenter.v1.File.Builder builderForValue) {
      if (librariesBuilder_ == null) {
        ensureLibrariesIsMutable();
        libraries_.add(index, builderForValue.build());
        onChanged();
      } else {
        librariesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public Builder addAllLibraries(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.File> values) {
      if (librariesBuilder_ == null) {
        ensureLibrariesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, libraries_);
        onChanged();
      } else {
        librariesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public Builder clearLibraries() {
      if (librariesBuilder_ == null) {
        libraries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        librariesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public Builder removeLibraries(int index) {
      if (librariesBuilder_ == null) {
        ensureLibrariesIsMutable();
        libraries_.remove(index);
        onChanged();
      } else {
        librariesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.File.Builder getLibrariesBuilder(int index) {
      return getLibrariesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.FileOrBuilder getLibrariesOrBuilder(int index) {
      if (librariesBuilder_ == null) {
        return libraries_.get(index);
      } else {
        return librariesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.FileOrBuilder>
        getLibrariesOrBuilderList() {
      if (librariesBuilder_ != null) {
        return librariesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(libraries_);
      }
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.File.Builder addLibrariesBuilder() {
      return getLibrariesFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.File.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.File.Builder addLibrariesBuilder(int index) {
      return getLibrariesFieldBuilder()
          .addBuilder(index, com.google.cloud.securitycenter.v1.File.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * File information for libraries loaded by the process.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.File libraries = 4;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.File.Builder>
        getLibrariesBuilderList() {
      return getLibrariesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.File,
            com.google.cloud.securitycenter.v1.File.Builder,
            com.google.cloud.securitycenter.v1.FileOrBuilder>
        getLibrariesFieldBuilder() {
      if (librariesBuilder_ == null) {
        librariesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.File,
                com.google.cloud.securitycenter.v1.File.Builder,
                com.google.cloud.securitycenter.v1.FileOrBuilder>(
                libraries_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        libraries_ = null;
      }
      return librariesBuilder_;
    }

    private com.google.cloud.securitycenter.v1.File script_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.File,
            com.google.cloud.securitycenter.v1.File.Builder,
            com.google.cloud.securitycenter.v1.FileOrBuilder>
        scriptBuilder_;
    /**
     *
     *
     * <pre>
     * When the process represents the invocation of a script, `binary` provides
     * information about the interpreter, while `script` provides information
     * about the script file provided to the interpreter.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
     *
     * @return Whether the script field is set.
     */
    public boolean hasScript() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * When the process represents the invocation of a script, `binary` provides
     * information about the interpreter, while `script` provides information
     * about the script file provided to the interpreter.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
     *
     * @return The script.
     */
    public com.google.cloud.securitycenter.v1.File getScript() {
      if (scriptBuilder_ == null) {
        return script_ == null
            ? com.google.cloud.securitycenter.v1.File.getDefaultInstance()
            : script_;
      } else {
        return scriptBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * When the process represents the invocation of a script, `binary` provides
     * information about the interpreter, while `script` provides information
     * about the script file provided to the interpreter.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
     */
    public Builder setScript(com.google.cloud.securitycenter.v1.File value) {
      if (scriptBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        script_ = value;
      } else {
        scriptBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When the process represents the invocation of a script, `binary` provides
     * information about the interpreter, while `script` provides information
     * about the script file provided to the interpreter.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
     */
    public Builder setScript(com.google.cloud.securitycenter.v1.File.Builder builderForValue) {
      if (scriptBuilder_ == null) {
        script_ = builderForValue.build();
      } else {
        scriptBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When the process represents the invocation of a script, `binary` provides
     * information about the interpreter, while `script` provides information
     * about the script file provided to the interpreter.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
     */
    public Builder mergeScript(com.google.cloud.securitycenter.v1.File value) {
      if (scriptBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && script_ != null
            && script_ != com.google.cloud.securitycenter.v1.File.getDefaultInstance()) {
          getScriptBuilder().mergeFrom(value);
        } else {
          script_ = value;
        }
      } else {
        scriptBuilder_.mergeFrom(value);
      }
      if (script_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When the process represents the invocation of a script, `binary` provides
     * information about the interpreter, while `script` provides information
     * about the script file provided to the interpreter.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
     */
    public Builder clearScript() {
      bitField0_ = (bitField0_ & ~0x00000008);
      script_ = null;
      if (scriptBuilder_ != null) {
        scriptBuilder_.dispose();
        scriptBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When the process represents the invocation of a script, `binary` provides
     * information about the interpreter, while `script` provides information
     * about the script file provided to the interpreter.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
     */
    public com.google.cloud.securitycenter.v1.File.Builder getScriptBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getScriptFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * When the process represents the invocation of a script, `binary` provides
     * information about the interpreter, while `script` provides information
     * about the script file provided to the interpreter.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
     */
    public com.google.cloud.securitycenter.v1.FileOrBuilder getScriptOrBuilder() {
      if (scriptBuilder_ != null) {
        return scriptBuilder_.getMessageOrBuilder();
      } else {
        return script_ == null
            ? com.google.cloud.securitycenter.v1.File.getDefaultInstance()
            : script_;
      }
    }
    /**
     *
     *
     * <pre>
     * When the process represents the invocation of a script, `binary` provides
     * information about the interpreter, while `script` provides information
     * about the script file provided to the interpreter.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.File script = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.File,
            com.google.cloud.securitycenter.v1.File.Builder,
            com.google.cloud.securitycenter.v1.FileOrBuilder>
        getScriptFieldBuilder() {
      if (scriptBuilder_ == null) {
        scriptBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.File,
                com.google.cloud.securitycenter.v1.File.Builder,
                com.google.cloud.securitycenter.v1.FileOrBuilder>(
                getScript(), getParentForChildren(), isClean());
        script_ = null;
      }
      return scriptBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList args_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureArgsIsMutable() {
      if (!args_.isModifiable()) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Process arguments as JSON encoded strings.
     * </pre>
     *
     * <code>repeated string args = 6;</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      args_.makeImmutable();
      return args_;
    }
    /**
     *
     *
     * <pre>
     * Process arguments as JSON encoded strings.
     * </pre>
     *
     * <code>repeated string args = 6;</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     *
     *
     * <pre>
     * Process arguments as JSON encoded strings.
     * </pre>
     *
     * <code>repeated string args = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Process arguments as JSON encoded strings.
     * </pre>
     *
     * <code>repeated string args = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Process arguments as JSON encoded strings.
     * </pre>
     *
     * <code>repeated string args = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process arguments as JSON encoded strings.
     * </pre>
     *
     * <code>repeated string args = 6;</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process arguments as JSON encoded strings.
     * </pre>
     *
     * <code>repeated string args = 6;</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process arguments as JSON encoded strings.
     * </pre>
     *
     * <code>repeated string args = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process arguments as JSON encoded strings.
     * </pre>
     *
     * <code>repeated string args = 6;</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean argumentsTruncated_;
    /**
     *
     *
     * <pre>
     * True if `args` is incomplete.
     * </pre>
     *
     * <code>bool arguments_truncated = 7;</code>
     *
     * @return The argumentsTruncated.
     */
    @java.lang.Override
    public boolean getArgumentsTruncated() {
      return argumentsTruncated_;
    }
    /**
     *
     *
     * <pre>
     * True if `args` is incomplete.
     * </pre>
     *
     * <code>bool arguments_truncated = 7;</code>
     *
     * @param value The argumentsTruncated to set.
     * @return This builder for chaining.
     */
    public Builder setArgumentsTruncated(boolean value) {

      argumentsTruncated_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if `args` is incomplete.
     * </pre>
     *
     * <code>bool arguments_truncated = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgumentsTruncated() {
      bitField0_ = (bitField0_ & ~0x00000020);
      argumentsTruncated_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.EnvironmentVariable> envVariables_ =
        java.util.Collections.emptyList();

    private void ensureEnvVariablesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        envVariables_ =
            new java.util.ArrayList<com.google.cloud.securitycenter.v1.EnvironmentVariable>(
                envVariables_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.EnvironmentVariable,
            com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder,
            com.google.cloud.securitycenter.v1.EnvironmentVariableOrBuilder>
        envVariablesBuilder_;

    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.EnvironmentVariable>
        getEnvVariablesList() {
      if (envVariablesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(envVariables_);
      } else {
        return envVariablesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public int getEnvVariablesCount() {
      if (envVariablesBuilder_ == null) {
        return envVariables_.size();
      } else {
        return envVariablesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public com.google.cloud.securitycenter.v1.EnvironmentVariable getEnvVariables(int index) {
      if (envVariablesBuilder_ == null) {
        return envVariables_.get(index);
      } else {
        return envVariablesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public Builder setEnvVariables(
        int index, com.google.cloud.securitycenter.v1.EnvironmentVariable value) {
      if (envVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvVariablesIsMutable();
        envVariables_.set(index, value);
        onChanged();
      } else {
        envVariablesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public Builder setEnvVariables(
        int index, com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder builderForValue) {
      if (envVariablesBuilder_ == null) {
        ensureEnvVariablesIsMutable();
        envVariables_.set(index, builderForValue.build());
        onChanged();
      } else {
        envVariablesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public Builder addEnvVariables(com.google.cloud.securitycenter.v1.EnvironmentVariable value) {
      if (envVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvVariablesIsMutable();
        envVariables_.add(value);
        onChanged();
      } else {
        envVariablesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public Builder addEnvVariables(
        int index, com.google.cloud.securitycenter.v1.EnvironmentVariable value) {
      if (envVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvVariablesIsMutable();
        envVariables_.add(index, value);
        onChanged();
      } else {
        envVariablesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public Builder addEnvVariables(
        com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder builderForValue) {
      if (envVariablesBuilder_ == null) {
        ensureEnvVariablesIsMutable();
        envVariables_.add(builderForValue.build());
        onChanged();
      } else {
        envVariablesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public Builder addEnvVariables(
        int index, com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder builderForValue) {
      if (envVariablesBuilder_ == null) {
        ensureEnvVariablesIsMutable();
        envVariables_.add(index, builderForValue.build());
        onChanged();
      } else {
        envVariablesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public Builder addAllEnvVariables(
        java.lang.Iterable<? extends com.google.cloud.securitycenter.v1.EnvironmentVariable>
            values) {
      if (envVariablesBuilder_ == null) {
        ensureEnvVariablesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, envVariables_);
        onChanged();
      } else {
        envVariablesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public Builder clearEnvVariables() {
      if (envVariablesBuilder_ == null) {
        envVariables_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        envVariablesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public Builder removeEnvVariables(int index) {
      if (envVariablesBuilder_ == null) {
        ensureEnvVariablesIsMutable();
        envVariables_.remove(index);
        onChanged();
      } else {
        envVariablesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder getEnvVariablesBuilder(
        int index) {
      return getEnvVariablesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public com.google.cloud.securitycenter.v1.EnvironmentVariableOrBuilder getEnvVariablesOrBuilder(
        int index) {
      if (envVariablesBuilder_ == null) {
        return envVariables_.get(index);
      } else {
        return envVariablesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public java.util.List<? extends com.google.cloud.securitycenter.v1.EnvironmentVariableOrBuilder>
        getEnvVariablesOrBuilderList() {
      if (envVariablesBuilder_ != null) {
        return envVariablesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(envVariables_);
      }
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder addEnvVariablesBuilder() {
      return getEnvVariablesFieldBuilder()
          .addBuilder(com.google.cloud.securitycenter.v1.EnvironmentVariable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder addEnvVariablesBuilder(
        int index) {
      return getEnvVariablesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.securitycenter.v1.EnvironmentVariable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Process environment variables.
     * </pre>
     *
     * <code>repeated .google.cloud.securitycenter.v1.EnvironmentVariable env_variables = 8;</code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder>
        getEnvVariablesBuilderList() {
      return getEnvVariablesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.EnvironmentVariable,
            com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder,
            com.google.cloud.securitycenter.v1.EnvironmentVariableOrBuilder>
        getEnvVariablesFieldBuilder() {
      if (envVariablesBuilder_ == null) {
        envVariablesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.EnvironmentVariable,
                com.google.cloud.securitycenter.v1.EnvironmentVariable.Builder,
                com.google.cloud.securitycenter.v1.EnvironmentVariableOrBuilder>(
                envVariables_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        envVariables_ = null;
      }
      return envVariablesBuilder_;
    }

    private boolean envVariablesTruncated_;
    /**
     *
     *
     * <pre>
     * True if `env_variables` is incomplete.
     * </pre>
     *
     * <code>bool env_variables_truncated = 9;</code>
     *
     * @return The envVariablesTruncated.
     */
    @java.lang.Override
    public boolean getEnvVariablesTruncated() {
      return envVariablesTruncated_;
    }
    /**
     *
     *
     * <pre>
     * True if `env_variables` is incomplete.
     * </pre>
     *
     * <code>bool env_variables_truncated = 9;</code>
     *
     * @param value The envVariablesTruncated to set.
     * @return This builder for chaining.
     */
    public Builder setEnvVariablesTruncated(boolean value) {

      envVariablesTruncated_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if `env_variables` is incomplete.
     * </pre>
     *
     * <code>bool env_variables_truncated = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnvVariablesTruncated() {
      bitField0_ = (bitField0_ & ~0x00000080);
      envVariablesTruncated_ = false;
      onChanged();
      return this;
    }

    private long pid_;
    /**
     *
     *
     * <pre>
     * The process ID.
     * </pre>
     *
     * <code>int64 pid = 10;</code>
     *
     * @return The pid.
     */
    @java.lang.Override
    public long getPid() {
      return pid_;
    }
    /**
     *
     *
     * <pre>
     * The process ID.
     * </pre>
     *
     * <code>int64 pid = 10;</code>
     *
     * @param value The pid to set.
     * @return This builder for chaining.
     */
    public Builder setPid(long value) {

      pid_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The process ID.
     * </pre>
     *
     * <code>int64 pid = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPid() {
      bitField0_ = (bitField0_ & ~0x00000100);
      pid_ = 0L;
      onChanged();
      return this;
    }

    private long parentPid_;
    /**
     *
     *
     * <pre>
     * The parent process ID.
     * </pre>
     *
     * <code>int64 parent_pid = 11;</code>
     *
     * @return The parentPid.
     */
    @java.lang.Override
    public long getParentPid() {
      return parentPid_;
    }
    /**
     *
     *
     * <pre>
     * The parent process ID.
     * </pre>
     *
     * <code>int64 parent_pid = 11;</code>
     *
     * @param value The parentPid to set.
     * @return This builder for chaining.
     */
    public Builder setParentPid(long value) {

      parentPid_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parent process ID.
     * </pre>
     *
     * <code>int64 parent_pid = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentPid() {
      bitField0_ = (bitField0_ & ~0x00000200);
      parentPid_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Process)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Process)
  private static final com.google.cloud.securitycenter.v1.Process DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Process();
  }

  public static com.google.cloud.securitycenter.v1.Process getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Process> PARSER =
      new com.google.protobuf.AbstractParser<Process>() {
        @java.lang.Override
        public Process parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Process> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Process> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Process getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
