/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/security_health_analytics_custom_module.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

public interface SecurityHealthAnalyticsCustomModuleOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the custom module.
   * Its format is
   * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
   * or
   * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
   * or
   * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
   *
   * The id {customModule} is server-generated and is not user settable.
   * It will be a numeric id containing 1-20 digits.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the custom module.
   * Its format is
   * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
   * or
   * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
   * or
   * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
   *
   * The id {customModule} is server-generated and is not user settable.
   * It will be a numeric id containing 1-20 digits.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The display name of the Security Health Analytics custom module. This
   * display name becomes the finding category for all findings that are
   * returned by this custom module. The display name must be between 1 and
   * 128 characters, start with a lowercase letter, and contain alphanumeric
   * characters or underscores only.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * The display name of the Security Health Analytics custom module. This
   * display name becomes the finding category for all findings that are
   * returned by this custom module. The display name must be between 1 and
   * 128 characters, start with a lowercase letter, and contain alphanumeric
   * characters or underscores only.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * The enablement state of the custom module.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for enablementState.
   */
  int getEnablementStateValue();
  /**
   *
   *
   * <pre>
   * The enablement state of the custom module.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;
   * </code>
   *
   * @return The enablementState.
   */
  com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState
      getEnablementState();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the custom module was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which the custom module was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which the custom module was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The editor that last updated the custom module.
   * </pre>
   *
   * <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The lastEditor.
   */
  java.lang.String getLastEditor();
  /**
   *
   *
   * <pre>
   * Output only. The editor that last updated the custom module.
   * </pre>
   *
   * <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for lastEditor.
   */
  com.google.protobuf.ByteString getLastEditorBytes();

  /**
   *
   *
   * <pre>
   * Output only. If empty, indicates that the custom module was created in the
   * organization, folder, or project in which you are viewing the custom
   * module. Otherwise, `ancestor_module` specifies the organization or folder
   * from which the custom module is inherited.
   * </pre>
   *
   * <code>
   * string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The ancestorModule.
   */
  java.lang.String getAncestorModule();
  /**
   *
   *
   * <pre>
   * Output only. If empty, indicates that the custom module was created in the
   * organization, folder, or project in which you are viewing the custom
   * module. Otherwise, `ancestor_module` specifies the organization or folder
   * from which the custom module is inherited.
   * </pre>
   *
   * <code>
   * string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for ancestorModule.
   */
  com.google.protobuf.ByteString getAncestorModuleBytes();

  /**
   *
   *
   * <pre>
   * The user specified custom configuration for the module.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
   *
   * @return Whether the customConfig field is set.
   */
  boolean hasCustomConfig();
  /**
   *
   *
   * <pre>
   * The user specified custom configuration for the module.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
   *
   * @return The customConfig.
   */
  com.google.cloud.securitycenter.v1.CustomConfig getCustomConfig();
  /**
   *
   *
   * <pre>
   * The user specified custom configuration for the module.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
   */
  com.google.cloud.securitycenter.v1.CustomConfigOrBuilder getCustomConfigOrBuilder();
}
