/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/security_posture.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Represents a posture that is deployed on Google Cloud by the
 * Security Command Center Posture Management service.
 * A posture contains one or more policy sets. A policy set is a
 * group of policies that enforce a set of security rules on Google
 * Cloud.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.SecurityPosture}
 */
public final class SecurityPosture extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.SecurityPosture)
    SecurityPostureOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecurityPosture.newBuilder() to construct.
  private SecurityPosture(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityPosture() {
    name_ = "";
    revisionId_ = "";
    postureDeploymentResource_ = "";
    postureDeployment_ = "";
    changedPolicy_ = "";
    policySet_ = "";
    policy_ = "";
    policyDriftDetails_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityPosture();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.SecurityPostureProto
        .internal_static_google_cloud_securitycenter_v1_SecurityPosture_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.SecurityPostureProto
        .internal_static_google_cloud_securitycenter_v1_SecurityPosture_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.SecurityPosture.class,
            com.google.cloud.securitycenter.v1.SecurityPosture.Builder.class);
  }

  public interface PolicyDriftDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the updated field, for example
     * constraint.implementation.policy_rules[0].enforce
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The field.
     */
    java.lang.String getField();
    /**
     *
     *
     * <pre>
     * The name of the updated field, for example
     * constraint.implementation.policy_rules[0].enforce
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The bytes for field.
     */
    com.google.protobuf.ByteString getFieldBytes();

    /**
     *
     *
     * <pre>
     * The value of this field that was configured in a posture, for example,
     * `true` or `allowed_values={"projects/29831892"}`.
     * </pre>
     *
     * <code>string expected_value = 2;</code>
     *
     * @return The expectedValue.
     */
    java.lang.String getExpectedValue();
    /**
     *
     *
     * <pre>
     * The value of this field that was configured in a posture, for example,
     * `true` or `allowed_values={"projects/29831892"}`.
     * </pre>
     *
     * <code>string expected_value = 2;</code>
     *
     * @return The bytes for expectedValue.
     */
    com.google.protobuf.ByteString getExpectedValueBytes();

    /**
     *
     *
     * <pre>
     * The detected value that violates the deployed posture, for example,
     * `false` or `allowed_values={"projects/22831892"}`.
     * </pre>
     *
     * <code>string detected_value = 3;</code>
     *
     * @return The detectedValue.
     */
    java.lang.String getDetectedValue();
    /**
     *
     *
     * <pre>
     * The detected value that violates the deployed posture, for example,
     * `false` or `allowed_values={"projects/22831892"}`.
     * </pre>
     *
     * <code>string detected_value = 3;</code>
     *
     * @return The bytes for detectedValue.
     */
    com.google.protobuf.ByteString getDetectedValueBytes();
  }
  /**
   *
   *
   * <pre>
   * The policy field that violates the deployed posture and its expected and
   * detected values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails}
   */
  public static final class PolicyDriftDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails)
      PolicyDriftDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PolicyDriftDetails.newBuilder() to construct.
    private PolicyDriftDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PolicyDriftDetails() {
      field_ = "";
      expectedValue_ = "";
      detectedValue_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PolicyDriftDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecurityPostureProto
          .internal_static_google_cloud_securitycenter_v1_SecurityPosture_PolicyDriftDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecurityPostureProto
          .internal_static_google_cloud_securitycenter_v1_SecurityPosture_PolicyDriftDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.class,
              com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder.class);
    }

    public static final int FIELD_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object field_ = "";
    /**
     *
     *
     * <pre>
     * The name of the updated field, for example
     * constraint.implementation.policy_rules[0].enforce
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The field.
     */
    @java.lang.Override
    public java.lang.String getField() {
      java.lang.Object ref = field_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        field_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the updated field, for example
     * constraint.implementation.policy_rules[0].enforce
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The bytes for field.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFieldBytes() {
      java.lang.Object ref = field_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        field_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EXPECTED_VALUE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object expectedValue_ = "";
    /**
     *
     *
     * <pre>
     * The value of this field that was configured in a posture, for example,
     * `true` or `allowed_values={"projects/29831892"}`.
     * </pre>
     *
     * <code>string expected_value = 2;</code>
     *
     * @return The expectedValue.
     */
    @java.lang.Override
    public java.lang.String getExpectedValue() {
      java.lang.Object ref = expectedValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        expectedValue_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of this field that was configured in a posture, for example,
     * `true` or `allowed_values={"projects/29831892"}`.
     * </pre>
     *
     * <code>string expected_value = 2;</code>
     *
     * @return The bytes for expectedValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getExpectedValueBytes() {
      java.lang.Object ref = expectedValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        expectedValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DETECTED_VALUE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object detectedValue_ = "";
    /**
     *
     *
     * <pre>
     * The detected value that violates the deployed posture, for example,
     * `false` or `allowed_values={"projects/22831892"}`.
     * </pre>
     *
     * <code>string detected_value = 3;</code>
     *
     * @return The detectedValue.
     */
    @java.lang.Override
    public java.lang.String getDetectedValue() {
      java.lang.Object ref = detectedValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detectedValue_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The detected value that violates the deployed posture, for example,
     * `false` or `allowed_values={"projects/22831892"}`.
     * </pre>
     *
     * <code>string detected_value = 3;</code>
     *
     * @return The bytes for detectedValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDetectedValueBytes() {
      java.lang.Object ref = detectedValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        detectedValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(field_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, field_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(expectedValue_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, expectedValue_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detectedValue_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, detectedValue_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(field_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, field_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(expectedValue_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, expectedValue_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detectedValue_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, detectedValue_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails other =
          (com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails) obj;

      if (!getField().equals(other.getField())) return false;
      if (!getExpectedValue().equals(other.getExpectedValue())) return false;
      if (!getDetectedValue().equals(other.getDetectedValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FIELD_FIELD_NUMBER;
      hash = (53 * hash) + getField().hashCode();
      hash = (37 * hash) + EXPECTED_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getExpectedValue().hashCode();
      hash = (37 * hash) + DETECTED_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getDetectedValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The policy field that violates the deployed posture and its expected and
     * detected values.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails)
        com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.SecurityPostureProto
            .internal_static_google_cloud_securitycenter_v1_SecurityPosture_PolicyDriftDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.SecurityPostureProto
            .internal_static_google_cloud_securitycenter_v1_SecurityPosture_PolicyDriftDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.class,
                com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        field_ = "";
        expectedValue_ = "";
        detectedValue_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.SecurityPostureProto
            .internal_static_google_cloud_securitycenter_v1_SecurityPosture_PolicyDriftDetails_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails build() {
        com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails buildPartial() {
        com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails result =
            new com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.field_ = field_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.expectedValue_ = expectedValue_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.detectedValue_ = detectedValue_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails other) {
        if (other
            == com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
                .getDefaultInstance()) return this;
        if (!other.getField().isEmpty()) {
          field_ = other.field_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getExpectedValue().isEmpty()) {
          expectedValue_ = other.expectedValue_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getDetectedValue().isEmpty()) {
          detectedValue_ = other.detectedValue_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  field_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  expectedValue_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  detectedValue_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object field_ = "";
      /**
       *
       *
       * <pre>
       * The name of the updated field, for example
       * constraint.implementation.policy_rules[0].enforce
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @return The field.
       */
      public java.lang.String getField() {
        java.lang.Object ref = field_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          field_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the updated field, for example
       * constraint.implementation.policy_rules[0].enforce
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @return The bytes for field.
       */
      public com.google.protobuf.ByteString getFieldBytes() {
        java.lang.Object ref = field_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          field_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the updated field, for example
       * constraint.implementation.policy_rules[0].enforce
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @param value The field to set.
       * @return This builder for chaining.
       */
      public Builder setField(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        field_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the updated field, for example
       * constraint.implementation.policy_rules[0].enforce
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearField() {
        field_ = getDefaultInstance().getField();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the updated field, for example
       * constraint.implementation.policy_rules[0].enforce
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @param value The bytes for field to set.
       * @return This builder for chaining.
       */
      public Builder setFieldBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        field_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object expectedValue_ = "";
      /**
       *
       *
       * <pre>
       * The value of this field that was configured in a posture, for example,
       * `true` or `allowed_values={"projects/29831892"}`.
       * </pre>
       *
       * <code>string expected_value = 2;</code>
       *
       * @return The expectedValue.
       */
      public java.lang.String getExpectedValue() {
        java.lang.Object ref = expectedValue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          expectedValue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of this field that was configured in a posture, for example,
       * `true` or `allowed_values={"projects/29831892"}`.
       * </pre>
       *
       * <code>string expected_value = 2;</code>
       *
       * @return The bytes for expectedValue.
       */
      public com.google.protobuf.ByteString getExpectedValueBytes() {
        java.lang.Object ref = expectedValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          expectedValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of this field that was configured in a posture, for example,
       * `true` or `allowed_values={"projects/29831892"}`.
       * </pre>
       *
       * <code>string expected_value = 2;</code>
       *
       * @param value The expectedValue to set.
       * @return This builder for chaining.
       */
      public Builder setExpectedValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        expectedValue_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of this field that was configured in a posture, for example,
       * `true` or `allowed_values={"projects/29831892"}`.
       * </pre>
       *
       * <code>string expected_value = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExpectedValue() {
        expectedValue_ = getDefaultInstance().getExpectedValue();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of this field that was configured in a posture, for example,
       * `true` or `allowed_values={"projects/29831892"}`.
       * </pre>
       *
       * <code>string expected_value = 2;</code>
       *
       * @param value The bytes for expectedValue to set.
       * @return This builder for chaining.
       */
      public Builder setExpectedValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        expectedValue_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object detectedValue_ = "";
      /**
       *
       *
       * <pre>
       * The detected value that violates the deployed posture, for example,
       * `false` or `allowed_values={"projects/22831892"}`.
       * </pre>
       *
       * <code>string detected_value = 3;</code>
       *
       * @return The detectedValue.
       */
      public java.lang.String getDetectedValue() {
        java.lang.Object ref = detectedValue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          detectedValue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The detected value that violates the deployed posture, for example,
       * `false` or `allowed_values={"projects/22831892"}`.
       * </pre>
       *
       * <code>string detected_value = 3;</code>
       *
       * @return The bytes for detectedValue.
       */
      public com.google.protobuf.ByteString getDetectedValueBytes() {
        java.lang.Object ref = detectedValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          detectedValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The detected value that violates the deployed posture, for example,
       * `false` or `allowed_values={"projects/22831892"}`.
       * </pre>
       *
       * <code>string detected_value = 3;</code>
       *
       * @param value The detectedValue to set.
       * @return This builder for chaining.
       */
      public Builder setDetectedValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        detectedValue_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The detected value that violates the deployed posture, for example,
       * `false` or `allowed_values={"projects/22831892"}`.
       * </pre>
       *
       * <code>string detected_value = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDetectedValue() {
        detectedValue_ = getDefaultInstance().getDetectedValue();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The detected value that violates the deployed posture, for example,
       * `false` or `allowed_values={"projects/22831892"}`.
       * </pre>
       *
       * <code>string detected_value = 3;</code>
       *
       * @param value The bytes for detectedValue to set.
       * @return This builder for chaining.
       */
      public Builder setDetectedValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        detectedValue_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails)
    private static final com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails();
    }

    public static com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PolicyDriftDetails> PARSER =
        new com.google.protobuf.AbstractParser<PolicyDriftDetails>() {
          @java.lang.Override
          public PolicyDriftDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PolicyDriftDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PolicyDriftDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the posture, for example, `CIS-Posture`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the posture, for example, `CIS-Posture`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REVISION_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object revisionId_ = "";
  /**
   *
   *
   * <pre>
   * The version of the posture, for example, `c7cfa2a8`.
   * </pre>
   *
   * <code>string revision_id = 2;</code>
   *
   * @return The revisionId.
   */
  @java.lang.Override
  public java.lang.String getRevisionId() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      revisionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The version of the posture, for example, `c7cfa2a8`.
   * </pre>
   *
   * <code>string revision_id = 2;</code>
   *
   * @return The bytes for revisionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRevisionIdBytes() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      revisionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POSTURE_DEPLOYMENT_RESOURCE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object postureDeploymentResource_ = "";
  /**
   *
   *
   * <pre>
   * The project, folder, or organization on which the posture is deployed,
   * for example, `projects/{project_number}`.
   * </pre>
   *
   * <code>string posture_deployment_resource = 3;</code>
   *
   * @return The postureDeploymentResource.
   */
  @java.lang.Override
  public java.lang.String getPostureDeploymentResource() {
    java.lang.Object ref = postureDeploymentResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      postureDeploymentResource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project, folder, or organization on which the posture is deployed,
   * for example, `projects/{project_number}`.
   * </pre>
   *
   * <code>string posture_deployment_resource = 3;</code>
   *
   * @return The bytes for postureDeploymentResource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPostureDeploymentResourceBytes() {
    java.lang.Object ref = postureDeploymentResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      postureDeploymentResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POSTURE_DEPLOYMENT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object postureDeployment_ = "";
  /**
   *
   *
   * <pre>
   * The name of the posture deployment, for example,
   * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
   * </pre>
   *
   * <code>string posture_deployment = 4;</code>
   *
   * @return The postureDeployment.
   */
  @java.lang.Override
  public java.lang.String getPostureDeployment() {
    java.lang.Object ref = postureDeployment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      postureDeployment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the posture deployment, for example,
   * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
   * </pre>
   *
   * <code>string posture_deployment = 4;</code>
   *
   * @return The bytes for postureDeployment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPostureDeploymentBytes() {
    java.lang.Object ref = postureDeployment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      postureDeployment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHANGED_POLICY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object changedPolicy_ = "";
  /**
   *
   *
   * <pre>
   * The name of the updated policy, for example,
   * `projects/{project_id}/policies/{constraint_name}`.
   * </pre>
   *
   * <code>string changed_policy = 5;</code>
   *
   * @return The changedPolicy.
   */
  @java.lang.Override
  public java.lang.String getChangedPolicy() {
    java.lang.Object ref = changedPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      changedPolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the updated policy, for example,
   * `projects/{project_id}/policies/{constraint_name}`.
   * </pre>
   *
   * <code>string changed_policy = 5;</code>
   *
   * @return The bytes for changedPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChangedPolicyBytes() {
    java.lang.Object ref = changedPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      changedPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICY_SET_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object policySet_ = "";
  /**
   *
   *
   * <pre>
   * The name of the updated policyset, for example, `cis-policyset`.
   * </pre>
   *
   * <code>string policy_set = 6;</code>
   *
   * @return The policySet.
   */
  @java.lang.Override
  public java.lang.String getPolicySet() {
    java.lang.Object ref = policySet_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      policySet_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the updated policyset, for example, `cis-policyset`.
   * </pre>
   *
   * <code>string policy_set = 6;</code>
   *
   * @return The bytes for policySet.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPolicySetBytes() {
    java.lang.Object ref = policySet_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      policySet_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object policy_ = "";
  /**
   *
   *
   * <pre>
   * The ID of the updated policy, for example, `compute-policy-1`.
   * </pre>
   *
   * <code>string policy = 7;</code>
   *
   * @return The policy.
   */
  @java.lang.Override
  public java.lang.String getPolicy() {
    java.lang.Object ref = policy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      policy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of the updated policy, for example, `compute-policy-1`.
   * </pre>
   *
   * <code>string policy = 7;</code>
   *
   * @return The bytes for policy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPolicyBytes() {
    java.lang.Object ref = policy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      policy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICY_DRIFT_DETAILS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails>
      policyDriftDetails_;
  /**
   *
   *
   * <pre>
   * The details about a change in an updated policy that violates the deployed
   * posture.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails>
      getPolicyDriftDetailsList() {
    return policyDriftDetails_;
  }
  /**
   *
   *
   * <pre>
   * The details about a change in an updated policy that violates the deployed
   * posture.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetailsOrBuilder>
      getPolicyDriftDetailsOrBuilderList() {
    return policyDriftDetails_;
  }
  /**
   *
   *
   * <pre>
   * The details about a change in an updated policy that violates the deployed
   * posture.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
   * </code>
   */
  @java.lang.Override
  public int getPolicyDriftDetailsCount() {
    return policyDriftDetails_.size();
  }
  /**
   *
   *
   * <pre>
   * The details about a change in an updated policy that violates the deployed
   * posture.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
      getPolicyDriftDetails(int index) {
    return policyDriftDetails_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The details about a change in an updated policy that violates the deployed
   * posture.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetailsOrBuilder
      getPolicyDriftDetailsOrBuilder(int index) {
    return policyDriftDetails_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, revisionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postureDeploymentResource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, postureDeploymentResource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postureDeployment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, postureDeployment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(changedPolicy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, changedPolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policySet_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, policySet_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, policy_);
    }
    for (int i = 0; i < policyDriftDetails_.size(); i++) {
      output.writeMessage(8, policyDriftDetails_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, revisionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postureDeploymentResource_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(3, postureDeploymentResource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postureDeployment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, postureDeployment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(changedPolicy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, changedPolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policySet_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, policySet_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, policy_);
    }
    for (int i = 0; i < policyDriftDetails_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, policyDriftDetails_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.SecurityPosture)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.SecurityPosture other =
        (com.google.cloud.securitycenter.v1.SecurityPosture) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getRevisionId().equals(other.getRevisionId())) return false;
    if (!getPostureDeploymentResource().equals(other.getPostureDeploymentResource())) return false;
    if (!getPostureDeployment().equals(other.getPostureDeployment())) return false;
    if (!getChangedPolicy().equals(other.getChangedPolicy())) return false;
    if (!getPolicySet().equals(other.getPolicySet())) return false;
    if (!getPolicy().equals(other.getPolicy())) return false;
    if (!getPolicyDriftDetailsList().equals(other.getPolicyDriftDetailsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + REVISION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRevisionId().hashCode();
    hash = (37 * hash) + POSTURE_DEPLOYMENT_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getPostureDeploymentResource().hashCode();
    hash = (37 * hash) + POSTURE_DEPLOYMENT_FIELD_NUMBER;
    hash = (53 * hash) + getPostureDeployment().hashCode();
    hash = (37 * hash) + CHANGED_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + getChangedPolicy().hashCode();
    hash = (37 * hash) + POLICY_SET_FIELD_NUMBER;
    hash = (53 * hash) + getPolicySet().hashCode();
    hash = (37 * hash) + POLICY_FIELD_NUMBER;
    hash = (53 * hash) + getPolicy().hashCode();
    if (getPolicyDriftDetailsCount() > 0) {
      hash = (37 * hash) + POLICY_DRIFT_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getPolicyDriftDetailsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.SecurityPosture prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a posture that is deployed on Google Cloud by the
   * Security Command Center Posture Management service.
   * A posture contains one or more policy sets. A policy set is a
   * group of policies that enforce a set of security rules on Google
   * Cloud.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.SecurityPosture}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.SecurityPosture)
      com.google.cloud.securitycenter.v1.SecurityPostureOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecurityPostureProto
          .internal_static_google_cloud_securitycenter_v1_SecurityPosture_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecurityPostureProto
          .internal_static_google_cloud_securitycenter_v1_SecurityPosture_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.SecurityPosture.class,
              com.google.cloud.securitycenter.v1.SecurityPosture.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.SecurityPosture.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      revisionId_ = "";
      postureDeploymentResource_ = "";
      postureDeployment_ = "";
      changedPolicy_ = "";
      policySet_ = "";
      policy_ = "";
      if (policyDriftDetailsBuilder_ == null) {
        policyDriftDetails_ = java.util.Collections.emptyList();
      } else {
        policyDriftDetails_ = null;
        policyDriftDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.SecurityPostureProto
          .internal_static_google_cloud_securitycenter_v1_SecurityPosture_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SecurityPosture getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.SecurityPosture.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SecurityPosture build() {
      com.google.cloud.securitycenter.v1.SecurityPosture result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SecurityPosture buildPartial() {
      com.google.cloud.securitycenter.v1.SecurityPosture result =
          new com.google.cloud.securitycenter.v1.SecurityPosture(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.securitycenter.v1.SecurityPosture result) {
      if (policyDriftDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          policyDriftDetails_ = java.util.Collections.unmodifiableList(policyDriftDetails_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.policyDriftDetails_ = policyDriftDetails_;
      } else {
        result.policyDriftDetails_ = policyDriftDetailsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.SecurityPosture result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.revisionId_ = revisionId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.postureDeploymentResource_ = postureDeploymentResource_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.postureDeployment_ = postureDeployment_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.changedPolicy_ = changedPolicy_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.policySet_ = policySet_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.policy_ = policy_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.SecurityPosture) {
        return mergeFrom((com.google.cloud.securitycenter.v1.SecurityPosture) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.SecurityPosture other) {
      if (other == com.google.cloud.securitycenter.v1.SecurityPosture.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRevisionId().isEmpty()) {
        revisionId_ = other.revisionId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getPostureDeploymentResource().isEmpty()) {
        postureDeploymentResource_ = other.postureDeploymentResource_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPostureDeployment().isEmpty()) {
        postureDeployment_ = other.postureDeployment_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getChangedPolicy().isEmpty()) {
        changedPolicy_ = other.changedPolicy_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getPolicySet().isEmpty()) {
        policySet_ = other.policySet_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getPolicy().isEmpty()) {
        policy_ = other.policy_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (policyDriftDetailsBuilder_ == null) {
        if (!other.policyDriftDetails_.isEmpty()) {
          if (policyDriftDetails_.isEmpty()) {
            policyDriftDetails_ = other.policyDriftDetails_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensurePolicyDriftDetailsIsMutable();
            policyDriftDetails_.addAll(other.policyDriftDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.policyDriftDetails_.isEmpty()) {
          if (policyDriftDetailsBuilder_.isEmpty()) {
            policyDriftDetailsBuilder_.dispose();
            policyDriftDetailsBuilder_ = null;
            policyDriftDetails_ = other.policyDriftDetails_;
            bitField0_ = (bitField0_ & ~0x00000080);
            policyDriftDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPolicyDriftDetailsFieldBuilder()
                    : null;
          } else {
            policyDriftDetailsBuilder_.addAllMessages(other.policyDriftDetails_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                revisionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                postureDeploymentResource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                postureDeployment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                changedPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                policySet_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                policy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
                            .parser(),
                        extensionRegistry);
                if (policyDriftDetailsBuilder_ == null) {
                  ensurePolicyDriftDetailsIsMutable();
                  policyDriftDetails_.add(m);
                } else {
                  policyDriftDetailsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the posture, for example, `CIS-Posture`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the posture, for example, `CIS-Posture`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the posture, for example, `CIS-Posture`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the posture, for example, `CIS-Posture`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the posture, for example, `CIS-Posture`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object revisionId_ = "";
    /**
     *
     *
     * <pre>
     * The version of the posture, for example, `c7cfa2a8`.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @return The revisionId.
     */
    public java.lang.String getRevisionId() {
      java.lang.Object ref = revisionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        revisionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the posture, for example, `c7cfa2a8`.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @return The bytes for revisionId.
     */
    public com.google.protobuf.ByteString getRevisionIdBytes() {
      java.lang.Object ref = revisionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        revisionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the posture, for example, `c7cfa2a8`.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @param value The revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of the posture, for example, `c7cfa2a8`.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevisionId() {
      revisionId_ = getDefaultInstance().getRevisionId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of the posture, for example, `c7cfa2a8`.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @param value The bytes for revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object postureDeploymentResource_ = "";
    /**
     *
     *
     * <pre>
     * The project, folder, or organization on which the posture is deployed,
     * for example, `projects/{project_number}`.
     * </pre>
     *
     * <code>string posture_deployment_resource = 3;</code>
     *
     * @return The postureDeploymentResource.
     */
    public java.lang.String getPostureDeploymentResource() {
      java.lang.Object ref = postureDeploymentResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        postureDeploymentResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project, folder, or organization on which the posture is deployed,
     * for example, `projects/{project_number}`.
     * </pre>
     *
     * <code>string posture_deployment_resource = 3;</code>
     *
     * @return The bytes for postureDeploymentResource.
     */
    public com.google.protobuf.ByteString getPostureDeploymentResourceBytes() {
      java.lang.Object ref = postureDeploymentResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        postureDeploymentResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project, folder, or organization on which the posture is deployed,
     * for example, `projects/{project_number}`.
     * </pre>
     *
     * <code>string posture_deployment_resource = 3;</code>
     *
     * @param value The postureDeploymentResource to set.
     * @return This builder for chaining.
     */
    public Builder setPostureDeploymentResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      postureDeploymentResource_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project, folder, or organization on which the posture is deployed,
     * for example, `projects/{project_number}`.
     * </pre>
     *
     * <code>string posture_deployment_resource = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPostureDeploymentResource() {
      postureDeploymentResource_ = getDefaultInstance().getPostureDeploymentResource();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project, folder, or organization on which the posture is deployed,
     * for example, `projects/{project_number}`.
     * </pre>
     *
     * <code>string posture_deployment_resource = 3;</code>
     *
     * @param value The bytes for postureDeploymentResource to set.
     * @return This builder for chaining.
     */
    public Builder setPostureDeploymentResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      postureDeploymentResource_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object postureDeployment_ = "";
    /**
     *
     *
     * <pre>
     * The name of the posture deployment, for example,
     * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
     * </pre>
     *
     * <code>string posture_deployment = 4;</code>
     *
     * @return The postureDeployment.
     */
    public java.lang.String getPostureDeployment() {
      java.lang.Object ref = postureDeployment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        postureDeployment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the posture deployment, for example,
     * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
     * </pre>
     *
     * <code>string posture_deployment = 4;</code>
     *
     * @return The bytes for postureDeployment.
     */
    public com.google.protobuf.ByteString getPostureDeploymentBytes() {
      java.lang.Object ref = postureDeployment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        postureDeployment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the posture deployment, for example,
     * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
     * </pre>
     *
     * <code>string posture_deployment = 4;</code>
     *
     * @param value The postureDeployment to set.
     * @return This builder for chaining.
     */
    public Builder setPostureDeployment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      postureDeployment_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the posture deployment, for example,
     * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
     * </pre>
     *
     * <code>string posture_deployment = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPostureDeployment() {
      postureDeployment_ = getDefaultInstance().getPostureDeployment();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the posture deployment, for example,
     * `organizations/{org_id}/posturedeployments/{posture_deployment_id}`.
     * </pre>
     *
     * <code>string posture_deployment = 4;</code>
     *
     * @param value The bytes for postureDeployment to set.
     * @return This builder for chaining.
     */
    public Builder setPostureDeploymentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      postureDeployment_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object changedPolicy_ = "";
    /**
     *
     *
     * <pre>
     * The name of the updated policy, for example,
     * `projects/{project_id}/policies/{constraint_name}`.
     * </pre>
     *
     * <code>string changed_policy = 5;</code>
     *
     * @return The changedPolicy.
     */
    public java.lang.String getChangedPolicy() {
      java.lang.Object ref = changedPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        changedPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the updated policy, for example,
     * `projects/{project_id}/policies/{constraint_name}`.
     * </pre>
     *
     * <code>string changed_policy = 5;</code>
     *
     * @return The bytes for changedPolicy.
     */
    public com.google.protobuf.ByteString getChangedPolicyBytes() {
      java.lang.Object ref = changedPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        changedPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the updated policy, for example,
     * `projects/{project_id}/policies/{constraint_name}`.
     * </pre>
     *
     * <code>string changed_policy = 5;</code>
     *
     * @param value The changedPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setChangedPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      changedPolicy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the updated policy, for example,
     * `projects/{project_id}/policies/{constraint_name}`.
     * </pre>
     *
     * <code>string changed_policy = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChangedPolicy() {
      changedPolicy_ = getDefaultInstance().getChangedPolicy();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the updated policy, for example,
     * `projects/{project_id}/policies/{constraint_name}`.
     * </pre>
     *
     * <code>string changed_policy = 5;</code>
     *
     * @param value The bytes for changedPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setChangedPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      changedPolicy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object policySet_ = "";
    /**
     *
     *
     * <pre>
     * The name of the updated policyset, for example, `cis-policyset`.
     * </pre>
     *
     * <code>string policy_set = 6;</code>
     *
     * @return The policySet.
     */
    public java.lang.String getPolicySet() {
      java.lang.Object ref = policySet_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        policySet_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the updated policyset, for example, `cis-policyset`.
     * </pre>
     *
     * <code>string policy_set = 6;</code>
     *
     * @return The bytes for policySet.
     */
    public com.google.protobuf.ByteString getPolicySetBytes() {
      java.lang.Object ref = policySet_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        policySet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the updated policyset, for example, `cis-policyset`.
     * </pre>
     *
     * <code>string policy_set = 6;</code>
     *
     * @param value The policySet to set.
     * @return This builder for chaining.
     */
    public Builder setPolicySet(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      policySet_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the updated policyset, for example, `cis-policyset`.
     * </pre>
     *
     * <code>string policy_set = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicySet() {
      policySet_ = getDefaultInstance().getPolicySet();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the updated policyset, for example, `cis-policyset`.
     * </pre>
     *
     * <code>string policy_set = 6;</code>
     *
     * @param value The bytes for policySet to set.
     * @return This builder for chaining.
     */
    public Builder setPolicySetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      policySet_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object policy_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the updated policy, for example, `compute-policy-1`.
     * </pre>
     *
     * <code>string policy = 7;</code>
     *
     * @return The policy.
     */
    public java.lang.String getPolicy() {
      java.lang.Object ref = policy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        policy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the updated policy, for example, `compute-policy-1`.
     * </pre>
     *
     * <code>string policy = 7;</code>
     *
     * @return The bytes for policy.
     */
    public com.google.protobuf.ByteString getPolicyBytes() {
      java.lang.Object ref = policy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        policy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the updated policy, for example, `compute-policy-1`.
     * </pre>
     *
     * <code>string policy = 7;</code>
     *
     * @param value The policy to set.
     * @return This builder for chaining.
     */
    public Builder setPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      policy_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the updated policy, for example, `compute-policy-1`.
     * </pre>
     *
     * <code>string policy = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicy() {
      policy_ = getDefaultInstance().getPolicy();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the updated policy, for example, `compute-policy-1`.
     * </pre>
     *
     * <code>string policy = 7;</code>
     *
     * @param value The bytes for policy to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      policy_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails>
        policyDriftDetails_ = java.util.Collections.emptyList();

    private void ensurePolicyDriftDetailsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        policyDriftDetails_ =
            new java.util.ArrayList<
                com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails>(
                policyDriftDetails_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails,
            com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder,
            com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetailsOrBuilder>
        policyDriftDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails>
        getPolicyDriftDetailsList() {
      if (policyDriftDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(policyDriftDetails_);
      } else {
        return policyDriftDetailsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public int getPolicyDriftDetailsCount() {
      if (policyDriftDetailsBuilder_ == null) {
        return policyDriftDetails_.size();
      } else {
        return policyDriftDetailsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
        getPolicyDriftDetails(int index) {
      if (policyDriftDetailsBuilder_ == null) {
        return policyDriftDetails_.get(index);
      } else {
        return policyDriftDetailsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public Builder setPolicyDriftDetails(
        int index, com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails value) {
      if (policyDriftDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePolicyDriftDetailsIsMutable();
        policyDriftDetails_.set(index, value);
        onChanged();
      } else {
        policyDriftDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public Builder setPolicyDriftDetails(
        int index,
        com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder
            builderForValue) {
      if (policyDriftDetailsBuilder_ == null) {
        ensurePolicyDriftDetailsIsMutable();
        policyDriftDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        policyDriftDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public Builder addPolicyDriftDetails(
        com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails value) {
      if (policyDriftDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePolicyDriftDetailsIsMutable();
        policyDriftDetails_.add(value);
        onChanged();
      } else {
        policyDriftDetailsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public Builder addPolicyDriftDetails(
        int index, com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails value) {
      if (policyDriftDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePolicyDriftDetailsIsMutable();
        policyDriftDetails_.add(index, value);
        onChanged();
      } else {
        policyDriftDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public Builder addPolicyDriftDetails(
        com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder
            builderForValue) {
      if (policyDriftDetailsBuilder_ == null) {
        ensurePolicyDriftDetailsIsMutable();
        policyDriftDetails_.add(builderForValue.build());
        onChanged();
      } else {
        policyDriftDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public Builder addPolicyDriftDetails(
        int index,
        com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder
            builderForValue) {
      if (policyDriftDetailsBuilder_ == null) {
        ensurePolicyDriftDetailsIsMutable();
        policyDriftDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        policyDriftDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public Builder addAllPolicyDriftDetails(
        java.lang.Iterable<
                ? extends com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails>
            values) {
      if (policyDriftDetailsBuilder_ == null) {
        ensurePolicyDriftDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, policyDriftDetails_);
        onChanged();
      } else {
        policyDriftDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public Builder clearPolicyDriftDetails() {
      if (policyDriftDetailsBuilder_ == null) {
        policyDriftDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        policyDriftDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public Builder removePolicyDriftDetails(int index) {
      if (policyDriftDetailsBuilder_ == null) {
        ensurePolicyDriftDetailsIsMutable();
        policyDriftDetails_.remove(index);
        onChanged();
      } else {
        policyDriftDetailsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder
        getPolicyDriftDetailsBuilder(int index) {
      return getPolicyDriftDetailsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetailsOrBuilder
        getPolicyDriftDetailsOrBuilder(int index) {
      if (policyDriftDetailsBuilder_ == null) {
        return policyDriftDetails_.get(index);
      } else {
        return policyDriftDetailsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetailsOrBuilder>
        getPolicyDriftDetailsOrBuilderList() {
      if (policyDriftDetailsBuilder_ != null) {
        return policyDriftDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(policyDriftDetails_);
      }
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder
        addPolicyDriftDetailsBuilder() {
      return getPolicyDriftDetailsFieldBuilder()
          .addBuilder(
              com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder
        addPolicyDriftDetailsBuilder(int index) {
      return getPolicyDriftDetailsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The details about a change in an updated policy that violates the deployed
     * posture.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails policy_drift_details = 8;
     * </code>
     */
    public java.util.List<
            com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder>
        getPolicyDriftDetailsBuilderList() {
      return getPolicyDriftDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails,
            com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder,
            com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetailsOrBuilder>
        getPolicyDriftDetailsFieldBuilder() {
      if (policyDriftDetailsBuilder_ == null) {
        policyDriftDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails,
                com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetails.Builder,
                com.google.cloud.securitycenter.v1.SecurityPosture.PolicyDriftDetailsOrBuilder>(
                policyDriftDetails_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        policyDriftDetails_ = null;
      }
      return policyDriftDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.SecurityPosture)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.SecurityPosture)
  private static final com.google.cloud.securitycenter.v1.SecurityPosture DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.SecurityPosture();
  }

  public static com.google.cloud.securitycenter.v1.SecurityPosture getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecurityPosture> PARSER =
      new com.google.protobuf.AbstractParser<SecurityPosture>() {
        @java.lang.Override
        public SecurityPosture parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecurityPosture> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityPosture> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityPosture getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
