/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Request message to simulate a CustomConfig against a given test resource.
 * Maximum size of the request is 4 MB by default.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest}
 */
public final class SimulateSecurityHealthAnalyticsCustomModuleRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest)
    SimulateSecurityHealthAnalyticsCustomModuleRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SimulateSecurityHealthAnalyticsCustomModuleRequest.newBuilder() to construct.
  private SimulateSecurityHealthAnalyticsCustomModuleRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SimulateSecurityHealthAnalyticsCustomModuleRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SimulateSecurityHealthAnalyticsCustomModuleRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .class,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .Builder.class);
  }

  public interface SimulatedResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The type of the resource, for example,
     * `compute.googleapis.com/Disk`.
     * </pre>
     *
     * <code>string resource_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The resourceType.
     */
    java.lang.String getResourceType();
    /**
     *
     *
     * <pre>
     * Required. The type of the resource, for example,
     * `compute.googleapis.com/Disk`.
     * </pre>
     *
     * <code>string resource_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for resourceType.
     */
    com.google.protobuf.ByteString getResourceTypeBytes();

    /**
     *
     *
     * <pre>
     * Optional. A representation of the Google Cloud resource. Should match the
     * Google Cloud resource JSON format.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the resourceData field is set.
     */
    boolean hasResourceData();
    /**
     *
     *
     * <pre>
     * Optional. A representation of the Google Cloud resource. Should match the
     * Google Cloud resource JSON format.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The resourceData.
     */
    com.google.protobuf.Struct getResourceData();
    /**
     *
     *
     * <pre>
     * Optional. A representation of the Google Cloud resource. Should match the
     * Google Cloud resource JSON format.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.StructOrBuilder getResourceDataOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. A representation of the IAM policy.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the iamPolicyData field is set.
     */
    boolean hasIamPolicyData();
    /**
     *
     *
     * <pre>
     * Optional. A representation of the IAM policy.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The iamPolicyData.
     */
    com.google.iam.v1.Policy getIamPolicyData();
    /**
     *
     *
     * <pre>
     * Optional. A representation of the IAM policy.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.iam.v1.PolicyOrBuilder getIamPolicyDataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Manually constructed resource name. If the custom module evaluates against
   * only the resource data, you can omit the `iam_policy_data` field. If it
   * evaluates only the `iam_policy_data` field, you can omit the resource data.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource}
   */
  public static final class SimulatedResource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource)
      SimulatedResourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SimulatedResource.newBuilder() to construct.
    private SimulatedResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SimulatedResource() {
      resourceType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SimulatedResource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                  .SimulatedResource.class,
              com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                  .SimulatedResource.Builder.class);
    }

    private int bitField0_;
    public static final int RESOURCE_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The type of the resource, for example,
     * `compute.googleapis.com/Disk`.
     * </pre>
     *
     * <code>string resource_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public java.lang.String getResourceType() {
      java.lang.Object ref = resourceType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The type of the resource, for example,
     * `compute.googleapis.com/Disk`.
     * </pre>
     *
     * <code>string resource_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for resourceType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceTypeBytes() {
      java.lang.Object ref = resourceType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_DATA_FIELD_NUMBER = 2;
    private com.google.protobuf.Struct resourceData_;
    /**
     *
     *
     * <pre>
     * Optional. A representation of the Google Cloud resource. Should match the
     * Google Cloud resource JSON format.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the resourceData field is set.
     */
    @java.lang.Override
    public boolean hasResourceData() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. A representation of the Google Cloud resource. Should match the
     * Google Cloud resource JSON format.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The resourceData.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getResourceData() {
      return resourceData_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : resourceData_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A representation of the Google Cloud resource. Should match the
     * Google Cloud resource JSON format.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getResourceDataOrBuilder() {
      return resourceData_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : resourceData_;
    }

    public static final int IAM_POLICY_DATA_FIELD_NUMBER = 3;
    private com.google.iam.v1.Policy iamPolicyData_;
    /**
     *
     *
     * <pre>
     * Optional. A representation of the IAM policy.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the iamPolicyData field is set.
     */
    @java.lang.Override
    public boolean hasIamPolicyData() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. A representation of the IAM policy.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The iamPolicyData.
     */
    @java.lang.Override
    public com.google.iam.v1.Policy getIamPolicyData() {
      return iamPolicyData_ == null
          ? com.google.iam.v1.Policy.getDefaultInstance()
          : iamPolicyData_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A representation of the IAM policy.
     * </pre>
     *
     * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.iam.v1.PolicyOrBuilder getIamPolicyDataOrBuilder() {
      return iamPolicyData_ == null
          ? com.google.iam.v1.Policy.getDefaultInstance()
          : iamPolicyData_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getResourceData());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getIamPolicyData());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getResourceData());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getIamPolicyData());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
              .SimulatedResource)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
              .SimulatedResource
          other =
              (com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                      .SimulatedResource)
                  obj;

      if (!getResourceType().equals(other.getResourceType())) return false;
      if (hasResourceData() != other.hasResourceData()) return false;
      if (hasResourceData()) {
        if (!getResourceData().equals(other.getResourceData())) return false;
      }
      if (hasIamPolicyData() != other.hasIamPolicyData()) return false;
      if (hasIamPolicyData()) {
        if (!getIamPolicyData().equals(other.getIamPolicyData())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getResourceType().hashCode();
      if (hasResourceData()) {
        hash = (37 * hash) + RESOURCE_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getResourceData().hashCode();
      }
      if (hasIamPolicyData()) {
        hash = (37 * hash) + IAM_POLICY_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getIamPolicyData().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Manually constructed resource name. If the custom module evaluates against
     * only the resource data, you can omit the `iam_policy_data` field. If it
     * evaluates only the `iam_policy_data` field, you can omit the resource data.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource)
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            .SimulatedResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource.class,
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getResourceDataFieldBuilder();
          getIamPolicyDataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        resourceType_ = "";
        resourceData_ = null;
        if (resourceDataBuilder_ != null) {
          resourceDataBuilder_.dispose();
          resourceDataBuilder_ = null;
        }
        iamPolicyData_ = null;
        if (iamPolicyDataBuilder_ != null) {
          iamPolicyDataBuilder_.dispose();
          iamPolicyDataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
              .SimulatedResource
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            .SimulatedResource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
              .SimulatedResource
          build() {
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
              .SimulatedResource
          buildPartial() {
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource
            result =
                new com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                  .SimulatedResource
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.resourceType_ = resourceType_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.resourceData_ =
              resourceDataBuilder_ == null ? resourceData_ : resourceDataBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.iamPolicyData_ =
              iamPolicyDataBuilder_ == null ? iamPolicyData_ : iamPolicyDataBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                      .SimulatedResource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                  .SimulatedResource
              other) {
        if (other
            == com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource.getDefaultInstance()) return this;
        if (!other.getResourceType().isEmpty()) {
          resourceType_ = other.resourceType_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasResourceData()) {
          mergeResourceData(other.getResourceData());
        }
        if (other.hasIamPolicyData()) {
          mergeIamPolicyData(other.getIamPolicyData());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  resourceType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getResourceDataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getIamPolicyDataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object resourceType_ = "";
      /**
       *
       *
       * <pre>
       * Required. The type of the resource, for example,
       * `compute.googleapis.com/Disk`.
       * </pre>
       *
       * <code>string resource_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The resourceType.
       */
      public java.lang.String getResourceType() {
        java.lang.Object ref = resourceType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the resource, for example,
       * `compute.googleapis.com/Disk`.
       * </pre>
       *
       * <code>string resource_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for resourceType.
       */
      public com.google.protobuf.ByteString getResourceTypeBytes() {
        java.lang.Object ref = resourceType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the resource, for example,
       * `compute.googleapis.com/Disk`.
       * </pre>
       *
       * <code>string resource_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the resource, for example,
       * `compute.googleapis.com/Disk`.
       * </pre>
       *
       * <code>string resource_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceType() {
        resourceType_ = getDefaultInstance().getResourceType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The type of the resource, for example,
       * `compute.googleapis.com/Disk`.
       * </pre>
       *
       * <code>string resource_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.Struct resourceData_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          resourceDataBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. A representation of the Google Cloud resource. Should match the
       * Google Cloud resource JSON format.
       * </pre>
       *
       * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the resourceData field is set.
       */
      public boolean hasResourceData() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the Google Cloud resource. Should match the
       * Google Cloud resource JSON format.
       * </pre>
       *
       * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The resourceData.
       */
      public com.google.protobuf.Struct getResourceData() {
        if (resourceDataBuilder_ == null) {
          return resourceData_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : resourceData_;
        } else {
          return resourceDataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the Google Cloud resource. Should match the
       * Google Cloud resource JSON format.
       * </pre>
       *
       * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setResourceData(com.google.protobuf.Struct value) {
        if (resourceDataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          resourceData_ = value;
        } else {
          resourceDataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the Google Cloud resource. Should match the
       * Google Cloud resource JSON format.
       * </pre>
       *
       * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setResourceData(com.google.protobuf.Struct.Builder builderForValue) {
        if (resourceDataBuilder_ == null) {
          resourceData_ = builderForValue.build();
        } else {
          resourceDataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the Google Cloud resource. Should match the
       * Google Cloud resource JSON format.
       * </pre>
       *
       * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeResourceData(com.google.protobuf.Struct value) {
        if (resourceDataBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && resourceData_ != null
              && resourceData_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getResourceDataBuilder().mergeFrom(value);
          } else {
            resourceData_ = value;
          }
        } else {
          resourceDataBuilder_.mergeFrom(value);
        }
        if (resourceData_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the Google Cloud resource. Should match the
       * Google Cloud resource JSON format.
       * </pre>
       *
       * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearResourceData() {
        bitField0_ = (bitField0_ & ~0x00000002);
        resourceData_ = null;
        if (resourceDataBuilder_ != null) {
          resourceDataBuilder_.dispose();
          resourceDataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the Google Cloud resource. Should match the
       * Google Cloud resource JSON format.
       * </pre>
       *
       * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Struct.Builder getResourceDataBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getResourceDataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the Google Cloud resource. Should match the
       * Google Cloud resource JSON format.
       * </pre>
       *
       * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.StructOrBuilder getResourceDataOrBuilder() {
        if (resourceDataBuilder_ != null) {
          return resourceDataBuilder_.getMessageOrBuilder();
        } else {
          return resourceData_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : resourceData_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the Google Cloud resource. Should match the
       * Google Cloud resource JSON format.
       * </pre>
       *
       * <code>.google.protobuf.Struct resource_data = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getResourceDataFieldBuilder() {
        if (resourceDataBuilder_ == null) {
          resourceDataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getResourceData(), getParentForChildren(), isClean());
          resourceData_ = null;
        }
        return resourceDataBuilder_;
      }

      private com.google.iam.v1.Policy iamPolicyData_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.iam.v1.Policy,
              com.google.iam.v1.Policy.Builder,
              com.google.iam.v1.PolicyOrBuilder>
          iamPolicyDataBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. A representation of the IAM policy.
       * </pre>
       *
       * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the iamPolicyData field is set.
       */
      public boolean hasIamPolicyData() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the IAM policy.
       * </pre>
       *
       * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The iamPolicyData.
       */
      public com.google.iam.v1.Policy getIamPolicyData() {
        if (iamPolicyDataBuilder_ == null) {
          return iamPolicyData_ == null
              ? com.google.iam.v1.Policy.getDefaultInstance()
              : iamPolicyData_;
        } else {
          return iamPolicyDataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the IAM policy.
       * </pre>
       *
       * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setIamPolicyData(com.google.iam.v1.Policy value) {
        if (iamPolicyDataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          iamPolicyData_ = value;
        } else {
          iamPolicyDataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the IAM policy.
       * </pre>
       *
       * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setIamPolicyData(com.google.iam.v1.Policy.Builder builderForValue) {
        if (iamPolicyDataBuilder_ == null) {
          iamPolicyData_ = builderForValue.build();
        } else {
          iamPolicyDataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the IAM policy.
       * </pre>
       *
       * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeIamPolicyData(com.google.iam.v1.Policy value) {
        if (iamPolicyDataBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && iamPolicyData_ != null
              && iamPolicyData_ != com.google.iam.v1.Policy.getDefaultInstance()) {
            getIamPolicyDataBuilder().mergeFrom(value);
          } else {
            iamPolicyData_ = value;
          }
        } else {
          iamPolicyDataBuilder_.mergeFrom(value);
        }
        if (iamPolicyData_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the IAM policy.
       * </pre>
       *
       * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearIamPolicyData() {
        bitField0_ = (bitField0_ & ~0x00000004);
        iamPolicyData_ = null;
        if (iamPolicyDataBuilder_ != null) {
          iamPolicyDataBuilder_.dispose();
          iamPolicyDataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the IAM policy.
       * </pre>
       *
       * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.iam.v1.Policy.Builder getIamPolicyDataBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getIamPolicyDataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the IAM policy.
       * </pre>
       *
       * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.iam.v1.PolicyOrBuilder getIamPolicyDataOrBuilder() {
        if (iamPolicyDataBuilder_ != null) {
          return iamPolicyDataBuilder_.getMessageOrBuilder();
        } else {
          return iamPolicyData_ == null
              ? com.google.iam.v1.Policy.getDefaultInstance()
              : iamPolicyData_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A representation of the IAM policy.
       * </pre>
       *
       * <code>.google.iam.v1.Policy iam_policy_data = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.iam.v1.Policy,
              com.google.iam.v1.Policy.Builder,
              com.google.iam.v1.PolicyOrBuilder>
          getIamPolicyDataFieldBuilder() {
        if (iamPolicyDataBuilder_ == null) {
          iamPolicyDataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.iam.v1.Policy,
                  com.google.iam.v1.Policy.Builder,
                  com.google.iam.v1.PolicyOrBuilder>(
                  getIamPolicyData(), getParentForChildren(), isClean());
          iamPolicyData_ = null;
        }
        return iamPolicyDataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource)
    private static final com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
              .SimulatedResource();
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SimulatedResource> PARSER =
        new com.google.protobuf.AbstractParser<SimulatedResource>() {
          @java.lang.Override
          public SimulatedResource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SimulatedResource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SimulatedResource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            .SimulatedResource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the organization, project, or
   * folder. For more information about relative resource names, see [Relative
   * Resource
   * Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
   * Example: `organizations/{organization_id}`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the organization, project, or
   * folder. For more information about relative resource names, see [Relative
   * Resource
   * Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
   * Example: `organizations/{organization_id}`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.securitycenter.v1.CustomConfig customConfig_;
  /**
   *
   *
   * <pre>
   * Required. The custom configuration that you need to test.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the customConfig field is set.
   */
  @java.lang.Override
  public boolean hasCustomConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The custom configuration that you need to test.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The customConfig.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfig getCustomConfig() {
    return customConfig_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
        : customConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The custom configuration that you need to test.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CustomConfigOrBuilder getCustomConfigOrBuilder() {
    return customConfig_ == null
        ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
        : customConfig_;
  }

  public static final int RESOURCE_FIELD_NUMBER = 3;
  private com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
          .SimulatedResource
      resource_;
  /**
   *
   *
   * <pre>
   * Required. Resource data to simulate custom module against.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the resource field is set.
   */
  @java.lang.Override
  public boolean hasResource() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Resource data to simulate custom module against.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
          .SimulatedResource
      getResource() {
    return resource_ == null
        ? com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            .SimulatedResource.getDefaultInstance()
        : resource_;
  }
  /**
   *
   *
   * <pre>
   * Required. Resource data to simulate custom module against.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
          .SimulatedResourceOrBuilder
      getResourceOrBuilder() {
    return resource_ == null
        ? com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            .SimulatedResource.getDefaultInstance()
        : resource_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCustomConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getResource());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCustomConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getResource());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest other =
        (com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasCustomConfig() != other.hasCustomConfig()) return false;
    if (hasCustomConfig()) {
      if (!getCustomConfig().equals(other.getCustomConfig())) return false;
    }
    if (hasResource() != other.hasResource()) return false;
    if (hasResource()) {
      if (!getResource().equals(other.getResource())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasCustomConfig()) {
      hash = (37 * hash) + CUSTOM_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCustomConfig().hashCode();
    }
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message to simulate a CustomConfig against a given test resource.
   * Maximum size of the request is 4 MB by default.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest)
      com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                  .class,
              com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCustomConfigFieldBuilder();
        getResourceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      customConfig_ = null;
      if (customConfigBuilder_ != null) {
        customConfigBuilder_.dispose();
        customConfigBuilder_ = null;
      }
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
        getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
        build() {
      com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
        buildPartial() {
      com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest result =
          new com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest(
              this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.customConfig_ =
            customConfigBuilder_ == null ? customConfig_ : customConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resource_ = resourceBuilder_ == null ? resource_ : resourceBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest) {
        return mergeFrom(
            (com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            other) {
      if (other
          == com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCustomConfig()) {
        mergeCustomConfig(other.getCustomConfig());
      }
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCustomConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the organization, project, or
     * folder. For more information about relative resource names, see [Relative
     * Resource
     * Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * Example: `organizations/{organization_id}`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the organization, project, or
     * folder. For more information about relative resource names, see [Relative
     * Resource
     * Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * Example: `organizations/{organization_id}`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the organization, project, or
     * folder. For more information about relative resource names, see [Relative
     * Resource
     * Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * Example: `organizations/{organization_id}`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the organization, project, or
     * folder. For more information about relative resource names, see [Relative
     * Resource
     * Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * Example: `organizations/{organization_id}`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the organization, project, or
     * folder. For more information about relative resource names, see [Relative
     * Resource
     * Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
     * Example: `organizations/{organization_id}`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1.CustomConfig customConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig,
            com.google.cloud.securitycenter.v1.CustomConfig.Builder,
            com.google.cloud.securitycenter.v1.CustomConfigOrBuilder>
        customConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The custom configuration that you need to test.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the customConfig field is set.
     */
    public boolean hasCustomConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The custom configuration that you need to test.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The customConfig.
     */
    public com.google.cloud.securitycenter.v1.CustomConfig getCustomConfig() {
      if (customConfigBuilder_ == null) {
        return customConfig_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
            : customConfig_;
      } else {
        return customConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The custom configuration that you need to test.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCustomConfig(com.google.cloud.securitycenter.v1.CustomConfig value) {
      if (customConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customConfig_ = value;
      } else {
        customConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The custom configuration that you need to test.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCustomConfig(
        com.google.cloud.securitycenter.v1.CustomConfig.Builder builderForValue) {
      if (customConfigBuilder_ == null) {
        customConfig_ = builderForValue.build();
      } else {
        customConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The custom configuration that you need to test.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeCustomConfig(com.google.cloud.securitycenter.v1.CustomConfig value) {
      if (customConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && customConfig_ != null
            && customConfig_
                != com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()) {
          getCustomConfigBuilder().mergeFrom(value);
        } else {
          customConfig_ = value;
        }
      } else {
        customConfigBuilder_.mergeFrom(value);
      }
      if (customConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The custom configuration that you need to test.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearCustomConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      customConfig_ = null;
      if (customConfigBuilder_ != null) {
        customConfigBuilder_.dispose();
        customConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The custom configuration that you need to test.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfig.Builder getCustomConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCustomConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The custom configuration that you need to test.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.CustomConfigOrBuilder getCustomConfigOrBuilder() {
      if (customConfigBuilder_ != null) {
        return customConfigBuilder_.getMessageOrBuilder();
      } else {
        return customConfig_ == null
            ? com.google.cloud.securitycenter.v1.CustomConfig.getDefaultInstance()
            : customConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The custom configuration that you need to test.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.CustomConfig custom_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.CustomConfig,
            com.google.cloud.securitycenter.v1.CustomConfig.Builder,
            com.google.cloud.securitycenter.v1.CustomConfigOrBuilder>
        getCustomConfigFieldBuilder() {
      if (customConfigBuilder_ == null) {
        customConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.CustomConfig,
                com.google.cloud.securitycenter.v1.CustomConfig.Builder,
                com.google.cloud.securitycenter.v1.CustomConfigOrBuilder>(
                getCustomConfig(), getParentForChildren(), isClean());
        customConfig_ = null;
      }
      return customConfigBuilder_;
    }

    private com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            .SimulatedResource
        resource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource.Builder,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResourceOrBuilder>
        resourceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Resource data to simulate custom module against.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the resource field is set.
     */
    public boolean hasResource() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Resource data to simulate custom module against.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The resource.
     */
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            .SimulatedResource
        getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null
            ? com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource.getDefaultInstance()
            : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Resource data to simulate custom module against.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResource(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource
            value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
      } else {
        resourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource data to simulate custom module against.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResource(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource.Builder
            builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource data to simulate custom module against.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeResource(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource
            value) {
      if (resourceBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && resource_ != null
            && resource_
                != com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
                    .getDefaultInstance()) {
          getResourceBuilder().mergeFrom(value);
        } else {
          resource_ = value;
        }
      } else {
        resourceBuilder_.mergeFrom(value);
      }
      if (resource_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource data to simulate custom module against.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearResource() {
      bitField0_ = (bitField0_ & ~0x00000004);
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource data to simulate custom module against.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            .SimulatedResource.Builder
        getResourceBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Resource data to simulate custom module against.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
            .SimulatedResourceOrBuilder
        getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null
            ? com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource.getDefaultInstance()
            : resource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Resource data to simulate custom module against.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource resource = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResource.Builder,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
                .SimulatedResourceOrBuilder>
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource,
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource.Builder,
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResourceOrBuilder>(
                getResource(), getParentForChildren(), isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest)
  private static final com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest();
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          SimulateSecurityHealthAnalyticsCustomModuleRequest>
      PARSER =
          new com.google.protobuf.AbstractParser<
              SimulateSecurityHealthAnalyticsCustomModuleRequest>() {
            @java.lang.Override
            public SimulateSecurityHealthAnalyticsCustomModuleRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<SimulateSecurityHealthAnalyticsCustomModuleRequest>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SimulateSecurityHealthAnalyticsCustomModuleRequest>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
