/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Response message for simulating a `SecurityHealthAnalyticsCustomModule`
 * against a given resource.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse}
 */
public final class SimulateSecurityHealthAnalyticsCustomModuleResponse
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse)
    SimulateSecurityHealthAnalyticsCustomModuleResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SimulateSecurityHealthAnalyticsCustomModuleResponse.newBuilder() to construct.
  private SimulateSecurityHealthAnalyticsCustomModuleResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SimulateSecurityHealthAnalyticsCustomModuleResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SimulateSecurityHealthAnalyticsCustomModuleResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .class,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .Builder.class);
  }

  public interface SimulatedResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Finding that would be published for the test case,
     * if a violation is detected.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     *
     * @return Whether the finding field is set.
     */
    boolean hasFinding();
    /**
     *
     *
     * <pre>
     * Finding that would be published for the test case,
     * if a violation is detected.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     *
     * @return The finding.
     */
    com.google.cloud.securitycenter.v1.Finding getFinding();
    /**
     *
     *
     * <pre>
     * Finding that would be published for the test case,
     * if a violation is detected.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     */
    com.google.cloud.securitycenter.v1.FindingOrBuilder getFindingOrBuilder();

    /**
     *
     *
     * <pre>
     * Indicates that the test case does not trigger any violation.
     * </pre>
     *
     * <code>.google.protobuf.Empty no_violation = 2;</code>
     *
     * @return Whether the noViolation field is set.
     */
    boolean hasNoViolation();
    /**
     *
     *
     * <pre>
     * Indicates that the test case does not trigger any violation.
     * </pre>
     *
     * <code>.google.protobuf.Empty no_violation = 2;</code>
     *
     * @return The noViolation.
     */
    com.google.protobuf.Empty getNoViolation();
    /**
     *
     *
     * <pre>
     * Indicates that the test case does not trigger any violation.
     * </pre>
     *
     * <code>.google.protobuf.Empty no_violation = 2;</code>
     */
    com.google.protobuf.EmptyOrBuilder getNoViolationOrBuilder();

    /**
     *
     *
     * <pre>
     * Error encountered during the test.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     *
     *
     * <pre>
     * Error encountered during the test.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return The error.
     */
    com.google.rpc.Status getError();
    /**
     *
     *
     * <pre>
     * Error encountered during the test.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    com.google.rpc.StatusOrBuilder getErrorOrBuilder();

    com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            .SimulatedResult.ResultCase
        getResultCase();
  }
  /**
   *
   *
   * <pre>
   * Possible test result.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult}
   */
  public static final class SimulatedResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult)
      SimulatedResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SimulatedResult.newBuilder() to construct.
    private SimulatedResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SimulatedResult() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SimulatedResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                  .SimulatedResult.class,
              com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                  .SimulatedResult.Builder.class);
    }

    private int resultCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object result_;

    public enum ResultCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      FINDING(1),
      NO_VIOLATION(2),
      ERROR(3),
      RESULT_NOT_SET(0);
      private final int value;

      private ResultCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ResultCase valueOf(int value) {
        return forNumber(value);
      }

      public static ResultCase forNumber(int value) {
        switch (value) {
          case 1:
            return FINDING;
          case 2:
            return NO_VIOLATION;
          case 3:
            return ERROR;
          case 0:
            return RESULT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public static final int FINDING_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Finding that would be published for the test case,
     * if a violation is detected.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     *
     * @return Whether the finding field is set.
     */
    @java.lang.Override
    public boolean hasFinding() {
      return resultCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Finding that would be published for the test case,
     * if a violation is detected.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     *
     * @return The finding.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding getFinding() {
      if (resultCase_ == 1) {
        return (com.google.cloud.securitycenter.v1.Finding) result_;
      }
      return com.google.cloud.securitycenter.v1.Finding.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Finding that would be published for the test case,
     * if a violation is detected.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.FindingOrBuilder getFindingOrBuilder() {
      if (resultCase_ == 1) {
        return (com.google.cloud.securitycenter.v1.Finding) result_;
      }
      return com.google.cloud.securitycenter.v1.Finding.getDefaultInstance();
    }

    public static final int NO_VIOLATION_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Indicates that the test case does not trigger any violation.
     * </pre>
     *
     * <code>.google.protobuf.Empty no_violation = 2;</code>
     *
     * @return Whether the noViolation field is set.
     */
    @java.lang.Override
    public boolean hasNoViolation() {
      return resultCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the test case does not trigger any violation.
     * </pre>
     *
     * <code>.google.protobuf.Empty no_violation = 2;</code>
     *
     * @return The noViolation.
     */
    @java.lang.Override
    public com.google.protobuf.Empty getNoViolation() {
      if (resultCase_ == 2) {
        return (com.google.protobuf.Empty) result_;
      }
      return com.google.protobuf.Empty.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Indicates that the test case does not trigger any violation.
     * </pre>
     *
     * <code>.google.protobuf.Empty no_violation = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.EmptyOrBuilder getNoViolationOrBuilder() {
      if (resultCase_ == 2) {
        return (com.google.protobuf.Empty) result_;
      }
      return com.google.protobuf.Empty.getDefaultInstance();
    }

    public static final int ERROR_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Error encountered during the test.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return resultCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Error encountered during the test.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return The error.
     */
    @java.lang.Override
    public com.google.rpc.Status getError() {
      if (resultCase_ == 3) {
        return (com.google.rpc.Status) result_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Error encountered during the test.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (resultCase_ == 3) {
        return (com.google.rpc.Status) result_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (resultCase_ == 1) {
        output.writeMessage(1, (com.google.cloud.securitycenter.v1.Finding) result_);
      }
      if (resultCase_ == 2) {
        output.writeMessage(2, (com.google.protobuf.Empty) result_);
      }
      if (resultCase_ == 3) {
        output.writeMessage(3, (com.google.rpc.Status) result_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (resultCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.securitycenter.v1.Finding) result_);
      }
      if (resultCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.protobuf.Empty) result_);
      }
      if (resultCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.rpc.Status) result_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
              .SimulatedResult)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
              .SimulatedResult
          other =
              (com.google.cloud.securitycenter.v1
                      .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult)
                  obj;

      if (!getResultCase().equals(other.getResultCase())) return false;
      switch (resultCase_) {
        case 1:
          if (!getFinding().equals(other.getFinding())) return false;
          break;
        case 2:
          if (!getNoViolation().equals(other.getNoViolation())) return false;
          break;
        case 3:
          if (!getError().equals(other.getError())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (resultCase_) {
        case 1:
          hash = (37 * hash) + FINDING_FIELD_NUMBER;
          hash = (53 * hash) + getFinding().hashCode();
          break;
        case 2:
          hash = (37 * hash) + NO_VIOLATION_FIELD_NUMBER;
          hash = (53 * hash) + getNoViolation().hashCode();
          break;
        case 3:
          hash = (37 * hash) + ERROR_FIELD_NUMBER;
          hash = (53 * hash) + getError().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Possible test result.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult)
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            .SimulatedResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.class,
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (findingBuilder_ != null) {
          findingBuilder_.clear();
        }
        if (noViolationBuilder_ != null) {
          noViolationBuilder_.clear();
        }
        if (errorBuilder_ != null) {
          errorBuilder_.clear();
        }
        resultCase_ = 0;
        result_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
              .SimulatedResult
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
              .SimulatedResult
          build() {
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
              .SimulatedResult
          buildPartial() {
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult
            result =
                new com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                  .SimulatedResult
              result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                  .SimulatedResult
              result) {
        result.resultCase_ = resultCase_;
        result.result_ = this.result_;
        if (resultCase_ == 1 && findingBuilder_ != null) {
          result.result_ = findingBuilder_.build();
        }
        if (resultCase_ == 2 && noViolationBuilder_ != null) {
          result.result_ = noViolationBuilder_.build();
        }
        if (resultCase_ == 3 && errorBuilder_ != null) {
          result.result_ = errorBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1
                      .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                  .SimulatedResult
              other) {
        if (other
            == com.google.cloud.securitycenter.v1
                .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
                .getDefaultInstance()) return this;
        switch (other.getResultCase()) {
          case FINDING:
            {
              mergeFinding(other.getFinding());
              break;
            }
          case NO_VIOLATION:
            {
              mergeNoViolation(other.getNoViolation());
              break;
            }
          case ERROR:
            {
              mergeError(other.getError());
              break;
            }
          case RESULT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getFindingFieldBuilder().getBuilder(), extensionRegistry);
                  resultCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getNoViolationFieldBuilder().getBuilder(), extensionRegistry);
                  resultCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                  resultCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int resultCase_ = 0;
      private java.lang.Object result_;

      public ResultCase getResultCase() {
        return ResultCase.forNumber(resultCase_);
      }

      public Builder clearResult() {
        resultCase_ = 0;
        result_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Finding,
              com.google.cloud.securitycenter.v1.Finding.Builder,
              com.google.cloud.securitycenter.v1.FindingOrBuilder>
          findingBuilder_;
      /**
       *
       *
       * <pre>
       * Finding that would be published for the test case,
       * if a violation is detected.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       *
       * @return Whether the finding field is set.
       */
      @java.lang.Override
      public boolean hasFinding() {
        return resultCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Finding that would be published for the test case,
       * if a violation is detected.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       *
       * @return The finding.
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.Finding getFinding() {
        if (findingBuilder_ == null) {
          if (resultCase_ == 1) {
            return (com.google.cloud.securitycenter.v1.Finding) result_;
          }
          return com.google.cloud.securitycenter.v1.Finding.getDefaultInstance();
        } else {
          if (resultCase_ == 1) {
            return findingBuilder_.getMessage();
          }
          return com.google.cloud.securitycenter.v1.Finding.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Finding that would be published for the test case,
       * if a violation is detected.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public Builder setFinding(com.google.cloud.securitycenter.v1.Finding value) {
        if (findingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          result_ = value;
          onChanged();
        } else {
          findingBuilder_.setMessage(value);
        }
        resultCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Finding that would be published for the test case,
       * if a violation is detected.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public Builder setFinding(
          com.google.cloud.securitycenter.v1.Finding.Builder builderForValue) {
        if (findingBuilder_ == null) {
          result_ = builderForValue.build();
          onChanged();
        } else {
          findingBuilder_.setMessage(builderForValue.build());
        }
        resultCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Finding that would be published for the test case,
       * if a violation is detected.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public Builder mergeFinding(com.google.cloud.securitycenter.v1.Finding value) {
        if (findingBuilder_ == null) {
          if (resultCase_ == 1
              && result_ != com.google.cloud.securitycenter.v1.Finding.getDefaultInstance()) {
            result_ =
                com.google.cloud.securitycenter.v1.Finding.newBuilder(
                        (com.google.cloud.securitycenter.v1.Finding) result_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            result_ = value;
          }
          onChanged();
        } else {
          if (resultCase_ == 1) {
            findingBuilder_.mergeFrom(value);
          } else {
            findingBuilder_.setMessage(value);
          }
        }
        resultCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Finding that would be published for the test case,
       * if a violation is detected.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public Builder clearFinding() {
        if (findingBuilder_ == null) {
          if (resultCase_ == 1) {
            resultCase_ = 0;
            result_ = null;
            onChanged();
          }
        } else {
          if (resultCase_ == 1) {
            resultCase_ = 0;
            result_ = null;
          }
          findingBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Finding that would be published for the test case,
       * if a violation is detected.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      public com.google.cloud.securitycenter.v1.Finding.Builder getFindingBuilder() {
        return getFindingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Finding that would be published for the test case,
       * if a violation is detected.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1.FindingOrBuilder getFindingOrBuilder() {
        if ((resultCase_ == 1) && (findingBuilder_ != null)) {
          return findingBuilder_.getMessageOrBuilder();
        } else {
          if (resultCase_ == 1) {
            return (com.google.cloud.securitycenter.v1.Finding) result_;
          }
          return com.google.cloud.securitycenter.v1.Finding.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Finding that would be published for the test case,
       * if a violation is detected.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1.Finding finding = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1.Finding,
              com.google.cloud.securitycenter.v1.Finding.Builder,
              com.google.cloud.securitycenter.v1.FindingOrBuilder>
          getFindingFieldBuilder() {
        if (findingBuilder_ == null) {
          if (!(resultCase_ == 1)) {
            result_ = com.google.cloud.securitycenter.v1.Finding.getDefaultInstance();
          }
          findingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.securitycenter.v1.Finding,
                  com.google.cloud.securitycenter.v1.Finding.Builder,
                  com.google.cloud.securitycenter.v1.FindingOrBuilder>(
                  (com.google.cloud.securitycenter.v1.Finding) result_,
                  getParentForChildren(),
                  isClean());
          result_ = null;
        }
        resultCase_ = 1;
        onChanged();
        return findingBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Empty,
              com.google.protobuf.Empty.Builder,
              com.google.protobuf.EmptyOrBuilder>
          noViolationBuilder_;
      /**
       *
       *
       * <pre>
       * Indicates that the test case does not trigger any violation.
       * </pre>
       *
       * <code>.google.protobuf.Empty no_violation = 2;</code>
       *
       * @return Whether the noViolation field is set.
       */
      @java.lang.Override
      public boolean hasNoViolation() {
        return resultCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the test case does not trigger any violation.
       * </pre>
       *
       * <code>.google.protobuf.Empty no_violation = 2;</code>
       *
       * @return The noViolation.
       */
      @java.lang.Override
      public com.google.protobuf.Empty getNoViolation() {
        if (noViolationBuilder_ == null) {
          if (resultCase_ == 2) {
            return (com.google.protobuf.Empty) result_;
          }
          return com.google.protobuf.Empty.getDefaultInstance();
        } else {
          if (resultCase_ == 2) {
            return noViolationBuilder_.getMessage();
          }
          return com.google.protobuf.Empty.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates that the test case does not trigger any violation.
       * </pre>
       *
       * <code>.google.protobuf.Empty no_violation = 2;</code>
       */
      public Builder setNoViolation(com.google.protobuf.Empty value) {
        if (noViolationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          result_ = value;
          onChanged();
        } else {
          noViolationBuilder_.setMessage(value);
        }
        resultCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the test case does not trigger any violation.
       * </pre>
       *
       * <code>.google.protobuf.Empty no_violation = 2;</code>
       */
      public Builder setNoViolation(com.google.protobuf.Empty.Builder builderForValue) {
        if (noViolationBuilder_ == null) {
          result_ = builderForValue.build();
          onChanged();
        } else {
          noViolationBuilder_.setMessage(builderForValue.build());
        }
        resultCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the test case does not trigger any violation.
       * </pre>
       *
       * <code>.google.protobuf.Empty no_violation = 2;</code>
       */
      public Builder mergeNoViolation(com.google.protobuf.Empty value) {
        if (noViolationBuilder_ == null) {
          if (resultCase_ == 2 && result_ != com.google.protobuf.Empty.getDefaultInstance()) {
            result_ =
                com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) result_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            result_ = value;
          }
          onChanged();
        } else {
          if (resultCase_ == 2) {
            noViolationBuilder_.mergeFrom(value);
          } else {
            noViolationBuilder_.setMessage(value);
          }
        }
        resultCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the test case does not trigger any violation.
       * </pre>
       *
       * <code>.google.protobuf.Empty no_violation = 2;</code>
       */
      public Builder clearNoViolation() {
        if (noViolationBuilder_ == null) {
          if (resultCase_ == 2) {
            resultCase_ = 0;
            result_ = null;
            onChanged();
          }
        } else {
          if (resultCase_ == 2) {
            resultCase_ = 0;
            result_ = null;
          }
          noViolationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the test case does not trigger any violation.
       * </pre>
       *
       * <code>.google.protobuf.Empty no_violation = 2;</code>
       */
      public com.google.protobuf.Empty.Builder getNoViolationBuilder() {
        return getNoViolationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Indicates that the test case does not trigger any violation.
       * </pre>
       *
       * <code>.google.protobuf.Empty no_violation = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.EmptyOrBuilder getNoViolationOrBuilder() {
        if ((resultCase_ == 2) && (noViolationBuilder_ != null)) {
          return noViolationBuilder_.getMessageOrBuilder();
        } else {
          if (resultCase_ == 2) {
            return (com.google.protobuf.Empty) result_;
          }
          return com.google.protobuf.Empty.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates that the test case does not trigger any violation.
       * </pre>
       *
       * <code>.google.protobuf.Empty no_violation = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Empty,
              com.google.protobuf.Empty.Builder,
              com.google.protobuf.EmptyOrBuilder>
          getNoViolationFieldBuilder() {
        if (noViolationBuilder_ == null) {
          if (!(resultCase_ == 2)) {
            result_ = com.google.protobuf.Empty.getDefaultInstance();
          }
          noViolationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Empty,
                  com.google.protobuf.Empty.Builder,
                  com.google.protobuf.EmptyOrBuilder>(
                  (com.google.protobuf.Empty) result_, getParentForChildren(), isClean());
          result_ = null;
        }
        resultCase_ = 2;
        onChanged();
        return noViolationBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          errorBuilder_;
      /**
       *
       *
       * <pre>
       * Error encountered during the test.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       *
       * @return Whether the error field is set.
       */
      @java.lang.Override
      public boolean hasError() {
        return resultCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Error encountered during the test.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       *
       * @return The error.
       */
      @java.lang.Override
      public com.google.rpc.Status getError() {
        if (errorBuilder_ == null) {
          if (resultCase_ == 3) {
            return (com.google.rpc.Status) result_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        } else {
          if (resultCase_ == 3) {
            return errorBuilder_.getMessage();
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Error encountered during the test.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public Builder setError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          result_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        resultCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error encountered during the test.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public Builder setError(com.google.rpc.Status.Builder builderForValue) {
        if (errorBuilder_ == null) {
          result_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        resultCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error encountered during the test.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public Builder mergeError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (resultCase_ == 3 && result_ != com.google.rpc.Status.getDefaultInstance()) {
            result_ =
                com.google.rpc.Status.newBuilder((com.google.rpc.Status) result_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            result_ = value;
          }
          onChanged();
        } else {
          if (resultCase_ == 3) {
            errorBuilder_.mergeFrom(value);
          } else {
            errorBuilder_.setMessage(value);
          }
        }
        resultCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error encountered during the test.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          if (resultCase_ == 3) {
            resultCase_ = 0;
            result_ = null;
            onChanged();
          }
        } else {
          if (resultCase_ == 3) {
            resultCase_ = 0;
            result_ = null;
          }
          errorBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error encountered during the test.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public com.google.rpc.Status.Builder getErrorBuilder() {
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Error encountered during the test.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      @java.lang.Override
      public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
        if ((resultCase_ == 3) && (errorBuilder_ != null)) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          if (resultCase_ == 3) {
            return (com.google.rpc.Status) result_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Error encountered during the test.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          if (!(resultCase_ == 3)) {
            result_ = com.google.rpc.Status.getDefaultInstance();
          }
          errorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(
                  (com.google.rpc.Status) result_, getParentForChildren(), isClean());
          result_ = null;
        }
        resultCase_ = 3;
        onChanged();
        return errorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult)
    private static final com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
              .SimulatedResult();
    }

    public static com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SimulatedResult> PARSER =
        new com.google.protobuf.AbstractParser<SimulatedResult>() {
          @java.lang.Override
          public SimulatedResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SimulatedResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SimulatedResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            .SimulatedResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int RESULT_FIELD_NUMBER = 1;
  private com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
          .SimulatedResult
      result_;
  /**
   *
   *
   * <pre>
   * Result for test case in the corresponding request.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
   * </code>
   *
   * @return Whether the result field is set.
   */
  @java.lang.Override
  public boolean hasResult() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Result for test case in the corresponding request.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
   * </code>
   *
   * @return The result.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
          .SimulatedResult
      getResult() {
    return result_ == null
        ? com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            .SimulatedResult.getDefaultInstance()
        : result_;
  }
  /**
   *
   *
   * <pre>
   * Result for test case in the corresponding request.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
          .SimulatedResultOrBuilder
      getResultOrBuilder() {
    return result_ == null
        ? com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            .SimulatedResult.getDefaultInstance()
        : result_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getResult());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getResult());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse other =
        (com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse)
            obj;

    if (hasResult() != other.hasResult()) return false;
    if (hasResult()) {
      if (!getResult().equals(other.getResult())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasResult()) {
      hash = (37 * hash) + RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getResult().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for simulating a `SecurityHealthAnalyticsCustomModule`
   * against a given resource.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse)
      com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                  .class,
              com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      result_ = null;
      if (resultBuilder_ != null) {
        resultBuilder_.dispose();
        resultBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1_SimulateSecurityHealthAnalyticsCustomModuleResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
        getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
        build() {
      com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
        buildPartial() {
      com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
          result =
              new com.google.cloud.securitycenter.v1
                  .SimulateSecurityHealthAnalyticsCustomModuleResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.result_ = resultBuilder_ == null ? result_ : resultBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse) {
        return mergeFrom(
            (com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            other) {
      if (other
          == com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
              .getDefaultInstance()) return this;
      if (other.hasResult()) {
        mergeResult(other.getResult());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            .SimulatedResult
        result_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult.Builder,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResultOrBuilder>
        resultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for test case in the corresponding request.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
     * </code>
     *
     * @return Whether the result field is set.
     */
    public boolean hasResult() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Result for test case in the corresponding request.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
     * </code>
     *
     * @return The result.
     */
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            .SimulatedResult
        getResult() {
      if (resultBuilder_ == null) {
        return result_ == null
            ? com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult.getDefaultInstance()
            : result_;
      } else {
        return resultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for test case in the corresponding request.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
     * </code>
     */
    public Builder setResult(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult
            value) {
      if (resultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
      } else {
        resultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for test case in the corresponding request.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
     * </code>
     */
    public Builder setResult(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult.Builder
            builderForValue) {
      if (resultBuilder_ == null) {
        result_ = builderForValue.build();
      } else {
        resultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for test case in the corresponding request.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
     * </code>
     */
    public Builder mergeResult(
        com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult
            value) {
      if (resultBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && result_ != null
            && result_
                != com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
                    .getDefaultInstance()) {
          getResultBuilder().mergeFrom(value);
        } else {
          result_ = value;
        }
      } else {
        resultBuilder_.mergeFrom(value);
      }
      if (result_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for test case in the corresponding request.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
     * </code>
     */
    public Builder clearResult() {
      bitField0_ = (bitField0_ & ~0x00000001);
      result_ = null;
      if (resultBuilder_ != null) {
        resultBuilder_.dispose();
        resultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for test case in the corresponding request.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            .SimulatedResult.Builder
        getResultBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for test case in the corresponding request.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
            .SimulatedResultOrBuilder
        getResultOrBuilder() {
      if (resultBuilder_ != null) {
        return resultBuilder_.getMessageOrBuilder();
      } else {
        return result_ == null
            ? com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult.getDefaultInstance()
            : result_;
      }
    }
    /**
     *
     *
     * <pre>
     * Result for test case in the corresponding request.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult result = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResult.Builder,
            com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
                .SimulatedResultOrBuilder>
        getResultFieldBuilder() {
      if (resultBuilder_ == null) {
        resultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult,
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.Builder,
                com.google.cloud.securitycenter.v1
                    .SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResultOrBuilder>(
                getResult(), getParentForChildren(), isClean());
        result_ = null;
      }
      return resultBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse)
  private static final com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.securitycenter.v1
            .SimulateSecurityHealthAnalyticsCustomModuleResponse();
  }

  public static com.google.cloud.securitycenter.v1
          .SimulateSecurityHealthAnalyticsCustomModuleResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          SimulateSecurityHealthAnalyticsCustomModuleResponse>
      PARSER =
          new com.google.protobuf.AbstractParser<
              SimulateSecurityHealthAnalyticsCustomModuleResponse>() {
            @java.lang.Override
            public SimulateSecurityHealthAnalyticsCustomModuleResponse parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<SimulateSecurityHealthAnalyticsCustomModuleResponse>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SimulateSecurityHealthAnalyticsCustomModuleResponse>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
