/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/vulnerability.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Refers to common vulnerability fields e.g. cve, cvss, cwe etc.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Vulnerability}
 */
public final class Vulnerability extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Vulnerability)
    VulnerabilityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Vulnerability.newBuilder() to construct.
  private Vulnerability(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Vulnerability() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Vulnerability();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.VulnerabilityProto
        .internal_static_google_cloud_securitycenter_v1_Vulnerability_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.VulnerabilityProto
        .internal_static_google_cloud_securitycenter_v1_Vulnerability_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Vulnerability.class,
            com.google.cloud.securitycenter.v1.Vulnerability.Builder.class);
  }

  private int bitField0_;
  public static final int CVE_FIELD_NUMBER = 1;
  private com.google.cloud.securitycenter.v1.Cve cve_;
  /**
   *
   *
   * <pre>
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
   *
   * @return Whether the cve field is set.
   */
  @java.lang.Override
  public boolean hasCve() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
   *
   * @return The cve.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Cve getCve() {
    return cve_ == null ? com.google.cloud.securitycenter.v1.Cve.getDefaultInstance() : cve_;
  }
  /**
   *
   *
   * <pre>
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.CveOrBuilder getCveOrBuilder() {
    return cve_ == null ? com.google.cloud.securitycenter.v1.Cve.getDefaultInstance() : cve_;
  }

  public static final int OFFENDING_PACKAGE_FIELD_NUMBER = 2;
  private com.google.cloud.securitycenter.v1.Package offendingPackage_;
  /**
   *
   *
   * <pre>
   * The offending package is relevant to the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
   *
   * @return Whether the offendingPackage field is set.
   */
  @java.lang.Override
  public boolean hasOffendingPackage() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The offending package is relevant to the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
   *
   * @return The offendingPackage.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Package getOffendingPackage() {
    return offendingPackage_ == null
        ? com.google.cloud.securitycenter.v1.Package.getDefaultInstance()
        : offendingPackage_;
  }
  /**
   *
   *
   * <pre>
   * The offending package is relevant to the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.PackageOrBuilder getOffendingPackageOrBuilder() {
    return offendingPackage_ == null
        ? com.google.cloud.securitycenter.v1.Package.getDefaultInstance()
        : offendingPackage_;
  }

  public static final int FIXED_PACKAGE_FIELD_NUMBER = 3;
  private com.google.cloud.securitycenter.v1.Package fixedPackage_;
  /**
   *
   *
   * <pre>
   * The fixed package is relevant to the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
   *
   * @return Whether the fixedPackage field is set.
   */
  @java.lang.Override
  public boolean hasFixedPackage() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The fixed package is relevant to the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
   *
   * @return The fixedPackage.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Package getFixedPackage() {
    return fixedPackage_ == null
        ? com.google.cloud.securitycenter.v1.Package.getDefaultInstance()
        : fixedPackage_;
  }
  /**
   *
   *
   * <pre>
   * The fixed package is relevant to the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.PackageOrBuilder getFixedPackageOrBuilder() {
    return fixedPackage_ == null
        ? com.google.cloud.securitycenter.v1.Package.getDefaultInstance()
        : fixedPackage_;
  }

  public static final int SECURITY_BULLETIN_FIELD_NUMBER = 4;
  private com.google.cloud.securitycenter.v1.SecurityBulletin securityBulletin_;
  /**
   *
   *
   * <pre>
   * The security bulletin is relevant to this finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
   *
   * @return Whether the securityBulletin field is set.
   */
  @java.lang.Override
  public boolean hasSecurityBulletin() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The security bulletin is relevant to this finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
   *
   * @return The securityBulletin.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityBulletin getSecurityBulletin() {
    return securityBulletin_ == null
        ? com.google.cloud.securitycenter.v1.SecurityBulletin.getDefaultInstance()
        : securityBulletin_;
  }
  /**
   *
   *
   * <pre>
   * The security bulletin is relevant to this finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityBulletinOrBuilder
      getSecurityBulletinOrBuilder() {
    return securityBulletin_ == null
        ? com.google.cloud.securitycenter.v1.SecurityBulletin.getDefaultInstance()
        : securityBulletin_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCve());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getOffendingPackage());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getFixedPackage());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(4, getSecurityBulletin());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCve());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOffendingPackage());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFixedPackage());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSecurityBulletin());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Vulnerability)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Vulnerability other =
        (com.google.cloud.securitycenter.v1.Vulnerability) obj;

    if (hasCve() != other.hasCve()) return false;
    if (hasCve()) {
      if (!getCve().equals(other.getCve())) return false;
    }
    if (hasOffendingPackage() != other.hasOffendingPackage()) return false;
    if (hasOffendingPackage()) {
      if (!getOffendingPackage().equals(other.getOffendingPackage())) return false;
    }
    if (hasFixedPackage() != other.hasFixedPackage()) return false;
    if (hasFixedPackage()) {
      if (!getFixedPackage().equals(other.getFixedPackage())) return false;
    }
    if (hasSecurityBulletin() != other.hasSecurityBulletin()) return false;
    if (hasSecurityBulletin()) {
      if (!getSecurityBulletin().equals(other.getSecurityBulletin())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCve()) {
      hash = (37 * hash) + CVE_FIELD_NUMBER;
      hash = (53 * hash) + getCve().hashCode();
    }
    if (hasOffendingPackage()) {
      hash = (37 * hash) + OFFENDING_PACKAGE_FIELD_NUMBER;
      hash = (53 * hash) + getOffendingPackage().hashCode();
    }
    if (hasFixedPackage()) {
      hash = (37 * hash) + FIXED_PACKAGE_FIELD_NUMBER;
      hash = (53 * hash) + getFixedPackage().hashCode();
    }
    if (hasSecurityBulletin()) {
      hash = (37 * hash) + SECURITY_BULLETIN_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityBulletin().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Vulnerability prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Refers to common vulnerability fields e.g. cve, cvss, cwe etc.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Vulnerability}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Vulnerability)
      com.google.cloud.securitycenter.v1.VulnerabilityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.VulnerabilityProto
          .internal_static_google_cloud_securitycenter_v1_Vulnerability_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.VulnerabilityProto
          .internal_static_google_cloud_securitycenter_v1_Vulnerability_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Vulnerability.class,
              com.google.cloud.securitycenter.v1.Vulnerability.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Vulnerability.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCveFieldBuilder();
        getOffendingPackageFieldBuilder();
        getFixedPackageFieldBuilder();
        getSecurityBulletinFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cve_ = null;
      if (cveBuilder_ != null) {
        cveBuilder_.dispose();
        cveBuilder_ = null;
      }
      offendingPackage_ = null;
      if (offendingPackageBuilder_ != null) {
        offendingPackageBuilder_.dispose();
        offendingPackageBuilder_ = null;
      }
      fixedPackage_ = null;
      if (fixedPackageBuilder_ != null) {
        fixedPackageBuilder_.dispose();
        fixedPackageBuilder_ = null;
      }
      securityBulletin_ = null;
      if (securityBulletinBuilder_ != null) {
        securityBulletinBuilder_.dispose();
        securityBulletinBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.VulnerabilityProto
          .internal_static_google_cloud_securitycenter_v1_Vulnerability_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Vulnerability getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Vulnerability.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Vulnerability build() {
      com.google.cloud.securitycenter.v1.Vulnerability result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Vulnerability buildPartial() {
      com.google.cloud.securitycenter.v1.Vulnerability result =
          new com.google.cloud.securitycenter.v1.Vulnerability(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1.Vulnerability result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cve_ = cveBuilder_ == null ? cve_ : cveBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.offendingPackage_ =
            offendingPackageBuilder_ == null ? offendingPackage_ : offendingPackageBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.fixedPackage_ =
            fixedPackageBuilder_ == null ? fixedPackage_ : fixedPackageBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.securityBulletin_ =
            securityBulletinBuilder_ == null ? securityBulletin_ : securityBulletinBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Vulnerability) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Vulnerability) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Vulnerability other) {
      if (other == com.google.cloud.securitycenter.v1.Vulnerability.getDefaultInstance())
        return this;
      if (other.hasCve()) {
        mergeCve(other.getCve());
      }
      if (other.hasOffendingPackage()) {
        mergeOffendingPackage(other.getOffendingPackage());
      }
      if (other.hasFixedPackage()) {
        mergeFixedPackage(other.getFixedPackage());
      }
      if (other.hasSecurityBulletin()) {
        mergeSecurityBulletin(other.getSecurityBulletin());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCveFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getOffendingPackageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getFixedPackageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getSecurityBulletinFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.securitycenter.v1.Cve cve_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Cve,
            com.google.cloud.securitycenter.v1.Cve.Builder,
            com.google.cloud.securitycenter.v1.CveOrBuilder>
        cveBuilder_;
    /**
     *
     *
     * <pre>
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
     *
     * @return Whether the cve field is set.
     */
    public boolean hasCve() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
     *
     * @return The cve.
     */
    public com.google.cloud.securitycenter.v1.Cve getCve() {
      if (cveBuilder_ == null) {
        return cve_ == null ? com.google.cloud.securitycenter.v1.Cve.getDefaultInstance() : cve_;
      } else {
        return cveBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
     */
    public Builder setCve(com.google.cloud.securitycenter.v1.Cve value) {
      if (cveBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cve_ = value;
      } else {
        cveBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
     */
    public Builder setCve(com.google.cloud.securitycenter.v1.Cve.Builder builderForValue) {
      if (cveBuilder_ == null) {
        cve_ = builderForValue.build();
      } else {
        cveBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
     */
    public Builder mergeCve(com.google.cloud.securitycenter.v1.Cve value) {
      if (cveBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && cve_ != null
            && cve_ != com.google.cloud.securitycenter.v1.Cve.getDefaultInstance()) {
          getCveBuilder().mergeFrom(value);
        } else {
          cve_ = value;
        }
      } else {
        cveBuilder_.mergeFrom(value);
      }
      if (cve_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
     */
    public Builder clearCve() {
      bitField0_ = (bitField0_ & ~0x00000001);
      cve_ = null;
      if (cveBuilder_ != null) {
        cveBuilder_.dispose();
        cveBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.Cve.Builder getCveBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCveFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
     */
    public com.google.cloud.securitycenter.v1.CveOrBuilder getCveOrBuilder() {
      if (cveBuilder_ != null) {
        return cveBuilder_.getMessageOrBuilder();
      } else {
        return cve_ == null ? com.google.cloud.securitycenter.v1.Cve.getDefaultInstance() : cve_;
      }
    }
    /**
     *
     *
     * <pre>
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Cve cve = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Cve,
            com.google.cloud.securitycenter.v1.Cve.Builder,
            com.google.cloud.securitycenter.v1.CveOrBuilder>
        getCveFieldBuilder() {
      if (cveBuilder_ == null) {
        cveBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Cve,
                com.google.cloud.securitycenter.v1.Cve.Builder,
                com.google.cloud.securitycenter.v1.CveOrBuilder>(
                getCve(), getParentForChildren(), isClean());
        cve_ = null;
      }
      return cveBuilder_;
    }

    private com.google.cloud.securitycenter.v1.Package offendingPackage_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Package,
            com.google.cloud.securitycenter.v1.Package.Builder,
            com.google.cloud.securitycenter.v1.PackageOrBuilder>
        offendingPackageBuilder_;
    /**
     *
     *
     * <pre>
     * The offending package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
     *
     * @return Whether the offendingPackage field is set.
     */
    public boolean hasOffendingPackage() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The offending package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
     *
     * @return The offendingPackage.
     */
    public com.google.cloud.securitycenter.v1.Package getOffendingPackage() {
      if (offendingPackageBuilder_ == null) {
        return offendingPackage_ == null
            ? com.google.cloud.securitycenter.v1.Package.getDefaultInstance()
            : offendingPackage_;
      } else {
        return offendingPackageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The offending package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
     */
    public Builder setOffendingPackage(com.google.cloud.securitycenter.v1.Package value) {
      if (offendingPackageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        offendingPackage_ = value;
      } else {
        offendingPackageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The offending package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
     */
    public Builder setOffendingPackage(
        com.google.cloud.securitycenter.v1.Package.Builder builderForValue) {
      if (offendingPackageBuilder_ == null) {
        offendingPackage_ = builderForValue.build();
      } else {
        offendingPackageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The offending package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
     */
    public Builder mergeOffendingPackage(com.google.cloud.securitycenter.v1.Package value) {
      if (offendingPackageBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && offendingPackage_ != null
            && offendingPackage_
                != com.google.cloud.securitycenter.v1.Package.getDefaultInstance()) {
          getOffendingPackageBuilder().mergeFrom(value);
        } else {
          offendingPackage_ = value;
        }
      } else {
        offendingPackageBuilder_.mergeFrom(value);
      }
      if (offendingPackage_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The offending package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
     */
    public Builder clearOffendingPackage() {
      bitField0_ = (bitField0_ & ~0x00000002);
      offendingPackage_ = null;
      if (offendingPackageBuilder_ != null) {
        offendingPackageBuilder_.dispose();
        offendingPackageBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The offending package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.Package.Builder getOffendingPackageBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getOffendingPackageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The offending package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
     */
    public com.google.cloud.securitycenter.v1.PackageOrBuilder getOffendingPackageOrBuilder() {
      if (offendingPackageBuilder_ != null) {
        return offendingPackageBuilder_.getMessageOrBuilder();
      } else {
        return offendingPackage_ == null
            ? com.google.cloud.securitycenter.v1.Package.getDefaultInstance()
            : offendingPackage_;
      }
    }
    /**
     *
     *
     * <pre>
     * The offending package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package offending_package = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Package,
            com.google.cloud.securitycenter.v1.Package.Builder,
            com.google.cloud.securitycenter.v1.PackageOrBuilder>
        getOffendingPackageFieldBuilder() {
      if (offendingPackageBuilder_ == null) {
        offendingPackageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Package,
                com.google.cloud.securitycenter.v1.Package.Builder,
                com.google.cloud.securitycenter.v1.PackageOrBuilder>(
                getOffendingPackage(), getParentForChildren(), isClean());
        offendingPackage_ = null;
      }
      return offendingPackageBuilder_;
    }

    private com.google.cloud.securitycenter.v1.Package fixedPackage_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Package,
            com.google.cloud.securitycenter.v1.Package.Builder,
            com.google.cloud.securitycenter.v1.PackageOrBuilder>
        fixedPackageBuilder_;
    /**
     *
     *
     * <pre>
     * The fixed package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
     *
     * @return Whether the fixedPackage field is set.
     */
    public boolean hasFixedPackage() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The fixed package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
     *
     * @return The fixedPackage.
     */
    public com.google.cloud.securitycenter.v1.Package getFixedPackage() {
      if (fixedPackageBuilder_ == null) {
        return fixedPackage_ == null
            ? com.google.cloud.securitycenter.v1.Package.getDefaultInstance()
            : fixedPackage_;
      } else {
        return fixedPackageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The fixed package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
     */
    public Builder setFixedPackage(com.google.cloud.securitycenter.v1.Package value) {
      if (fixedPackageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fixedPackage_ = value;
      } else {
        fixedPackageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fixed package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
     */
    public Builder setFixedPackage(
        com.google.cloud.securitycenter.v1.Package.Builder builderForValue) {
      if (fixedPackageBuilder_ == null) {
        fixedPackage_ = builderForValue.build();
      } else {
        fixedPackageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fixed package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
     */
    public Builder mergeFixedPackage(com.google.cloud.securitycenter.v1.Package value) {
      if (fixedPackageBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && fixedPackage_ != null
            && fixedPackage_ != com.google.cloud.securitycenter.v1.Package.getDefaultInstance()) {
          getFixedPackageBuilder().mergeFrom(value);
        } else {
          fixedPackage_ = value;
        }
      } else {
        fixedPackageBuilder_.mergeFrom(value);
      }
      if (fixedPackage_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fixed package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
     */
    public Builder clearFixedPackage() {
      bitField0_ = (bitField0_ & ~0x00000004);
      fixedPackage_ = null;
      if (fixedPackageBuilder_ != null) {
        fixedPackageBuilder_.dispose();
        fixedPackageBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fixed package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.Package.Builder getFixedPackageBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getFixedPackageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The fixed package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
     */
    public com.google.cloud.securitycenter.v1.PackageOrBuilder getFixedPackageOrBuilder() {
      if (fixedPackageBuilder_ != null) {
        return fixedPackageBuilder_.getMessageOrBuilder();
      } else {
        return fixedPackage_ == null
            ? com.google.cloud.securitycenter.v1.Package.getDefaultInstance()
            : fixedPackage_;
      }
    }
    /**
     *
     *
     * <pre>
     * The fixed package is relevant to the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Package fixed_package = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.Package,
            com.google.cloud.securitycenter.v1.Package.Builder,
            com.google.cloud.securitycenter.v1.PackageOrBuilder>
        getFixedPackageFieldBuilder() {
      if (fixedPackageBuilder_ == null) {
        fixedPackageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.Package,
                com.google.cloud.securitycenter.v1.Package.Builder,
                com.google.cloud.securitycenter.v1.PackageOrBuilder>(
                getFixedPackage(), getParentForChildren(), isClean());
        fixedPackage_ = null;
      }
      return fixedPackageBuilder_;
    }

    private com.google.cloud.securitycenter.v1.SecurityBulletin securityBulletin_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SecurityBulletin,
            com.google.cloud.securitycenter.v1.SecurityBulletin.Builder,
            com.google.cloud.securitycenter.v1.SecurityBulletinOrBuilder>
        securityBulletinBuilder_;
    /**
     *
     *
     * <pre>
     * The security bulletin is relevant to this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
     *
     * @return Whether the securityBulletin field is set.
     */
    public boolean hasSecurityBulletin() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The security bulletin is relevant to this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
     *
     * @return The securityBulletin.
     */
    public com.google.cloud.securitycenter.v1.SecurityBulletin getSecurityBulletin() {
      if (securityBulletinBuilder_ == null) {
        return securityBulletin_ == null
            ? com.google.cloud.securitycenter.v1.SecurityBulletin.getDefaultInstance()
            : securityBulletin_;
      } else {
        return securityBulletinBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The security bulletin is relevant to this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
     */
    public Builder setSecurityBulletin(com.google.cloud.securitycenter.v1.SecurityBulletin value) {
      if (securityBulletinBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securityBulletin_ = value;
      } else {
        securityBulletinBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The security bulletin is relevant to this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
     */
    public Builder setSecurityBulletin(
        com.google.cloud.securitycenter.v1.SecurityBulletin.Builder builderForValue) {
      if (securityBulletinBuilder_ == null) {
        securityBulletin_ = builderForValue.build();
      } else {
        securityBulletinBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The security bulletin is relevant to this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
     */
    public Builder mergeSecurityBulletin(
        com.google.cloud.securitycenter.v1.SecurityBulletin value) {
      if (securityBulletinBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && securityBulletin_ != null
            && securityBulletin_
                != com.google.cloud.securitycenter.v1.SecurityBulletin.getDefaultInstance()) {
          getSecurityBulletinBuilder().mergeFrom(value);
        } else {
          securityBulletin_ = value;
        }
      } else {
        securityBulletinBuilder_.mergeFrom(value);
      }
      if (securityBulletin_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The security bulletin is relevant to this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
     */
    public Builder clearSecurityBulletin() {
      bitField0_ = (bitField0_ & ~0x00000008);
      securityBulletin_ = null;
      if (securityBulletinBuilder_ != null) {
        securityBulletinBuilder_.dispose();
        securityBulletinBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The security bulletin is relevant to this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.SecurityBulletin.Builder
        getSecurityBulletinBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSecurityBulletinFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The security bulletin is relevant to this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
     */
    public com.google.cloud.securitycenter.v1.SecurityBulletinOrBuilder
        getSecurityBulletinOrBuilder() {
      if (securityBulletinBuilder_ != null) {
        return securityBulletinBuilder_.getMessageOrBuilder();
      } else {
        return securityBulletin_ == null
            ? com.google.cloud.securitycenter.v1.SecurityBulletin.getDefaultInstance()
            : securityBulletin_;
      }
    }
    /**
     *
     *
     * <pre>
     * The security bulletin is relevant to this finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.SecurityBulletin security_bulletin = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SecurityBulletin,
            com.google.cloud.securitycenter.v1.SecurityBulletin.Builder,
            com.google.cloud.securitycenter.v1.SecurityBulletinOrBuilder>
        getSecurityBulletinFieldBuilder() {
      if (securityBulletinBuilder_ == null) {
        securityBulletinBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.SecurityBulletin,
                com.google.cloud.securitycenter.v1.SecurityBulletin.Builder,
                com.google.cloud.securitycenter.v1.SecurityBulletinOrBuilder>(
                getSecurityBulletin(), getParentForChildren(), isClean());
        securityBulletin_ = null;
      }
      return securityBulletinBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Vulnerability)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Vulnerability)
  private static final com.google.cloud.securitycenter.v1.Vulnerability DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Vulnerability();
  }

  public static com.google.cloud.securitycenter.v1.Vulnerability getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Vulnerability> PARSER =
      new com.google.protobuf.AbstractParser<Vulnerability>() {
        @java.lang.Override
        public Vulnerability parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Vulnerability> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Vulnerability> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Vulnerability getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
