/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_ASSET = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/assets/{asset}");
    private static final PathTemplate FOLDER_ASSET = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/assets/{asset}");
    private static final PathTemplate PROJECT_ASSET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/assets/{asset}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String asset;
    private final String folder;
    private final String project;

    @Deprecated
    protected AssetName() {
        this.organization = null;
        this.asset = null;
        this.folder = null;
        this.project = null;
    }

    private AssetName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_ASSET;
    }

    private AssetName(FolderAssetBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_ASSET;
    }

    private AssetName(ProjectAssetBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_ASSET;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getAsset() {
        return this.asset;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationAssetBuilder() {
        return new Builder();
    }

    public static FolderAssetBuilder newFolderAssetBuilder() {
        return new FolderAssetBuilder();
    }

    public static ProjectAssetBuilder newProjectAssetBuilder() {
        return new ProjectAssetBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetName of(String organization, String asset) {
        return AssetName.newBuilder().setOrganization(organization).setAsset(asset).build();
    }

    public static AssetName ofOrganizationAssetName(String organization, String asset) {
        return AssetName.newBuilder().setOrganization(organization).setAsset(asset).build();
    }

    public static AssetName ofFolderAssetName(String folder, String asset) {
        return AssetName.newFolderAssetBuilder().setFolder(folder).setAsset(asset).build();
    }

    public static AssetName ofProjectAssetName(String project, String asset) {
        return AssetName.newProjectAssetBuilder().setProject(project).setAsset(asset).build();
    }

    public static String format(String organization, String asset) {
        return AssetName.newBuilder().setOrganization(organization).setAsset(asset).build().toString();
    }

    public static String formatOrganizationAssetName(String organization, String asset) {
        return AssetName.newBuilder().setOrganization(organization).setAsset(asset).build().toString();
    }

    public static String formatFolderAssetName(String folder, String asset) {
        return AssetName.newFolderAssetBuilder().setFolder(folder).setAsset(asset).build().toString();
    }

    public static String formatProjectAssetName(String project, String asset) {
        return AssetName.newProjectAssetBuilder().setProject(project).setAsset(asset).build().toString();
    }

    public static AssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_ASSET.matches(formattedString)) {
            Map matchMap = ORGANIZATION_ASSET.match(formattedString);
            return AssetName.ofOrganizationAssetName((String)matchMap.get("organization"), (String)matchMap.get("asset"));
        }
        if (FOLDER_ASSET.matches(formattedString)) {
            Map matchMap = FOLDER_ASSET.match(formattedString);
            return AssetName.ofFolderAssetName((String)matchMap.get("folder"), (String)matchMap.get("asset"));
        }
        if (PROJECT_ASSET.matches(formattedString)) {
            Map matchMap = PROJECT_ASSET.match(formattedString);
            return AssetName.ofProjectAssetName((String)matchMap.get("project"), (String)matchMap.get("asset"));
        }
        throw new ValidationException("AssetName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AssetName> parseList(List<String> formattedStrings) {
        ArrayList<AssetName> list = new ArrayList<AssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_ASSET.matches(formattedString) || FOLDER_ASSET.matches(formattedString) || PROJECT_ASSET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetName assetName = this;
            synchronized (assetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.asset != null) {
                        fieldMapBuilder.put((Object)"asset", (Object)this.asset);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetName that = (AssetName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.asset, that.asset) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.asset);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectAssetBuilder {
        private String project;
        private String asset;

        protected ProjectAssetBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getAsset() {
            return this.asset;
        }

        public ProjectAssetBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectAssetBuilder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        public AssetName build() {
            return new AssetName(this);
        }
    }

    public static class FolderAssetBuilder {
        private String folder;
        private String asset;

        protected FolderAssetBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getAsset() {
            return this.asset;
        }

        public FolderAssetBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderAssetBuilder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        public AssetName build() {
            return new AssetName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String asset;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getAsset() {
            return this.asset;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        private Builder(AssetName assetName) {
            Preconditions.checkArgument((boolean)Objects.equals(assetName.pathTemplate, ORGANIZATION_ASSET), (Object)"toBuilder is only supported when AssetName has the pattern of organizations/{organization}/assets/{asset}");
            this.organization = assetName.organization;
            this.asset = assetName.asset;
        }

        public AssetName build() {
            return new AssetName(this);
        }
    }
}

