/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1beta1/securitycenter_service.proto

package com.google.cloud.securitycenter.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for listing assets.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1beta1.ListAssetsResponse}
 */
public final class ListAssetsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1beta1.ListAssetsResponse)
    ListAssetsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListAssetsResponse.newBuilder() to construct.
  private ListAssetsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListAssetsResponse() {
    listAssetsResults_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListAssetsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
        .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.class,
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.Builder.class);
  }

  public interface ListAssetsResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Asset matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
     *
     * @return Whether the asset field is set.
     */
    boolean hasAsset();
    /**
     *
     *
     * <pre>
     * Asset matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
     *
     * @return The asset.
     */
    com.google.cloud.securitycenter.v1beta1.Asset getAsset();
    /**
     *
     *
     * <pre>
     * Asset matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
     */
    com.google.cloud.securitycenter.v1beta1.AssetOrBuilder getAssetOrBuilder();

    /**
     *
     *
     * <pre>
     * State of the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State state = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * State of the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State state = 2;
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State getState();
  }
  /**
   *
   *
   * <pre>
   * Result containing the Asset and its State.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult}
   */
  public static final class ListAssetsResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult)
      ListAssetsResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListAssetsResult.newBuilder() to construct.
    private ListAssetsResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListAssetsResult() {
      state_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListAssetsResult();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_ListAssetsResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_ListAssetsResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.class,
              com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * State of the asset.
     * When querying across two points in time this describes
     * the change between the two points: ADDED, REMOVED, or ACTIVE.
     * If there was no compare_duration supplied in the request the state should
     * be: UNUSED
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified state.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Request did not specify use of this field in the result.
       * </pre>
       *
       * <code>UNUSED = 1;</code>
       */
      UNUSED(1),
      /**
       *
       *
       * <pre>
       * Asset was added between the points in time.
       * </pre>
       *
       * <code>ADDED = 2;</code>
       */
      ADDED(2),
      /**
       *
       *
       * <pre>
       * Asset was removed between the points in time.
       * </pre>
       *
       * <code>REMOVED = 3;</code>
       */
      REMOVED(3),
      /**
       *
       *
       * <pre>
       * Asset was active at both point(s) in time.
       * </pre>
       *
       * <code>ACTIVE = 4;</code>
       */
      ACTIVE(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified state.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Request did not specify use of this field in the result.
       * </pre>
       *
       * <code>UNUSED = 1;</code>
       */
      public static final int UNUSED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Asset was added between the points in time.
       * </pre>
       *
       * <code>ADDED = 2;</code>
       */
      public static final int ADDED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Asset was removed between the points in time.
       * </pre>
       *
       * <code>REMOVED = 3;</code>
       */
      public static final int REMOVED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Asset was active at both point(s) in time.
       * </pre>
       *
       * <code>ACTIVE = 4;</code>
       */
      public static final int ACTIVE_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return UNUSED;
          case 2:
            return ADDED;
          case 3:
            return REMOVED;
          case 4:
            return ACTIVE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State)
    }

    public static final int ASSET_FIELD_NUMBER = 1;
    private com.google.cloud.securitycenter.v1beta1.Asset asset_;
    /**
     *
     *
     * <pre>
     * Asset matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
     *
     * @return Whether the asset field is set.
     */
    @java.lang.Override
    public boolean hasAsset() {
      return asset_ != null;
    }
    /**
     *
     *
     * <pre>
     * Asset matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
     *
     * @return The asset.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.Asset getAsset() {
      return asset_ == null
          ? com.google.cloud.securitycenter.v1beta1.Asset.getDefaultInstance()
          : asset_;
    }
    /**
     *
     *
     * <pre>
     * Asset matching the search request.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.AssetOrBuilder getAssetOrBuilder() {
      return getAsset();
    }

    public static final int STATE_FIELD_NUMBER = 2;
    private int state_;
    /**
     *
     *
     * <pre>
     * State of the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State state = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * State of the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State state = 2;
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State
        getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State result =
          com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State.valueOf(
              state_);
      return result == null
          ? com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (asset_ != null) {
        output.writeMessage(1, getAsset());
      }
      if (state_
          != com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, state_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (asset_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAsset());
      }
      if (state_
          != com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult other =
          (com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult) obj;

      if (hasAsset() != other.hasAsset()) return false;
      if (hasAsset()) {
        if (!getAsset().equals(other.getAsset())) return false;
      }
      if (state_ != other.state_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAsset()) {
        hash = (37 * hash) + ASSET_FIELD_NUMBER;
        hash = (53 * hash) + getAsset().hashCode();
      }
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Result containing the Asset and its State.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult)
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_ListAssetsResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_ListAssetsResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.class,
                com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (assetBuilder_ == null) {
          asset_ = null;
        } else {
          asset_ = null;
          assetBuilder_ = null;
        }
        state_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
            .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_ListAssetsResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult build() {
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
          buildPartial() {
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult result =
            new com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult(this);
        if (assetBuilder_ == null) {
          result.asset_ = asset_;
        } else {
          result.asset_ = assetBuilder_.build();
        }
        result.state_ = state_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult other) {
        if (other
            == com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
                .getDefaultInstance()) return this;
        if (other.hasAsset()) {
          mergeAsset(other.getAsset());
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getAssetFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 16:
                {
                  state_ = input.readEnum();

                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.cloud.securitycenter.v1beta1.Asset asset_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1beta1.Asset,
              com.google.cloud.securitycenter.v1beta1.Asset.Builder,
              com.google.cloud.securitycenter.v1beta1.AssetOrBuilder>
          assetBuilder_;
      /**
       *
       *
       * <pre>
       * Asset matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
       *
       * @return Whether the asset field is set.
       */
      public boolean hasAsset() {
        return assetBuilder_ != null || asset_ != null;
      }
      /**
       *
       *
       * <pre>
       * Asset matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
       *
       * @return The asset.
       */
      public com.google.cloud.securitycenter.v1beta1.Asset getAsset() {
        if (assetBuilder_ == null) {
          return asset_ == null
              ? com.google.cloud.securitycenter.v1beta1.Asset.getDefaultInstance()
              : asset_;
        } else {
          return assetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Asset matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
       */
      public Builder setAsset(com.google.cloud.securitycenter.v1beta1.Asset value) {
        if (assetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          asset_ = value;
          onChanged();
        } else {
          assetBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Asset matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
       */
      public Builder setAsset(
          com.google.cloud.securitycenter.v1beta1.Asset.Builder builderForValue) {
        if (assetBuilder_ == null) {
          asset_ = builderForValue.build();
          onChanged();
        } else {
          assetBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Asset matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
       */
      public Builder mergeAsset(com.google.cloud.securitycenter.v1beta1.Asset value) {
        if (assetBuilder_ == null) {
          if (asset_ != null) {
            asset_ =
                com.google.cloud.securitycenter.v1beta1.Asset.newBuilder(asset_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            asset_ = value;
          }
          onChanged();
        } else {
          assetBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Asset matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
       */
      public Builder clearAsset() {
        if (assetBuilder_ == null) {
          asset_ = null;
          onChanged();
        } else {
          asset_ = null;
          assetBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Asset matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
       */
      public com.google.cloud.securitycenter.v1beta1.Asset.Builder getAssetBuilder() {

        onChanged();
        return getAssetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Asset matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
       */
      public com.google.cloud.securitycenter.v1beta1.AssetOrBuilder getAssetOrBuilder() {
        if (assetBuilder_ != null) {
          return assetBuilder_.getMessageOrBuilder();
        } else {
          return asset_ == null
              ? com.google.cloud.securitycenter.v1beta1.Asset.getDefaultInstance()
              : asset_;
        }
      }
      /**
       *
       *
       * <pre>
       * Asset matching the search request.
       * </pre>
       *
       * <code>.google.cloud.securitycenter.v1beta1.Asset asset = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.securitycenter.v1beta1.Asset,
              com.google.cloud.securitycenter.v1beta1.Asset.Builder,
              com.google.cloud.securitycenter.v1beta1.AssetOrBuilder>
          getAssetFieldBuilder() {
        if (assetBuilder_ == null) {
          assetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.securitycenter.v1beta1.Asset,
                  com.google.cloud.securitycenter.v1beta1.Asset.Builder,
                  com.google.cloud.securitycenter.v1beta1.AssetOrBuilder>(
                  getAsset(), getParentForChildren(), isClean());
          asset_ = null;
        }
        return assetBuilder_;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * State of the asset.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State state = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * State of the asset.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State state = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {

        state_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * State of the asset.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State state = 2;
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State
          getState() {
        @SuppressWarnings("deprecation")
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State result =
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State
                .valueOf(state_);
        return result == null
            ? com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * State of the asset.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State state = 2;
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State value) {
        if (value == null) {
          throw new NullPointerException();
        }

        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * State of the asset.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.State state = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {

        state_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult)
    private static final com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult();
    }

    public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListAssetsResult> PARSER =
        new com.google.protobuf.AbstractParser<ListAssetsResult>() {
          @java.lang.Override
          public ListAssetsResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListAssetsResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListAssetsResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int LIST_ASSETS_RESULTS_FIELD_NUMBER = 1;
  private java.util.List<
          com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult>
      listAssetsResults_;
  /**
   *
   *
   * <pre>
   * Assets matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult>
      getListAssetsResultsList() {
    return listAssetsResults_;
  }
  /**
   *
   *
   * <pre>
   * Assets matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResultOrBuilder>
      getListAssetsResultsOrBuilderList() {
    return listAssetsResults_;
  }
  /**
   *
   *
   * <pre>
   * Assets matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
   * </code>
   */
  @java.lang.Override
  public int getListAssetsResultsCount() {
    return listAssetsResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Assets matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
      getListAssetsResults(int index) {
    return listAssetsResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Assets matching the list request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResultOrBuilder
      getListAssetsResultsOrBuilder(int index) {
    return listAssetsResults_.get(index);
  }

  public static final int READ_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp readTime_;
  /**
   *
   *
   * <pre>
   * Time used for executing the list request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 2;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return readTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time used for executing the list request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 2;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }
  /**
   *
   *
   * <pre>
   * Time used for executing the list request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return getReadTime();
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * Token to retrieve the next page of results, or empty if there are no more
   * results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Token to retrieve the next page of results, or empty if there are no more
   * results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TOTAL_SIZE_FIELD_NUMBER = 4;
  private int totalSize_;
  /**
   *
   *
   * <pre>
   * The total number of assets matching the query.
   * </pre>
   *
   * <code>int32 total_size = 4;</code>
   *
   * @return The totalSize.
   */
  @java.lang.Override
  public int getTotalSize() {
    return totalSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < listAssetsResults_.size(); i++) {
      output.writeMessage(1, listAssetsResults_.get(i));
    }
    if (readTime_ != null) {
      output.writeMessage(2, getReadTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
    }
    if (totalSize_ != 0) {
      output.writeInt32(4, totalSize_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < listAssetsResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, listAssetsResults_.get(i));
    }
    if (readTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getReadTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
    }
    if (totalSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, totalSize_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1beta1.ListAssetsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1beta1.ListAssetsResponse other =
        (com.google.cloud.securitycenter.v1beta1.ListAssetsResponse) obj;

    if (!getListAssetsResultsList().equals(other.getListAssetsResultsList())) return false;
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (getTotalSize() != other.getTotalSize()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getListAssetsResultsCount() > 0) {
      hash = (37 * hash) + LIST_ASSETS_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getListAssetsResultsList().hashCode();
    }
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (37 * hash) + TOTAL_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getTotalSize();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1beta1.ListAssetsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for listing assets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1beta1.ListAssetsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1beta1.ListAssetsResponse)
      com.google.cloud.securitycenter.v1beta1.ListAssetsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.class,
              com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (listAssetsResultsBuilder_ == null) {
        listAssetsResults_ = java.util.Collections.emptyList();
      } else {
        listAssetsResults_ = null;
        listAssetsResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (readTimeBuilder_ == null) {
        readTime_ = null;
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }
      nextPageToken_ = "";

      totalSize_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1beta1.SecuritycenterService
          .internal_static_google_cloud_securitycenter_v1beta1_ListAssetsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse build() {
      com.google.cloud.securitycenter.v1beta1.ListAssetsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse buildPartial() {
      com.google.cloud.securitycenter.v1beta1.ListAssetsResponse result =
          new com.google.cloud.securitycenter.v1beta1.ListAssetsResponse(this);
      int from_bitField0_ = bitField0_;
      if (listAssetsResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          listAssetsResults_ = java.util.Collections.unmodifiableList(listAssetsResults_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.listAssetsResults_ = listAssetsResults_;
      } else {
        result.listAssetsResults_ = listAssetsResultsBuilder_.build();
      }
      if (readTimeBuilder_ == null) {
        result.readTime_ = readTime_;
      } else {
        result.readTime_ = readTimeBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      result.totalSize_ = totalSize_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1beta1.ListAssetsResponse) {
        return mergeFrom((com.google.cloud.securitycenter.v1beta1.ListAssetsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1beta1.ListAssetsResponse other) {
      if (other == com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.getDefaultInstance())
        return this;
      if (listAssetsResultsBuilder_ == null) {
        if (!other.listAssetsResults_.isEmpty()) {
          if (listAssetsResults_.isEmpty()) {
            listAssetsResults_ = other.listAssetsResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureListAssetsResultsIsMutable();
            listAssetsResults_.addAll(other.listAssetsResults_);
          }
          onChanged();
        }
      } else {
        if (!other.listAssetsResults_.isEmpty()) {
          if (listAssetsResultsBuilder_.isEmpty()) {
            listAssetsResultsBuilder_.dispose();
            listAssetsResultsBuilder_ = null;
            listAssetsResults_ = other.listAssetsResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
            listAssetsResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getListAssetsResultsFieldBuilder()
                    : null;
          } else {
            listAssetsResultsBuilder_.addAllMessages(other.listAssetsResults_);
          }
        }
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      if (other.getTotalSize() != 0) {
        setTotalSize(other.getTotalSize());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult m =
                    input.readMessage(
                        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
                            .parser(),
                        extensionRegistry);
                if (listAssetsResultsBuilder_ == null) {
                  ensureListAssetsResultsIsMutable();
                  listAssetsResults_.add(m);
                } else {
                  listAssetsResultsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                nextPageToken_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 32:
              {
                totalSize_ = input.readInt32();

                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult>
        listAssetsResults_ = java.util.Collections.emptyList();

    private void ensureListAssetsResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        listAssetsResults_ =
            new java.util.ArrayList<
                com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult>(
                listAssetsResults_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult,
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder,
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResultOrBuilder>
        listAssetsResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult>
        getListAssetsResultsList() {
      if (listAssetsResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(listAssetsResults_);
      } else {
        return listAssetsResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public int getListAssetsResultsCount() {
      if (listAssetsResultsBuilder_ == null) {
        return listAssetsResults_.size();
      } else {
        return listAssetsResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
        getListAssetsResults(int index) {
      if (listAssetsResultsBuilder_ == null) {
        return listAssetsResults_.get(index);
      } else {
        return listAssetsResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public Builder setListAssetsResults(
        int index,
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult value) {
      if (listAssetsResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListAssetsResultsIsMutable();
        listAssetsResults_.set(index, value);
        onChanged();
      } else {
        listAssetsResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public Builder setListAssetsResults(
        int index,
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder
            builderForValue) {
      if (listAssetsResultsBuilder_ == null) {
        ensureListAssetsResultsIsMutable();
        listAssetsResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        listAssetsResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public Builder addListAssetsResults(
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult value) {
      if (listAssetsResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListAssetsResultsIsMutable();
        listAssetsResults_.add(value);
        onChanged();
      } else {
        listAssetsResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public Builder addListAssetsResults(
        int index,
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult value) {
      if (listAssetsResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListAssetsResultsIsMutable();
        listAssetsResults_.add(index, value);
        onChanged();
      } else {
        listAssetsResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public Builder addListAssetsResults(
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder
            builderForValue) {
      if (listAssetsResultsBuilder_ == null) {
        ensureListAssetsResultsIsMutable();
        listAssetsResults_.add(builderForValue.build());
        onChanged();
      } else {
        listAssetsResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public Builder addListAssetsResults(
        int index,
        com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder
            builderForValue) {
      if (listAssetsResultsBuilder_ == null) {
        ensureListAssetsResultsIsMutable();
        listAssetsResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        listAssetsResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public Builder addAllListAssetsResults(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult>
            values) {
      if (listAssetsResultsBuilder_ == null) {
        ensureListAssetsResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, listAssetsResults_);
        onChanged();
      } else {
        listAssetsResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public Builder clearListAssetsResults() {
      if (listAssetsResultsBuilder_ == null) {
        listAssetsResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        listAssetsResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public Builder removeListAssetsResults(int index) {
      if (listAssetsResultsBuilder_ == null) {
        ensureListAssetsResultsIsMutable();
        listAssetsResults_.remove(index);
        onChanged();
      } else {
        listAssetsResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder
        getListAssetsResultsBuilder(int index) {
      return getListAssetsResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResultOrBuilder
        getListAssetsResultsOrBuilder(int index) {
      if (listAssetsResultsBuilder_ == null) {
        return listAssetsResults_.get(index);
      } else {
        return listAssetsResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.securitycenter.v1beta1.ListAssetsResponse
                    .ListAssetsResultOrBuilder>
        getListAssetsResultsOrBuilderList() {
      if (listAssetsResultsBuilder_ != null) {
        return listAssetsResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(listAssetsResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder
        addListAssetsResultsBuilder() {
      return getListAssetsResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder
        addListAssetsResultsBuilder(int index) {
      return getListAssetsResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Assets matching the list request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult list_assets_results = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder>
        getListAssetsResultsBuilderList() {
      return getListAssetsResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult,
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder,
            com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResultOrBuilder>
        getListAssetsResultsFieldBuilder() {
      if (listAssetsResultsBuilder_ == null) {
        listAssetsResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult,
                com.google.cloud.securitycenter.v1beta1.ListAssetsResponse.ListAssetsResult.Builder,
                com.google.cloud.securitycenter.v1beta1.ListAssetsResponse
                    .ListAssetsResultOrBuilder>(
                listAssetsResults_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        listAssetsResults_ = null;
      }
      return listAssetsResultsBuilder_;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return readTimeBuilder_ != null || readTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (readTime_ != null) {
          readTime_ =
              com.google.protobuf.Timestamp.newBuilder(readTime_).mergeFrom(value).buildPartial();
        } else {
          readTime_ = value;
        }
        onChanged();
      } else {
        readTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        readTime_ = null;
        onChanged();
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {

      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time used for executing the list request.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token to retrieve the next page of results, or empty if there are no more
     * results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    private int totalSize_;
    /**
     *
     *
     * <pre>
     * The total number of assets matching the query.
     * </pre>
     *
     * <code>int32 total_size = 4;</code>
     *
     * @return The totalSize.
     */
    @java.lang.Override
    public int getTotalSize() {
      return totalSize_;
    }
    /**
     *
     *
     * <pre>
     * The total number of assets matching the query.
     * </pre>
     *
     * <code>int32 total_size = 4;</code>
     *
     * @param value The totalSize to set.
     * @return This builder for chaining.
     */
    public Builder setTotalSize(int value) {

      totalSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The total number of assets matching the query.
     * </pre>
     *
     * <code>int32 total_size = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalSize() {

      totalSize_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1beta1.ListAssetsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1beta1.ListAssetsResponse)
  private static final com.google.cloud.securitycenter.v1beta1.ListAssetsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1beta1.ListAssetsResponse();
  }

  public static com.google.cloud.securitycenter.v1beta1.ListAssetsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListAssetsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListAssetsResponse>() {
        @java.lang.Override
        public ListAssetsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListAssetsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListAssetsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.ListAssetsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
