/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1beta1/asset.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1beta1;

/**
 *
 *
 * <pre>
 * Security Command Center representation of a Google Cloud
 * resource.
 *
 * The Asset is a Security Command Center resource that captures information
 * about a single Google Cloud resource. All modifications to an Asset are only
 * within the context of Security Command Center and don't affect the referenced
 * Google Cloud resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1beta1.Asset}
 */
public final class Asset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1beta1.Asset)
    AssetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Asset.newBuilder() to construct.
  private Asset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Asset() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Asset();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
        .internal_static_google_cloud_securitycenter_v1beta1_Asset_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 7:
        return internalGetResourceProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
        .internal_static_google_cloud_securitycenter_v1beta1_Asset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1beta1.Asset.class,
            com.google.cloud.securitycenter.v1beta1.Asset.Builder.class);
  }

  public interface SecurityCenterPropertiesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the Google Cloud resource this asset
     * represents. This field is immutable after create time. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The resourceName.
     */
    java.lang.String getResourceName();
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the Google Cloud resource this asset
     * represents. This field is immutable after create time. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for resourceName.
     */
    com.google.protobuf.ByteString getResourceNameBytes();

    /**
     *
     *
     * <pre>
     * The type of the Google Cloud resource. Examples include: APPLICATION,
     * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
     * Security Command Center and/or the producer of the resource and is
     * immutable after create time.
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     *
     * @return The resourceType.
     */
    java.lang.String getResourceType();
    /**
     *
     *
     * <pre>
     * The type of the Google Cloud resource. Examples include: APPLICATION,
     * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
     * Security Command Center and/or the producer of the resource and is
     * immutable after create time.
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     *
     * @return The bytes for resourceType.
     */
    com.google.protobuf.ByteString getResourceTypeBytes();

    /**
     *
     *
     * <pre>
     * The full resource name of the immediate parent of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_parent = 3;</code>
     *
     * @return The resourceParent.
     */
    java.lang.String getResourceParent();
    /**
     *
     *
     * <pre>
     * The full resource name of the immediate parent of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_parent = 3;</code>
     *
     * @return The bytes for resourceParent.
     */
    com.google.protobuf.ByteString getResourceParentBytes();

    /**
     *
     *
     * <pre>
     * The full resource name of the project the resource belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_project = 4;</code>
     *
     * @return The resourceProject.
     */
    java.lang.String getResourceProject();
    /**
     *
     *
     * <pre>
     * The full resource name of the project the resource belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_project = 4;</code>
     *
     * @return The bytes for resourceProject.
     */
    com.google.protobuf.ByteString getResourceProjectBytes();

    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     *
     * @return A list containing the resourceOwners.
     */
    java.util.List<java.lang.String> getResourceOwnersList();
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     *
     * @return The count of resourceOwners.
     */
    int getResourceOwnersCount();
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The resourceOwners at the given index.
     */
    java.lang.String getResourceOwners(int index);
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourceOwners at the given index.
     */
    com.google.protobuf.ByteString getResourceOwnersBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Security Command Center managed properties. These properties are managed by
   * Security Command Center and cannot be modified by the user.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties}
   */
  public static final class SecurityCenterProperties extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
      SecurityCenterPropertiesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SecurityCenterProperties.newBuilder() to construct.
    private SecurityCenterProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SecurityCenterProperties() {
      resourceName_ = "";
      resourceType_ = "";
      resourceParent_ = "";
      resourceProject_ = "";
      resourceOwners_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SecurityCenterProperties();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.class,
              com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder.class);
    }

    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceName_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the Google Cloud resource this asset
     * represents. This field is immutable after create time. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The resourceName.
     */
    @java.lang.Override
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the Google Cloud resource this asset
     * represents. This field is immutable after create time. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for resourceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_TYPE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceType_ = "";
    /**
     *
     *
     * <pre>
     * The type of the Google Cloud resource. Examples include: APPLICATION,
     * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
     * Security Command Center and/or the producer of the resource and is
     * immutable after create time.
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public java.lang.String getResourceType() {
      java.lang.Object ref = resourceType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the Google Cloud resource. Examples include: APPLICATION,
     * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
     * Security Command Center and/or the producer of the resource and is
     * immutable after create time.
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     *
     * @return The bytes for resourceType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceTypeBytes() {
      java.lang.Object ref = resourceType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_PARENT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceParent_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name of the immediate parent of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_parent = 3;</code>
     *
     * @return The resourceParent.
     */
    @java.lang.Override
    public java.lang.String getResourceParent() {
      java.lang.Object ref = resourceParent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceParent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the immediate parent of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_parent = 3;</code>
     *
     * @return The bytes for resourceParent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceParentBytes() {
      java.lang.Object ref = resourceParent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceParent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_PROJECT_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceProject_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name of the project the resource belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_project = 4;</code>
     *
     * @return The resourceProject.
     */
    @java.lang.Override
    public java.lang.String getResourceProject() {
      java.lang.Object ref = resourceProject_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceProject_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the project the resource belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_project = 4;</code>
     *
     * @return The bytes for resourceProject.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceProjectBytes() {
      java.lang.Object ref = resourceProject_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceProject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_OWNERS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList resourceOwners_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     *
     * @return A list containing the resourceOwners.
     */
    public com.google.protobuf.ProtocolStringList getResourceOwnersList() {
      return resourceOwners_;
    }
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     *
     * @return The count of resourceOwners.
     */
    public int getResourceOwnersCount() {
      return resourceOwners_.size();
    }
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The resourceOwners at the given index.
     */
    public java.lang.String getResourceOwners(int index) {
      return resourceOwners_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourceOwners at the given index.
     */
    public com.google.protobuf.ByteString getResourceOwnersBytes(int index) {
      return resourceOwners_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceParent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resourceParent_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceProject_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resourceProject_);
      }
      for (int i = 0; i < resourceOwners_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, resourceOwners_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resourceType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceParent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resourceParent_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceProject_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, resourceProject_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < resourceOwners_.size(); i++) {
          dataSize += computeStringSizeNoTag(resourceOwners_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getResourceOwnersList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties other =
          (com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties) obj;

      if (!getResourceName().equals(other.getResourceName())) return false;
      if (!getResourceType().equals(other.getResourceType())) return false;
      if (!getResourceParent().equals(other.getResourceParent())) return false;
      if (!getResourceProject().equals(other.getResourceProject())) return false;
      if (!getResourceOwnersList().equals(other.getResourceOwnersList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getResourceName().hashCode();
      hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getResourceType().hashCode();
      hash = (37 * hash) + RESOURCE_PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getResourceParent().hashCode();
      hash = (37 * hash) + RESOURCE_PROJECT_FIELD_NUMBER;
      hash = (53 * hash) + getResourceProject().hashCode();
      if (getResourceOwnersCount() > 0) {
        hash = (37 * hash) + RESOURCE_OWNERS_FIELD_NUMBER;
        hash = (53 * hash) + getResourceOwnersList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
            .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
            .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.class,
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        resourceName_ = "";
        resourceType_ = "";
        resourceParent_ = "";
        resourceProject_ = "";
        resourceOwners_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
            .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties build() {
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties buildPartial() {
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties result =
            new com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.resourceName_ = resourceName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.resourceType_ = resourceType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.resourceParent_ = resourceParent_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.resourceProject_ = resourceProject_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          resourceOwners_.makeImmutable();
          result.resourceOwners_ = resourceOwners_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties other) {
        if (other
            == com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
                .getDefaultInstance()) return this;
        if (!other.getResourceName().isEmpty()) {
          resourceName_ = other.resourceName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getResourceType().isEmpty()) {
          resourceType_ = other.resourceType_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getResourceParent().isEmpty()) {
          resourceParent_ = other.resourceParent_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getResourceProject().isEmpty()) {
          resourceProject_ = other.resourceProject_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.resourceOwners_.isEmpty()) {
          if (resourceOwners_.isEmpty()) {
            resourceOwners_ = other.resourceOwners_;
            bitField0_ |= 0x00000010;
          } else {
            ensureResourceOwnersIsMutable();
            resourceOwners_.addAll(other.resourceOwners_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  resourceName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  resourceType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  resourceParent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  resourceProject_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureResourceOwnersIsMutable();
                  resourceOwners_.add(s);
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object resourceName_ = "";
      /**
       *
       *
       * <pre>
       * Immutable. The full resource name of the Google Cloud resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The resourceName.
       */
      public java.lang.String getResourceName() {
        java.lang.Object ref = resourceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The full resource name of the Google Cloud resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The bytes for resourceName.
       */
      public com.google.protobuf.ByteString getResourceNameBytes() {
        java.lang.Object ref = resourceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The full resource name of the Google Cloud resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The full resource name of the Google Cloud resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceName() {
        resourceName_ = getDefaultInstance().getResourceName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The full resource name of the Google Cloud resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The bytes for resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object resourceType_ = "";
      /**
       *
       *
       * <pre>
       * The type of the Google Cloud resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Security Command Center and/or the producer of the resource and is
       * immutable after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       *
       * @return The resourceType.
       */
      public java.lang.String getResourceType() {
        java.lang.Object ref = resourceType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The type of the Google Cloud resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Security Command Center and/or the producer of the resource and is
       * immutable after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       *
       * @return The bytes for resourceType.
       */
      public com.google.protobuf.ByteString getResourceTypeBytes() {
        java.lang.Object ref = resourceType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The type of the Google Cloud resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Security Command Center and/or the producer of the resource and is
       * immutable after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       *
       * @param value The resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the Google Cloud resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Security Command Center and/or the producer of the resource and is
       * immutable after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceType() {
        resourceType_ = getDefaultInstance().getResourceType();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the Google Cloud resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Security Command Center and/or the producer of the resource and is
       * immutable after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       *
       * @param value The bytes for resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object resourceParent_ = "";
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       *
       * @return The resourceParent.
       */
      public java.lang.String getResourceParent() {
        java.lang.Object ref = resourceParent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceParent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       *
       * @return The bytes for resourceParent.
       */
      public com.google.protobuf.ByteString getResourceParentBytes() {
        java.lang.Object ref = resourceParent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceParent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       *
       * @param value The resourceParent to set.
       * @return This builder for chaining.
       */
      public Builder setResourceParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceParent_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceParent() {
        resourceParent_ = getDefaultInstance().getResourceParent();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       *
       * @param value The bytes for resourceParent to set.
       * @return This builder for chaining.
       */
      public Builder setResourceParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceParent_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object resourceProject_ = "";
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       *
       * @return The resourceProject.
       */
      public java.lang.String getResourceProject() {
        java.lang.Object ref = resourceProject_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceProject_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       *
       * @return The bytes for resourceProject.
       */
      public com.google.protobuf.ByteString getResourceProjectBytes() {
        java.lang.Object ref = resourceProject_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceProject_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       *
       * @param value The resourceProject to set.
       * @return This builder for chaining.
       */
      public Builder setResourceProject(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceProject_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceProject() {
        resourceProject_ = getDefaultInstance().getResourceProject();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       *
       * @param value The bytes for resourceProject to set.
       * @return This builder for chaining.
       */
      public Builder setResourceProjectBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceProject_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList resourceOwners_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureResourceOwnersIsMutable() {
        if (!resourceOwners_.isModifiable()) {
          resourceOwners_ = new com.google.protobuf.LazyStringArrayList(resourceOwners_);
        }
        bitField0_ |= 0x00000010;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       *
       * @return A list containing the resourceOwners.
       */
      public com.google.protobuf.ProtocolStringList getResourceOwnersList() {
        resourceOwners_.makeImmutable();
        return resourceOwners_;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       *
       * @return The count of resourceOwners.
       */
      public int getResourceOwnersCount() {
        return resourceOwners_.size();
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The resourceOwners at the given index.
       */
      public java.lang.String getResourceOwners(int index) {
        return resourceOwners_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the resourceOwners at the given index.
       */
      public com.google.protobuf.ByteString getResourceOwnersBytes(int index) {
        return resourceOwners_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       *
       * @param index The index to set the value at.
       * @param value The resourceOwners to set.
       * @return This builder for chaining.
       */
      public Builder setResourceOwners(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceOwnersIsMutable();
        resourceOwners_.set(index, value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       *
       * @param value The resourceOwners to add.
       * @return This builder for chaining.
       */
      public Builder addResourceOwners(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceOwnersIsMutable();
        resourceOwners_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       *
       * @param values The resourceOwners to add.
       * @return This builder for chaining.
       */
      public Builder addAllResourceOwners(java.lang.Iterable<java.lang.String> values) {
        ensureResourceOwnersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceOwners_);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceOwners() {
        resourceOwners_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       *
       * @param value The bytes of the resourceOwners to add.
       * @return This builder for chaining.
       */
      public Builder addResourceOwnersBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureResourceOwnersIsMutable();
        resourceOwners_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
    private static final com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties();
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SecurityCenterProperties> PARSER =
        new com.google.protobuf.AbstractParser<SecurityCenterProperties>() {
          @java.lang.Override
          public SecurityCenterProperties parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SecurityCenterProperties> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SecurityCenterProperties> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The relative resource name of this asset. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/{organization_id}/assets/{asset_id}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative resource name of this asset. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/{organization_id}/assets/{asset_id}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECURITY_CENTER_PROPERTIES_FIELD_NUMBER = 2;
  private com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
      securityCenterProperties_;
  /**
   *
   *
   * <pre>
   * Security Command Center managed properties. These properties are managed by
   * Security Command Center and cannot be modified by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
   * </code>
   *
   * @return Whether the securityCenterProperties field is set.
   */
  @java.lang.Override
  public boolean hasSecurityCenterProperties() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Security Command Center managed properties. These properties are managed by
   * Security Command Center and cannot be modified by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
   * </code>
   *
   * @return The securityCenterProperties.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
      getSecurityCenterProperties() {
    return securityCenterProperties_ == null
        ? com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
            .getDefaultInstance()
        : securityCenterProperties_;
  }
  /**
   *
   *
   * <pre>
   * Security Command Center managed properties. These properties are managed by
   * Security Command Center and cannot be modified by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder
      getSecurityCenterPropertiesOrBuilder() {
    return securityCenterProperties_ == null
        ? com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
            .getDefaultInstance()
        : securityCenterProperties_;
  }

  public static final int RESOURCE_PROPERTIES_FIELD_NUMBER = 7;

  private static final class ResourcePropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.securitycenter.v1beta1.AssetOuterClass
                        .internal_static_google_cloud_securitycenter_v1beta1_Asset_ResourcePropertiesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      resourceProperties_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetResourceProperties() {
    if (resourceProperties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ResourcePropertiesDefaultEntryHolder.defaultEntry);
    }
    return resourceProperties_;
  }

  public int getResourcePropertiesCount() {
    return internalGetResourceProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource managed properties. These properties are managed and defined by
   * the Google Cloud resource and cannot be modified by the user.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
   */
  @java.lang.Override
  public boolean containsResourceProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetResourceProperties().getMap().containsKey(key);
  }
  /** Use {@link #getResourcePropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getResourceProperties() {
    return getResourcePropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Resource managed properties. These properties are managed and defined by
   * the Google Cloud resource and cannot be modified by the user.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getResourcePropertiesMap() {
    return internalGetResourceProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource managed properties. These properties are managed and defined by
   * the Google Cloud resource and cannot be modified by the user.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Value getResourcePropertiesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetResourceProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource managed properties. These properties are managed and defined by
   * the Google Cloud resource and cannot be modified by the user.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getResourcePropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetResourceProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SECURITY_MARKS_FIELD_NUMBER = 8;
  private com.google.cloud.securitycenter.v1beta1.SecurityMarks securityMarks_;
  /**
   *
   *
   * <pre>
   * User specified security marks. These marks are entirely managed by the user
   * and come from the SecurityMarks resource that belongs to the asset.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
   *
   * @return Whether the securityMarks field is set.
   */
  @java.lang.Override
  public boolean hasSecurityMarks() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * User specified security marks. These marks are entirely managed by the user
   * and come from the SecurityMarks resource that belongs to the asset.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
   *
   * @return The securityMarks.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.SecurityMarks getSecurityMarks() {
    return securityMarks_ == null
        ? com.google.cloud.securitycenter.v1beta1.SecurityMarks.getDefaultInstance()
        : securityMarks_;
  }
  /**
   *
   *
   * <pre>
   * User specified security marks. These marks are entirely managed by the user
   * and come from the SecurityMarks resource that belongs to the asset.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder
      getSecurityMarksOrBuilder() {
    return securityMarks_ == null
        ? com.google.cloud.securitycenter.v1beta1.SecurityMarks.getDefaultInstance()
        : securityMarks_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time at which the asset was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which the asset was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the asset was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * The time at which the asset was last updated, added, or deleted in Security
   * Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which the asset was last updated, added, or deleted in Security
   * Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the asset was last updated, added, or deleted in Security
   * Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getSecurityCenterProperties());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetResourceProperties(),
        ResourcePropertiesDefaultEntryHolder.defaultEntry,
        7);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getSecurityMarks());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getSecurityCenterProperties());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetResourceProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          resourceProperties__ =
              ResourcePropertiesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, resourceProperties__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSecurityMarks());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1beta1.Asset)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1beta1.Asset other =
        (com.google.cloud.securitycenter.v1beta1.Asset) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSecurityCenterProperties() != other.hasSecurityCenterProperties()) return false;
    if (hasSecurityCenterProperties()) {
      if (!getSecurityCenterProperties().equals(other.getSecurityCenterProperties())) return false;
    }
    if (!internalGetResourceProperties().equals(other.internalGetResourceProperties()))
      return false;
    if (hasSecurityMarks() != other.hasSecurityMarks()) return false;
    if (hasSecurityMarks()) {
      if (!getSecurityMarks().equals(other.getSecurityMarks())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSecurityCenterProperties()) {
      hash = (37 * hash) + SECURITY_CENTER_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityCenterProperties().hashCode();
    }
    if (!internalGetResourceProperties().getMap().isEmpty()) {
      hash = (37 * hash) + RESOURCE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetResourceProperties().hashCode();
    }
    if (hasSecurityMarks()) {
      hash = (37 * hash) + SECURITY_MARKS_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityMarks().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1beta1.Asset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Security Command Center representation of a Google Cloud
   * resource.
   *
   * The Asset is a Security Command Center resource that captures information
   * about a single Google Cloud resource. All modifications to an Asset are only
   * within the context of Security Command Center and don't affect the referenced
   * Google Cloud resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1beta1.Asset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1beta1.Asset)
      com.google.cloud.securitycenter.v1beta1.AssetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetResourceProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetMutableResourceProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1beta1.Asset.class,
              com.google.cloud.securitycenter.v1beta1.Asset.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1beta1.Asset.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSecurityCenterPropertiesFieldBuilder();
        getSecurityMarksFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      securityCenterProperties_ = null;
      if (securityCenterPropertiesBuilder_ != null) {
        securityCenterPropertiesBuilder_.dispose();
        securityCenterPropertiesBuilder_ = null;
      }
      internalGetMutableResourceProperties().clear();
      securityMarks_ = null;
      if (securityMarksBuilder_ != null) {
        securityMarksBuilder_.dispose();
        securityMarksBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.Asset getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1beta1.Asset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.Asset build() {
      com.google.cloud.securitycenter.v1beta1.Asset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.Asset buildPartial() {
      com.google.cloud.securitycenter.v1beta1.Asset result =
          new com.google.cloud.securitycenter.v1beta1.Asset(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securitycenter.v1beta1.Asset result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.securityCenterProperties_ =
            securityCenterPropertiesBuilder_ == null
                ? securityCenterProperties_
                : securityCenterPropertiesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resourceProperties_ =
            internalGetResourceProperties()
                .build(ResourcePropertiesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.securityMarks_ =
            securityMarksBuilder_ == null ? securityMarks_ : securityMarksBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1beta1.Asset) {
        return mergeFrom((com.google.cloud.securitycenter.v1beta1.Asset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1beta1.Asset other) {
      if (other == com.google.cloud.securitycenter.v1beta1.Asset.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSecurityCenterProperties()) {
        mergeSecurityCenterProperties(other.getSecurityCenterProperties());
      }
      internalGetMutableResourceProperties().mergeFrom(other.internalGetResourceProperties());
      bitField0_ |= 0x00000004;
      if (other.hasSecurityMarks()) {
        mergeSecurityMarks(other.getSecurityMarks());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getSecurityCenterPropertiesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                    resourceProperties__ =
                        input.readMessage(
                            ResourcePropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableResourceProperties()
                    .ensureBuilderMap()
                    .put(resourceProperties__.getKey(), resourceProperties__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getSecurityMarksFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/assets/{asset_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/assets/{asset_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/assets/{asset_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/assets/{asset_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/assets/{asset_id}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        securityCenterProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties,
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder,
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder>
        securityCenterPropertiesBuilder_;
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     *
     * @return Whether the securityCenterProperties field is set.
     */
    public boolean hasSecurityCenterProperties() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     *
     * @return The securityCenterProperties.
     */
    public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        getSecurityCenterProperties() {
      if (securityCenterPropertiesBuilder_ == null) {
        return securityCenterProperties_ == null
            ? com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
                .getDefaultInstance()
            : securityCenterProperties_;
      } else {
        return securityCenterPropertiesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public Builder setSecurityCenterProperties(
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties value) {
      if (securityCenterPropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securityCenterProperties_ = value;
      } else {
        securityCenterPropertiesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public Builder setSecurityCenterProperties(
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder
            builderForValue) {
      if (securityCenterPropertiesBuilder_ == null) {
        securityCenterProperties_ = builderForValue.build();
      } else {
        securityCenterPropertiesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public Builder mergeSecurityCenterProperties(
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties value) {
      if (securityCenterPropertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && securityCenterProperties_ != null
            && securityCenterProperties_
                != com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
                    .getDefaultInstance()) {
          getSecurityCenterPropertiesBuilder().mergeFrom(value);
        } else {
          securityCenterProperties_ = value;
        }
      } else {
        securityCenterPropertiesBuilder_.mergeFrom(value);
      }
      if (securityCenterProperties_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public Builder clearSecurityCenterProperties() {
      bitField0_ = (bitField0_ & ~0x00000002);
      securityCenterProperties_ = null;
      if (securityCenterPropertiesBuilder_ != null) {
        securityCenterPropertiesBuilder_.dispose();
        securityCenterPropertiesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder
        getSecurityCenterPropertiesBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSecurityCenterPropertiesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder
        getSecurityCenterPropertiesOrBuilder() {
      if (securityCenterPropertiesBuilder_ != null) {
        return securityCenterPropertiesBuilder_.getMessageOrBuilder();
      } else {
        return securityCenterProperties_ == null
            ? com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
                .getDefaultInstance()
            : securityCenterProperties_;
      }
    }
    /**
     *
     *
     * <pre>
     * Security Command Center managed properties. These properties are managed by
     * Security Command Center and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties,
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder,
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder>
        getSecurityCenterPropertiesFieldBuilder() {
      if (securityCenterPropertiesBuilder_ == null) {
        securityCenterPropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties,
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder,
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder>(
                getSecurityCenterProperties(), getParentForChildren(), isClean());
        securityCenterProperties_ = null;
      }
      return securityCenterPropertiesBuilder_;
    }

    private static final class ResourcePropertiesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String, com.google.protobuf.ValueOrBuilder, com.google.protobuf.Value> {
      @java.lang.Override
      public com.google.protobuf.Value build(com.google.protobuf.ValueOrBuilder val) {
        if (val instanceof com.google.protobuf.Value) {
          return (com.google.protobuf.Value) val;
        }
        return ((com.google.protobuf.Value.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry() {
        return ResourcePropertiesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final ResourcePropertiesConverter resourcePropertiesConverter =
        new ResourcePropertiesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        resourceProperties_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetResourceProperties() {
      if (resourceProperties_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(resourcePropertiesConverter);
      }
      return resourceProperties_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetMutableResourceProperties() {
      if (resourceProperties_ == null) {
        resourceProperties_ =
            new com.google.protobuf.MapFieldBuilder<>(resourcePropertiesConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return resourceProperties_;
    }

    public int getResourcePropertiesCount() {
      return internalGetResourceProperties().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the Google Cloud resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    @java.lang.Override
    public boolean containsResourceProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetResourceProperties().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getResourcePropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getResourceProperties() {
      return getResourcePropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the Google Cloud resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getResourcePropertiesMap() {
      return internalGetResourceProperties().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the Google Cloud resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getResourcePropertiesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableResourceProperties().ensureBuilderMap();
      return map.containsKey(key) ? resourcePropertiesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the Google Cloud resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getResourcePropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableResourceProperties().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return resourcePropertiesConverter.build(map.get(key));
    }

    public Builder clearResourceProperties() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableResourceProperties().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the Google Cloud resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public Builder removeResourceProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableResourceProperties().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value>
        getMutableResourceProperties() {
      bitField0_ |= 0x00000004;
      return internalGetMutableResourceProperties().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the Google Cloud resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public Builder putResourceProperties(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableResourceProperties().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the Google Cloud resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public Builder putAllResourceProperties(
        java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableResourceProperties().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the Google Cloud resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public com.google.protobuf.Value.Builder putResourcePropertiesBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> builderMap =
          internalGetMutableResourceProperties().ensureBuilderMap();
      com.google.protobuf.ValueOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.protobuf.Value.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.protobuf.Value) {
        entry = ((com.google.protobuf.Value) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.protobuf.Value.Builder) entry;
    }

    private com.google.cloud.securitycenter.v1beta1.SecurityMarks securityMarks_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.SecurityMarks,
            com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder,
            com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder>
        securityMarksBuilder_;
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     *
     * @return Whether the securityMarks field is set.
     */
    public boolean hasSecurityMarks() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     *
     * @return The securityMarks.
     */
    public com.google.cloud.securitycenter.v1beta1.SecurityMarks getSecurityMarks() {
      if (securityMarksBuilder_ == null) {
        return securityMarks_ == null
            ? com.google.cloud.securitycenter.v1beta1.SecurityMarks.getDefaultInstance()
            : securityMarks_;
      } else {
        return securityMarksBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public Builder setSecurityMarks(com.google.cloud.securitycenter.v1beta1.SecurityMarks value) {
      if (securityMarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securityMarks_ = value;
      } else {
        securityMarksBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public Builder setSecurityMarks(
        com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder builderForValue) {
      if (securityMarksBuilder_ == null) {
        securityMarks_ = builderForValue.build();
      } else {
        securityMarksBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public Builder mergeSecurityMarks(com.google.cloud.securitycenter.v1beta1.SecurityMarks value) {
      if (securityMarksBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && securityMarks_ != null
            && securityMarks_
                != com.google.cloud.securitycenter.v1beta1.SecurityMarks.getDefaultInstance()) {
          getSecurityMarksBuilder().mergeFrom(value);
        } else {
          securityMarks_ = value;
        }
      } else {
        securityMarksBuilder_.mergeFrom(value);
      }
      if (securityMarks_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public Builder clearSecurityMarks() {
      bitField0_ = (bitField0_ & ~0x00000008);
      securityMarks_ = null;
      if (securityMarksBuilder_ != null) {
        securityMarksBuilder_.dispose();
        securityMarksBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder getSecurityMarksBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSecurityMarksFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder
        getSecurityMarksOrBuilder() {
      if (securityMarksBuilder_ != null) {
        return securityMarksBuilder_.getMessageOrBuilder();
      } else {
        return securityMarks_ == null
            ? com.google.cloud.securitycenter.v1beta1.SecurityMarks.getDefaultInstance()
            : securityMarks_;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.SecurityMarks,
            com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder,
            com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder>
        getSecurityMarksFieldBuilder() {
      if (securityMarksBuilder_ == null) {
        securityMarksBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1beta1.SecurityMarks,
                com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder,
                com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder>(
                getSecurityMarks(), getParentForChildren(), isClean());
        securityMarks_ = null;
      }
      return securityMarksBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Security
     * Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Security
     * Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Security
     * Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Security
     * Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Security
     * Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Security
     * Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Security
     * Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Security
     * Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Security
     * Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1beta1.Asset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1beta1.Asset)
  private static final com.google.cloud.securitycenter.v1beta1.Asset DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1beta1.Asset();
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Asset> PARSER =
      new com.google.protobuf.AbstractParser<Asset>() {
        @java.lang.Override
        public Asset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Asset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Asset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.Asset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
