/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1beta1/organization_settings.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.securitycenter.v1beta1;

/**
 *
 *
 * <pre>
 * User specified settings that are attached to the Security Command
 * Center organization.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1beta1.OrganizationSettings}
 */
public final class OrganizationSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1beta1.OrganizationSettings)
    OrganizationSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OrganizationSettings.newBuilder() to construct.
  private OrganizationSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OrganizationSettings() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OrganizationSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
        .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
        .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1beta1.OrganizationSettings.class,
            com.google.cloud.securitycenter.v1beta1.OrganizationSettings.Builder.class);
  }

  public interface AssetDiscoveryConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The project ids to use for filtering asset discovery.
     * </pre>
     *
     * <code>repeated string project_ids = 1;</code>
     *
     * @return A list containing the projectIds.
     */
    java.util.List<java.lang.String> getProjectIdsList();
    /**
     *
     *
     * <pre>
     * The project ids to use for filtering asset discovery.
     * </pre>
     *
     * <code>repeated string project_ids = 1;</code>
     *
     * @return The count of projectIds.
     */
    int getProjectIdsCount();
    /**
     *
     *
     * <pre>
     * The project ids to use for filtering asset discovery.
     * </pre>
     *
     * <code>repeated string project_ids = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The projectIds at the given index.
     */
    java.lang.String getProjectIds(int index);
    /**
     *
     *
     * <pre>
     * The project ids to use for filtering asset discovery.
     * </pre>
     *
     * <code>repeated string project_ids = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the projectIds at the given index.
     */
    com.google.protobuf.ByteString getProjectIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * The mode to use for filtering asset discovery.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode inclusion_mode = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for inclusionMode.
     */
    int getInclusionModeValue();
    /**
     *
     *
     * <pre>
     * The mode to use for filtering asset discovery.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode inclusion_mode = 2;
     * </code>
     *
     * @return The inclusionMode.
     */
    com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode
        getInclusionMode();
  }
  /**
   *
   *
   * <pre>
   * The configuration used for Asset Discovery runs.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig}
   */
  public static final class AssetDiscoveryConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig)
      AssetDiscoveryConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AssetDiscoveryConfig.newBuilder() to construct.
    private AssetDiscoveryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AssetDiscoveryConfig() {
      projectIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      inclusionMode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AssetDiscoveryConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_AssetDiscoveryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_AssetDiscoveryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                  .class,
              com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                  .Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The mode of inclusion when running Asset Discovery.
     * Asset discovery can be limited by explicitly identifying projects to be
     * included or excluded. If INCLUDE_ONLY is set, then only those projects
     * within the organization and their children are discovered during asset
     * discovery. If EXCLUDE is set, then projects that don't match those
     * projects are discovered during asset discovery. If neither are set, then
     * all projects within the organization are discovered during asset
     * discovery.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode}
     */
    public enum InclusionMode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified. Setting the mode with this value will disable
       * inclusion/exclusion filtering for Asset Discovery.
       * </pre>
       *
       * <code>INCLUSION_MODE_UNSPECIFIED = 0;</code>
       */
      INCLUSION_MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Asset Discovery will capture only the resources within the projects
       * specified. All other resources will be ignored.
       * </pre>
       *
       * <code>INCLUDE_ONLY = 1;</code>
       */
      INCLUDE_ONLY(1),
      /**
       *
       *
       * <pre>
       * Asset Discovery will ignore all resources under the projects specified.
       * All other resources will be retrieved.
       * </pre>
       *
       * <code>EXCLUDE = 2;</code>
       */
      EXCLUDE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified. Setting the mode with this value will disable
       * inclusion/exclusion filtering for Asset Discovery.
       * </pre>
       *
       * <code>INCLUSION_MODE_UNSPECIFIED = 0;</code>
       */
      public static final int INCLUSION_MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Asset Discovery will capture only the resources within the projects
       * specified. All other resources will be ignored.
       * </pre>
       *
       * <code>INCLUDE_ONLY = 1;</code>
       */
      public static final int INCLUDE_ONLY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Asset Discovery will ignore all resources under the projects specified.
       * All other resources will be retrieved.
       * </pre>
       *
       * <code>EXCLUDE = 2;</code>
       */
      public static final int EXCLUDE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static InclusionMode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static InclusionMode forNumber(int value) {
        switch (value) {
          case 0:
            return INCLUSION_MODE_UNSPECIFIED;
          case 1:
            return INCLUDE_ONLY;
          case 2:
            return EXCLUDE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<InclusionMode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<InclusionMode>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<InclusionMode>() {
                public InclusionMode findValueByNumber(int number) {
                  return InclusionMode.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final InclusionMode[] VALUES = values();

      public static InclusionMode valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private InclusionMode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode)
    }

    public static final int PROJECT_IDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList projectIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The project ids to use for filtering asset discovery.
     * </pre>
     *
     * <code>repeated string project_ids = 1;</code>
     *
     * @return A list containing the projectIds.
     */
    public com.google.protobuf.ProtocolStringList getProjectIdsList() {
      return projectIds_;
    }
    /**
     *
     *
     * <pre>
     * The project ids to use for filtering asset discovery.
     * </pre>
     *
     * <code>repeated string project_ids = 1;</code>
     *
     * @return The count of projectIds.
     */
    public int getProjectIdsCount() {
      return projectIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The project ids to use for filtering asset discovery.
     * </pre>
     *
     * <code>repeated string project_ids = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The projectIds at the given index.
     */
    public java.lang.String getProjectIds(int index) {
      return projectIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The project ids to use for filtering asset discovery.
     * </pre>
     *
     * <code>repeated string project_ids = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the projectIds at the given index.
     */
    public com.google.protobuf.ByteString getProjectIdsBytes(int index) {
      return projectIds_.getByteString(index);
    }

    public static final int INCLUSION_MODE_FIELD_NUMBER = 2;
    private int inclusionMode_ = 0;
    /**
     *
     *
     * <pre>
     * The mode to use for filtering asset discovery.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode inclusion_mode = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for inclusionMode.
     */
    @java.lang.Override
    public int getInclusionModeValue() {
      return inclusionMode_;
    }
    /**
     *
     *
     * <pre>
     * The mode to use for filtering asset discovery.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode inclusion_mode = 2;
     * </code>
     *
     * @return The inclusionMode.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
            .InclusionMode
        getInclusionMode() {
      com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
              .InclusionMode
          result =
              com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                  .InclusionMode.forNumber(inclusionMode_);
      return result == null
          ? com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
              .InclusionMode.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < projectIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectIds_.getRaw(i));
      }
      if (inclusionMode_
          != com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
              .InclusionMode.INCLUSION_MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, inclusionMode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < projectIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(projectIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getProjectIdsList().size();
      }
      if (inclusionMode_
          != com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
              .InclusionMode.INCLUSION_MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, inclusionMode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig other =
          (com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig) obj;

      if (!getProjectIdsList().equals(other.getProjectIdsList())) return false;
      if (inclusionMode_ != other.inclusionMode_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getProjectIdsCount() > 0) {
        hash = (37 * hash) + PROJECT_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getProjectIdsList().hashCode();
      }
      hash = (37 * hash) + INCLUSION_MODE_FIELD_NUMBER;
      hash = (53 * hash) + inclusionMode_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig)
        com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
            .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_AssetDiscoveryConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
            .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_AssetDiscoveryConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                    .class,
                com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        projectIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        inclusionMode_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
            .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_AssetDiscoveryConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
          build() {
        com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
          buildPartial() {
        com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig result =
            new com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          projectIds_.makeImmutable();
          result.projectIds_ = projectIds_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.inclusionMode_ = inclusionMode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig other) {
        if (other
            == com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                .getDefaultInstance()) return this;
        if (!other.projectIds_.isEmpty()) {
          if (projectIds_.isEmpty()) {
            projectIds_ = other.projectIds_;
            bitField0_ |= 0x00000001;
          } else {
            ensureProjectIdsIsMutable();
            projectIds_.addAll(other.projectIds_);
          }
          onChanged();
        }
        if (other.inclusionMode_ != 0) {
          setInclusionModeValue(other.getInclusionModeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureProjectIdsIsMutable();
                  projectIds_.add(s);
                  break;
                } // case 10
              case 16:
                {
                  inclusionMode_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList projectIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureProjectIdsIsMutable() {
        if (!projectIds_.isModifiable()) {
          projectIds_ = new com.google.protobuf.LazyStringArrayList(projectIds_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * The project ids to use for filtering asset discovery.
       * </pre>
       *
       * <code>repeated string project_ids = 1;</code>
       *
       * @return A list containing the projectIds.
       */
      public com.google.protobuf.ProtocolStringList getProjectIdsList() {
        projectIds_.makeImmutable();
        return projectIds_;
      }
      /**
       *
       *
       * <pre>
       * The project ids to use for filtering asset discovery.
       * </pre>
       *
       * <code>repeated string project_ids = 1;</code>
       *
       * @return The count of projectIds.
       */
      public int getProjectIdsCount() {
        return projectIds_.size();
      }
      /**
       *
       *
       * <pre>
       * The project ids to use for filtering asset discovery.
       * </pre>
       *
       * <code>repeated string project_ids = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The projectIds at the given index.
       */
      public java.lang.String getProjectIds(int index) {
        return projectIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The project ids to use for filtering asset discovery.
       * </pre>
       *
       * <code>repeated string project_ids = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the projectIds at the given index.
       */
      public com.google.protobuf.ByteString getProjectIdsBytes(int index) {
        return projectIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The project ids to use for filtering asset discovery.
       * </pre>
       *
       * <code>repeated string project_ids = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The projectIds to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectIdsIsMutable();
        projectIds_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The project ids to use for filtering asset discovery.
       * </pre>
       *
       * <code>repeated string project_ids = 1;</code>
       *
       * @param value The projectIds to add.
       * @return This builder for chaining.
       */
      public Builder addProjectIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectIdsIsMutable();
        projectIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The project ids to use for filtering asset discovery.
       * </pre>
       *
       * <code>repeated string project_ids = 1;</code>
       *
       * @param values The projectIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllProjectIds(java.lang.Iterable<java.lang.String> values) {
        ensureProjectIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, projectIds_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The project ids to use for filtering asset discovery.
       * </pre>
       *
       * <code>repeated string project_ids = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectIds() {
        projectIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The project ids to use for filtering asset discovery.
       * </pre>
       *
       * <code>repeated string project_ids = 1;</code>
       *
       * @param value The bytes of the projectIds to add.
       * @return This builder for chaining.
       */
      public Builder addProjectIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureProjectIdsIsMutable();
        projectIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int inclusionMode_ = 0;
      /**
       *
       *
       * <pre>
       * The mode to use for filtering asset discovery.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode inclusion_mode = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for inclusionMode.
       */
      @java.lang.Override
      public int getInclusionModeValue() {
        return inclusionMode_;
      }
      /**
       *
       *
       * <pre>
       * The mode to use for filtering asset discovery.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode inclusion_mode = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for inclusionMode to set.
       * @return This builder for chaining.
       */
      public Builder setInclusionModeValue(int value) {
        inclusionMode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The mode to use for filtering asset discovery.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode inclusion_mode = 2;
       * </code>
       *
       * @return The inclusionMode.
       */
      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
              .InclusionMode
          getInclusionMode() {
        com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                .InclusionMode
            result =
                com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                    .InclusionMode.forNumber(inclusionMode_);
        return result == null
            ? com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                .InclusionMode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The mode to use for filtering asset discovery.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode inclusion_mode = 2;
       * </code>
       *
       * @param value The inclusionMode to set.
       * @return This builder for chaining.
       */
      public Builder setInclusionMode(
          com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                  .InclusionMode
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        inclusionMode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The mode to use for filtering asset discovery.
       * </pre>
       *
       * <code>
       * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.InclusionMode inclusion_mode = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInclusionMode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        inclusionMode_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig)
    private static final com.google.cloud.securitycenter.v1beta1.OrganizationSettings
            .AssetDiscoveryConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig();
    }

    public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AssetDiscoveryConfig> PARSER =
        new com.google.protobuf.AbstractParser<AssetDiscoveryConfig>() {
          @java.lang.Override
          public AssetDiscoveryConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AssetDiscoveryConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AssetDiscoveryConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The relative resource name of the settings. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/{organization_id}/organizationSettings".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative resource name of the settings. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/{organization_id}/organizationSettings".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_ASSET_DISCOVERY_FIELD_NUMBER = 2;
  private boolean enableAssetDiscovery_ = false;
  /**
   *
   *
   * <pre>
   * A flag that indicates if Asset Discovery should be enabled. If the flag is
   * set to `true`, then discovery of assets will occur. If it is set to `false,
   * all historical assets will remain, but discovery of future assets will not
   * occur.
   * </pre>
   *
   * <code>bool enable_asset_discovery = 2;</code>
   *
   * @return The enableAssetDiscovery.
   */
  @java.lang.Override
  public boolean getEnableAssetDiscovery() {
    return enableAssetDiscovery_;
  }

  public static final int ASSET_DISCOVERY_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
      assetDiscoveryConfig_;
  /**
   *
   *
   * <pre>
   * The configuration used for Asset Discovery runs.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
   * </code>
   *
   * @return Whether the assetDiscoveryConfig field is set.
   */
  @java.lang.Override
  public boolean hasAssetDiscoveryConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The configuration used for Asset Discovery runs.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
   * </code>
   *
   * @return The assetDiscoveryConfig.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
      getAssetDiscoveryConfig() {
    return assetDiscoveryConfig_ == null
        ? com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
            .getDefaultInstance()
        : assetDiscoveryConfig_;
  }
  /**
   *
   *
   * <pre>
   * The configuration used for Asset Discovery runs.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfigOrBuilder
      getAssetDiscoveryConfigOrBuilder() {
    return assetDiscoveryConfig_ == null
        ? com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
            .getDefaultInstance()
        : assetDiscoveryConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (enableAssetDiscovery_ != false) {
      output.writeBool(2, enableAssetDiscovery_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getAssetDiscoveryConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (enableAssetDiscovery_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableAssetDiscovery_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAssetDiscoveryConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1beta1.OrganizationSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1beta1.OrganizationSettings other =
        (com.google.cloud.securitycenter.v1beta1.OrganizationSettings) obj;

    if (!getName().equals(other.getName())) return false;
    if (getEnableAssetDiscovery() != other.getEnableAssetDiscovery()) return false;
    if (hasAssetDiscoveryConfig() != other.hasAssetDiscoveryConfig()) return false;
    if (hasAssetDiscoveryConfig()) {
      if (!getAssetDiscoveryConfig().equals(other.getAssetDiscoveryConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ENABLE_ASSET_DISCOVERY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAssetDiscovery());
    if (hasAssetDiscoveryConfig()) {
      hash = (37 * hash) + ASSET_DISCOVERY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAssetDiscoveryConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.securitycenter.v1beta1.OrganizationSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * User specified settings that are attached to the Security Command
   * Center organization.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1beta1.OrganizationSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1beta1.OrganizationSettings)
      com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1beta1.OrganizationSettings.class,
              com.google.cloud.securitycenter.v1beta1.OrganizationSettings.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1beta1.OrganizationSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAssetDiscoveryConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      enableAssetDiscovery_ = false;
      assetDiscoveryConfig_ = null;
      if (assetDiscoveryConfigBuilder_ != null) {
        assetDiscoveryConfigBuilder_.dispose();
        assetDiscoveryConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1beta1.OrganizationSettingsOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_OrganizationSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.OrganizationSettings
        getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1beta1.OrganizationSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.OrganizationSettings build() {
      com.google.cloud.securitycenter.v1beta1.OrganizationSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.OrganizationSettings buildPartial() {
      com.google.cloud.securitycenter.v1beta1.OrganizationSettings result =
          new com.google.cloud.securitycenter.v1beta1.OrganizationSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.securitycenter.v1beta1.OrganizationSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.enableAssetDiscovery_ = enableAssetDiscovery_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.assetDiscoveryConfig_ =
            assetDiscoveryConfigBuilder_ == null
                ? assetDiscoveryConfig_
                : assetDiscoveryConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1beta1.OrganizationSettings) {
        return mergeFrom((com.google.cloud.securitycenter.v1beta1.OrganizationSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1beta1.OrganizationSettings other) {
      if (other
          == com.google.cloud.securitycenter.v1beta1.OrganizationSettings.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getEnableAssetDiscovery() != false) {
        setEnableAssetDiscovery(other.getEnableAssetDiscovery());
      }
      if (other.hasAssetDiscoveryConfig()) {
        mergeAssetDiscoveryConfig(other.getAssetDiscoveryConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                enableAssetDiscovery_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    getAssetDiscoveryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The relative resource name of the settings. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/organizationSettings".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the settings. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/organizationSettings".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the settings. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/organizationSettings".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the settings. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/organizationSettings".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the settings. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/organizationSettings".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean enableAssetDiscovery_;
    /**
     *
     *
     * <pre>
     * A flag that indicates if Asset Discovery should be enabled. If the flag is
     * set to `true`, then discovery of assets will occur. If it is set to `false,
     * all historical assets will remain, but discovery of future assets will not
     * occur.
     * </pre>
     *
     * <code>bool enable_asset_discovery = 2;</code>
     *
     * @return The enableAssetDiscovery.
     */
    @java.lang.Override
    public boolean getEnableAssetDiscovery() {
      return enableAssetDiscovery_;
    }
    /**
     *
     *
     * <pre>
     * A flag that indicates if Asset Discovery should be enabled. If the flag is
     * set to `true`, then discovery of assets will occur. If it is set to `false,
     * all historical assets will remain, but discovery of future assets will not
     * occur.
     * </pre>
     *
     * <code>bool enable_asset_discovery = 2;</code>
     *
     * @param value The enableAssetDiscovery to set.
     * @return This builder for chaining.
     */
    public Builder setEnableAssetDiscovery(boolean value) {

      enableAssetDiscovery_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A flag that indicates if Asset Discovery should be enabled. If the flag is
     * set to `true`, then discovery of assets will occur. If it is set to `false,
     * all historical assets will remain, but discovery of future assets will not
     * occur.
     * </pre>
     *
     * <code>bool enable_asset_discovery = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableAssetDiscovery() {
      bitField0_ = (bitField0_ & ~0x00000002);
      enableAssetDiscovery_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        assetDiscoveryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig,
            com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                .Builder,
            com.google.cloud.securitycenter.v1beta1.OrganizationSettings
                .AssetDiscoveryConfigOrBuilder>
        assetDiscoveryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
     * </code>
     *
     * @return Whether the assetDiscoveryConfig field is set.
     */
    public boolean hasAssetDiscoveryConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
     * </code>
     *
     * @return The assetDiscoveryConfig.
     */
    public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
        getAssetDiscoveryConfig() {
      if (assetDiscoveryConfigBuilder_ == null) {
        return assetDiscoveryConfig_ == null
            ? com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                .getDefaultInstance()
            : assetDiscoveryConfig_;
      } else {
        return assetDiscoveryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
     * </code>
     */
    public Builder setAssetDiscoveryConfig(
        com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig value) {
      if (assetDiscoveryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assetDiscoveryConfig_ = value;
      } else {
        assetDiscoveryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
     * </code>
     */
    public Builder setAssetDiscoveryConfig(
        com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.Builder
            builderForValue) {
      if (assetDiscoveryConfigBuilder_ == null) {
        assetDiscoveryConfig_ = builderForValue.build();
      } else {
        assetDiscoveryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
     * </code>
     */
    public Builder mergeAssetDiscoveryConfig(
        com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig value) {
      if (assetDiscoveryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && assetDiscoveryConfig_ != null
            && assetDiscoveryConfig_
                != com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                    .getDefaultInstance()) {
          getAssetDiscoveryConfigBuilder().mergeFrom(value);
        } else {
          assetDiscoveryConfig_ = value;
        }
      } else {
        assetDiscoveryConfigBuilder_.mergeFrom(value);
      }
      if (assetDiscoveryConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
     * </code>
     */
    public Builder clearAssetDiscoveryConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      assetDiscoveryConfig_ = null;
      if (assetDiscoveryConfigBuilder_ != null) {
        assetDiscoveryConfigBuilder_.dispose();
        assetDiscoveryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig.Builder
        getAssetDiscoveryConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAssetDiscoveryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.OrganizationSettings
            .AssetDiscoveryConfigOrBuilder
        getAssetDiscoveryConfigOrBuilder() {
      if (assetDiscoveryConfigBuilder_ != null) {
        return assetDiscoveryConfigBuilder_.getMessageOrBuilder();
      } else {
        return assetDiscoveryConfig_ == null
            ? com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                .getDefaultInstance()
            : assetDiscoveryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration used for Asset Discovery runs.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig asset_discovery_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig,
            com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                .Builder,
            com.google.cloud.securitycenter.v1beta1.OrganizationSettings
                .AssetDiscoveryConfigOrBuilder>
        getAssetDiscoveryConfigFieldBuilder() {
      if (assetDiscoveryConfigBuilder_ == null) {
        assetDiscoveryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig,
                com.google.cloud.securitycenter.v1beta1.OrganizationSettings.AssetDiscoveryConfig
                    .Builder,
                com.google.cloud.securitycenter.v1beta1.OrganizationSettings
                    .AssetDiscoveryConfigOrBuilder>(
                getAssetDiscoveryConfig(), getParentForChildren(), isClean());
        assetDiscoveryConfig_ = null;
      }
      return assetDiscoveryConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1beta1.OrganizationSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1beta1.OrganizationSettings)
  private static final com.google.cloud.securitycenter.v1beta1.OrganizationSettings
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1beta1.OrganizationSettings();
  }

  public static com.google.cloud.securitycenter.v1beta1.OrganizationSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OrganizationSettings> PARSER =
      new com.google.protobuf.AbstractParser<OrganizationSettings>() {
        @java.lang.Override
        public OrganizationSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OrganizationSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OrganizationSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.OrganizationSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
