/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1beta1/asset.proto

package com.google.cloud.securitycenter.v1beta1;

/**
 *
 *
 * <pre>
 * Cloud Security Command Center's (Cloud SCC) representation of a Google Cloud
 * Platform (GCP) resource.
 * The Asset is a Cloud SCC resource that captures information about a single
 * GCP resource. All modifications to an Asset are only within the context of
 * Cloud SCC and don't affect the referenced GCP resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1beta1.Asset}
 */
public final class Asset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1beta1.Asset)
    AssetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Asset.newBuilder() to construct.
  private Asset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Asset() {
    name_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Asset(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder
                  subBuilder = null;
              if (securityCenterProperties_ != null) {
                subBuilder = securityCenterProperties_.toBuilder();
              }
              securityCenterProperties_ =
                  input.readMessage(
                      com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(securityCenterProperties_);
                securityCenterProperties_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                resourceProperties_ =
                    com.google.protobuf.MapField.newMapField(
                        ResourcePropertiesDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000004;
              }
              com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                  resourceProperties__ =
                      input.readMessage(
                          ResourcePropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              resourceProperties_
                  .getMutableMap()
                  .put(resourceProperties__.getKey(), resourceProperties__.getValue());
              break;
            }
          case 66:
            {
              com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder subBuilder = null;
              if (securityMarks_ != null) {
                subBuilder = securityMarks_.toBuilder();
              }
              securityMarks_ =
                  input.readMessage(
                      com.google.cloud.securitycenter.v1beta1.SecurityMarks.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(securityMarks_);
                securityMarks_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
        .internal_static_google_cloud_securitycenter_v1beta1_Asset_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetResourceProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
        .internal_static_google_cloud_securitycenter_v1beta1_Asset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1beta1.Asset.class,
            com.google.cloud.securitycenter.v1beta1.Asset.Builder.class);
  }

  public interface SecurityCenterPropertiesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The full resource name of the GCP resource this asset
     * represents. This field is immutable after create time. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     */
    java.lang.String getResourceName();
    /**
     *
     *
     * <pre>
     * The full resource name of the GCP resource this asset
     * represents. This field is immutable after create time. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     */
    com.google.protobuf.ByteString getResourceNameBytes();

    /**
     *
     *
     * <pre>
     * The type of the GCP resource. Examples include: APPLICATION,
     * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
     * Cloud SCC and/or the producer of the resource and is immutable
     * after create time.
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     */
    java.lang.String getResourceType();
    /**
     *
     *
     * <pre>
     * The type of the GCP resource. Examples include: APPLICATION,
     * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
     * Cloud SCC and/or the producer of the resource and is immutable
     * after create time.
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     */
    com.google.protobuf.ByteString getResourceTypeBytes();

    /**
     *
     *
     * <pre>
     * The full resource name of the immediate parent of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_parent = 3;</code>
     */
    java.lang.String getResourceParent();
    /**
     *
     *
     * <pre>
     * The full resource name of the immediate parent of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_parent = 3;</code>
     */
    com.google.protobuf.ByteString getResourceParentBytes();

    /**
     *
     *
     * <pre>
     * The full resource name of the project the resource belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_project = 4;</code>
     */
    java.lang.String getResourceProject();
    /**
     *
     *
     * <pre>
     * The full resource name of the project the resource belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_project = 4;</code>
     */
    com.google.protobuf.ByteString getResourceProjectBytes();

    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     */
    java.util.List<java.lang.String> getResourceOwnersList();
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     */
    int getResourceOwnersCount();
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     */
    java.lang.String getResourceOwners(int index);
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     */
    com.google.protobuf.ByteString getResourceOwnersBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Cloud SCC managed properties. These properties are managed by Cloud SCC and
   * cannot be modified by the user.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties}
   */
  public static final class SecurityCenterProperties extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
      SecurityCenterPropertiesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SecurityCenterProperties.newBuilder() to construct.
    private SecurityCenterProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SecurityCenterProperties() {
      resourceName_ = "";
      resourceType_ = "";
      resourceParent_ = "";
      resourceProject_ = "";
      resourceOwners_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private SecurityCenterProperties(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                resourceName_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                resourceType_ = s;
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                resourceParent_ = s;
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                resourceProject_ = s;
                break;
              }
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                  resourceOwners_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000010;
                }
                resourceOwners_.add(s);
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) != 0)) {
          resourceOwners_ = resourceOwners_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.class,
              com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder.class);
    }

    private int bitField0_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object resourceName_;
    /**
     *
     *
     * <pre>
     * The full resource name of the GCP resource this asset
     * represents. This field is immutable after create time. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the GCP resource this asset
     * represents. This field is immutable after create time. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_TYPE_FIELD_NUMBER = 2;
    private volatile java.lang.Object resourceType_;
    /**
     *
     *
     * <pre>
     * The type of the GCP resource. Examples include: APPLICATION,
     * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
     * Cloud SCC and/or the producer of the resource and is immutable
     * after create time.
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     */
    public java.lang.String getResourceType() {
      java.lang.Object ref = resourceType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the GCP resource. Examples include: APPLICATION,
     * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
     * Cloud SCC and/or the producer of the resource and is immutable
     * after create time.
     * </pre>
     *
     * <code>string resource_type = 2;</code>
     */
    public com.google.protobuf.ByteString getResourceTypeBytes() {
      java.lang.Object ref = resourceType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_PARENT_FIELD_NUMBER = 3;
    private volatile java.lang.Object resourceParent_;
    /**
     *
     *
     * <pre>
     * The full resource name of the immediate parent of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_parent = 3;</code>
     */
    public java.lang.String getResourceParent() {
      java.lang.Object ref = resourceParent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceParent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the immediate parent of the resource. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_parent = 3;</code>
     */
    public com.google.protobuf.ByteString getResourceParentBytes() {
      java.lang.Object ref = resourceParent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceParent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_PROJECT_FIELD_NUMBER = 4;
    private volatile java.lang.Object resourceProject_;
    /**
     *
     *
     * <pre>
     * The full resource name of the project the resource belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_project = 4;</code>
     */
    public java.lang.String getResourceProject() {
      java.lang.Object ref = resourceProject_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceProject_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the project the resource belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * </pre>
     *
     * <code>string resource_project = 4;</code>
     */
    public com.google.protobuf.ByteString getResourceProjectBytes() {
      java.lang.Object ref = resourceProject_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceProject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_OWNERS_FIELD_NUMBER = 5;
    private com.google.protobuf.LazyStringList resourceOwners_;
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     */
    public com.google.protobuf.ProtocolStringList getResourceOwnersList() {
      return resourceOwners_;
    }
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     */
    public int getResourceOwnersCount() {
      return resourceOwners_.size();
    }
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     */
    public java.lang.String getResourceOwners(int index) {
      return resourceOwners_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Owners of the Google Cloud resource.
     * </pre>
     *
     * <code>repeated string resource_owners = 5;</code>
     */
    public com.google.protobuf.ByteString getResourceOwnersBytes(int index) {
      return resourceOwners_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getResourceNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
      }
      if (!getResourceTypeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceType_);
      }
      if (!getResourceParentBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resourceParent_);
      }
      if (!getResourceProjectBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resourceProject_);
      }
      for (int i = 0; i < resourceOwners_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, resourceOwners_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getResourceNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
      }
      if (!getResourceTypeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resourceType_);
      }
      if (!getResourceParentBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resourceParent_);
      }
      if (!getResourceProjectBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, resourceProject_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < resourceOwners_.size(); i++) {
          dataSize += computeStringSizeNoTag(resourceOwners_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getResourceOwnersList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)) {
        return super.equals(obj);
      }
      com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties other =
          (com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties) obj;

      if (!getResourceName().equals(other.getResourceName())) return false;
      if (!getResourceType().equals(other.getResourceType())) return false;
      if (!getResourceParent().equals(other.getResourceParent())) return false;
      if (!getResourceProject().equals(other.getResourceProject())) return false;
      if (!getResourceOwnersList().equals(other.getResourceOwnersList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getResourceName().hashCode();
      hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getResourceType().hashCode();
      hash = (37 * hash) + RESOURCE_PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getResourceParent().hashCode();
      hash = (37 * hash) + RESOURCE_PROJECT_FIELD_NUMBER;
      hash = (53 * hash) + getResourceProject().hashCode();
      if (getResourceOwnersCount() > 0) {
        hash = (37 * hash) + RESOURCE_OWNERS_FIELD_NUMBER;
        hash = (53 * hash) + getResourceOwnersList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by Cloud SCC and
     * cannot be modified by the user.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
            .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
            .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.class,
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        resourceName_ = "";

        resourceType_ = "";

        resourceParent_ = "";

        resourceProject_ = "";

        resourceOwners_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
            .internal_static_google_cloud_securitycenter_v1beta1_Asset_SecurityCenterProperties_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
          getDefaultInstanceForType() {
        return com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties build() {
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties buildPartial() {
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties result =
            new com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.resourceName_ = resourceName_;
        result.resourceType_ = resourceType_;
        result.resourceParent_ = resourceParent_;
        result.resourceProject_ = resourceProject_;
        if (((bitField0_ & 0x00000010) != 0)) {
          resourceOwners_ = resourceOwners_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.resourceOwners_ = resourceOwners_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties) {
          return mergeFrom(
              (com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties other) {
        if (other
            == com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
                .getDefaultInstance()) return this;
        if (!other.getResourceName().isEmpty()) {
          resourceName_ = other.resourceName_;
          onChanged();
        }
        if (!other.getResourceType().isEmpty()) {
          resourceType_ = other.resourceType_;
          onChanged();
        }
        if (!other.getResourceParent().isEmpty()) {
          resourceParent_ = other.resourceParent_;
          onChanged();
        }
        if (!other.getResourceProject().isEmpty()) {
          resourceProject_ = other.resourceProject_;
          onChanged();
        }
        if (!other.resourceOwners_.isEmpty()) {
          if (resourceOwners_.isEmpty()) {
            resourceOwners_ = other.resourceOwners_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureResourceOwnersIsMutable();
            resourceOwners_.addAll(other.resourceOwners_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object resourceName_ = "";
      /**
       *
       *
       * <pre>
       * The full resource name of the GCP resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       */
      public java.lang.String getResourceName() {
        java.lang.Object ref = resourceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the GCP resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       */
      public com.google.protobuf.ByteString getResourceNameBytes() {
        java.lang.Object ref = resourceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the GCP resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       */
      public Builder setResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        resourceName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the GCP resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       */
      public Builder clearResourceName() {

        resourceName_ = getDefaultInstance().getResourceName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the GCP resource this asset
       * represents. This field is immutable after create time. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_name = 1;</code>
       */
      public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        resourceName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object resourceType_ = "";
      /**
       *
       *
       * <pre>
       * The type of the GCP resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Cloud SCC and/or the producer of the resource and is immutable
       * after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       */
      public java.lang.String getResourceType() {
        java.lang.Object ref = resourceType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The type of the GCP resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Cloud SCC and/or the producer of the resource and is immutable
       * after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       */
      public com.google.protobuf.ByteString getResourceTypeBytes() {
        java.lang.Object ref = resourceType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The type of the GCP resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Cloud SCC and/or the producer of the resource and is immutable
       * after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       */
      public Builder setResourceType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        resourceType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the GCP resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Cloud SCC and/or the producer of the resource and is immutable
       * after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       */
      public Builder clearResourceType() {

        resourceType_ = getDefaultInstance().getResourceType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the GCP resource. Examples include: APPLICATION,
       * PROJECT, and ORGANIZATION. This is a case insensitive field defined by
       * Cloud SCC and/or the producer of the resource and is immutable
       * after create time.
       * </pre>
       *
       * <code>string resource_type = 2;</code>
       */
      public Builder setResourceTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        resourceType_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object resourceParent_ = "";
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       */
      public java.lang.String getResourceParent() {
        java.lang.Object ref = resourceParent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceParent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       */
      public com.google.protobuf.ByteString getResourceParentBytes() {
        java.lang.Object ref = resourceParent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceParent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       */
      public Builder setResourceParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        resourceParent_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       */
      public Builder clearResourceParent() {

        resourceParent_ = getDefaultInstance().getResourceParent();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the immediate parent of the resource. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_parent = 3;</code>
       */
      public Builder setResourceParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        resourceParent_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object resourceProject_ = "";
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       */
      public java.lang.String getResourceProject() {
        java.lang.Object ref = resourceProject_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceProject_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       */
      public com.google.protobuf.ByteString getResourceProjectBytes() {
        java.lang.Object ref = resourceProject_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceProject_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       */
      public Builder setResourceProject(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        resourceProject_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       */
      public Builder clearResourceProject() {

        resourceProject_ = getDefaultInstance().getResourceProject();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of the project the resource belongs to. See:
       * https://cloud.google.com/apis/design/resource_names#full_resource_name
       * </pre>
       *
       * <code>string resource_project = 4;</code>
       */
      public Builder setResourceProjectBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        resourceProject_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList resourceOwners_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureResourceOwnersIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          resourceOwners_ = new com.google.protobuf.LazyStringArrayList(resourceOwners_);
          bitField0_ |= 0x00000010;
        }
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       */
      public com.google.protobuf.ProtocolStringList getResourceOwnersList() {
        return resourceOwners_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       */
      public int getResourceOwnersCount() {
        return resourceOwners_.size();
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       */
      public java.lang.String getResourceOwners(int index) {
        return resourceOwners_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       */
      public com.google.protobuf.ByteString getResourceOwnersBytes(int index) {
        return resourceOwners_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       */
      public Builder setResourceOwners(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceOwnersIsMutable();
        resourceOwners_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       */
      public Builder addResourceOwners(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceOwnersIsMutable();
        resourceOwners_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       */
      public Builder addAllResourceOwners(java.lang.Iterable<java.lang.String> values) {
        ensureResourceOwnersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceOwners_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       */
      public Builder clearResourceOwners() {
        resourceOwners_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Owners of the Google Cloud resource.
       * </pre>
       *
       * <code>repeated string resource_owners = 5;</code>
       */
      public Builder addResourceOwnersBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureResourceOwnersIsMutable();
        resourceOwners_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties)
    private static final com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties();
    }

    public static com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SecurityCenterProperties> PARSER =
        new com.google.protobuf.AbstractParser<SecurityCenterProperties>() {
          @java.lang.Override
          public SecurityCenterProperties parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new SecurityCenterProperties(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<SecurityCenterProperties> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SecurityCenterProperties> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The relative resource name of this asset. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/123/assets/456".
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative resource name of this asset. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/123/assets/456".
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECURITY_CENTER_PROPERTIES_FIELD_NUMBER = 2;
  private com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
      securityCenterProperties_;
  /**
   *
   *
   * <pre>
   * Cloud SCC managed properties. These properties are managed by
   * Cloud SCC and cannot be modified by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
   * </code>
   */
  public boolean hasSecurityCenterProperties() {
    return securityCenterProperties_ != null;
  }
  /**
   *
   *
   * <pre>
   * Cloud SCC managed properties. These properties are managed by
   * Cloud SCC and cannot be modified by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
   * </code>
   */
  public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
      getSecurityCenterProperties() {
    return securityCenterProperties_ == null
        ? com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
            .getDefaultInstance()
        : securityCenterProperties_;
  }
  /**
   *
   *
   * <pre>
   * Cloud SCC managed properties. These properties are managed by
   * Cloud SCC and cannot be modified by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
   * </code>
   */
  public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder
      getSecurityCenterPropertiesOrBuilder() {
    return getSecurityCenterProperties();
  }

  public static final int RESOURCE_PROPERTIES_FIELD_NUMBER = 7;

  private static final class ResourcePropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.securitycenter.v1beta1.AssetOuterClass
                        .internal_static_google_cloud_securitycenter_v1beta1_Asset_ResourcePropertiesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      resourceProperties_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetResourceProperties() {
    if (resourceProperties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ResourcePropertiesDefaultEntryHolder.defaultEntry);
    }
    return resourceProperties_;
  }

  public int getResourcePropertiesCount() {
    return internalGetResourceProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource managed properties. These properties are managed and defined by
   * the GCP resource and cannot be modified by the user.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
   */
  public boolean containsResourceProperties(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetResourceProperties().getMap().containsKey(key);
  }
  /** Use {@link #getResourcePropertiesMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getResourceProperties() {
    return getResourcePropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Resource managed properties. These properties are managed and defined by
   * the GCP resource and cannot be modified by the user.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
   */
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getResourcePropertiesMap() {
    return internalGetResourceProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource managed properties. These properties are managed and defined by
   * the GCP resource and cannot be modified by the user.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
   */
  public com.google.protobuf.Value getResourcePropertiesOrDefault(
      java.lang.String key, com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetResourceProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource managed properties. These properties are managed and defined by
   * the GCP resource and cannot be modified by the user.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
   */
  public com.google.protobuf.Value getResourcePropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetResourceProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SECURITY_MARKS_FIELD_NUMBER = 8;
  private com.google.cloud.securitycenter.v1beta1.SecurityMarks securityMarks_;
  /**
   *
   *
   * <pre>
   * User specified security marks. These marks are entirely managed by the user
   * and come from the SecurityMarks resource that belongs to the asset.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
   */
  public boolean hasSecurityMarks() {
    return securityMarks_ != null;
  }
  /**
   *
   *
   * <pre>
   * User specified security marks. These marks are entirely managed by the user
   * and come from the SecurityMarks resource that belongs to the asset.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
   */
  public com.google.cloud.securitycenter.v1beta1.SecurityMarks getSecurityMarks() {
    return securityMarks_ == null
        ? com.google.cloud.securitycenter.v1beta1.SecurityMarks.getDefaultInstance()
        : securityMarks_;
  }
  /**
   *
   *
   * <pre>
   * User specified security marks. These marks are entirely managed by the user
   * and come from the SecurityMarks resource that belongs to the asset.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
   */
  public com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder
      getSecurityMarksOrBuilder() {
    return getSecurityMarks();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time at which the asset was created in Cloud SCC.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9;</code>
   */
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the asset was created in Cloud SCC.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9;</code>
   */
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the asset was created in Cloud SCC.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * The time at which the asset was last updated, added, or deleted in Cloud
   * SCC.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10;</code>
   */
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the asset was last updated, added, or deleted in Cloud
   * SCC.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10;</code>
   */
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the asset was last updated, added, or deleted in Cloud
   * SCC.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (securityCenterProperties_ != null) {
      output.writeMessage(2, getSecurityCenterProperties());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetResourceProperties(),
        ResourcePropertiesDefaultEntryHolder.defaultEntry,
        7);
    if (securityMarks_ != null) {
      output.writeMessage(8, getSecurityMarks());
    }
    if (createTime_ != null) {
      output.writeMessage(9, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(10, getUpdateTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (securityCenterProperties_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getSecurityCenterProperties());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetResourceProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          resourceProperties__ =
              ResourcePropertiesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, resourceProperties__);
    }
    if (securityMarks_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSecurityMarks());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1beta1.Asset)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1beta1.Asset other =
        (com.google.cloud.securitycenter.v1beta1.Asset) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSecurityCenterProperties() != other.hasSecurityCenterProperties()) return false;
    if (hasSecurityCenterProperties()) {
      if (!getSecurityCenterProperties().equals(other.getSecurityCenterProperties())) return false;
    }
    if (!internalGetResourceProperties().equals(other.internalGetResourceProperties()))
      return false;
    if (hasSecurityMarks() != other.hasSecurityMarks()) return false;
    if (hasSecurityMarks()) {
      if (!getSecurityMarks().equals(other.getSecurityMarks())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSecurityCenterProperties()) {
      hash = (37 * hash) + SECURITY_CENTER_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityCenterProperties().hashCode();
    }
    if (!internalGetResourceProperties().getMap().isEmpty()) {
      hash = (37 * hash) + RESOURCE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetResourceProperties().hashCode();
    }
    if (hasSecurityMarks()) {
      hash = (37 * hash) + SECURITY_MARKS_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityMarks().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1beta1.Asset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Cloud Security Command Center's (Cloud SCC) representation of a Google Cloud
   * Platform (GCP) resource.
   * The Asset is a Cloud SCC resource that captures information about a single
   * GCP resource. All modifications to an Asset are only within the context of
   * Cloud SCC and don't affect the referenced GCP resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1beta1.Asset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1beta1.Asset)
      com.google.cloud.securitycenter.v1beta1.AssetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetResourceProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableResourceProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1beta1.Asset.class,
              com.google.cloud.securitycenter.v1beta1.Asset.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1beta1.Asset.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (securityCenterPropertiesBuilder_ == null) {
        securityCenterProperties_ = null;
      } else {
        securityCenterProperties_ = null;
        securityCenterPropertiesBuilder_ = null;
      }
      internalGetMutableResourceProperties().clear();
      if (securityMarksBuilder_ == null) {
        securityMarks_ = null;
      } else {
        securityMarks_ = null;
        securityMarksBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1beta1.AssetOuterClass
          .internal_static_google_cloud_securitycenter_v1beta1_Asset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.Asset getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1beta1.Asset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.Asset build() {
      com.google.cloud.securitycenter.v1beta1.Asset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1beta1.Asset buildPartial() {
      com.google.cloud.securitycenter.v1beta1.Asset result =
          new com.google.cloud.securitycenter.v1beta1.Asset(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.name_ = name_;
      if (securityCenterPropertiesBuilder_ == null) {
        result.securityCenterProperties_ = securityCenterProperties_;
      } else {
        result.securityCenterProperties_ = securityCenterPropertiesBuilder_.build();
      }
      result.resourceProperties_ = internalGetResourceProperties();
      result.resourceProperties_.makeImmutable();
      if (securityMarksBuilder_ == null) {
        result.securityMarks_ = securityMarks_;
      } else {
        result.securityMarks_ = securityMarksBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1beta1.Asset) {
        return mergeFrom((com.google.cloud.securitycenter.v1beta1.Asset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1beta1.Asset other) {
      if (other == com.google.cloud.securitycenter.v1beta1.Asset.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasSecurityCenterProperties()) {
        mergeSecurityCenterProperties(other.getSecurityCenterProperties());
      }
      internalGetMutableResourceProperties().mergeFrom(other.internalGetResourceProperties());
      if (other.hasSecurityMarks()) {
        mergeSecurityMarks(other.getSecurityMarks());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.securitycenter.v1beta1.Asset parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.securitycenter.v1beta1.Asset) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/123/assets/456".
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/123/assets/456".
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/123/assets/456".
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/123/assets/456".
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this asset. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/123/assets/456".
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        securityCenterProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties,
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder,
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder>
        securityCenterPropertiesBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by
     * Cloud SCC and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public boolean hasSecurityCenterProperties() {
      return securityCenterPropertiesBuilder_ != null || securityCenterProperties_ != null;
    }
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by
     * Cloud SCC and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
        getSecurityCenterProperties() {
      if (securityCenterPropertiesBuilder_ == null) {
        return securityCenterProperties_ == null
            ? com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
                .getDefaultInstance()
            : securityCenterProperties_;
      } else {
        return securityCenterPropertiesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by
     * Cloud SCC and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public Builder setSecurityCenterProperties(
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties value) {
      if (securityCenterPropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securityCenterProperties_ = value;
        onChanged();
      } else {
        securityCenterPropertiesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by
     * Cloud SCC and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public Builder setSecurityCenterProperties(
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder
            builderForValue) {
      if (securityCenterPropertiesBuilder_ == null) {
        securityCenterProperties_ = builderForValue.build();
        onChanged();
      } else {
        securityCenterPropertiesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by
     * Cloud SCC and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public Builder mergeSecurityCenterProperties(
        com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties value) {
      if (securityCenterPropertiesBuilder_ == null) {
        if (securityCenterProperties_ != null) {
          securityCenterProperties_ =
              com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.newBuilder(
                      securityCenterProperties_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          securityCenterProperties_ = value;
        }
        onChanged();
      } else {
        securityCenterPropertiesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by
     * Cloud SCC and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public Builder clearSecurityCenterProperties() {
      if (securityCenterPropertiesBuilder_ == null) {
        securityCenterProperties_ = null;
        onChanged();
      } else {
        securityCenterProperties_ = null;
        securityCenterPropertiesBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by
     * Cloud SCC and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder
        getSecurityCenterPropertiesBuilder() {

      onChanged();
      return getSecurityCenterPropertiesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by
     * Cloud SCC and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    public com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder
        getSecurityCenterPropertiesOrBuilder() {
      if (securityCenterPropertiesBuilder_ != null) {
        return securityCenterPropertiesBuilder_.getMessageOrBuilder();
      } else {
        return securityCenterProperties_ == null
            ? com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties
                .getDefaultInstance()
            : securityCenterProperties_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud SCC managed properties. These properties are managed by
     * Cloud SCC and cannot be modified by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties security_center_properties = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties,
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder,
            com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder>
        getSecurityCenterPropertiesFieldBuilder() {
      if (securityCenterPropertiesBuilder_ == null) {
        securityCenterPropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties,
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties.Builder,
                com.google.cloud.securitycenter.v1beta1.Asset.SecurityCenterPropertiesOrBuilder>(
                getSecurityCenterProperties(), getParentForChildren(), isClean());
        securityCenterProperties_ = null;
      }
      return securityCenterPropertiesBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        resourceProperties_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetResourceProperties() {
      if (resourceProperties_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ResourcePropertiesDefaultEntryHolder.defaultEntry);
      }
      return resourceProperties_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetMutableResourceProperties() {
      onChanged();
      ;
      if (resourceProperties_ == null) {
        resourceProperties_ =
            com.google.protobuf.MapField.newMapField(
                ResourcePropertiesDefaultEntryHolder.defaultEntry);
      }
      if (!resourceProperties_.isMutable()) {
        resourceProperties_ = resourceProperties_.copy();
      }
      return resourceProperties_;
    }

    public int getResourcePropertiesCount() {
      return internalGetResourceProperties().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the GCP resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public boolean containsResourceProperties(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetResourceProperties().getMap().containsKey(key);
    }
    /** Use {@link #getResourcePropertiesMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getResourceProperties() {
      return getResourcePropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the GCP resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getResourcePropertiesMap() {
      return internalGetResourceProperties().getMap();
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the GCP resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public com.google.protobuf.Value getResourcePropertiesOrDefault(
        java.lang.String key, com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetResourceProperties().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the GCP resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public com.google.protobuf.Value getResourcePropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetResourceProperties().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearResourceProperties() {
      internalGetMutableResourceProperties().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the GCP resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public Builder removeResourceProperties(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableResourceProperties().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value>
        getMutableResourceProperties() {
      return internalGetMutableResourceProperties().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the GCP resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public Builder putResourceProperties(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableResourceProperties().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource managed properties. These properties are managed and defined by
     * the GCP resource and cannot be modified by the user.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; resource_properties = 7;</code>
     */
    public Builder putAllResourceProperties(
        java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      internalGetMutableResourceProperties().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.securitycenter.v1beta1.SecurityMarks securityMarks_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.SecurityMarks,
            com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder,
            com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder>
        securityMarksBuilder_;
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public boolean hasSecurityMarks() {
      return securityMarksBuilder_ != null || securityMarks_ != null;
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public com.google.cloud.securitycenter.v1beta1.SecurityMarks getSecurityMarks() {
      if (securityMarksBuilder_ == null) {
        return securityMarks_ == null
            ? com.google.cloud.securitycenter.v1beta1.SecurityMarks.getDefaultInstance()
            : securityMarks_;
      } else {
        return securityMarksBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public Builder setSecurityMarks(com.google.cloud.securitycenter.v1beta1.SecurityMarks value) {
      if (securityMarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securityMarks_ = value;
        onChanged();
      } else {
        securityMarksBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public Builder setSecurityMarks(
        com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder builderForValue) {
      if (securityMarksBuilder_ == null) {
        securityMarks_ = builderForValue.build();
        onChanged();
      } else {
        securityMarksBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public Builder mergeSecurityMarks(com.google.cloud.securitycenter.v1beta1.SecurityMarks value) {
      if (securityMarksBuilder_ == null) {
        if (securityMarks_ != null) {
          securityMarks_ =
              com.google.cloud.securitycenter.v1beta1.SecurityMarks.newBuilder(securityMarks_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          securityMarks_ = value;
        }
        onChanged();
      } else {
        securityMarksBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public Builder clearSecurityMarks() {
      if (securityMarksBuilder_ == null) {
        securityMarks_ = null;
        onChanged();
      } else {
        securityMarks_ = null;
        securityMarksBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder getSecurityMarksBuilder() {

      onChanged();
      return getSecurityMarksFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    public com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder
        getSecurityMarksOrBuilder() {
      if (securityMarksBuilder_ != null) {
        return securityMarksBuilder_.getMessageOrBuilder();
      } else {
        return securityMarks_ == null
            ? com.google.cloud.securitycenter.v1beta1.SecurityMarks.getDefaultInstance()
            : securityMarks_;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified security marks. These marks are entirely managed by the user
     * and come from the SecurityMarks resource that belongs to the asset.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1beta1.SecurityMarks security_marks = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1beta1.SecurityMarks,
            com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder,
            com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder>
        getSecurityMarksFieldBuilder() {
      if (securityMarksBuilder_ == null) {
        securityMarksBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1beta1.SecurityMarks,
                com.google.cloud.securitycenter.v1beta1.SecurityMarks.Builder,
                com.google.cloud.securitycenter.v1beta1.SecurityMarksOrBuilder>(
                getSecurityMarks(), getParentForChildren(), isClean());
        securityMarks_ = null;
      }
      return securityMarksBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Cloud SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Cloud SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Cloud SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Cloud SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Cloud SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Cloud SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Cloud SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Cloud SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was created in Cloud SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Cloud
     * SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Cloud
     * SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Cloud
     * SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Cloud
     * SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Cloud
     * SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Cloud
     * SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Cloud
     * SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Cloud
     * SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the asset was last updated, added, or deleted in Cloud
     * SCC.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1beta1.Asset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1beta1.Asset)
  private static final com.google.cloud.securitycenter.v1beta1.Asset DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1beta1.Asset();
  }

  public static com.google.cloud.securitycenter.v1beta1.Asset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Asset> PARSER =
      new com.google.protobuf.AbstractParser<Asset>() {
        @java.lang.Override
        public Asset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Asset(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Asset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Asset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1beta1.Asset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
