/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1p1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrganizationSettingsName
implements ResourceName {
    private static final PathTemplate ORGANIZATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/organizationSettings");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;

    @Deprecated
    protected OrganizationSettingsName() {
        this.organization = null;
    }

    private OrganizationSettingsName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrganizationSettingsName of(String organization) {
        return OrganizationSettingsName.newBuilder().setOrganization(organization).build();
    }

    public static String format(String organization) {
        return OrganizationSettingsName.newBuilder().setOrganization(organization).build().toString();
    }

    public static OrganizationSettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION.validatedMatch(formattedString, "OrganizationSettingsName.parse: formattedString not in valid format");
        return OrganizationSettingsName.of((String)matchMap.get("organization"));
    }

    public static List<OrganizationSettingsName> parseList(List<String> formattedStrings) {
        ArrayList<OrganizationSettingsName> list = new ArrayList<OrganizationSettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrganizationSettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrganizationSettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrganizationSettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrganizationSettingsName organizationSettingsName = this;
            synchronized (organizationSettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION.instantiate(new String[]{"organization", this.organization});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            OrganizationSettingsName that = (OrganizationSettingsName)o;
            return Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class Builder {
        private String organization;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        private Builder(OrganizationSettingsName organizationSettingsName) {
            this.organization = organizationSettingsName.organization;
        }

        public OrganizationSettingsName build() {
            return new OrganizationSettingsName(this);
        }
    }
}

