/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1p1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationConfigName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_NOTIFICATION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/notificationConfigs/{notification_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String notificationConfig;

    @Deprecated
    protected NotificationConfigName() {
        this.organization = null;
        this.notificationConfig = null;
    }

    private NotificationConfigName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.notificationConfig = (String)Preconditions.checkNotNull((Object)builder.getNotificationConfig());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getNotificationConfig() {
        return this.notificationConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotificationConfigName of(String organization, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setNotificationConfig(notificationConfig).build();
    }

    public static String format(String organization, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setNotificationConfig(notificationConfig).build().toString();
    }

    public static NotificationConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_NOTIFICATION_CONFIG.validatedMatch(formattedString, "NotificationConfigName.parse: formattedString not in valid format");
        return NotificationConfigName.of((String)matchMap.get("organization"), (String)matchMap.get("notification_config"));
    }

    public static List<NotificationConfigName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationConfigName> list = new ArrayList<NotificationConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_NOTIFICATION_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationConfigName notificationConfigName = this;
            synchronized (notificationConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.notificationConfig != null) {
                        fieldMapBuilder.put((Object)"notification_config", (Object)this.notificationConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_NOTIFICATION_CONFIG.instantiate(new String[]{"organization", this.organization, "notification_config", this.notificationConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NotificationConfigName that = (NotificationConfigName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.notificationConfig, that.notificationConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.notificationConfig);
    }

    public static class Builder {
        private String organization;
        private String notificationConfig;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getNotificationConfig() {
            return this.notificationConfig;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setNotificationConfig(String notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        private Builder(NotificationConfigName notificationConfigName) {
            this.organization = notificationConfigName.organization;
            this.notificationConfig = notificationConfigName.notificationConfig;
        }

        public NotificationConfigName build() {
            return new NotificationConfigName(this);
        }
    }
}

