/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycentermanagement.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecurityHealthAnalyticsCustomModuleName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}");
    private static final PathTemplate PROJECT_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}");
    private static final PathTemplate FOLDER_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String securityHealthAnalyticsCustomModule;
    private final String project;
    private final String folder;

    @Deprecated
    protected SecurityHealthAnalyticsCustomModuleName() {
        this.organization = null;
        this.location = null;
        this.securityHealthAnalyticsCustomModule = null;
        this.project = null;
        this.folder = null;
    }

    private SecurityHealthAnalyticsCustomModuleName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.securityHealthAnalyticsCustomModule = (String)Preconditions.checkNotNull((Object)builder.getSecurityHealthAnalyticsCustomModule());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE;
    }

    private SecurityHealthAnalyticsCustomModuleName(ProjectLocationSecurityHealthAnalyticsCustomModuleBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.securityHealthAnalyticsCustomModule = (String)Preconditions.checkNotNull((Object)builder.getSecurityHealthAnalyticsCustomModule());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE;
    }

    private SecurityHealthAnalyticsCustomModuleName(FolderLocationSecurityHealthAnalyticsCustomModuleBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.securityHealthAnalyticsCustomModule = (String)Preconditions.checkNotNull((Object)builder.getSecurityHealthAnalyticsCustomModule());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSecurityHealthAnalyticsCustomModule() {
        return this.securityHealthAnalyticsCustomModule;
    }

    public String getProject() {
        return this.project;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationSecurityHealthAnalyticsCustomModuleBuilder() {
        return new Builder();
    }

    public static ProjectLocationSecurityHealthAnalyticsCustomModuleBuilder newProjectLocationSecurityHealthAnalyticsCustomModuleBuilder() {
        return new ProjectLocationSecurityHealthAnalyticsCustomModuleBuilder();
    }

    public static FolderLocationSecurityHealthAnalyticsCustomModuleBuilder newFolderLocationSecurityHealthAnalyticsCustomModuleBuilder() {
        return new FolderLocationSecurityHealthAnalyticsCustomModuleBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SecurityHealthAnalyticsCustomModuleName of(String organization, String location, String securityHealthAnalyticsCustomModule) {
        return SecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule).build();
    }

    public static SecurityHealthAnalyticsCustomModuleName ofOrganizationLocationSecurityHealthAnalyticsCustomModuleName(String organization, String location, String securityHealthAnalyticsCustomModule) {
        return SecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule).build();
    }

    public static SecurityHealthAnalyticsCustomModuleName ofProjectLocationSecurityHealthAnalyticsCustomModuleName(String project, String location, String securityHealthAnalyticsCustomModule) {
        return SecurityHealthAnalyticsCustomModuleName.newProjectLocationSecurityHealthAnalyticsCustomModuleBuilder().setProject(project).setLocation(location).setSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule).build();
    }

    public static SecurityHealthAnalyticsCustomModuleName ofFolderLocationSecurityHealthAnalyticsCustomModuleName(String folder, String location, String securityHealthAnalyticsCustomModule) {
        return SecurityHealthAnalyticsCustomModuleName.newFolderLocationSecurityHealthAnalyticsCustomModuleBuilder().setFolder(folder).setLocation(location).setSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule).build();
    }

    public static String format(String organization, String location, String securityHealthAnalyticsCustomModule) {
        return SecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule).build().toString();
    }

    public static String formatOrganizationLocationSecurityHealthAnalyticsCustomModuleName(String organization, String location, String securityHealthAnalyticsCustomModule) {
        return SecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setLocation(location).setSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule).build().toString();
    }

    public static String formatProjectLocationSecurityHealthAnalyticsCustomModuleName(String project, String location, String securityHealthAnalyticsCustomModule) {
        return SecurityHealthAnalyticsCustomModuleName.newProjectLocationSecurityHealthAnalyticsCustomModuleBuilder().setProject(project).setLocation(location).setSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule).build().toString();
    }

    public static String formatFolderLocationSecurityHealthAnalyticsCustomModuleName(String folder, String location, String securityHealthAnalyticsCustomModule) {
        return SecurityHealthAnalyticsCustomModuleName.newFolderLocationSecurityHealthAnalyticsCustomModuleBuilder().setFolder(folder).setLocation(location).setSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule).build().toString();
    }

    public static SecurityHealthAnalyticsCustomModuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.match(formattedString);
            return SecurityHealthAnalyticsCustomModuleName.ofOrganizationLocationSecurityHealthAnalyticsCustomModuleName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("security_health_analytics_custom_module"));
        }
        if (PROJECT_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.match(formattedString);
            return SecurityHealthAnalyticsCustomModuleName.ofProjectLocationSecurityHealthAnalyticsCustomModuleName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("security_health_analytics_custom_module"));
        }
        if (FOLDER_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.match(formattedString);
            return SecurityHealthAnalyticsCustomModuleName.ofFolderLocationSecurityHealthAnalyticsCustomModuleName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("security_health_analytics_custom_module"));
        }
        throw new ValidationException("SecurityHealthAnalyticsCustomModuleName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SecurityHealthAnalyticsCustomModuleName> parseList(List<String> formattedStrings) {
        ArrayList<SecurityHealthAnalyticsCustomModuleName> list = new ArrayList<SecurityHealthAnalyticsCustomModuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecurityHealthAnalyticsCustomModuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecurityHealthAnalyticsCustomModuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecurityHealthAnalyticsCustomModuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString) || PROJECT_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString) || FOLDER_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecurityHealthAnalyticsCustomModuleName securityHealthAnalyticsCustomModuleName = this;
            synchronized (securityHealthAnalyticsCustomModuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.securityHealthAnalyticsCustomModule != null) {
                        fieldMapBuilder.put((Object)"security_health_analytics_custom_module", (Object)this.securityHealthAnalyticsCustomModule);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SecurityHealthAnalyticsCustomModuleName that = (SecurityHealthAnalyticsCustomModuleName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.securityHealthAnalyticsCustomModule, that.securityHealthAnalyticsCustomModule) && Objects.equals(this.project, that.project) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.securityHealthAnalyticsCustomModule);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    public static class FolderLocationSecurityHealthAnalyticsCustomModuleBuilder {
        private String folder;
        private String location;
        private String securityHealthAnalyticsCustomModule;

        protected FolderLocationSecurityHealthAnalyticsCustomModuleBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSecurityHealthAnalyticsCustomModule() {
            return this.securityHealthAnalyticsCustomModule;
        }

        public FolderLocationSecurityHealthAnalyticsCustomModuleBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationSecurityHealthAnalyticsCustomModuleBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationSecurityHealthAnalyticsCustomModuleBuilder setSecurityHealthAnalyticsCustomModule(String securityHealthAnalyticsCustomModule) {
            this.securityHealthAnalyticsCustomModule = securityHealthAnalyticsCustomModule;
            return this;
        }

        public SecurityHealthAnalyticsCustomModuleName build() {
            return new SecurityHealthAnalyticsCustomModuleName(this);
        }
    }

    public static class ProjectLocationSecurityHealthAnalyticsCustomModuleBuilder {
        private String project;
        private String location;
        private String securityHealthAnalyticsCustomModule;

        protected ProjectLocationSecurityHealthAnalyticsCustomModuleBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSecurityHealthAnalyticsCustomModule() {
            return this.securityHealthAnalyticsCustomModule;
        }

        public ProjectLocationSecurityHealthAnalyticsCustomModuleBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationSecurityHealthAnalyticsCustomModuleBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationSecurityHealthAnalyticsCustomModuleBuilder setSecurityHealthAnalyticsCustomModule(String securityHealthAnalyticsCustomModule) {
            this.securityHealthAnalyticsCustomModule = securityHealthAnalyticsCustomModule;
            return this;
        }

        public SecurityHealthAnalyticsCustomModuleName build() {
            return new SecurityHealthAnalyticsCustomModuleName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String securityHealthAnalyticsCustomModule;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSecurityHealthAnalyticsCustomModule() {
            return this.securityHealthAnalyticsCustomModule;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSecurityHealthAnalyticsCustomModule(String securityHealthAnalyticsCustomModule) {
            this.securityHealthAnalyticsCustomModule = securityHealthAnalyticsCustomModule;
            return this;
        }

        private Builder(SecurityHealthAnalyticsCustomModuleName securityHealthAnalyticsCustomModuleName) {
            Preconditions.checkArgument((boolean)Objects.equals(securityHealthAnalyticsCustomModuleName.pathTemplate, ORGANIZATION_LOCATION_SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE), (Object)"toBuilder is only supported when SecurityHealthAnalyticsCustomModuleName has the pattern of organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}");
            this.organization = securityHealthAnalyticsCustomModuleName.organization;
            this.location = securityHealthAnalyticsCustomModuleName.location;
            this.securityHealthAnalyticsCustomModule = securityHealthAnalyticsCustomModuleName.securityHealthAnalyticsCustomModule;
        }

        public SecurityHealthAnalyticsCustomModuleName build() {
            return new SecurityHealthAnalyticsCustomModuleName(this);
        }
    }
}

