/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/servicecontrol/v2/service_controller.proto

package com.google.api.servicecontrol.v2;

/**
 *
 *
 * <pre>
 * Request message for the Check method.
 * </pre>
 *
 * Protobuf type {@code google.api.servicecontrol.v2.CheckRequest}
 */
public final class CheckRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.servicecontrol.v2.CheckRequest)
    CheckRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CheckRequest.newBuilder() to construct.
  private CheckRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CheckRequest() {
    serviceName_ = "";
    serviceConfigId_ = "";
    resources_ = java.util.Collections.emptyList();
    flags_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CheckRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.servicecontrol.v2.ServiceControllerProto
        .internal_static_google_api_servicecontrol_v2_CheckRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.servicecontrol.v2.ServiceControllerProto
        .internal_static_google_api_servicecontrol_v2_CheckRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.servicecontrol.v2.CheckRequest.class,
            com.google.api.servicecontrol.v2.CheckRequest.Builder.class);
  }

  public static final int SERVICE_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceName_ = "";
  /**
   *
   *
   * <pre>
   * The service name as specified in its service configuration. For example,
   * `"pubsub.googleapis.com"`.
   *
   * See
   * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
   * for the definition of a service name.
   * </pre>
   *
   * <code>string service_name = 1;</code>
   *
   * @return The serviceName.
   */
  @java.lang.Override
  public java.lang.String getServiceName() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service name as specified in its service configuration. For example,
   * `"pubsub.googleapis.com"`.
   *
   * See
   * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
   * for the definition of a service name.
   * </pre>
   *
   * <code>string service_name = 1;</code>
   *
   * @return The bytes for serviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceNameBytes() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_CONFIG_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceConfigId_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the version of the service configuration that should be used to
   * process the request. Must not be empty. Set this field to 'latest' to
   * specify using the latest configuration.
   * </pre>
   *
   * <code>string service_config_id = 2;</code>
   *
   * @return The serviceConfigId.
   */
  @java.lang.Override
  public java.lang.String getServiceConfigId() {
    java.lang.Object ref = serviceConfigId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceConfigId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the version of the service configuration that should be used to
   * process the request. Must not be empty. Set this field to 'latest' to
   * specify using the latest configuration.
   * </pre>
   *
   * <code>string service_config_id = 2;</code>
   *
   * @return The bytes for serviceConfigId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceConfigIdBytes() {
    java.lang.Object ref = serviceConfigId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceConfigId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 3;
  private com.google.rpc.context.AttributeContext attributes_;
  /**
   *
   *
   * <pre>
   * Describes attributes about the operation being executed by the service.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
   *
   * @return Whether the attributes field is set.
   */
  @java.lang.Override
  public boolean hasAttributes() {
    return attributes_ != null;
  }
  /**
   *
   *
   * <pre>
   * Describes attributes about the operation being executed by the service.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
   *
   * @return The attributes.
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext getAttributes() {
    return attributes_ == null
        ? com.google.rpc.context.AttributeContext.getDefaultInstance()
        : attributes_;
  }
  /**
   *
   *
   * <pre>
   * Describes attributes about the operation being executed by the service.
   * </pre>
   *
   * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContextOrBuilder getAttributesOrBuilder() {
    return attributes_ == null
        ? com.google.rpc.context.AttributeContext.getDefaultInstance()
        : attributes_;
  }

  public static final int RESOURCES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.servicecontrol.v2.ResourceInfo> resources_;
  /**
   *
   *
   * <pre>
   * Describes the resources and the policies applied to each resource.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.servicecontrol.v2.ResourceInfo> getResourcesList() {
    return resources_;
  }
  /**
   *
   *
   * <pre>
   * Describes the resources and the policies applied to each resource.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.servicecontrol.v2.ResourceInfoOrBuilder>
      getResourcesOrBuilderList() {
    return resources_;
  }
  /**
   *
   *
   * <pre>
   * Describes the resources and the policies applied to each resource.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
   */
  @java.lang.Override
  public int getResourcesCount() {
    return resources_.size();
  }
  /**
   *
   *
   * <pre>
   * Describes the resources and the policies applied to each resource.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
   */
  @java.lang.Override
  public com.google.api.servicecontrol.v2.ResourceInfo getResources(int index) {
    return resources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Describes the resources and the policies applied to each resource.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
   */
  @java.lang.Override
  public com.google.api.servicecontrol.v2.ResourceInfoOrBuilder getResourcesOrBuilder(int index) {
    return resources_.get(index);
  }

  public static final int FLAGS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object flags_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Contains a comma-separated list of flags.
   * </pre>
   *
   * <code>string flags = 5;</code>
   *
   * @return The flags.
   */
  @java.lang.Override
  public java.lang.String getFlags() {
    java.lang.Object ref = flags_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      flags_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Contains a comma-separated list of flags.
   * </pre>
   *
   * <code>string flags = 5;</code>
   *
   * @return The bytes for flags.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFlagsBytes() {
    java.lang.Object ref = flags_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      flags_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceConfigId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, serviceConfigId_);
    }
    if (attributes_ != null) {
      output.writeMessage(3, getAttributes());
    }
    for (int i = 0; i < resources_.size(); i++) {
      output.writeMessage(4, resources_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(flags_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, flags_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceConfigId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, serviceConfigId_);
    }
    if (attributes_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAttributes());
    }
    for (int i = 0; i < resources_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, resources_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(flags_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, flags_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.servicecontrol.v2.CheckRequest)) {
      return super.equals(obj);
    }
    com.google.api.servicecontrol.v2.CheckRequest other =
        (com.google.api.servicecontrol.v2.CheckRequest) obj;

    if (!getServiceName().equals(other.getServiceName())) return false;
    if (!getServiceConfigId().equals(other.getServiceConfigId())) return false;
    if (hasAttributes() != other.hasAttributes()) return false;
    if (hasAttributes()) {
      if (!getAttributes().equals(other.getAttributes())) return false;
    }
    if (!getResourcesList().equals(other.getResourcesList())) return false;
    if (!getFlags().equals(other.getFlags())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceName().hashCode();
    hash = (37 * hash) + SERVICE_CONFIG_ID_FIELD_NUMBER;
    hash = (53 * hash) + getServiceConfigId().hashCode();
    if (hasAttributes()) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getAttributes().hashCode();
    }
    if (getResourcesCount() > 0) {
      hash = (37 * hash) + RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getResourcesList().hashCode();
    }
    hash = (37 * hash) + FLAGS_FIELD_NUMBER;
    hash = (53 * hash) + getFlags().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicecontrol.v2.CheckRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.servicecontrol.v2.CheckRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the Check method.
   * </pre>
   *
   * Protobuf type {@code google.api.servicecontrol.v2.CheckRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.servicecontrol.v2.CheckRequest)
      com.google.api.servicecontrol.v2.CheckRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.servicecontrol.v2.ServiceControllerProto
          .internal_static_google_api_servicecontrol_v2_CheckRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.servicecontrol.v2.ServiceControllerProto
          .internal_static_google_api_servicecontrol_v2_CheckRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.servicecontrol.v2.CheckRequest.class,
              com.google.api.servicecontrol.v2.CheckRequest.Builder.class);
    }

    // Construct using com.google.api.servicecontrol.v2.CheckRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      serviceName_ = "";
      serviceConfigId_ = "";
      attributes_ = null;
      if (attributesBuilder_ != null) {
        attributesBuilder_.dispose();
        attributesBuilder_ = null;
      }
      if (resourcesBuilder_ == null) {
        resources_ = java.util.Collections.emptyList();
      } else {
        resources_ = null;
        resourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      flags_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.servicecontrol.v2.ServiceControllerProto
          .internal_static_google_api_servicecontrol_v2_CheckRequest_descriptor;
    }

    @java.lang.Override
    public com.google.api.servicecontrol.v2.CheckRequest getDefaultInstanceForType() {
      return com.google.api.servicecontrol.v2.CheckRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.servicecontrol.v2.CheckRequest build() {
      com.google.api.servicecontrol.v2.CheckRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.servicecontrol.v2.CheckRequest buildPartial() {
      com.google.api.servicecontrol.v2.CheckRequest result =
          new com.google.api.servicecontrol.v2.CheckRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.api.servicecontrol.v2.CheckRequest result) {
      if (resourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          resources_ = java.util.Collections.unmodifiableList(resources_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.resources_ = resources_;
      } else {
        result.resources_ = resourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.servicecontrol.v2.CheckRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.serviceName_ = serviceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.serviceConfigId_ = serviceConfigId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.attributes_ = attributesBuilder_ == null ? attributes_ : attributesBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.flags_ = flags_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.servicecontrol.v2.CheckRequest) {
        return mergeFrom((com.google.api.servicecontrol.v2.CheckRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.servicecontrol.v2.CheckRequest other) {
      if (other == com.google.api.servicecontrol.v2.CheckRequest.getDefaultInstance()) return this;
      if (!other.getServiceName().isEmpty()) {
        serviceName_ = other.serviceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getServiceConfigId().isEmpty()) {
        serviceConfigId_ = other.serviceConfigId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasAttributes()) {
        mergeAttributes(other.getAttributes());
      }
      if (resourcesBuilder_ == null) {
        if (!other.resources_.isEmpty()) {
          if (resources_.isEmpty()) {
            resources_ = other.resources_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureResourcesIsMutable();
            resources_.addAll(other.resources_);
          }
          onChanged();
        }
      } else {
        if (!other.resources_.isEmpty()) {
          if (resourcesBuilder_.isEmpty()) {
            resourcesBuilder_.dispose();
            resourcesBuilder_ = null;
            resources_ = other.resources_;
            bitField0_ = (bitField0_ & ~0x00000008);
            resourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResourcesFieldBuilder()
                    : null;
          } else {
            resourcesBuilder_.addAllMessages(other.resources_);
          }
        }
      }
      if (!other.getFlags().isEmpty()) {
        flags_ = other.flags_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                serviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                serviceConfigId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAttributesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.api.servicecontrol.v2.ResourceInfo m =
                    input.readMessage(
                        com.google.api.servicecontrol.v2.ResourceInfo.parser(), extensionRegistry);
                if (resourcesBuilder_ == null) {
                  ensureResourcesIsMutable();
                  resources_.add(m);
                } else {
                  resourcesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                flags_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return The serviceName.
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return The bytes for serviceName.
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @param value The serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceName() {
      serviceName_ = getDefaultInstance().getServiceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @param value The bytes for serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object serviceConfigId_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @return The serviceConfigId.
     */
    public java.lang.String getServiceConfigId() {
      java.lang.Object ref = serviceConfigId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceConfigId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @return The bytes for serviceConfigId.
     */
    public com.google.protobuf.ByteString getServiceConfigIdBytes() {
      java.lang.Object ref = serviceConfigId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceConfigId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @param value The serviceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceConfigId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceConfigId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceConfigId() {
      serviceConfigId_ = getDefaultInstance().getServiceConfigId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @param value The bytes for serviceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceConfigIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceConfigId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.rpc.context.AttributeContext attributes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext,
            com.google.rpc.context.AttributeContext.Builder,
            com.google.rpc.context.AttributeContextOrBuilder>
        attributesBuilder_;
    /**
     *
     *
     * <pre>
     * Describes attributes about the operation being executed by the service.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
     *
     * @return Whether the attributes field is set.
     */
    public boolean hasAttributes() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Describes attributes about the operation being executed by the service.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
     *
     * @return The attributes.
     */
    public com.google.rpc.context.AttributeContext getAttributes() {
      if (attributesBuilder_ == null) {
        return attributes_ == null
            ? com.google.rpc.context.AttributeContext.getDefaultInstance()
            : attributes_;
      } else {
        return attributesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes attributes about the operation being executed by the service.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
     */
    public Builder setAttributes(com.google.rpc.context.AttributeContext value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attributes_ = value;
      } else {
        attributesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes attributes about the operation being executed by the service.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
     */
    public Builder setAttributes(com.google.rpc.context.AttributeContext.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        attributes_ = builderForValue.build();
      } else {
        attributesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes attributes about the operation being executed by the service.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
     */
    public Builder mergeAttributes(com.google.rpc.context.AttributeContext value) {
      if (attributesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && attributes_ != null
            && attributes_ != com.google.rpc.context.AttributeContext.getDefaultInstance()) {
          getAttributesBuilder().mergeFrom(value);
        } else {
          attributes_ = value;
        }
      } else {
        attributesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes attributes about the operation being executed by the service.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
     */
    public Builder clearAttributes() {
      bitField0_ = (bitField0_ & ~0x00000004);
      attributes_ = null;
      if (attributesBuilder_ != null) {
        attributesBuilder_.dispose();
        attributesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes attributes about the operation being executed by the service.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
     */
    public com.google.rpc.context.AttributeContext.Builder getAttributesBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAttributesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes attributes about the operation being executed by the service.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
     */
    public com.google.rpc.context.AttributeContextOrBuilder getAttributesOrBuilder() {
      if (attributesBuilder_ != null) {
        return attributesBuilder_.getMessageOrBuilder();
      } else {
        return attributes_ == null
            ? com.google.rpc.context.AttributeContext.getDefaultInstance()
            : attributes_;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes attributes about the operation being executed by the service.
     * </pre>
     *
     * <code>.google.rpc.context.AttributeContext attributes = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.context.AttributeContext,
            com.google.rpc.context.AttributeContext.Builder,
            com.google.rpc.context.AttributeContextOrBuilder>
        getAttributesFieldBuilder() {
      if (attributesBuilder_ == null) {
        attributesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.context.AttributeContext,
                com.google.rpc.context.AttributeContext.Builder,
                com.google.rpc.context.AttributeContextOrBuilder>(
                getAttributes(), getParentForChildren(), isClean());
        attributes_ = null;
      }
      return attributesBuilder_;
    }

    private java.util.List<com.google.api.servicecontrol.v2.ResourceInfo> resources_ =
        java.util.Collections.emptyList();

    private void ensureResourcesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        resources_ =
            new java.util.ArrayList<com.google.api.servicecontrol.v2.ResourceInfo>(resources_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.servicecontrol.v2.ResourceInfo,
            com.google.api.servicecontrol.v2.ResourceInfo.Builder,
            com.google.api.servicecontrol.v2.ResourceInfoOrBuilder>
        resourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public java.util.List<com.google.api.servicecontrol.v2.ResourceInfo> getResourcesList() {
      if (resourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(resources_);
      } else {
        return resourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public int getResourcesCount() {
      if (resourcesBuilder_ == null) {
        return resources_.size();
      } else {
        return resourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public com.google.api.servicecontrol.v2.ResourceInfo getResources(int index) {
      if (resourcesBuilder_ == null) {
        return resources_.get(index);
      } else {
        return resourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public Builder setResources(int index, com.google.api.servicecontrol.v2.ResourceInfo value) {
      if (resourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourcesIsMutable();
        resources_.set(index, value);
        onChanged();
      } else {
        resourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public Builder setResources(
        int index, com.google.api.servicecontrol.v2.ResourceInfo.Builder builderForValue) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        resources_.set(index, builderForValue.build());
        onChanged();
      } else {
        resourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public Builder addResources(com.google.api.servicecontrol.v2.ResourceInfo value) {
      if (resourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourcesIsMutable();
        resources_.add(value);
        onChanged();
      } else {
        resourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public Builder addResources(int index, com.google.api.servicecontrol.v2.ResourceInfo value) {
      if (resourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourcesIsMutable();
        resources_.add(index, value);
        onChanged();
      } else {
        resourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public Builder addResources(
        com.google.api.servicecontrol.v2.ResourceInfo.Builder builderForValue) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        resources_.add(builderForValue.build());
        onChanged();
      } else {
        resourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public Builder addResources(
        int index, com.google.api.servicecontrol.v2.ResourceInfo.Builder builderForValue) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        resources_.add(index, builderForValue.build());
        onChanged();
      } else {
        resourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public Builder addAllResources(
        java.lang.Iterable<? extends com.google.api.servicecontrol.v2.ResourceInfo> values) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resources_);
        onChanged();
      } else {
        resourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public Builder clearResources() {
      if (resourcesBuilder_ == null) {
        resources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        resourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public Builder removeResources(int index) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        resources_.remove(index);
        onChanged();
      } else {
        resourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public com.google.api.servicecontrol.v2.ResourceInfo.Builder getResourcesBuilder(int index) {
      return getResourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public com.google.api.servicecontrol.v2.ResourceInfoOrBuilder getResourcesOrBuilder(int index) {
      if (resourcesBuilder_ == null) {
        return resources_.get(index);
      } else {
        return resourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public java.util.List<? extends com.google.api.servicecontrol.v2.ResourceInfoOrBuilder>
        getResourcesOrBuilderList() {
      if (resourcesBuilder_ != null) {
        return resourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(resources_);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public com.google.api.servicecontrol.v2.ResourceInfo.Builder addResourcesBuilder() {
      return getResourcesFieldBuilder()
          .addBuilder(com.google.api.servicecontrol.v2.ResourceInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public com.google.api.servicecontrol.v2.ResourceInfo.Builder addResourcesBuilder(int index) {
      return getResourcesFieldBuilder()
          .addBuilder(index, com.google.api.servicecontrol.v2.ResourceInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the resources and the policies applied to each resource.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v2.ResourceInfo resources = 4;</code>
     */
    public java.util.List<com.google.api.servicecontrol.v2.ResourceInfo.Builder>
        getResourcesBuilderList() {
      return getResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.servicecontrol.v2.ResourceInfo,
            com.google.api.servicecontrol.v2.ResourceInfo.Builder,
            com.google.api.servicecontrol.v2.ResourceInfoOrBuilder>
        getResourcesFieldBuilder() {
      if (resourcesBuilder_ == null) {
        resourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.servicecontrol.v2.ResourceInfo,
                com.google.api.servicecontrol.v2.ResourceInfo.Builder,
                com.google.api.servicecontrol.v2.ResourceInfoOrBuilder>(
                resources_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        resources_ = null;
      }
      return resourcesBuilder_;
    }

    private java.lang.Object flags_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Contains a comma-separated list of flags.
     * </pre>
     *
     * <code>string flags = 5;</code>
     *
     * @return The flags.
     */
    public java.lang.String getFlags() {
      java.lang.Object ref = flags_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        flags_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains a comma-separated list of flags.
     * </pre>
     *
     * <code>string flags = 5;</code>
     *
     * @return The bytes for flags.
     */
    public com.google.protobuf.ByteString getFlagsBytes() {
      java.lang.Object ref = flags_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        flags_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains a comma-separated list of flags.
     * </pre>
     *
     * <code>string flags = 5;</code>
     *
     * @param value The flags to set.
     * @return This builder for chaining.
     */
    public Builder setFlags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      flags_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains a comma-separated list of flags.
     * </pre>
     *
     * <code>string flags = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFlags() {
      flags_ = getDefaultInstance().getFlags();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Contains a comma-separated list of flags.
     * </pre>
     *
     * <code>string flags = 5;</code>
     *
     * @param value The bytes for flags to set.
     * @return This builder for chaining.
     */
    public Builder setFlagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      flags_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.servicecontrol.v2.CheckRequest)
  }

  // @@protoc_insertion_point(class_scope:google.api.servicecontrol.v2.CheckRequest)
  private static final com.google.api.servicecontrol.v2.CheckRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.servicecontrol.v2.CheckRequest();
  }

  public static com.google.api.servicecontrol.v2.CheckRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CheckRequest> PARSER =
      new com.google.protobuf.AbstractParser<CheckRequest>() {
        @java.lang.Override
        public CheckRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CheckRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CheckRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.servicecontrol.v2.CheckRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
