/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/servicecontrol/v2/service_controller.proto

package com.google.api.servicecontrol.v2;

/**
 *
 *
 * <pre>
 * Request message for the Report method.
 * </pre>
 *
 * Protobuf type {@code google.api.servicecontrol.v2.ReportRequest}
 */
public final class ReportRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.servicecontrol.v2.ReportRequest)
    ReportRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReportRequest.newBuilder() to construct.
  private ReportRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReportRequest() {
    serviceName_ = "";
    serviceConfigId_ = "";
    operations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReportRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.servicecontrol.v2.ServiceControllerProto
        .internal_static_google_api_servicecontrol_v2_ReportRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.servicecontrol.v2.ServiceControllerProto
        .internal_static_google_api_servicecontrol_v2_ReportRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.servicecontrol.v2.ReportRequest.class,
            com.google.api.servicecontrol.v2.ReportRequest.Builder.class);
  }

  public static final int SERVICE_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceName_ = "";
  /**
   *
   *
   * <pre>
   * The service name as specified in its service configuration. For example,
   * `"pubsub.googleapis.com"`.
   *
   * See
   * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
   * for the definition of a service name.
   * </pre>
   *
   * <code>string service_name = 1;</code>
   *
   * @return The serviceName.
   */
  @java.lang.Override
  public java.lang.String getServiceName() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service name as specified in its service configuration. For example,
   * `"pubsub.googleapis.com"`.
   *
   * See
   * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
   * for the definition of a service name.
   * </pre>
   *
   * <code>string service_name = 1;</code>
   *
   * @return The bytes for serviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceNameBytes() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_CONFIG_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceConfigId_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the version of the service configuration that should be used to
   * process the request. Must not be empty. Set this field to 'latest' to
   * specify using the latest configuration.
   * </pre>
   *
   * <code>string service_config_id = 2;</code>
   *
   * @return The serviceConfigId.
   */
  @java.lang.Override
  public java.lang.String getServiceConfigId() {
    java.lang.Object ref = serviceConfigId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceConfigId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the version of the service configuration that should be used to
   * process the request. Must not be empty. Set this field to 'latest' to
   * specify using the latest configuration.
   * </pre>
   *
   * <code>string service_config_id = 2;</code>
   *
   * @return The bytes for serviceConfigId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceConfigIdBytes() {
    java.lang.Object ref = serviceConfigId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceConfigId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.context.AttributeContext> operations_;
  /**
   *
   *
   * <pre>
   * Describes the list of operations to be reported. Each operation is
   * represented as an AttributeContext, and contains all attributes around an
   * API access.
   * </pre>
   *
   * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.context.AttributeContext> getOperationsList() {
    return operations_;
  }
  /**
   *
   *
   * <pre>
   * Describes the list of operations to be reported. Each operation is
   * represented as an AttributeContext, and contains all attributes around an
   * API access.
   * </pre>
   *
   * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.context.AttributeContextOrBuilder>
      getOperationsOrBuilderList() {
    return operations_;
  }
  /**
   *
   *
   * <pre>
   * Describes the list of operations to be reported. Each operation is
   * represented as an AttributeContext, and contains all attributes around an
   * API access.
   * </pre>
   *
   * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
   */
  @java.lang.Override
  public int getOperationsCount() {
    return operations_.size();
  }
  /**
   *
   *
   * <pre>
   * Describes the list of operations to be reported. Each operation is
   * represented as an AttributeContext, and contains all attributes around an
   * API access.
   * </pre>
   *
   * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContext getOperations(int index) {
    return operations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Describes the list of operations to be reported. Each operation is
   * represented as an AttributeContext, and contains all attributes around an
   * API access.
   * </pre>
   *
   * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.context.AttributeContextOrBuilder getOperationsOrBuilder(int index) {
    return operations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceConfigId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, serviceConfigId_);
    }
    for (int i = 0; i < operations_.size(); i++) {
      output.writeMessage(3, operations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceConfigId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, serviceConfigId_);
    }
    for (int i = 0; i < operations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, operations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.servicecontrol.v2.ReportRequest)) {
      return super.equals(obj);
    }
    com.google.api.servicecontrol.v2.ReportRequest other =
        (com.google.api.servicecontrol.v2.ReportRequest) obj;

    if (!getServiceName().equals(other.getServiceName())) return false;
    if (!getServiceConfigId().equals(other.getServiceConfigId())) return false;
    if (!getOperationsList().equals(other.getOperationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceName().hashCode();
    hash = (37 * hash) + SERVICE_CONFIG_ID_FIELD_NUMBER;
    hash = (53 * hash) + getServiceConfigId().hashCode();
    if (getOperationsCount() > 0) {
      hash = (37 * hash) + OPERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOperationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicecontrol.v2.ReportRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.servicecontrol.v2.ReportRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the Report method.
   * </pre>
   *
   * Protobuf type {@code google.api.servicecontrol.v2.ReportRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.servicecontrol.v2.ReportRequest)
      com.google.api.servicecontrol.v2.ReportRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.servicecontrol.v2.ServiceControllerProto
          .internal_static_google_api_servicecontrol_v2_ReportRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.servicecontrol.v2.ServiceControllerProto
          .internal_static_google_api_servicecontrol_v2_ReportRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.servicecontrol.v2.ReportRequest.class,
              com.google.api.servicecontrol.v2.ReportRequest.Builder.class);
    }

    // Construct using com.google.api.servicecontrol.v2.ReportRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      serviceName_ = "";
      serviceConfigId_ = "";
      if (operationsBuilder_ == null) {
        operations_ = java.util.Collections.emptyList();
      } else {
        operations_ = null;
        operationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.servicecontrol.v2.ServiceControllerProto
          .internal_static_google_api_servicecontrol_v2_ReportRequest_descriptor;
    }

    @java.lang.Override
    public com.google.api.servicecontrol.v2.ReportRequest getDefaultInstanceForType() {
      return com.google.api.servicecontrol.v2.ReportRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.servicecontrol.v2.ReportRequest build() {
      com.google.api.servicecontrol.v2.ReportRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.servicecontrol.v2.ReportRequest buildPartial() {
      com.google.api.servicecontrol.v2.ReportRequest result =
          new com.google.api.servicecontrol.v2.ReportRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.api.servicecontrol.v2.ReportRequest result) {
      if (operationsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          operations_ = java.util.Collections.unmodifiableList(operations_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.operations_ = operations_;
      } else {
        result.operations_ = operationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.servicecontrol.v2.ReportRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.serviceName_ = serviceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.serviceConfigId_ = serviceConfigId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.servicecontrol.v2.ReportRequest) {
        return mergeFrom((com.google.api.servicecontrol.v2.ReportRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.servicecontrol.v2.ReportRequest other) {
      if (other == com.google.api.servicecontrol.v2.ReportRequest.getDefaultInstance()) return this;
      if (!other.getServiceName().isEmpty()) {
        serviceName_ = other.serviceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getServiceConfigId().isEmpty()) {
        serviceConfigId_ = other.serviceConfigId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (operationsBuilder_ == null) {
        if (!other.operations_.isEmpty()) {
          if (operations_.isEmpty()) {
            operations_ = other.operations_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureOperationsIsMutable();
            operations_.addAll(other.operations_);
          }
          onChanged();
        }
      } else {
        if (!other.operations_.isEmpty()) {
          if (operationsBuilder_.isEmpty()) {
            operationsBuilder_.dispose();
            operationsBuilder_ = null;
            operations_ = other.operations_;
            bitField0_ = (bitField0_ & ~0x00000004);
            operationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOperationsFieldBuilder()
                    : null;
          } else {
            operationsBuilder_.addAllMessages(other.operations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                serviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                serviceConfigId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.rpc.context.AttributeContext m =
                    input.readMessage(
                        com.google.rpc.context.AttributeContext.parser(), extensionRegistry);
                if (operationsBuilder_ == null) {
                  ensureOperationsIsMutable();
                  operations_.add(m);
                } else {
                  operationsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return The serviceName.
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return The bytes for serviceName.
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @param value The serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceName() {
      serviceName_ = getDefaultInstance().getServiceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service name as specified in its service configuration. For example,
     * `"pubsub.googleapis.com"`.
     *
     * See
     * [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
     * for the definition of a service name.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @param value The bytes for serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object serviceConfigId_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @return The serviceConfigId.
     */
    public java.lang.String getServiceConfigId() {
      java.lang.Object ref = serviceConfigId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceConfigId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @return The bytes for serviceConfigId.
     */
    public com.google.protobuf.ByteString getServiceConfigIdBytes() {
      java.lang.Object ref = serviceConfigId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceConfigId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @param value The serviceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceConfigId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceConfigId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceConfigId() {
      serviceConfigId_ = getDefaultInstance().getServiceConfigId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the version of the service configuration that should be used to
     * process the request. Must not be empty. Set this field to 'latest' to
     * specify using the latest configuration.
     * </pre>
     *
     * <code>string service_config_id = 2;</code>
     *
     * @param value The bytes for serviceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceConfigIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceConfigId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.context.AttributeContext> operations_ =
        java.util.Collections.emptyList();

    private void ensureOperationsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        operations_ = new java.util.ArrayList<com.google.rpc.context.AttributeContext>(operations_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.context.AttributeContext,
            com.google.rpc.context.AttributeContext.Builder,
            com.google.rpc.context.AttributeContextOrBuilder>
        operationsBuilder_;

    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public java.util.List<com.google.rpc.context.AttributeContext> getOperationsList() {
      if (operationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(operations_);
      } else {
        return operationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public int getOperationsCount() {
      if (operationsBuilder_ == null) {
        return operations_.size();
      } else {
        return operationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public com.google.rpc.context.AttributeContext getOperations(int index) {
      if (operationsBuilder_ == null) {
        return operations_.get(index);
      } else {
        return operationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public Builder setOperations(int index, com.google.rpc.context.AttributeContext value) {
      if (operationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOperationsIsMutable();
        operations_.set(index, value);
        onChanged();
      } else {
        operationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public Builder setOperations(
        int index, com.google.rpc.context.AttributeContext.Builder builderForValue) {
      if (operationsBuilder_ == null) {
        ensureOperationsIsMutable();
        operations_.set(index, builderForValue.build());
        onChanged();
      } else {
        operationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public Builder addOperations(com.google.rpc.context.AttributeContext value) {
      if (operationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOperationsIsMutable();
        operations_.add(value);
        onChanged();
      } else {
        operationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public Builder addOperations(int index, com.google.rpc.context.AttributeContext value) {
      if (operationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOperationsIsMutable();
        operations_.add(index, value);
        onChanged();
      } else {
        operationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public Builder addOperations(com.google.rpc.context.AttributeContext.Builder builderForValue) {
      if (operationsBuilder_ == null) {
        ensureOperationsIsMutable();
        operations_.add(builderForValue.build());
        onChanged();
      } else {
        operationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public Builder addOperations(
        int index, com.google.rpc.context.AttributeContext.Builder builderForValue) {
      if (operationsBuilder_ == null) {
        ensureOperationsIsMutable();
        operations_.add(index, builderForValue.build());
        onChanged();
      } else {
        operationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public Builder addAllOperations(
        java.lang.Iterable<? extends com.google.rpc.context.AttributeContext> values) {
      if (operationsBuilder_ == null) {
        ensureOperationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, operations_);
        onChanged();
      } else {
        operationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public Builder clearOperations() {
      if (operationsBuilder_ == null) {
        operations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        operationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public Builder removeOperations(int index) {
      if (operationsBuilder_ == null) {
        ensureOperationsIsMutable();
        operations_.remove(index);
        onChanged();
      } else {
        operationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public com.google.rpc.context.AttributeContext.Builder getOperationsBuilder(int index) {
      return getOperationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public com.google.rpc.context.AttributeContextOrBuilder getOperationsOrBuilder(int index) {
      if (operationsBuilder_ == null) {
        return operations_.get(index);
      } else {
        return operationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public java.util.List<? extends com.google.rpc.context.AttributeContextOrBuilder>
        getOperationsOrBuilderList() {
      if (operationsBuilder_ != null) {
        return operationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(operations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public com.google.rpc.context.AttributeContext.Builder addOperationsBuilder() {
      return getOperationsFieldBuilder()
          .addBuilder(com.google.rpc.context.AttributeContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public com.google.rpc.context.AttributeContext.Builder addOperationsBuilder(int index) {
      return getOperationsFieldBuilder()
          .addBuilder(index, com.google.rpc.context.AttributeContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes the list of operations to be reported. Each operation is
     * represented as an AttributeContext, and contains all attributes around an
     * API access.
     * </pre>
     *
     * <code>repeated .google.rpc.context.AttributeContext operations = 3;</code>
     */
    public java.util.List<com.google.rpc.context.AttributeContext.Builder>
        getOperationsBuilderList() {
      return getOperationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.context.AttributeContext,
            com.google.rpc.context.AttributeContext.Builder,
            com.google.rpc.context.AttributeContextOrBuilder>
        getOperationsFieldBuilder() {
      if (operationsBuilder_ == null) {
        operationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.context.AttributeContext,
                com.google.rpc.context.AttributeContext.Builder,
                com.google.rpc.context.AttributeContextOrBuilder>(
                operations_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        operations_ = null;
      }
      return operationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.servicecontrol.v2.ReportRequest)
  }

  // @@protoc_insertion_point(class_scope:google.api.servicecontrol.v2.ReportRequest)
  private static final com.google.api.servicecontrol.v2.ReportRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.servicecontrol.v2.ReportRequest();
  }

  public static com.google.api.servicecontrol.v2.ReportRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReportRequest> PARSER =
      new com.google.protobuf.AbstractParser<ReportRequest>() {
        @java.lang.Override
        public ReportRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReportRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReportRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.servicecontrol.v2.ReportRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
