/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/servicecontrol/v2/service_controller.proto

package com.google.api.servicecontrol.v2;

public interface ResourceInfoOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.api.servicecontrol.v2.ResourceInfo)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The name of the resource referenced in the request.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The name of the resource referenced in the request.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The resource type in the format of "{service}/{kind}".
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The type.
   */
  java.lang.String getType();
  /**
   *
   *
   * <pre>
   * The resource type in the format of "{service}/{kind}".
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The bytes for type.
   */
  com.google.protobuf.ByteString getTypeBytes();

  /**
   *
   *
   * <pre>
   * The resource permission needed for this request.
   * The format must be "{service}/{plural}.{verb}".
   * </pre>
   *
   * <code>string permission = 3;</code>
   *
   * @return The permission.
   */
  java.lang.String getPermission();
  /**
   *
   *
   * <pre>
   * The resource permission needed for this request.
   * The format must be "{service}/{plural}.{verb}".
   * </pre>
   *
   * <code>string permission = 3;</code>
   *
   * @return The bytes for permission.
   */
  com.google.protobuf.ByteString getPermissionBytes();

  /**
   *
   *
   * <pre>
   * Optional. The identifier of the container of this resource. For Google
   * Cloud APIs, the resource container must be one of the following formats:
   *     - `projects/&lt;project-id or project-number&gt;`
   *     - `folders/&lt;folder-id&gt;`
   *     - `organizations/&lt;organization-id&gt;`
   * For the policy enforcement on the container level (VPCSC and Location
   * Policy check), this field takes precedence on the container extracted from
   * name when presents.
   * </pre>
   *
   * <code>string container = 4;</code>
   *
   * @return The container.
   */
  java.lang.String getContainer();
  /**
   *
   *
   * <pre>
   * Optional. The identifier of the container of this resource. For Google
   * Cloud APIs, the resource container must be one of the following formats:
   *     - `projects/&lt;project-id or project-number&gt;`
   *     - `folders/&lt;folder-id&gt;`
   *     - `organizations/&lt;organization-id&gt;`
   * For the policy enforcement on the container level (VPCSC and Location
   * Policy check), this field takes precedence on the container extracted from
   * name when presents.
   * </pre>
   *
   * <code>string container = 4;</code>
   *
   * @return The bytes for container.
   */
  com.google.protobuf.ByteString getContainerBytes();

  /**
   *
   *
   * <pre>
   * Optional. The location of the resource. The value must be a valid zone,
   * region or multiregion. For example: "europe-west4" or
   * "northamerica-northeast1-a"
   * </pre>
   *
   * <code>string location = 5;</code>
   *
   * @return The location.
   */
  java.lang.String getLocation();
  /**
   *
   *
   * <pre>
   * Optional. The location of the resource. The value must be a valid zone,
   * region or multiregion. For example: "europe-west4" or
   * "northamerica-northeast1-a"
   * </pre>
   *
   * <code>string location = 5;</code>
   *
   * @return The bytes for location.
   */
  com.google.protobuf.ByteString getLocationBytes();
}
