/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/servicemanagement/v1/servicemanager.proto

package com.google.api.servicemanagement.v1;

/**
 *
 *
 * <pre>
 * Response message for GenerateConfigReport method.
 * </pre>
 *
 * Protobuf type {@code google.api.servicemanagement.v1.GenerateConfigReportResponse}
 */
public final class GenerateConfigReportResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.servicemanagement.v1.GenerateConfigReportResponse)
    GenerateConfigReportResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateConfigReportResponse.newBuilder() to construct.
  private GenerateConfigReportResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateConfigReportResponse() {
    serviceName_ = "";
    id_ = "";
    changeReports_ = java.util.Collections.emptyList();
    diagnostics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateConfigReportResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.servicemanagement.v1.ServiceManagerProto
        .internal_static_google_api_servicemanagement_v1_GenerateConfigReportResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.servicemanagement.v1.ServiceManagerProto
        .internal_static_google_api_servicemanagement_v1_GenerateConfigReportResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.servicemanagement.v1.GenerateConfigReportResponse.class,
            com.google.api.servicemanagement.v1.GenerateConfigReportResponse.Builder.class);
  }

  public static final int SERVICE_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceName_ = "";
  /**
   *
   *
   * <pre>
   * Name of the service this report belongs to.
   * </pre>
   *
   * <code>string service_name = 1;</code>
   *
   * @return The serviceName.
   */
  @java.lang.Override
  public java.lang.String getServiceName() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the service this report belongs to.
   * </pre>
   *
   * <code>string service_name = 1;</code>
   *
   * @return The bytes for serviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceNameBytes() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * ID of the service configuration this report belongs to.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ID of the service configuration this report belongs to.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHANGE_REPORTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.servicemanagement.v1.ChangeReport> changeReports_;
  /**
   *
   *
   * <pre>
   * list of ChangeReport, each corresponding to comparison between two
   * service configurations.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.servicemanagement.v1.ChangeReport> getChangeReportsList() {
    return changeReports_;
  }
  /**
   *
   *
   * <pre>
   * list of ChangeReport, each corresponding to comparison between two
   * service configurations.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.servicemanagement.v1.ChangeReportOrBuilder>
      getChangeReportsOrBuilderList() {
    return changeReports_;
  }
  /**
   *
   *
   * <pre>
   * list of ChangeReport, each corresponding to comparison between two
   * service configurations.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
   */
  @java.lang.Override
  public int getChangeReportsCount() {
    return changeReports_.size();
  }
  /**
   *
   *
   * <pre>
   * list of ChangeReport, each corresponding to comparison between two
   * service configurations.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.ChangeReport getChangeReports(int index) {
    return changeReports_.get(index);
  }
  /**
   *
   *
   * <pre>
   * list of ChangeReport, each corresponding to comparison between two
   * service configurations.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.ChangeReportOrBuilder getChangeReportsOrBuilder(
      int index) {
    return changeReports_.get(index);
  }

  public static final int DIAGNOSTICS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.servicemanagement.v1.Diagnostic> diagnostics_;
  /**
   *
   *
   * <pre>
   * Errors / Linter warnings associated with the service definition this
   * report
   * belongs to.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.servicemanagement.v1.Diagnostic> getDiagnosticsList() {
    return diagnostics_;
  }
  /**
   *
   *
   * <pre>
   * Errors / Linter warnings associated with the service definition this
   * report
   * belongs to.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.servicemanagement.v1.DiagnosticOrBuilder>
      getDiagnosticsOrBuilderList() {
    return diagnostics_;
  }
  /**
   *
   *
   * <pre>
   * Errors / Linter warnings associated with the service definition this
   * report
   * belongs to.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
   */
  @java.lang.Override
  public int getDiagnosticsCount() {
    return diagnostics_.size();
  }
  /**
   *
   *
   * <pre>
   * Errors / Linter warnings associated with the service definition this
   * report
   * belongs to.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.Diagnostic getDiagnostics(int index) {
    return diagnostics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Errors / Linter warnings associated with the service definition this
   * report
   * belongs to.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.DiagnosticOrBuilder getDiagnosticsOrBuilder(
      int index) {
    return diagnostics_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    for (int i = 0; i < changeReports_.size(); i++) {
      output.writeMessage(3, changeReports_.get(i));
    }
    for (int i = 0; i < diagnostics_.size(); i++) {
      output.writeMessage(4, diagnostics_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    for (int i = 0; i < changeReports_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, changeReports_.get(i));
    }
    for (int i = 0; i < diagnostics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, diagnostics_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.servicemanagement.v1.GenerateConfigReportResponse)) {
      return super.equals(obj);
    }
    com.google.api.servicemanagement.v1.GenerateConfigReportResponse other =
        (com.google.api.servicemanagement.v1.GenerateConfigReportResponse) obj;

    if (!getServiceName().equals(other.getServiceName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getChangeReportsList().equals(other.getChangeReportsList())) return false;
    if (!getDiagnosticsList().equals(other.getDiagnosticsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (getChangeReportsCount() > 0) {
      hash = (37 * hash) + CHANGE_REPORTS_FIELD_NUMBER;
      hash = (53 * hash) + getChangeReportsList().hashCode();
    }
    if (getDiagnosticsCount() > 0) {
      hash = (37 * hash) + DIAGNOSTICS_FIELD_NUMBER;
      hash = (53 * hash) + getDiagnosticsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.api.servicemanagement.v1.GenerateConfigReportResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for GenerateConfigReport method.
   * </pre>
   *
   * Protobuf type {@code google.api.servicemanagement.v1.GenerateConfigReportResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.servicemanagement.v1.GenerateConfigReportResponse)
      com.google.api.servicemanagement.v1.GenerateConfigReportResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.servicemanagement.v1.ServiceManagerProto
          .internal_static_google_api_servicemanagement_v1_GenerateConfigReportResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.servicemanagement.v1.ServiceManagerProto
          .internal_static_google_api_servicemanagement_v1_GenerateConfigReportResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.servicemanagement.v1.GenerateConfigReportResponse.class,
              com.google.api.servicemanagement.v1.GenerateConfigReportResponse.Builder.class);
    }

    // Construct using com.google.api.servicemanagement.v1.GenerateConfigReportResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      serviceName_ = "";
      id_ = "";
      if (changeReportsBuilder_ == null) {
        changeReports_ = java.util.Collections.emptyList();
      } else {
        changeReports_ = null;
        changeReportsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (diagnosticsBuilder_ == null) {
        diagnostics_ = java.util.Collections.emptyList();
      } else {
        diagnostics_ = null;
        diagnosticsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.servicemanagement.v1.ServiceManagerProto
          .internal_static_google_api_servicemanagement_v1_GenerateConfigReportResponse_descriptor;
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.GenerateConfigReportResponse
        getDefaultInstanceForType() {
      return com.google.api.servicemanagement.v1.GenerateConfigReportResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.GenerateConfigReportResponse build() {
      com.google.api.servicemanagement.v1.GenerateConfigReportResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.GenerateConfigReportResponse buildPartial() {
      com.google.api.servicemanagement.v1.GenerateConfigReportResponse result =
          new com.google.api.servicemanagement.v1.GenerateConfigReportResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.api.servicemanagement.v1.GenerateConfigReportResponse result) {
      if (changeReportsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          changeReports_ = java.util.Collections.unmodifiableList(changeReports_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.changeReports_ = changeReports_;
      } else {
        result.changeReports_ = changeReportsBuilder_.build();
      }
      if (diagnosticsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          diagnostics_ = java.util.Collections.unmodifiableList(diagnostics_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.diagnostics_ = diagnostics_;
      } else {
        result.diagnostics_ = diagnosticsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.api.servicemanagement.v1.GenerateConfigReportResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.serviceName_ = serviceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.servicemanagement.v1.GenerateConfigReportResponse) {
        return mergeFrom((com.google.api.servicemanagement.v1.GenerateConfigReportResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.api.servicemanagement.v1.GenerateConfigReportResponse other) {
      if (other
          == com.google.api.servicemanagement.v1.GenerateConfigReportResponse.getDefaultInstance())
        return this;
      if (!other.getServiceName().isEmpty()) {
        serviceName_ = other.serviceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (changeReportsBuilder_ == null) {
        if (!other.changeReports_.isEmpty()) {
          if (changeReports_.isEmpty()) {
            changeReports_ = other.changeReports_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureChangeReportsIsMutable();
            changeReports_.addAll(other.changeReports_);
          }
          onChanged();
        }
      } else {
        if (!other.changeReports_.isEmpty()) {
          if (changeReportsBuilder_.isEmpty()) {
            changeReportsBuilder_.dispose();
            changeReportsBuilder_ = null;
            changeReports_ = other.changeReports_;
            bitField0_ = (bitField0_ & ~0x00000004);
            changeReportsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChangeReportsFieldBuilder()
                    : null;
          } else {
            changeReportsBuilder_.addAllMessages(other.changeReports_);
          }
        }
      }
      if (diagnosticsBuilder_ == null) {
        if (!other.diagnostics_.isEmpty()) {
          if (diagnostics_.isEmpty()) {
            diagnostics_ = other.diagnostics_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureDiagnosticsIsMutable();
            diagnostics_.addAll(other.diagnostics_);
          }
          onChanged();
        }
      } else {
        if (!other.diagnostics_.isEmpty()) {
          if (diagnosticsBuilder_.isEmpty()) {
            diagnosticsBuilder_.dispose();
            diagnosticsBuilder_ = null;
            diagnostics_ = other.diagnostics_;
            bitField0_ = (bitField0_ & ~0x00000008);
            diagnosticsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDiagnosticsFieldBuilder()
                    : null;
          } else {
            diagnosticsBuilder_.addAllMessages(other.diagnostics_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                serviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.api.servicemanagement.v1.ChangeReport m =
                    input.readMessage(
                        com.google.api.servicemanagement.v1.ChangeReport.parser(),
                        extensionRegistry);
                if (changeReportsBuilder_ == null) {
                  ensureChangeReportsIsMutable();
                  changeReports_.add(m);
                } else {
                  changeReportsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.api.servicemanagement.v1.Diagnostic m =
                    input.readMessage(
                        com.google.api.servicemanagement.v1.Diagnostic.parser(), extensionRegistry);
                if (diagnosticsBuilder_ == null) {
                  ensureDiagnosticsIsMutable();
                  diagnostics_.add(m);
                } else {
                  diagnosticsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * Name of the service this report belongs to.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return The serviceName.
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the service this report belongs to.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return The bytes for serviceName.
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the service this report belongs to.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @param value The serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the service this report belongs to.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceName() {
      serviceName_ = getDefaultInstance().getServiceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the service this report belongs to.
     * </pre>
     *
     * <code>string service_name = 1;</code>
     *
     * @param value The bytes for serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * ID of the service configuration this report belongs to.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the service configuration this report belongs to.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the service configuration this report belongs to.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the service configuration this report belongs to.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the service configuration this report belongs to.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.servicemanagement.v1.ChangeReport> changeReports_ =
        java.util.Collections.emptyList();

    private void ensureChangeReportsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        changeReports_ =
            new java.util.ArrayList<com.google.api.servicemanagement.v1.ChangeReport>(
                changeReports_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.servicemanagement.v1.ChangeReport,
            com.google.api.servicemanagement.v1.ChangeReport.Builder,
            com.google.api.servicemanagement.v1.ChangeReportOrBuilder>
        changeReportsBuilder_;

    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public java.util.List<com.google.api.servicemanagement.v1.ChangeReport> getChangeReportsList() {
      if (changeReportsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(changeReports_);
      } else {
        return changeReportsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public int getChangeReportsCount() {
      if (changeReportsBuilder_ == null) {
        return changeReports_.size();
      } else {
        return changeReportsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public com.google.api.servicemanagement.v1.ChangeReport getChangeReports(int index) {
      if (changeReportsBuilder_ == null) {
        return changeReports_.get(index);
      } else {
        return changeReportsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public Builder setChangeReports(
        int index, com.google.api.servicemanagement.v1.ChangeReport value) {
      if (changeReportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChangeReportsIsMutable();
        changeReports_.set(index, value);
        onChanged();
      } else {
        changeReportsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public Builder setChangeReports(
        int index, com.google.api.servicemanagement.v1.ChangeReport.Builder builderForValue) {
      if (changeReportsBuilder_ == null) {
        ensureChangeReportsIsMutable();
        changeReports_.set(index, builderForValue.build());
        onChanged();
      } else {
        changeReportsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public Builder addChangeReports(com.google.api.servicemanagement.v1.ChangeReport value) {
      if (changeReportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChangeReportsIsMutable();
        changeReports_.add(value);
        onChanged();
      } else {
        changeReportsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public Builder addChangeReports(
        int index, com.google.api.servicemanagement.v1.ChangeReport value) {
      if (changeReportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChangeReportsIsMutable();
        changeReports_.add(index, value);
        onChanged();
      } else {
        changeReportsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public Builder addChangeReports(
        com.google.api.servicemanagement.v1.ChangeReport.Builder builderForValue) {
      if (changeReportsBuilder_ == null) {
        ensureChangeReportsIsMutable();
        changeReports_.add(builderForValue.build());
        onChanged();
      } else {
        changeReportsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public Builder addChangeReports(
        int index, com.google.api.servicemanagement.v1.ChangeReport.Builder builderForValue) {
      if (changeReportsBuilder_ == null) {
        ensureChangeReportsIsMutable();
        changeReports_.add(index, builderForValue.build());
        onChanged();
      } else {
        changeReportsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public Builder addAllChangeReports(
        java.lang.Iterable<? extends com.google.api.servicemanagement.v1.ChangeReport> values) {
      if (changeReportsBuilder_ == null) {
        ensureChangeReportsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, changeReports_);
        onChanged();
      } else {
        changeReportsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public Builder clearChangeReports() {
      if (changeReportsBuilder_ == null) {
        changeReports_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        changeReportsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public Builder removeChangeReports(int index) {
      if (changeReportsBuilder_ == null) {
        ensureChangeReportsIsMutable();
        changeReports_.remove(index);
        onChanged();
      } else {
        changeReportsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public com.google.api.servicemanagement.v1.ChangeReport.Builder getChangeReportsBuilder(
        int index) {
      return getChangeReportsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public com.google.api.servicemanagement.v1.ChangeReportOrBuilder getChangeReportsOrBuilder(
        int index) {
      if (changeReportsBuilder_ == null) {
        return changeReports_.get(index);
      } else {
        return changeReportsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public java.util.List<? extends com.google.api.servicemanagement.v1.ChangeReportOrBuilder>
        getChangeReportsOrBuilderList() {
      if (changeReportsBuilder_ != null) {
        return changeReportsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(changeReports_);
      }
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public com.google.api.servicemanagement.v1.ChangeReport.Builder addChangeReportsBuilder() {
      return getChangeReportsFieldBuilder()
          .addBuilder(com.google.api.servicemanagement.v1.ChangeReport.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public com.google.api.servicemanagement.v1.ChangeReport.Builder addChangeReportsBuilder(
        int index) {
      return getChangeReportsFieldBuilder()
          .addBuilder(index, com.google.api.servicemanagement.v1.ChangeReport.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * list of ChangeReport, each corresponding to comparison between two
     * service configurations.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.ChangeReport change_reports = 3;</code>
     */
    public java.util.List<com.google.api.servicemanagement.v1.ChangeReport.Builder>
        getChangeReportsBuilderList() {
      return getChangeReportsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.servicemanagement.v1.ChangeReport,
            com.google.api.servicemanagement.v1.ChangeReport.Builder,
            com.google.api.servicemanagement.v1.ChangeReportOrBuilder>
        getChangeReportsFieldBuilder() {
      if (changeReportsBuilder_ == null) {
        changeReportsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.servicemanagement.v1.ChangeReport,
                com.google.api.servicemanagement.v1.ChangeReport.Builder,
                com.google.api.servicemanagement.v1.ChangeReportOrBuilder>(
                changeReports_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        changeReports_ = null;
      }
      return changeReportsBuilder_;
    }

    private java.util.List<com.google.api.servicemanagement.v1.Diagnostic> diagnostics_ =
        java.util.Collections.emptyList();

    private void ensureDiagnosticsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        diagnostics_ =
            new java.util.ArrayList<com.google.api.servicemanagement.v1.Diagnostic>(diagnostics_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.servicemanagement.v1.Diagnostic,
            com.google.api.servicemanagement.v1.Diagnostic.Builder,
            com.google.api.servicemanagement.v1.DiagnosticOrBuilder>
        diagnosticsBuilder_;

    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public java.util.List<com.google.api.servicemanagement.v1.Diagnostic> getDiagnosticsList() {
      if (diagnosticsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(diagnostics_);
      } else {
        return diagnosticsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public int getDiagnosticsCount() {
      if (diagnosticsBuilder_ == null) {
        return diagnostics_.size();
      } else {
        return diagnosticsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public com.google.api.servicemanagement.v1.Diagnostic getDiagnostics(int index) {
      if (diagnosticsBuilder_ == null) {
        return diagnostics_.get(index);
      } else {
        return diagnosticsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public Builder setDiagnostics(int index, com.google.api.servicemanagement.v1.Diagnostic value) {
      if (diagnosticsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDiagnosticsIsMutable();
        diagnostics_.set(index, value);
        onChanged();
      } else {
        diagnosticsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public Builder setDiagnostics(
        int index, com.google.api.servicemanagement.v1.Diagnostic.Builder builderForValue) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        diagnostics_.set(index, builderForValue.build());
        onChanged();
      } else {
        diagnosticsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public Builder addDiagnostics(com.google.api.servicemanagement.v1.Diagnostic value) {
      if (diagnosticsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDiagnosticsIsMutable();
        diagnostics_.add(value);
        onChanged();
      } else {
        diagnosticsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public Builder addDiagnostics(int index, com.google.api.servicemanagement.v1.Diagnostic value) {
      if (diagnosticsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDiagnosticsIsMutable();
        diagnostics_.add(index, value);
        onChanged();
      } else {
        diagnosticsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public Builder addDiagnostics(
        com.google.api.servicemanagement.v1.Diagnostic.Builder builderForValue) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        diagnostics_.add(builderForValue.build());
        onChanged();
      } else {
        diagnosticsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public Builder addDiagnostics(
        int index, com.google.api.servicemanagement.v1.Diagnostic.Builder builderForValue) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        diagnostics_.add(index, builderForValue.build());
        onChanged();
      } else {
        diagnosticsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public Builder addAllDiagnostics(
        java.lang.Iterable<? extends com.google.api.servicemanagement.v1.Diagnostic> values) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, diagnostics_);
        onChanged();
      } else {
        diagnosticsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public Builder clearDiagnostics() {
      if (diagnosticsBuilder_ == null) {
        diagnostics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        diagnosticsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public Builder removeDiagnostics(int index) {
      if (diagnosticsBuilder_ == null) {
        ensureDiagnosticsIsMutable();
        diagnostics_.remove(index);
        onChanged();
      } else {
        diagnosticsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public com.google.api.servicemanagement.v1.Diagnostic.Builder getDiagnosticsBuilder(int index) {
      return getDiagnosticsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public com.google.api.servicemanagement.v1.DiagnosticOrBuilder getDiagnosticsOrBuilder(
        int index) {
      if (diagnosticsBuilder_ == null) {
        return diagnostics_.get(index);
      } else {
        return diagnosticsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public java.util.List<? extends com.google.api.servicemanagement.v1.DiagnosticOrBuilder>
        getDiagnosticsOrBuilderList() {
      if (diagnosticsBuilder_ != null) {
        return diagnosticsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(diagnostics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public com.google.api.servicemanagement.v1.Diagnostic.Builder addDiagnosticsBuilder() {
      return getDiagnosticsFieldBuilder()
          .addBuilder(com.google.api.servicemanagement.v1.Diagnostic.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public com.google.api.servicemanagement.v1.Diagnostic.Builder addDiagnosticsBuilder(int index) {
      return getDiagnosticsFieldBuilder()
          .addBuilder(index, com.google.api.servicemanagement.v1.Diagnostic.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Errors / Linter warnings associated with the service definition this
     * report
     * belongs to.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.Diagnostic diagnostics = 4;</code>
     */
    public java.util.List<com.google.api.servicemanagement.v1.Diagnostic.Builder>
        getDiagnosticsBuilderList() {
      return getDiagnosticsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.servicemanagement.v1.Diagnostic,
            com.google.api.servicemanagement.v1.Diagnostic.Builder,
            com.google.api.servicemanagement.v1.DiagnosticOrBuilder>
        getDiagnosticsFieldBuilder() {
      if (diagnosticsBuilder_ == null) {
        diagnosticsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.servicemanagement.v1.Diagnostic,
                com.google.api.servicemanagement.v1.Diagnostic.Builder,
                com.google.api.servicemanagement.v1.DiagnosticOrBuilder>(
                diagnostics_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        diagnostics_ = null;
      }
      return diagnosticsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.servicemanagement.v1.GenerateConfigReportResponse)
  }

  // @@protoc_insertion_point(class_scope:google.api.servicemanagement.v1.GenerateConfigReportResponse)
  private static final com.google.api.servicemanagement.v1.GenerateConfigReportResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.servicemanagement.v1.GenerateConfigReportResponse();
  }

  public static com.google.api.servicemanagement.v1.GenerateConfigReportResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateConfigReportResponse> PARSER =
      new com.google.protobuf.AbstractParser<GenerateConfigReportResponse>() {
        @java.lang.Override
        public GenerateConfigReportResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateConfigReportResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateConfigReportResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.servicemanagement.v1.GenerateConfigReportResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
