/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/servicemanagement/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.api.servicemanagement.v1;

/**
 *
 *
 * <pre>
 * The metadata associated with a long running operation resource.
 * </pre>
 *
 * Protobuf type {@code google.api.servicemanagement.v1.OperationMetadata}
 */
public final class OperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.servicemanagement.v1.OperationMetadata)
    OperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationMetadata.newBuilder() to construct.
  private OperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationMetadata() {
    resourceNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
    steps_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.servicemanagement.v1.ResourcesProto
        .internal_static_google_api_servicemanagement_v1_OperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.servicemanagement.v1.ResourcesProto
        .internal_static_google_api_servicemanagement_v1_OperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.servicemanagement.v1.OperationMetadata.class,
            com.google.api.servicemanagement.v1.OperationMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Code describes the status of the operation (or one of its steps).
   * </pre>
   *
   * Protobuf enum {@code google.api.servicemanagement.v1.OperationMetadata.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecifed code.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The operation or step has completed without errors.
     * </pre>
     *
     * <code>DONE = 1;</code>
     */
    DONE(1),
    /**
     *
     *
     * <pre>
     * The operation or step has not started yet.
     * </pre>
     *
     * <code>NOT_STARTED = 2;</code>
     */
    NOT_STARTED(2),
    /**
     *
     *
     * <pre>
     * The operation or step is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    IN_PROGRESS(3),
    /**
     *
     *
     * <pre>
     * The operation or step has completed with errors. If the operation is
     * rollbackable, the rollback completed with errors too.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    /**
     *
     *
     * <pre>
     * The operation or step has completed with cancellation.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    CANCELLED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecifed code.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The operation or step has completed without errors.
     * </pre>
     *
     * <code>DONE = 1;</code>
     */
    public static final int DONE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The operation or step has not started yet.
     * </pre>
     *
     * <code>NOT_STARTED = 2;</code>
     */
    public static final int NOT_STARTED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The operation or step is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    public static final int IN_PROGRESS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The operation or step has completed with errors. If the operation is
     * rollbackable, the rollback completed with errors too.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The operation or step has completed with cancellation.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    public static final int CANCELLED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return STATUS_UNSPECIFIED;
        case 1:
          return DONE;
        case 2:
          return NOT_STARTED;
        case 3:
          return IN_PROGRESS;
        case 4:
          return FAILED;
        case 5:
          return CANCELLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.api.servicemanagement.v1.OperationMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.servicemanagement.v1.OperationMetadata.Status)
  }

  public interface StepOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.servicemanagement.v1.OperationMetadata.Step)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The short description of the step.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * The short description of the step.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * The status code.
     * </pre>
     *
     * <code>.google.api.servicemanagement.v1.OperationMetadata.Status status = 4;</code>
     *
     * @return The enum numeric value on the wire for status.
     */
    int getStatusValue();
    /**
     *
     *
     * <pre>
     * The status code.
     * </pre>
     *
     * <code>.google.api.servicemanagement.v1.OperationMetadata.Status status = 4;</code>
     *
     * @return The status.
     */
    com.google.api.servicemanagement.v1.OperationMetadata.Status getStatus();
  }
  /**
   *
   *
   * <pre>
   * Represents the status of one operation step.
   * </pre>
   *
   * Protobuf type {@code google.api.servicemanagement.v1.OperationMetadata.Step}
   */
  public static final class Step extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.servicemanagement.v1.OperationMetadata.Step)
      StepOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Step.newBuilder() to construct.
    private Step(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Step() {
      description_ = "";
      status_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Step();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_OperationMetadata_Step_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_OperationMetadata_Step_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.servicemanagement.v1.OperationMetadata.Step.class,
              com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder.class);
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The short description of the step.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The short description of the step.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 4;
    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * The status code.
     * </pre>
     *
     * <code>.google.api.servicemanagement.v1.OperationMetadata.Status status = 4;</code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * The status code.
     * </pre>
     *
     * <code>.google.api.servicemanagement.v1.OperationMetadata.Status status = 4;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.api.servicemanagement.v1.OperationMetadata.Status getStatus() {
      com.google.api.servicemanagement.v1.OperationMetadata.Status result =
          com.google.api.servicemanagement.v1.OperationMetadata.Status.forNumber(status_);
      return result == null
          ? com.google.api.servicemanagement.v1.OperationMetadata.Status.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      if (status_
          != com.google.api.servicemanagement.v1.OperationMetadata.Status.STATUS_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, status_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      if (status_
          != com.google.api.servicemanagement.v1.OperationMetadata.Status.STATUS_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, status_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.api.servicemanagement.v1.OperationMetadata.Step)) {
        return super.equals(obj);
      }
      com.google.api.servicemanagement.v1.OperationMetadata.Step other =
          (com.google.api.servicemanagement.v1.OperationMetadata.Step) obj;

      if (!getDescription().equals(other.getDescription())) return false;
      if (status_ != other.status_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + status_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.api.servicemanagement.v1.OperationMetadata.Step prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents the status of one operation step.
     * </pre>
     *
     * Protobuf type {@code google.api.servicemanagement.v1.OperationMetadata.Step}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.servicemanagement.v1.OperationMetadata.Step)
        com.google.api.servicemanagement.v1.OperationMetadata.StepOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.api.servicemanagement.v1.ResourcesProto
            .internal_static_google_api_servicemanagement_v1_OperationMetadata_Step_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.servicemanagement.v1.ResourcesProto
            .internal_static_google_api_servicemanagement_v1_OperationMetadata_Step_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.servicemanagement.v1.OperationMetadata.Step.class,
                com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder.class);
      }

      // Construct using com.google.api.servicemanagement.v1.OperationMetadata.Step.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        description_ = "";
        status_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.api.servicemanagement.v1.ResourcesProto
            .internal_static_google_api_servicemanagement_v1_OperationMetadata_Step_descriptor;
      }

      @java.lang.Override
      public com.google.api.servicemanagement.v1.OperationMetadata.Step
          getDefaultInstanceForType() {
        return com.google.api.servicemanagement.v1.OperationMetadata.Step.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.api.servicemanagement.v1.OperationMetadata.Step build() {
        com.google.api.servicemanagement.v1.OperationMetadata.Step result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.api.servicemanagement.v1.OperationMetadata.Step buildPartial() {
        com.google.api.servicemanagement.v1.OperationMetadata.Step result =
            new com.google.api.servicemanagement.v1.OperationMetadata.Step(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.api.servicemanagement.v1.OperationMetadata.Step result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.status_ = status_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.api.servicemanagement.v1.OperationMetadata.Step) {
          return mergeFrom((com.google.api.servicemanagement.v1.OperationMetadata.Step) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.api.servicemanagement.v1.OperationMetadata.Step other) {
        if (other
            == com.google.api.servicemanagement.v1.OperationMetadata.Step.getDefaultInstance())
          return this;
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.status_ != 0) {
          setStatusValue(other.getStatusValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              case 32:
                {
                  status_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * The short description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The short description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The short description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The short description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The short description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int status_ = 0;
      /**
       *
       *
       * <pre>
       * The status code.
       * </pre>
       *
       * <code>.google.api.servicemanagement.v1.OperationMetadata.Status status = 4;</code>
       *
       * @return The enum numeric value on the wire for status.
       */
      @java.lang.Override
      public int getStatusValue() {
        return status_;
      }
      /**
       *
       *
       * <pre>
       * The status code.
       * </pre>
       *
       * <code>.google.api.servicemanagement.v1.OperationMetadata.Status status = 4;</code>
       *
       * @param value The enum numeric value on the wire for status to set.
       * @return This builder for chaining.
       */
      public Builder setStatusValue(int value) {
        status_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status code.
       * </pre>
       *
       * <code>.google.api.servicemanagement.v1.OperationMetadata.Status status = 4;</code>
       *
       * @return The status.
       */
      @java.lang.Override
      public com.google.api.servicemanagement.v1.OperationMetadata.Status getStatus() {
        com.google.api.servicemanagement.v1.OperationMetadata.Status result =
            com.google.api.servicemanagement.v1.OperationMetadata.Status.forNumber(status_);
        return result == null
            ? com.google.api.servicemanagement.v1.OperationMetadata.Status.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The status code.
       * </pre>
       *
       * <code>.google.api.servicemanagement.v1.OperationMetadata.Status status = 4;</code>
       *
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(com.google.api.servicemanagement.v1.OperationMetadata.Status value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status code.
       * </pre>
       *
       * <code>.google.api.servicemanagement.v1.OperationMetadata.Status status = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.servicemanagement.v1.OperationMetadata.Step)
    }

    // @@protoc_insertion_point(class_scope:google.api.servicemanagement.v1.OperationMetadata.Step)
    private static final com.google.api.servicemanagement.v1.OperationMetadata.Step
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.api.servicemanagement.v1.OperationMetadata.Step();
    }

    public static com.google.api.servicemanagement.v1.OperationMetadata.Step getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Step> PARSER =
        new com.google.protobuf.AbstractParser<Step>() {
          @java.lang.Override
          public Step parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Step> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Step> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.OperationMetadata.Step getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int RESOURCE_NAMES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList resourceNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The full name of the resources that this operation is directly
   * associated with.
   * </pre>
   *
   * <code>repeated string resource_names = 1;</code>
   *
   * @return A list containing the resourceNames.
   */
  public com.google.protobuf.ProtocolStringList getResourceNamesList() {
    return resourceNames_;
  }
  /**
   *
   *
   * <pre>
   * The full name of the resources that this operation is directly
   * associated with.
   * </pre>
   *
   * <code>repeated string resource_names = 1;</code>
   *
   * @return The count of resourceNames.
   */
  public int getResourceNamesCount() {
    return resourceNames_.size();
  }
  /**
   *
   *
   * <pre>
   * The full name of the resources that this operation is directly
   * associated with.
   * </pre>
   *
   * <code>repeated string resource_names = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The resourceNames at the given index.
   */
  public java.lang.String getResourceNames(int index) {
    return resourceNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The full name of the resources that this operation is directly
   * associated with.
   * </pre>
   *
   * <code>repeated string resource_names = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the resourceNames at the given index.
   */
  public com.google.protobuf.ByteString getResourceNamesBytes(int index) {
    return resourceNames_.getByteString(index);
  }

  public static final int STEPS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.servicemanagement.v1.OperationMetadata.Step> steps_;
  /**
   *
   *
   * <pre>
   * Detailed status information for each step. The order is undetermined.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.servicemanagement.v1.OperationMetadata.Step> getStepsList() {
    return steps_;
  }
  /**
   *
   *
   * <pre>
   * Detailed status information for each step. The order is undetermined.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.api.servicemanagement.v1.OperationMetadata.StepOrBuilder>
      getStepsOrBuilderList() {
    return steps_;
  }
  /**
   *
   *
   * <pre>
   * Detailed status information for each step. The order is undetermined.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
   */
  @java.lang.Override
  public int getStepsCount() {
    return steps_.size();
  }
  /**
   *
   *
   * <pre>
   * Detailed status information for each step. The order is undetermined.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.OperationMetadata.Step getSteps(int index) {
    return steps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Detailed status information for each step. The order is undetermined.
   * </pre>
   *
   * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.OperationMetadata.StepOrBuilder getStepsOrBuilder(
      int index) {
    return steps_.get(index);
  }

  public static final int PROGRESS_PERCENTAGE_FIELD_NUMBER = 3;
  private int progressPercentage_ = 0;
  /**
   *
   *
   * <pre>
   * Percentage of completion of this operation, ranging from 0 to 100.
   * </pre>
   *
   * <code>int32 progress_percentage = 3;</code>
   *
   * @return The progressPercentage.
   */
  @java.lang.Override
  public int getProgressPercentage() {
    return progressPercentage_;
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The start time of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The start time of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The start time of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < resourceNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceNames_.getRaw(i));
    }
    for (int i = 0; i < steps_.size(); i++) {
      output.writeMessage(2, steps_.get(i));
    }
    if (progressPercentage_ != 0) {
      output.writeInt32(3, progressPercentage_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getStartTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < resourceNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(resourceNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getResourceNamesList().size();
    }
    for (int i = 0; i < steps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, steps_.get(i));
    }
    if (progressPercentage_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, progressPercentage_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.servicemanagement.v1.OperationMetadata)) {
      return super.equals(obj);
    }
    com.google.api.servicemanagement.v1.OperationMetadata other =
        (com.google.api.servicemanagement.v1.OperationMetadata) obj;

    if (!getResourceNamesList().equals(other.getResourceNamesList())) return false;
    if (!getStepsList().equals(other.getStepsList())) return false;
    if (getProgressPercentage() != other.getProgressPercentage()) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResourceNamesCount() > 0) {
      hash = (37 * hash) + RESOURCE_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getResourceNamesList().hashCode();
    }
    if (getStepsCount() > 0) {
      hash = (37 * hash) + STEPS_FIELD_NUMBER;
      hash = (53 * hash) + getStepsList().hashCode();
    }
    hash = (37 * hash) + PROGRESS_PERCENTAGE_FIELD_NUMBER;
    hash = (53 * hash) + getProgressPercentage();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.api.servicemanagement.v1.OperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The metadata associated with a long running operation resource.
   * </pre>
   *
   * Protobuf type {@code google.api.servicemanagement.v1.OperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.servicemanagement.v1.OperationMetadata)
      com.google.api.servicemanagement.v1.OperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_OperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_OperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.servicemanagement.v1.OperationMetadata.class,
              com.google.api.servicemanagement.v1.OperationMetadata.Builder.class);
    }

    // Construct using com.google.api.servicemanagement.v1.OperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStepsFieldBuilder();
        getStartTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (stepsBuilder_ == null) {
        steps_ = java.util.Collections.emptyList();
      } else {
        steps_ = null;
        stepsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      progressPercentage_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_OperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.OperationMetadata getDefaultInstanceForType() {
      return com.google.api.servicemanagement.v1.OperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.OperationMetadata build() {
      com.google.api.servicemanagement.v1.OperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.OperationMetadata buildPartial() {
      com.google.api.servicemanagement.v1.OperationMetadata result =
          new com.google.api.servicemanagement.v1.OperationMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.api.servicemanagement.v1.OperationMetadata result) {
      if (stepsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          steps_ = java.util.Collections.unmodifiableList(steps_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.steps_ = steps_;
      } else {
        result.steps_ = stepsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.servicemanagement.v1.OperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        resourceNames_.makeImmutable();
        result.resourceNames_ = resourceNames_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.progressPercentage_ = progressPercentage_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.servicemanagement.v1.OperationMetadata) {
        return mergeFrom((com.google.api.servicemanagement.v1.OperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.servicemanagement.v1.OperationMetadata other) {
      if (other == com.google.api.servicemanagement.v1.OperationMetadata.getDefaultInstance())
        return this;
      if (!other.resourceNames_.isEmpty()) {
        if (resourceNames_.isEmpty()) {
          resourceNames_ = other.resourceNames_;
          bitField0_ |= 0x00000001;
        } else {
          ensureResourceNamesIsMutable();
          resourceNames_.addAll(other.resourceNames_);
        }
        onChanged();
      }
      if (stepsBuilder_ == null) {
        if (!other.steps_.isEmpty()) {
          if (steps_.isEmpty()) {
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureStepsIsMutable();
            steps_.addAll(other.steps_);
          }
          onChanged();
        }
      } else {
        if (!other.steps_.isEmpty()) {
          if (stepsBuilder_.isEmpty()) {
            stepsBuilder_.dispose();
            stepsBuilder_ = null;
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000002);
            stepsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStepsFieldBuilder()
                    : null;
          } else {
            stepsBuilder_.addAllMessages(other.steps_);
          }
        }
      }
      if (other.getProgressPercentage() != 0) {
        setProgressPercentage(other.getProgressPercentage());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResourceNamesIsMutable();
                resourceNames_.add(s);
                break;
              } // case 10
            case 18:
              {
                com.google.api.servicemanagement.v1.OperationMetadata.Step m =
                    input.readMessage(
                        com.google.api.servicemanagement.v1.OperationMetadata.Step.parser(),
                        extensionRegistry);
                if (stepsBuilder_ == null) {
                  ensureStepsIsMutable();
                  steps_.add(m);
                } else {
                  stepsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                progressPercentage_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList resourceNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureResourceNamesIsMutable() {
      if (!resourceNames_.isModifiable()) {
        resourceNames_ = new com.google.protobuf.LazyStringArrayList(resourceNames_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * The full name of the resources that this operation is directly
     * associated with.
     * </pre>
     *
     * <code>repeated string resource_names = 1;</code>
     *
     * @return A list containing the resourceNames.
     */
    public com.google.protobuf.ProtocolStringList getResourceNamesList() {
      resourceNames_.makeImmutable();
      return resourceNames_;
    }
    /**
     *
     *
     * <pre>
     * The full name of the resources that this operation is directly
     * associated with.
     * </pre>
     *
     * <code>repeated string resource_names = 1;</code>
     *
     * @return The count of resourceNames.
     */
    public int getResourceNamesCount() {
      return resourceNames_.size();
    }
    /**
     *
     *
     * <pre>
     * The full name of the resources that this operation is directly
     * associated with.
     * </pre>
     *
     * <code>repeated string resource_names = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The resourceNames at the given index.
     */
    public java.lang.String getResourceNames(int index) {
      return resourceNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The full name of the resources that this operation is directly
     * associated with.
     * </pre>
     *
     * <code>repeated string resource_names = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourceNames at the given index.
     */
    public com.google.protobuf.ByteString getResourceNamesBytes(int index) {
      return resourceNames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The full name of the resources that this operation is directly
     * associated with.
     * </pre>
     *
     * <code>repeated string resource_names = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The resourceNames to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourceNamesIsMutable();
      resourceNames_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the resources that this operation is directly
     * associated with.
     * </pre>
     *
     * <code>repeated string resource_names = 1;</code>
     *
     * @param value The resourceNames to add.
     * @return This builder for chaining.
     */
    public Builder addResourceNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourceNamesIsMutable();
      resourceNames_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the resources that this operation is directly
     * associated with.
     * </pre>
     *
     * <code>repeated string resource_names = 1;</code>
     *
     * @param values The resourceNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllResourceNames(java.lang.Iterable<java.lang.String> values) {
      ensureResourceNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceNames_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the resources that this operation is directly
     * associated with.
     * </pre>
     *
     * <code>repeated string resource_names = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceNames() {
      resourceNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the resources that this operation is directly
     * associated with.
     * </pre>
     *
     * <code>repeated string resource_names = 1;</code>
     *
     * @param value The bytes of the resourceNames to add.
     * @return This builder for chaining.
     */
    public Builder addResourceNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResourceNamesIsMutable();
      resourceNames_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.servicemanagement.v1.OperationMetadata.Step> steps_ =
        java.util.Collections.emptyList();

    private void ensureStepsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        steps_ =
            new java.util.ArrayList<com.google.api.servicemanagement.v1.OperationMetadata.Step>(
                steps_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.servicemanagement.v1.OperationMetadata.Step,
            com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder,
            com.google.api.servicemanagement.v1.OperationMetadata.StepOrBuilder>
        stepsBuilder_;

    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public java.util.List<com.google.api.servicemanagement.v1.OperationMetadata.Step>
        getStepsList() {
      if (stepsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(steps_);
      } else {
        return stepsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public int getStepsCount() {
      if (stepsBuilder_ == null) {
        return steps_.size();
      } else {
        return stepsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public com.google.api.servicemanagement.v1.OperationMetadata.Step getSteps(int index) {
      if (stepsBuilder_ == null) {
        return steps_.get(index);
      } else {
        return stepsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public Builder setSteps(
        int index, com.google.api.servicemanagement.v1.OperationMetadata.Step value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.set(index, value);
        onChanged();
      } else {
        stepsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public Builder setSteps(
        int index,
        com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.set(index, builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public Builder addSteps(com.google.api.servicemanagement.v1.OperationMetadata.Step value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.add(value);
        onChanged();
      } else {
        stepsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public Builder addSteps(
        int index, com.google.api.servicemanagement.v1.OperationMetadata.Step value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.add(index, value);
        onChanged();
      } else {
        stepsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public Builder addSteps(
        com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.add(builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public Builder addSteps(
        int index,
        com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.add(index, builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public Builder addAllSteps(
        java.lang.Iterable<? extends com.google.api.servicemanagement.v1.OperationMetadata.Step>
            values) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, steps_);
        onChanged();
      } else {
        stepsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public Builder clearSteps() {
      if (stepsBuilder_ == null) {
        steps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        stepsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public Builder removeSteps(int index) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.remove(index);
        onChanged();
      } else {
        stepsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder getStepsBuilder(
        int index) {
      return getStepsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public com.google.api.servicemanagement.v1.OperationMetadata.StepOrBuilder getStepsOrBuilder(
        int index) {
      if (stepsBuilder_ == null) {
        return steps_.get(index);
      } else {
        return stepsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public java.util.List<
            ? extends com.google.api.servicemanagement.v1.OperationMetadata.StepOrBuilder>
        getStepsOrBuilderList() {
      if (stepsBuilder_ != null) {
        return stepsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(steps_);
      }
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder addStepsBuilder() {
      return getStepsFieldBuilder()
          .addBuilder(
              com.google.api.servicemanagement.v1.OperationMetadata.Step.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder addStepsBuilder(
        int index) {
      return getStepsFieldBuilder()
          .addBuilder(
              index,
              com.google.api.servicemanagement.v1.OperationMetadata.Step.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Detailed status information for each step. The order is undetermined.
     * </pre>
     *
     * <code>repeated .google.api.servicemanagement.v1.OperationMetadata.Step steps = 2;</code>
     */
    public java.util.List<com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder>
        getStepsBuilderList() {
      return getStepsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.servicemanagement.v1.OperationMetadata.Step,
            com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder,
            com.google.api.servicemanagement.v1.OperationMetadata.StepOrBuilder>
        getStepsFieldBuilder() {
      if (stepsBuilder_ == null) {
        stepsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.servicemanagement.v1.OperationMetadata.Step,
                com.google.api.servicemanagement.v1.OperationMetadata.Step.Builder,
                com.google.api.servicemanagement.v1.OperationMetadata.StepOrBuilder>(
                steps_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        steps_ = null;
      }
      return stepsBuilder_;
    }

    private int progressPercentage_;
    /**
     *
     *
     * <pre>
     * Percentage of completion of this operation, ranging from 0 to 100.
     * </pre>
     *
     * <code>int32 progress_percentage = 3;</code>
     *
     * @return The progressPercentage.
     */
    @java.lang.Override
    public int getProgressPercentage() {
      return progressPercentage_;
    }
    /**
     *
     *
     * <pre>
     * Percentage of completion of this operation, ranging from 0 to 100.
     * </pre>
     *
     * <code>int32 progress_percentage = 3;</code>
     *
     * @param value The progressPercentage to set.
     * @return This builder for chaining.
     */
    public Builder setProgressPercentage(int value) {

      progressPercentage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Percentage of completion of this operation, ranging from 0 to 100.
     * </pre>
     *
     * <code>int32 progress_percentage = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProgressPercentage() {
      bitField0_ = (bitField0_ & ~0x00000004);
      progressPercentage_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The start time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The start time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The start time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The start time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The start time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.servicemanagement.v1.OperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.api.servicemanagement.v1.OperationMetadata)
  private static final com.google.api.servicemanagement.v1.OperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.servicemanagement.v1.OperationMetadata();
  }

  public static com.google.api.servicemanagement.v1.OperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<OperationMetadata>() {
        @java.lang.Override
        public OperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.servicemanagement.v1.OperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
