/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/servicemanagement/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.api.servicemanagement.v1;

/**
 *
 *
 * <pre>
 * A rollout resource that defines how service configuration versions are pushed
 * to control plane systems. Typically, you create a new version of the
 * service config, and then create a Rollout to push the service config.
 * </pre>
 *
 * Protobuf type {@code google.api.servicemanagement.v1.Rollout}
 */
public final class Rollout extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.servicemanagement.v1.Rollout)
    RolloutOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Rollout.newBuilder() to construct.
  private Rollout(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Rollout() {
    rolloutId_ = "";
    createdBy_ = "";
    status_ = 0;
    serviceName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Rollout();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.servicemanagement.v1.ResourcesProto
        .internal_static_google_api_servicemanagement_v1_Rollout_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.servicemanagement.v1.ResourcesProto
        .internal_static_google_api_servicemanagement_v1_Rollout_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.servicemanagement.v1.Rollout.class,
            com.google.api.servicemanagement.v1.Rollout.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Status of a Rollout.
   * </pre>
   *
   * Protobuf enum {@code google.api.servicemanagement.v1.Rollout.RolloutStatus}
   */
  public enum RolloutStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No status specified.
     * </pre>
     *
     * <code>ROLLOUT_STATUS_UNSPECIFIED = 0;</code>
     */
    ROLLOUT_STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The Rollout is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    IN_PROGRESS(1),
    /**
     *
     *
     * <pre>
     * The Rollout has completed successfully.
     * </pre>
     *
     * <code>SUCCESS = 2;</code>
     */
    SUCCESS(2),
    /**
     *
     *
     * <pre>
     * The Rollout has been cancelled. This can happen if you have overlapping
     * Rollout pushes, and the previous ones will be cancelled.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    CANCELLED(3),
    /**
     *
     *
     * <pre>
     * The Rollout has failed and the rollback attempt has failed too.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    /**
     *
     *
     * <pre>
     * The Rollout has not started yet and is pending for execution.
     * </pre>
     *
     * <code>PENDING = 5;</code>
     */
    PENDING(5),
    /**
     *
     *
     * <pre>
     * The Rollout has failed and rolled back to the previous successful
     * Rollout.
     * </pre>
     *
     * <code>FAILED_ROLLED_BACK = 6;</code>
     */
    FAILED_ROLLED_BACK(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No status specified.
     * </pre>
     *
     * <code>ROLLOUT_STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int ROLLOUT_STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The Rollout is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    public static final int IN_PROGRESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The Rollout has completed successfully.
     * </pre>
     *
     * <code>SUCCESS = 2;</code>
     */
    public static final int SUCCESS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The Rollout has been cancelled. This can happen if you have overlapping
     * Rollout pushes, and the previous ones will be cancelled.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    public static final int CANCELLED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The Rollout has failed and the rollback attempt has failed too.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The Rollout has not started yet and is pending for execution.
     * </pre>
     *
     * <code>PENDING = 5;</code>
     */
    public static final int PENDING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The Rollout has failed and rolled back to the previous successful
     * Rollout.
     * </pre>
     *
     * <code>FAILED_ROLLED_BACK = 6;</code>
     */
    public static final int FAILED_ROLLED_BACK_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RolloutStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RolloutStatus forNumber(int value) {
      switch (value) {
        case 0:
          return ROLLOUT_STATUS_UNSPECIFIED;
        case 1:
          return IN_PROGRESS;
        case 2:
          return SUCCESS;
        case 3:
          return CANCELLED;
        case 4:
          return FAILED;
        case 5:
          return PENDING;
        case 6:
          return FAILED_ROLLED_BACK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RolloutStatus> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RolloutStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RolloutStatus>() {
          public RolloutStatus findValueByNumber(int number) {
            return RolloutStatus.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.api.servicemanagement.v1.Rollout.getDescriptor().getEnumTypes().get(0);
    }

    private static final RolloutStatus[] VALUES = values();

    public static RolloutStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RolloutStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.servicemanagement.v1.Rollout.RolloutStatus)
  }

  public interface TrafficPercentStrategyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Maps service configuration IDs to their corresponding traffic percentage.
     * Key is the service configuration ID, Value is the traffic percentage
     * which must be greater than 0.0 and the sum must equal to 100.0.
     * </pre>
     *
     * <code>map&lt;string, double&gt; percentages = 1;</code>
     */
    int getPercentagesCount();
    /**
     *
     *
     * <pre>
     * Maps service configuration IDs to their corresponding traffic percentage.
     * Key is the service configuration ID, Value is the traffic percentage
     * which must be greater than 0.0 and the sum must equal to 100.0.
     * </pre>
     *
     * <code>map&lt;string, double&gt; percentages = 1;</code>
     */
    boolean containsPercentages(java.lang.String key);
    /** Use {@link #getPercentagesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.Double> getPercentages();
    /**
     *
     *
     * <pre>
     * Maps service configuration IDs to their corresponding traffic percentage.
     * Key is the service configuration ID, Value is the traffic percentage
     * which must be greater than 0.0 and the sum must equal to 100.0.
     * </pre>
     *
     * <code>map&lt;string, double&gt; percentages = 1;</code>
     */
    java.util.Map<java.lang.String, java.lang.Double> getPercentagesMap();
    /**
     *
     *
     * <pre>
     * Maps service configuration IDs to their corresponding traffic percentage.
     * Key is the service configuration ID, Value is the traffic percentage
     * which must be greater than 0.0 and the sum must equal to 100.0.
     * </pre>
     *
     * <code>map&lt;string, double&gt; percentages = 1;</code>
     */
    double getPercentagesOrDefault(java.lang.String key, double defaultValue);
    /**
     *
     *
     * <pre>
     * Maps service configuration IDs to their corresponding traffic percentage.
     * Key is the service configuration ID, Value is the traffic percentage
     * which must be greater than 0.0 and the sum must equal to 100.0.
     * </pre>
     *
     * <code>map&lt;string, double&gt; percentages = 1;</code>
     */
    double getPercentagesOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * Strategy that specifies how clients of Google Service Controller want to
   * send traffic to use different config versions. This is generally
   * used by API proxy to split traffic based on your configured percentage for
   * each config version.
   *
   * One example of how to gradually rollout a new service configuration using
   * this
   * strategy:
   * Day 1
   *
   *     Rollout {
   *       id: "example.googleapis.com/rollout_20160206"
   *       traffic_percent_strategy {
   *         percentages: {
   *           "example.googleapis.com/20160201": 70.00
   *           "example.googleapis.com/20160206": 30.00
   *         }
   *       }
   *     }
   *
   * Day 2
   *
   *     Rollout {
   *       id: "example.googleapis.com/rollout_20160207"
   *       traffic_percent_strategy: {
   *         percentages: {
   *           "example.googleapis.com/20160206": 100.00
   *         }
   *       }
   *     }
   * </pre>
   *
   * Protobuf type {@code google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy}
   */
  public static final class TrafficPercentStrategy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy)
      TrafficPercentStrategyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TrafficPercentStrategy.newBuilder() to construct.
    private TrafficPercentStrategy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TrafficPercentStrategy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TrafficPercentStrategy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_Rollout_TrafficPercentStrategy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetPercentages();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_Rollout_TrafficPercentStrategy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.class,
              com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.Builder.class);
    }

    public static final int PERCENTAGES_FIELD_NUMBER = 1;

    private static final class PercentagesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.Double>newDefaultInstance(
              com.google.api.servicemanagement.v1.ResourcesProto
                  .internal_static_google_api_servicemanagement_v1_Rollout_TrafficPercentStrategy_PercentagesEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.DOUBLE,
              0D);
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> percentages_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double>
        internalGetPercentages() {
      if (percentages_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PercentagesDefaultEntryHolder.defaultEntry);
      }
      return percentages_;
    }

    public int getPercentagesCount() {
      return internalGetPercentages().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Maps service configuration IDs to their corresponding traffic percentage.
     * Key is the service configuration ID, Value is the traffic percentage
     * which must be greater than 0.0 and the sum must equal to 100.0.
     * </pre>
     *
     * <code>map&lt;string, double&gt; percentages = 1;</code>
     */
    @java.lang.Override
    public boolean containsPercentages(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPercentages().getMap().containsKey(key);
    }
    /** Use {@link #getPercentagesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getPercentages() {
      return getPercentagesMap();
    }
    /**
     *
     *
     * <pre>
     * Maps service configuration IDs to their corresponding traffic percentage.
     * Key is the service configuration ID, Value is the traffic percentage
     * which must be greater than 0.0 and the sum must equal to 100.0.
     * </pre>
     *
     * <code>map&lt;string, double&gt; percentages = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Double> getPercentagesMap() {
      return internalGetPercentages().getMap();
    }
    /**
     *
     *
     * <pre>
     * Maps service configuration IDs to their corresponding traffic percentage.
     * Key is the service configuration ID, Value is the traffic percentage
     * which must be greater than 0.0 and the sum must equal to 100.0.
     * </pre>
     *
     * <code>map&lt;string, double&gt; percentages = 1;</code>
     */
    @java.lang.Override
    public double getPercentagesOrDefault(java.lang.String key, double defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetPercentages().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Maps service configuration IDs to their corresponding traffic percentage.
     * Key is the service configuration ID, Value is the traffic percentage
     * which must be greater than 0.0 and the sum must equal to 100.0.
     * </pre>
     *
     * <code>map&lt;string, double&gt; percentages = 1;</code>
     */
    @java.lang.Override
    public double getPercentagesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetPercentages().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetPercentages(), PercentagesDefaultEntryHolder.defaultEntry, 1);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<java.lang.String, java.lang.Double> entry :
          internalGetPercentages().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> percentages__ =
            PercentagesDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, percentages__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy)) {
        return super.equals(obj);
      }
      com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy other =
          (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) obj;

      if (!internalGetPercentages().equals(other.internalGetPercentages())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetPercentages().getMap().isEmpty()) {
        hash = (37 * hash) + PERCENTAGES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetPercentages().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Strategy that specifies how clients of Google Service Controller want to
     * send traffic to use different config versions. This is generally
     * used by API proxy to split traffic based on your configured percentage for
     * each config version.
     *
     * One example of how to gradually rollout a new service configuration using
     * this
     * strategy:
     * Day 1
     *
     *     Rollout {
     *       id: "example.googleapis.com/rollout_20160206"
     *       traffic_percent_strategy {
     *         percentages: {
     *           "example.googleapis.com/20160201": 70.00
     *           "example.googleapis.com/20160206": 30.00
     *         }
     *       }
     *     }
     *
     * Day 2
     *
     *     Rollout {
     *       id: "example.googleapis.com/rollout_20160207"
     *       traffic_percent_strategy: {
     *         percentages: {
     *           "example.googleapis.com/20160206": 100.00
     *         }
     *       }
     *     }
     * </pre>
     *
     * Protobuf type {@code google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy)
        com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.api.servicemanagement.v1.ResourcesProto
            .internal_static_google_api_servicemanagement_v1_Rollout_TrafficPercentStrategy_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetPercentages();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetMutablePercentages();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.servicemanagement.v1.ResourcesProto
            .internal_static_google_api_servicemanagement_v1_Rollout_TrafficPercentStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.class,
                com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.Builder.class);
      }

      // Construct using
      // com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        internalGetMutablePercentages().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.api.servicemanagement.v1.ResourcesProto
            .internal_static_google_api_servicemanagement_v1_Rollout_TrafficPercentStrategy_descriptor;
      }

      @java.lang.Override
      public com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
          getDefaultInstanceForType() {
        return com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy build() {
        com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy buildPartial() {
        com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy result =
            new com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.percentages_ = internalGetPercentages();
          result.percentages_.makeImmutable();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) {
          return mergeFrom(
              (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy other) {
        if (other
            == com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
                .getDefaultInstance()) return this;
        internalGetMutablePercentages().mergeFrom(other.internalGetPercentages());
        bitField0_ |= 0x00000001;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> percentages__ =
                      input.readMessage(
                          PercentagesDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutablePercentages()
                      .getMutableMap()
                      .put(percentages__.getKey(), percentages__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.Double> percentages_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.Double>
          internalGetPercentages() {
        if (percentages_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              PercentagesDefaultEntryHolder.defaultEntry);
        }
        return percentages_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.Double>
          internalGetMutablePercentages() {
        if (percentages_ == null) {
          percentages_ =
              com.google.protobuf.MapField.newMapField(PercentagesDefaultEntryHolder.defaultEntry);
        }
        if (!percentages_.isMutable()) {
          percentages_ = percentages_.copy();
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return percentages_;
      }

      public int getPercentagesCount() {
        return internalGetPercentages().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Maps service configuration IDs to their corresponding traffic percentage.
       * Key is the service configuration ID, Value is the traffic percentage
       * which must be greater than 0.0 and the sum must equal to 100.0.
       * </pre>
       *
       * <code>map&lt;string, double&gt; percentages = 1;</code>
       */
      @java.lang.Override
      public boolean containsPercentages(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetPercentages().getMap().containsKey(key);
      }
      /** Use {@link #getPercentagesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Double> getPercentages() {
        return getPercentagesMap();
      }
      /**
       *
       *
       * <pre>
       * Maps service configuration IDs to their corresponding traffic percentage.
       * Key is the service configuration ID, Value is the traffic percentage
       * which must be greater than 0.0 and the sum must equal to 100.0.
       * </pre>
       *
       * <code>map&lt;string, double&gt; percentages = 1;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.Double> getPercentagesMap() {
        return internalGetPercentages().getMap();
      }
      /**
       *
       *
       * <pre>
       * Maps service configuration IDs to their corresponding traffic percentage.
       * Key is the service configuration ID, Value is the traffic percentage
       * which must be greater than 0.0 and the sum must equal to 100.0.
       * </pre>
       *
       * <code>map&lt;string, double&gt; percentages = 1;</code>
       */
      @java.lang.Override
      public double getPercentagesOrDefault(java.lang.String key, double defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Double> map = internalGetPercentages().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Maps service configuration IDs to their corresponding traffic percentage.
       * Key is the service configuration ID, Value is the traffic percentage
       * which must be greater than 0.0 and the sum must equal to 100.0.
       * </pre>
       *
       * <code>map&lt;string, double&gt; percentages = 1;</code>
       */
      @java.lang.Override
      public double getPercentagesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Double> map = internalGetPercentages().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearPercentages() {
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutablePercentages().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maps service configuration IDs to their corresponding traffic percentage.
       * Key is the service configuration ID, Value is the traffic percentage
       * which must be greater than 0.0 and the sum must equal to 100.0.
       * </pre>
       *
       * <code>map&lt;string, double&gt; percentages = 1;</code>
       */
      public Builder removePercentages(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutablePercentages().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Double> getMutablePercentages() {
        bitField0_ |= 0x00000001;
        return internalGetMutablePercentages().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Maps service configuration IDs to their corresponding traffic percentage.
       * Key is the service configuration ID, Value is the traffic percentage
       * which must be greater than 0.0 and the sum must equal to 100.0.
       * </pre>
       *
       * <code>map&lt;string, double&gt; percentages = 1;</code>
       */
      public Builder putPercentages(java.lang.String key, double value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }

        internalGetMutablePercentages().getMutableMap().put(key, value);
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maps service configuration IDs to their corresponding traffic percentage.
       * Key is the service configuration ID, Value is the traffic percentage
       * which must be greater than 0.0 and the sum must equal to 100.0.
       * </pre>
       *
       * <code>map&lt;string, double&gt; percentages = 1;</code>
       */
      public Builder putAllPercentages(java.util.Map<java.lang.String, java.lang.Double> values) {
        internalGetMutablePercentages().getMutableMap().putAll(values);
        bitField0_ |= 0x00000001;
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy)
    }

    // @@protoc_insertion_point(class_scope:google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy)
    private static final com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy();
    }

    public static com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TrafficPercentStrategy> PARSER =
        new com.google.protobuf.AbstractParser<TrafficPercentStrategy>() {
          @java.lang.Override
          public TrafficPercentStrategy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TrafficPercentStrategy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TrafficPercentStrategy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeleteServiceStrategyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Strategy used to delete a service. This strategy is a placeholder only
   * used by the system generated rollout to delete a service.
   * </pre>
   *
   * Protobuf type {@code google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy}
   */
  public static final class DeleteServiceStrategy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy)
      DeleteServiceStrategyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeleteServiceStrategy.newBuilder() to construct.
    private DeleteServiceStrategy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeleteServiceStrategy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeleteServiceStrategy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_Rollout_DeleteServiceStrategy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_Rollout_DeleteServiceStrategy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.class,
              com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy)) {
        return super.equals(obj);
      }
      com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy other =
          (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Strategy used to delete a service. This strategy is a placeholder only
     * used by the system generated rollout to delete a service.
     * </pre>
     *
     * Protobuf type {@code google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy)
        com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.api.servicemanagement.v1.ResourcesProto
            .internal_static_google_api_servicemanagement_v1_Rollout_DeleteServiceStrategy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.servicemanagement.v1.ResourcesProto
            .internal_static_google_api_servicemanagement_v1_Rollout_DeleteServiceStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.class,
                com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.Builder.class);
      }

      // Construct using
      // com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.api.servicemanagement.v1.ResourcesProto
            .internal_static_google_api_servicemanagement_v1_Rollout_DeleteServiceStrategy_descriptor;
      }

      @java.lang.Override
      public com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
          getDefaultInstanceForType() {
        return com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy build() {
        com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy buildPartial() {
        com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy result =
            new com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) {
          return mergeFrom(
              (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy other) {
        if (other
            == com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy)
    }

    // @@protoc_insertion_point(class_scope:google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy)
    private static final com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy();
    }

    public static com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeleteServiceStrategy> PARSER =
        new com.google.protobuf.AbstractParser<DeleteServiceStrategy>() {
          @java.lang.Override
          public DeleteServiceStrategy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeleteServiceStrategy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeleteServiceStrategy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int strategyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object strategy_;

  public enum StrategyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRAFFIC_PERCENT_STRATEGY(5),
    DELETE_SERVICE_STRATEGY(200),
    STRATEGY_NOT_SET(0);
    private final int value;

    private StrategyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StrategyCase valueOf(int value) {
      return forNumber(value);
    }

    public static StrategyCase forNumber(int value) {
      switch (value) {
        case 5:
          return TRAFFIC_PERCENT_STRATEGY;
        case 200:
          return DELETE_SERVICE_STRATEGY;
        case 0:
          return STRATEGY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StrategyCase getStrategyCase() {
    return StrategyCase.forNumber(strategyCase_);
  }

  public static final int ROLLOUT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rolloutId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Unique identifier of this Rollout. Must be no longer than 63
   * characters and only lower case letters, digits, '.', '_' and '-' are
   * allowed.
   *
   * If not specified by client, the server will generate one. The generated id
   * will have the form of &lt;date&gt;&lt;revision number&gt;, where "date" is the create
   * date in ISO 8601 format.  "revision number" is a monotonically increasing
   * positive number that is reset every day for each service.
   * An example of the generated rollout_id is '2016-02-16r1'
   * </pre>
   *
   * <code>string rollout_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The rolloutId.
   */
  @java.lang.Override
  public java.lang.String getRolloutId() {
    java.lang.Object ref = rolloutId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rolloutId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Unique identifier of this Rollout. Must be no longer than 63
   * characters and only lower case letters, digits, '.', '_' and '-' are
   * allowed.
   *
   * If not specified by client, the server will generate one. The generated id
   * will have the form of &lt;date&gt;&lt;revision number&gt;, where "date" is the create
   * date in ISO 8601 format.  "revision number" is a monotonically increasing
   * positive number that is reset every day for each service.
   * An example of the generated rollout_id is '2016-02-16r1'
   * </pre>
   *
   * <code>string rollout_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for rolloutId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRolloutIdBytes() {
    java.lang.Object ref = rolloutId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rolloutId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Creation time of the rollout. Readonly.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Creation time of the rollout. Readonly.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Creation time of the rollout. Readonly.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int CREATED_BY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object createdBy_ = "";
  /**
   *
   *
   * <pre>
   * The user who created the Rollout. Readonly.
   * </pre>
   *
   * <code>string created_by = 3;</code>
   *
   * @return The createdBy.
   */
  @java.lang.Override
  public java.lang.String getCreatedBy() {
    java.lang.Object ref = createdBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      createdBy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The user who created the Rollout. Readonly.
   * </pre>
   *
   * <code>string created_by = 3;</code>
   *
   * @return The bytes for createdBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreatedByBytes() {
    java.lang.Object ref = createdBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      createdBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * The status of this rollout. Readonly. In case of a failed rollout,
   * the system will automatically rollback to the current Rollout
   * version. Readonly.
   * </pre>
   *
   * <code>.google.api.servicemanagement.v1.Rollout.RolloutStatus status = 4;</code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * The status of this rollout. Readonly. In case of a failed rollout,
   * the system will automatically rollback to the current Rollout
   * version. Readonly.
   * </pre>
   *
   * <code>.google.api.servicemanagement.v1.Rollout.RolloutStatus status = 4;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.Rollout.RolloutStatus getStatus() {
    com.google.api.servicemanagement.v1.Rollout.RolloutStatus result =
        com.google.api.servicemanagement.v1.Rollout.RolloutStatus.forNumber(status_);
    return result == null
        ? com.google.api.servicemanagement.v1.Rollout.RolloutStatus.UNRECOGNIZED
        : result;
  }

  public static final int TRAFFIC_PERCENT_STRATEGY_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Google Service Control selects service configurations based on
   * traffic percentage.
   * </pre>
   *
   * <code>
   * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
   * </code>
   *
   * @return Whether the trafficPercentStrategy field is set.
   */
  @java.lang.Override
  public boolean hasTrafficPercentStrategy() {
    return strategyCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Google Service Control selects service configurations based on
   * traffic percentage.
   * </pre>
   *
   * <code>
   * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
   * </code>
   *
   * @return The trafficPercentStrategy.
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
      getTrafficPercentStrategy() {
    if (strategyCase_ == 5) {
      return (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) strategy_;
    }
    return com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Google Service Control selects service configurations based on
   * traffic percentage.
   * </pre>
   *
   * <code>
   * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategyOrBuilder
      getTrafficPercentStrategyOrBuilder() {
    if (strategyCase_ == 5) {
      return (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) strategy_;
    }
    return com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.getDefaultInstance();
  }

  public static final int DELETE_SERVICE_STRATEGY_FIELD_NUMBER = 200;
  /**
   *
   *
   * <pre>
   * The strategy associated with a rollout to delete a `ManagedService`.
   * Readonly.
   * </pre>
   *
   * <code>
   * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
   * </code>
   *
   * @return Whether the deleteServiceStrategy field is set.
   */
  @java.lang.Override
  public boolean hasDeleteServiceStrategy() {
    return strategyCase_ == 200;
  }
  /**
   *
   *
   * <pre>
   * The strategy associated with a rollout to delete a `ManagedService`.
   * Readonly.
   * </pre>
   *
   * <code>
   * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
   * </code>
   *
   * @return The deleteServiceStrategy.
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
      getDeleteServiceStrategy() {
    if (strategyCase_ == 200) {
      return (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) strategy_;
    }
    return com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The strategy associated with a rollout to delete a `ManagedService`.
   * Readonly.
   * </pre>
   *
   * <code>
   * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
   * </code>
   */
  @java.lang.Override
  public com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategyOrBuilder
      getDeleteServiceStrategyOrBuilder() {
    if (strategyCase_ == 200) {
      return (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) strategy_;
    }
    return com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.getDefaultInstance();
  }

  public static final int SERVICE_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the service associated with this Rollout.
   * </pre>
   *
   * <code>string service_name = 8;</code>
   *
   * @return The serviceName.
   */
  @java.lang.Override
  public java.lang.String getServiceName() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the service associated with this Rollout.
   * </pre>
   *
   * <code>string service_name = 8;</code>
   *
   * @return The bytes for serviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceNameBytes() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, rolloutId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(createdBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, createdBy_);
    }
    if (status_
        != com.google.api.servicemanagement.v1.Rollout.RolloutStatus.ROLLOUT_STATUS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, status_);
    }
    if (strategyCase_ == 5) {
      output.writeMessage(
          5, (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) strategy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, serviceName_);
    }
    if (strategyCase_ == 200) {
      output.writeMessage(
          200, (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) strategy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, rolloutId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(createdBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, createdBy_);
    }
    if (status_
        != com.google.api.servicemanagement.v1.Rollout.RolloutStatus.ROLLOUT_STATUS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, status_);
    }
    if (strategyCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) strategy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, serviceName_);
    }
    if (strategyCase_ == 200) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              200, (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) strategy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.servicemanagement.v1.Rollout)) {
      return super.equals(obj);
    }
    com.google.api.servicemanagement.v1.Rollout other =
        (com.google.api.servicemanagement.v1.Rollout) obj;

    if (!getRolloutId().equals(other.getRolloutId())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getCreatedBy().equals(other.getCreatedBy())) return false;
    if (status_ != other.status_) return false;
    if (!getServiceName().equals(other.getServiceName())) return false;
    if (!getStrategyCase().equals(other.getStrategyCase())) return false;
    switch (strategyCase_) {
      case 5:
        if (!getTrafficPercentStrategy().equals(other.getTrafficPercentStrategy())) return false;
        break;
      case 200:
        if (!getDeleteServiceStrategy().equals(other.getDeleteServiceStrategy())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ROLLOUT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRolloutId().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + CREATED_BY_FIELD_NUMBER;
    hash = (53 * hash) + getCreatedBy().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceName().hashCode();
    switch (strategyCase_) {
      case 5:
        hash = (37 * hash) + TRAFFIC_PERCENT_STRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + getTrafficPercentStrategy().hashCode();
        break;
      case 200:
        hash = (37 * hash) + DELETE_SERVICE_STRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteServiceStrategy().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.servicemanagement.v1.Rollout parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.servicemanagement.v1.Rollout prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A rollout resource that defines how service configuration versions are pushed
   * to control plane systems. Typically, you create a new version of the
   * service config, and then create a Rollout to push the service config.
   * </pre>
   *
   * Protobuf type {@code google.api.servicemanagement.v1.Rollout}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.servicemanagement.v1.Rollout)
      com.google.api.servicemanagement.v1.RolloutOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_Rollout_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_Rollout_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.servicemanagement.v1.Rollout.class,
              com.google.api.servicemanagement.v1.Rollout.Builder.class);
    }

    // Construct using com.google.api.servicemanagement.v1.Rollout.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      rolloutId_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      createdBy_ = "";
      status_ = 0;
      if (trafficPercentStrategyBuilder_ != null) {
        trafficPercentStrategyBuilder_.clear();
      }
      if (deleteServiceStrategyBuilder_ != null) {
        deleteServiceStrategyBuilder_.clear();
      }
      serviceName_ = "";
      strategyCase_ = 0;
      strategy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.servicemanagement.v1.ResourcesProto
          .internal_static_google_api_servicemanagement_v1_Rollout_descriptor;
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout getDefaultInstanceForType() {
      return com.google.api.servicemanagement.v1.Rollout.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout build() {
      com.google.api.servicemanagement.v1.Rollout result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout buildPartial() {
      com.google.api.servicemanagement.v1.Rollout result =
          new com.google.api.servicemanagement.v1.Rollout(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.api.servicemanagement.v1.Rollout result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.rolloutId_ = rolloutId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createdBy_ = createdBy_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.serviceName_ = serviceName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.api.servicemanagement.v1.Rollout result) {
      result.strategyCase_ = strategyCase_;
      result.strategy_ = this.strategy_;
      if (strategyCase_ == 5 && trafficPercentStrategyBuilder_ != null) {
        result.strategy_ = trafficPercentStrategyBuilder_.build();
      }
      if (strategyCase_ == 200 && deleteServiceStrategyBuilder_ != null) {
        result.strategy_ = deleteServiceStrategyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.servicemanagement.v1.Rollout) {
        return mergeFrom((com.google.api.servicemanagement.v1.Rollout) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.servicemanagement.v1.Rollout other) {
      if (other == com.google.api.servicemanagement.v1.Rollout.getDefaultInstance()) return this;
      if (!other.getRolloutId().isEmpty()) {
        rolloutId_ = other.rolloutId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getCreatedBy().isEmpty()) {
        createdBy_ = other.createdBy_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getServiceName().isEmpty()) {
        serviceName_ = other.serviceName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      switch (other.getStrategyCase()) {
        case TRAFFIC_PERCENT_STRATEGY:
          {
            mergeTrafficPercentStrategy(other.getTrafficPercentStrategy());
            break;
          }
        case DELETE_SERVICE_STRATEGY:
          {
            mergeDeleteServiceStrategy(other.getDeleteServiceStrategy());
            break;
          }
        case STRATEGY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                rolloutId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                createdBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getTrafficPercentStrategyFieldBuilder().getBuilder(), extensionRegistry);
                strategyCase_ = 5;
                break;
              } // case 42
            case 66:
              {
                serviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 1602:
              {
                input.readMessage(
                    getDeleteServiceStrategyFieldBuilder().getBuilder(), extensionRegistry);
                strategyCase_ = 200;
                break;
              } // case 1602
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int strategyCase_ = 0;
    private java.lang.Object strategy_;

    public StrategyCase getStrategyCase() {
      return StrategyCase.forNumber(strategyCase_);
    }

    public Builder clearStrategy() {
      strategyCase_ = 0;
      strategy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object rolloutId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Unique identifier of this Rollout. Must be no longer than 63
     * characters and only lower case letters, digits, '.', '_' and '-' are
     * allowed.
     *
     * If not specified by client, the server will generate one. The generated id
     * will have the form of &lt;date&gt;&lt;revision number&gt;, where "date" is the create
     * date in ISO 8601 format.  "revision number" is a monotonically increasing
     * positive number that is reset every day for each service.
     * An example of the generated rollout_id is '2016-02-16r1'
     * </pre>
     *
     * <code>string rollout_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The rolloutId.
     */
    public java.lang.String getRolloutId() {
      java.lang.Object ref = rolloutId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rolloutId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Unique identifier of this Rollout. Must be no longer than 63
     * characters and only lower case letters, digits, '.', '_' and '-' are
     * allowed.
     *
     * If not specified by client, the server will generate one. The generated id
     * will have the form of &lt;date&gt;&lt;revision number&gt;, where "date" is the create
     * date in ISO 8601 format.  "revision number" is a monotonically increasing
     * positive number that is reset every day for each service.
     * An example of the generated rollout_id is '2016-02-16r1'
     * </pre>
     *
     * <code>string rollout_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for rolloutId.
     */
    public com.google.protobuf.ByteString getRolloutIdBytes() {
      java.lang.Object ref = rolloutId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rolloutId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Unique identifier of this Rollout. Must be no longer than 63
     * characters and only lower case letters, digits, '.', '_' and '-' are
     * allowed.
     *
     * If not specified by client, the server will generate one. The generated id
     * will have the form of &lt;date&gt;&lt;revision number&gt;, where "date" is the create
     * date in ISO 8601 format.  "revision number" is a monotonically increasing
     * positive number that is reset every day for each service.
     * An example of the generated rollout_id is '2016-02-16r1'
     * </pre>
     *
     * <code>string rollout_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The rolloutId to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rolloutId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unique identifier of this Rollout. Must be no longer than 63
     * characters and only lower case letters, digits, '.', '_' and '-' are
     * allowed.
     *
     * If not specified by client, the server will generate one. The generated id
     * will have the form of &lt;date&gt;&lt;revision number&gt;, where "date" is the create
     * date in ISO 8601 format.  "revision number" is a monotonically increasing
     * positive number that is reset every day for each service.
     * An example of the generated rollout_id is '2016-02-16r1'
     * </pre>
     *
     * <code>string rollout_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutId() {
      rolloutId_ = getDefaultInstance().getRolloutId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unique identifier of this Rollout. Must be no longer than 63
     * characters and only lower case letters, digits, '.', '_' and '-' are
     * allowed.
     *
     * If not specified by client, the server will generate one. The generated id
     * will have the form of &lt;date&gt;&lt;revision number&gt;, where "date" is the create
     * date in ISO 8601 format.  "revision number" is a monotonically increasing
     * positive number that is reset every day for each service.
     * An example of the generated rollout_id is '2016-02-16r1'
     * </pre>
     *
     * <code>string rollout_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for rolloutId to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rolloutId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Creation time of the rollout. Readonly.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Creation time of the rollout. Readonly.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Creation time of the rollout. Readonly.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creation time of the rollout. Readonly.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creation time of the rollout. Readonly.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creation time of the rollout. Readonly.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creation time of the rollout. Readonly.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Creation time of the rollout. Readonly.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Creation time of the rollout. Readonly.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object createdBy_ = "";
    /**
     *
     *
     * <pre>
     * The user who created the Rollout. Readonly.
     * </pre>
     *
     * <code>string created_by = 3;</code>
     *
     * @return The createdBy.
     */
    public java.lang.String getCreatedBy() {
      java.lang.Object ref = createdBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        createdBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user who created the Rollout. Readonly.
     * </pre>
     *
     * <code>string created_by = 3;</code>
     *
     * @return The bytes for createdBy.
     */
    public com.google.protobuf.ByteString getCreatedByBytes() {
      java.lang.Object ref = createdBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        createdBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user who created the Rollout. Readonly.
     * </pre>
     *
     * <code>string created_by = 3;</code>
     *
     * @param value The createdBy to set.
     * @return This builder for chaining.
     */
    public Builder setCreatedBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      createdBy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user who created the Rollout. Readonly.
     * </pre>
     *
     * <code>string created_by = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreatedBy() {
      createdBy_ = getDefaultInstance().getCreatedBy();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user who created the Rollout. Readonly.
     * </pre>
     *
     * <code>string created_by = 3;</code>
     *
     * @param value The bytes for createdBy to set.
     * @return This builder for chaining.
     */
    public Builder setCreatedByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      createdBy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * The status of this rollout. Readonly. In case of a failed rollout,
     * the system will automatically rollback to the current Rollout
     * version. Readonly.
     * </pre>
     *
     * <code>.google.api.servicemanagement.v1.Rollout.RolloutStatus status = 4;</code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * The status of this rollout. Readonly. In case of a failed rollout,
     * the system will automatically rollback to the current Rollout
     * version. Readonly.
     * </pre>
     *
     * <code>.google.api.servicemanagement.v1.Rollout.RolloutStatus status = 4;</code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of this rollout. Readonly. In case of a failed rollout,
     * the system will automatically rollback to the current Rollout
     * version. Readonly.
     * </pre>
     *
     * <code>.google.api.servicemanagement.v1.Rollout.RolloutStatus status = 4;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout.RolloutStatus getStatus() {
      com.google.api.servicemanagement.v1.Rollout.RolloutStatus result =
          com.google.api.servicemanagement.v1.Rollout.RolloutStatus.forNumber(status_);
      return result == null
          ? com.google.api.servicemanagement.v1.Rollout.RolloutStatus.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The status of this rollout. Readonly. In case of a failed rollout,
     * the system will automatically rollback to the current Rollout
     * version. Readonly.
     * </pre>
     *
     * <code>.google.api.servicemanagement.v1.Rollout.RolloutStatus status = 4;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.api.servicemanagement.v1.Rollout.RolloutStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of this rollout. Readonly. In case of a failed rollout,
     * the system will automatically rollback to the current Rollout
     * version. Readonly.
     * </pre>
     *
     * <code>.google.api.servicemanagement.v1.Rollout.RolloutStatus status = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      status_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy,
            com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.Builder,
            com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategyOrBuilder>
        trafficPercentStrategyBuilder_;
    /**
     *
     *
     * <pre>
     * Google Service Control selects service configurations based on
     * traffic percentage.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
     * </code>
     *
     * @return Whether the trafficPercentStrategy field is set.
     */
    @java.lang.Override
    public boolean hasTrafficPercentStrategy() {
      return strategyCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Google Service Control selects service configurations based on
     * traffic percentage.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
     * </code>
     *
     * @return The trafficPercentStrategy.
     */
    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
        getTrafficPercentStrategy() {
      if (trafficPercentStrategyBuilder_ == null) {
        if (strategyCase_ == 5) {
          return (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) strategy_;
        }
        return com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
            .getDefaultInstance();
      } else {
        if (strategyCase_ == 5) {
          return trafficPercentStrategyBuilder_.getMessage();
        }
        return com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Service Control selects service configurations based on
     * traffic percentage.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
     * </code>
     */
    public Builder setTrafficPercentStrategy(
        com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy value) {
      if (trafficPercentStrategyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        strategy_ = value;
        onChanged();
      } else {
        trafficPercentStrategyBuilder_.setMessage(value);
      }
      strategyCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Service Control selects service configurations based on
     * traffic percentage.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
     * </code>
     */
    public Builder setTrafficPercentStrategy(
        com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.Builder
            builderForValue) {
      if (trafficPercentStrategyBuilder_ == null) {
        strategy_ = builderForValue.build();
        onChanged();
      } else {
        trafficPercentStrategyBuilder_.setMessage(builderForValue.build());
      }
      strategyCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Service Control selects service configurations based on
     * traffic percentage.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
     * </code>
     */
    public Builder mergeTrafficPercentStrategy(
        com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy value) {
      if (trafficPercentStrategyBuilder_ == null) {
        if (strategyCase_ == 5
            && strategy_
                != com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
                    .getDefaultInstance()) {
          strategy_ =
              com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.newBuilder(
                      (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy)
                          strategy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          strategy_ = value;
        }
        onChanged();
      } else {
        if (strategyCase_ == 5) {
          trafficPercentStrategyBuilder_.mergeFrom(value);
        } else {
          trafficPercentStrategyBuilder_.setMessage(value);
        }
      }
      strategyCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Service Control selects service configurations based on
     * traffic percentage.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
     * </code>
     */
    public Builder clearTrafficPercentStrategy() {
      if (trafficPercentStrategyBuilder_ == null) {
        if (strategyCase_ == 5) {
          strategyCase_ = 0;
          strategy_ = null;
          onChanged();
        }
      } else {
        if (strategyCase_ == 5) {
          strategyCase_ = 0;
          strategy_ = null;
        }
        trafficPercentStrategyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Service Control selects service configurations based on
     * traffic percentage.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
     * </code>
     */
    public com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.Builder
        getTrafficPercentStrategyBuilder() {
      return getTrafficPercentStrategyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Google Service Control selects service configurations based on
     * traffic percentage.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategyOrBuilder
        getTrafficPercentStrategyOrBuilder() {
      if ((strategyCase_ == 5) && (trafficPercentStrategyBuilder_ != null)) {
        return trafficPercentStrategyBuilder_.getMessageOrBuilder();
      } else {
        if (strategyCase_ == 5) {
          return (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) strategy_;
        }
        return com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Service Control selects service configurations based on
     * traffic percentage.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy traffic_percent_strategy = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy,
            com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.Builder,
            com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategyOrBuilder>
        getTrafficPercentStrategyFieldBuilder() {
      if (trafficPercentStrategyBuilder_ == null) {
        if (!(strategyCase_ == 5)) {
          strategy_ =
              com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
                  .getDefaultInstance();
        }
        trafficPercentStrategyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy,
                com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.Builder,
                com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategyOrBuilder>(
                (com.google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy) strategy_,
                getParentForChildren(),
                isClean());
        strategy_ = null;
      }
      strategyCase_ = 5;
      onChanged();
      return trafficPercentStrategyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy,
            com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.Builder,
            com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategyOrBuilder>
        deleteServiceStrategyBuilder_;
    /**
     *
     *
     * <pre>
     * The strategy associated with a rollout to delete a `ManagedService`.
     * Readonly.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
     * </code>
     *
     * @return Whether the deleteServiceStrategy field is set.
     */
    @java.lang.Override
    public boolean hasDeleteServiceStrategy() {
      return strategyCase_ == 200;
    }
    /**
     *
     *
     * <pre>
     * The strategy associated with a rollout to delete a `ManagedService`.
     * Readonly.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
     * </code>
     *
     * @return The deleteServiceStrategy.
     */
    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
        getDeleteServiceStrategy() {
      if (deleteServiceStrategyBuilder_ == null) {
        if (strategyCase_ == 200) {
          return (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) strategy_;
        }
        return com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
            .getDefaultInstance();
      } else {
        if (strategyCase_ == 200) {
          return deleteServiceStrategyBuilder_.getMessage();
        }
        return com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The strategy associated with a rollout to delete a `ManagedService`.
     * Readonly.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
     * </code>
     */
    public Builder setDeleteServiceStrategy(
        com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy value) {
      if (deleteServiceStrategyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        strategy_ = value;
        onChanged();
      } else {
        deleteServiceStrategyBuilder_.setMessage(value);
      }
      strategyCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The strategy associated with a rollout to delete a `ManagedService`.
     * Readonly.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
     * </code>
     */
    public Builder setDeleteServiceStrategy(
        com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.Builder builderForValue) {
      if (deleteServiceStrategyBuilder_ == null) {
        strategy_ = builderForValue.build();
        onChanged();
      } else {
        deleteServiceStrategyBuilder_.setMessage(builderForValue.build());
      }
      strategyCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The strategy associated with a rollout to delete a `ManagedService`.
     * Readonly.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
     * </code>
     */
    public Builder mergeDeleteServiceStrategy(
        com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy value) {
      if (deleteServiceStrategyBuilder_ == null) {
        if (strategyCase_ == 200
            && strategy_
                != com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
                    .getDefaultInstance()) {
          strategy_ =
              com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.newBuilder(
                      (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) strategy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          strategy_ = value;
        }
        onChanged();
      } else {
        if (strategyCase_ == 200) {
          deleteServiceStrategyBuilder_.mergeFrom(value);
        } else {
          deleteServiceStrategyBuilder_.setMessage(value);
        }
      }
      strategyCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The strategy associated with a rollout to delete a `ManagedService`.
     * Readonly.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
     * </code>
     */
    public Builder clearDeleteServiceStrategy() {
      if (deleteServiceStrategyBuilder_ == null) {
        if (strategyCase_ == 200) {
          strategyCase_ = 0;
          strategy_ = null;
          onChanged();
        }
      } else {
        if (strategyCase_ == 200) {
          strategyCase_ = 0;
          strategy_ = null;
        }
        deleteServiceStrategyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The strategy associated with a rollout to delete a `ManagedService`.
     * Readonly.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
     * </code>
     */
    public com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.Builder
        getDeleteServiceStrategyBuilder() {
      return getDeleteServiceStrategyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The strategy associated with a rollout to delete a `ManagedService`.
     * Readonly.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
     * </code>
     */
    @java.lang.Override
    public com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategyOrBuilder
        getDeleteServiceStrategyOrBuilder() {
      if ((strategyCase_ == 200) && (deleteServiceStrategyBuilder_ != null)) {
        return deleteServiceStrategyBuilder_.getMessageOrBuilder();
      } else {
        if (strategyCase_ == 200) {
          return (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) strategy_;
        }
        return com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The strategy associated with a rollout to delete a `ManagedService`.
     * Readonly.
     * </pre>
     *
     * <code>
     * .google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy delete_service_strategy = 200;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy,
            com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.Builder,
            com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategyOrBuilder>
        getDeleteServiceStrategyFieldBuilder() {
      if (deleteServiceStrategyBuilder_ == null) {
        if (!(strategyCase_ == 200)) {
          strategy_ =
              com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
                  .getDefaultInstance();
        }
        deleteServiceStrategyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy,
                com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy.Builder,
                com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategyOrBuilder>(
                (com.google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy) strategy_,
                getParentForChildren(),
                isClean());
        strategy_ = null;
      }
      strategyCase_ = 200;
      onChanged();
      return deleteServiceStrategyBuilder_;
    }

    private java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the service associated with this Rollout.
     * </pre>
     *
     * <code>string service_name = 8;</code>
     *
     * @return The serviceName.
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the service associated with this Rollout.
     * </pre>
     *
     * <code>string service_name = 8;</code>
     *
     * @return The bytes for serviceName.
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the service associated with this Rollout.
     * </pre>
     *
     * <code>string service_name = 8;</code>
     *
     * @param value The serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the service associated with this Rollout.
     * </pre>
     *
     * <code>string service_name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceName() {
      serviceName_ = getDefaultInstance().getServiceName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the service associated with this Rollout.
     * </pre>
     *
     * <code>string service_name = 8;</code>
     *
     * @param value The bytes for serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.servicemanagement.v1.Rollout)
  }

  // @@protoc_insertion_point(class_scope:google.api.servicemanagement.v1.Rollout)
  private static final com.google.api.servicemanagement.v1.Rollout DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.servicemanagement.v1.Rollout();
  }

  public static com.google.api.servicemanagement.v1.Rollout getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Rollout> PARSER =
      new com.google.protobuf.AbstractParser<Rollout>() {
        @java.lang.Override
        public Rollout parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Rollout> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Rollout> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.servicemanagement.v1.Rollout getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
