/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.admin.database.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BackupName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/backups/{backup}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String backup;

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getBackup() {
        return this.backup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BackupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.backup = (String)Preconditions.checkNotNull((Object)builder.getBackup());
    }

    public static BackupName of(String project, String instance, String backup) {
        return BackupName.newBuilder().setProject(project).setInstance(instance).setBackup(backup).build();
    }

    public static String format(String project, String instance, String backup) {
        return BackupName.newBuilder().setProject(project).setInstance(instance).setBackup(backup).build().toString();
    }

    public static BackupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BackupName.parse: formattedString not in valid format");
        return BackupName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("backup"));
    }

    public static List<BackupName> parseList(List<String> formattedStrings) {
        ArrayList<BackupName> list = new ArrayList<BackupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupName backupName = this;
            synchronized (backupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    fieldMapBuilder.put((Object)"backup", (Object)this.backup);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance", this.instance, "backup", this.backup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackupName) {
            BackupName that = (BackupName)o;
            return this.project.equals(that.project) && this.instance.equals(that.instance) && this.backup.equals(that.backup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.instance.hashCode();
        h *= 1000003;
        return h ^= this.backup.hashCode();
    }

    public static class Builder {
        private String project;
        private String instance;
        private String backup;

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getBackup() {
            return this.backup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setBackup(String backup) {
            this.backup = backup;
            return this;
        }

        private Builder() {
        }

        private Builder(BackupName backupName) {
            this.project = backupName.project;
            this.instance = backupName.instance;
            this.backup = backupName.backup;
        }

        public BackupName build() {
            return new BackupName(this);
        }
    }
}

