/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * A Cloud Spanner database.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.Database}
 */
public final class Database extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.Database)
    DatabaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Database.newBuilder() to construct.
  private Database(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Database() {
    name_ = "";
    state_ = 0;
    versionRetentionPeriod_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Database();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Database(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 26:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.spanner.admin.database.v1.RestoreInfo.Builder subBuilder = null;
              if (restoreInfo_ != null) {
                subBuilder = restoreInfo_.toBuilder();
              }
              restoreInfo_ =
                  input.readMessage(
                      com.google.spanner.admin.database.v1.RestoreInfo.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(restoreInfo_);
                restoreInfo_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              versionRetentionPeriod_ = s;
              break;
            }
          case 58:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (earliestVersionTime_ != null) {
                subBuilder = earliestVersionTime_.toBuilder();
              }
              earliestVersionTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(earliestVersionTime_);
                earliestVersionTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_Database_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_Database_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.Database.class,
            com.google.spanner.admin.database.v1.Database.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the current state of the database.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.admin.database.v1.Database.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The database is still being created. Operations on the database may fail
     * with `FAILED_PRECONDITION` in this state.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The database is fully created and ready for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * The database is fully created and ready for use, but is still
     * being optimized for performance and cannot handle full load.
     * In this state, the database still references the backup
     * it was restore from, preventing the backup
     * from being deleted. When optimizations are complete, the full performance
     * of the database will be restored, and the database will transition to
     * `READY` state.
     * </pre>
     *
     * <code>READY_OPTIMIZING = 3;</code>
     */
    READY_OPTIMIZING(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The database is still being created. Operations on the database may fail
     * with `FAILED_PRECONDITION` in this state.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The database is fully created and ready for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The database is fully created and ready for use, but is still
     * being optimized for performance and cannot handle full load.
     * In this state, the database still references the backup
     * it was restore from, preventing the backup
     * from being deleted. When optimizations are complete, the full performance
     * of the database will be restored, and the database will transition to
     * `READY` state.
     * </pre>
     *
     * <code>READY_OPTIMIZING = 3;</code>
     */
    public static final int READY_OPTIMIZING_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        case 3:
          return READY_OPTIMIZING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.Database.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.admin.database.v1.Database.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The name of the database. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
   * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
   * statement. This name can be passed to other API methods to
   * identify the database.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the database. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
   * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
   * statement. This name can be passed to other API methods to
   * identify the database.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current database state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current database state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.Database.State getState() {
    @SuppressWarnings("deprecation")
    com.google.spanner.admin.database.v1.Database.State result =
        com.google.spanner.admin.database.v1.Database.State.valueOf(state_);
    return result == null
        ? com.google.spanner.admin.database.v1.Database.State.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. If exists, the time at which the database creation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. If exists, the time at which the database creation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If exists, the time at which the database creation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int RESTORE_INFO_FIELD_NUMBER = 4;
  private com.google.spanner.admin.database.v1.RestoreInfo restoreInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Applicable only for restored databases. Contains information
   * about the restore source.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the restoreInfo field is set.
   */
  @java.lang.Override
  public boolean hasRestoreInfo() {
    return restoreInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Applicable only for restored databases. Contains information
   * about the restore source.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The restoreInfo.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.RestoreInfo getRestoreInfo() {
    return restoreInfo_ == null
        ? com.google.spanner.admin.database.v1.RestoreInfo.getDefaultInstance()
        : restoreInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Applicable only for restored databases. Contains information
   * about the restore source.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.RestoreInfoOrBuilder getRestoreInfoOrBuilder() {
    return getRestoreInfo();
  }

  public static final int VERSION_RETENTION_PERIOD_FIELD_NUMBER = 6;
  private volatile java.lang.Object versionRetentionPeriod_;
  /**
   *
   *
   * <pre>
   * Output only. The period in which Cloud Spanner retains all versions of data
   * for the database. This is the same as the value of version_retention_period
   * database option set using
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]. Defaults to 1 hour,
   * if not set.
   * </pre>
   *
   * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The versionRetentionPeriod.
   */
  @java.lang.Override
  public java.lang.String getVersionRetentionPeriod() {
    java.lang.Object ref = versionRetentionPeriod_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionRetentionPeriod_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The period in which Cloud Spanner retains all versions of data
   * for the database. This is the same as the value of version_retention_period
   * database option set using
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]. Defaults to 1 hour,
   * if not set.
   * </pre>
   *
   * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for versionRetentionPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionRetentionPeriodBytes() {
    java.lang.Object ref = versionRetentionPeriod_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionRetentionPeriod_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EARLIEST_VERSION_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp earliestVersionTime_;
  /**
   *
   *
   * <pre>
   * Output only. Earliest timestamp at which older versions of the data can be
   * read.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the earliestVersionTime field is set.
   */
  @java.lang.Override
  public boolean hasEarliestVersionTime() {
    return earliestVersionTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Earliest timestamp at which older versions of the data can be
   * read.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The earliestVersionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEarliestVersionTime() {
    return earliestVersionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : earliestVersionTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Earliest timestamp at which older versions of the data can be
   * read.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
    return getEarliestVersionTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_
        != com.google.spanner.admin.database.v1.Database.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (restoreInfo_ != null) {
      output.writeMessage(4, getRestoreInfo());
    }
    if (!getVersionRetentionPeriodBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, versionRetentionPeriod_);
    }
    if (earliestVersionTime_ != null) {
      output.writeMessage(7, getEarliestVersionTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_
        != com.google.spanner.admin.database.v1.Database.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (restoreInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRestoreInfo());
    }
    if (!getVersionRetentionPeriodBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, versionRetentionPeriod_);
    }
    if (earliestVersionTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEarliestVersionTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.Database)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.Database other =
        (com.google.spanner.admin.database.v1.Database) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasRestoreInfo() != other.hasRestoreInfo()) return false;
    if (hasRestoreInfo()) {
      if (!getRestoreInfo().equals(other.getRestoreInfo())) return false;
    }
    if (!getVersionRetentionPeriod().equals(other.getVersionRetentionPeriod())) return false;
    if (hasEarliestVersionTime() != other.hasEarliestVersionTime()) return false;
    if (hasEarliestVersionTime()) {
      if (!getEarliestVersionTime().equals(other.getEarliestVersionTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasRestoreInfo()) {
      hash = (37 * hash) + RESTORE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getRestoreInfo().hashCode();
    }
    hash = (37 * hash) + VERSION_RETENTION_PERIOD_FIELD_NUMBER;
    hash = (53 * hash) + getVersionRetentionPeriod().hashCode();
    if (hasEarliestVersionTime()) {
      hash = (37 * hash) + EARLIEST_VERSION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEarliestVersionTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.Database parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.admin.database.v1.Database prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Cloud Spanner database.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.Database}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.Database)
      com.google.spanner.admin.database.v1.DatabaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_Database_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_Database_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.Database.class,
              com.google.spanner.admin.database.v1.Database.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.Database.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      state_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (restoreInfoBuilder_ == null) {
        restoreInfo_ = null;
      } else {
        restoreInfo_ = null;
        restoreInfoBuilder_ = null;
      }
      versionRetentionPeriod_ = "";

      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTime_ = null;
      } else {
        earliestVersionTime_ = null;
        earliestVersionTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_Database_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.Database getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.Database.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.Database build() {
      com.google.spanner.admin.database.v1.Database result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.Database buildPartial() {
      com.google.spanner.admin.database.v1.Database result =
          new com.google.spanner.admin.database.v1.Database(this);
      result.name_ = name_;
      result.state_ = state_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (restoreInfoBuilder_ == null) {
        result.restoreInfo_ = restoreInfo_;
      } else {
        result.restoreInfo_ = restoreInfoBuilder_.build();
      }
      result.versionRetentionPeriod_ = versionRetentionPeriod_;
      if (earliestVersionTimeBuilder_ == null) {
        result.earliestVersionTime_ = earliestVersionTime_;
      } else {
        result.earliestVersionTime_ = earliestVersionTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.Database) {
        return mergeFrom((com.google.spanner.admin.database.v1.Database) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.Database other) {
      if (other == com.google.spanner.admin.database.v1.Database.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasRestoreInfo()) {
        mergeRestoreInfo(other.getRestoreInfo());
      }
      if (!other.getVersionRetentionPeriod().isEmpty()) {
        versionRetentionPeriod_ = other.versionRetentionPeriod_;
        onChanged();
      }
      if (other.hasEarliestVersionTime()) {
        mergeEarliestVersionTime(other.getEarliestVersionTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.spanner.admin.database.v1.Database parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.spanner.admin.database.v1.Database) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.Database.State getState() {
      @SuppressWarnings("deprecation")
      com.google.spanner.admin.database.v1.Database.State result =
          com.google.spanner.admin.database.v1.Database.State.valueOf(state_);
      return result == null
          ? com.google.spanner.admin.database.v1.Database.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.spanner.admin.database.v1.Database.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.spanner.admin.database.v1.RestoreInfo restoreInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.RestoreInfo,
            com.google.spanner.admin.database.v1.RestoreInfo.Builder,
            com.google.spanner.admin.database.v1.RestoreInfoOrBuilder>
        restoreInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the restoreInfo field is set.
     */
    public boolean hasRestoreInfo() {
      return restoreInfoBuilder_ != null || restoreInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The restoreInfo.
     */
    public com.google.spanner.admin.database.v1.RestoreInfo getRestoreInfo() {
      if (restoreInfoBuilder_ == null) {
        return restoreInfo_ == null
            ? com.google.spanner.admin.database.v1.RestoreInfo.getDefaultInstance()
            : restoreInfo_;
      } else {
        return restoreInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRestoreInfo(com.google.spanner.admin.database.v1.RestoreInfo value) {
      if (restoreInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        restoreInfo_ = value;
        onChanged();
      } else {
        restoreInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRestoreInfo(
        com.google.spanner.admin.database.v1.RestoreInfo.Builder builderForValue) {
      if (restoreInfoBuilder_ == null) {
        restoreInfo_ = builderForValue.build();
        onChanged();
      } else {
        restoreInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRestoreInfo(com.google.spanner.admin.database.v1.RestoreInfo value) {
      if (restoreInfoBuilder_ == null) {
        if (restoreInfo_ != null) {
          restoreInfo_ =
              com.google.spanner.admin.database.v1.RestoreInfo.newBuilder(restoreInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          restoreInfo_ = value;
        }
        onChanged();
      } else {
        restoreInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRestoreInfo() {
      if (restoreInfoBuilder_ == null) {
        restoreInfo_ = null;
        onChanged();
      } else {
        restoreInfo_ = null;
        restoreInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.RestoreInfo.Builder getRestoreInfoBuilder() {

      onChanged();
      return getRestoreInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.RestoreInfoOrBuilder getRestoreInfoOrBuilder() {
      if (restoreInfoBuilder_ != null) {
        return restoreInfoBuilder_.getMessageOrBuilder();
      } else {
        return restoreInfo_ == null
            ? com.google.spanner.admin.database.v1.RestoreInfo.getDefaultInstance()
            : restoreInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.RestoreInfo,
            com.google.spanner.admin.database.v1.RestoreInfo.Builder,
            com.google.spanner.admin.database.v1.RestoreInfoOrBuilder>
        getRestoreInfoFieldBuilder() {
      if (restoreInfoBuilder_ == null) {
        restoreInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.RestoreInfo,
                com.google.spanner.admin.database.v1.RestoreInfo.Builder,
                com.google.spanner.admin.database.v1.RestoreInfoOrBuilder>(
                getRestoreInfo(), getParentForChildren(), isClean());
        restoreInfo_ = null;
      }
      return restoreInfoBuilder_;
    }

    private java.lang.Object versionRetentionPeriod_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]. Defaults to 1 hour,
     * if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionRetentionPeriod.
     */
    public java.lang.String getVersionRetentionPeriod() {
      java.lang.Object ref = versionRetentionPeriod_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionRetentionPeriod_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]. Defaults to 1 hour,
     * if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for versionRetentionPeriod.
     */
    public com.google.protobuf.ByteString getVersionRetentionPeriodBytes() {
      java.lang.Object ref = versionRetentionPeriod_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionRetentionPeriod_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]. Defaults to 1 hour,
     * if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The versionRetentionPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setVersionRetentionPeriod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      versionRetentionPeriod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]. Defaults to 1 hour,
     * if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionRetentionPeriod() {

      versionRetentionPeriod_ = getDefaultInstance().getVersionRetentionPeriod();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]. Defaults to 1 hour,
     * if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for versionRetentionPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setVersionRetentionPeriodBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      versionRetentionPeriod_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp earliestVersionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        earliestVersionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the earliestVersionTime field is set.
     */
    public boolean hasEarliestVersionTime() {
      return earliestVersionTimeBuilder_ != null || earliestVersionTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The earliestVersionTime.
     */
    public com.google.protobuf.Timestamp getEarliestVersionTime() {
      if (earliestVersionTimeBuilder_ == null) {
        return earliestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestVersionTime_;
      } else {
        return earliestVersionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestVersionTime(com.google.protobuf.Timestamp value) {
      if (earliestVersionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        earliestVersionTime_ = value;
        onChanged();
      } else {
        earliestVersionTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestVersionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTime_ = builderForValue.build();
        onChanged();
      } else {
        earliestVersionTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEarliestVersionTime(com.google.protobuf.Timestamp value) {
      if (earliestVersionTimeBuilder_ == null) {
        if (earliestVersionTime_ != null) {
          earliestVersionTime_ =
              com.google.protobuf.Timestamp.newBuilder(earliestVersionTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          earliestVersionTime_ = value;
        }
        onChanged();
      } else {
        earliestVersionTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEarliestVersionTime() {
      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTime_ = null;
        onChanged();
      } else {
        earliestVersionTime_ = null;
        earliestVersionTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEarliestVersionTimeBuilder() {

      onChanged();
      return getEarliestVersionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
      if (earliestVersionTimeBuilder_ != null) {
        return earliestVersionTimeBuilder_.getMessageOrBuilder();
      } else {
        return earliestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestVersionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEarliestVersionTimeFieldBuilder() {
      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEarliestVersionTime(), getParentForChildren(), isClean());
        earliestVersionTime_ = null;
      }
      return earliestVersionTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.Database)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.Database)
  private static final com.google.spanner.admin.database.v1.Database DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.Database();
  }

  public static com.google.spanner.admin.database.v1.Database getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Database> PARSER =
      new com.google.protobuf.AbstractParser<Database>() {
        @java.lang.Override
        public Database parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Database(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Database> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Database> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.Database getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
