/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/backup.proto

// Protobuf Java Version: 3.25.2
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * Information about a backup.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.BackupInfo}
 */
public final class BackupInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.BackupInfo)
    BackupInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackupInfo.newBuilder() to construct.
  private BackupInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackupInfo() {
    backup_ = "";
    sourceDatabase_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackupInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_BackupInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_BackupInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.BackupInfo.class,
            com.google.spanner.admin.database.v1.BackupInfo.Builder.class);
  }

  private int bitField0_;
  public static final int BACKUP_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backup_ = "";
  /**
   *
   *
   * <pre>
   * Name of the backup.
   * </pre>
   *
   * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The backup.
   */
  @java.lang.Override
  public java.lang.String getBackup() {
    java.lang.Object ref = backup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backup_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the backup.
   * </pre>
   *
   * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for backup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackupBytes() {
    java.lang.Object ref = backup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp versionTime_;
  /**
   *
   *
   * <pre>
   * The backup contains an externally consistent copy of `source_database` at
   * the timestamp specified by `version_time`. If the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
   * `version_time`, the `version_time` of the backup is equivalent to the
   * `create_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp version_time = 4;</code>
   *
   * @return Whether the versionTime field is set.
   */
  @java.lang.Override
  public boolean hasVersionTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The backup contains an externally consistent copy of `source_database` at
   * the timestamp specified by `version_time`. If the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
   * `version_time`, the `version_time` of the backup is equivalent to the
   * `create_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp version_time = 4;</code>
   *
   * @return The versionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getVersionTime() {
    return versionTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : versionTime_;
  }
  /**
   *
   *
   * <pre>
   * The backup contains an externally consistent copy of `source_database` at
   * the timestamp specified by `version_time`. If the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
   * `version_time`, the `version_time` of the backup is equivalent to the
   * `create_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp version_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getVersionTimeOrBuilder() {
    return versionTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : versionTime_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int SOURCE_DATABASE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceDatabase_ = "";
  /**
   *
   *
   * <pre>
   * Name of the database the backup was created from.
   * </pre>
   *
   * <code>string source_database = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The sourceDatabase.
   */
  @java.lang.Override
  public java.lang.String getSourceDatabase() {
    java.lang.Object ref = sourceDatabase_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceDatabase_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the database the backup was created from.
   * </pre>
   *
   * <code>string source_database = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for sourceDatabase.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceDatabaseBytes() {
    java.lang.Object ref = sourceDatabase_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceDatabase_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backup_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, backup_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceDatabase_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceDatabase_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getVersionTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backup_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, backup_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceDatabase_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sourceDatabase_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getVersionTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.BackupInfo)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.BackupInfo other =
        (com.google.spanner.admin.database.v1.BackupInfo) obj;

    if (!getBackup().equals(other.getBackup())) return false;
    if (hasVersionTime() != other.hasVersionTime()) return false;
    if (hasVersionTime()) {
      if (!getVersionTime().equals(other.getVersionTime())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getSourceDatabase().equals(other.getSourceDatabase())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BACKUP_FIELD_NUMBER;
    hash = (53 * hash) + getBackup().hashCode();
    if (hasVersionTime()) {
      hash = (37 * hash) + VERSION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getVersionTime().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + SOURCE_DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getSourceDatabase().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.BackupInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.admin.database.v1.BackupInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about a backup.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.BackupInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.BackupInfo)
      com.google.spanner.admin.database.v1.BackupInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_BackupInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_BackupInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.BackupInfo.class,
              com.google.spanner.admin.database.v1.BackupInfo.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.BackupInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVersionTimeFieldBuilder();
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      backup_ = "";
      versionTime_ = null;
      if (versionTimeBuilder_ != null) {
        versionTimeBuilder_.dispose();
        versionTimeBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      sourceDatabase_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_BackupInfo_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.BackupInfo getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.BackupInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.BackupInfo build() {
      com.google.spanner.admin.database.v1.BackupInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.BackupInfo buildPartial() {
      com.google.spanner.admin.database.v1.BackupInfo result =
          new com.google.spanner.admin.database.v1.BackupInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.BackupInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.backup_ = backup_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.versionTime_ =
            versionTimeBuilder_ == null ? versionTime_ : versionTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sourceDatabase_ = sourceDatabase_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.BackupInfo) {
        return mergeFrom((com.google.spanner.admin.database.v1.BackupInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.BackupInfo other) {
      if (other == com.google.spanner.admin.database.v1.BackupInfo.getDefaultInstance())
        return this;
      if (!other.getBackup().isEmpty()) {
        backup_ = other.backup_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasVersionTime()) {
        mergeVersionTime(other.getVersionTime());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getSourceDatabase().isEmpty()) {
        sourceDatabase_ = other.sourceDatabase_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                backup_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                sourceDatabase_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getVersionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object backup_ = "";
    /**
     *
     *
     * <pre>
     * Name of the backup.
     * </pre>
     *
     * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The backup.
     */
    public java.lang.String getBackup() {
      java.lang.Object ref = backup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the backup.
     * </pre>
     *
     * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for backup.
     */
    public com.google.protobuf.ByteString getBackupBytes() {
      java.lang.Object ref = backup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the backup.
     * </pre>
     *
     * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The backup to set.
     * @return This builder for chaining.
     */
    public Builder setBackup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backup_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the backup.
     * </pre>
     *
     * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackup() {
      backup_ = getDefaultInstance().getBackup();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the backup.
     * </pre>
     *
     * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for backup to set.
     * @return This builder for chaining.
     */
    public Builder setBackupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backup_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp versionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        versionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The backup contains an externally consistent copy of `source_database` at
     * the timestamp specified by `version_time`. If the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
     * `version_time`, the `version_time` of the backup is equivalent to the
     * `create_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 4;</code>
     *
     * @return Whether the versionTime field is set.
     */
    public boolean hasVersionTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The backup contains an externally consistent copy of `source_database` at
     * the timestamp specified by `version_time`. If the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
     * `version_time`, the `version_time` of the backup is equivalent to the
     * `create_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 4;</code>
     *
     * @return The versionTime.
     */
    public com.google.protobuf.Timestamp getVersionTime() {
      if (versionTimeBuilder_ == null) {
        return versionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : versionTime_;
      } else {
        return versionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The backup contains an externally consistent copy of `source_database` at
     * the timestamp specified by `version_time`. If the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
     * `version_time`, the `version_time` of the backup is equivalent to the
     * `create_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 4;</code>
     */
    public Builder setVersionTime(com.google.protobuf.Timestamp value) {
      if (versionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versionTime_ = value;
      } else {
        versionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup contains an externally consistent copy of `source_database` at
     * the timestamp specified by `version_time`. If the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
     * `version_time`, the `version_time` of the backup is equivalent to the
     * `create_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 4;</code>
     */
    public Builder setVersionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (versionTimeBuilder_ == null) {
        versionTime_ = builderForValue.build();
      } else {
        versionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup contains an externally consistent copy of `source_database` at
     * the timestamp specified by `version_time`. If the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
     * `version_time`, the `version_time` of the backup is equivalent to the
     * `create_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 4;</code>
     */
    public Builder mergeVersionTime(com.google.protobuf.Timestamp value) {
      if (versionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && versionTime_ != null
            && versionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getVersionTimeBuilder().mergeFrom(value);
        } else {
          versionTime_ = value;
        }
      } else {
        versionTimeBuilder_.mergeFrom(value);
      }
      if (versionTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup contains an externally consistent copy of `source_database` at
     * the timestamp specified by `version_time`. If the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
     * `version_time`, the `version_time` of the backup is equivalent to the
     * `create_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 4;</code>
     */
    public Builder clearVersionTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      versionTime_ = null;
      if (versionTimeBuilder_ != null) {
        versionTimeBuilder_.dispose();
        versionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup contains an externally consistent copy of `source_database` at
     * the timestamp specified by `version_time`. If the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
     * `version_time`, the `version_time` of the backup is equivalent to the
     * `create_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getVersionTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getVersionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The backup contains an externally consistent copy of `source_database` at
     * the timestamp specified by `version_time`. If the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
     * `version_time`, the `version_time` of the backup is equivalent to the
     * `create_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getVersionTimeOrBuilder() {
      if (versionTimeBuilder_ != null) {
        return versionTimeBuilder_.getMessageOrBuilder();
      } else {
        return versionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : versionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The backup contains an externally consistent copy of `source_database` at
     * the timestamp specified by `version_time`. If the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request did not specify
     * `version_time`, the `version_time` of the backup is equivalent to the
     * `create_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getVersionTimeFieldBuilder() {
      if (versionTimeBuilder_ == null) {
        versionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getVersionTime(), getParentForChildren(), isClean());
        versionTime_ = null;
      }
      return versionTimeBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object sourceDatabase_ = "";
    /**
     *
     *
     * <pre>
     * Name of the database the backup was created from.
     * </pre>
     *
     * <code>string source_database = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The sourceDatabase.
     */
    public java.lang.String getSourceDatabase() {
      java.lang.Object ref = sourceDatabase_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceDatabase_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the database the backup was created from.
     * </pre>
     *
     * <code>string source_database = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for sourceDatabase.
     */
    public com.google.protobuf.ByteString getSourceDatabaseBytes() {
      java.lang.Object ref = sourceDatabase_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceDatabase_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the database the backup was created from.
     * </pre>
     *
     * <code>string source_database = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The sourceDatabase to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceDatabase_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the database the backup was created from.
     * </pre>
     *
     * <code>string source_database = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceDatabase() {
      sourceDatabase_ = getDefaultInstance().getSourceDatabase();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the database the backup was created from.
     * </pre>
     *
     * <code>string source_database = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for sourceDatabase to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceDatabase_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.BackupInfo)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.BackupInfo)
  private static final com.google.spanner.admin.database.v1.BackupInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.BackupInfo();
  }

  public static com.google.spanner.admin.database.v1.BackupInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackupInfo> PARSER =
      new com.google.protobuf.AbstractParser<BackupInfo>() {
        @java.lang.Override
        public BackupInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackupInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackupInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.BackupInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
