/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

// Protobuf Java Version: 3.25.2
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * Enqueues the given DDL statements to be applied, in order but not
 * necessarily all at once, to the database schema at some point (or
 * points) in the future. The server checks that the statements
 * are executable (syntactically valid, name tables that exist, etc.)
 * before enqueueing them, but they may still fail upon
 * later execution (e.g., if a statement from another batch of
 * statements is applied first and it conflicts in some way, or if
 * there is some data-related problem like a `NULL` value in a column to
 * which `NOT NULL` would be added). If a statement fails, all
 * subsequent statements in the batch are automatically cancelled.
 *
 * Each batch of statements is assigned a name which can be used with
 * the [Operations][google.longrunning.Operations] API to monitor
 * progress. See the
 * [operation_id][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.operation_id] field for more
 * details.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.UpdateDatabaseDdlRequest}
 */
public final class UpdateDatabaseDdlRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.UpdateDatabaseDdlRequest)
    UpdateDatabaseDdlRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateDatabaseDdlRequest.newBuilder() to construct.
  private UpdateDatabaseDdlRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateDatabaseDdlRequest() {
    database_ = "";
    statements_ = com.google.protobuf.LazyStringArrayList.emptyList();
    operationId_ = "";
    protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateDatabaseDdlRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.class,
            com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.Builder.class);
  }

  public static final int DATABASE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";
  /**
   *
   *
   * <pre>
   * Required. The database to update.
   * </pre>
   *
   * <code>
   * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The database to update.
   * </pre>
   *
   * <code>
   * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATEMENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList statements_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. DDL statements to be applied to the database.
   * </pre>
   *
   * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the statements.
   */
  public com.google.protobuf.ProtocolStringList getStatementsList() {
    return statements_;
  }
  /**
   *
   *
   * <pre>
   * Required. DDL statements to be applied to the database.
   * </pre>
   *
   * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of statements.
   */
  public int getStatementsCount() {
    return statements_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. DDL statements to be applied to the database.
   * </pre>
   *
   * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The statements at the given index.
   */
  public java.lang.String getStatements(int index) {
    return statements_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. DDL statements to be applied to the database.
   * </pre>
   *
   * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the statements at the given index.
   */
  public com.google.protobuf.ByteString getStatementsBytes(int index) {
    return statements_.getByteString(index);
  }

  public static final int OPERATION_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operationId_ = "";
  /**
   *
   *
   * <pre>
   * If empty, the new update request is assigned an
   * automatically-generated operation ID. Otherwise, `operation_id`
   * is used to construct the name of the resulting
   * [Operation][google.longrunning.Operation].
   *
   * Specifying an explicit operation ID simplifies determining
   * whether the statements were executed in the event that the
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] call is replayed,
   * or the return value is otherwise lost: the [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database] and
   * `operation_id` fields can be combined to form the
   * [name][google.longrunning.Operation.name] of the resulting
   * [longrunning.Operation][google.longrunning.Operation]: `&lt;database&gt;/operations/&lt;operation_id&gt;`.
   *
   * `operation_id` should be unique within the database, and must be
   * a valid identifier: `[a-z][a-z0-9_]*`. Note that
   * automatically-generated operation IDs always begin with an
   * underscore. If the named operation already exists,
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] returns
   * `ALREADY_EXISTS`.
   * </pre>
   *
   * <code>string operation_id = 3;</code>
   *
   * @return The operationId.
   */
  @java.lang.Override
  public java.lang.String getOperationId() {
    java.lang.Object ref = operationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If empty, the new update request is assigned an
   * automatically-generated operation ID. Otherwise, `operation_id`
   * is used to construct the name of the resulting
   * [Operation][google.longrunning.Operation].
   *
   * Specifying an explicit operation ID simplifies determining
   * whether the statements were executed in the event that the
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] call is replayed,
   * or the return value is otherwise lost: the [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database] and
   * `operation_id` fields can be combined to form the
   * [name][google.longrunning.Operation.name] of the resulting
   * [longrunning.Operation][google.longrunning.Operation]: `&lt;database&gt;/operations/&lt;operation_id&gt;`.
   *
   * `operation_id` should be unique within the database, and must be
   * a valid identifier: `[a-z][a-z0-9_]*`. Note that
   * automatically-generated operation IDs always begin with an
   * underscore. If the named operation already exists,
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] returns
   * `ALREADY_EXISTS`.
   * </pre>
   *
   * <code>string operation_id = 3;</code>
   *
   * @return The bytes for operationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationIdBytes() {
    java.lang.Object ref = operationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROTO_DESCRIPTORS_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements.
   * Contains a protobuf-serialized
   * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
   * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
   * run `protoc` with --include_imports and --descriptor_set_out. For example,
   * to generate for moon/shot/app.proto, run
   * ```
   * $protoc  --proto_path=/app_path --proto_path=/lib_path &#92;
   *          --include_imports &#92;
   *          --descriptor_set_out=descriptors.data &#92;
   *          moon/shot/app.proto
   * ```
   * For more details, see protobuffer [self
   * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
   * </pre>
   *
   * <code>bytes proto_descriptors = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The protoDescriptors.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtoDescriptors() {
    return protoDescriptors_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, database_);
    }
    for (int i = 0; i < statements_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, statements_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, operationId_);
    }
    if (!protoDescriptors_.isEmpty()) {
      output.writeBytes(4, protoDescriptors_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, database_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < statements_.size(); i++) {
        dataSize += computeStringSizeNoTag(statements_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getStatementsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, operationId_);
    }
    if (!protoDescriptors_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, protoDescriptors_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest other =
        (com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getStatementsList().equals(other.getStatementsList())) return false;
    if (!getOperationId().equals(other.getOperationId())) return false;
    if (!getProtoDescriptors().equals(other.getProtoDescriptors())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (getStatementsCount() > 0) {
      hash = (37 * hash) + STATEMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getStatementsList().hashCode();
    }
    hash = (37 * hash) + OPERATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getOperationId().hashCode();
    hash = (37 * hash) + PROTO_DESCRIPTORS_FIELD_NUMBER;
    hash = (53 * hash) + getProtoDescriptors().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Enqueues the given DDL statements to be applied, in order but not
   * necessarily all at once, to the database schema at some point (or
   * points) in the future. The server checks that the statements
   * are executable (syntactically valid, name tables that exist, etc.)
   * before enqueueing them, but they may still fail upon
   * later execution (e.g., if a statement from another batch of
   * statements is applied first and it conflicts in some way, or if
   * there is some data-related problem like a `NULL` value in a column to
   * which `NOT NULL` would be added). If a statement fails, all
   * subsequent statements in the batch are automatically cancelled.
   *
   * Each batch of statements is assigned a name which can be used with
   * the [Operations][google.longrunning.Operations] API to monitor
   * progress. See the
   * [operation_id][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.operation_id] field for more
   * details.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.UpdateDatabaseDdlRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.UpdateDatabaseDdlRequest)
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.class,
              com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      database_ = "";
      statements_ = com.google.protobuf.LazyStringArrayList.emptyList();
      operationId_ = "";
      protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest
        getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest build() {
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest buildPartial() {
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest result =
          new com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.database_ = database_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        statements_.makeImmutable();
        result.statements_ = statements_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.operationId_ = operationId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.protoDescriptors_ = protoDescriptors_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest) {
        return mergeFrom((com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest other) {
      if (other
          == com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.getDefaultInstance())
        return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.statements_.isEmpty()) {
        if (statements_.isEmpty()) {
          statements_ = other.statements_;
          bitField0_ |= 0x00000002;
        } else {
          ensureStatementsIsMutable();
          statements_.addAll(other.statements_);
        }
        onChanged();
      }
      if (!other.getOperationId().isEmpty()) {
        operationId_ = other.operationId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getProtoDescriptors() != com.google.protobuf.ByteString.EMPTY) {
        setProtoDescriptors(other.getProtoDescriptors());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStatementsIsMutable();
                statements_.add(s);
                break;
              } // case 18
            case 26:
              {
                operationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                protoDescriptors_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * Required. The database to update.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The database to update.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The database to update.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database to update.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database to update.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList statements_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStatementsIsMutable() {
      if (!statements_.isModifiable()) {
        statements_ = new com.google.protobuf.LazyStringArrayList(statements_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Required. DDL statements to be applied to the database.
     * </pre>
     *
     * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the statements.
     */
    public com.google.protobuf.ProtocolStringList getStatementsList() {
      statements_.makeImmutable();
      return statements_;
    }
    /**
     *
     *
     * <pre>
     * Required. DDL statements to be applied to the database.
     * </pre>
     *
     * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of statements.
     */
    public int getStatementsCount() {
      return statements_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. DDL statements to be applied to the database.
     * </pre>
     *
     * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The statements at the given index.
     */
    public java.lang.String getStatements(int index) {
      return statements_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. DDL statements to be applied to the database.
     * </pre>
     *
     * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the statements at the given index.
     */
    public com.google.protobuf.ByteString getStatementsBytes(int index) {
      return statements_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. DDL statements to be applied to the database.
     * </pre>
     *
     * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The statements to set.
     * @return This builder for chaining.
     */
    public Builder setStatements(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStatementsIsMutable();
      statements_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. DDL statements to be applied to the database.
     * </pre>
     *
     * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The statements to add.
     * @return This builder for chaining.
     */
    public Builder addStatements(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStatementsIsMutable();
      statements_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. DDL statements to be applied to the database.
     * </pre>
     *
     * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The statements to add.
     * @return This builder for chaining.
     */
    public Builder addAllStatements(java.lang.Iterable<java.lang.String> values) {
      ensureStatementsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statements_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. DDL statements to be applied to the database.
     * </pre>
     *
     * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatements() {
      statements_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. DDL statements to be applied to the database.
     * </pre>
     *
     * <code>repeated string statements = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the statements to add.
     * @return This builder for chaining.
     */
    public Builder addStatementsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStatementsIsMutable();
      statements_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object operationId_ = "";
    /**
     *
     *
     * <pre>
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     *
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] call is replayed,
     * or the return value is otherwise lost: the [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database] and
     * `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]: `&lt;database&gt;/operations/&lt;operation_id&gt;`.
     *
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] returns
     * `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>string operation_id = 3;</code>
     *
     * @return The operationId.
     */
    public java.lang.String getOperationId() {
      java.lang.Object ref = operationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     *
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] call is replayed,
     * or the return value is otherwise lost: the [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database] and
     * `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]: `&lt;database&gt;/operations/&lt;operation_id&gt;`.
     *
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] returns
     * `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>string operation_id = 3;</code>
     *
     * @return The bytes for operationId.
     */
    public com.google.protobuf.ByteString getOperationIdBytes() {
      java.lang.Object ref = operationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     *
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] call is replayed,
     * or the return value is otherwise lost: the [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database] and
     * `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]: `&lt;database&gt;/operations/&lt;operation_id&gt;`.
     *
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] returns
     * `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>string operation_id = 3;</code>
     *
     * @param value The operationId to set.
     * @return This builder for chaining.
     */
    public Builder setOperationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     *
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] call is replayed,
     * or the return value is otherwise lost: the [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database] and
     * `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]: `&lt;database&gt;/operations/&lt;operation_id&gt;`.
     *
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] returns
     * `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>string operation_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationId() {
      operationId_ = getDefaultInstance().getOperationId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If empty, the new update request is assigned an
     * automatically-generated operation ID. Otherwise, `operation_id`
     * is used to construct the name of the resulting
     * [Operation][google.longrunning.Operation].
     *
     * Specifying an explicit operation ID simplifies determining
     * whether the statements were executed in the event that the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] call is replayed,
     * or the return value is otherwise lost: the [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database] and
     * `operation_id` fields can be combined to form the
     * [name][google.longrunning.Operation.name] of the resulting
     * [longrunning.Operation][google.longrunning.Operation]: `&lt;database&gt;/operations/&lt;operation_id&gt;`.
     *
     * `operation_id` should be unique within the database, and must be
     * a valid identifier: `[a-z][a-z0-9_]*`. Note that
     * automatically-generated operation IDs always begin with an
     * underscore. If the named operation already exists,
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] returns
     * `ALREADY_EXISTS`.
     * </pre>
     *
     * <code>string operation_id = 3;</code>
     *
     * @param value The bytes for operationId to set.
     * @return This builder for chaining.
     */
    public Builder setOperationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements.
     * Contains a protobuf-serialized
     * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     * run `protoc` with --include_imports and --descriptor_set_out. For example,
     * to generate for moon/shot/app.proto, run
     * ```
     * $protoc  --proto_path=/app_path --proto_path=/lib_path &#92;
     *          --include_imports &#92;
     *          --descriptor_set_out=descriptors.data &#92;
     *          moon/shot/app.proto
     * ```
     * For more details, see protobuffer [self
     * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     * </pre>
     *
     * <code>bytes proto_descriptors = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The protoDescriptors.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProtoDescriptors() {
      return protoDescriptors_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements.
     * Contains a protobuf-serialized
     * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     * run `protoc` with --include_imports and --descriptor_set_out. For example,
     * to generate for moon/shot/app.proto, run
     * ```
     * $protoc  --proto_path=/app_path --proto_path=/lib_path &#92;
     *          --include_imports &#92;
     *          --descriptor_set_out=descriptors.data &#92;
     *          moon/shot/app.proto
     * ```
     * For more details, see protobuffer [self
     * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     * </pre>
     *
     * <code>bytes proto_descriptors = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The protoDescriptors to set.
     * @return This builder for chaining.
     */
    public Builder setProtoDescriptors(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protoDescriptors_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Proto descriptors used by CREATE/ALTER PROTO BUNDLE statements.
     * Contains a protobuf-serialized
     * [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto).
     * To generate it, [install](https://grpc.io/docs/protoc-installation/) and
     * run `protoc` with --include_imports and --descriptor_set_out. For example,
     * to generate for moon/shot/app.proto, run
     * ```
     * $protoc  --proto_path=/app_path --proto_path=/lib_path &#92;
     *          --include_imports &#92;
     *          --descriptor_set_out=descriptors.data &#92;
     *          moon/shot/app.proto
     * ```
     * For more details, see protobuffer [self
     * description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
     * </pre>
     *
     * <code>bytes proto_descriptors = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtoDescriptors() {
      bitField0_ = (bitField0_ & ~0x00000008);
      protoDescriptors_ = getDefaultInstance().getProtoDescriptors();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.UpdateDatabaseDdlRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.UpdateDatabaseDdlRequest)
  private static final com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest();
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateDatabaseDdlRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateDatabaseDdlRequest>() {
        @java.lang.Override
        public UpdateDatabaseDdlRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateDatabaseDdlRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateDatabaseDdlRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
