/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.admin.instance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InstanceConfigName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instanceConfigs/{instance_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instanceConfig;

    public String getProject() {
        return this.project;
    }

    public String getInstanceConfig() {
        return this.instanceConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private InstanceConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instanceConfig = (String)Preconditions.checkNotNull((Object)builder.getInstanceConfig());
    }

    public static InstanceConfigName of(String project, String instanceConfig) {
        return InstanceConfigName.newBuilder().setProject(project).setInstanceConfig(instanceConfig).build();
    }

    public static String format(String project, String instanceConfig) {
        return InstanceConfigName.newBuilder().setProject(project).setInstanceConfig(instanceConfig).build().toString();
    }

    public static InstanceConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "InstanceConfigName.parse: formattedString not in valid format");
        return InstanceConfigName.of((String)matchMap.get("project"), (String)matchMap.get("instance_config"));
    }

    public static List<InstanceConfigName> parseList(List<String> formattedStrings) {
        ArrayList<InstanceConfigName> list = new ArrayList<InstanceConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstanceConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstanceConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstanceConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstanceConfigName instanceConfigName = this;
            synchronized (instanceConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"instanceConfig", (Object)this.instanceConfig);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("InstanceConfigName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance_config", this.instanceConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceConfigName) {
            InstanceConfigName that = (InstanceConfigName)o;
            return this.project.equals(that.project) && this.instanceConfig.equals(that.instanceConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.instanceConfig.hashCode();
    }

    public static class Builder {
        private String project;
        private String instanceConfig;

        public String getProject() {
            return this.project;
        }

        public String getInstanceConfig() {
            return this.instanceConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstanceConfig(String instanceConfig) {
            this.instanceConfig = instanceConfig;
            return this;
        }

        private Builder() {
        }

        private Builder(InstanceConfigName instanceConfigName) {
            this.project = instanceConfigName.project;
            this.instanceConfig = instanceConfigName.instanceConfig;
        }

        public InstanceConfigName build() {
            return new InstanceConfigName(this);
        }
    }
}

