/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

package com.google.spanner.admin.instance.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [CreateInstanceConfigRequest][InstanceAdmin.CreateInstanceConfigRequest].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.instance.v1.CreateInstanceConfigRequest}
 */
public final class CreateInstanceConfigRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.CreateInstanceConfigRequest)
    CreateInstanceConfigRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateInstanceConfigRequest.newBuilder() to construct.
  private CreateInstanceConfigRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateInstanceConfigRequest() {
    parent_ = "";
    instanceConfigId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateInstanceConfigRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CreateInstanceConfigRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              instanceConfigId_ = s;
              break;
            }
          case 26:
            {
              com.google.spanner.admin.instance.v1.InstanceConfig.Builder subBuilder = null;
              if (instanceConfig_ != null) {
                subBuilder = instanceConfig_.toBuilder();
              }
              instanceConfig_ =
                  input.readMessage(
                      com.google.spanner.admin.instance.v1.InstanceConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(instanceConfig_);
                instanceConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 32:
            {
              validateOnly_ = input.readBool();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.class,
            com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The name of the project in which to create the instance config.
   * Values are of the form `projects/&lt;project&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the project in which to create the instance config.
   * Values are of the form `projects/&lt;project&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_CONFIG_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object instanceConfigId_;
  /**
   *
   *
   * <pre>
   * Required. The ID of the instance config to create.  Valid identifiers are
   * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
   * characters in length. The `custom-` prefix is required to avoid name
   * conflicts with Google managed configurations.
   * </pre>
   *
   * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The instanceConfigId.
   */
  @java.lang.Override
  public java.lang.String getInstanceConfigId() {
    java.lang.Object ref = instanceConfigId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceConfigId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the instance config to create.  Valid identifiers are
   * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
   * characters in length. The `custom-` prefix is required to avoid name
   * conflicts with Google managed configurations.
   * </pre>
   *
   * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for instanceConfigId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceConfigIdBytes() {
    java.lang.Object ref = instanceConfigId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceConfigId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_CONFIG_FIELD_NUMBER = 3;
  private com.google.spanner.admin.instance.v1.InstanceConfig instanceConfig_;
  /**
   *
   *
   * <pre>
   * Required. The InstanceConfig proto of the configuration to create.
   * instance_config.name must be
   * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
   * instance_config.base_config must be a Google managed configuration name,
   * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the instanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasInstanceConfig() {
    return instanceConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The InstanceConfig proto of the configuration to create.
   * instance_config.name must be
   * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
   * instance_config.base_config must be a Google managed configuration name,
   * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The instanceConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.InstanceConfig getInstanceConfig() {
    return instanceConfig_ == null
        ? com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance()
        : instanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The InstanceConfig proto of the configuration to create.
   * instance_config.name must be
   * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
   * instance_config.base_config must be a Google managed configuration name,
   * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder getInstanceConfigOrBuilder() {
    return getInstanceConfig();
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 4;
  private boolean validateOnly_;
  /**
   *
   *
   * <pre>
   * An option to validate, but not actually execute, a request,
   * and provide the same response.
   * </pre>
   *
   * <code>bool validate_only = 4;</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceConfigId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instanceConfigId_);
    }
    if (instanceConfig_ != null) {
      output.writeMessage(3, getInstanceConfig());
    }
    if (validateOnly_ != false) {
      output.writeBool(4, validateOnly_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceConfigId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, instanceConfigId_);
    }
    if (instanceConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInstanceConfig());
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, validateOnly_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest other =
        (com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getInstanceConfigId().equals(other.getInstanceConfigId())) return false;
    if (hasInstanceConfig() != other.hasInstanceConfig()) return false;
    if (hasInstanceConfig()) {
      if (!getInstanceConfig().equals(other.getInstanceConfig())) return false;
    }
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + INSTANCE_CONFIG_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceConfigId().hashCode();
    if (hasInstanceConfig()) {
      hash = (37 * hash) + INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceConfig().hashCode();
    }
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [CreateInstanceConfigRequest][InstanceAdmin.CreateInstanceConfigRequest].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.CreateInstanceConfigRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.CreateInstanceConfigRequest)
      com.google.spanner.admin.instance.v1.CreateInstanceConfigRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.class,
              com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.Builder.class);
    }

    // Construct using com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      instanceConfigId_ = "";

      if (instanceConfigBuilder_ == null) {
        instanceConfig_ = null;
      } else {
        instanceConfig_ = null;
        instanceConfigBuilder_ = null;
      }
      validateOnly_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest
        getDefaultInstanceForType() {
      return com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest build() {
      com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest buildPartial() {
      com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest result =
          new com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest(this);
      result.parent_ = parent_;
      result.instanceConfigId_ = instanceConfigId_;
      if (instanceConfigBuilder_ == null) {
        result.instanceConfig_ = instanceConfig_;
      } else {
        result.instanceConfig_ = instanceConfigBuilder_.build();
      }
      result.validateOnly_ = validateOnly_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest) {
        return mergeFrom((com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest other) {
      if (other
          == com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getInstanceConfigId().isEmpty()) {
        instanceConfigId_ = other.instanceConfigId_;
        onChanged();
      }
      if (other.hasInstanceConfig()) {
        mergeInstanceConfig(other.getInstanceConfig());
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object instanceConfigId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The instanceConfigId.
     */
    public java.lang.String getInstanceConfigId() {
      java.lang.Object ref = instanceConfigId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceConfigId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for instanceConfigId.
     */
    public com.google.protobuf.ByteString getInstanceConfigIdBytes() {
      java.lang.Object ref = instanceConfigId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceConfigId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The instanceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceConfigId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      instanceConfigId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceConfigId() {

      instanceConfigId_ = getDefaultInstance().getInstanceConfigId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for instanceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceConfigIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      instanceConfigId_ = value;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.instance.v1.InstanceConfig instanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.InstanceConfig,
            com.google.spanner.admin.instance.v1.InstanceConfig.Builder,
            com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder>
        instanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the instanceConfig field is set.
     */
    public boolean hasInstanceConfig() {
      return instanceConfigBuilder_ != null || instanceConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceConfig.
     */
    public com.google.spanner.admin.instance.v1.InstanceConfig getInstanceConfig() {
      if (instanceConfigBuilder_ == null) {
        return instanceConfig_ == null
            ? com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance()
            : instanceConfig_;
      } else {
        return instanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstanceConfig(com.google.spanner.admin.instance.v1.InstanceConfig value) {
      if (instanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceConfig_ = value;
        onChanged();
      } else {
        instanceConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstanceConfig(
        com.google.spanner.admin.instance.v1.InstanceConfig.Builder builderForValue) {
      if (instanceConfigBuilder_ == null) {
        instanceConfig_ = builderForValue.build();
        onChanged();
      } else {
        instanceConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInstanceConfig(com.google.spanner.admin.instance.v1.InstanceConfig value) {
      if (instanceConfigBuilder_ == null) {
        if (instanceConfig_ != null) {
          instanceConfig_ =
              com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder(instanceConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          instanceConfig_ = value;
        }
        onChanged();
      } else {
        instanceConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInstanceConfig() {
      if (instanceConfigBuilder_ == null) {
        instanceConfig_ = null;
        onChanged();
      } else {
        instanceConfig_ = null;
        instanceConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.InstanceConfig.Builder getInstanceConfigBuilder() {

      onChanged();
      return getInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder
        getInstanceConfigOrBuilder() {
      if (instanceConfigBuilder_ != null) {
        return instanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return instanceConfig_ == null
            ? com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance()
            : instanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.InstanceConfig,
            com.google.spanner.admin.instance.v1.InstanceConfig.Builder,
            com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder>
        getInstanceConfigFieldBuilder() {
      if (instanceConfigBuilder_ == null) {
        instanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.instance.v1.InstanceConfig,
                com.google.spanner.admin.instance.v1.InstanceConfig.Builder,
                com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder>(
                getInstanceConfig(), getParentForChildren(), isClean());
        instanceConfig_ = null;
      }
      return instanceConfigBuilder_;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * An option to validate, but not actually execute, a request,
     * and provide the same response.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * An option to validate, but not actually execute, a request,
     * and provide the same response.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An option to validate, but not actually execute, a request,
     * and provide the same response.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {

      validateOnly_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.CreateInstanceConfigRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.CreateInstanceConfigRequest)
  private static final com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest();
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateInstanceConfigRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateInstanceConfigRequest>() {
        @java.lang.Override
        public CreateInstanceConfigRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CreateInstanceConfigRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CreateInstanceConfigRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateInstanceConfigRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
