/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

package com.google.spanner.admin.instance.v1;

/**
 *
 *
 * <pre>
 * A possible configuration for a Cloud Spanner instance. Configurations
 * define the geographic placement of nodes and their replication.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.instance.v1.InstanceConfig}
 */
public final class InstanceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.InstanceConfig)
    InstanceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InstanceConfig.newBuilder() to construct.
  private InstanceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceConfig() {
    name_ = "";
    displayName_ = "";
    replicas_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_InstanceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_InstanceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.instance.v1.InstanceConfig.class,
            com.google.spanner.admin.instance.v1.InstanceConfig.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A unique identifier for the instance configuration.  Values
   * are of the form
   * `projects/&lt;project&gt;/instanceConfigs/[a-z][-a-z0-9]*`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for the instance configuration.  Values
   * are of the form
   * `projects/&lt;project&gt;/instanceConfigs/[a-z][-a-z0-9]*`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The name of this instance configuration as it appears in UIs.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of this instance configuration as it appears in UIs.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPLICAS_FIELD_NUMBER = 3;
  private java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo> replicas_;
  /**
   *
   *
   * <pre>
   * The geographic placement of nodes in this instance configuration and their
   * replication properties.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo> getReplicasList() {
    return replicas_;
  }
  /**
   *
   *
   * <pre>
   * The geographic placement of nodes in this instance configuration and their
   * replication properties.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>
      getReplicasOrBuilderList() {
    return replicas_;
  }
  /**
   *
   *
   * <pre>
   * The geographic placement of nodes in this instance configuration and their
   * replication properties.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
   */
  @java.lang.Override
  public int getReplicasCount() {
    return replicas_.size();
  }
  /**
   *
   *
   * <pre>
   * The geographic placement of nodes in this instance configuration and their
   * replication properties.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.ReplicaInfo getReplicas(int index) {
    return replicas_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The geographic placement of nodes in this instance configuration and their
   * replication properties.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder getReplicasOrBuilder(int index) {
    return replicas_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    for (int i = 0; i < replicas_.size(); i++) {
      output.writeMessage(3, replicas_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (int i = 0; i < replicas_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, replicas_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.instance.v1.InstanceConfig)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.instance.v1.InstanceConfig other =
        (com.google.spanner.admin.instance.v1.InstanceConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getReplicasList().equals(other.getReplicasList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getReplicasCount() > 0) {
      hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
      hash = (53 * hash) + getReplicasList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.admin.instance.v1.InstanceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A possible configuration for a Cloud Spanner instance. Configurations
   * define the geographic placement of nodes and their replication.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.InstanceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.InstanceConfig)
      com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_InstanceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_InstanceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.InstanceConfig.class,
              com.google.spanner.admin.instance.v1.InstanceConfig.Builder.class);
    }

    // Construct using com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (replicasBuilder_ == null) {
        replicas_ = java.util.Collections.emptyList();
      } else {
        replicas_ = null;
        replicasBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_InstanceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.InstanceConfig getDefaultInstanceForType() {
      return com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.InstanceConfig build() {
      com.google.spanner.admin.instance.v1.InstanceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.InstanceConfig buildPartial() {
      com.google.spanner.admin.instance.v1.InstanceConfig result =
          new com.google.spanner.admin.instance.v1.InstanceConfig(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (replicasBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          replicas_ = java.util.Collections.unmodifiableList(replicas_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.replicas_ = replicas_;
      } else {
        result.replicas_ = replicasBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.instance.v1.InstanceConfig) {
        return mergeFrom((com.google.spanner.admin.instance.v1.InstanceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.instance.v1.InstanceConfig other) {
      if (other == com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (replicasBuilder_ == null) {
        if (!other.replicas_.isEmpty()) {
          if (replicas_.isEmpty()) {
            replicas_ = other.replicas_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureReplicasIsMutable();
            replicas_.addAll(other.replicas_);
          }
          onChanged();
        }
      } else {
        if (!other.replicas_.isEmpty()) {
          if (replicasBuilder_.isEmpty()) {
            replicasBuilder_.dispose();
            replicasBuilder_ = null;
            replicas_ = other.replicas_;
            bitField0_ = (bitField0_ & ~0x00000001);
            replicasBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReplicasFieldBuilder()
                    : null;
          } else {
            replicasBuilder_.addAllMessages(other.replicas_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.spanner.admin.instance.v1.ReplicaInfo m =
                    input.readMessage(
                        com.google.spanner.admin.instance.v1.ReplicaInfo.parser(),
                        extensionRegistry);
                if (replicasBuilder_ == null) {
                  ensureReplicasIsMutable();
                  replicas_.add(m);
                } else {
                  replicasBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A unique identifier for the instance configuration.  Values
     * are of the form
     * `projects/&lt;project&gt;/instanceConfigs/[a-z][-a-z0-9]*`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for the instance configuration.  Values
     * are of the form
     * `projects/&lt;project&gt;/instanceConfigs/[a-z][-a-z0-9]*`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for the instance configuration.  Values
     * are of the form
     * `projects/&lt;project&gt;/instanceConfigs/[a-z][-a-z0-9]*`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for the instance configuration.  Values
     * are of the form
     * `projects/&lt;project&gt;/instanceConfigs/[a-z][-a-z0-9]*`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for the instance configuration.  Values
     * are of the form
     * `projects/&lt;project&gt;/instanceConfigs/[a-z][-a-z0-9]*`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The name of this instance configuration as it appears in UIs.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of this instance configuration as it appears in UIs.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of this instance configuration as it appears in UIs.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of this instance configuration as it appears in UIs.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of this instance configuration as it appears in UIs.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo> replicas_ =
        java.util.Collections.emptyList();

    private void ensureReplicasIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        replicas_ =
            new java.util.ArrayList<com.google.spanner.admin.instance.v1.ReplicaInfo>(replicas_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.instance.v1.ReplicaInfo,
            com.google.spanner.admin.instance.v1.ReplicaInfo.Builder,
            com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>
        replicasBuilder_;

    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo> getReplicasList() {
      if (replicasBuilder_ == null) {
        return java.util.Collections.unmodifiableList(replicas_);
      } else {
        return replicasBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public int getReplicasCount() {
      if (replicasBuilder_ == null) {
        return replicas_.size();
      } else {
        return replicasBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfo getReplicas(int index) {
      if (replicasBuilder_ == null) {
        return replicas_.get(index);
      } else {
        return replicasBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public Builder setReplicas(int index, com.google.spanner.admin.instance.v1.ReplicaInfo value) {
      if (replicasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReplicasIsMutable();
        replicas_.set(index, value);
        onChanged();
      } else {
        replicasBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public Builder setReplicas(
        int index, com.google.spanner.admin.instance.v1.ReplicaInfo.Builder builderForValue) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        replicas_.set(index, builderForValue.build());
        onChanged();
      } else {
        replicasBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public Builder addReplicas(com.google.spanner.admin.instance.v1.ReplicaInfo value) {
      if (replicasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReplicasIsMutable();
        replicas_.add(value);
        onChanged();
      } else {
        replicasBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public Builder addReplicas(int index, com.google.spanner.admin.instance.v1.ReplicaInfo value) {
      if (replicasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReplicasIsMutable();
        replicas_.add(index, value);
        onChanged();
      } else {
        replicasBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public Builder addReplicas(
        com.google.spanner.admin.instance.v1.ReplicaInfo.Builder builderForValue) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        replicas_.add(builderForValue.build());
        onChanged();
      } else {
        replicasBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public Builder addReplicas(
        int index, com.google.spanner.admin.instance.v1.ReplicaInfo.Builder builderForValue) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        replicas_.add(index, builderForValue.build());
        onChanged();
      } else {
        replicasBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public Builder addAllReplicas(
        java.lang.Iterable<? extends com.google.spanner.admin.instance.v1.ReplicaInfo> values) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, replicas_);
        onChanged();
      } else {
        replicasBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public Builder clearReplicas() {
      if (replicasBuilder_ == null) {
        replicas_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        replicasBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public Builder removeReplicas(int index) {
      if (replicasBuilder_ == null) {
        ensureReplicasIsMutable();
        replicas_.remove(index);
        onChanged();
      } else {
        replicasBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfo.Builder getReplicasBuilder(int index) {
      return getReplicasFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder getReplicasOrBuilder(
        int index) {
      if (replicasBuilder_ == null) {
        return replicas_.get(index);
      } else {
        return replicasBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public java.util.List<? extends com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>
        getReplicasOrBuilderList() {
      if (replicasBuilder_ != null) {
        return replicasBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(replicas_);
      }
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfo.Builder addReplicasBuilder() {
      return getReplicasFieldBuilder()
          .addBuilder(com.google.spanner.admin.instance.v1.ReplicaInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public com.google.spanner.admin.instance.v1.ReplicaInfo.Builder addReplicasBuilder(int index) {
      return getReplicasFieldBuilder()
          .addBuilder(index, com.google.spanner.admin.instance.v1.ReplicaInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The geographic placement of nodes in this instance configuration and their
     * replication properties.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.instance.v1.ReplicaInfo replicas = 3;</code>
     */
    public java.util.List<com.google.spanner.admin.instance.v1.ReplicaInfo.Builder>
        getReplicasBuilderList() {
      return getReplicasFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.instance.v1.ReplicaInfo,
            com.google.spanner.admin.instance.v1.ReplicaInfo.Builder,
            com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>
        getReplicasFieldBuilder() {
      if (replicasBuilder_ == null) {
        replicasBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.instance.v1.ReplicaInfo,
                com.google.spanner.admin.instance.v1.ReplicaInfo.Builder,
                com.google.spanner.admin.instance.v1.ReplicaInfoOrBuilder>(
                replicas_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        replicas_ = null;
      }
      return replicasBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.InstanceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.InstanceConfig)
  private static final com.google.spanner.admin.instance.v1.InstanceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.instance.v1.InstanceConfig();
  }

  public static com.google.spanner.admin.instance.v1.InstanceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceConfig> PARSER =
      new com.google.protobuf.AbstractParser<InstanceConfig>() {
        @java.lang.Override
        public InstanceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstanceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.instance.v1.InstanceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
