/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

package com.google.spanner.admin.instance.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [CreateInstanceConfigRequest][InstanceAdmin.CreateInstanceConfigRequest].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.instance.v1.CreateInstanceConfigRequest}
 */
public final class CreateInstanceConfigRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.CreateInstanceConfigRequest)
    CreateInstanceConfigRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateInstanceConfigRequest.newBuilder() to construct.
  private CreateInstanceConfigRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateInstanceConfigRequest() {
    parent_ = "";
    instanceConfigId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateInstanceConfigRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.class,
            com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the project in which to create the instance config.
   * Values are of the form `projects/&lt;project&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the project in which to create the instance config.
   * Values are of the form `projects/&lt;project&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_CONFIG_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceConfigId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID of the instance config to create.  Valid identifiers are
   * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
   * characters in length. The `custom-` prefix is required to avoid name
   * conflicts with Google managed configurations.
   * </pre>
   *
   * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The instanceConfigId.
   */
  @java.lang.Override
  public java.lang.String getInstanceConfigId() {
    java.lang.Object ref = instanceConfigId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceConfigId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the instance config to create.  Valid identifiers are
   * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
   * characters in length. The `custom-` prefix is required to avoid name
   * conflicts with Google managed configurations.
   * </pre>
   *
   * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for instanceConfigId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceConfigIdBytes() {
    java.lang.Object ref = instanceConfigId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceConfigId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_CONFIG_FIELD_NUMBER = 3;
  private com.google.spanner.admin.instance.v1.InstanceConfig instanceConfig_;
  /**
   *
   *
   * <pre>
   * Required. The InstanceConfig proto of the configuration to create.
   * instance_config.name must be
   * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
   * instance_config.base_config must be a Google managed configuration name,
   * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the instanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasInstanceConfig() {
    return instanceConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The InstanceConfig proto of the configuration to create.
   * instance_config.name must be
   * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
   * instance_config.base_config must be a Google managed configuration name,
   * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The instanceConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.InstanceConfig getInstanceConfig() {
    return instanceConfig_ == null
        ? com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance()
        : instanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The InstanceConfig proto of the configuration to create.
   * instance_config.name must be
   * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
   * instance_config.base_config must be a Google managed configuration name,
   * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder getInstanceConfigOrBuilder() {
    return instanceConfig_ == null
        ? com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance()
        : instanceConfig_;
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 4;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * An option to validate, but not actually execute, a request,
   * and provide the same response.
   * </pre>
   *
   * <code>bool validate_only = 4;</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceConfigId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instanceConfigId_);
    }
    if (instanceConfig_ != null) {
      output.writeMessage(3, getInstanceConfig());
    }
    if (validateOnly_ != false) {
      output.writeBool(4, validateOnly_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceConfigId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, instanceConfigId_);
    }
    if (instanceConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInstanceConfig());
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, validateOnly_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest other =
        (com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getInstanceConfigId().equals(other.getInstanceConfigId())) return false;
    if (hasInstanceConfig() != other.hasInstanceConfig()) return false;
    if (hasInstanceConfig()) {
      if (!getInstanceConfig().equals(other.getInstanceConfig())) return false;
    }
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + INSTANCE_CONFIG_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceConfigId().hashCode();
    if (hasInstanceConfig()) {
      hash = (37 * hash) + INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceConfig().hashCode();
    }
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [CreateInstanceConfigRequest][InstanceAdmin.CreateInstanceConfigRequest].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.CreateInstanceConfigRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.CreateInstanceConfigRequest)
      com.google.spanner.admin.instance.v1.CreateInstanceConfigRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.class,
              com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.Builder.class);
    }

    // Construct using com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      instanceConfigId_ = "";
      instanceConfig_ = null;
      if (instanceConfigBuilder_ != null) {
        instanceConfigBuilder_.dispose();
        instanceConfigBuilder_ = null;
      }
      validateOnly_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_CreateInstanceConfigRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest
        getDefaultInstanceForType() {
      return com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest build() {
      com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest buildPartial() {
      com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest result =
          new com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instanceConfigId_ = instanceConfigId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.instanceConfig_ =
            instanceConfigBuilder_ == null ? instanceConfig_ : instanceConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest) {
        return mergeFrom((com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest other) {
      if (other
          == com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getInstanceConfigId().isEmpty()) {
        instanceConfigId_ = other.instanceConfigId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasInstanceConfig()) {
        mergeInstanceConfig(other.getInstanceConfig());
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                instanceConfigId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to create the instance config.
     * Values are of the form `projects/&lt;project&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object instanceConfigId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The instanceConfigId.
     */
    public java.lang.String getInstanceConfigId() {
      java.lang.Object ref = instanceConfigId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceConfigId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for instanceConfigId.
     */
    public com.google.protobuf.ByteString getInstanceConfigIdBytes() {
      java.lang.Object ref = instanceConfigId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceConfigId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The instanceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceConfigId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceConfigId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceConfigId() {
      instanceConfigId_ = getDefaultInstance().getInstanceConfigId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the instance config to create.  Valid identifiers are
     * of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
     * characters in length. The `custom-` prefix is required to avoid name
     * conflicts with Google managed configurations.
     * </pre>
     *
     * <code>string instance_config_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for instanceConfigId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceConfigIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceConfigId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.instance.v1.InstanceConfig instanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.InstanceConfig,
            com.google.spanner.admin.instance.v1.InstanceConfig.Builder,
            com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder>
        instanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the instanceConfig field is set.
     */
    public boolean hasInstanceConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceConfig.
     */
    public com.google.spanner.admin.instance.v1.InstanceConfig getInstanceConfig() {
      if (instanceConfigBuilder_ == null) {
        return instanceConfig_ == null
            ? com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance()
            : instanceConfig_;
      } else {
        return instanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstanceConfig(com.google.spanner.admin.instance.v1.InstanceConfig value) {
      if (instanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceConfig_ = value;
      } else {
        instanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstanceConfig(
        com.google.spanner.admin.instance.v1.InstanceConfig.Builder builderForValue) {
      if (instanceConfigBuilder_ == null) {
        instanceConfig_ = builderForValue.build();
      } else {
        instanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInstanceConfig(com.google.spanner.admin.instance.v1.InstanceConfig value) {
      if (instanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && instanceConfig_ != null
            && instanceConfig_
                != com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance()) {
          getInstanceConfigBuilder().mergeFrom(value);
        } else {
          instanceConfig_ = value;
        }
      } else {
        instanceConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      instanceConfig_ = null;
      if (instanceConfigBuilder_ != null) {
        instanceConfigBuilder_.dispose();
        instanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.InstanceConfig.Builder getInstanceConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder
        getInstanceConfigOrBuilder() {
      if (instanceConfigBuilder_ != null) {
        return instanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return instanceConfig_ == null
            ? com.google.spanner.admin.instance.v1.InstanceConfig.getDefaultInstance()
            : instanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The InstanceConfig proto of the configuration to create.
     * instance_config.name must be
     * `&lt;parent&gt;/instanceConfigs/&lt;instance_config_id&gt;`.
     * instance_config.base_config must be a Google managed configuration name,
     * e.g. &lt;parent&gt;/instanceConfigs/us-east1, &lt;parent&gt;/instanceConfigs/nam3.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.InstanceConfig instance_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.InstanceConfig,
            com.google.spanner.admin.instance.v1.InstanceConfig.Builder,
            com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder>
        getInstanceConfigFieldBuilder() {
      if (instanceConfigBuilder_ == null) {
        instanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.instance.v1.InstanceConfig,
                com.google.spanner.admin.instance.v1.InstanceConfig.Builder,
                com.google.spanner.admin.instance.v1.InstanceConfigOrBuilder>(
                getInstanceConfig(), getParentForChildren(), isClean());
        instanceConfig_ = null;
      }
      return instanceConfigBuilder_;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * An option to validate, but not actually execute, a request,
     * and provide the same response.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * An option to validate, but not actually execute, a request,
     * and provide the same response.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An option to validate, but not actually execute, a request,
     * and provide the same response.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000008);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.CreateInstanceConfigRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.CreateInstanceConfigRequest)
  private static final com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest();
  }

  public static com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateInstanceConfigRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateInstanceConfigRequest>() {
        @java.lang.Override
        public CreateInstanceConfigRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateInstanceConfigRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateInstanceConfigRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
